/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Base64;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.UnnecessaryCatch;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.template.SourceTemplate;

public class UseJavaUtilBase64
extends Recipe {
    private final String sunPackage;

    public String getDisplayName() {
        return "Prefer `java.util.Base64` instead of `sun.misc`";
    }

    public String getDescription() {
        return "Prefer `java.util.Base64` instead of using `sun.misc` in Java 8 or higher. `sun.misc` is not exported by the Java module system and accessing this class will result in a warning in Java 11 and an error in Java 17.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new UsesType(this.sunPackage + ".BASE64Encoder"), new UsesType(this.sunPackage + ".BASE64Decoder")});
    }

    public UseJavaUtilBase64(String sunPackage) {
        this.sunPackage = sunPackage;
    }

    @JsonCreator
    public UseJavaUtilBase64() {
        this("sun.misc");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher base64EncodeMethod = new MethodMatcher(this.sunPackage + ".CharacterEncoder *(byte[])");
        final MethodMatcher base64DecodeBuffer = new MethodMatcher(this.sunPackage + ".CharacterDecoder decodeBuffer(String)");
        final MethodMatcher newBase64Encoder = new MethodMatcher(this.sunPackage + ".BASE64Encoder <constructor>()");
        final MethodMatcher newBase64Decoder = new MethodMatcher(this.sunPackage + ".BASE64Decoder <constructor>()");
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate getDecoderTemplate = JavaTemplate.builder(() -> (this).getCursor(), (String)"Base64.getDecoder()").imports(new String[]{"java.util.Base64"}).build();
            final JavaTemplate encodeToString = JavaTemplate.builder(() -> (this).getCursor(), (String)"Base64.getEncoder().encodeToString(#{anyArray(byte)})").imports(new String[]{"java.util.Base64"}).build();
            final JavaTemplate decode = JavaTemplate.builder(() -> (this).getCursor(), (String)"Base64.getDecoder().decode(#{any(String)})").imports(new String[]{"java.util.Base64"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if (base64EncodeMethod.matches(m) && ("encode".equals(method.getSimpleName()) || "encodeBuffer".equals(method.getSimpleName()))) {
                    m = (J.MethodInvocation)m.withTemplate((SourceTemplate)this.encodeToString, m.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                    if (method.getSelect() instanceof J.Identifier) {
                        m = m.withSelect(method.getSelect());
                    }
                } else if (base64DecodeBuffer.matches(method)) {
                    m = (J.MethodInvocation)m.withTemplate((SourceTemplate)this.decode, m.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                    if (method.getSelect() instanceof J.Identifier) {
                        m = m.withSelect(method.getSelect());
                    }
                    this.doAfterVisit((Recipe)new UnnecessaryCatch());
                }
                return m;
            }

            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                JavaSourceFile c = (JavaSourceFile)super.visitJavaSourceFile(cu, (Object)ctx);
                c = (J.CompilationUnit)new ChangeType(UseJavaUtilBase64.this.sunPackage + ".BASE64Encoder", "java.util.Base64$Encoder", Boolean.valueOf(true)).getVisitor().visitNonNull((Tree)c, (Object)ctx);
                c = (J.CompilationUnit)new ChangeType(UseJavaUtilBase64.this.sunPackage + ".BASE64Decoder", "java.util.Base64$Decoder", Boolean.valueOf(true)).getVisitor().visitNonNull((Tree)c, (Object)ctx);
                return c;
            }

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass c = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                if (newBase64Encoder.matches(c)) {
                    return c.withTemplate((SourceTemplate)JavaTemplate.compile((JavaVisitor)this, (String)"getEncoder", () -> Base64.getEncoder()).build(), c.getCoordinates().replace(), new Object[0]);
                }
                if (newBase64Decoder.matches(c)) {
                    return c.withTemplate((SourceTemplate)this.getDecoderTemplate, c.getCoordinates().replace(), new Object[0]);
                }
                return c;
            }
        };
    }
}

