/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.RemoveManagedDependency;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class UpdateJaxwsRuntimeToJakartaEE8
extends Recipe {
    private static final String LEGACY_JAVA_JAXWS_API_GROUP = "javax.xml.ws";
    private static final String LEGACY_JAVA_JAXWS_API_ARTIFACT = "jaxws-api";
    private static final String JAKARTA_JAXWS_API_GROUP = "jakarta.xml.ws";
    private static final String JAKARTA_JAXWS_API_ARTIFACT = "jakarta.xml.ws-api";
    private static final String SUN_JAXWS_RUNTIME_GROUP = "com.sun.xml.ws";
    private static final String SUN_JAXWS_RUNTIME_ARTIFACT = "jaxws-rt";

    public String getDisplayName() {
        return "Use the latest JAX-WS API and runtime for Jakarta EE 8";
    }

    public String getDescription() {
        return "Update maven build files to use the latest JAX-WS API from Jakarta EE 8 and add a compatible runtime dependency to maintain compatibility with Java version greater than Java 8. This recipe will change existing dependencies on `javax.xml.ws:jaxws-api` to `jakarta.xml.ws:jakarta.xml.ws-api`. The recipe will also add a JAXWS run-time, in `provided` scope, to any project that has a transitive dependency on the JAXWS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("javax", "jakarta", "javaee", "jax-ws", "java11"));
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                this.doAfterVisit((Recipe)new RemoveDependency(UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_GROUP, "jaxws-ri", null));
                this.doAfterVisit((Recipe)new RemoveManagedDependency(UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_GROUP, "jaxws-ri", null));
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(UpdateJaxwsRuntimeToJakartaEE8.LEGACY_JAVA_JAXWS_API_GROUP, UpdateJaxwsRuntimeToJakartaEE8.LEGACY_JAVA_JAXWS_API_ARTIFACT, UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_GROUP, UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_ARTIFACT, "2.3.2", null).getVisitor().visit((Tree)d, (Object)ctx);
                d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(UpdateJaxwsRuntimeToJakartaEE8.LEGACY_JAVA_JAXWS_API_GROUP, UpdateJaxwsRuntimeToJakartaEE8.LEGACY_JAVA_JAXWS_API_ARTIFACT, UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_GROUP, UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_ARTIFACT, "2.3.2").getVisitor().visit((Tree)d, (Object)ctx);
                if (d != document) {
                    return d;
                }
                if ((d = this.maybeAddRuntimeDependency(d, ctx)) != document) {
                    this.doAfterVisit((Recipe)new RemoveRedundantDependencyVersions(UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_GROUP, "*", Boolean.valueOf(true)));
                    this.doAfterVisit((Recipe)new RemoveRedundantDependencyVersions(UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_GROUP, "*", Boolean.valueOf(true)));
                }
                return d;
            }

            private Xml.Document maybeAddRuntimeDependency(Xml.Document d, ExecutionContext ctx) {
                MavenResolutionResult mavenModel = this.getResolutionResult();
                Scope apiScope = UpdateJaxwsRuntimeToJakartaEE8.this.getTransitiveDependencyScope(mavenModel, UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_GROUP, UpdateJaxwsRuntimeToJakartaEE8.JAKARTA_JAXWS_API_ARTIFACT);
                Scope runtimeScope = UpdateJaxwsRuntimeToJakartaEE8.this.getTransitiveDependencyScope(mavenModel, UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_GROUP, UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_ARTIFACT);
                if (!(apiScope == null || runtimeScope != null && apiScope.isInClasspathOf(runtimeScope))) {
                    String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                    d = (Xml.Document)new AddDependencyVisitor(UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_GROUP, UpdateJaxwsRuntimeToJakartaEE8.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.2", null, resolvedScope, null, null, null, null, null).visit((Tree)d, (Object)ctx);
                }
                return d;
            }
        };
    }

    @Nullable
    private Scope getTransitiveDependencyScope(MavenResolutionResult mavenModel, String groupId, String artifactId) {
        Scope maxScope = null;
        block0: for (Map.Entry entry : mavenModel.getDependencies().entrySet()) {
            for (ResolvedDependency dependency : (List)entry.getValue()) {
                if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                if (!Scope.Compile.equals((Object)(maxScope = Scope.maxPrecedence(maxScope, (Scope)((Scope)entry.getKey()))))) continue block0;
                return maxScope;
            }
        }
        return maxScope;
    }

    @NonNull
    public String toString() {
        return "UpdateJaxwsRuntimeToJakartaEE8()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateJaxwsRuntimeToJakartaEE8)) {
            return false;
        }
        UpdateJaxwsRuntimeToJakartaEE8 other = (UpdateJaxwsRuntimeToJakartaEE8)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateJaxwsRuntimeToJakartaEE8;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

