/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateMulticastSocketSetTTLToSetTimeToLive
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.net.MulticastSocket setTTL(byte)");

    public String getDisplayName() {
        return "Use `java.net.MulticastSocket#setTimeToLive(int)`";
    }

    public String getDescription() {
        return "`java.net.MulticastSocket#setTTL(byte)` has been deprecated.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateMulticastSocketSetTTLToSetTimeToLiveVisitor();
    }

    private static class MigrateMulticastSocketSetTTLToSetTimeToLiveVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateMulticastSocketSetTTLToSetTimeToLiveVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (MATCHER.matches(m)) {
                m = (J.MethodInvocation)m.withName(m.getName().withSimpleName("setTimeToLive")).withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((MigrateMulticastSocketSetTTLToSetTimeToLiveVisitor)this).getCursor(), (String)"Byte.valueOf(#{any(byte)}).intValue()").build(), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
            }
            return super.visitMethodInvocation(m, (Object)ctx);
        }
    }
}

