/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateGetLoggingMXBeanToGetPlatformMXBean
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.util.logging.LogManager getLoggingMXBean()");

    public String getDisplayName() {
        return "Use `ManagementFactory#getPlatformMXBean(PlatformLoggingMXBean.class)`";
    }

    public String getDescription() {
        return "`LogManager#getLoggingMXBean()` was deprecated in Java 9.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                cu = (J.CompilationUnit)new ChangeType("java.util.logging.LoggingMXBean", "java.lang.management.PlatformLoggingMXBean").getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (MATCHER.matches(m)) {
                    this.maybeAddImport("java.lang.management.ManagementFactory");
                    this.maybeAddImport("java.lang.management.PlatformLoggingMXBean");
                    this.maybeRemoveImport("java.util.logging.LogManager");
                    m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class)").imports(new String[]{"java.lang.management.ManagementFactory"}).imports(new String[]{"java.lang.management.PlatformLoggingMXBean"}).build(), m.getCoordinates().replace(), new Object[0]);
                }
                return m;
            }
        };
    }
}

