/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.xml.tree.Xml;

public class ReplaceJavaxJaxwsWithJakarta
extends Recipe {
    public String getDisplayName() {
        return "Replace `javax.xml.ws:jaxws-api` with `jakarta.xml.ws:jakarta.xml.ws-api`";
    }

    public String getDescription() {
        return "This recipe will replace the legacy javax `jaxws-api` artifact with the Jakarta EE equivalent. The jakarta JAX-WS API 2.3.x is part of JakartaEE 8 and still uses `javax` packaging.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag("javax.xml.ws", "jaxws-api")) {
                    Optional scopeTag = tag.getChild("scope");
                    String scope = scopeTag.isPresent() && ((Xml.Tag)scopeTag.get()).getValue().isPresent() ? (String)((Xml.Tag)scopeTag.get()).getValue().get() : null;
                    this.doAfterVisit((Recipe)new RemoveDependency("javax.xml.ws", "jaxws-api", scope));
                    this.doAfterVisit((TreeVisitor)new AddDependencyVisitor("jakarta.xml.ws", "jakarta.xml.ws-api", "2.3.2", null, scope, null, null, null, null, null));
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }
}

