/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.sql;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class MigrateDriverManagerSetLogStream
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.sql.DriverManager setLogStream(java.io.PrintStream)");

    public String getDisplayName() {
        return "Use `DriverManager#setLogWriter(java.io.PrintWriter)`";
    }

    public String getDescription() {
        return "`DriverManager#setLogStream(java.io.PrintStream)` was deprecated in Java 1.2.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)"new java.io.PrintWriter(#{any(java.io.PrintStream)})").build();

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches(m)) {
                    m = (J.MethodInvocation)method.withName(m.getName().withName("setLogWriter")).withTemplate(this.template, m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
                }
                return m;
            }
        };
    }
}

