/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class MigrateClassLoaderDefineClass
extends Recipe {
    private static final MethodMatcher DEFINE_CLASS_MATCHER = new MethodMatcher("java.lang.ClassLoader defineClass(byte[], int, int)");

    public String getDisplayName() {
        return "Use `ClassLoader#defineClass(String, byte[], int, int)`";
    }

    public String getDescription() {
        return "`ClassLoader#defineClass(byte[], int, int)` was deprecated in Java 1.1.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)"null, #{anyArray(byte)}, #{any(int)}, #{any(int)}").build();

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (DEFINE_CLASS_MATCHER.matches(m) && m.getArguments().size() == 3) {
                    m = (J.MethodInvocation)method.withTemplate(this.template, m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0), m.getArguments().get(1), m.getArguments().get(2)});
                }
                return m;
            }
        };
    }
}

