/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.xml.tree.Xml;

public class ReplaceJavaxJaxbWithJakarta
extends Recipe {
    public String getDisplayName() {
        return "Replace `javax.xml.bind:jaxb-api with `jakarta.xml.bind:jakarta.xml.bind-api`";
    }

    public String getDescription() {
        return "This recipe will replace the legacy `javax-api` artifact with the Jakarta EE equivalent.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag("javax.xml.bind", "jaxb-api")) {
                    Optional scopeTag = tag.getChild("scope");
                    String scope = scopeTag.isPresent() && ((Xml.Tag)scopeTag.get()).getValue().isPresent() ? (String)((Xml.Tag)scopeTag.get()).getValue().get() : null;
                    this.doAfterVisit((Recipe)new RemoveDependency("javax.xml.bind", "jaxb-api", scope));
                    this.doAfterVisit((TreeVisitor)new AddDependencyVisitor("jakarta.xml.bind", "jakarta.xml.bind-api", "2.3.x", null, scope, null, null, null, null, null));
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }
}

