/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;

public final class AddJaxwsRuntime
extends Recipe {
    private static final String JAKARTA_JAXWS_API_GROUP = "jakarta.xml.ws";
    private static final String JAKARTA_JAXWS_API_ARTIFACT = "jakarta.xml.ws-api";
    private static final String SUN_JAXWS_RUNTIME_GROUP = "com.sun.xml.ws";
    private static final String SUN_JAXWS_RUNTIME_ARTIFACT = "jaxws-rt";

    public String getDisplayName() {
        return "Add JAX-WS run-time dependency to a Maven project";
    }

    public String getDescription() {
        return "This recipe will add a JAX-WS run-time dependency to any maven project that has a transitive dependency on JAX-WS APIs.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        this.doNext((Recipe)new RemoveDependency(SUN_JAXWS_RUNTIME_GROUP, "jaxws-ri", null));
        HashMap<String, Pom> gavToPom = new HashMap<String, Pom>();
        for (SourceFile source : before) {
            if (!(source instanceof Maven)) continue;
            Pom pom = ((Maven)source).getModel();
            gavToPom.put(pom.getCoordinates(), pom);
        }
        return ListUtils.map(before, s -> {
            if (s instanceof Maven) {
                Maven mavenSource = (Maven)s;
                Scope apiScope = this.getTransitiveDependencyScope(mavenSource.getModel(), JAKARTA_JAXWS_API_GROUP, JAKARTA_JAXWS_API_ARTIFACT, gavToPom);
                Scope runtimeScope = this.getTransitiveDependencyScope(mavenSource.getModel(), SUN_JAXWS_RUNTIME_GROUP, SUN_JAXWS_RUNTIME_ARTIFACT, gavToPom);
                if (!(apiScope == null || runtimeScope != null && apiScope.isInClasspathOf(runtimeScope))) {
                    String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                    return (SourceFile)new AddDependencyVisitor(SUN_JAXWS_RUNTIME_GROUP, SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null).visit((Tree)mavenSource, (Object)ctx);
                }
            }
            return s;
        });
    }

    @Nullable
    private Scope getTransitiveDependencyScope(Pom pom, String groupId, String artifactId, Map<String, Pom> gavToPoms) {
        Pom localPom = gavToPoms.get(pom.getCoordinates());
        if (localPom != null) {
            pom = localPom;
        }
        Scope scope = null;
        for (Pom.Dependency dependency : pom.getDependencies()) {
            if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId()) || !Scope.Compile.equals((Object)(scope = Scope.maxPrecedence((Scope)scope, (Scope)dependency.getScope())))) continue;
            return scope;
        }
        if (pom.getParent() != null && Scope.Compile.equals((Object)(scope = Scope.maxPrecedence(scope, (Scope)this.getTransitiveDependencyScope(pom.getParent(), groupId, artifactId, gavToPoms))))) {
            return scope;
        }
        for (Pom.Dependency dependency : pom.getDependencies()) {
            if (!Scope.Compile.equals((Object)(scope = Scope.maxPrecedence((Scope)scope, (Scope)this.getTransitiveDependencyScope(dependency.getModel(), groupId, artifactId, gavToPoms))))) continue;
            return scope;
        }
        return scope;
    }

    @NonNull
    public String toString() {
        return "AddJaxwsRuntime()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxwsRuntime)) {
            return false;
        }
        AddJaxwsRuntime other = (AddJaxwsRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddJaxwsRuntime;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

