/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JulIsLoggableToIsEnabledRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUL active Level check with corresponding SLF4J method calls";
    }

    public String getDescription() {
        return "Replace calls to `Logger.isLoggable(Level)` with the corresponding SLF4J method calls.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LoggerIsLoggableLevelAllRecipe(), new LoggerIsLoggableLevelFinestRecipe(), new LoggerIsLoggableLevelFinerRecipe(), new LoggerIsLoggableLevelFineRecipe(), new LoggerIsLoggableLevelConfigRecipe(), new LoggerIsLoggableLevelInfoRecipe(), new LoggerIsLoggableLevelWarningRecipe(), new LoggerIsLoggableLevelSevereRecipe()});
    }

    @NullMarked
    public static class LoggerIsLoggableLevelAllRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.ALL)` with SLF4J's `Logger.isTraceEnabled`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.ALL)` with `org.slf4j.Logger.isTraceEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.ALL)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isTraceEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelFinestRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.FINEST)` with SLF4J's `Logger.isTraceEnabled`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.FINEST)` with `org.slf4j.Logger.isTraceEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.FINEST)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isTraceEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelFinerRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.FINER)` with SLF4J's `Logger.isTraceEnabled()`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.FINER)` with `org.slf4j.Logger.isTraceEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.FINER)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isTraceEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelFineRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.FINE)` with SLF4J's `Logger.isDebugEnabled()`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.FINE)` with `org.slf4j.Logger.isDebugEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.FINE)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isDebugEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelConfigRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.CONFIG)` with SLF4J's `Logger.isInfoEnabled()`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.CONFIG)` with `org.slf4j.Logger.isInfoEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.CONFIG)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isInfoEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelInfoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.INFO)` with SLF4J's `Logger.isInfoEnabled()`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.INFO)` with `org.slf4j.Logger.isInfoEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.INFO)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isInfoEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelWarningRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.WARNING)` with SLF4J's `Logger.isWarnEnabled()`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.WARNING)` with `org.slf4j.Logger.isWarnEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.WARNING)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isWarnEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LoggerIsLoggableLevelSevereRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.isLoggable(Level.SEVERE)` with SLF4J's `Logger.isErrorEnabled()`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.isLoggable(Level.SEVERE)` with `org.slf4j.Logger.isErrorEnabled()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.isLoggable(java.util.logging.Level.SEVERE)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.isErrorEnabled()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger isLoggable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

