/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.tree.Yaml;

public final class FindMissingOrInvalidLabel
extends Recipe {
    @Option(displayName="Label name", description="The name of the label to search for the existence of.", example="mylabel")
    private final String labelName;
    @Option(displayName="Value", description="An optional regex that will validate values that match.", example="value(.*)", required=false)
    private final @Nullable String value;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Find label";
    }

    public String getDescription() {
        return "Find labels that optionally match a given regex.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern pattern = this.value != null ? Pattern.compile(this.value) : null;
        final String missing = "missing:" + this.labelName;
        final String invalid = null != this.value ? "invalid:" + this.value : null;
        EntryMarkingVisitor visitor = new EntryMarkingVisitor(){
            private final JsonPathMatcher IN_LABELS = new JsonPathMatcher("$.*..metadata.labels.*");

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof Yaml.Mapping || is instanceof Yaml.Document);
                if (parent.getValue() instanceof Yaml.Mapping && this.IN_LABELS.matches(parent)) {
                    K8S.Labels labels = K8S.asLabels((Yaml.Mapping)parent.getValue());
                    if (FindMissingOrInvalidLabel.this.value == null && !labels.getKeys().contains(FindMissingOrInvalidLabel.this.labelName)) {
                        this.getCursor().getParentOrThrow().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)missing);
                    } else if (pattern != null && !labels.valueMatches(FindMissingOrInvalidLabel.this.labelName, pattern, this.getCursor())) {
                        this.getCursor().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)invalid);
                    }
                }
                return super.visitMappingEntry(entry, ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"labelName", "value", "fileMatcher"})
    @Generated
    public FindMissingOrInvalidLabel(String labelName, @Nullable String value, @Nullable String fileMatcher) {
        this.labelName = labelName;
        this.value = value;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public String getLabelName() {
        return this.labelName;
    }

    @Generated
    public @Nullable String getValue() {
        return this.value;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindMissingOrInvalidLabel(labelName=" + this.getLabelName() + ", value=" + this.getValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMissingOrInvalidLabel)) {
            return false;
        }
        FindMissingOrInvalidLabel other = (FindMissingOrInvalidLabel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$labelName = this.getLabelName();
        String other$labelName = other.getLabelName();
        if (this$labelName == null ? other$labelName != null : !this$labelName.equals(other$labelName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindMissingOrInvalidLabel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $labelName = this.getLabelName();
        result = result * 59 + ($labelName == null ? 43 : $labelName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

