/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.table.MavenRepositoryOrder;

public final class FindRepositoryOrder
extends Recipe {
    private final transient MavenRepositoryOrder repositoryOrder = new MavenRepositoryOrder((Recipe)this);
    private final String displayName = "Maven repository order";
    private final String description = "Determine the order in which dependencies will be resolved for each `pom.xml` or `build.gradle` based on its defined repositories and effective settings.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> mavenFindRepositoryOrder = new org.openrewrite.maven.search.FindRepositoryOrder().getVisitor();
            final TreeVisitor<?, ExecutionContext> gradleFindRepositoryOrder = new org.openrewrite.gradle.search.FindRepositoryOrder().getVisitor();

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (this.mavenFindRepositoryOrder.isAcceptable(s, (Object)ctx)) {
                    return this.mavenFindRepositoryOrder.visitNonNull(tree, (Object)ctx);
                }
                if (this.gradleFindRepositoryOrder.isAcceptable(s, (Object)ctx)) {
                    return this.gradleFindRepositoryOrder.visitNonNull(tree, (Object)ctx);
                }
                return s;
            }
        };
    }

    @Generated
    public FindRepositoryOrder() {
    }

    @Generated
    public MavenRepositoryOrder getRepositoryOrder() {
        return this.repositoryOrder;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "FindRepositoryOrder(repositoryOrder=" + this.getRepositoryOrder() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindRepositoryOrder)) {
            return false;
        }
        FindRepositoryOrder other = (FindRepositoryOrder)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindRepositoryOrder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

