/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.search;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.dependencies.DependencyInsight;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.SearchResult;

public final class ModuleHasDependency
extends ScanningRecipe<Set<JavaProject>> {
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. All scopes are searched by default.", valid={"compile", "test", "runtime", "provided", "system"}, example="compile", required=false)
    private final @Nullable String scope;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Invert marking", description="If `true`, will invert the check for whether to mark a file. Defaults to `false`.", required=false)
    private final @Nullable Boolean invertMarking;

    public String getDisplayName() {
        return "Module has dependency";
    }

    public String getDescription() {
        return "Searches for both Gradle and Maven modules that have a dependency matching the specified groupId and artifactId. Places a `SearchResult` marker on all sources within a module with a matching dependency. This recipe is intended to be used as a precondition for other recipes. For example this could be used to limit the application of a spring boot migration to only projects that use spring-boot-starter, limiting unnecessary upgrading. If the search result you want is instead just the build.gradle(.kts) or pom.xml file applying the plugin, use the `FindDependency` recipe instead.";
    }

    public Set<JavaProject> getInitialValue(ExecutionContext ctx) {
        return new HashSet<JavaProject>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<JavaProject> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                tree.getMarkers().findFirst(JavaProject.class).ifPresent(jp -> {
                    Tree t = new DependencyInsight(ModuleHasDependency.this.groupIdPattern, ModuleHasDependency.this.artifactIdPattern, ModuleHasDependency.this.version, ModuleHasDependency.this.scope).getVisitor().visit(tree, (Object)ctx);
                    if (t != tree) {
                        acc.add(jp);
                    }
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<JavaProject> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                boolean shouldInvert = ModuleHasDependency.this.invertMarking != null && ModuleHasDependency.this.invertMarking != false;
                String dependencyGav = ModuleHasDependency.this.groupIdPattern + ":" + ModuleHasDependency.this.artifactIdPattern + (ModuleHasDependency.this.version == null ? "" : ":" + ModuleHasDependency.this.version);
                Optional maybeJp = tree.getMarkers().findFirst(JavaProject.class);
                if (!maybeJp.isPresent()) {
                    if (shouldInvert) {
                        return SearchResult.found((Tree)tree, (String)("No module, so vacuously does not have dependency: " + dependencyGav));
                    }
                    return tree;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                if (shouldInvert && !acc.contains(jp)) {
                    return SearchResult.found((Tree)tree, (String)("Module does not have dependency: " + dependencyGav));
                }
                if (!shouldInvert && acc.contains(jp)) {
                    return SearchResult.found((Tree)tree, (String)("Module has dependency: " + dependencyGav));
                }
                return tree;
            }
        };
    }

    @ConstructorProperties(value={"groupIdPattern", "artifactIdPattern", "scope", "version", "invertMarking"})
    @Generated
    public ModuleHasDependency(String groupIdPattern, String artifactIdPattern, @Nullable String scope, @Nullable String version, @Nullable Boolean invertMarking) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.scope = scope;
        this.version = version;
        this.invertMarking = invertMarking;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getInvertMarking() {
        return this.invertMarking;
    }

    @Generated
    public String toString() {
        return "ModuleHasDependency(groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", scope=" + this.getScope() + ", version=" + this.getVersion() + ", invertMarking=" + this.getInvertMarking() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleHasDependency)) {
            return false;
        }
        ModuleHasDependency other = (ModuleHasDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$invertMarking = this.getInvertMarking();
        Boolean other$invertMarking = other.getInvertMarking();
        if (this$invertMarking == null ? other$invertMarking != null : !((Object)this$invertMarking).equals(other$invertMarking)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModuleHasDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $invertMarking = this.getInvertMarking();
        result = result * 59 + ($invertMarking == null ? 43 : ((Object)$invertMarking).hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

