/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.beans.ConstructorProperties;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class DependencyListReport
extends DataTable<Row> {
    public DependencyListReport(Recipe recipe) {
        super(recipe, "Dependency report", "Lists all Gradle and Maven dependencies");
    }

    public static final class Row {
        @Column(displayName="Build tool", description="The build tool used to manage dependencies (Gradle or Maven).")
        private final String buildTool;
        @Column(displayName="Group id", description="The Group ID of the Gradle project or Maven module requesting the dependency.")
        private final String groupId;
        @Column(displayName="Artifact id", description="The Artifact ID of the Gradle project or Maven module requesting the dependency.")
        private final String artifactId;
        @Column(displayName="Version", description="The version of Gradle project or Maven module requesting the dependency.")
        private final String version;
        @Column(displayName="Dependency group id", description="The Group ID of the dependency.")
        private final String dependencyGroupId;
        @Column(displayName="Dependency artifact id", description="The Artifact ID of the dependency.")
        private final String dependencyArtifactId;
        @Column(displayName="Dependency version", description="The version of the dependency.")
        private final String dependencyVersion;
        @Column(displayName="Direct Dependency", description="When `true` the project directly depends on the dependency. When `false` the project depends on the dependency transitively through at least one direct dependency.")
        private final boolean direct;

        @ConstructorProperties(value={"buildTool", "groupId", "artifactId", "version", "dependencyGroupId", "dependencyArtifactId", "dependencyVersion", "direct"})
        public Row(String buildTool, String groupId, String artifactId, String version, String dependencyGroupId, String dependencyArtifactId, String dependencyVersion, boolean direct) {
            this.buildTool = buildTool;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.dependencyGroupId = dependencyGroupId;
            this.dependencyArtifactId = dependencyArtifactId;
            this.dependencyVersion = dependencyVersion;
            this.direct = direct;
        }

        public String getBuildTool() {
            return this.buildTool;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDependencyGroupId() {
            return this.dependencyGroupId;
        }

        public String getDependencyArtifactId() {
            return this.dependencyArtifactId;
        }

        public String getDependencyVersion() {
            return this.dependencyVersion;
        }

        public boolean isDirect() {
            return this.direct;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isDirect() != other.isDirect()) {
                return false;
            }
            String this$buildTool = this.getBuildTool();
            String other$buildTool = other.getBuildTool();
            if (this$buildTool == null ? other$buildTool != null : !this$buildTool.equals(other$buildTool)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$dependencyGroupId = this.getDependencyGroupId();
            String other$dependencyGroupId = other.getDependencyGroupId();
            if (this$dependencyGroupId == null ? other$dependencyGroupId != null : !this$dependencyGroupId.equals(other$dependencyGroupId)) {
                return false;
            }
            String this$dependencyArtifactId = this.getDependencyArtifactId();
            String other$dependencyArtifactId = other.getDependencyArtifactId();
            if (this$dependencyArtifactId == null ? other$dependencyArtifactId != null : !this$dependencyArtifactId.equals(other$dependencyArtifactId)) {
                return false;
            }
            String this$dependencyVersion = this.getDependencyVersion();
            String other$dependencyVersion = other.getDependencyVersion();
            return !(this$dependencyVersion == null ? other$dependencyVersion != null : !this$dependencyVersion.equals(other$dependencyVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDirect() ? 79 : 97);
            String $buildTool = this.getBuildTool();
            result = result * 59 + ($buildTool == null ? 43 : $buildTool.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $dependencyGroupId = this.getDependencyGroupId();
            result = result * 59 + ($dependencyGroupId == null ? 43 : $dependencyGroupId.hashCode());
            String $dependencyArtifactId = this.getDependencyArtifactId();
            result = result * 59 + ($dependencyArtifactId == null ? 43 : $dependencyArtifactId.hashCode());
            String $dependencyVersion = this.getDependencyVersion();
            result = result * 59 + ($dependencyVersion == null ? 43 : $dependencyVersion.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DependencyListReport.Row(buildTool=" + this.getBuildTool() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", dependencyGroupId=" + this.getDependencyGroupId() + ", dependencyArtifactId=" + this.getDependencyArtifactId() + ", dependencyVersion=" + this.getDependencyVersion() + ", direct=" + this.isDirect() + ")";
        }
    }
}

