/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.time.LocalDate;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class RemoveExpiredSuppressions
extends Recipe {
    private static final XPathMatcher X_PATH_MATCHER = new XPathMatcher("/suppressions/suppress");

    public String getDisplayName() {
        return "Remove expired suppressions";
    }

    public String getDescription() {
        return "Remove expired vulnerability suppressions from `DependencyCheck` `suppression.xml` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                String until;
                Optional<Xml.Attribute> untilAttribute;
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (X_PATH_MATCHER.matches(this.getCursor()) && (untilAttribute = t.getAttributes().stream().filter(attribute -> "until".equals(attribute.getKeyAsString())).findFirst()).isPresent() && LocalDate.parse((until = untilAttribute.get().getValue().getValue()).substring(0, 10)).isBefore(LocalDate.now())) {
                    return null;
                }
                return t;
            }
        };
    }
}

