/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.github;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import org.openrewrite.java.dependencies.Vulnerability;
import org.openrewrite.java.dependencies.github.advisories.Advisory;
import org.openrewrite.java.dependencies.github.advisories.Affected;
import org.openrewrite.java.dependencies.github.advisories.Range;

public class ParseAdvisories {
    public static void main(String[] args) throws IOException {
        final ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new JavaTimeModule());
        CsvFactory factory = new CsvFactory();
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        CsvMapper csvMapper = (CsvMapper)((CsvMapper)((CsvMapper.Builder)((CsvMapper.Builder)CsvMapper.builder((CsvFactory)factory).disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build()).registerModule((Module)new JavaTimeModule());
        CsvSchema schema = csvMapper.schemaFor(Vulnerability.class);
        final ObjectWriter vWriter = csvMapper.writer((FormatSchema)schema);
        try (final FileOutputStream f = new FileOutputStream("src/main/resources/advisories.csv");){
            Files.walkFileTree(new File(System.getProperty("user.home") + "/Projects/github/github/advisory-database/advisories").toPath(), Collections.emptySet(), 16, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    System.out.println("Parsing " + file);
                    if (file.getFileName().toString().endsWith(".json")) {
                        Advisory advisory = (Advisory)mapper.readValue(file.toFile(), Advisory.class);
                        for (Affected affected : advisory.getAffected()) {
                            if (!affected.getPkg().getEcosystem().equals("Maven") || affected.getRanges() == null || affected.getRanges().isEmpty()) continue;
                            Range range = affected.getRanges().iterator().next();
                            Vulnerability vulnerability = new Vulnerability(advisory.getAliases().isEmpty() ? advisory.getId() : advisory.getAliases().iterator().next(), advisory.getPublished(), advisory.getSummary(), affected.getPkg().getName(), range.getIntroduced(), range.getFixed(), Vulnerability.Severity.valueOf(advisory.getDatabaseSpecific().getSeverity()));
                            vWriter.writeValue((OutputStream)f, (Object)vulnerability);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

