/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;

public class ChangeDependency
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Override managed version", description="If the new dependency has a managed version, this flag can be used to explicitly set the version on the dependency. The default for this flag is `false`.", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;
    private final org.openrewrite.gradle.ChangeDependency changeGradleDependency;
    private final ChangeDependencyGroupIdAndArtifactId changeMavenDependency;

    public String getDisplayName() {
        return "Change Gradle or Maven dependency";
    }

    public String getDescription() {
        return "Change the groupId, artifactId and/or the version of a specified Gradle or Maven dependency.";
    }

    public ChangeDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
        this.changeGradleDependency = new org.openrewrite.gradle.ChangeDependency(oldGroupId, oldArtifactId, newGroupId, newArtifactId, newVersion, versionPattern);
        this.changeMavenDependency = new ChangeDependencyGroupIdAndArtifactId(oldGroupId, oldArtifactId, newGroupId, newArtifactId, newVersion, versionPattern, overrideManagedVersion);
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(this.changeGradleDependency, this.changeMavenDependency);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependency)) {
            return false;
        }
        ChangeDependency other = (ChangeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.overrideManagedVersion;
        Boolean other$overrideManagedVersion = other.overrideManagedVersion;
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$oldGroupId = this.oldGroupId;
        String other$oldGroupId = other.oldGroupId;
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.oldArtifactId;
        String other$oldArtifactId = other.oldArtifactId;
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.newGroupId;
        String other$newGroupId = other.newGroupId;
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.newArtifactId;
        String other$newArtifactId = other.newArtifactId;
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.newVersion;
        String other$newVersion = other.newVersion;
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.versionPattern;
        String other$versionPattern = other.versionPattern;
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        org.openrewrite.gradle.ChangeDependency this$changeGradleDependency = this.changeGradleDependency;
        org.openrewrite.gradle.ChangeDependency other$changeGradleDependency = other.changeGradleDependency;
        if (this$changeGradleDependency == null ? other$changeGradleDependency != null : !this$changeGradleDependency.equals(other$changeGradleDependency)) {
            return false;
        }
        ChangeDependencyGroupIdAndArtifactId this$changeMavenDependency = this.changeMavenDependency;
        ChangeDependencyGroupIdAndArtifactId other$changeMavenDependency = other.changeMavenDependency;
        return !(this$changeMavenDependency == null ? other$changeMavenDependency != null : !this$changeMavenDependency.equals(other$changeMavenDependency));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $overrideManagedVersion = this.overrideManagedVersion;
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $oldGroupId = this.oldGroupId;
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.oldArtifactId;
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.newGroupId;
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.newArtifactId;
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.newVersion;
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.versionPattern;
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        org.openrewrite.gradle.ChangeDependency $changeGradleDependency = this.changeGradleDependency;
        result = result * 59 + ($changeGradleDependency == null ? 43 : $changeGradleDependency.hashCode());
        ChangeDependencyGroupIdAndArtifactId $changeMavenDependency = this.changeMavenDependency;
        result = result * 59 + ($changeMavenDependency == null ? 43 : $changeMavenDependency.hashCode());
        return result;
    }
}

