/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.github.security.YamlHelper;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UnpinnedDockerImagesRecipe
extends Recipe {
    private static final Pattern DOCKER_IMAGE_PATTERN = Pattern.compile("^(?:docker://)?([^/:]+(?:\\.[^/:]+)*(?::[0-9]+)?/)?([^/:]+(?:/[^/:]+)*):([^@]+)(?:@(.+))?$");
    private static final Pattern SHA256_DIGEST_PATTERN = Pattern.compile("^sha256:[a-f0-9]{64}$");
    private final String displayName = "Pin Docker images to digests";
    private final String description = "Pin Docker images to specific digest hashes for security and reproducibility. Images pinned to tags can be changed by the image author, while digest pins are immutable. Based on [zizmor's unpinned-images audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/unpinned_images.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new UnpinnedDockerImagesVisitor());
    }

    @Generated
    public UnpinnedDockerImagesRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "UnpinnedDockerImagesRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnpinnedDockerImagesRecipe)) {
            return false;
        }
        UnpinnedDockerImagesRecipe other = (UnpinnedDockerImagesRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnpinnedDockerImagesRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class UnpinnedDockerImagesVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private UnpinnedDockerImagesVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            String imageValue;
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isImageEntry(mappingEntry) && (imageValue = this.getImageValue(mappingEntry)) != null && this.isUnpinnedDockerImage(imageValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)("Docker image '" + imageValue + "' is not pinned to a digest. Consider pinning to a specific digest for security and reproducibility."));
            }
            return mappingEntry;
        }

        private boolean isImageEntry(Yaml.Mapping.Entry entry) {
            return "image".equals(entry.getKey().getValue());
        }

        private String getImageValue(Yaml.Mapping.Entry entry) {
            return YamlHelper.getScalarValue(entry.getValue());
        }

        private boolean isUnpinnedDockerImage(String imageValue) {
            String[] parts;
            String cleanImage = imageValue;
            if (cleanImage.startsWith("docker://")) {
                cleanImage = cleanImage.substring("docker://".length());
            }
            if (cleanImage.contains("@") && (parts = cleanImage.split("@", 2)).length == 2) {
                String digest = parts[1];
                return !SHA256_DIGEST_PATTERN.matcher(digest).matches();
            }
            return true;
        }
    }
}

