/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class TrustedPublishingRecipe
extends Recipe {
    private static final Set<String> KNOWN_PYTHON_TP_REGISTRIES = new HashSet<String>(Arrays.asList("https://upload.pypi.org/legacy/", "https://test.pypi.org/legacy/"));
    private static final Set<String> KNOWN_RUBY_TP_REGISTRIES = new HashSet<String>(Arrays.asList("https://rubygems.org"));
    private static final Set<String> KNOWN_NPM_TP_REGISTRIES = new HashSet<String>(Arrays.asList("https://registry.npmjs.org"));
    private static final Pattern[] MANUAL_PUBLISH_PATTERNS = new Pattern[]{Pattern.compile("(?s)twine\\s+(.+\\s+)?upload"), Pattern.compile("(?s)cargo\\s+(.+\\s+)?publish"), Pattern.compile("(?s)npm\\s+(.+\\s+)?publish"), Pattern.compile("(?s)yarn\\s+(.+\\s+)?npm\\s+publish"), Pattern.compile("(?s)pnpm\\s+(.+\\s+)?publish"), Pattern.compile("(?s)gem\\s+(.+\\s+)?push"), Pattern.compile("(?s)uv\\s+(.+\\s+)?publish"), Pattern.compile("(?s)hatch\\s+(.+\\s+)?publish"), Pattern.compile("(?s)pdm\\s+(.+\\s+)?publish")};
    private final String displayName = "Find manual credentials instead of trusted publishing";
    private final String description = "Find workflows that use manual credentials for publishing instead of OIDC trusted publishing. Trusted publishing eliminates the need for long-lived API tokens and provides better security through short-lived, automatically-rotated tokens. Based on [zizmor's use-trusted-publishing audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/use_trusted_publishing.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new TrustedPublishingVisitor());
    }

    @Generated
    public TrustedPublishingRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "TrustedPublishingRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustedPublishingRecipe)) {
            return false;
        }
        TrustedPublishingRecipe other = (TrustedPublishingRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrustedPublishingRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class TrustedPublishingVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private TrustedPublishingVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isUsesEntry(mappingEntry)) {
                return this.checkUsesEntry(mappingEntry);
            }
            if (this.isRunEntry(mappingEntry)) {
                return this.checkRunEntry(mappingEntry);
            }
            if (this.isWithinProblematicAction()) {
                return this.checkWithEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "uses".equals(key.getValue());
        }

        private boolean isRunEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "run".equals(key.getValue());
        }

        private Yaml.Mapping.Entry checkUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String usesValue = ((Yaml.Scalar)entry.getValue()).getValue();
            if (usesValue.startsWith("pypa/gh-action-pypi-publish")) {
                return this.checkPyPIAction(entry);
            }
            if (usesValue.startsWith("rubygems/release-gem")) {
                return this.checkRubyGemsAction(entry);
            }
            if (usesValue.startsWith("rubygems/configure-rubygems-credentials")) {
                return this.checkRubyGemsCredentialsAction(entry);
            }
            if (usesValue.startsWith("actions/setup-node")) {
                return this.checkSetupNodeAction(entry);
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkPyPIAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                return entry;
            }
            boolean hasPassword = withMapping.getEntries().stream().anyMatch(withEntry -> {
                if (withEntry.getKey() instanceof Yaml.Scalar) {
                    Yaml.Scalar key = (Yaml.Scalar)withEntry.getKey();
                    return "password".equals(key.getValue());
                }
                return false;
            });
            boolean isTrustedRegistry = withMapping.getEntries().stream().anyMatch(withEntry -> {
                Yaml.Scalar key;
                if (withEntry.getKey() instanceof Yaml.Scalar && ("repository-url".equals((key = (Yaml.Scalar)withEntry.getKey()).getValue()) || "repository_url".equals(key.getValue())) && withEntry.getValue() instanceof Yaml.Scalar) {
                    String repoUrl = ((Yaml.Scalar)withEntry.getValue()).getValue();
                    return KNOWN_PYTHON_TP_REGISTRIES.contains(repoUrl);
                }
                return false;
            });
            if (hasPassword && isTrustedRegistry) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses manual credentials instead of trusted publishing. Consider using OIDC trusted publishing for better security.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkRubyGemsAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                return entry;
            }
            boolean explicitlyDisabled = withMapping.getEntries().stream().anyMatch(withEntry -> {
                Yaml.Scalar key;
                if (withEntry.getKey() instanceof Yaml.Scalar && "setup-trusted-publisher".equals((key = (Yaml.Scalar)withEntry.getKey()).getValue()) && withEntry.getValue() instanceof Yaml.Scalar) {
                    String value = ((Yaml.Scalar)withEntry.getValue()).getValue();
                    return "false".equals(value);
                }
                return false;
            });
            if (explicitlyDisabled) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses manual credentials instead of trusted publishing. Consider using OIDC trusted publishing for better security.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkRubyGemsCredentialsAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                return entry;
            }
            boolean hasApiToken = withMapping.getEntries().stream().anyMatch(withEntry -> {
                if (withEntry.getKey() instanceof Yaml.Scalar) {
                    Yaml.Scalar key = (Yaml.Scalar)withEntry.getKey();
                    return "api-token".equals(key.getValue());
                }
                return false;
            });
            boolean isRubyGemsServer = withMapping.getEntries().stream().anyMatch(withEntry -> {
                Yaml.Scalar key;
                if (withEntry.getKey() instanceof Yaml.Scalar && "gem-server".equals((key = (Yaml.Scalar)withEntry.getKey()).getValue()) && withEntry.getValue() instanceof Yaml.Scalar) {
                    String server = ((Yaml.Scalar)withEntry.getValue()).getValue();
                    return KNOWN_RUBY_TP_REGISTRIES.contains(server);
                }
                return false;
            });
            if (hasApiToken && isRubyGemsServer) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses manual credentials instead of trusted publishing. Consider using OIDC trusted publishing for better security.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkSetupNodeAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                return entry;
            }
            boolean isNpmRegistry = withMapping.getEntries().stream().anyMatch(withEntry -> {
                Yaml.Scalar key;
                if (withEntry.getKey() instanceof Yaml.Scalar && "registry-url".equals((key = (Yaml.Scalar)withEntry.getKey()).getValue()) && withEntry.getValue() instanceof Yaml.Scalar) {
                    String registryUrl = ((Yaml.Scalar)withEntry.getValue()).getValue();
                    return KNOWN_NPM_TP_REGISTRIES.contains(registryUrl);
                }
                return false;
            });
            boolean hasAlwaysAuth = withMapping.getEntries().stream().anyMatch(withEntry -> {
                Yaml.Scalar key;
                if (withEntry.getKey() instanceof Yaml.Scalar && "always-auth".equals((key = (Yaml.Scalar)withEntry.getKey()).getValue()) && withEntry.getValue() instanceof Yaml.Scalar) {
                    String value = ((Yaml.Scalar)withEntry.getValue()).getValue();
                    return "true".equals(value);
                }
                return false;
            });
            if (isNpmRegistry && hasAlwaysAuth) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses manual credentials instead of trusted publishing. Consider using OIDC trusted publishing for better security.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkRunEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String runCommand = ((Yaml.Scalar)entry.getValue()).getValue();
            for (Pattern pattern : MANUAL_PUBLISH_PATTERNS) {
                if (!pattern.matcher(runCommand).find()) continue;
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Manual publishing command detected. Consider using trusted publishing actions instead.");
            }
            return entry;
        }

        private Yaml.Mapping findParentStepMapping() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Yaml.Mapping mapping;
                boolean hasUses;
                Object value = current.getValue();
                if (!(value instanceof Yaml.Mapping) || !(hasUses = (mapping = (Yaml.Mapping)value).getEntries().stream().anyMatch(mapEntry -> {
                    if (mapEntry.getKey() instanceof Yaml.Scalar) {
                        Yaml.Scalar key = (Yaml.Scalar)mapEntry.getKey();
                        return "uses".equals(key.getValue());
                    }
                    return false;
                }))) continue;
                return mapping;
            }
            return null;
        }

        private Yaml.Mapping findWithMapping(Yaml.Mapping stepMapping) {
            for (Yaml.Mapping.Entry stepEntry : stepMapping.getEntries()) {
                Yaml.Scalar key;
                if (!(stepEntry.getKey() instanceof Yaml.Scalar) || !"with".equals((key = (Yaml.Scalar)stepEntry.getKey()).getValue()) || !(stepEntry.getValue() instanceof Yaml.Mapping)) continue;
                return (Yaml.Mapping)stepEntry.getValue();
            }
            return null;
        }

        private boolean isWithinProblematicAction() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Yaml.Scalar key;
                Yaml.Mapping.Entry parentEntry;
                Object value = current.getValue();
                if (!(value instanceof Yaml.Mapping.Entry) || !((parentEntry = (Yaml.Mapping.Entry)value).getKey() instanceof Yaml.Scalar) || !"with".equals((key = (Yaml.Scalar)parentEntry.getKey()).getValue())) continue;
                return this.isProblematicActionStep(current);
            }
            return false;
        }

        private boolean isProblematicActionStep(Cursor withCursor) {
            for (Cursor stepCursor = withCursor.getParent(); stepCursor != null; stepCursor = stepCursor.getParent()) {
                Object value = stepCursor.getValue();
                if (!(value instanceof Yaml.Mapping)) continue;
                Yaml.Mapping stepMapping = (Yaml.Mapping)value;
                for (Yaml.Mapping.Entry stepEntry : stepMapping.getEntries()) {
                    Yaml.Scalar key;
                    if (!(stepEntry.getKey() instanceof Yaml.Scalar) || !"uses".equals((key = (Yaml.Scalar)stepEntry.getKey()).getValue()) || !(stepEntry.getValue() instanceof Yaml.Scalar)) continue;
                    String usesValue = ((Yaml.Scalar)stepEntry.getValue()).getValue();
                    return usesValue.startsWith("pypa/gh-action-pypi-publish") || usesValue.startsWith("rubygems/release-gem") || usesValue.startsWith("rubygems/configure-rubygems-credentials") || usesValue.startsWith("actions/setup-node");
                }
            }
            return false;
        }

        private Yaml.Mapping.Entry checkWithEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return entry;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            String keyValue = key.getValue();
            if (("password".equals(keyValue) || "setup-trusted-publisher".equals(keyValue) || "always-auth".equals(keyValue) || "api-token".equals(keyValue)) && entry.getValue() instanceof Yaml.Scalar) {
                String value = ((Yaml.Scalar)entry.getValue()).getValue();
                if ("password".equals(keyValue)) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Manual credential used here");
                }
                if ("setup-trusted-publisher".equals(keyValue) && "false".equals(value)) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Manual credential used here");
                }
                if ("always-auth".equals(keyValue) && "true".equals(value)) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Manual credential used here");
                }
                if ("api-token".equals(keyValue)) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Manual credential used here");
                }
            }
            return entry;
        }
    }
}

