/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class SetupJavaUpgradeJavaVersion
extends Recipe {
    @Option(displayName="Minimum major Java version (defaults to 21)", example="21", required=false)
    private final @Nullable Integer minimumJavaMajorVersion;
    private final String displayName = "Upgrade `actions/setup-java` `java-version`";
    private final String description = "Update the Java version used by `actions/setup-java` if it is below the expected version number.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new UpgradeJavaVersionVisitor(this.minimumJavaMajorVersion == null ? 21 : this.minimumJavaMajorVersion));
    }

    @Generated
    public SetupJavaUpgradeJavaVersion(@Nullable Integer minimumJavaMajorVersion) {
        this.minimumJavaMajorVersion = minimumJavaMajorVersion;
    }

    @Generated
    public @Nullable Integer getMinimumJavaMajorVersion() {
        return this.minimumJavaMajorVersion;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "SetupJavaUpgradeJavaVersion(minimumJavaMajorVersion=" + this.getMinimumJavaMajorVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupJavaUpgradeJavaVersion)) {
            return false;
        }
        SetupJavaUpgradeJavaVersion other = (SetupJavaUpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$minimumJavaMajorVersion = this.getMinimumJavaMajorVersion();
        Integer other$minimumJavaMajorVersion = other.getMinimumJavaMajorVersion();
        if (this$minimumJavaMajorVersion == null ? other$minimumJavaMajorVersion != null : !((Object)this$minimumJavaMajorVersion).equals(other$minimumJavaMajorVersion)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetupJavaUpgradeJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minimumJavaMajorVersion = this.getMinimumJavaMajorVersion();
        result = result * 59 + ($minimumJavaMajorVersion == null ? 43 : ((Object)$minimumJavaMajorVersion).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class UpgradeJavaVersionVisitor
    extends YamlVisitor<ExecutionContext> {
        private static final JsonPathMatcher javaVersion = new JsonPathMatcher("..steps[?(@.uses =~ 'actions/setup-java@v*.*')].with.java-version");
        private static final Pattern javaVersionPattern = Pattern.compile("([0-9]+)(\\.[0-9]+)*([-+].*)?");
        private final int minimumJavaMajorVersion;

        public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            int currentMajorVersion;
            if (!javaVersion.matches(this.getCursor())) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            Yaml.Scalar currentValue = (Yaml.Scalar)entry.getValue();
            Matcher matcher = javaVersionPattern.matcher(currentValue.getValue());
            if (!matcher.matches()) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            try {
                currentMajorVersion = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            if (currentMajorVersion >= this.minimumJavaMajorVersion) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            return super.visitMappingEntry(entry.withValue((Yaml.Block)currentValue.withValue(String.valueOf(this.minimumJavaMajorVersion))), (Object)ctx);
        }

        @Generated
        public UpgradeJavaVersionVisitor(int minimumJavaMajorVersion) {
            this.minimumJavaMajorVersion = minimumJavaMajorVersion;
        }
    }
}

