/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ReplaceSecrets
extends Recipe {
    @Option(displayName="Old secret name", description="The name of the secret to be replaced", example="OSSRH_S01_USERNAME")
    private final String oldSecretName;
    @Option(displayName="New secret name", description="The new secret name to use", example="SONATYPE_USERNAME")
    private final String newSecretName;
    @Option(displayName="File matcher", description="Optional file path matcher", required=false, example=".github/workflows/*.yml")
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Replace GitHub Action secret names";
    }

    public String getDescription() {
        return "Replace references to GitHub Action secrets in workflow files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher != null ? this.fileMatcher : ".github/workflows/*.yml"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                Yaml.Scalar s = super.visitScalar(scalar, (Object)ctx);
                String value = s.getValue();
                String regex = "\\$\\{\\{\\s*secrets\\." + ReplaceSecrets.this.oldSecretName + "\\s*}}";
                if (value.matches(".*" + regex + ".*")) {
                    String newValue = value.replaceAll(regex, "\\${{ secrets." + ReplaceSecrets.this.newSecretName + " }}");
                    return s.withValue(newValue);
                }
                return s;
            }
        });
    }

    @Generated
    public ReplaceSecrets(String oldSecretName, String newSecretName, @Nullable String fileMatcher) {
        this.oldSecretName = oldSecretName;
        this.newSecretName = newSecretName;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public String getOldSecretName() {
        return this.oldSecretName;
    }

    @Generated
    public String getNewSecretName() {
        return this.newSecretName;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @Generated
    public String toString() {
        return "ReplaceSecrets(oldSecretName=" + this.getOldSecretName() + ", newSecretName=" + this.getNewSecretName() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceSecrets)) {
            return false;
        }
        ReplaceSecrets other = (ReplaceSecrets)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldSecretName = this.getOldSecretName();
        String other$oldSecretName = other.getOldSecretName();
        if (this$oldSecretName == null ? other$oldSecretName != null : !this$oldSecretName.equals(other$oldSecretName)) {
            return false;
        }
        String this$newSecretName = this.getNewSecretName();
        String other$newSecretName = other.getNewSecretName();
        if (this$newSecretName == null ? other$newSecretName != null : !this$newSecretName.equals(other$newSecretName)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceSecrets;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldSecretName = this.getOldSecretName();
        result = result * 59 + ($oldSecretName == null ? 43 : $oldSecretName.hashCode());
        String $newSecretName = this.getNewSecretName();
        result = result * 59 + ($newSecretName == null ? 43 : $newSecretName.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

