// For Library Version: 1.120.19

declare module "sap/fe/templates/library" {}

declare module "sap/fe/templates/ListReport/ExtensionAPI" {
  import ExtensionAPI1 from "sap/fe/core/ExtensionAPI";

  import Context from "sap/ui/model/odata/v4/Context";

  /**
   * Extension API for list reports in SAP Fiori elements for OData V4.
   * To correctly integrate your app extension coding with SAP Fiori elements, use only the extensionAPI of
   * SAP Fiori elements. Don't access or manipulate controls, properties, models, or other internal objects
   * created by the SAP Fiori elements framework.
   *
   *
   * @since 1.79.0
   */
  export default class ExtensionAPI extends ExtensionAPI1 {
    constructor();

    /**
     * This method converts filter conditions to filters.
     *
     *
     * @returns Object containing the converted FilterBar filters.
     */
    createFiltersFromFilterConditions(
      /**
       * Map containing the filter conditions of the FilterBar.
       */
      mFilterConditions: object
    ): object;
    /**
     * Provides all the model filters from the filter bar that are currently active
     * along with the search expression.
     *
     *
     * @returns An array of active filters and the search expression.
     */
    getFilters(): object;
    /**
     * Gets the list entries currently selected for the displayed control.
     *
     *
     * @returns Array containing the selected contexts
     */
    getSelectedContexts(): Context[];
    /**
     * Refreshes the List Report.
     * This method currently only supports triggering the search (by clicking on the GO button)
     * in the List Report Filter Bar. It can be used to request the initial load or to refresh the
     * currently shown data based on the filters entered by the user.
     * Please note: The Promise is resolved once the search is triggered and not once the data is returned.
     *
     *
     * @returns Resolved once the data is refreshed or rejected if the request failed
     */
    refresh(): Promise<void>;
    /**
     * Provide an option for showing a custom message in the message strip above the list report table.
     */
    setCustomMessage(
      /**
       * Custom message along with the message type to be set on the table.
       */
      message: /* was: sap.fe.templates.ListReport.LRMessageStrip.LRCustomMessage */
        | any
        | undefined,
      /**
       * The tabKey identifying the table where the custom message is displayed. If tabKey is empty, the message
       * is displayed in all tabs . If tabKey = ['1','2'], the message is displayed in tabs 1 and 2 only
       */
      tabKey?: null | string | string[],
      /**
       * A function that is called when the user closes the message bar.
       */
      onClose?: Function
    ): void;
    /**
     * Set the filter values for the given property in the filter bar.
     * The filter values can be either a single value or an array of values.
     * Each filter value must be represented as a primitive value.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setFilterValues(
      /**
       * The path to the property as a condition path
       */
      sConditionPath: string,
      /**
       * The operator to be used (optional) - if not set, the default operator (EQ) will be used
       */
      sOperator: string | undefined,
      /**
       * The values to be applied
       */
      vValues?:
        | boolean
        | boolean[]
        | number
        | number[]
        | string
        | string[]
        | undefined
    ): Promise<void>;
    /**
     * Provides an option for the selection of a specific tab programamatically.
     */
    setSelectedTab(
      /**
       * Specific tab to be selected.
       */
      tabKey: string
    ): void;
  }
}

declare module "sap/fe/templates/ListReport/ListReportController.controller" {
  import PageController from "sap/fe/core/PageController";

  import ExtensionAPI from "sap/fe/templates/ListReport/ExtensionAPI";

  /**
   * Controller class for the list report page, used inside an SAP Fiori elements application.
   */
  export default class ListReportController extends PageController {
    constructor();

    /**
     * Get the extension API for the current page.
     *
     *
     * @returns The extension API.
     */
    getExtensionAPI(): ExtensionAPI;
    /**
     * Method called when the 'Clear' button on the FilterBar is pressed.
     */
    onAfterClear(): void;
    /**
     * Method called when a filter or search value has been changed in the FilterBar,
     * but has not been validated yet by the end user (with the 'Go' or 'Search' button).
     * Typically, the content of the current tab is greyed out until the filters are validated.
     * This method can be overwritten by the controller extension in case of customization.
     */
    onPendingFilters(): void;
    /**
     * Method called when the content of a custom view used in a list report needs to be refreshed.
     * This happens either when there is a change on the FilterBar and the search is triggered,
     * or when a tab with custom content is selected.
     * This method can be overwritten by the controller extension in case of customization.
     */
    onViewNeedsRefresh(
      /**
       * Map containing the filter conditions of the FilterBar, the currentTabID
       * and the view refresh cause (tabChanged or search).
       * The map looks like this:
       *
       * ```javascript
       *
       * {
       * filterConditions: {
       * Country: [
       * {
       * operator: "EQ"
       * validated: "NotValidated"
       * values: ["Germany", ...]
       * },
       * ...
       * ]
       * ...
       * },
       * currentTabId: "fe::CustomTab::tab1",
       * refreshCause: "tabChanged" | "search"
       * }
       * ```
       */
      mParameters: any
    ): void;
  }
}

declare module "sap/fe/templates/ObjectPage/ExtensionAPI" {
  import ExtensionAPI1 from "sap/fe/core/ExtensionAPI";

  import Context from "sap/ui/model/Context";

  import Context1 from "sap/ui/model/odata/v4/Context";

  import Message from "sap/ui/core/message/Message";

  /**
   * Extension API for object pages on SAP Fiori elements for OData V4.
   * To correctly integrate your app extension coding with SAP Fiori elements, use only the extensionAPI of
   * SAP Fiori elements. Don't access or manipulate controls, properties, models, or other internal objects
   * created by the SAP Fiori elements framework.
   *
   *
   * @since 1.79.0
   */
  export default class ExtensionAPI extends ExtensionAPI1 {
    constructor();

    /**
     * Gets the bound context of the current object page.
     *
     *
     * @returns Context bound to the object page
     */
    getBindingContext(): null | Context | undefined;
    /**
     * Gets the list entries currently selected for the table.
     *
     *
     * @returns Array containing the selected contexts
     */
    getSelectedContexts(
      /**
       * The ID identifying the table the selected context is requested for
       */
      sTableId: string
    ): Context1[];
    /**
     * Hides the message strip below the anchor bar.
     */
    hideMessage(): void;
    /**
     * Refreshes either the whole object page or only parts of it.
     *
     *
     * @returns Resolved once the data is refreshed or rejected if the request failed
     */
    refresh(
      /**
       * Path or array of paths referring to entities or properties to be refreshed.
       * If omitted, the whole object page is refreshed. The path "" refreshes the entity assigned to the object
       * page
       * without navigations
       */
      vPath?: string | string[]
    ): Promise<void>;
    /**
     * Displays the message strip between the title and the header of the ObjectPage.
     */
    showMessages(
      /**
       * The message to be displayed
       */
      messages: Message[]
    ): void;
    /**
     * Displays or hides the side content of an object page.
     */
    showSideContent(
      /**
       * Key of the side content fragment as defined in the manifest.json
       */
      sSubSectionKey: string,
      /**
       * Optional Boolean flag to show or hide the side content
       */
      bShow?: boolean
    ): void;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/fe/templates/library": undefined;

    "sap/fe/templates/ListReport/ExtensionAPI": undefined;

    "sap/fe/templates/ListReport/ListReportController.controller": undefined;

    "sap/fe/templates/ObjectPage/ExtensionAPI": undefined;
  }
}
