import { ParserOptions as BabelParserOptions, ParserPlugin } from '@babel/parser';
export type ParserPluginName = Extract<ParserPlugin, string> | Extract<ParserPlugin, [string, object]>[0];
export declare function isParserPluginName(name: string): name is ParserPluginName;
export interface ParserOptions extends Omit<BabelParserOptions, 'plugins'> {
    plugins?: Array<ParserPlugin>;
}
/**
 * Builds options for `@babel/parser` by enabling as many features as possible,
 * while also preserving the options given as an argument.
 */
export declare function buildOptions({ sourceType, allowAwaitOutsideFunction, allowImportExportEverywhere, allowReturnOutsideFunction, allowSuperOutsideMethod, allowUndeclaredExports, plugins, sourceFilename, ...rest }?: ParserOptions): ParserOptions;
/**
 * Gets the name of `plugin`.
 *
 * @example
 *
 *   getPluginName('decorators');            // 'decorators'
 *   getPluginName(['flow', { all: true }]); // 'flow'
 */
export declare function getPluginName(plugin: ParserPlugin): ParserPluginName;
