import { AbstractAdapter, AbstractReader } from "@ui5/fs";
import { LintMessageSeverity, MESSAGE } from "./messages.js";
import { MessageArgs } from "./MessageArgs.js";
import { Directive } from "./ui5Types/directives.js";
export type FilePattern = string;
export type FilePath = string;
export type ResourcePath = string;
export interface LintResult {
    filePath: FilePath;
    messages: LintMessage[];
    coverageInfo: CoverageInfo[];
    errorCount: number;
    fatalErrorCount: number;
    warningCount: number;
}
export interface RawLintMessage<M extends MESSAGE = MESSAGE> {
    id: M;
    args: MessageArgs[M];
    position?: PositionInfo;
}
export interface LintMessage {
    ruleId: string;
    severity: LintMessageSeverity;
    message: string;
    messageDetails?: string;
    fatal?: boolean | undefined;
    line?: number | undefined;
    column?: number | undefined;
    endLine?: number | undefined;
    endColumn?: number | undefined;
}
export declare enum CoverageCategory {
    CallExpressionUnknownType = 1
}
export interface CoverageInfo {
    category: CoverageCategory;
    message: string;
    messageDetails?: string;
    line?: number | undefined;
    column?: number | undefined;
    endLine?: number | undefined;
    endColumn?: number | undefined;
}
export interface TranspileResult {
    source: string;
    map: string;
}
export interface LinterOptions {
    rootDir: string;
    filePatterns?: FilePattern[];
    ignorePatterns?: FilePattern[];
    coverage?: boolean;
    details?: boolean;
    configPath?: string;
    noConfig?: boolean;
    ui5Config?: string | object;
    namespace?: string;
}
export interface FSToVirtualPathOptions {
    relFsBasePath: string;
    virBasePath: string;
    relFsBasePathTest?: string;
    virBasePathTest?: string;
}
export interface LinterParameters {
    workspace: AbstractAdapter;
    filePathsWorkspace: AbstractAdapter;
    context: LinterContext;
}
export interface PositionInfo {
    line: number;
    column: number;
}
export interface PositionRange {
    start: PositionInfo;
    end?: PositionInfo;
}
export interface LintMetadata {
    directives: Set<Directive>;
    transformedImports: Map<string, Set<string>>;
}
export default class LinterContext {
    #private;
    constructor(options: LinterOptions);
    getRootDir(): string;
    setRootReader(rootReader: AbstractReader): void;
    getRootReader(): AbstractReader;
    getNamespace(): string | undefined;
    getReportCoverage(): boolean;
    getIncludeMessageDetails(): boolean;
    getMetadata(resourcePath: ResourcePath): LintMetadata;
    getRawLintingMessages(resourcePath: ResourcePath): RawLintMessage[];
    addLintingMessage<M extends MESSAGE>(resourcePath: ResourcePath, id: M, args: MessageArgs[M]): void;
    addLintingMessage<M extends MESSAGE>(resourcePath: ResourcePath, id: M, args: MessageArgs[M], position: PositionInfo): void;
    addLintingMessages<M extends MESSAGE>(resourcePath: ResourcePath, rawMessages: RawLintMessage<M>[]): void;
    getCoverageInfo(resourcePath: ResourcePath): CoverageInfo[];
    addCoverageInfo(resourcePath: ResourcePath, coverageInfo: CoverageInfo): void;
    generateLintResult(resourcePath: ResourcePath): LintResult;
    generateLintResults(): LintResult[];
}
