"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tupleOf = exports.TupleOfMatcher = void 0;
const Matcher_1 = require("./Matcher");
class TupleOfMatcher extends Matcher_1.Matcher {
    constructor(...matchers) {
        super();
        this.matchers = matchers;
    }
    matchValue(value, keys) {
        if (!Array.isArray(value)) {
            return false;
        }
        if (value.length !== this.matchers.length) {
            return false;
        }
        for (let i = 0; i < this.matchers.length; i++) {
            const matcher = this.matchers[i];
            const element = value[i];
            if (!matcher.matchValue(element, [...keys, i])) {
                return false;
            }
        }
        return true;
    }
}
exports.TupleOfMatcher = TupleOfMatcher;
function tupleOf(...matchers) {
    return new TupleOfMatcher(...matchers);
}
exports.tupleOf = tupleOf;
//# sourceMappingURL=tupleOf.js.map