"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.spacer = exports.slice = exports.oneOrMore = exports.zeroOrMore = exports.SliceMatcher = void 0;
const Matcher_1 = require("./Matcher");
const anything_1 = require("./anything");
class SliceMatcher extends Matcher_1.Matcher {
    constructor(min, max, matcher) {
        super();
        this.min = min;
        this.max = max;
        this.matcher = matcher;
    }
    matchValue(value, keys) {
        return this.matcher.matchValue(value, keys);
    }
}
exports.SliceMatcher = SliceMatcher;
/**
 * Match zero or more elements. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo', 1]` and `['foo', 'bar', 2]` and `['foo', 'bar', 'baz', 3]` but not `['foo']` or `['foo', 'bar']`
 * m.anyList([m.anyString(), m.zeroOrMore(), m.anyNumber()])
 * ```
 */
function zeroOrMore(matcher = (0, anything_1.anything)()) {
    return new SliceMatcher(0, Infinity, matcher);
}
exports.zeroOrMore = zeroOrMore;
/**
 * Match one or more elements. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo']` and `['foo', 'bar']` but not `[]`
 * m.anyList([m.oneOrMore()])
 * ```
 */
function oneOrMore(matcher = (0, anything_1.anything)()) {
    return new SliceMatcher(1, Infinity, matcher);
}
exports.oneOrMore = oneOrMore;
/**
 * Match a slice of an array. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo', 'bar', 'baz']` but not `['foo']` or `['foo', 'bar', 'baz', 'qux']`
 * m.anyList([m.anyString(), m.slice({ min: 1, max: 2 })])
 * ```
 */
function slice(optionsOrLength, matcherOrUndefined) {
    var _a, _b, _c;
    let min;
    let max;
    let matcher;
    if (typeof optionsOrLength === 'number') {
        min = optionsOrLength;
        max = optionsOrLength;
        matcher = matcherOrUndefined !== null && matcherOrUndefined !== void 0 ? matcherOrUndefined : (0, anything_1.anything)();
    }
    else if (typeof optionsOrLength === 'object' &&
        typeof matcherOrUndefined === 'undefined') {
        min = (_a = optionsOrLength.min) !== null && _a !== void 0 ? _a : 0;
        max = (_b = optionsOrLength.max) !== null && _b !== void 0 ? _b : Infinity;
        matcher = (_c = optionsOrLength.matcher) !== null && _c !== void 0 ? _c : (0, anything_1.anything)();
    }
    else {
        throw new Error('Invalid arguments');
    }
    return new SliceMatcher(min, max, matcher);
}
exports.slice = slice;
/**
 * @deprecated Use `slice` instead.
 */
function spacer(min = 1, max = min) {
    return new SliceMatcher(min, max, (0, anything_1.anything)());
}
exports.spacer = spacer;
//# sourceMappingURL=slice.js.map