"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromCapture = exports.FromCaptureMatcher = void 0;
const utils_1 = require("@codemod/utils");
const Matcher_1 = require("./Matcher");
class FromCaptureMatcher extends Matcher_1.Matcher {
    constructor(capturedMatcher) {
        super();
        this.capturedMatcher = capturedMatcher;
    }
    matchValue(value) {
        if (utils_1.t.isNode(this.capturedMatcher.current) && utils_1.t.isNode(value)) {
            return (0, utils_1.nodesEquivalent)(this.capturedMatcher.current, value);
        }
        return this.capturedMatcher.current === value;
    }
}
exports.FromCaptureMatcher = FromCaptureMatcher;
function fromCapture(capturedMatcher) {
    return new FromCaptureMatcher(capturedMatcher);
}
exports.fromCapture = fromCapture;
//# sourceMappingURL=fromCapture.js.map