![SAPUI5](https://ui5.sap.com/resources/sap/ui/documentation/sdk/images/Logo_B_SAPUI5_H.png)

# @sapui5/types

This npm package contains the TypeScript type definitions based on ES modules for all the SAPUI5 libraries. Read [below](#usage) and at the main [UI5 & TypeScript documentation](https://sap.github.io/ui5-typescript) how to use them.

These definitions can be used to:

1. Enable advanced content assist in IDEs, e.g: (VSCode / IntelliJ / Webstorm) for SAPUI5.
1. Integrate type checking for SAPUI5 applications using the TypeScript compiler.

These capabilities are available not only for SAPUI5 apps written in TypeScript, but to some degree also [in JavaScript](https://github.com/SAP-samples/ui5-cap-event-app/blob/js-with-typescript-support/README.md).

<b>NOTE:</b> "<i>based on ES modules</i>" means that the application code needs to load UI5 modules using the ES6 modules syntax and needs to be transformed to standard UI5 require/define syntax before it is executed. This is the recommended approach!


## Usage

The central entry point for all information about using UI5 with TypeScript (incl. sample apps and templates) is https://sap.github.io/ui5-typescript.

The [UI5 TypeScript tutorial](https://github.com/SAP-samples/ui5-typescript-tutorial) gives the best end-to-end impression of UI5 application and control development in TypeScript. The above and below links lead to further details about certain aspects.

To see the suggested project setup for TypeScript development, please check out the [TypeScript Hello World app](https://github.com/SAP-samples/ui5-typescript-helloworld). It not only can serve as copy template, but also includes a [detailed step-by-step guide](https://github.com/SAP-samples/ui5-typescript-helloworld/blob/main/step-by-step.md) for creating this setup from scratch.

The [TypeScript branch of the "UI5 CAP Event App"](https://github.com/SAP-samples/ui5-cap-event-app/tree/typescript) sample demonstrates a more complex application using the same setup. It comes with an [explanation](https://github.com/SAP-samples/ui5-cap-event-app/blob/typescript/docs/typescript.md) of what UI5 TypeScript code usually looks like and what to consider when writing such code.

For quick and easy scaffolding of a new UI5 app written in TypeScript, you can use the easy-ui5 tool with the [generator-ui5-ts-app](https://github.com/ui5-community/generator-ui5-ts-app) generator.


## Status

We encourage you to use SAPUI5 with TypeScript productively for an improved development efficiency and experience. TypeScript itself keeps evolving and we try to further improve the UI5 type definitions, so there could be potential incompatible changes between versions of the type definitions. However, such incompatibilities would only affect the compilation of your code but will not cause runtime issues in your application. Plus, there are various ways to easily deal with them: you can, for example, simply keep using the previous version of the UI5 type definitions together with an updated UI5 runtime.

For news related to the type definitions, in particular ones which require adaptation, please refer to the [Release Notes](https://sap.github.io/ui5-typescript/releasenotes.html).

## License
This package is provided under the terms of the [SAP Developer License Agreement](https://tools.hana.ondemand.com/developer-license-3_2.txt).
