import { Attribute, PositionDetail, Tag as SaxTag } from "sax-wasm";
import { ChangeSet } from "../../../utils/textChanges.js";
import { HtmlFix } from "./HtmlFix.js";
import { ToPositionCallback } from "../../ui5Types/fix/XmlEnabledFix.js";
/**
 * Fix to remove an attribute from an HTML tag.
 * @param tag The surrounding tag from which the attribute should be removed.
 * @param attr The attribute to be removed.
 */
export default class RemoveAttributeFix extends HtmlFix {
    private startPositionDetail;
    private endPositionDetail;
    constructor(tag: SaxTag, attr: Attribute);
    /**
     * This will prepare the start pos of the removal.
     * This is needed to ensure there are no empty lines or whitespaces left after removal.
     */
    _calculateStartPos(tag: SaxTag, attr: Attribute): PositionDetail;
    /**
     * This will prepare the end pos of the removal.
     */
    _calculateEndPos(attr: Attribute): PositionDetail;
    calculateSourceCodeRange(toPosition: ToPositionCallback): void;
    generateChanges(): ChangeSet;
    _getEdgeCaseStartPos(tag: SaxTag, previousAttr: Attribute | undefined, attr: Attribute, subsequentAttr: Attribute): PositionDetail | undefined;
}
