/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class ESLintMessages
extends DataTable<Row> {
    public ESLintMessages(Recipe recipe) {
        super(recipe, "ESLint messages", "Errors and warnings as reported by ESLint.");
    }

    public static enum Severity {
        Warning,
        Error;


        public static Severity of(int severity) {
            return severity == 1 ? Warning : Error;
        }
    }

    public static final class Row {
        @Column(displayName="Source Path", description="The source path of the file.")
        private final String sourcePath;
        @Column(displayName="Rule ID", description="ESLint Rule ID.")
        private final String ruleId;
        @Column(displayName="Severity", description="Either `Warning` or `Error`.")
        private final Severity severity;
        @Column(displayName="Fatal", description="Is this a fatal error (like a parse error).")
        private final boolean fatal;
        @Column(displayName="Message", description="The message created by the rule.")
        private final String message;
        @Column(displayName="Line", description="Line in source file this message pertains to.")
        private final int line;
        @Column(displayName="Column", description="Column in source file this message pertains to.")
        private final int column;

        @Generated
        public Row(String sourcePath, String ruleId, Severity severity, boolean fatal, String message, int line, int column) {
            this.sourcePath = sourcePath;
            this.ruleId = ruleId;
            this.severity = severity;
            this.fatal = fatal;
            this.message = message;
            this.line = line;
            this.column = column;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getRuleId() {
            return this.ruleId;
        }

        @Generated
        public Severity getSeverity() {
            return this.severity;
        }

        @Generated
        public boolean isFatal() {
            return this.fatal;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public int getLine() {
            return this.line;
        }

        @Generated
        public int getColumn() {
            return this.column;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isFatal() != other.isFatal()) {
                return false;
            }
            if (this.getLine() != other.getLine()) {
                return false;
            }
            if (this.getColumn() != other.getColumn()) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$ruleId = this.getRuleId();
            String other$ruleId = other.getRuleId();
            if (this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId)) {
                return false;
            }
            Severity this$severity = this.getSeverity();
            Severity other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFatal() ? 79 : 97);
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $ruleId = this.getRuleId();
            result = result * 59 + ($ruleId == null ? 43 : $ruleId.hashCode());
            Severity $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ESLintMessages.Row(sourcePath=" + this.getSourcePath() + ", ruleId=" + this.getRuleId() + ", severity=" + (Object)((Object)this.getSeverity()) + ", fatal=" + this.isFatal() + ", message=" + this.getMessage() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ")";
        }
    }
}

