// For Library Version: 1.136.12

declare module "sap/ushell/library" {
  /**
   * Denotes the types of the content nodes.
   *
   * This enum is part of the 'sap/ushell/library' module export and must be accessed by the property 'ContentNodeType'.
   */
  export enum ContentNodeType {
    /**
     * A group of the classic homepage
     *
     * @deprecated As of version 1.120.
     */
    HomepageGroup = "HomepageGroup",
    /**
     * A page which is assigned to a space in spaces mode
     */
    Page = "Page",
    /**
     * A space in spaces mode
     */
    Space = "Space",
    /**
     * A visualization which is assigned to a space in spaces mode
     */
    Visualization = "Visualization",
  }
  /**
   * The state of a navigation operation
   *
   * This enum is part of the 'sap/ushell/library' module export and must be accessed by the property 'NavigationState'.
   *
   * @deprecated As of version 1.136.
   */
  export enum NavigationState {
    Finished = "Finished",

    InProgress = "InProgress",
  }

  export namespace ui {
    namespace launchpad {
      /**
       * Denotes display states of the viewport
       *
       * This enum is part of the 'sap/ushell/library' module export and must be accessed by the property 'ui.launchpad.ViewPortState'.
       *
       * @deprecated As of version 1.120. The ViewPortState is related to Fiori2 and not used anymore.
       */
      enum ViewPortState {
        /**
         * Indicates state, when only center content is in the viewport.
         */
        Center = "Center",
        /**
         * Indicates state, when the center content as well as a part from the left content is in the viewport.
         */
        CenterLeft = "CenterLeft",
        /**
         * Indicates state, when the center content as well as a part from the right content is in the viewport.
         */
        CenterRight = "CenterRight",
        /**
         * Indicates state, when only left content is in the viewport.
         */
        Left = "Left",
        /**
         * Indicates state, when the left content as well as a part from the center content is in the viewport.
         */
        LeftCenter = "LeftCenter",
        /**
         * Indicates state, when only right content is in the viewport.
         */
        Right = "Right",
        /**
         * Indicates state, when the right content as well as a part from the center content is in the viewport.
         */
        RightCenter = "RightCenter",
      }
    }
  }
}

declare module "sap/ushell/components/factsheet/controls/PictureTile" {
  import { default as CustomTile, $CustomTileSettings } from "sap/m/CustomTile";

  import Event from "sap/ui/base/Event";

  import { CSSSize, ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import PictureViewerItem from "sap/ushell/components/factsheet/controls/PictureViewerItem";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Tile control embedding an image and allowing custom sizing
   *
   * @deprecated As of version 1.22. Please use {@link sap.m.Carousel} instead.
   *
   * PictureTile is used in PictureViewer control and is not meant to be consumed outside of PictureViewer
   * usage. PictureViewer was replacing the sap.m.Carousel as it wasn't supporting some versions of MS Internet
   * Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel instead. This control
   * will not be supported anymore.
   */
  export default class PictureTile extends CustomTile {
    /**
     * Constructor for a new components/factsheet/controls/PictureTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureTileSettings
    );
    /**
     * Constructor for a new components/factsheet/controls/PictureTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureTileSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.components.factsheet.controls.PictureTile with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.CustomTile.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.components.factsheet.controls.PictureTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDelete pictureDelete} event of this `sap.ushell.components.factsheet.controls.PictureTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.components.factsheet.controls.PictureTile` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDelete(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.components.factsheet.controls.PictureTile`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDelete pictureDelete} event of this `sap.ushell.components.factsheet.controls.PictureTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.components.factsheet.controls.PictureTile` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDelete(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.components.factsheet.controls.PictureTile`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pictureDelete pictureDelete} event of this
     * `sap.ushell.components.factsheet.controls.PictureTile`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPictureDelete(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:pictureDelete pictureDelete} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePictureDelete(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Default value is `"32px"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * ID of the element which is the current target of the association {@link #getTileContent tileContent},
     * or `null`.
     */
    getTileContent(): ID | null;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Default value is `"32px"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"32px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Reference to one PictureViewerItem coming from the PictureViewer.
     *
     *
     * @returns `this` to allow method chaining
     */
    setTileContent(
      /**
       * Id of an element which becomes the new target of this `tileContent` association. Alternatively, an element
       * instance may be given.
       */
      vTileContent: string | PictureViewerItem
    ): PictureTile;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"32px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PictureTile constructor.
   *
   * @deprecated As of version 1.22. Please use {@link sap.m.Carousel} instead.
   *
   * PictureTile is used in PictureViewer control and is not meant to be consumed outside of PictureViewer
   * usage. PictureViewer was replacing the sap.m.Carousel as it wasn't supporting some versions of MS Internet
   * Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel instead. This control
   * will not be supported anymore.
   */
  export interface $PictureTileSettings extends $CustomTileSettings {
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    tileContent?: PictureViewerItem | string;

    pictureDelete?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the PictureTile#pictureDelete event.
   */
  export interface PictureTile$PictureDeleteEventParameters {}

  /**
   * Event object of the PictureTile#pictureDelete event.
   */
  export type PictureTile$PictureDeleteEvent = Event<
    PictureTile$PictureDeleteEventParameters,
    PictureTile
  >;
}

declare module "sap/ushell/components/factsheet/controls/PictureViewer" {
  import {
    default as TileContainer,
    $TileContainerSettings,
  } from "sap/m/TileContainer";

  import PictureViewerItem from "sap/ushell/components/factsheet/controls/PictureViewerItem";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Picture viewer control relying on the TileContainer control
   *
   * @deprecated As of version 1.22. Please use {@link sap.m.Carousel} instead. PictureViewer was replacing
   * the Carousel as it wasn't supporting some versions of MS Internet Explorer. Now, the sap.m.Carousel is
   * fully functional, please use sap.m.Carousel instead. This control will not be supported anymore.
   */
  export default class PictureViewer extends TileContainer {
    /**
     * Constructor for a new components/factsheet/controls/PictureViewer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerSettings
    );
    /**
     * Constructor for a new components/factsheet/controls/PictureViewer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.components.factsheet.controls.PictureViewer with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.TileContainer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureViewer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.components.factsheet.controls.PictureViewer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item `oItem` to the aggregation named `items`. Deprecated, use aggregation "tiles".
     *
     * @deprecated As of version 1.18.
     *
     * @returns `this` to allow method chaining
     */
    addItem(
      /**
       * the item to add; if empty, nothing is inserted
       */
      oItem: PictureViewerItem
    ): PictureViewer;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDeleted pictureDeleted} event of this
     * `sap.ushell.components.factsheet.controls.PictureViewer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.components.factsheet.controls.PictureViewer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDeleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.components.factsheet.controls.PictureViewer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDeleted pictureDeleted} event of this
     * `sap.ushell.components.factsheet.controls.PictureViewer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.components.factsheet.controls.PictureViewer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDeleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.components.factsheet.controls.PictureViewer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Removes the picture at index `iIndex` from the `items` aggregation.
     *
     *
     * @returns `this` to allow method chaining
     */
    deletePicture(
      /**
       * the `0`-based index of the picture collection to delete; if `iIndex` is out of range or empty, the current
       * image will be deleted.
       */
      iIndex: int
    ): PictureViewer;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pictureDeleted pictureDeleted} event of this
     * `sap.ushell.components.factsheet.controls.PictureViewer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPictureDeleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:pictureDeleted pictureDeleted} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePictureDeleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets the current picture index.
     *
     *
     * @returns the current picture index
     */
    getCurrentPictureIndex(): PictureViewer;
    /**
     * Gets content of aggregation {@link #getItems items}.
     */
    getItems(): PictureViewerItem[];
    /**
     * Gets current value of property {@link #getRemovable removable}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `removable`
     */
    getRemovable(): boolean;
    /**
     * Gets current value of property {@link #getTileScaling tileScaling}.
     *
     * Percentage of the space occupied by the image in the picture viewer control. Please note that if the
     * factor is too close to 1, the navigation arrows usually displayed in desktop mode will not be available
     *
     * Default value is `0.95`.
     *
     *
     * @returns Value of property `tileScaling`
     */
    getTileScaling(): float;
    /**
     * Checks for the provided `sap.ushell.components.factsheet.controls.PictureViewerItem` in the aggregation
     * {@link #getItems items}. and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: PictureViewerItem
    ): int;
    /**
     * Inserts a item into the aggregation named `items`. When adding a new item to the aggregation, a sap.ca.ui.PictureTile
     * is actually created with its own ID and added to the internal TileContainer. Deprecated, use aggregation
     * "tiles".
     *
     * @deprecated As of version 1.18.
     *
     * @returns `this` to allow method chaining
     */
    insertItem(
      /**
       * the item to insert; if empty, nothing is inserted
       */
      oItem: PictureViewerItem,
      /**
       * the `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): PictureViewer;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): PictureViewerItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | PictureViewerItem
    ): PictureViewerItem | null;
    /**
     * Select the picture at index `iIndex` from the `items` aggregation.
     *
     *
     * @returns `this` to allow method chaining
     */
    selectPicture(
      /**
       * the `0`-based index of the aggregation to select; for a negative value of `iIndex`, the picture at position
       * 0 is selected; for a value greater than the current size of the aggregation, the selected picture at
       * the last position is selected
       */
      iIndex: int
    ): PictureViewer;
    /**
     * Sets a new value for property {@link #getRemovable removable}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRemovable(
      /**
       * New value for property `removable`
       */
      bRemovable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTileScaling tileScaling}.
     *
     * Percentage of the space occupied by the image in the picture viewer control. Please note that if the
     * factor is too close to 1, the navigation arrows usually displayed in desktop mode will not be available
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.95`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileScaling(
      /**
       * New value for property `tileScaling`
       */
      fTileScaling?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PictureViewer constructor.
   *
   * @deprecated As of version 1.22. Please use {@link sap.m.Carousel} instead. PictureViewer was replacing
   * the Carousel as it wasn't supporting some versions of MS Internet Explorer. Now, the sap.m.Carousel is
   * fully functional, please use sap.m.Carousel instead. This control will not be supported anymore.
   */
  export interface $PictureViewerSettings extends $TileContainerSettings {
    /**
     * Percentage of the space occupied by the image in the picture viewer control. Please note that if the
     * factor is too close to 1, the navigation arrows usually displayed in desktop mode will not be available
     */
    tileScaling?: float | PropertyBindingInfo | `{${string}}`;

    removable?: boolean | PropertyBindingInfo | `{${string}}`;

    items?:
      | PictureViewerItem[]
      | PictureViewerItem
      | AggregationBindingInfo
      | `{${string}}`;

    pictureDeleted?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the PictureViewer#pictureDeleted event.
   */
  export interface PictureViewer$PictureDeletedEventParameters {}

  /**
   * Event object of the PictureViewer#pictureDeleted event.
   */
  export type PictureViewer$PictureDeletedEvent = Event<
    PictureViewer$PictureDeletedEventParameters,
    PictureViewer
  >;
}

declare module "sap/ushell/components/factsheet/controls/PictureViewerItem" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Image from "sap/m/Image";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Picture viewer control relying on the TileContainer control
   *
   * @deprecated As of version 1.22. Please use {@link sap.m.Carousel} instead. PictureViewerItem is used
   * in PictureViewer control and is not meant to be consumed outside of PictureViewer usage. PictureViewer
   * was replacing the Carousel as it wasn't supporting some versions of MS Internet Explorer. Now, the sap.m.Carousel
   * is fully functional, please use sap.m.Carousel instead. This control will not be supported anymore.
   */
  export default class PictureViewerItem extends Control {
    /**
     * Constructor for a new components/factsheet/controls/PictureViewerItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerItemSettings
    );
    /**
     * Constructor for a new components/factsheet/controls/PictureViewerItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerItemSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.components.factsheet.controls.PictureViewerItem with name
     * `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureViewerItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.components.factsheet.controls.PictureViewerItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the image in the aggregation {@link #getImage image}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyImage(): this;
    /**
     * Gets content of aggregation {@link #getImage image}.
     */
    getImage(): Image;
    /**
     * Gets current value of property {@link #getSrc src}.
     *
     *
     * @returns Value of property `src`
     */
    getSrc(): string;
    /**
     * Sets the aggregated {@link #getImage image}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImage(
      /**
       * The image to set
       */
      oImage: Image
    ): this;
    /**
     * Setter for property `src`.
     *
     * Default value is empty/`undefined`
     *
     *
     * @returns `this` to allow method chaining
     */
    setSrc(
      /**
       * new value for property `src`
       */
      sSrc: string
    ): PictureViewerItem;
  }
  /**
   * Describes the settings that can be provided to the PictureViewerItem constructor.
   *
   * @deprecated As of version 1.22. Please use {@link sap.m.Carousel} instead. PictureViewerItem is used
   * in PictureViewer control and is not meant to be consumed outside of PictureViewer usage. PictureViewer
   * was replacing the Carousel as it wasn't supporting some versions of MS Internet Explorer. Now, the sap.m.Carousel
   * is fully functional, please use sap.m.Carousel instead. This control will not be supported anymore.
   */
  export interface $PictureViewerItemSettings extends $ControlSettings {
    src?: string | PropertyBindingInfo;

    image?: Image;
  }
}

declare module "sap/ushell/Container" {
  import System from "sap/ushell/System";

  import Control from "sap/ui/core/Control";

  import ComponentContainer from "sap/ui/core/ComponentContainer";

  import Component from "sap/ui/core/Component";

  /**
   * The Unified Shell's container. Manages renderers, services, and adapters. The container is designed to
   * be a singleton, therefore instead of creating an instance, access the central one via
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     // do something with the container
   *   });
   * ```
   *
   *
   * @since 1.15.0
   */
  interface Container {
    /**
     * An enumeration for the application work protect mode state.
     *
     * @since 1.21.1
     */
    DirtyState: DirtyState;

    /**
     * Adds a system to the list of remote systems currently in use. On logout this list is processed and performs
     * a logout for each system via the ContainerAdapter specific for its platform.
     *
     * @since 1.15.0
     */
    addRemoteSystem(
      /**
       * Remote system to be added.
       */
      oRemoteSystem: System
    ): void;
    /**
     * Attaches a listener to the logout event. In case the bAsyncFunction parameter is true, the fnFunction
     * must return a promise. FLP will wait for the promise to be resolved before doing the actual logout.
     *
     * @since 1.19.1
     */
    attachLogoutEvent(
      /**
       * Event handler to be attached.
       */
      fnFunction: Function,
      /**
       * Whether the function returns a Promise to wait for its resolvent (since 1.81.0).
       */
      bAsyncFunction: boolean
    ): void;
    /**
     * Attaches a listener to the rendererCreated event.
     *
     * @since 1.34.1
     * @deprecated As of version 1.120.
     */
    attachRendererCreatedEvent(
      /**
       * Event handler to be attached. If a renderer is created, this function is called with a parameter of instance
       * `sap.ui.base.Event`. The event object provides the instance of the created renderer as parameter "renderer".
       * If the renderer is a SAPUI5 UI component (i.e. extend `sap.ui.core.UIComponent`), the event parameter
       * returns the component instance, i.e. it unwraps the renderer component from its component container.
       */
      fnFunction: Function
    ): void;
    /**
     * Cancels the logon procedure in the current frame, if any. This MUST be used by the logon frame provider
     * in case the user wants to close the logon frame for good. It will report "Authentication cancelled" and
     * let all pending requests for the current realm fail. As a side-effect, it also calls `destroy` on the
     * logon frame provider.
     * See:
     * 	sap.ushell.Container#setLogonFrameProvider
     *
     * @since 1.21.2
     * @deprecated As of version 1.120.
     */
    cancelLogon(): void;
    /**
     * Creates a new renderer instance for the given renderer name.
     *
     * Names without a dot are interpreted as package names within the default naming convention and will be
     * expanded to `"sap.ushell.renderers." + sRendererName + ".Renderer"`. Names containing a dot are used
     * "as is".
     *
     * The resulting name must point to a SAPUI5 object which is first required and then instantiated (without
     * arguments). The object is expected to be a UI component (i.e. extend `sap.ui.core.UIComponent`), which
     * is then automatically wrapped into a `sap.ui.core.ComponentContainer` control by this method. The `sap.ui.core.ComponentContainer`
     * is created with `height` and `width` set to "100%" to accommodate the complete available space. Besides
     * UIComponents a control (i.e. extend `sap.ui.core.Control`) is accepted, too.
     *
     * The returned renderer is supposed to be added to a direct child (for example `div`) of the `body` of
     * the page and there should be no other parts of the page consuming space outside the renderer. Use CSS
     * class `sapUShellFullHeight` at `html`, `body` and at the element to which the renderer is added to allow
     * the renderer to use 100% height.
     *
     * @since 1.15.0
     * @deprecated As of version 1.120.
     *
     * @returns the renderer or Promise (in asynchronous mode)
     */
    createRenderer(
      /**
       * The renderer name, such as "standard" or "acme.foo.bar.MyRenderer"; it is taken from the configuration
       * property `defaultRenderer` if not given here.
       */
      sRendererName?: string,
      /**
       * If `true`, the renderer is created asynchronously and a `Promise` is returned.
       */
      bAsync?: boolean
    ):
      | Control
      | Promise<Control>
      | ComponentContainer
      | Promise<ComponentContainer>;
    /**
     * Deregister the work protection dirty callback function. See registerDirtyStateProvider for more information.
     * Only the last registered function will be deregistered (in case it was registered multiple times).
     *
     * @since 1.67.0
     */
    deregisterDirtyStateProvider(
      /**
       * function for determining the state of the application
       */
      fnDirty: () => boolean
    ): void;
    /**
     * Detaches a listener from the logout event.
     *
     * @since 1.19.1
     */
    detachLogoutEvent(
      /**
       * Event handler to be detached.
       */
      fnFunction: Function
    ): void;
    /**
     * Detaches a listener from the rendererCreated event.
     *
     * @since 1.34.1
     * @deprecated As of version 1.120.
     */
    detachRendererCreatedEvent(
      /**
       * Event handler to be detached.
       */
      fnFunction: Function
    ): void;
    /**
     * If the dirty state was set to 'false' using 'setDirtyFlag' the registered dirty state provider methods
     * get called to determine the actual dirty state. The determined dirty state is then returned.
     *
     * However, if the dirty state was previously set to 'true' using 'setDirtyFlag' the registered dirty state
     * provider methods are ignored and the function simply returns 'true'.
     *
     * @since 1.27.0
     * @deprecated As of version 1.120.
     *
     * @returns The value of the dirty flag or the determined dirty state returned by the dirty state providers.
     */
    getDirtyFlag(): boolean;
    /**
     * Returns the global dirty state.
     *
     * All open UShell browser windows for the same origin are asked about their global dirty state.
     *
     * @since 1.21.1
     * @deprecated As of version 1.120.
     *
     * @returns Resolves the dirty state (see {@link sap.ushell.Container.DirtyState}).
     */
    getGlobalDirty(): jQuery.Promise;
    /**
     * Gets a renderer instance for the given renderer name, that was created by the createRenderer method.
     *
     * @since 1.30.0
     * @deprecated As of version 1.120. Use {@link sap.ushell.services.Extension} for shell extensions instead.
     *
     * @returns the renderer with the specified name; the returned object is either a control (i.e. extend `sap.ui.core.Control`)
     * or a UI component (i.e. extend `sap.ui.core.UIComponent`), i.e. this method unwraps the renderer component
     * from its `sap.ui.core.ComponentContainer`; if no renderer name can be determined and a single renderer
     * instance has been created, this single instance is returned.
     */
    getRenderer(
      /**
       * The renderer name, such as "standard" or "fiori2"; it is taken from the configuration property `defaultRenderer`
       * if not given here.
       */
      sRendererName?: string
    ): Control | Component;
    /**
     * Returns a service with the given name, creating it if necessary. Services are singleton objects identified
     * by their (resulting) name.
     *
     * Names without a dot are interpreted as service names within the default naming convention and will be
     * expanded to `"sap.ushell.services." + sServiceName`. Names containing a dot are not yet supported. This
     * name may be overridden via configuration. See example 2 below.
     *
     * The resulting name must point to a constructor function which is first required as a SAPUI5 module and
     * then called to create a service instance. The service will be passed to a corresponding service adapter
     * for the current logon system, as well as a callback interface (of virtual type `sap.ushell.services.ContainerInterface`)
     * to the container providing a method `createAdapter(oSystem)` to create further adapters for the same
     * service but connected to remote systems. The third parameter will be `sParameter` as passed to this function.
     * The fourth parameter will be an object with the property `config` supplied by the configuration. See
     * example 2 below.
     *
     * The adapter for the logon system will be created before the service. Its constructor gets three parameters.
     * The first parameter is the logon system, the second parameter is `sParameter` and the third parameter
     * is an object with the property `config` supplied by the configuration.
     *
     * The service may declare itself adapterless by setting the property `hasNoAdapter = true` at the constructor
     * function. In this case no adapter will be created and passed to the constructor and all other parameters
     * will be shifted.
     *
     * **Example 1:** The service `sap.ushell.services.UserInfo` is parameterless. It indicates this by setting
     * `sap.ushell.services.UserInfo.hasNoAdapter = true;`.
     *
     * **Example 2:** (Configuration)
     * ```javascript
     *
     *   window["sap-ushell-config"] = {
     *     services: {
     *       Foo: {
     *         module: "my.own.Foo"
     *         config: {header: "hidden"},
     *         adapter: {
     *           module: "my.own.FooAdapter",
     *           config: {foo: "bar"}
     *         }
     *       }
     *     }
     *   }
     *   sap.ushell.Container.getServiceAsync("Foo", "runtimeConfig")
     *       .then(function (Foo) {
     *           // Do something with the service
     *       });
     *   ```
     *  Now `oService` is an instance of `my.own.Foo`. The third parameter of the constructor will be "runtimeConfig",
     * the fourth parameter `{config: {header: "hidden"}}`. Its adapter is an instance of `my.own.FooAdapter`
     * constructed with the parameters logon system, "runtimeConfig" and `{config: {foo: "bar"}}`.
     *
     * Note that the api will throw a runtime error (or reject for async mode) if the service name does not
     * reflect a service available.
     * See:
     * 	sap.ushell.services.ContainerInterface
     *
     * @since 1.15.0
     * @deprecated As of version 1.77. Please use {@link #getServiceAsync} instead.
     *
     * @returns the service or, in asynchronous mode, a Promise that returns the service
     */
    getService<ServiceType extends sap.ushell.services.Service>(
      /**
       * The service name, such as "Menu"
       */
      sServiceName: string,
      /**
       * A parameter which is passed to the service constructor and every adapter constructor. (since 1.15.0)
       */
      sParameter?: string,
      /**
       * if true, the adapter is loaded asynchronously and a Promise is returned. (since 1.55.0)
       */
      bAsync?: boolean
    ): ServiceType | Promise<ServiceType>;
    /**
     * Returns a Promise that resolves a service with the given name, creating it if necessary. Services are
     * singleton objects identified by their (resulting) name.
     *
     * Names without a dot are interpreted as service names within the default naming convention and will be
     * expanded to `"sap.ushell.services." + sServiceName`. Names containing a dot are not yet supported. This
     * name may be overridden via configuration. See example 2 below.
     *
     * The resulting name must point to a constructor function which is first required as a SAPUI5 module and
     * then called to create a service instance. The service will be passed to a corresponding service adapter
     * for the current logon system, as well as a callback interface (of virtual type `sap.ushell.services.ContainerInterface`)
     * to the container providing a method `createAdapter(oSystem)` to create further adapters for the same
     * service but connected to remote systems. The third parameter will be `sParameter` as passed to this function.
     * The fourth parameter will be an object with the property `config` supplied by the configuration. See
     * example 2 below.
     *
     * The adapter for the logon system will be created before the service. Its constructor gets three parameters.
     * The first parameter is the logon system, the second parameter is `sParameter` and the third parameter
     * is an object with the property `config` supplied by the configuration.
     *
     * The service may declare itself adapterless by setting the property `hasNoAdapter = true` at the constructor
     * function. In this case no adapter will be created and passed to the constructor and all other parameters
     * will be shifted.
     *
     * **Example 1:** The service `sap.ushell.services.UserInfo` is parameterless. It indicates this by setting
     * `sap.ushell.services.UserInfo.hasNoAdapter = true;`.
     *
     * **Example 2:** (Configuration)
     * ```javascript
     *
     *   window["sap-ushell-config"] = {
     *     services: {
     *       Foo: {
     *         module: "my.own.Foo"
     *         config: {header: "hidden"},
     *         adapter: {
     *           module: "my.own.FooAdapter",
     *           config: {foo: "bar"}
     *         }
     *       }
     *     }
     *   }
     *   sap.ushell.Container.getServiceAsync("Foo", "runtimeConfig")
     *       .then(function (Foo) {
     *           // Do something with the service
     *       });
     *   ```
     *  Now the parameter provided in the promise handler is an instance of `my.own.Foo`. The third parameter
     * of the constructor will be "runtimeConfig", the fourth parameter `{config: {header: "hidden"}}`. Its
     * adapter is an instance of `my.own.FooAdapter` constructed with the parameters logon system, "runtimeConfig"
     * and `{config: {foo: "bar"}}`.
     * See:
     * 	sap.ushell.services.ContainerInterface
     *
     * @since 1.55.0
     *
     * @returns a Promise that returns the requested service
     */
    getServiceAsync<ServiceType extends sap.ushell.services.Service>(
      /**
       * The service name, such as "Menu"
       */
      sServiceName: string,
      /**
       * A parameter which is passed to the service constructor and every adapter constructor.
       */
      sParameter?: string
    ): Promise<ServiceType>;
    /**
     * Register the work protection dirty callback function. In the work protect mechanism, each platform can
     * register their own method in order to check if data was changed during the session, and notify the container
     * about the change. Registering multiple times the same function is allowed.
     *
     * Use `Function.prototype.bind()` to determine the callback's `this` or some of its arguments.
     *
     * @since 1.31.0
     */
    registerDirtyStateProvider(
      /**
       * Function for determining the state of the application. The callback is used to determine the current
       * dirty state during a navigation. The function must return a boolean which determines if the current application
       * is dirty or not. If `true` is returned the end user is prompted with a dialog where they need to confirm
       * the potential data loss. The callback is called with a navigation context as its first parameter which
       * can be used to determine the dirty state:
       * ```javascript
       *
       *  {
       *    status: "InProgress", // Enum which determines if a navigation currently takes place or if it is already finished. See sap.ushell.NavigationState.
       *    isCrossAppNavigation: true, // Boolean which indicates if the navigation is inner app our across two different applications.
       *    innerAppRoute: "&/SalesOrder/11" // If it is an inner app navigation, it describes the inner app route.
       *  }
       *  ```
       */
      fnDirty: () => boolean
    ): void;
    /**
     * Setter for the isDirty flag value.
     *
     * Default value is false
     *
     * @since 1.27.0
     */
    setDirtyFlag(
      /**
       * The value of the dirty flag.
       */
      bIsDirty?: boolean
    ): void;
  }
  const Container: Container;
  export default Container;

  /**
   * An enumeration for the application work protect mode state.
   *
   * @since 1.90.0
   */
  export type DirtyState = {
    /**
     * The embedded application is clean, there is no unsaved data.
     */
    CLEAN: "CLEAN";
    /**
     * The embedded application is dirty, the user has entered data that is not yet saved.
     */
    DIRTY: "DIRTY";
    /**
     * The embedded application container's dirty state cannot be determined because of technical reasons.
     */
    MAYBE_DIRTY: "MAYBE_DIRTY";
  };
}

declare module "sap/ushell/renderers/fiori2/Renderer" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import Control from "sap/ui/core/Control";

  import Bar from "sap/m/Bar";

  /**
   * The SAPUI5 component of SAP Fiori Launchpad renderer for the Unified Shell. This method MUST be called
   * by the Unified Shell's container only, others MUST call {@link sap.ushell.Container#getRenderer}.
   *
   * @since 1.15.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.Extension} instead.
   */
  export default class Renderer extends UIComponent {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
    /**
     * The launchpad states that can be passed as a parameter.
     *
     *
     * **Values:** App - launchpad state when running a Fiori app
     *  Home - launchpad state when the home page is open
     *
     *
     * @since 1.30
     */
    LaunchpadState: undefined;

    /**
     * Creates an action button in the User Actions Menu in the SAP Fiori launchpad, in the given launchpad
     * states (LaunchpadState).
     *
     *
     * **Example:**
     * ```javascript
     *
     * sap.ushell.Container.getRenderer("fiori2").addActionButton("sap.m.Button", {id: "testBtn2", text: "test button"}, true, true);
     * ```
     *
     *
     * This function is marked for deprecation as of version 1.48.
     *  It will continue to work as expected as long as one of the following conditions apply:
     *  1. The control instance is already created and its ID is included in the input parameter oControlProperties
     *  2. The control type resource is already loaded
     * See:
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState
     *   If no launchpad state is provided, the content is added in all states.
     *
     * @since 1.30
     * @deprecated As of version 1.48. Please use {@link #addUserAction} instead.
     *
     * @returns oItem - the created control
     */
    addActionButton(
      /**
       * The (class) name of the control type to create.
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control.
       */
      oControlProperties: object,
      /**
       * Specify whether to display the control. If true, the control is displayed (calls the showActionButton
       * method) according to the bCurrentState and aStates parameters. If false, the control is created but not
       * displayed (you can use showActionButton to display the control when needed).
       */
      bIsVisible: boolean,
      /**
       * If true, add the current control only to the current rendered shell state. Once the user navigates to
       * another app or back to the home page, this control will be removed.
       */
      bCurrentState: boolean,
      /**
       * List of the launchpad states (sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which to add the
       * control. Valid only if bCurrentState is set to false.
       */
      aStates: string[]
    ): Control;
    /**
     * Adds the given sap.ui.core.Control to the EndUserFeedback dialog.
     *  The EndUserFeedback dialog is opened via the user actions menu in the Fiori Launchpad shell header.
     *
     * @since 1.30
     * @deprecated As of version 1.93.
     */
    addEndUserFeedbackCustomUI(
      /**
       * The control to be added to the EndUserFeedback dialog.
       */
      oCustomUIContent: object,
      /**
       * Specify whether to display the control.
       */
      bShowCustomUIContent: boolean
    ): void;
    /**
     * Creates a FloatingActionButton in Fiori launchpad, in the given launchpad states.
     *  The FloatingActionButton is rendered in the bottom right corner of the shell.
     *
     *
     * **Example:**
     * ```javascript
     *
     * sap.ushell.Container.getRenderer("fiori2").addFloatingActionButton("sap.ushell.ui.shell.ShellFloatingAction", {id: "testBtn"}, true, true);
     * ```
     *
     *
     * This function is marked for deprecation as of version 1.48.
     *  It will continue to work as expected as long as one of the following conditions apply:
     *  1. The control instance is already created and its ID is included in the input parameter oControlProperties
     *  2. The control type resource is already loaded
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is added in all states.
     *
     * @since 1.30
     * @deprecated As of version 1.48. Please use {@link #addFloatingButton} instead.
     *
     * @returns oItem - the created control
     */
    addFloatingActionButton(
      /**
       * The (class) name of the control type to create.
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control.
       */
      oControlProperties: object,
      /**
       * Specify whether to display the control.
       */
      bIsVisible: boolean,
      /**
       * If true, add the current control only to the current rendered shell state. Once the user navigates to
       * another app or back to the Home page, this control will be removed.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
       * in which to add the control.
       */
      aStates: string[]
    ): object;
    /**
     * Creates a FloatingActionButton in Fiori launchpad, in the given launchpad states.
     *  The FloatingActionButton is rendered in the bottom right corner of the shell.
     *
     *
     * **Example:**
     * ```javascript
     *
     * sap.ushell.Container.getRenderer("fiori2").addFloatingActionButton("sap.ushell.ui.shell.ShellFloatingAction", {id: "testBtn"}, true, true);
     * ```
     *
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is added in all states.
     *
     * @since 1.48
     * @deprecated As of version 1.52.
     *
     * @returns Resolves with the newly created control
     */
    addFloatingButton(
      /**
       * Contains the required parameters for creating and showing the new control object:
       *  Properties:
       *  - {string} controlType
       *  The (class) name of the control type to create.
       *  - {object} oControlProperties
       *  The properties that will be passed to the created control.
       *  - {boolean} bIsVisible
       *  Specify whether to display the control.
       *  - {boolean} bCurrentState
       *  If true, add the current control only to the current rendered shell state.
       *  Once the user navigates to another app or back to the Home page, this control will be removed.
       *  - {string[]} aStates
       *  (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
       * in which to add the control.
       */
      oParameters: object
    ): jQuery.Promise;
    /**
     * Creates and displays a shell header icon in Fiori launchpad, in the given launchpad states.
     *  The icon is displayed in the right side of the Fiori Launchpad shell header or in an overflow menu.
     *  The text property is mandatory as it might be used in the overflow menu.
     *  The tooltip property must not have the same text as the text property, as this causes accessibility
     * issues if the item is in the overflow menu.
     *  If no tooltip is provided, the text property is shown as tooltip when the item is not in the overflow
     * menu.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     *
     *     // Create an icon button that opens a dialog
     *     oRenderer.addHeaderEndItem({
     *         id: "myTestButton",
     *         icon: "sap-icon://action-settings",
     *         tooltip: resources.i18n.getText("testButton.tooltip"),
     *         text: resources.i18n.getText("testButton.text"),
     *         ariaLabel: resources.i18n.getText("testButton.ariaLabel"),
     *         ariaHaspopup: "dialog",
     *         press: [myController.handleTestButtonPress, myController]
     *     }, true);
     *
     *     // Create a temporary link
     *     oRenderer.addHeaderEndItem({
     *         id: "myTestLink",
     *         ariaLabel: resources.i18n.getText("testLink.label"),
     *         target: "#MyTestApplication-show",
     *         icon: "sap-icon://overflow"
     *     }, true, true);
     * ```
     *
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is added in all states.
     *
     * @since 1.30
     *
     * @returns oItem - the created control
     */
    addHeaderEndItem(
      /**
       * The (class) name of the control type to create. **Deprecated**: Since version 1.38. This parameter is
       * no longer supported and can be omitted.
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control. The object may contain the following properties:
       *
       * 	{string} [id] - The ID of the object.
       *  {string} icon - The button icon source.
       *  {string} [text] - The button text. It is only rendered in the overflow popover but not in the shell
       * header.
       *  {string} [target] - target URI for a navigation link.
       *  {string} [ariaLabel] - Accessibility: aria-label attribute.
       *  {string} [ariaHaspopup] - Accessibility: aria-haspopup attribute.
       *  {Function} [press] - A function to be called when the button is depressed.
       */
      oControlProperties: object,
      /**
       * Specify whether to display the control.
       */
      bIsVisible: boolean,
      /**
       * If true, add the current control only to the current rendered shell state. Once the user navigates to
       * another app or back to the Home page, this control will be removed.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
       * in which to add the control.
       */
      aStates: string[]
    ): Control;
    /**
     * Creates and displays an item in the header of Fiori launchpad, in the given launchpad states.
     *  The new header item will be displayed on the left-hand side of the Fiori Launchpad shell header, according
     * to the given display parameters.
     *  The new header item will be added to the right of any existing header items. The header can contain
     * a maximum of three header items.
     *
     *
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     *     oRenderer.addHeaderItem({
     *         id: "myTestButton",
     *         ariaLabel: resources.i18n.getText("testButton.label"),
     *         ariaHaspopup: "dialog",
     *         icon: "sap-icon://action-settings",
     *         tooltip: resources.i18n.getText("testButton.tooltip"),
     *         text: resources.i18n.getText("testButton.text"),
     *         press: controller.handleTestButtonPress
     *     }, true, true);
     * ```
     *
     * See:
     * 	LaunchpadState
     *
     * @since 1.30
     *
     * @returns The created control
     */
    addHeaderItem(
      /**
       * The (class) name of the control type to create. **Deprecated**: Since version 1.38. This parameter is
       * no longer supported and can be omitted.
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control. For example: `{id: "testButton"}`
       */
      oControlProperties: object,
      /**
       * Specifies whether the header item control is displayed after being created.
       *  If `true` then the control is displayed according to parameters bCurrentState and aStates.
       *  If `false` then the control is created but not displayed.
       */
      bIsVisible: boolean,
      /**
       * If `true` then the new created control is added to the current rendered shell state.
       *  When the user navigates to a different state including a different application then the control will
       * be removed.
       *  If `false` then add the control to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * (Valid only if bCurrentState is `false`)
       *  A list of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which the control
       * is added.
       *  If no launchpad state is provided the control is added in all states.
       */
      aStates: string[]
    ): Control;
    /**
     * Creates and displays an item in the header of Fiori launchpad, in the given launchpad states.
     *  The new header item will be displayed on the left-hand side of the Fiori Launchpad shell header, according
     * to the given display parameters.
     *  The new header item will be added to the right of any existing header items. The header can contain
     * a maximum of three header items.
     *
     *
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     *     oRenderer.addHeaderItem({
     *         id: "myTestButton",
     *         ariaLabel: resources.i18n.getText("testButton.label"),
     *         ariaHaspopup: "dialog",
     *         icon: "sap-icon://action-settings",
     *         tooltip: resources.i18n.getText("testButton.tooltip"),
     *         text: resources.i18n.getText("testButton.text"),
     *         press: controller.handleTestButtonPress
     *     }, true, true);
     * ```
     *
     * See:
     * 	LaunchpadState
     *
     * @since 1.30
     *
     * @returns The created control
     */
    addHeaderItem(
      /**
       * The properties that will be passed to the created control. For example: `{id: "testButton"}`
       */
      oControlProperties: object,
      /**
       * Specifies whether the header item control is displayed after being created.
       *  If `true` then the control is displayed according to parameters bCurrentState and aStates.
       *  If `false` then the control is created but not displayed.
       */
      bIsVisible: boolean,
      /**
       * If `true` then the new created control is added to the current rendered shell state.
       *  When the user navigates to a different state including a different application then the control will
       * be removed.
       *  If `false` then add the control to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * (Valid only if bCurrentState is `false`)
       *  A list of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which the control
       * is added.
       *  If no launchpad state is provided the control is added in all states.
       */
      aStates: string[]
    ): Control;
    /**
     * Creates the Left Pane content in Fiori launchpad, in the given launchpad states.
     *
     *
     * **Example:**
     * ```javascript
     *
     * sap.ushell.Container.getRenderer("fiori2").addLeftPaneContent("sap.m.Button", {id: "testBtn", text: "Test Button"}, true, true);
     * ```
     *
     *
     * This function is marked for deprecation as of version 1.48.
     *  It will continue to work as expected as long as one of the following conditions apply:
     *  1. The control instance is already created and its ID is included in the input parameter oControlProperties
     *  2. The control type resource is already loaded
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is added in all states.
     *
     * @since 1.30
     * @deprecated As of version 1.48. Please use {@link #addSidePaneContent} instead.
     *
     * @returns oItem - the created control
     */
    addLeftPaneContent(
      /**
       * The (class) name of the control type to create.
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control.
       */
      oControlProperties: object,
      /**
       * Specify whether to display the control.
       */
      bIsVisible: boolean,
      /**
       * If true, add the current control only to the current rendered shell state. Once the user navigates to
       * another app or back to the Home page, this control will be removed.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
       * in which to add the control.
       */
      aStates: string[]
    ): object;
    /**
     * Creates and displays a sub header control in Fiori launchpad, in the given launchpad states.
     *  The new control is displayed in FLP UI according to the given display parameters.
     *  If a sub header already exists, the new created one will replace the existing one.
     *
     *  **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2"),
     *     oAddSubHeaderProperties = {
     *         controlType : "sap.m.Bar",
     *         oControlProperties : {
     *             id: "testBar",
     *             contentLeft: [new sap.m.Button({
     *                 text: "Test SubHeader Button",
     *                 press: function () {
     *                     sap.m.MessageToast.show("Pressed");
     *                 }
     *             })
     *         },
     *         bIsVisible: true,
     *         bCurrentState: true
     *     };
     *
     * oRenderer.addShellSubHeader(oAddSubHeaderProperties);
     * ```
     *
     *
     * @since 1.48
     *
     * @returns Resolves with the newly created control
     */
    addShellSubHeader(
      /**
       * Contains the required parameters for creating and showing the new control object.
       */
      oParameters: {
        /**
         * The (class) name of the control type to create.
         */
        controlType: string;
        /**
         * The properties that will be passed to the created control.
         */
        oControlProperties: object;
        /**
         * Specify whether to display the control.
         */
        bIsVisible: boolean;
        /**
         * If true, add the current control only to the current rendered shell state. Once the user navigates to
         * another app or back to the Home page, this control will be removed.
         */
        bCurrentState: boolean;
        /**
         * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
         * in which to add the control.
         */
        aStates: string[];
      }
    ): jQuery.Promise;
    /**
     * Creates the Left Pane content in Fiori launchpad, in the given launchpad states.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2"),
     *     oSidePaneContentProperties = {
     *         controlType : "sap.m.Button",
     *         oControlProperties : {
     *             id: "testBtn",
     *             text: "Test Button"
     *         },
     *         bIsVisible: true,
     *         bCurrentState: true
     *     };
     *
     * oRenderer.addSidePaneContent(oSidePaneContentProperties);
     * ```
     *
     * See:
     * 	LaunchpadState
     *      If no launchpad state is provided the content is added in all states.
     *
     * @since 1.48
     *
     * @returns Resolves with the newly created control
     */
    addSidePaneContent(
      /**
       * Contains the parameters for the control that should be added to the side pane
       */
      oParameters: {
        /**
         * The (class) name of the control type to create.
         */
        controlType: string;
        /**
         * The properties that will be passed to the created control.
         */
        oControlProperties: object;
        /**
         * Specify whether to display the control.
         */
        bIsVisible: boolean;
        /**
         * If true, add the current control only to the current rendered shell state. Once the user navigates to
         * another app or back to the Home page, this control will be removed.
         */
        bCurrentState: boolean;
        /**
         * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
         * in which to add the control.
         */
        aStates: string[];
      }
    ): jQuery.Promise;
    /**
     * Creates and displays a sub header control in Fiori launchpad, in the given launchpad states.
     *  The new control is displayed in FLP UI according to the given display parameters.
     *  If a sub header already exists, the new created one will replace the existing one.
     *
     *
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     * oRenderer.addSubHeader("sap.m.Bar", {id: "testBar", contentLeft: [new sap.m.Button({text: "Test SubHeader Button",
     *   press: function () {
     *     sap.m.MessageToast.show("Pressed");
     *   }})
     * ]}, true, true);
     * ```
     *
     *
     * This function is marked for deprecation as of version 1.48.
     *  It will continue to work as expected as long as one of the following conditions apply:
     *  1. The control instance is already created and its ID is included in the input parameter oControlProperties
     *  2. The control type resource is already loaded
     * See:
     * 	LaunchpadState
     *
     * @since 1.30
     * @deprecated As of version 1.48. Please use {@link #addShellSubHeader} instead.
     *
     * @returns The created control
     */
    addSubHeader(
      /**
       * The (class) name of the control type to create.
       *  For example: `"sap.m.Bar"`
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control.
       *  For example: `{id: "testBar"}`
       */
      oControlProperties: object,
      /**
       * Specifies whether the sub header control is displayed after being created.
       *  If `true` then the control is displayed according to parameters bCurrentState and aStates,
       *  if `false` then the control is created but not displayed.
       */
      bIsVisible: boolean,
      /**
       * If `true` then the new created control is added to the current rendered shell state.
       *  When the user navigates to another application (including the Home page) then the control will be removed.
       *  If `false` then add the control to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * (Valid only if bCurrentState is `false`)
       *  A list of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which the control
       * is added.
       *  If no launchpad state is provided the control is added in all states.
       */
      aStates: string[]
    ): object;
    /**
     * Creates a ToolAreaItem in Fiori Launchpad and adds it to the Tool Area, in the given launchpad states.
     * Once the item is added, the Tool Area is rendered on the left side on the Fiori Launchpad shell.
     *
     * **Example:**
     * ```javascript
     *
     * sap.ushell.Container.getRenderer("fiori2").addToolAreaItem({
     *   id: "testButton",
     *   icon: "sap-icon://documents",
     *   expandable: true,
     *   press: function (evt) {
     *     window.alert("Press" );
     *   },
     *   expand: function (evt) {
     *     // This function will be called on the press event of the "expand" button. The result of "expand" event in the UI must be determined by the developer
     *     window.alert("Expand" );
     *   }
     * }, true, false, ["home"]);
     * ```
     *
     * See:
     * 	sap.ushell.ui.shell.ToolAreaItem
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState.
     *
     * @since 1.30
     *
     * @returns the added control
     */
    addToolAreaItem(
      /**
       * The properties object that will be passed to the constructor of sap.ushell.ui.shell.ToolAreaItem control.
       */
      oControlProperties: object,
      /**
       * Specify whether to display the control.
       */
      bIsVisible: boolean,
      /**
       * If `true`, add the item to the currently rendered shell. If `false`, add the item to the given LaunchPadStates
       * This causes the items to be rendered every time the given states are active.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to `false`) - An array of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState)
       * in which the controls are added. If no launchpad state is provided the items are added in all states.
       */
      aStates: string[]
    ): Control;
    /**
     * Creates an Action Button in Fiori launchpad, in the given launchpad states.
     *  The button will be displayed in the user actions menu, that is opened from the user button in the shell
     * header.
     *  **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2"),
     *     oAddActionButtonProperties = {
     *         controlType : "sap.m.Button",
     *         oControlProperties : {
     *             id: "exampleButton",
     *             text: "Example Button",
     *             icon: "sap-icon://refresh",
     *             press: function () {
     *                 alert("Example Button was pressed!");
     *             }
     *         },
     *         bIsVisible: true,
     *         bCurrentState: true
     *     };
     * oRenderer.addUserAction(oAddActionButtonProperties);
     * ```
     *
     *
     * @since 1.48
     *
     * @returns Resolves with the newly created control
     */
    addUserAction(
      /**
       * Contains the required parameters for creating and showing the new control object.
       */
      oParameters: {
        /**
         * The (class) name of the control type to create.
         */
        controlType: string;
        /**
         * The properties that will be passed to the created control.
         */
        oControlProperties: object;
        /**
         * Specify whether to display the control.
         */
        bIsVisible: boolean;
        /**
         * If true, add the current control only to the current rendered shell state. Once the user navigates to
         * another app or back to the Home page, this control will be removed.
         */
        bCurrentState: boolean;
        /**
         * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
         * in which to add the control. If no launchpad state is provided the content is added in all states. @see
         * LaunchpadState
         */
        aStates: string[];
      }
    ): jQuery.Promise;
    /**
     * Adds an entry to the User Preferences dialog box including the UI control that appears when the user
     * clicks the new entry, and handling of User Preferences actions such as SAVE and CANCEL.
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     * var oEntry = {
     *   title: "title",
     *   value: function() {
     *       return jQuery.Deferred().resolve("entryTitleToBeDisplayed");
     *   },
     *   content: function() {
     *       return jQuery.Deferred().resolve(new sap.m.Button("userPrefEntryButton", {text: "Button"}));
     *   },
     *   onSave: function() {
     *       return jQuery.Deferred().resolve();
     *   }
     * };
     * oRenderer.addUserPreferencesEntry(oEntry);
     * ```
     *
     *
     * @since 1.30
     */
    addUserPreferencesEntry(
      /**
       * The data of the new added User Preference entry.
       */
      entryObject: {
        /**
         * (Optional) - The ID of the object.
         */
        entryHelpID: string;
        /**
         * The title of the entry to be presented in the list in the User Preferences dialog box. We recommend using
         * a string from the translation bundle.
         */
        title: string;
        /**
         * A function to be called that returns a {@link jQuery.Promise} object which consists of a {sap.ui.core.Control }
         * to be displayed in a follow-on dialog box. A SAPUI5 view instance can also be returned. The function
         * is called on each time the user opens the User Preferences dialog box.
         */
        content: Function;
        /**
         * A function to be called which returns a {@link jQuery.Promise} object when the user clicks "save" in
         * the User Preferences dialog box. If an error occurs, pass the error message via the {@link jQuery.Promise }
         * object. Errors are displayed in the log.
         */
        onSave: Function;
        /**
         * A function to be called that closes the User Preferences dialog box without saving any changes.
         */
        onCancel: Function;
        /**
         * Experimental. Set this value to true if you want that your content is displayed without the standard
         * header.
         */
        provideEmptyWrapper: boolean;
      },
      /**
       * A string to be presented as the value of the entry OR a function to be called which returns a {@link jQuery.Promise }
       * object.
       */
      value: string | Function
    ): void;
    /**
     * This method returns the current state of the Viewport Container control.
     *
     * @since 1.37
     * @deprecated As of version 1.120. This functionality was discontinued.
     *
     * @returns The current Viewport State.
     */
    getCurrentViewportState(): string;
    /**
     * Hides an action button from the User Actions Menu in the SAP Fiori launchpad, in the given launchpad
     * states (LaunchpadState). The removed button will not be destroyed.
     *
     *  This API is meant to be used for custom elements in the SAP Fiori launchpad. We do not recommend using
     * it on standard launchpad elements, as this may interfere with the standard launchpad functionality.
     * See:
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState.
     *   If no launchpad state is provided, the content is hidden in all states.
     *
     * @since 1.30
     */
    hideActionButton(
      /**
       * IDs of the button controls that should hidden.
       */
      aIds: string[],
      /**
       * If true, removes the current control only from the current rendered shell state.
       */
      bCurrentState: boolean,
      /**
       * A list of the launchpad states in which to hide the control. Valid only if bCurrentState is set to false.
       */
      aStates: string[]
    ): void;
    /**
     * Hide the given sap.ushell.ui.shell.ShellFloatingAction from Fiori Launchpad, in the given launchpad states.
     * The removed control will not be destroyed.
     *
     *  This API is meant to be used for implementing custom elements in the SAP Fiori launchpad. We do not
     * recommend using it on a standard launchpad element, as this may interfere with the standard launchpad
     * functionality.
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is removed in all states.
     *
     * @since 1.30
     * @deprecated As of version 1.52.
     */
    hideFloatingActionButton(
      /**
       * the Ids of the sap.ushell.ui.shell.ShellFloatingAction to remove.
       */
      aIds: string[],
      /**
       * if true, remove the current control only from the current rendered shell state.
       */
      bCurrentState: boolean,
      /**
       * list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState in which to remove the control. (Only
       * valid if bCurrentState is set to false)
       */
      aStates: string[]
    ): void;
    /**
     * Hide the given sap.ushell.ui.shell.ShellHeadItem from Fiori Launchpad, in the given launchpad states.
     * The removed control will not be destroyed.
     *
     *  This API is meant to be used for implementing custom elements in the SAP Fiori launchpad. We do not
     * recommend using it on a standard launchpad element, as this may interfere with the standard launchpad
     * functionality.
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is removed in all states.
     *
     * @since 1.30
     */
    hideHeaderEndItem(
      /**
       * the Ids of the sap.ushell.ui.shell.ShellHeadItem to remove.
       */
      aIds: string[],
      /**
       * if true, remove the current control only from the current rendered shell state.
       */
      bCurrentState: boolean,
      /**
       * list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState in which to remove the control. (Only
       * valid if bCurrentState is set to false)
       */
      aStates: string[]
    ): void;
    /**
     * Hide the given sap.ushell.ui.shell.ShellHeadItem from Fiori Launchpad, in the given launchpad states.
     * The removed control will not be destroyed.
     *
     *  This API is meant to be used for implementing custom elements in the SAP Fiori launchpad. We do not
     * recommend using it on a standard launchpad element, as this may interfere with the standard launchpad
     * functionality.
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is removed in all states.
     *
     * @since 1.30
     */
    hideHeaderItem(
      /**
       * the Ids of the sap.ushell.ui.shell.ShellHeadItem to remove.
       */
      aIds: string[],
      /**
       * if true, remove the current control only from the current rendered shell state.
       */
      bCurrentState: boolean,
      /**
       * list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState in which to remove the control. (Only
       * valid if bCurrentState is set to false)
       */
      aStates: string[]
    ): void;
    /**
     * Hide the given control from Fiori Launchpad, in the given launchpad states. The removed control will
     * not be destroyed.
     *
     *  This API is meant to be used for implementing custom elements in the SAP Fiori launchpad. We do not
     * recommend using it on a standard launchpad element, as this may interfere with the standard launchpad
     * functionality.
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is removed in all states.
     *
     * @since 1.30
     */
    hideLeftPaneContent(
      /**
       * the Ids of the controls to remove.
       */
      aIds: string[],
      /**
       * if true, remove the current control only from the current rendered shell state.
       */
      bCurrentState: boolean,
      /**
       * list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState in which to remove the control. (Only
       * valid if bCurrentState is set to false)
       */
      aStates: string[]
    ): void;
    /**
     * Hide the given control from the Fiori Launchpad sub header, in the given launchpad states. The removed
     * control will not be destroyed.
     *
     *  This API is meant to be used for implementing custom elements in the SAP Fiori launchpad. We do not
     * recommend using it on a standard launchpad element, as this may interfere with the standard launchpad
     * functionality.
     * See:
     * 	LaunchpadState
     *   If no launchpad state is provided the content is removed in all states.
     *
     * @since 1.30
     */
    hideSubHeader(
      /**
       * the Ids of the controls to remove.
       */
      aIds: string[],
      /**
       * if true, remove the current control only from the current rendered shell state.
       */
      bCurrentState: boolean,
      /**
       * list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState in which to remove the control. (Only
       * valid if bCurrentState is set to false)
       */
      aStates: string[]
    ): void;
    /**
     * If exists, this method will remove the footer from the Fiori Launchpad.
     *
     *  This API is meant to be used for implementing custom elements in the SAP Fiori launchpad. We do not
     * recommend using it on a standard launchpad element, as this may interfere with the standard launchpad
     * functionality.
     *
     * @since 1.30
     */
    removeFooter(): void;
    /**
     * Remove the given Tool Area Item from Fiori Launchpad, in the given launchpad states. This API is meant
     * to be used for implementing custom elements in the SAP Fiori launchpad. We do not recommend using it
     * on a standard launchpad element, as this may interfere with the standard launchpad functionality.
     * See:
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState.
     *
     * @since 1.30
     */
    removeToolAreaItem(
      /**
       * A single ID or an array of IDs to remove from the Tool Area.
       */
      vIds: string | string[],
      /**
       * If `true`, remove the items from the currently rendered shell. If `false`, remove the items from the
       * LaunchPadState itself, causing the items to be removed every time the given states are active.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to `false`) - An array of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState)
       * from which the controls are removed. If no launchpad state is provided the items are removed from all
       * states.
       */
      aStates: string[]
    ): void;
    /**
     * Displays the given sap.m.Bar as the footer of the Fiori launchpad shell.
     *  The footer will be displayed in all states.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var bar = new sap.m.Bar({contentLeft: [new sap.m.Button({text: "Test Footer Button",
     *   press: function () {
     *     sap.m.MessageToast.show("Pressed");
     *   }})
     * ]});
     * var renderer = sap.ushell.Container.getRenderer("fiori2");
     * renderer.setFooter(bar);
     * ```
     *
     *
     * @since 1.30
     * @deprecated As of version 1.120. Please use {@link #setShellFooter} instead.
     */
    setFooter(
      /**
       * sap.m.Bar, the control to be added as the footer of the Fiori Launchpad
       */
      oFooter: Bar
    ): void;
    /**
     * Creates and displays an SAPUI5 control as the footer of the Fiori launchpad shell.
     *  The footer will be displayed in all states.
     *  Previously created footer will be removed.
     *
     *
     * **For example, using the sap.m.Bar control:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     * oRenderer.setFooterControl("sap.m.Bar", {id: "testBar", contentLeft: [new sap.m.Button({text: "Test Footer Button",
     *   press: function () {
     *     sap.m.MessageToast.show("Pressed");
     *   }})
     * ]});
     * ```
     *
     *
     * This function is marked for deprecation as of version 1.48.
     *  It will continue to work as expected as long as one of the following conditions apply:
     *  1. The control instance is already created and its ID is included in the input parameter oControlProperties
     *  2. The control type resource is already loaded
     *
     * @since 1.42
     * @deprecated As of version 1.48. Please use {@link #setShellFooter} instead.
     *
     * @returns The created control
     */
    setFooterControl(
      /**
       * The (class) name of the control type to create.
       *  For example: `"sap.m.Bar"`
       */
      controlType: string,
      /**
       * The properties that will be passed to the created control.
       *  For example: `{id: "testBar"}`
       */
      oControlProperties: object
    ): Control;
    /**
     * Sets the title in the Fiori Launchpad shell header.
     *
     * @since 1.30
     * @deprecated As of version 1.120. The "second title" functionality was discontinued. Set a title via {@link sap.ushell.ui5service.ShellUIService#setTitle }
     * instead.
     */
    setHeaderTitle(
      /**
       * The title to be displayed in the Fiori Launchpad shell header
       */
      sTitle: string
    ): void;
    /**
     * Sets the header visibility according to the given value and shell states. (see sap.ushell.renderers.fiori2.Renderer.LaunchpadState).
     *
     * **Example:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     * oRenderer.setHeaderVisibility(false, false, ["home", "app"]);
     * ```
     *
     * See:
     * 	LaunchpadState
     *
     * @since 1.38
     * @deprecated As of version 1.120. This functionality was discontinued.
     */
    setHeaderVisibility(
      /**
       * The visibility of the header
       */
      bVisible: boolean,
      /**
       * If `true` then the visibility is set only to the current rendered shell state.
       *  When the user navigates to another application (including the Home page) then the visibility flag is
       * reset.
       *  If `false` then set the visibility according to the states provided in the aState parameter.
       */
      bCurrentState: boolean,
      /**
       * (Valid only if bCurrentState is `false`)
       *  A list of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which the header
       * visibility flag should be set.
       *  If no launchpad state is provided the visibility flag is set for all states.
       */
      aStates: string[]
    ): void;
    /**
     * Sets the visibility of the left pane in the Fiori Launchpad shell, in the given launchpad state @see
     * LaunchpadState
     *
     * @since 1.30
     */
    setLeftPaneVisibility(
      /**
       * LaunchpadState in which to show/hide the left pane
       */
      sLaunchpadState: string,
      /**
       * specify whether to display the left pane or not
       */
      bVisible: boolean
    ): void;
    /**
     * Creates and displays an SAPUI5 control as the footer of the Fiori launchpad shell.
     *  The footer will be displayed in all states.
     *  Previously created footer will be removed.
     *
     *
     * **For example, using the sap.m.Bar control:**
     * ```javascript
     *
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2"),
     *   oFooterControlProperties = {
     *     controlType : "sap.m.Bar",
     *     oControlProperties : {
     *       id: "testBar",
     *       contentLeft: [new sap.m.Button({
     *         text: "Test Footer Button",
     *         press: function () {
     *           sap.m.MessageToast.show("Pressed");
     *         }
     *       })]
     *     }
     *   };
     * oRenderer.setShellFooter(oFooterControlProperties);
     * ```
     *
     *
     * @since 1.48
     *
     * @returns Resolves with the newly created control
     */
    setShellFooter(
      /**
       * Contains the required parameters for creating and showing the new control object.
       */
      oParameters: {
        /**
         * The (class) name of the control type to create, for example: `sap.m.Bar`
         */
        controlType: string;
        /**
         * The properties that will be passed to the created control, for example: `{id: "testBar"}`
         */
        oControlProperties: object;
      }
    ): jQuery.Promise;
    /**
     * Displays action buttons in the User Actions Menu in the SAP Fiori launchpad, in the given launchpad states
     * (LaunchpadState). (see sap.ushell.renderers.fiori2.Renderer.LaunchpadState).
     *  If no launchpad state is provided the content is displayed in all states.
     *  The user actions menu is opened via the button on the right hand side of the shell header.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var button1 = new sap.m.Button();
     * var renderer = sap.ushell.Container.getRenderer("fiori2");
     * renderer.showActionButton([button1.getId()], false, ["home", "app"]);
     * ```
     *
     * See:
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState.
     *   If no launchpad state is provided, the content is added in all states.
     *
     * @since 1.30
     */
    showActionButton(
      /**
       * List of ID elements to that should be added to the User Actions Menu options bar.
       */
      aIds: string[],
      /**
       * If true, add the created control to the current rendered shell state. When the user navigates to a different
       * state, or to a different application, then the control is removed. If false, the control is added to
       * the LaunchpadState.
       */
      bCurrentState: boolean,
      /**
       * List of the launchpad states (sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which to add the
       * aIds. Valid only if bCurrentState is set to false.
       */
      aStates: string[]
    ): void;
    /**
     * Displays FloatingActionButton on the bottom right corner of the Fiori launchpad, in the given launchpad
     * states. The FloatingActionButton is rendered in the bottom right corner of the shell.
     *  (see sap.ushell.renderers.fiori2.Renderer.LaunchpadState).
     *  If no launchpad state is provided the content is displayed in all states.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var button1 = new sap.ushell.ui.shell.ShellFloatingAction();
     * var renderer = sap.ushell.Container.getRenderer("fiori2");
     * renderer.showFloatingActionButton([button1.getId()], true);
     * ```
     *
     *
     * @since 1.30
     * @deprecated As of version 1.52. Support for the FloatingActionButton has been discontinued.
     */
    showFloatingActionButton(
      /**
       * List of ID elements to add to the user actions menu.
       */
      aIds: string[],
      /**
       * if true, add the current Buttons only to the current instance of the rendering of the shell. if false,
       * add the Buttons to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
       * in which to add the aIds.
       */
      aStates: string[]
    ): void;
    /**
     * Displays HeaderItems on the right side of the Fiori launchpad shell header, in the given launchpad states
     * (see sap.ushell.renderers.fiori2.Renderer.LaunchpadState).
     *  If no launchpad state is provided the content is displayed in all states.
     *  The shell header can display the user HeaderItem, and just one more HeaderItem.
     *  If this method is called when the right side of the header is full, this method will not do anything.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var button1 = new sap.ushell.ui.shell.ShellHeadItem();
     * var renderer = sap.ushell.Container.getRenderer("fiori2");
     * renderer.showHeaderEndItem ([button1.getId()], false, ["home", "app"]);
     * ```
     *
     *
     * @since 1.30
     */
    showHeaderEndItem(
      /**
       * List of ID elements to add to the shell header.
       */
      aIds: string[],
      /**
       * if true, add the current HeaderItems only to the current instance of the rendering of the shell. if false,
       * add the HeaderItems to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * (only valid if bCurrentState is set to false) - list of the sap.ushell.renderers.fiori2.Renderer.LaunchpadState
       * in which to add the aIds.
       */
      aStates: string[]
    ): void;
    /**
     * Creates and displays one or more HeaderItem controls according to the given control IDs and Shell states
     *  (see sap.ushell.renderers.fiori2.Renderer.LaunchpadState).
     *
     *  The HeaderItem controls will be displayed on the left side of the Fiori Launchpad shell header according
     * to the given display parameters.
     *  There can be up to three header items. If the number of existing header items plus the given ones exceeds
     * 3, then the operation fails and no new header items are created.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var button1 = new sap.ushell.ui.shell.ShellHeadItem();
     * var button2 = new sap.ushell.ui.shell.ShellHeadItem();
     * var renderer = sap.ushell.Container.getRenderer("fiori2");
     * renderer.showHeaderItem ([button1.getId(), button2.getId()], false, ["home", "app"]);
     * ```
     *
     * See:
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState.
     *
     * @since 1.30
     */
    showHeaderItem(
      /**
       * Either ID or an array of IDs of headerItem controls to be added to the shell header.
       */
      vIds: string | string[],
      /**
       * If `true` then the new created controls are added to the current rendered shell state. When the user
       * navigates to another application (including the Home page) then the controls will be removed. If `false`
       * then the controls are added to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * Valid only if bCurrentState is `false`. A list of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState)
       * in which the controls are added. If no launchpad state is provided the controls are added in all states.
       */
      aStates: string[]
    ): void;
    /**
     * Displays one or more sub header controls according to the given control IDs and shell states.
     *  (see sap.ushell.renderers.fiori2.Renderer.LaunchpadState).
     *
     *  A sub header is placed in a container, located directly below the main Fiori launchpad shell header.
     *
     *
     * **Example:**
     * ```javascript
     *
     * var bar = new sap.m.Bar({id: "testBar", contentLeft: [new sap.m.Button({text: "Test SubHeader Button",
     *   press: function () {
     *     sap.m.MessageToast.show("Pressed");
     *   }})
     * ]});
     * var oRenderer = sap.ushell.Container.getRenderer("fiori2");
     * oRenderer.showSubHeader([bar.getId()], false, ["home", "app"]);
     * ```
     *
     * See:
     * 	LaunchpadState
     *
     * @since 1.30
     */
    showSubHeader(
      /**
       * Array of sub header control IDs to be added
       */
      aIds: string[],
      /**
       * If `true` then the new created controls are added only to the current rendered shell state.
       *  When the user navigates to another application (including the Home page) then the controls will be removed.
       *  If `false` then add the control to the LaunchPadState itself.
       */
      bCurrentState: boolean,
      /**
       * (Valid only if bCurrentState is `false`)
       *  A list of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState) in which the controls
       * are added.
       *  If no launchpad state is provided the controls are added in all states.
       */
      aStates: string[]
    ): void;
    /**
     * Sets the ToolArea visibility
     */
    showToolArea(
      /**
       * LaunchpadState in which to show/hide the ToolArea @see LaunchpadState
       */
      sLaunchpadState?: string,
      /**
       * specifies whether to display the ToolArea or not
       */
      bVisible?: boolean
    ): void;
    /**
     * Displays ToolAreaItems on the left side of the Fiori Launchpad shell, in the given launchpad states.
     *
     * **Example:**
     * ```javascript
     *
     * sap.ui.require(["sap/ushell/ui/shell/ToolAreaItem"], function (ToolAreaItem) {
     *     var oRenderer = sap.ushell.Container.getRenderer("fiori2"),
     *         oToolAreaItem = new ToolAreaItem({ icon: "sap-icon://wrench" });
     *     renderer.showToolAreaItem(oToolAreaItem.getId(), false, ["home", "app"]);
     * });
     * ```
     *
     * See:
     * 	sap.ushell.renderers.fiori2.Renderer.LaunchpadState.
     *
     * @since 1.30
     */
    showToolAreaItem(
      /**
       * A single ID or an array of IDs to add to the Tool Area.
       */
      vIds: string | string[],
      /**
       * If `true`, add the items to the currently rendered shell. If `false`, add the items to the LaunchPadState
       * itself, causing the items to be rendered every time the given states are active.
       */
      bCurrentState: boolean,
      /**
       * Only valid if bCurrentState is set to `false`. An array of shell states (i.e. sap.ushell.renderers.fiori2.Renderer.LaunchpadState)
       * in which the controls are added. If no launchpad state is provided the items are added in all states.
       */
      aStates: string[]
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Renderer constructor.
   *
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.Extension} instead.
   */
  export interface $RendererSettings extends $UIComponentSettings {}
}

declare module "sap/ushell/services/AppConfiguration" {
  import Button from "sap/m/Button";

  /**
   * The unified shell's AppConfiguration service as a singleton object.
   *
   * @since 1.15.0
   */
  interface AppConfiguration {
    /**
     * Adds an entry to user recent activity list. The list of recent activities will be displayed in the UserActionsMenu
     * of FLP application (fiori 2.0) This method should be used by applications of special types. like "Search",
     * "OVP", "Co-Pilot" and "FactSheet" This method should be only called in the "exit" method of applications
     * Component.js in order to assure that it will be added to recent activities. For these applications the
     * unique identifier of the entry is url and not appId, so in order to add different entry, different url
     * should be specified, otherwise the entry will be updated with a new timestamp Only applications of type
     * Search and Co-Pilot can set their icon.
     *
     * @deprecated As of version 1.120. Deprecated without successor.
     *
     * @returns Resolves the updated list of user recents.
     */
    addActivity(
      /**
       * oRecentActivity
       */
      oRecentActivity: object
    ): jQuery.Promise;
    /**
     * Adds buttons to the action sheet in the shell header. This function always overrides the already existing
     * application settings buttons with the new buttons. It is meant to be used by applications that want to
     * add their own settings button to the shell header.
     *
     * @deprecated As of version 1.120. Use {@link sap.ushell.services.Extension#addUserAction} instead.
     */
    addApplicationSettingsButtons(
      /**
       * List of sap.m.Button controls
       */
      aButtons: Button[]
    ): void;
    /**
     * Sets the application screen size to full width
     *
     * @deprecated As of version 1.120. Use {@link sap.ushell.ui5service.ShellUIService#setApplicationFullWidth }
     * instead.
     */
    setApplicationFullWidth(
      /**
       * A Boolean value indicating if the application fills the full width of the screen
       */
      bValue: boolean
    ): void;
    /**
     * Sets the icons of the browser.
     *
     * @deprecated As of version 1.120. Use {@link sap.ui.util.Mobile#setIcons} instead.
     */
    setIcons(
      /**
       * Icon properties, an object holding icon URLs
       */
      oIconsProperties: object
    ): void;
  }
  const AppConfiguration: AppConfiguration;
  export default AppConfiguration;

  /**
   * Type for the metadata object for AppConfiguration
   *
   * @since 1.120.0
   */
  export type Metadata = {
    /**
     * The title of the application
     */
    title: string;
    /**
     * The library of the application
     */
    library: string;
    /**
     * The version of the application
     */
    version: string;
    /**
     * A Boolean value indicating if the application fills the full width of the screen
     */
    fullWidth: boolean;
  };
}

declare module "sap/ushell/services/AppLifeCycle" {
  import Event from "sap/ui/base/Event";

  import Component from "sap/ui/core/Component";

  /**
   * The Unified Shell's AppLifeCycle service.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const AppLifeCycle = await Container.getServiceAsync("AppLifeCycle");
   *     // do something with the AppLifeCycle service
   *   });
   * ```
   *
   *
   * @since 1.38
   */
  export default class AppLifeCycle extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
    /**
     * Enumeration of application info parameter names.
     *
     * This enum is part of the 'sap/ushell/services/AppLifeCycle' module export and must be accessed by the
     * property 'AppInfoParameterName'.
     *
     * @since 1.120.0
     */
    static AppInfoParameterName: typeof AppInfoParameterName;

    /**
     * Enumeration of application types.
     *
     * This enum is part of the 'sap/ushell/services/AppLifeCycle' module export and must be accessed by the
     * property 'ApplicationType'.
     *
     * @since 1.120.0
     */
    static ApplicationType: typeof ApplicationType;

    /**
     * Attaches an event handler for the appLoaded event. This event handler will be triggered each time an
     * application has been loaded.
     *
     * @since 1.38
     */
    attachAppLoaded<ObjectToBePassedToHandler extends object>(
      /**
       * An object that will be passed to the handler along with the event object when the event is fired.
       */
      oData: ObjectToBePassedToHandler,
      /**
       * The handler function to call when the event occurs.
       */
      fnFunction: (p1: Event, p2: ObjectToBePassedToHandler) => void,
      /**
       * The object that wants to be notified when the event occurs (this context within the handler function).
       */
      oListener: object
    ): void;
    /**
     * Detaches an event handler from the EventProvider.
     *
     * @since 1.38
     */
    detachAppLoaded(
      /**
       * The handler function that has to be detached from the EventProvider.
       */
      fnFunction: Function,
      /**
       * The object that wanted to be notified when the event occurred
       */
      oListener: object
    ): void;
    /**
     * Returns information about the currently running application or `undefined` if no application is running.
     *
     * @since 1.38
     *
     * @returns Information object about currently running application or `undefined` if no application is running.
     * **Note:** Return value is only valid after app is loaded. See {@link #attachAppLoaded} for details. Before
     * an app is loaded, `undefined` is returned.
     */
    getCurrentApplication(): CurrentApplication | undefined;
  }
  /**
   * Defines the application info.
   *
   * @since 1.120.0
   */
  export type AppInfo = {
    /**
     * A human readable free form text maintained on the platform where FLP runs, and identifying the current
     * product.
     */
    productName: string;
    /**
     * Current FLP theme. Includes the path to the theme resources if the theme is not an sap theme (does not
     * start with sap_)
     */
    theme: string;
    /**
     * Current Language (BCP47 format)
     */
    languageTag: string;
    /**
     * Intent that was used to launch the application (including parameters)
     */
    appIntent: string;
    /**
     * ID of the framework
     */
    appFrameworkId: string;
    /**
     * Identifier of the component that implements the base application.
     */
    technicalAppComponentId: string;
    /**
     * Universal stable logical identifier of the application across the whole content.
     */
    appId: string;
    /**
     * Version of the app
     */
    appVersion: string;
    /**
     * The name of an organizational component that handles support incidents.
     */
    appSupportInfo: string;
    /**
     * Version of the framework
     */
    appFrameworkVersion: string;
    /**
     * The FLP URL with the current hash included.
     */
    url: string;
  };

  /**
   * Enumeration of application info parameter names.
   *
   * This enum is part of the 'sap/ushell/services/AppLifeCycle' module export and must be accessed by the
   * property 'AppInfoParameterName'.
   *
   * @since 1.120.0
   */
  enum AppInfoParameterName {
    /**
     * The ABAP transaction code which not always available and therefore can be undefined.
     */
    "abap.transaction" = "undefined",
    /**
     * ID of the framework
     */
    appFrameworkId = "undefined",
    /**
     * Version of the framework
     */
    appFrameworkVersion = "undefined",
    /**
     * Universal stable logical identifier of the application across the whole content.
     */
    appId = "undefined",
    /**
     * Intent that was used to launch the application (including parameters)
     */
    appIntent = "undefined",
    /**
     * The name of an organizational component that handles support incidents.
     */
    appSupportInfo = "undefined",
    /**
     * Version of the app
     */
    appVersion = "undefined",
    /**
     * Current Language (BCP47 format)
     */
    languageTag = "undefined",
    /**
     * A human readable free form text maintained on the platform where FLP runs, and identifying the current
     * product.
     */
    productName = "undefined",
    /**
     * Identifier of the component that implements the base application.
     */
    technicalAppComponentId = "undefined",
    /**
     * Current FLP theme. Includes the path to the theme resources if the theme is not an sap theme (does not
     * start with sap_)
     */
    theme = "undefined",
  }
  /**
   * Enumeration of application types.
   *
   * This enum is part of the 'sap/ushell/services/AppLifeCycle' module export and must be accessed by the
   * property 'ApplicationType'.
   *
   * @since 1.120.0
   */
  enum ApplicationType {
    /**
     * The application is starting using the SAP Business Client.
     */
    NWBC = "NWBC",
    /**
     * The application is started using a transaction
     */
    TR = "TR",
    /**
     * The application is a UI5 application.
     */
    UI5 = "UI5",
    /**
     * The application is started using a URL
     */
    URL = "URL",
    /**
     * The application is a Webdynpro application.
     */
    WDA = "WDA",
  }
  /**
   * Defines the current application.
   *
   * @since 1.120.0
   */
  export type CurrentApplication = {
    /**
     * The type of the current application.
     */
    applicationType: ApplicationType | keyof typeof ApplicationType;
    /**
     * reference to component (only for applicationType "UI5")
     */
    componentInstance?: Component;
    /**
     * `true` when root intent (normally #Shell-home) or Appfinder (#Shell-appfinder) is currently displayed.
     */
    homePage: boolean;
    /**
     * function that returns the value of a technical parameter for the given application. This method is for
     * SAP internal usage only.
     */
    getTechnicalParameter: Function;
    /**
     * See {@link sap.ushell.services.URLParsing#parseShellHash} for details. This property is for SAP-internal
     * use only!
     */
    getIntent: () => Promise<Intent>;
    /**
     * provides the values of the given parameters.
     */
    getInfo: (p1: AppInfoParameterName[]) => Promise<AppInfo>;
  };

  /**
   * Defines an intent. See {@link sap.ushell.services.URLParsing#parseShellHash} for details.
   *
   * @since 1.120.0
   */
  export type Intent = {
    /**
     * The semantic object of the intent.
     */
    semanticObject: string;
    /**
     * The action of the intent.
     */
    action: string;
    /**
     * The raw context of the intent.
     */
    contextRaw: string;
    /**
     * The parameters of the intent.
     */
    params: Record<string, string[]>;
    /**
     * The app specific route of the intent.
     */
    appSpecificRoute: string;
  };
}

declare module "sap/ushell/services/Bookmark" {
  import { ContentNodeType } from "sap/ushell/library";

  /**
   * The Unified Shell's bookmark service. Allows creating shortcuts on the user's home page.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Bookmark = await Container.getServiceAsync("Bookmark");
   *     // do something with the Bookmark service
   *   });
   * ```
   *
   *
   * @since 1.15.0
   * @deprecated As of version 1.119. Please use {@link sap.ushell.services.BookmarkV2} instead.
   */
  export default class Bookmark extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Adds a bookmark tile to one of the user's classic home page groups or to multiple provided content nodes.
     * See:
     * 	sap.ushell.services.URLParsing#getShellHash
     *
     * @since 1.15.0
     * @deprecated As of version 1.119. Please use {@link sap.ushell.services.BookmarkV2#addBookmark} instead.
     *
     * @returns Resolves on success, but rejects with a reason-message on failure to add the bookmark to the
     * specified or implied group. The promise gets resolved if personalization is disabled.
     */
    addBookmark(
      /**
       * Bookmark parameters. In addition to title and URL, a bookmark might allow further settings, such as an
       * icon or a subtitle. Which settings are supported depends on the environment in which the application
       * is running. Unsupported parameters will be ignored.
       */
      oParameters: {
        /**
         * The title of the bookmark.
         */
        title: string;
        /**
         * The target intent or URL of the bookmark. If the target app runs in the current shell, the URL has to
         * be a valid intent, i.e. in the format `"#SO-Action?P1=a&P2=x&/route?RPV=1"`.
         */
        url: string;
        /**
         * The optional icon URL of the bookmark (e.g. `"sap-icon://home"`).
         */
        icon?: string;
        /**
         * The information text of the bookmark.
         */
        info?: string;
        /**
         * The subtitle of the bookmark.
         */
        subtitle?: string;
        /**
         * The URL to a REST or OData service that provides some dynamic information for the bookmark.
         *
         * **Semantic Date Ranges:**
         *
         * You can use placeholders for dynamic dates in the query parameters of the service URL. This can be used
         * to create KPI tiles based on user entries in control {@link sap.m.DynamicDateRange}, where it is possible
         * to specify dynamic dates like YESTERDAY or THISYEAR.
         *
         * The placeholder format looks like this: {Edm.<type>%%DynamicDate.<operator>.<value1>.<value2>.<position>%%}
         *
         *
         * 	 - <type>: The Edm Type of the parameter. Supported types are String, DateTime and DateTimeOffset
         *     for OData V2 and Date and DateTimeOffset for OData V4.
         * 	 - <operator>, <value1>, <value2>: Possible values are the ones that can be used in
         *     {@link sap.m.DynamicDateRange#toDates} to create a date range.
         * 	 - <position>: Possible values are 'start' and 'end' which mark the start or end of the interval
         *     specified by the operator.
         *
         * Examples:
         * 	 - /a/url/$count?$filter=(testDate ge {Edm.DateTimeOffset%DynamicDate.YESTERDAY.start%} and testDate
         *     le {Edm.DateTimeOffset%DynamicDate.YESTERDAY.end%})
         * 	 - /a/url/$count?$filter=(testDate ge {Edm.DateTime%DynamicDate.THISYEAR.start%} and testDate le {Edm.DateTime%DynamicDate.THISYEAR.end%})
         *
         * 	 - /a/url/$count?$filter=(testDate ge {Edm.Date%DynamicDate.TODAYFROMTO.1.5.start%} and testDate le
         *     {Edm.Date%DynamicDate.TODAYFROMTO.1.5.end%})
         *
         * Hint: Check the debug log when displaying the resulting KPI tiles to get more information about the resolution
         * of the placeholders.
         */
        serviceUrl?: string;
        /**
         * Metadata for parameter serviceUrl. Mandatory to specify if parameter serviceURL contains semantic date
         * ranges. This does not influence the data source of the app itself.
         *
         * Specify the data source as follows:
         * ```javascript
         *
         *   {
         *       type: "OData",
         *       settings: {
         *           odataVersion: "4.0"
         *       }
         *   }
         *   ```
         *
         *
         *
         * 	type: The type of the serviceURL's service. Only "OData" is supported. odataVersion: The OData version
         * of parameter serviceURL. Valid values are "2.0" and "4.0".
         */
        dataSource?: object;
        /**
         * The refresh interval for the `serviceUrl` in seconds.
         */
        serviceRefreshInterval?: string;
        /**
         * The unit for the number retrieved from `serviceUrl`.
         */
        numberUnit?: string;
      },
      /**
       * Either a legacy launchpad home page group, one content node or an array of content nodes (see {@link #getContentNodes}).
       * If not provided, the bookmark will be added to the default group if spaces mode is not active or to the
       * default page if spaces mode is active.
       */
      vContainer?: object | ContentNode | ContentNode[],
      /**
       * The contentProviderId or undefined outside the cFLP
       */
      sContentProviderId?: string
    ): jQuery.Promise;
    /**
     * Adds the catalog tile with the given ID to given group. The catalog tile is looked up in the legacy SAP
     * HANA catalog unless data to look up a remote catalog is provided.
     *
     * @since 1.21.2
     * @deprecated As of version 1.112. Please use {@link sap.ushell.services.BookmarkV2#addBookmark} instead.
     *
     * @returns Resolves if successful. In case of failure, an error message is passed. In launchpad spaces
     * mode the promise gets rejected.
     */
    addCatalogTileToGroup(
      /**
       * The ID of the tile within the catalog
       */
      sCatalogTileId: string,
      /**
       * The id of the group. If not given, the tile is added to the default group
       */
      sGroupId?: string,
      /**
       * The data to identify the catalog containing the tile with the given ID
       */
      oCatalogData?: {
        /**
         * The remote catalog's base URL such as "/sap/hba/apps/kpi/s/odata/hana_chip_catalog.xsodata/"
         */
        baseUrl: string;
        /**
         * The remote catalog's id on the remote system such as "HANA_CATALOG"
         */
        remoteId: string;
      }
    ): jQuery.Promise;
    /**
     * Counts **all** bookmarks pointing to the given URL from all of the user's pages. You can use this method
     * to check if a bookmark already exists.  This is a potentially asynchronous operation in case the user's
     * pages have not yet been loaded completely!
     * See:
     * 	#addBookmark
     *
     * @since 1.17.1
     * @deprecated As of version 1.119. Please use {@link sap.ushell.services.BookmarkV2#countBookmarks} instead.
     *
     * @returns Resolves the count of existing bookmarks is provided (which might be zero). In case of failure,
     * an error message is passed.
     */
    countBookmarks(
      /**
       * The URL of the bookmarks to be counted, exactly as specified to {@link #addBookmark}.
       */
      sUrl: string,
      /**
       * The Content Provider ID.
       */
      sContentProviderId: string
    ): jQuery.Promise;
    /**
     * Deletes **all** bookmarks pointing to the given URL from all of the user's pages.
     * See:
     * 	#addBookmark
     * 	#countBookmarks
     *
     * @since 1.17.1
     * @deprecated As of version 1.119. Please use {@link sap.ushell.services.BookmarkV2#deleteBookmarks} instead.
     *
     * @returns Resolves the number of deleted bookmarks is provided (which might be zero). In case of failure,
     * an error message is passed.
     */
    deleteBookmarks(
      /**
       * The URL of the bookmarks to be deleted, exactly as specified to {@link #addBookmark}.
       */
      sUrl: string,
      /**
       * The contentProviderId or undefined outside the cFLP
       */
      sContentProviderId?: string
    ): jQuery.Promise;
    /**
     * Returns available content nodes based on the current launchpad context. (Classic home page, spaces mode)
     *
     * A content node may be:
     * 	 - a classic home page group
     * 	 - an unselectable node (space) or a selectable node (page) in spaces mode
     * 	 - or any other containers in the future
     *
     * It has the following properties:
     * 	 - id: ID of the content node
     * 	 - label: Human-readable representation of a content node which can be displayed in a control
     * 	 - type: Specifies the content node type. E.g: space, page, group, etc. See {@link sap.ushell.ContentNodeType }
     *
     * 	 - isContainer: Specifies if a bookmark can be added
     * 	 - children: Specifies sub-nodes
     *
     * @since 1.81
     * @deprecated As of version 1.119. Please use {@link sap.ushell.services.BookmarkV2#getContentNodes} instead.
     *
     * @returns Promise resolving the currently available content nodes.
     */
    getContentNodes(): Promise<ContentNode[]>;
    /**
     * Updates **all** bookmarks pointing to the given URL on all of the user's pages with the given new parameters.
     * Parameters which are omitted are not changed in the existing bookmarks.
     * See:
     * 	#addBookmark
     * 	#countBookmarks
     * 	#deleteBookmarks
     *
     * @since 1.17.1
     * @deprecated As of version 1.119. Please use {@link sap.ushell.services.BookmarkV2#updateBookmarks} instead.
     *
     * @returns Resolves the number of updated bookmarks is provided (which might be zero). In case of failure,
     * an error message is passed.
     */
    updateBookmarks(
      /**
       * The URL of the bookmarks to be updated, exactly as specified to {@link #addBookmark}. In case you need
       * to update the URL itself, pass the old one here and the new one as `oParameters.url`!
       */
      sUrl: string,
      /**
       * Bookmark parameters. In addition to title and URL, a bookmark might allow additional settings, such as
       * an icon or a subtitle. Which settings are supported depends on the environment in which the application
       * is running. Unsupported parameters will be ignored.
       */
      oParameters: {
        /**
         * The title of the bookmark.
         */
        title: string;
        /**
         * The target URL or intent of the bookmark. If the target application shall run in the current shell, the
         * URL has to be a valid intent, i.e. in the format like `"#SO-Action?P1=a&P2=x&/route?RPV=1"`.
         */
        url: string;
        /**
         * The optional icon URL of the bookmark (e.g. `"sap-icon://home"`).
         */
        icon?: string;
        /**
         * The information text of the bookmark.
         */
        info?: string;
        /**
         * The subtitle of the bookmark.
         */
        subtitle?: string;
        /**
         * The URL to a REST or OData service that provides some dynamic information for the bookmark.
         */
        serviceUrl?: string;
        /**
         * Metadata for parameter serviceUrl. Mandatory to specify if parameter serviceURL contains semantic date
         * ranges. This does not influence the data source of the app itself.
         */
        dataSource?: {
          /**
           * The type of the serviceURL's service. Only "OData" is supported.
           */
          type?: string;
          /**
           * Additional settings for the data source.
           */
          settings?: {
            /**
             * The OData version of parameter serviceURL. Valid values are "2.0" and "4.0".
             */
            odataVersion?: object;
          };
        };
        /**
         * The refresh interval for the `serviceUrl` in seconds.
         */
        serviceRefreshInterval?: string;
        /**
         * The unit for the number retrieved from `serviceUrl`.
         */
        numberUnit?: string;
      },
      /**
       * The contentProviderId or undefined outside the cFLP
       */
      sContentProviderId?: string
    ): jQuery.Promise;
  }
  /**
   * A content node may be: - a classic home page group - an unselectable node (space) or a selectable node
   * (page) in spaces mode - or any other containers in the future
   *
   * @deprecated As of version 1.119. because it is part of the deprecated package sap.ushell.services.Bookmark
   */
  export type ContentNode = {
    /**
     * ID of the content node
     */
    id: string;
    /**
     * Human-readable representation of a content node which can be displayed in a control
     */
    label: string;
    /**
     * Specifies the content node type. E.g: space, page, group, etc. See {@link sap.ushell.sap.ushell.services.Bookmark.ContentNodeType}
     */
    type: ContentNodeType | keyof typeof ContentNodeType;
    /**
     * Specifies if a bookmark can be added
     */
    isContainer: boolean;
    /**
     * Specifies sub-nodes
     */
    children?: ContentNode[];
  };
}

declare module "sap/ushell/services/BookmarkV2" {
  import { URI } from "sap/ui/core/library";

  import { ContentNodeType } from "sap/ushell/library";

  /**
   * The Unified Shell's bookmark service. Allows creating shortcuts on the user's home page.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const BookmarkV2 = await Container.getServiceAsync("BookmarkV2");
   *     // do something with the BookmarkV2 service
   *   });
   * ```
   *
   *
   * @since 1.119.0
   */
  export default class BookmarkV2 extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Adds a bookmark tile to the provided content nodes.
     * See:
     * 	sap.ushell.services.URLParsing#getShellHash
     *
     * @since 1.119.0
     *
     * @returns A promise which resolves on success
     */
    addBookmark(
      /**
       * Bookmark parameters. In addition to title and URL, a bookmark might allow further settings, such as an
       * icon or a subtitle. Which settings are supported depends on the environment in which the application
       * is running. Unsupported parameters will be ignored.
       */
      oParameters: BookmarkParameters,
      /**
       * Either a content node or an array of content nodes (see {@link #getContentNodes}). If not provided, the
       * bookmark will be added to the default page.
       */
      vContainer?: ContentNode | ContentNode[],
      /**
       * **SAP internal usage only** The contentProviderId or undefined outside the cFLP.
       */
      sContentProviderId?: string
    ): Promise<any>;
    /**
     * Counts **all** bookmarks pointing to the given URL from all of the user's pages. You can use this method
     * to check if a bookmark already exists.  This is a potentially asynchronous operation in case the user's
     * pages have not yet been loaded completely!
     * See:
     * 	#addBookmark
     *
     * @since 1.119.0
     *
     * @returns A `Promise` which informs about success or failure of this asynchronous operation. In case of
     * success, the count of existing bookmarks is provided (which might be zero). In case of failure, an error
     * message is passed.
     */
    countBookmarks(
      /**
       * The URL of the bookmarks to be counted, exactly as specified to {@link #addBookmark}.
       */
      sUrl: /* was: sap.ushell.services.navigation.TargetIntent */ any | URI,
      /**
       * **SAP internal usage only** The contentProviderId or undefined outside the cFLP. The Content Provider
       * ID.
       */
      sContentProviderId?: string
    ): Promise<int>;
    /**
     * Deletes **all** bookmarks pointing to the given URL from all of the user's pages.
     * See:
     * 	#addBookmark
     * 	#countBookmarks
     *
     * @since 1.119.0
     *
     * @returns A `Promise` which informs about success or failure of this asynchronous operation. In case of
     * success, the number of deleted bookmarks is provided (which might be zero). In case of failure, an error
     * message is passed.
     */
    deleteBookmarks(
      /**
       * The URL of the bookmarks to be deleted, exactly as specified to {@link #addBookmark}.
       */
      sUrl: /* was: sap.ushell.services.navigation.TargetIntent */ any | URI,
      /**
       * **SAP internal usage only** The contentProviderId or undefined outside the cFLP.
       */
      sContentProviderId?: string
    ): Promise<int>;
    /**
     * Returns available content nodes.
     *
     * @since 1.119.0
     *
     * @returns Promise resolving the currently available content nodes.
     */
    getContentNodes(): Promise<ContentNode[]>;
    /**
     * Updates **all** bookmarks pointing to the given URL on all of the user's pages with the given new parameters.
     * Parameters which are omitted are not changed in the existing bookmarks.
     * See:
     * 	#addBookmark
     * 	#countBookmarks
     * 	#deleteBookmarks
     *
     * @since 1.119.0
     *
     * @returns A `Promise` which informs about success or failure of this asynchronous operation. In case of
     * success, the number of updated bookmarks is provided (which might be zero). In case of failure, an error
     * message is passed.
     */
    updateBookmarks(
      /**
       * The URL of the bookmarks to be updated, exactly as specified to {@link #addBookmark}. In case you need
       * to update the URL itself, pass the old one here and the new one as `oParameters.url`!
       */
      sUrl: string,
      /**
       * Bookmark parameters. In addition to title and URL, a bookmark might allow additional settings, such as
       * an icon or a subtitle. Which settings are supported depends on the environment in which the application
       * is running. Unsupported parameters will be ignored.
       */
      oParameters: BookmarkParameters,
      /**
       * **SAP internal usage only** The contentProviderId or undefined outside the cFLP.
       */
      sContentProviderId?: string
    ): Promise<int>;
  }
  /**
   * Type for data source object. Metadata for parameter serviceUrl. Mandatory to specify if parameter serviceURL
   * contains semantic date ranges. This does not influence the data source of the app itself.
   *
   * Specify the data source as follows:
   * ```javascript
   *
   *   {
   *       type: "OData",
   *       settings: {
   *           odataVersion: "4.0"
   *       }
   *   }
   *   ```
   *
   *
   *
   * 	type: The type of the serviceURL's service. Only "OData" is supported. odataVersion: The OData version
   * of parameter serviceURL. Valid values are "2.0" and "4.0".
   *
   * @since 1.121.0
   */
  export type BookmarkParameters = {
    /**
     * The type of the serviceURL's service. Only "OData" is supported.
     */
    type: string;
    /**
     * The settings for the data source.
     */
    settings: {
      x: any;
    };
    /**
     * The title of the bookmark.
     */
    title: string;
    /**
     * The URL of the bookmark. The target intent or URL of the bookmark. If the target app runs in the current
     * shell, the URL has to be a valid intent, i.e. in the format `"#SO-Action?P1=a&P2=x&/route?RPV=1"`.
     */
    url: /* was: sap.ushell.services.navigation.TargetIntent */ any | URI;
    /**
     * The optional icon URL of the bookmark (e.g. `"sap-icon://home"`).
     */
    icon?: string;
    /**
     * The optional information text of the bookmark.
     */
    info?: string;
    /**
     * The optional subtitle of the bookmark.
     */
    subtitle?: string;
    /**
     * The URL to a REST or OData service that provides some dynamic information for the bookmark. The URL to
     * a REST or OData service that provides some dynamic information for the bookmark.
     *
     * **Semantic Date Ranges:**
     *
     * You can use placeholders for dynamic dates in the query parameters of the service URL. This can be used
     * to create KPI tiles based on user entries in control {@link sap.m.DynamicDateRange}, where it is possible
     * to specify dynamic dates like YESTERDAY or THISYEAR.
     *
     * The placeholder format looks like this: {Edm.<type>%%DynamicDate.<operator>.<value1>.<value2>.<position>%%}
     *
     *
     * 	 - <type>: The Edm Type of the parameter. Supported types are String, DateTime and DateTimeOffset
     *     for OData V2 and Date and DateTimeOffset for OData V4.
     * 	 - <operator>, <value1>, <value2>: Possible values are the ones that can be used in
     *     {@link sap.m.DynamicDateRange#toDates} to create a date range.
     * 	 - <position>: Possible values are 'start' and 'end' which mark the start or end of the interval
     *     specified by the operator.
     *
     * Examples:
     * 	 - /a/url/$count?$filter=(testDate ge {Edm.DateTimeOffset%DynamicDate.YESTERDAY.start%} and testDate
     *     le {Edm.DateTimeOffset%DynamicDate.YESTERDAY.end%})
     * 	 - /a/url/$count?$filter=(testDate ge {Edm.DateTime%DynamicDate.THISYEAR.start%} and testDate le {Edm.DateTime%DynamicDate.THISYEAR.end%})
     *
     * 	 - /a/url/$count?$filter=(testDate ge {Edm.Date%DynamicDate.TODAYFROMTO.1.5.start%} and testDate le
     *     {Edm.Date%DynamicDate.TODAYFROMTO.1.5.end%})
     *
     * Hint: Check the debug log when displaying the resulting KPI tiles to get more information about the resolution
     * of the placeholders.
     */
    serviceUrl?: URI;
    /**
     * Metadata for parameter serviceUrl. Mandatory to specify if parameter serviceURL contains semantic date
     * ranges.
     */
    dataSource?: /* was: sap.ushell.services.BookmarkV2.DataSource */ any;
    /**
     * The refresh interval for the `serviceUrl` in seconds.
     */
    serviceRefreshInterval?: string;
    /**
     * The unit for the number retrieved from `serviceUrl`.
     */
    numberUnit?: string;
  };

  /**
   * A tree of content nodes.
   *
   * @since 1.121.0
   */
  export type ContentNode = {
    /**
     * ID of the content node
     */
    id: string;
    /**
     * Human-readable representation of a content node which can be displayed in a control
     */
    label: string;
    /**
     * Specifies the content node type. E.g: space, page, etc.
     */
    type: ContentNodeType | keyof typeof ContentNodeType;
    /**
     * Specifies if a bookmark can be added
     */
    isContainer: boolean;
    /**
     * Specifies sub-nodes
     */
    children?: ContentNode[];
  };
}

declare module "sap/ushell/services/Configuration" {
  /**
   * The unified shell's Configuration service. Allows attaching to **selected** launchpad configuration settings
   * and their value changes.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Configuration = await Container.getServiceAsync("Configuration");
   *     // do something with the Configuration service
   *   });
   * ```
   *
   *
   * @since 1.64.0
   */
  export default class Configuration extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Allows to attach to any value change of the sizeBehavior configuration for homepage parts (smaller tile
     * size) which is needed to implement custom tiles reacting on this setting. The returned value can directly
     * be used in {@link sap.m.GenericTile#sizeBehavior}.
     *
     * Once attached, `fnCallback` will be called once initially for the **current value** and afterwards every
     * time the value changed.
     *
     * Please ensure to detach from the registry by calling `.detach` on the returned object e.g. in the destroy
     * function of your component or controller! Make sure that you do not attach twice with the same function
     * as otherwise a detach cannot be performed later!
     *
     * Example usage:
     * ```javascript
     *
     * var oEventRegistry;
     *
     * // the callback that is called whenever the property changes
     * var fnCallback = function (sSizeBehavior) {
     *     // do something with sSizeBehavior like setting it on a
     *     // sap.m.GenericTile via model and data binding!
     * };
     *
     *
     * // retrieve service via getServiceAsync API
     * sap.ushell.Container.getServiceAsync("Configuration").then( function (oService) {
     *     // keep the returned event registry in order to detach upon destroy of your context
     *     oEventRegistry = oService.attachSizeBehaviorUpdate(fnCallback);
     * });
     *
     * // detach later when your context is destroyed (e.g. destroy of the controller)
     * oEventRegistry.detach();
     * ```
     *
     *
     *
     * @returns detach handler - call detach() to detach from further updates
     */
    attachSizeBehaviorUpdate(
      /**
       * The function to be called once the property changes. It receives a parameter of type {@link sap.m.TileSizeBehavior}.
       */
      fnCallback: Function
    ): {
      detach: Function;
    };
  }
}

declare module "sap/ushell/services/ContentExtensionAdapterFactory" {
  /**
   * @since 1.62.0
   * @deprecated
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  interface ContentExtensionAdapterFactory {
    /**
     * Constructs a new instance of the Content Extension Adapter Factory. An array of adapter configurations
     * needs to be passed to it (one specific adapter for each extended content). The configuration can be passed
     * explicitly as an array vConfig or coded in ContentExtensionAdapterConfig.
     *
     * Once instantiated, it generates a map of all the needed adapters and returns them (as a promise) with
     * the method #getAdapterMap. Once the Promises resolve, the adapters are available in the map.
     *
     * IMPORTANT: aConfig.contentProviderName is the string any content would use to indicate the LaunchPage
     * service which adapter needs to be used through a field "contentProvider" e.g. oGroup.contentProvider
     *
     * Currently, the configuration mocks the content through FeatureGroupConfig and uses the local adapter.
     * This should be changed once a dedicated adapter for the extended content exists.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns A promise that resolves to a map of content provider names to adapter instances Note that the
     * map might contain undefined entries if the adapters are disabled.
     */
    getAdapters(
      /**
       * A configuration array for the different adapters of ContentExtensionAdapterFactory.
       */
      vConfigs: Array<{
        /**
         * The name of the adapter to find it in the service
         */
        contentProviderName: string;
        /**
         * The path to the adapter
         */
        adapter: string;
        /**
         * The path to the configuration flag for this adapter
         */
        config: string;
        /**
         * A system object for creating the system when instantiating the adapter
         */
        system: object;
        /**
         * A function that returns any needed configuration for the adapter
         */
        configHandler: Function;
      }>
    ): Promise<object>;
  }
  const ContentExtensionAdapterFactory: ContentExtensionAdapterFactory;
  /**
   * @deprecated
   */
  export default ContentExtensionAdapterFactory;
}

declare module "sap/ushell/services/CrossApplicationNavigation" {
  import Component from "sap/ui/core/Component";

  /**
   * The Unified Shell's CrossApplicationNavigation service. Allows navigating to "external" targets outside
   * of the currently running app (but still in scope of the current Fiori launchpad) or to create links to
   * such external targets.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const CrossApplicationNavigation = await Container.getServiceAsync("CrossApplicationNavigation");
   *     // do something with the CrossApplicationNavigation service
   *   });
   * ```
   *
   *
   * The CrossApplicationNavigation service currently provides platform independent functionality.
   *
   * The service is meant to be used by applications, plugins and shell components.
   *
   * Usage:
   * ```javascript
   *
   *      CrossApplicationNavigation.hrefForExternalAsync({
   *          target : {
   *              semanticObject: "Product",
   *              action: "display"
   *          },
   *          params: {
   *              "ProductID": "102343333"
   *          }
   *      }).then( function(sHref) {
   *          // Place sHref somewhere in the DOM
   *      });
   *   ```
   *
   *
   * Parameter names and values are case sensitive.
   *
   * Note that the usage of multi-valued parameters (specifying an array with more than one member as parameter
   * value, e.g. `params : { A : ["a1", "a2"] }`) is possible with this API but **strongly discouraged**.
   * Depending on the used platform / back-end implementation the target matching might not supported multi-value
   * parameters. Furthermore, it is not guaranteed that additional parameter values specified in the back-end
   * configuration are merged with parameter values passed in this method.
   *
   * Note that the application parameter length (including SemanticObject/Action) shall not exceed 512 bytes
   * when serialized as UTF-8.
   *
   * Note that when receiving the values as startup parameters (as part of the component data object) single
   * values are represented as an array of size 1. Above example is returned as ` deepEqual(getComponentData().startupParameters
   * , { "ProductID" : [ "102343333" ] } ) `
   *
   * Make sure not to store security critical data within an URL. URLs may appear in a server log, be persisted
   * inside and outside the system.
   *
   * Note: When constructing large URLs, the URLs may be shortened and persisted on a database server for
   * prolonged time, the actual data is persisted under a key accessible to any User (guessing the key).
   *
   * The same restrictions apply for the Application state.
   *
   * @since 1.15.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.Navigation} instead.
   */
  export default class CrossApplicationNavigation extends sap.ushell.services
    .Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Attempts to use the browser history to navigate to the previous app.
     *
     * A navigation to the Fiori launchpad Home is performed when this method is called on a first navigation.
     * In all other cases, this function simply performs a browser back navigation.
     *
     * Note that the behavior of this method is subject to change and therefore it may not yield to the expected
     * results especially on mobile devices where "back" is the previous inner-app state if these are put into
     * the history!
     *
     *
     * @returns A promise which resolves once the back navigation was triggered
     */
    backToPreviousApp(): Promise<undefined>;
    /**
     * if sHashFragment is a compacted hash (sap-intent-param is present), in a hash, this function replaces
     * it into a long url with all parameters expanded
     *
     *
     * @returns Resolves the expanded shell hash as first argument.
     */
    expandCompactHash(
      /**
       * an (internal format) shell hash
       */
      sHashFragment: string
    ): jQuery.Promise;
    /**
     * Returns a list of semantic objects of the intents the current user can navigate to.
     *
     * @since 1.38.0
     *
     * @returns Resolves with an array of strings representing the semantic objects of the intents the current
     * user can navigate to, or rejects with an error message. The returned array will not contain duplicates.
     * NOTE: the caller should not rely on the specific order the semantic objects appear in the returned
     * array.
     */
    getDistinctSemanticObjects(): jQuery.Promise;
    /**
     * Resolves the given semantic object (and action) and business parameters to a list of links available
     * to the user.
     *
     * @since 1.38.0
     *
     * @returns Resolves with an array of link objects containing (at least) the following properties:
     * ```javascript
     *
     *   {
     *     intent: "#AnObject-Action?A=B&C=e&C=j",
     *     text: "Perform action",
     *     icon: "sap-icon://Fiori2/F0018", // optional
     *     subTitle: "Action", //optional
     *     shortTitle: "Perform"            // optional
     *     tags: ["tag-1", "tag-2"]         // optional
     *   }
     *  ```
     *
     *
     *  Properties marked as 'optional' in the example above may not be present in the returned result.
     *
     *  **NOTE:** the intents returned are in **internal** format and cannot be directly put into a link
     * tag.  Example: Let the string `"C&A != H&M"` be a parameter value.
     *
     * Intent will be encoded as#AnObject-action?text=C%26A%20!%3D%20H%26M. Note that the intent
     * is in **internal** format, before putting it into a link tag, you must invoke:
     * ```javascript
     *
     *   externalHash = oCrossApplicationNavigationService.hrefForExternal({ target : { shellHash :  oLink.intent } }, that.oComponent);
     * ```
     *    NOTE: in case the mass invocation interface is used (see `vArgs` parameter explanation above),
     * the promise will resolve to an array of arrays of arrays. For example, if the mass interface specified
     * two arguments, the promise would resolve as follows:
     * ```javascript
     *
     *     [     // mass interface was used, so return multiple values
     *       [  // values returned from the first call (functions may return multiple values)
     *          // value returned from first getLinks call (as returned by single getLinks call)
     *          [
     *            {intent: "#SO-something1", text: "Perform navigation"},
     *            {intent: "#SO-something2", text: "Perform action"} ],
     *          ]
     *       ],
     *       [
     *          // value returned from second getLinks call (as returned by single getLinks call)
     *          [
     *            {intent: "#Object-someAction", text: "Some action1"}
     *          ]
     *       ]
     *       // ... and so on
     *     ]
     *     ```
     */
    getLinks(
      /**
       * An object containing nominal arguments for the method, having the following structure:
       *
       *
       * ```javascript
       *
       *   {
       *      semanticObject: "Object", // optional, matches any semantic objects if undefined
       *      action: "action",         // optional, matches any actions if undefined
       *      params: {                 // optional business parameters
       *         A: "B",
       *         C: ["e", "j"]
       *      },
       *      withAtLeastOneUsedParam: true, // optional, defaults to false.
       *                                     // If true, returns only the links that use at least one (non sap-) parameter from 'params'.
       *
       *      sortResultsBy: "intent", // optional parameter that decides on how the returned results will be sorted.
       *                               // Possible values are:
       *                               //   - "intent" (default) lexicographical sort on returned 'intent' field
       *                               //   - "text" lexicographical sort on returned 'text' field
       *                               //   - "priority" experimental - top intents are returned first
       *
       *      treatTechHintAsFilter : true, // optional, defaults to false.
       *                                    // if true, only apps that match exactly the supplied technology (e.g. sap-ui-tech-hint=WDA) will be considered.
       *
       *      ui5Component: UI5Component, // mandatory, the UI5 component invoking the service, shall be a root component!
       *
       *      appStateKey: "abc123...",   // optional, application state key to add to the generated links, SAP internal usage only.
       *
       *      compactIntents: true        // optional, whether intents should be returned in compact format. Defaults to false.
       *
       *      ignoreFormFactor: true,     // optional, defaults to false, deprecated, do not use, may have no effect in the future.
       *
       *      tags: ["tag-1", "tag-2"]    // optional, if specified, only returns links that match inbound with certain tags.
       *   }
       *   ```
       *
       *
       * Starting from UI5 version 1.52.0 the `params` argument can be specified in the extended format:
       *
       *
       * ```javascript
       *
       *   ...
       *   params: {
       *      P1: { value: "v1" },
       *      P2: { value: ["v2", "v3"] }
       *   }
       *   ```
       *
       *
       * When the parameter is expressed in this format, the caller can specify additional search options.
       *
       * Besides 'value', supported search options for the extended format are:
       * 	 **required**: whether the parameter must be required (true) or not required (false) in the signature
       * of the matching target (once the navigation occurs to the returned link). Note that this option will
       * be effective if the Fiori Launchpad is configured to resolve navigation targets via `sap.ushell.services.ClientSideTargetResolution`
       * and therefore may not be supported in all platforms.
       *
       * Example:
       * ```javascript
       *
       *         ...
       *         params: {
       *           P1: { value: "v1", required: true },
       *           P2: { value: ["v2", "v3"] }
       *         }
       *         ...
       *       ```
       *
       *
       * This method supports a mass invocation interface to obtain multiple results with a single call, as
       * shown in the following example:
       *
       *
       * ```javascript
       *
       *     oCrossApplicationService.getLinks([ // array, because multiple invocations are to be made
       *        [                           // arguments for the first invocation
       *          { semanticObject: "SO" }  // this method supports one parameter only in each call
       *        ],
       *        [                           // arguments for the second invocation
       *          { action: "someAction" }
       *        ]
       *        // ... and so on
       *     ]).done(…);
       *   ```
       *
       *
       * Calling this method with no arguments will produce the same result as if the method was called with
       * an empty object.
       */
      vArgs?:
        | {
            /**
             * Optional, matches any semantic objects if undefined
             */
            semanticObject?: string;
            /**
             * Optional, matches any actions if undefined
             */
            action?: string;
            /**
             * Optional business parameters
             */
            params?: object;
            /**
             * Optional, defaults to false. If true, returns only the links that use at least one (non sap-) parameter
             * from 'params'.
             */
            withAtLeastOneUsedParam?: boolean;
            /**
             * Optional parameter that decides on how the returned results will be sorted.
             */
            sortResultsBy?: string;
            /**
             * Optional, defaults to false. If true, only apps that match exactly the supplied technology (e.g. sap-ui-tech-hint=WDA)
             * will be considered.
             */
            treatTechHintAsFilter?: boolean;
            /**
             * Mandatory, the UI5 component invoking the service, shall be a root component.
             */
            ui5Component: Component;
            /**
             * Optional, application state key to add to the generated links, SAP internal usage only.
             */
            appStateKey?: string;
            /**
             * Optional, whether intents should be returned in compact format. Defaults to false.
             */
            compactIntents?: boolean;
            /**
             * Optional, if specified, only returns links that match inbound with certain tags.
             */
            tags?: string[];
          }
        | Array<{
            /**
             * Optional, matches any semantic objects if undefined
             */
            semanticObject?: string;
            /**
             * Optional, matches any actions if undefined
             */
            action?: string;
            /**
             * Optional business parameters
             */
            params?: object;
            /**
             * Optional, defaults to false. If true, returns only the links that use at least one (non sap-) parameter
             * from 'params'.
             */
            withAtLeastOneUsedParam?: boolean;
            /**
             * Optional parameter that decides on how the returned results will be sorted.
             */
            sortResultsBy?: string;
            /**
             * Optional, defaults to false. If true, only apps that match exactly the supplied technology (e.g. sap-ui-tech-hint=WDA)
             * will be considered.
             */
            treatTechHintAsFilter?: boolean;
            /**
             * Mandatory, the UI5 component invoking the service, shall be a root component.
             */
            ui5Component: Component;
            /**
             * Optional, application state key to add to the generated links, SAP internal usage only.
             */
            appStateKey?: string;
            /**
             * Optional, whether intents should be returned in compact format. Defaults to false.
             */
            compactIntents?: boolean;
            /**
             * Optional, if specified, only returns links that match inbound with certain tags.
             */
            tags?: string[];
          }>
    ): jQuery.Promise;
    /**
     * For a given semantic object, this method considers all actions associated with the semantic object and
     * returns the one tagged as a "primaryAction". If no inbound tagged as "primaryAction" exists, then the
     * intent of the first inbound (after sorting has been applied) matching the action "displayFactSheet".
     *
     * The primary intent is determined by querying {@link sap.ushell.services.CrossApplicationNavigation#getLinks }
     * with the given semantic object and optional parameter. Then the resulting list is filtered to the outcome
     * that a single item remains.
     *
     * @since 1.48
     *
     * @returns Resolves to an object of the following form when a relevant link object exists:
     * ```javascript
     *
     *   {
     *     intent: "#AnObject-Action?A=B&C=e&C=j",
     *     text: "Perform action",
     *     icon: "sap-icon://Fiori2/F0018", // optional
     *     shortTitle: "Perform"            // optional
     *     tags: ["tag-1", "tag-2"]         // optional
     *   }
     *   ```
     *  Otherwise, the returned promise will resolve to null when no relevant link object exists.
     */
    getPrimaryIntent(
      /**
       * Semantic object.
       */
      sSemanticObject: string,
      /**
       * @see sap.ushell.services.CrossApplicationNavigation#getSemanticObjectLinks for description.
       */
      mParameters?: object
    ): jQuery.Promise;
    /**
     * Resolves a given semantic object and business parameters to a list of links, taking into account the
     * form factor of the current device.
     *
     * @since 1.19.0
     * @deprecated As of version 1.38. Please use {@link #getLinks} instead.
     *
     * @returns Resolves with an array of link objects containing (at least) the following properties:
     * ```javascript
     *
     *   {
     *     intent: "#AnObject-action?A=B&C=e",
     *     text: "Perform action",
     *     icon: "sap-icon://Fiori2/F0018", //optional
     *     subTitle: "Action", //optional
     *     shortTitle: "Perform" //optional
     *   }
     * ```
     *
     *
     * **NOTE:** the intents returned are in **internal** format and cannot be directly put into a link tag.
     *  Example: Let the string `"C&A != H&M"` be a parameter value. Intent will be encoded as#AnObject-action?text=C%26A%20!%3D%20H%26M.
     * Note that the intent is in **internal** format, before putting it into a link tag, you must invoke:
     * ```javascript
     *
     *   externalHash = oCrossApplicationNavigationService.hrefForExternal({ target : { shellHash :  oLink.intent } }, that.oComponent);
     * ```
     */
    getSemanticObjectLinks(
      /**
       * the semantic object such as `"AnObject"`
       */
      sSemanticObject: string,
      /**
       * the map of business parameters with values, for instance
       * ```javascript
       *
       *   {
       *     A: "B",
       *     c: "e"
       *   }
       * ```
       */
      mParameters?: object,
      /**
       * when set to `true` the form factor of the current device is ignored
       */
      bIgnoreFormFactor?: boolean,
      /**
       * SAP UI5 Component invoking the service
       */
      oComponent?: object,
      /**
       * application state key to add to the generated links, SAP internal usage only
       */
      sAppStateKey?: string,
      /**
       * whether the returned intents should be returned in compact format. Defaults to false.
       */
      bCompactIntents?: boolean
    ): jQuery.Promise;
    /**
     * Navigates back in history the number of given steps if this is supported by the underlying platform.
     * If no argument is provided it will navigate back 1 step.
     */
    historyBack(
      /**
       * positive integer representing the steps to go back in the history
       */
      iSteps: int
    ): void;
    /**
     * Returns a string which can be put into the DOM (e.g. in a link tag) given an application specific hash
     * suffix
     *
     * Example: `hrefForAppSpecificHash("View1/details/0/")` returns `#SemanticObject-action&/View1/details/0/`
     * if the current application runs in the shell and was started using "SemanticObject-action" as shell navigation
     * hash
     *
     * @since 1.15.0
     * @deprecated As of version 1.94. Please use {@link #hrefForAppSpecificHashAsync} instead.
     *
     * @returns A string which can be put into the link tag, containing the current shell navigation target
     * and the specified application specific hash suffix
     */
    hrefForAppSpecificHash(
      /**
       * the app specific router, obtained e.g. via router.getURL(...). Note that sAppHash shall not exceed 512
       * bytes when serialized as UTF-8.
       */
      sAppHash: string
    ): string;
    /**
     * Returns a Promise which resolves a string that can be put into the DOM (e.g. in a link tag) given an
     * application specific hash suffix
     *
     * Example: `hrefForAppSpecificHashAsync("View1/details/0/")` returns a Promise that resolves: `#SemanticObject-action&/View1/details/0/`
     * if the current application runs in the shell and was started using "SemanticObject-action" as shell navigation
     * hash
     *
     * @since 1.94.0
     *
     * @returns A promise which resolves a string which can be put into the link tag, containing the current
     * shell navigation target and the specified application specific hash suffix
     */
    hrefForAppSpecificHashAsync(
      /**
       * the app specific router, obtained e.g. via router.getURL(...). Note that sAppHash shall not exceed 512
       * bytes when serialized as UTF-8.
       */
      sAppHash: string
    ): Promise<string>;
    /**
     * Returns a string which can be put into the DOM (e.g. in a link tag). **Note:** The generated url / url
     * segment must not be used as `shellHash` in the target definition of {@link sap.ushell.services.CrossApplicationNavigation#toExternal}
     *
     * @since 1.15.0
     * @deprecated As of version 1.98. Please use {@link #hrefForExternalAsync} instead.
     *
     * @returns the href for the specified parameters as an external shell hash; always starting with a hash
     * character; all parameters and parameter names are URL-encoded (via encodeURIComponent) and the complete
     * string is encoded via encodeURI (!). The generated string can not be used in the majority of interfaces
     * which expect a internal shell hash.
     *
     * A proper way for an application to generate a link to return to the home page of the Fiori launchpad
     * is: `hrefForExternal( { target : { shellHash : "#" }})`
     *
     * Do not use "#Shell-home" to navigate to a specific homepage!
     *
     * Note: if object is undefined, the current shell hash is returned.
     *
     * Note that the application parameter length (including SemanticObject/Action) shall not exceed 512 bytes
     * when serialized as UTF-8.
     *
     * The function can be used to convert an shell hash internal format commonly encountered into the URL format
     * to use in link tags:
     * ```javascript
     *
     *   externalHash = oCrossApplicationNavigationService.hrefForExternal({
     *       target: { shellHash: oLink.intent }
     *   }, that.oComponent);
     *   ```
     *
     *
     * Since version 1.56 this API accepts a sap-xapp-state-data parameter that can be used generate a url that
     * can be used to launch and application with certain data, for example:
     * ```javascript
     *
     *   {
     *     target : { semanticObject : "AnObject", action: "action" },
     *     params : { "sap-xapp-state-data" : JSON.stringify({ a: "b", c: "d" }) }
     *   }
     *   ```
     *
     *
     * Using the arguments as in the example above, a link with a sap-xapp-state parameter that encodes the
     * provided data is returned. The sap-xapp-state-data parameter does not appear in the generated link.
     */
    hrefForExternal(
      /**
       * object encoding a semantic object and action, e.g.
       * ```javascript
       *
       *   {
       *     target : { semanticObject : "AnObject", action: "action" },
       *     params : { A : "B" }
       *   }
       *   ```
       *  or e.g.
       * ```javascript
       *
       *   {
       *     target : {
       *       semanticObject : "AnObject",
       *       action: "action", context  : "AB7F3C"
       *     },
       *     params : {
       *       A : "B",
       *       c : "e"
       *     }
       *   }
       *   ```
       *  or
       * ```javascript
       * { target : { shellHash : "SO-36?jumper=postman" } }```
       */
      oArgs: object,
      /**
       * the root component of the application
       */
      oComponent: object,
      /**
       * if set to `true`, a promise will be returned instead of the direct argument. The promise will only succeed
       * after all compaction requests have been sent. `bAsync=false` is deprecated since 1.94.
       */
      bAsync: boolean
    ): string | Promise<string>;
    /**
     * Returns a string which can be put into the DOM (e.g. in a link tag). **Note:** The generated url / url
     * segment must not be used as `shellHash` in the target definition of {@link sap.ushell.services.CrossApplicationNavigation#toExternal}
     *
     * @since 1.15.0
     * @deprecated As of version 1.98. Please use {@link #hrefForExternalAsync} instead.
     *
     * @returns the href for the specified parameters as an external shell hash; always starting with a hash
     * character; all parameters and parameter names are URL-encoded (via encodeURIComponent) and the complete
     * string is encoded via encodeURI (!). The generated string can not be used in the majority of interfaces
     * which expect a internal shell hash.
     *
     * A proper way for an application to generate a link to return to the home page of the Fiori launchpad
     * is: `hrefForExternal( { target : { shellHash : "#" }})`
     *
     * Do not use "#Shell-home" to navigate to a specific homepage!
     *
     * Note: if object is undefined, the current shell hash is returned.
     *
     * Note that the application parameter length (including SemanticObject/Action) shall not exceed 512 bytes
     * when serialized as UTF-8.
     *
     * The function can be used to convert an shell hash internal format commonly encountered into the URL format
     * to use in link tags:
     * ```javascript
     *
     *   externalHash = oCrossApplicationNavigationService.hrefForExternal({
     *       target: { shellHash: oLink.intent }
     *   }, that.oComponent);
     *   ```
     *
     *
     * Since version 1.56 this API accepts a sap-xapp-state-data parameter that can be used generate a url that
     * can be used to launch and application with certain data, for example:
     * ```javascript
     *
     *   {
     *     target : { semanticObject : "AnObject", action: "action" },
     *     params : { "sap-xapp-state-data" : JSON.stringify({ a: "b", c: "d" }) }
     *   }
     *   ```
     *
     *
     * Using the arguments as in the example above, a link with a sap-xapp-state parameter that encodes the
     * provided data is returned. The sap-xapp-state-data parameter does not appear in the generated link.
     */
    hrefForExternal(
      /**
       * object encoding a semantic object and action, e.g.
       * ```javascript
       *
       *   {
       *     target : { semanticObject : "AnObject", action: "action" },
       *     params : { A : "B" }
       *   }
       *   ```
       *  or e.g.
       * ```javascript
       *
       *   {
       *     target : {
       *       semanticObject : "AnObject",
       *       action: "action", context  : "AB7F3C"
       *     },
       *     params : {
       *       A : "B",
       *       c : "e"
       *     }
       *   }
       *   ```
       *  or
       * ```javascript
       * { target : { shellHash : "SO-36?jumper=postman" } }```
       */
      oArgs: object,
      /**
       * if set to `true`, a promise will be returned instead of the direct argument. The promise will only succeed
       * after all compaction requests have been sent. `bAsync=false` is deprecated since 1.94.
       */
      bAsync: boolean
    ): string | Promise<string>;
    /**
     * Returns a promise resolving to a URL that launches an app with certain parameters. The URL can be used
     * to define a link to a Fiori application, for example.
     *
     * @since 1.94.0
     *
     * @returns A Promise which resolves href for the specified parameters as an *external* shell hash; always
     * starting with a hash character; all parameters and parameter names are URL-encoded (via encodeURIComponent)
     * and the complete string is encoded via encodeURI (!). The generated string can not be used in the majority
     * of interfaces which expect a internal shell hash.
     *
     * A proper way for an application to generate a link to return to the home page of the Fiori launchpad
     * is: `hrefForExternalAsync( { target : { shellHash : "#" }})`
     *
     * Do *not* use "#Shell-home" to navigate to a specific homepage!
     *
     * Note: if object is undefined, the current shell hash is returned.
     *
     * Note that the application parameter length (including SemanticObject/Action) shall not exceed 512 bytes
     * when serialized as UTF-8.
     *
     * The function can be used to convert an shell hash internal format commonly encountered into the URL format
     * to use in link tags:
     * ```javascript
     *
     *   CrossApplicationNavigation.hrefForExternalAsync({
     *       target: { shellHash: oLink.intent }
     *   }, that.oComponent).then( function (sExternalHref) {
     *        // do something with the resolved sExternalHref.
     *   });
     * ```
     *
     *
     * This API accepts a sap-xapp-state-data parameter that can be used generate a url that can be used to
     * launch and application with certain data, for example:
     *
     *
     * ```javascript
     *
     *   {
     *     target : { semanticObject : "AnObject", action: "action" },
     *     params : { "sap-xapp-state-data" : JSON.stringify({ a: "b", c: "d" }) }
     *   }
     * ```
     *
     *
     * Using the arguments as in the example above, a link with a sap-xapp-state parameter that encodes the
     * provided data is returned. The sap-xapp-state-data parameter does not appear in the generated link.
     */
    hrefForExternalAsync(
      /**
       * object encoding a semantic object and action, e.g.
       * ```javascript
       *
       *   {
       *     target : { semanticObject : "AnObject", action: "action" },
       *     params : { A : "B" }
       *   }
       * ```
       *  or e.g.
       * ```javascript
       *
       *   {
       *     target : {
       *       semanticObject : "AnObject",
       *       action: "action", context  : "AB7F3C"
       *     },
       *     params : {
       *       A : "B",
       *       c : "e"
       *     }
       *   }
       * ```
       *  or
       * ```javascript
       *
       *   {
       *     target : {
       *       shellHash : "SO-36?jumper=postman"
       *     }
       *   }
       *  ```
       */
      oArgs: object,
      /**
       * the root component of the application
       */
      oComponent?: object
    ): Promise<string>;
    /**
     * Checks wether the FLP currently shows the initially loaded navigation target (i.e. the intent it was
     * started with). This method can be used to e.g. detect whether the current app was started directly, that
     * is, without a navigation from another app or FLP home.
     *
     * @since 1.36.0
     * @deprecated As of version 1.94. Please use {@link #isInitialNavigationAsync} instead.
     *
     * @returns Whether the initial navigation occurred.
     */
    isInitialNavigation(): boolean;
    /**
     * Checks whether the FLP has performed the first navigation. This method can be used to detect whether
     * the current app was started directly, that is, without a previous navigation to another app, to the FLP
     * home, or another target that adds an entry in the browser history.
     *
     * @since 1.94.0
     *
     * @returns This promise resolves with a boolean indicating if the current navigation is considered initial
     */
    isInitialNavigationAsync(): Promise<boolean>;
    /**
     * Tells whether the given intent(s) are supported, taking into account the form factor of the current device.
     * "Supported" means that navigation to the intent is possible. Note that the intents are assumed to be
     * in internal format and expanded.
     *
     * @since 1.19.1
     * @deprecated As of version 1.31. Please use {@link #isNavigationSupported} instead. Note that this has
     * a slightly different response format.
     *
     * @returns Resolves with a map containing the intents from `aIntents` as keys. The map values are objects
     * with a property `supported` of type `boolean`.
     *  Example:
     * ```javascript
     *
     *     {
     *       "#AnObject-action?A=B&c=e": { supported: false },
     *       "#AnotherObject-action2": { supported: true }
     *     }
     *     ```
     *
     *
     * Example usage:
     * ```javascript
     *
     *   this.oCrossAppNav.isIntentSupported(["SalesOrder-approve?SOId=1234"])
     *   .done(function(aResponses) {
     *     if (oResponse["SalesOrder-approve?SOId=1234"].supported===true){
     *       // enable link
     *     }
     *     else {
     *       // disable link
     *     }
     *   })
     *   .fail(function() {
     *     // disable link
     *     // request failed or other error
     *   });
     * ```
     */
    isIntentSupported(
      /**
       * the intents (such as `["#AnObject-action?A=B&c=e"]`) to be checked
       */
      aIntents: string[],
      /**
       * the root component of the application
       */
      oComponent?: object
    ): jQuery.Promise;
    /**
     * Tells whether the given navigation intents are supported for the given parameters, form factor etc. .
     * "Supported" means that a valid navigation target is configured for the user and for the given device.
     *
     * `isNavigationSupported` is effectively a test function for {@link sap.ushell.services.CrossApplicationNavigation#toExternal }
     * and {@link sap.ushell.services.CrossApplicationNavigation#hrefForExternal}.
     *
     * It is functionally equivalent to {@link sap.ushell.services.CrossApplicationNavigation#isIntentSupported }
     * but accepts the same interface as {@link sap.ushell.services.CrossApplicationNavigation#toExternal} and
     * {@link sap.ushell.services.CrossApplicationNavigation#hrefForExternal}.
     *
     * @since 1.32
     *
     * @returns Resolves to an array of objects indicating whether the intent is supported or not. Each object
     * has a property `supported` of type `boolean`.
     *
     * Example:
     *
     * `aIntents`:
     * ```javascript
     *
     *   [
     *     {
     *       target : {
     *         semanticObject : "AnObject",
     *         action: "action"
     *       },
     *       params : { P1 : "B", P2 : [ "V2a", "V2b"]  }
     *     },
     *     {
     *       target : {
     *         semanticObject : "SalesOrder",
     *         action: "display"
     *       },
     *       params : { P3 : "B", SalesOrderIds : [ "4711", "472"] }
     *     }
     *   ]
     *   ```
     *
     *
     * `response`:
     * ```javascript
     *
     *   [
     *     { supported: false },
     *     { supported: true }
     *   ]
     *   ```
     *
     *
     * Example usage:
     * ```javascript
     *
     *   this.oCrossAppNav.isNavigationSupported([
     *     target: { shellHash: "SalesOrder-approve?SOId=1234" }
     *   ])
     *   .done(function(aResponses) {
     *     if (aResponses[0].supported===true){
     *       // enable link
     *     }
     *     else {
     *       // disable link
     *     }
     *   })
     *   .fail(function() {
     *     // disable link
     *     // request failed or other fatal error
     *   });
     * ```
     */
    isNavigationSupported(
      /**
       * The intents to be checked, with `object[]` being instances of the `oArgs` argument of the `toExternal`
       * or `hrefForExternal` methods, e.g.
       * ```javascript
       *
       *   {
       *     target: {
       *       semanticObject: "AnObject",
       *       action: "action"
       *     },
       *     params: { A: "B" }
       *   }
       * ```
       *  or e.g.
       * ```javascript
       *
       *   {
       *     target: {
       *       semanticObject: "AnObject",
       *       action: "action"
       *     },
       *     params: {
       *       A: "B",
       *       c: "e"
       *     }
       *   }
       * ```
       *  or
       * ```javascript
       *
       *   {
       *     target: {
       *        shellHash: "SalesOrder-approve?SOId=1234"
       *     }
       *   }
       * ```
       */
      aIntents: object[],
      /**
       * The root component of the application
       */
      oComponent?: object
    ): jQuery.Promise;
    /**
     * Resolves the URL hash fragment.
     *
     * This function gets the hash part of the URL and returns the URL of the target application.
     *
     * This is an asynchronous operation.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Resolves the intent.
     */
    resolveIntent(
      /**
       * The formatted URL hash fragment in internal format (as obtained by the SAPUI5 hasher service) not as
       * given in `location.hash`)! Example: `#SemanticObject-action?P1=V1&P2=A%20B%20C`
       */
      sHashFragment: string
    ): jQuery.Promise;
    /**
     * Triggers a navigation to a specified target outside of the currently running application (e.g. different
     * launchpad application). Invocation will trigger a hash change and subsequent invocation of the target.
     *
     * If the navigation target opens in a new window the running application may be retained.
     *
     * @since 1.15.0
     *
     * @returns A `Promise` which resolves once the navigation was triggered. The `Promise` might never reject
     * or resolve when an error occurs during the navigation.
     */
    toExternal(
      /**
       * A configuration object describing the navigation target. The navigation target can be provided as its
       * separate aspects like semantic object, action, parameters etc. in separate members of the configuration
       * object.
       *
       * **Note:** Parameter values can contain special characters and must be provided unencoded; the function
       * takes care for necessary encodings itself.
       *
       * Simple Example:
       * ```javascript
       *
       * {
       *   target: {
       *     semanticObject: "Customer",
       *     action: "display"
       *   },
       *   params: {
       *     customerId: "0815-4711"
       *   }
       * }
       * ```
       *
       *
       * Example with text:
       * ```javascript
       *
       * {
       *   target: {
       *     semanticObject: "Note",
       *     action: "create"
       *   },
       *   params: {
       *     noteText: "Thanks for reading the documentation!"
       *   }
       * }
       * ```
       *
       *
       * Example with a given context:
       * ```javascript
       *
       * {
       *   target: {
       *     semanticObject: "AnObject",
       *     action: "action",
       *     context: "AB7F3C"
       *   },
       *   params: {
       *     param1: "Value One"
       *   }
       * }
       * ```
       *
       *
       * Alternatively a `shellHash` can be provided that includes already all aspects of the navigation target:
       * semantic object, action, intent parameters, app-specific route (including app parameters)
       *
       * **Note:** While parameters need to be url-encoded once when used in the `shellHash` the app specific
       * route must not be encoded.
       *
       * Example with shellHash as target:
       * ```javascript
       *
       * {
       *   target: {
       *     shellHash: "Note-update?noteText=You%20got%20quite%20far&/Notes/My First Note"
       *   }
       * }
       * ```
       *
       *
       * To navigate to the homepage of the Fiori launchpad, navigate to `{target: {shellHash: "#"}}`. Do not
       * use "#Shell-home" or "Shell-home" to navigate to!
       *
       * To provide a complex parameter structure to a target app the pseudo parameter `sap-xapp-state-data` can
       * be used.
       *
       * Example:
       * ```javascript
       *
       * {
       *   ...
       *   params : {
       *     "sap-xapp-state-data": JSON.stringify({ a: "b", c: "d" })
       *   }
       * }
       * ```
       *
       *
       * The data specified via `sap-xapp-state-data` is passed to the target application in the `sap-xapp-state`
       * parameter. The `sap-xapp-state-data` parameter itself is not passed to the target application.
       *
       * **Note:** The parameter length (including semantic object and action) shall not exceed 512 bytes when
       * serialized as UTF-8.
       */
      oArgs: object,
      /**
       * an optional UI5 component, used to logically attach a possibly generated app state.
       */
      oComponent?: object
    ): Promise<undefined>;
  }
}

declare module "sap/ushell/services/EndUserFeedback" {
  /**
   * The Unified Shell's end user feedback service. This service is deprecated and does nothing. End user
   * feedback functionality is not part of the ushell library.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const EndUserFeedback = await Container.getServiceAsync("EndUserFeedback");
   *     // do something with the EndUserFeedback service
   *   });
   * ```
   *
   *
   * @since 1.25.1
   * @deprecated As of version 1.93.
   */
  export default class EndUserFeedback extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * @since 1.25.1
     * @deprecated As of version 1.93.
     *
     * @returns Empty string
     */
    getLegalText(): string;
    /**
     * The service is deprecated. The function always returns a negative answer.
     *
     * @since 1.25.1
     * @deprecated As of version 1.93.
     *
     * @returns Rejected promise.
     */
    isEnabled(): Promise<any>;
    /**
     * Sends a feedback.
     *
     * @since 1.25.1
     * @deprecated As of version 1.93.
     *
     * @returns Empty promise
     */
    sendFeedback(): Promise<any>;
  }
}

declare module "sap/ushell/services/Extension" {
  import { Properties } from "sap/ushell/ui/shell/ShellHeadItem";

  import Item from "sap/ushell/services/Extension/Item";

  /**
   * The Unified Shell's Extension service. Allows adding extensions on the user's home page.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Extension = await Container.getServiceAsync("Extension");
   *     // do something with the Extension service
   *   });
   * ```
   *
   *
   * This service is available in any FLP context (native, iframe, ...).
   *
   *
   *  All extension items and extension areas are instantiated as invisible. You have to call .show<...> to
   * make them visible.
   *
   * @since 1.120.0
   */
  export default class Extension extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a header item in the shell header. **Restrictions:**
     * 	 - The control properties are only allowed to contain primitive properties and event handlers. Aggregations,
     *     controls and types with prototypes are not allowed!
     * 	 - The event handlers are not bound to the actual control and do not receive the event arguments.
     *
     * @since 1.120.0
     *
     * @returns The newly created header item.
     */
    createHeaderItem(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: Properties,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Possible values are `begin` and `end`.
         */
        position?: string;
      }
    ): Promise<Item>;
    /**
     * Creates a user action in the user action menu.
     *  The `controlType` can be any control and is by default a {@link sap.ushell.ui.launchpad.ActionItem}.
     * The `controlProperties` are passed to the constructor of the control.
     *  **Restrictions:**
     * 	 - The control properties are only allowed to contain primitive properties and event handlers. Aggregations,
     *     controls and types with prototypes are not allowed!
     * 	 - The event handlers are not bound to the actual control and do not receive the event arguments.
     *
     * @since 1.120.0
     *
     * @returns The newly created user action.
     */
    createUserAction(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: object,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Defines the `controlType` of the item.
         */
        controlType?: string;
      }
    ): Promise<Item>;
  }
}

declare module "sap/ushell/services/Extension/Item" {
  /**
   * Item wrapping an item positioned in an extension point. To be instantiated by {@link sap.ushell.services.Extension}.
   *
   *  The item will be automatically destroyed when the user navigates away from the current application.
   * After calling {@link sap.ushell.services.Extension.Item#showOnHome} or {@link sap.ushell.services.Extension.Item#showForAllApps }
   * the item is not destroyed automatically and has to be destroyed manually via {@link sap.ushell.services.Extension.Item#destroy}.
   *
   * @since 1.120.0
   */
  export default class Item {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Destroys the item and it's related content.
     *
     * @since 1.120.0
     *
     * @returns Resolves once the item was destroyed.
     */
    destroy(): Promise<any>;
    /**
     * Shows the item for all applications. Does not change the visibility of the item for the launchpad "home".
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideForAllApps(): this;
    /**
     * Hides the item for the current application.
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideForCurrentApp(): this;
    /**
     * Hides the item for launchpad "home". Does not change the visibility of the item within applications.
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideOnHome(): this;
    /**
     * Shows the item for all applications. Does not change the visibility of the item for the launchpad "home".
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showForAllApps(): this;
    /**
     * Shows the item for the current application. The item will be hidden after the user navigates away from
     * this application. The item will not be added again if the user navigates back to the application.
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showForCurrentApp(): this;
    /**
     * Shows the item for launchpad "home". Does not change the visibility of the item within applications.
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showOnHome(): this;
  }
}

declare module "sap/ushell/services/FrameBoundExtension" {
  import Control from "sap/ui/core/Control";

  import UserSettingsEntry from "sap/ushell/services/FrameBoundExtension/UserSettingsEntry";

  import Footer from "sap/ushell/services/FrameBoundExtension/Footer";

  import { Properties } from "sap/ushell/ui/shell/ShellHeadItem";

  import Item from "sap/ushell/services/FrameBoundExtension/Item";

  import SidePane from "sap/ushell/services/FrameBoundExtension/SidePane";

  import ToolArea from "sap/ushell/services/FrameBoundExtension/ToolArea";

  /**
   * The Unified Shell's Extension service. Allows adding extensions on the user's home page.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call `sap.ushell.Container.getServiceAsync("FrameBoundExtension")`.
   * For details, see {@link sap.ushell.Container#getServiceAsync}.
   *
   * **Restriction:** This Service does not work when called from within a iframe. The calling function
   * has to be in the 'same frame' as the launchpad itself.
   *
   *
   *  All extension items and extension areas are instantiated as invisible. You have to call .show<...> to
   * make them visible.
   *
   * @since 1.124.0
   */
  export default class FrameBoundExtension extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Adds an entry to the user settings dialog box including the UI control that appears when the user clicks
     * the new entry, and handling of user settings actions such as SAVE and CANCEL. **Restriction:** NOT
     * available for apps running in an iframe
     *
     * @since 1.124.0
     *
     * @returns Resolves with the new entry once the settings entry was added.
     */
    addUserSettingsEntry(
      /**
       * The data of the new added user settings entry.
       */
      properties: {
        /**
         * The ID of the object.
         */
        entryHelpID?: string;
        /**
         * The title of the entry to be presented in the list in the user settings dialog box. We recommend using
         * a string from the translation bundle.
         */
        title: string;
        /**
         * A string to be presented as the subtitle of the entry OR a function which resolves the sub title.
         */
        value: string | (() => Promise<string>);
        /**
         * A function that resolves the content which has to be a {@link sap.ui.core.Control}. A SAPUI5 view instance
         * can also be returned. The result will be displayed in the settings as content for this entry.
         */
        content: () => Promise<Control>;
        /**
         * A callback which is called when the user clicks "save" in the user settings dialog. The function has
         * to return a native promise. If an error occurs, pass the error message via rejected promise. Errors are
         * displayed in the common log.
         */
        onSave: () => Promise<any>;
        /**
         * A callback which is called when the user closes the user settings dialog without saving any changes.
         */
        onCancel: Function;
        /**
         * Set this value to `true` if you want that your content is displayed without the standard header.
         */
        provideEmptyWrapper?: boolean;
      }
    ): Promise<UserSettingsEntry>;
    /**
     * Creates a new footer which is positioned below the launchpad content.
     *
     * The `controlType` can be any control and is by default a {@link sap.m.Bar}. The `controlProperties` are
     * passed to the constructor of the control.
     *
     * **Note:** Only one footer is displayed at once. Any new footer will replace the previous one **Restriction:**
     * NOT available for apps running in an iframe
     *
     * @since 1.124.0
     *
     * @returns The newly created footer.
     */
    createFooter(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: object,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Defines the `controlType`.
         */
        controlType?: string;
      }
    ): Promise<Footer>;
    /**
     * Creates a header item in the shell header.
     *
     * @since 1.124.0
     *
     * @returns The newly created header item.
     */
    createHeaderItem(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: Properties,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Possible values are `begin` and `end`.
         */
        position?: string;
      }
    ): Promise<Item>;
    /**
     * Creates a new sub header which is positioned below the header.
     *
     * The `controlType` can be any control and is by default a {@link sap.m.Bar}. The `controlProperties` are
     * passed to the constructor of the control.
     *
     * **Note:** Only one sub header is displayed at once **Restriction:** NOT available for apps
     * running in an iframe
     *
     * @since 1.124.0
     *
     * @returns The newly created sub header.
     */
    createSubHeader(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: object,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Defines the `controlType`.
         */
        controlType?: string;
      }
    ): Promise<Item>;
    /**
     * Creates a user action in the user action menu.
     *
     * The `controlType` can be any control and is by default a {@link sap.ushell.ui.launchpad.ActionItem}.
     * The `controlProperties` are passed to the constructor of the control.
     *
     * @since 1.124.0
     *
     * @returns The newly created user action.
     */
    createUserAction(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: object,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Defines the `controlType` of the item.
         */
        controlType?: string;
      }
    ): Promise<Item>;
    /**
     * Returns the API for the SidePane which is located next to the launchpad content. **Restriction:**
     * NOT available for apps running in an iframe
     *
     * @since 1.124.0
     *
     * @returns The SidePane.
     */
    getSidePane(): Promise<SidePane>;
    /**
     * Returns the API for the ToolArea which is located next to the launchpad content. **Restriction:**
     * NOT available for apps running in an iframe
     *
     * @since 1.124.0
     *
     * @returns The ToolArea.
     */
    getToolArea(): Promise<ToolArea>;
  }
}

declare module "sap/ushell/services/FrameBoundExtension/Footer" {
  import Control from "sap/ui/core/Control";

  /**
   * The footer extension point is positioned below the launchpad content. To be instantiated by {@link sap.ushell.services.FrameBoundExtension}.
   *
   * **Restriction:** Does not work when called from within a iframe. The calling function has to be in
   * the 'same frame' as the launchpad itself.
   *
   * @since 1.124.0
   */
  export default class Footer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Destroys the footer.
     *
     * @since 1.124.0
     *
     * @returns Resolves once the footer was destroyed.
     */
    destroy(): Promise<any>;
    /**
     * Returns the related control instance.
     *
     * @since 1.124.0
     *
     * @returns The control.
     */
    getControl(): Promise<Control>;
  }
}

declare module "sap/ushell/services/FrameBoundExtension/Item" {
  import Control from "sap/ui/core/Control";

  /**
   * Item wrapping an item positioned in an extension point. To be instantiated by {@link sap.ushell.services.FrameBoundExtension}.
   *
   *  The item will be automatically destroyed when the user navigates away from the current application.
   * After calling {@link sap.ushell.services.Extension.Item#showOnHome} or {@link sap.ushell.services.Extension.Item#showForAllApps }
   * the item is not destroyed automatically and has to be destroyed manually via {@link sap.ushell.services.Extension.Item#destroy}.
   *
   *  **Restriction:** Does not work when called from within a iframe. The calling function has to be in
   * the 'same frame' as the launchpad itself.
   *
   * @since 1.124.0
   */
  export default class Item {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Destroys the item and it's related content.
     *
     * @since 1.124.0
     *
     * @returns Resolves once the item was destroyed.
     */
    destroy(): Promise<any>;
    /**
     * Returns the related control instance.
     *
     * @since 1.124.0
     *
     * @returns The control.
     */
    getControl(): Promise<Control>;
    /**
     * Shows the item for all applications. Does not change the visibility of the item for the launchpad "home".
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideForAllApps(): this;
    /**
     * Hides the item for the current application.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideForCurrentApp(): this;
    /**
     * Hides the item for launchpad "home". Does not change the visibility of the item within applications.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideOnHome(): this;
    /**
     * Shows the item for all applications. Does not change the visibility of the item for the launchpad "home".
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showForAllApps(): this;
    /**
     * Shows the item for the current application. The item will be hidden after the user navigates away from
     * this application. The item will not be added again if the user navigates back to the application.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showForCurrentApp(): this;
    /**
     * Shows the item for launchpad "home". Does not change the visibility of the item within applications.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showOnHome(): this;
  }
}

declare module "sap/ushell/services/FrameBoundExtension/SidePane" {
  import Item from "sap/ushell/services/FrameBoundExtension/Item";

  /**
   * The side pane extension point is positioned next the launchpad content. To be instantiated by {@link sap.ushell.services.FrameBoundExtension}.
   *
   * **Restriction:** Does not work when called from within a iframe. The calling function has to be in
   * the 'same frame' as the launchpad itself.
   *
   * @since 1.124.0
   */
  export default class SidePane {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates an item in the side pane.
     *
     * The `controlType` can be any control and is by default a {@link sap.m.Button}. The `controlProperties`
     * are passed to the constructor of the control.
     *
     * @since 1.124.0
     *
     * @returns The newly created item.
     */
    createItem(
      /**
       * The properties that will be passed to the created control.
       */
      controlProperties: object,
      /**
       * Additional parameters.
       */
      parameters?: {
        /**
         * Defines the `controlType` of the item.
         */
        controlType?: string;
      }
    ): Promise<Item>;
    /**
     * Shows the side pane for all applications. Does not change the visibility of the side pane for the launchpad
     * "home".
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideForAllApps(): this;
    /**
     * Hides the area for launchpad "home". Does not change the visibility of the area within applications.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideOnHome(): this;
    /**
     * Shows the side pane for all applications. Does not change the visibility of the side pane for the launchpad
     * "home".
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showForAllApps(): this;
    /**
     * Shows the side pane for launchpad "home". Does not change the visibility of the side pane within applications.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showOnHome(): this;
  }
}

declare module "sap/ushell/services/FrameBoundExtension/ToolArea" {
  import Item from "sap/ushell/services/FrameBoundExtension/Item";

  /**
   * The tool area extension point is positioned next the launchpad content. To be instantiated by {@link sap.ushell.services.FrameBoundExtension}.
   *
   * **Restriction:** Does not work when called from within a iframe. The calling function has to be in
   * the 'same frame' as the launchpad itself.
   *
   * @since 1.124.0
   */
  export default class ToolArea {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates an item in the tool area.
     * See:
     * 	sap.ushell.ui.shell.ToolAreaItem
     *
     * @since 1.124.0
     *
     * @returns The newly created item.
     */
    createItem(
      /**
       * The properties that will be passed to the {@link sap.ushell.ui.shell.ToolAreaItem}.
       */
      controlProperties: object
    ): Promise<Item>;
    /**
     * Shows the tool area for all applications. Does not change the visibility of the tool area for the launchpad
     * "home".
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideForAllApps(): this;
    /**
     * Hides the tool area for launchpad "home". Does not change the visibility of the tool area within applications.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    hideOnHome(): this;
    /**
     * Shows the tool area for all applications. Does not change the visibility of the tool area for the launchpad
     * "home".
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showForAllApps(): this;
    /**
     * Shows the tool area for launchpad "home". Does not change the visibility of the tool area within applications.
     *
     * @since 1.124.0
     *
     * @returns Reference to `this` for method chaining.
     */
    showOnHome(): this;
  }
}

declare module "sap/ushell/services/FrameBoundExtension/UserSettingsEntry" {
  /**
   * The UserSettingsEntry defines an entry in the user settings dialog. To be instantiated by {@link sap.ushell.services.FrameBoundExtension}.
   *
   * **Restriction:** Does not work when called from within an iframe. The calling function has to be in
   * the 'same frame' as the launchpad itself.
   *
   * @since 1.134.0
   */
  export default class UserSettingsEntry {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Opens the user settings entry.
     *
     * The dialog is opened and then navigated to the new entry. If a group is available, the function navigates
     * to the group and entry (tab).
     *
     * @since 1.134.0
     */
    open(): void;
  }
}

declare module "sap/ushell/services/LaunchPage" {
  /**
   * A service for handling groups, tiles and catalogs.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const LaunchPage = await Container.getServiceAsync("LaunchPage");
   *     // do something with the LaunchPage service
   *   });
   * ```
   *
   *
   * The functions that return the main objects are getGroups, getGroupTitle, getCatalogs and getCatalogTiles.
   * Since the implementation (i.e. adapter) is platform specific, do not call or access properties and functions
   * of returned objects. Instead, use other functions of the LaunchPage service with the relevant object
   * as the input parameter.
   *
   * When using the content extension factory, any extended content needs to refer to the correct adapter
   * with the field "contentProvider".
   *
   * @since 1.15.0
   * @deprecated As of version 1.99. Deprecated together with the classic homepage.
   */
  export default class LaunchPage extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Adds a new group.
     *
     * Intention: the page builder adds this group to the end of the home screen.
     *
     * In case of failure it gets the consistent (i.e. persisted) backend state of all groups.
     *
     *
     * @returns Resolves once the group was added.
     */
    addGroup(
      /**
       * The title of the new group
       */
      sTitle: string
    ): jQuery.Promise;
    /**
     * Adds a new group at a specific location.
     *
     * Intention: the page builder adds this group to the specific location on the home screen.
     *
     * In case of error it gets the consistent (i.e. persisted) backend state of all groups.
     *
     *
     * @returns Resolves the group.
     */
    addGroupAt(
      /**
       * The title of the new group
       */
      sTitle: string,
      /**
       * the location of the new group
       */
      iIndex: int
    ): jQuery.Promise;
    /**
     * Adds a tile to a group.
     *
     * If no group is provided then the tile is added to the default group.
     *
     * Intention: the page builder by default puts this tile at the end of the default group. In case of failure
     * it gets the consistent (i.e. persisted) backend state of the default group.
     *
     *
     * @returns Resolves once the tile was added.
     */
    addTile(
      /**
       * An 'anonymous' tile from the tile catalog
       */
      oCatalogTile: object,
      /**
       * The target group
       */
      oGroup?: object
    ): jQuery.Promise;
    /**
     * Returns the press handler for clicking on a tile.
     *
     *
     * @returns handler for clicking on the tile.
     */
    getAppBoxPressHandler(
      /**
       * The tile
       */
      oTile: object
    ): Function;
    /**
     * Returns catalog's technical data.
     *
     * @since 1.21.2
     *
     * @returns An object that includes the following properties (the list may include additional properties):
     *
     * 	`id`: the catalog ID `systemId`: [remote catalogs] the ID of the remote system `remoteId`: [remote
     * catalogs] the ID of the catalog in the remote system `baseUrl`: [remote catalogs] the base URL of
     * the catalog in the remote system
     */
    getCatalogData(
      /**
       * the catalog
       */
      oCatalog: object
    ): object;
    /**
     * Returns the catalog's technical error message in case it could not be loaded from the backend.  **Beware:**
     * The technical error message is not translated!
     *
     * @since 1.17.1
     *
     * @returns The technical error message or `undefined` if the catalog was loaded properly
     */
    getCatalogError(
      /**
       * the catalog
       */
      oCatalog: object
    ): string;
    /**
     * Returns the catalog's unique identifier
     *
     *
     * @returns Catalog id
     */
    getCatalogId(
      /**
       * The catalog
       */
      oCatalog: object
    ): string;
    /**
     * Returns the catalogs of the user.  Only severe failures make the overall operation fail. If loading
     * of a remote catalog fails, this is handled gracefully by providing a "dummy" empty catalog (with ID instead
     * of title). Use {@link getCatalogError} to check if a (remote) catalog could not be loaded from the backend.
     *  Progress notifications are sent for each single catalog, i.e. attaching a `progress` handler gives
     * you the same possibilities as attaching a `done` handler, but with the advantage of improved responsiveness.
     *
     *
     * @returns Resolves an array of black-box catalog objects is provided (which might be empty). In case of
     * failure, an error message is passed. Progress notifications are sent for each single catalog, providing
     * a single black-box catalog object each time.
     */
    getCatalogs(): jQuery.Promise;
    /**
     * Returns catalog tile's content provider ID.
     *
     *
     * @returns Tile content provider ID
     */
    getCatalogTileContentProviderId(
      /**
       * The tile or the catalog tile
       */
      oTile: object
    ): string;
    /**
     * Returns catalog tile's unique identifier. This function may be called for a catalog tile or (since 1.21.0)
     * for a group tile. In the latter case, the function returns the unique identifier of the catalog tile
     * on which the group tile is based.
     *
     *
     * @returns Tile id
     */
    getCatalogTileId(
      /**
       * The tile or the catalog tile
       */
      oTile: object
    ): string;
    /**
     * Returns the keywords associated with a catalog tile which can be used to find the catalog tile in a search.
     * Note: getCatalogTileViewControl **must** be called **before** this method. Otherwise the keywords may
     * be incomplete.
     *
     *
     * @returns The keywords associated with this catalog tile
     */
    getCatalogTileKeywords(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string[];
    /**
     * Returns preview icon for a catalog tile.
     *
     * @since 1.16.3
     *
     * @returns Preview icon as URL/URI for the catalog tile's underlying application as provided via the "preview"
     * contract
     */
    getCatalogTilePreviewIcon(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns the catalog tile info
     *
     * @since 1.67.0
     *
     * @returns The catalog tile info
     */
    getCatalogTilePreviewInfo(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns preview subtitle for a catalog tile.
     *
     * @since 1.40
     *
     * @returns Preview subtitle for the catalog tile's underlying application as provided via the "preview"
     * contract
     */
    getCatalogTilePreviewSubtitle(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns preview title for a catalog tile.
     *
     * @since 1.16.3
     *
     * @returns Preview title for the catalog tile's underlying application as provided via the "preview" contract
     */
    getCatalogTilePreviewTitle(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns the tiles of a catalog.
     *
     *
     * @returns Resolve the catalog tiles.
     */
    getCatalogTiles(
      /**
       * The catalog
       */
      oCatalog: object
    ): jQuery.Promise;
    /**
     * Returns the size of a catalog tile as a string. For example: "1x1", "1x2"
     *
     *
     * @returns Tile size in units in 1x1 or 1x2 format
     */
    getCatalogTileSize(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns the tags associated with a catalog tile which can be used to find the catalog tile in a tag filter.
     *
     *
     * @returns The tags associated with this catalog tile
     */
    getCatalogTileTags(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string[];
    /**
     * Returns the navigation target URL of a catalog tile.
     *
     *
     * @returns The target URL for the catalog tile's underlying application as provided via the "preview" contract
     */
    getCatalogTileTargetURL(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns the technical attributes associated with a catalog tile which can be used define additional tags
     * for apps. Note: getCatalogTileViewControl **must** be called **before** this method. Otherwise the technical
     * attributes may be incomplete.
     *
     *
     * @returns The technical attributes associated with this catalog tile if this is supported by the adapter
     * implementation
     */
    getCatalogTileTechnicalAttributes(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string[];
    /**
     * Returns the catalog tile's title
     *
     *
     * @returns Tile title
     */
    getCatalogTileTitle(
      /**
       * The catalog tile
       */
      oCatalogTile: object
    ): string;
    /**
     * Returns the UI5 view or control of a catalog tile
     *
     * @deprecated As of version 1.48. Please use {@link #getCatalogTileViewControl} instead.
     *
     * @returns UI5 view or control
     */
    getCatalogTileView(
      /**
       * The catalog tile
       */
      oCatalogTile: object,
      /**
       * SAP-internal: Whether the tile should be displayed in preview mode
       */
      bPreview?: boolean
    ): object;
    /**
     * Returns the UI5 view or control of a catalog tile
     *
     *
     * @returns Resolves the Catalog Tile View
     */
    getCatalogTileViewControl(
      /**
       * The catalog tile
       */
      oCatalogTile: object,
      /**
       * SAP-internal: Whether the tile should be displayed in preview mode
       */
      bPreview?: boolean
    ): jQuery.Promise;
    /**
     * Returns the catalog's title
     *
     *
     * @returns Catalog title
     */
    getCatalogTitle(
      /**
       * The catalog
       */
      oCatalog: object
    ): string;
    /**
     * Returns the default group of the user.
     *
     *
     * @returns Resolves the default group.
     */
    getDefaultGroup(): jQuery.Promise;
    /**
     * Returns the unique identifier of the given group
     *
     *
     * @returns Group id
     */
    getGroupId(
      /**
       * The group whose id is returned
       */
      oGroup: object
    ): string;
    /**
     * Returns the groups of the user. The order of the array is the order in which the groups will be displayed
     * to the user.
     *
     * @deprecated As of version 1.99. Alternative for use with {@link sap.ushell.services.Bookmark} is {@link sap.ushell.services.Bookmark#getContentNodes}.
     *
     * @returns A promise that resolves to the list of groups
     */
    getGroups(): jQuery.Promise<object>;
    /**
     * Returns an array of 'anonymous' tiles of a group. The order of the array is the order of tiles that will
     * be displayed to the user.
     *
     *
     * @returns The group tiles array
     */
    getGroupTiles(
      /**
       * The group whose tiles are returned
       */
      oGroup: object
    ): object[];
    /**
     * Returns the title of the given group.
     *
     *
     * @returns group title
     */
    getGroupTitle(
      /**
       * The group whose title is returned
       */
      oGroup: object
    ): string;
    /**
     * Returns an array of link tiles for a group. The order of the array is the order in which the links will
     * be displayed to the user.
     *
     *
     * @returns The array of link tiles
     */
    getLinkTiles(
      /**
       * The group whose link tiles are returned
       */
      oGroup: object
    ): object[];
    /**
     * Returns the tile's unique identifier
     *
     *
     * @returns Tile id
     */
    getTileId(
      /**
       * The tile
       */
      oTile: object
    ): string;
    /**
     * Returns the tile size in the format of 1x1 or 1x2 string
     *
     *
     * @returns tile size in units in 1x1 format
     */
    getTileSize(
      /**
       * The tile
       */
      oTile: object
    ): string;
    /**
     * Returns the tile's navigation target.
     *
     * The navigation target string is used (when assigned to `location.hash`) for performing a navigation action
     * that eventually opens the application represented by the tile.
     *
     *
     * @returns the tile target
     */
    getTileTarget(
      /**
       * the tile
       */
      oTile: object
    ): string;
    /**
     * Returns the tile's title.
     *
     *
     * @returns The title
     */
    getTileTitle(
      /**
       * The tile
       */
      oTile: object
    ): string;
    /**
     * Returns the tile's type.
     *
     *
     * @returns The type
     */
    getTileType(
      /**
       * The tile
       */
      oTile: object
    ): string;
    /**
     * Returns UI5 view or control of the tile.
     *
     *
     * @returns Resolves the UI5 view or control of the tile.
     */
    getTileView(
      /**
       * The tile
       */
      oTile: object
    ): jQuery.Promise;
    /**
     * Returns whether the catalogs collection previously returned by `getCatalogs()` is still valid.
     *
     * Initially the result is `false` until `getCatalogs()` has been called. Later, the result might be `false`
     * again in case one of the catalogs has been invalidated, e.g. due to adding a tile to a catalog ("Add
     * to catalog" scenario).
     * See:
     * 	#getCatalogs
     *
     * @since 1.16.4
     *
     * @returns `true` in case the catalogs are still valid; `false` if not
     */
    isCatalogsValid(): boolean;
    /**
     * Checks if a group was marked as featured (meaning the group is a Fiori 3 featured group).
     *
     * Returns `true` if the group is featured and `false` if not.
     *
     *
     * @returns `true` if featured; `false` if not (or as default in case the function was not implemented in
     * the proper adapter).
     */
    isGroupFeatured(
      /**
       * The group to be checked
       */
      oGroup: object
    ): boolean;
    /**
     * Checks if a group was marked as locked (meaning the group and its tiles will lack several capabilities
     * such as Rename, Drag&Drop...).
     *
     * Returns `true` if the group is locked and `false` if not.
     *
     *
     * @returns `true` if locked; `false` if not (or as default in case the function was not implemented in
     * the proper adapter).
     */
    isGroupLocked(
      /**
       * The group to be checked
       */
      oGroup: object
    ): boolean;
    /**
     * Checks if a group can be removed.
     *
     * Returns `true` if the group can be removed (i.e. if the given group was created by the user) and `false`
     * if the group can only be reset.
     *
     *
     * @returns `true` if removable; `false` if resettable
     */
    isGroupRemovable(
      /**
       * The group to be checked
       */
      oGroup: object
    ): boolean;
    /**
     * Moves a group to a new index (i.e. location).
     *
     * Intention: the page builder already moved the page (visible to the user) and if successful - nothing
     * needs to be done. In case of failure it gets the consistent (i.e. persisted) backend state of all groups.
     *
     *
     * @returns Resolves once the group was moved.
     */
    moveGroup(
      /**
       * The group to be moved
       */
      oGroup: object,
      /**
       * The new index for the group
       */
      iNewIndex: int
    ): jQuery.Promise;
    /**
     * Moves a tile within a group or between different groups.
     *
     * Intention: the page builder already moved the tile.
     *
     * In case of failure it gets the consistent (i.e. persisted) backend state of the source group and the
     * target group. The result is in the following format {source:[{},{}], target:[{},{}]}.
     *
     * The source and the target groups tiles are in the form of the @see sap.ushell.services.LaunchPage.getGroupTiles
     *
     *
     * @returns Resolves once the tile was moved.
     */
    moveTile(
      /**
       * a tile instance to be moved. The same object type as the one returned by `sap.ushell.services.LaunchPage.getGroupTiles`
       */
      oTile: object,
      /**
       * the index in the source group
       */
      iSourceIndex: int,
      /**
       * the target group index, in case this parameter is not supplied we assume the move tile is within the
       * source group using iSourceIndex
       */
      iTargetIndex: int,
      /**
       * the source group the tile came from
       */
      oSourceGroup: object,
      /**
       * The same object type as the one returned by `sap.ushell.services.LaunchPage.getGroups` the target group
       * the tile will be placed in, in case this parameter is not supplied we assume the move tile is within
       * the source group
       */
      oTargetGroup?: object,
      /**
       * (added with 1.46) The new type of the tile
       */
      sNewTileType?: string
    ): jQuery.Promise;
    /**
     * Triggers a refresh action of a tile. Typically this action is related to the value presented in dynamic
     * tiles
     */
    refreshTile(
      /**
       * The tile
       */
      oTile: object
    ): void;
    /**
     * Register an external tile actions provider callback function.
     *
     * The callback has to return an array of actions of the given tile. The callback is triggered when @see
     * sap.ushell.services.LaunchPage.getTileActions is called.
     *
     * Tile actions are additional operations that can be executed on a tile, and can be provided by external
     * providers.
     *
     * A tile action is an object with the following properties: text, icon and targetURL or a press handler.
     *
     * Tile actions should be returned immediately without any additional server access in order to avoid delays
     * in rendering the action list in the browser.
     *
     * @deprecated As of version 1.99. Deprecated together with the classic homepage.
     */
    registerTileActionsProvider(
      /**
       * A callback which returns an array of action objects.
       */
      fnProvider: object
    ): void;
    /**
     * Removes a group.
     *
     * Intention: the page builder already removed the page (or hid it from the user) and if successful - nothing
     * needs to be done.
     *
     * In case of failure it gets the consistent (i.e. persisted) backend state of all groups.
     *
     *
     * @returns Resolves once the group was removed.
     */
    removeGroup(
      /**
       * The group to be removed
       */
      oGroup: object,
      /**
       * The index of the group to be removed
       */
      iIndex: int
    ): jQuery.Promise;
    /**
     * Removes a tile from a group.
     *
     * Intention: the page builder has already 'hidden' (or removed) the tile.
     *
     * In case of failure it gets the consistent (i.e. persisted) backend state of the group.
     *
     *
     * @returns Resolves once the tile was removed.
     */
    removeTile(
      /**
       * The group from which to remove the tile instance
       */
      oGroup: object,
      /**
       * The tile instance to remove
       */
      oTile: object,
      /**
       * The tile index
       */
      iIndex: int
    ): jQuery.Promise;
    /**
     * Resets a group.
     *
     * The reset action is relevant for a group that was assigned to the user by an administrator. The reset
     * action means that the group is set back to the state defined by the administrator, and changes made by
     * the end user (e.g. adding tiles) are removed. A group can be reset multiple times.
     *
     * In case of failure, or when the given group was created by the user (i.e. can't be reset)- it gets, the
     * consistent (i.e. persisted) backend state of all groups. The returned group object is the same as the
     * one returned by @see sap.ushell.services.LaunchPage.getGroups
     *
     *
     * @returns Resolves once the group was reset.
     */
    resetGroup(
      /**
       * The group to be reset
       */
      oGroup: object,
      /**
       * The index of the group to be reset
       */
      iIndex: int
    ): jQuery.Promise;
    /**
     * Sets the title of an existing group.
     *
     * Intention: the page builder knows the new title, and if successful nothing needs to be done, as the title
     * is already visible to the user. In case of failure it gets the consistent (i.e. persisted) backend state
     * of the group title, in most cases the old title.
     *
     *
     * @returns Resolves once the group title was set.
     */
    setGroupTitle(
      /**
       * The group whose title is set
       */
      oGroup: object,
      /**
       * The new title of the group
       */
      sTitle: string
    ): jQuery.Promise;
    /**
     * Sets the tile's visibility state and notifies the tile about the change.
     */
    setTileVisible(
      /**
       * The tile
       */
      oTile: object,
      /**
       * The tile's required visibility state.
       */
      bNewVisible: boolean
    ): void;
  }
}

declare module "sap/ushell/services/Message" {
  /**
   * Message service.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Message = await Container.getServiceAsync("Message");
   *     // do something with the Message service
   *   });
   * ```
   *
   *
   * @since 1.16.0
   * @deprecated As of version 1.120.
   */
  export default class Message extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
  }
}

declare module "sap/ushell/services/Navigation" {
  import Component from "sap/ui/core/Component";

  import { URI } from "sap/ui/core/library";

  /**
   * The Unified Shell's Navigation service. Allows navigating to "external" targets outside of the currently
   * running app (but still in scope of the current Fiori launchpad) or to create links to such external targets.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Navigation = await Container.getServiceAsync("Navigation");
   *     // do something with the Navigation service
   *   });
   * ```
   *
   *
   * The Navigation service currently provides platform independent functionality.
   *
   * The service is meant to be used by applications, plugins and shell components.
   *
   * Usage:
   * ```javascript
   *
   *   const sHref = await Navigation.getHref({
   *     target : {
   *       semanticObject: "Product",
   *       action: "display"
   *     },
   *     params: {
   *       "ProductID": "102343333"
   *     }
   *   }, oComponent);
   *   // do something with the resolved sHref.
   * ```
   *
   *
   * Parameter names and values are case sensitive.
   *
   * Note that the usage of multi-valued parameters (specifying an array with more than one member as parameter
   * value, e.g. `params : { A : ["a1", "a2"] }`) is possible with this API but **strongly discouraged**.
   * Depending on the used platform / back-end implementation the target matching might not support multi-value
   * parameters. Furthermore, it is not guaranteed that additional parameter values specified in the back-end
   * configuration are merged with parameter values passed via the Navigation service.
   *
   * Note that the application parameter length (including SemanticObject/Action) shall not exceed 512 bytes
   * when serialized as UTF-8.
   *
   * Note that when receiving the values as startup parameters (as part of the component data object) single
   * values are represented as an array of size 1. Above example is returned as ` deepEqual(getComponentData().startupParameters
   * , { "ProductID" : [ "102343333" ] } ) `
   *
   * Make sure not to store sensitive data within an URL. URLs may appear in a server log, be persisted inside
   * and outside the system.
   *
   * Note: When constructing large URLs, the URLs may be shortened and persisted on a database server for
   * prolonged time, the actual data is persisted under a key accessible to any User (guessing the key).
   *
   * The same restrictions apply for the Application state.
   *
   * @since 1.120.0
   */
  export default class Navigation extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Attempts to use the browser history to navigate to the previous app.
     *
     * A navigation to the Fiori launchpad Home is performed when this method is called on a first navigation.
     * In all other cases, this function simply performs a browser back navigation.
     *
     * Note that the behavior of this method is subject to change and therefore it may not yield to the expected
     * results especially on mobile devices where "back" is the previous inner-app state if these are put into
     * the history!
     *
     * @since 1.120.0
     *
     * @returns A promise which resolves once the back navigation was triggered
     */
    backToPreviousApp(): Promise<any>;
    /**
     * Returns a promise resolving to a URL that launches an app with certain parameters. This API can be used
     * to convert the internal shell hash format into the URL format for use in link tags. The resulting href
     * is fully encoded and cannot be used in other APIs expecting the internal decoded hash.
     *
     *
     * ```javascript
     *
     *   const sHref = await Navigation.getHref({
     *     target: { shellHash: oLink.intent }
     *   }, oComponent);
     *   // do something with the resolved sHref.
     * ```
     *
     *
     * This API accepts a sap-xapp-state-data parameter that can be used generate a url that can be used to
     * launch an app with certain data, for example:
     * ```javascript
     *
     *   {
     *     target : { semanticObject : "AnObject", action: "action" },
     *     params : { "sap-xapp-state-data" : JSON.stringify({ a: "b", c: "d" }) }
     *   }
     * ```
     *  Using the arguments as in the example above, a link with a sap-xapp-state parameter that encodes the
     * provided data is returned. The sap-xapp-state-data parameter does not appear in the generated link.
     *
     * Do **not** use "#Shell-home" to navigate to a specific homepage!
     *  A proper way for an application to generate a link to return to the home page of the Fiori launchpad
     * is:
     *  `getHref( { target : { shellHash : "#" }})`
     *
     * @since 1.120.0
     *
     * @returns A Promise resolving the encoded href.
     */
    getHref(
      /**
       * The navigation target to transform. When omitted the current hash is used as basis for the calculation.
       */
      oTarget?: Target,
      /**
       * A UI5 component, used to logically attach any related app state.
       */
      oComponent?: Component
    ): Promise<string>;
    /**
     * Resolves the given filters to a list of links available to the user.
     *
     * @since 1.120.0
     *
     * @returns A promise that resolves an array with a list for each filter containing the matched links.
     * **Note:** The intent is in a **internal** format and cannot be directly put into a link tag. If you want
     * to use it directly you have to transform it first into a href.
     * ```javascript
     *
     *      const sHref = await NavigationService.getHref({ target: { shellHash:  oLink.intent} }, oComponent);
     *   ```
     */
    getLinks(
      /**
       * A list of target filters.
       */
      aLinkFilter?: LinkFilter[]
    ): Promise<Link[][]>;
    /**
     * For a given semantic object, this method considers all actions associated with the semantic object and
     * returns the one tagged as a "primaryAction".
     * If no inbound tagged as "primaryAction" exists, then the intent of the first inbound (after sorting has
     * been applied) matching the action "displayFactSheet".
     *
     * The primary intent is determined by querying {@link sap.ushell.services.Navigation#getLinks} with the
     * given semantic object and optional parameter.
     * Then the resulting list is filtered to the outcome that a single item remains.
     *
     * @since 1.120.0
     *
     * @returns A promise resolving a link matching the 'primaryAction' tag.
     */
    getPrimaryIntent(
      /**
       * The semantic object.
       */
      sSemanticObject: string,
      /**
       * A target filter.
       */
      oLinkFilter?: LinkFilter
    ): Promise<Link>;
    /**
     * Returns a list of semantic objects of the intents the current user can navigate to.
     *
     * @since 1.120.0
     *
     * @returns A promise that resolves with an array of strings representing the semantic objects of the intents
     * the current user can navigate to, or rejects with an error message. The returned array will not contain
     * duplicates.
     * **Note:** the caller should not rely on the specific order the semantic objects appear in the returned
     * array.
     */
    getSemanticObjects(): Promise<string[]>;
    /**
     * Navigates back in history the number of given steps if this is supported by the underlying platform.
     * If no argument is provided it will navigate back 1 step.
     *
     * @since 1.120.0
     */
    historyBack(
      /**
       * positive integer representing the steps to go back in the history
       */
      iSteps: int
    ): void;
    /**
     * Checks whether the FLP has performed the first navigation. This method can be used to detect whether
     * the current app was started directly, that is, without a previous navigation to another app, to the FLP
     * home, or another target that adds an entry in the browser history.
     *
     * @since 1.120.0
     *
     * @returns This promise resolves with a boolean indicating if the current navigation is considered initial
     */
    isInitialNavigation(): Promise<boolean>;
    /**
     * Calculates whether the given navigation targets are supported for the given parameters, form factor etc.
     * . "Supported" means that a valid navigation target is configured for the user and for the given device.
     *
     * `isNavigationSupported` is a test function for {@link sap.ushell.services.Navigation#navigate} and {@link sap.ushell.services.Navigation#getHref}.
     *
     * Example usage:
     * ```javascript
     *
     *   const aResult = await oNavigationService.isNavigationSupported([{
     *     target: { shellHash: "SalesOrder-approve?SOId=1234" }
     *   }])
     *   if (aResult[0].supported===true){
     *       // enable link
     *     }
     *     else {
     *       // disable link
     *   }
     * ```
     *
     *
     * @since 1.120.0
     *
     * @returns A promise that resolves to an array of objects indicating whether the intent is supported or
     * not. Each object has a property `supported` of type `boolean`.
     */
    isNavigationSupported(
      /**
       * A list of navigation targets to be checked.
       */
      aTargets: Target[],
      /**
       * The root component of the application.
       */
      oComponent?: Component
    ): Promise<
      Array<{
        supported: boolean;
      }>
    >;
    /**
     * Triggers a navigation to a specified target outside of the currently running application (e.g. different
     * launchpad application). Invocation will trigger a hash change and subsequent invocation of the target.
     *
     * If the navigation target opens in a new window the running application may be retained.
     *
     * This API accepts a sap-xapp-state-data parameter that can be used generate a url that can be used to
     * launch an app with certain data, for example:
     * ```javascript
     *
     *   {
     *     target : { semanticObject : "AnObject", action: "action" },
     *     params : { "sap-xapp-state-data" : JSON.stringify({ a: "b", c: "d" }) }
     *   }
     * ```
     *  Using the arguments as in the example above, a link with a sap-xapp-state parameter that encodes the
     * provided data is returned. The sap-xapp-state-data parameter does not appear in the generated link.
     *
     * Do **not** use "#Shell-home" to navigate to a specific homepage!
     *  A proper way for an application to generate a link to return to the home page of the Fiori launchpad
     * is:
     *  `navigate( { target : { shellHash : "#" }})`
     *
     * @since 1.120.0
     *
     * @returns A Promise resolving once the navigation was triggered. The Promise might never reject or resolve
     * when an error occurs during the navigation.
     */
    navigate(
      /**
       * The navigation target.
       */
      oTarget: Target,
      /**
       * A UI5 component, used to logically attach any related app state.
       */
      oComponent?: Component
    ): Promise<any>;
    /**
     * Resolves the URL hash fragment. This function gets the hash part of the URL and returns the URL of the
     * target application.
     *
     * @since 1.120.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns A Promise resolving the intent.
     */
    resolveIntent(
      /**
       * The formatted URL hash fragment in internal format (as obtained by the SAPUI5 hasher service) not as
       * given in `location.hash`)! Example: `#SemanticObject-action?P1=V1&P2=A%20B%20C`
       */
      sHashFragment: string
    ): Promise<{
      url: string;
    }>;
  }
  /**
   * Optional properties may not be present in the link.
   */
  export type Link = {
    /**
     * The intent: for example "#AnObject-Action?A=B&C=e&C=j"
     * **Note:** The intent is in a **internal** format and cannot be directly put into a link tag.
     */
    intent: string;
    /**
     * The title of the link.
     */
    text: string;
    /**
     * A URI to the icon: for example "sap-icon://Fiori2/F0018".
     */
    icon?: URI;
    /**
     * The short title of the link.
     */
    subTitle?: string;
    /**
     * The short title of the link.
     */
    shortTitle?: string;
    /**
     * The list of tags.
     */
    tags?: string[];
  };

  export type LinkFilter = {
    /**
     * Matches the semantic object of a link.
     */
    semanticObject?: string;
    /**
     * Matches the action object of a link.
     */
    action?: string;
    /**
     * Matches the parameters of a link.
     * 	**Simple format:**
     *
     *
     * ```javascript
     *
     * {
     *    P1: "B",
     *    P2: ["e", "j"]
     * }
     * ```
     *
     *
     *  **Extended format:**
     *
     *
     * ```javascript
     *
     *    {
     *       P1: { value: "v1" },
     *       P2: { value: ["v2", "v3"] },
     *       P3: { value: "v4", required: true }
     *    }
     * ```
     *
     *
     * `required`: Whether the parameter is be required (`true`) or not (`false`) in the signature of the matching
     * target. Note that this option is only effective on platforms using the `sap.ushell.services.ClientSideTargetResolution`
     */
    params?: object;
    /**
     * If `true`, matches only links that use at least one (non sap-) parameter from 'params'.
     */
    withAtLeastOneUsedParam?: boolean;
    /**
     * How the matching links should be sorted. Possible Values:
     * 	 -  `"intent"` lexicographical sort on returned 'intent' field
     * 	 -  `"text"` lexicographical sort on returned 'text' field
     * 	 -  `"priority"` experimental - top intents are returned first
     */
    sortResultsBy?: string;
    /**
     * If true, only apps that match exactly the supplied technology (for example sap-ui-tech-hint=WDA) will
     * be considered.
     */
    treatTechHintAsFilter?: boolean;
    /**
     * The UI5 component invoking the service, shall be a root component.
     */
    ui5Component: Component;
    /**
     * **SAP internal usage only** Application state key to add to the generated links.
     */
    appStateKey?: string;
    /**
     * Whether intents should be returned in compact format.
     */
    compactIntents?: boolean;
    /**
     * Matches only links which match an inbound with certain tags.
     */
    tags?: string[];
  };

  /**
   * A target describing the intent: #-~?&/
   * **Note:** The intent shall not exceed 512 bytes when serialized as UTF-8.
   */
  export type Target = {
    /**
     * Defaults to current hash. Note that the only the `appSpecificRoute` will be considered when target is
     * omitted.
     */
    target?: {
      /**
       * The semanticObject part of the intent.
       */
      semanticObject?: string;
      /**
       * The action part of the intent.
       */
      action?: string;
      /**
       * The contextRaw part of the intent without the '~' prefix.
       */
      contextRaw?: string;
      /**
       * The entire intent including parameters and appSpecificRoute.
       * **Note:** If set all other parameters are ignored.
       * **Note:** While parameters need to be url-encoded once when used in the `shellHash` the app specific
       * route must not be encoded.
       */
      shellHash?: string;
    };
    /**
     * The parameters of the target
     * 	**Simple format:**
     *
     *
     * ```javascript
     *
     * {
     *    P1: "B",
     *    P2: ["e", "j"]
     * }
     * ```
     *
     *
     *  **Extended format:**
     *
     *
     * ```javascript
     *
     * {
     *    P1: { value: "v1" },
     *    P2: { value: ["v2", "v3"] }
     * }
     * ```
     *
     *
     *
     *
     *
     * **Note:** Parameter values can contain special characters and must be provided unencoded. The APIs takes
     * care of the necessary encodings.
     */
    params?: object;
    /**
     * The appSpecificRoute without the '&/' prefix.
     */
    appSpecificRoute?: string;
    /**
     * Wether the parameter provided in `params` should be applied or ignored. Parameters already set by the
     * shellHash are ignored.
     */
    processParams?: boolean;
  };

  /**
   * The target intent.
   *
   * Navigation is encoded in the fragment identifier of the URL within FLPthe URL has to be a valid intent,
   * i.e. in the format `"#SO-Action?P1=a&P2=x&/route?RPV=1"`. The generic syntax consists of the semantic
   * object, the action and an optional part:
   * ```javascript
   * Intent = "#" semanticObject "-" action ["?" intentParameters "&/" innerAppRoute + "?" + innerAppRouteParameters]```
   *  The intent compries of the fthe following parts:
   * 	semanticObject: Semantic object as defined in an app launcher tile. The following characters are allowed:
   * uppercase letters [A-Z], lowercase letters [a-z], numbers [0-9]. The first character must be an uppercase
   * or lowercase letter. The length of the semantic object is limited to 30 characters.
   *
   *
   * 	 - action: Action as defined in an app launcher tile. For the action name, choose a verb or a short
   *     phrase starting with lower case and without blanks. Examples are display, create, or release. The following
   *     characters are allowed: uppercase letters [A-Z], lowercase letters [a-z], numbers [0-9] and underscores
   *     [_]. The first character must be an uppercase or lowercase letter or an underscore. The length of the
   *     action is limited to 50 characters.
   * 	 - intentParameters: Intent parameters are optional parameters. The parameters are separated by the
   *     ampersand character (&). The parameter name and value are separated by the equal sign (=). The parameter
   *     value must be URL-encoded. When navigating via Intent Based Navigation (IBN) the intent parameters are
   *     used to determine the target application.
   * 	 - innerAppRoute: The inner app route is an optional parameter that is used to navigate within the target
   *     application. The inner app route is separated from the intent parameters by the "&/".
   * 	 - innerAppRouteParameters: The inner app route parameters are optional parameters that are passed to
   *     the target application. The parameters are separated by the ampersand character (&). The parameter name
   *     and value are separated by the equal sign (=). The parameter value must be URL-encoded.
   *
   * @since 1.121.0
   */
  export type TargetIntent = string;

  /**
   * The target intent in strict format. same as {@link sap.ushell.services.Navigation.TargetIntent} but with
   * the following restriction: The intent must not start with a hash character (#).
   *
   * @since 1.124.0
   */
  export type TargetIntentStrict = string;
}

declare module "sap/ushell/services/NavTargetResolution" {
  /**
   * The Unified Shell's internal navigation target resolution service.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const NavTargetResolution = await Container.getServiceAsync("NavTargetResolution");
   *     // do something with the NavTargetResolution service
   *   });
   * ```
   *
   *
   * Methods in this class deal with *internal* representations of the shell hash.
   *
   * configurations: `config : { allowTestUrlComponentConfig : true }` allow to redefine the Test-url, Test-local1,
   * Test-local2 applications via url parameters (sap-ushell-test-local1-url= / sap-ushell-test-local1-additionalInformation=
   * ... )
   *
   * @since 1.15.0
   * @deprecated As of version 1.120. Use {@link sap.ushell.services.Navigation} for Navigation instead.
   */
  export default class NavTargetResolution extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * expands a URL hash fragment
     *
     * This function gets the hash part of the URL and expands a sap-intent-param if present and retrievable
     *
     * This is an asynchronous operation.
     *
     *
     * @returns Resolves expanded shell hash (in internal format).
     */
    expandCompactHash(
      /**
       * The formatted URL hash fragment in internal format (as obtained by the SAPUI5 hasher service, not as
       * given in `location.hash`)
       */
      sHashFragment: string
    ): jQuery.Promise;
    /**
     * Tells whether the given navigation intent(s) are supported for the given parameters Supported" means
     * that a valid navigation target is configured for the user for the given device form factor.
     *
     * This is effectively a test function for {@link toExternal}/ {@link hrefForExternal}. It function accepts
     * the same input as {@link toExternal}/ {@link hrefForExternal}.
     *
     * @since 1.32
     *
     * @returns Resolves an array of objects representing whether the intent is supported or not objects with
     * a property `supported` of type `boolean`.
     *  Example:
     *
     * aIntents: an array of parameterized (parsed) Intent objects, in the corresponding structure to arguments
     * to {@link sap.ushell.services.CrossApplicationNavigation.toExternal}, {@link sap.ushell.services.CrossApplicationNavigation.hrefForExternal }
     *
     * ```javascript
     *
     *     [
     *       {
     *         target : {
     *           semanticObject : "AnObject",
     *           action: "action"
     *         },
     *         params : { P1 : "B", P2 : [ "V2a", "V2b"] }
     *       },
     *       {
     *         target : {
     *           semanticObject : "SalesOrder",
     *           action: "display"
     *         },
     *         params : { P3 : "B", SalesOrderIds : [ "4711", "472"] }
     *       }
     *     ]
     *     ```
     *
     *
     * The following formats are also supported as input to ease migration of existing code: `[ "#AnObject-action?P1=B&SalesOrderIds=4711&SalesOrderIds=472"
     * ]`
     *
     * response:
     * ```javascript
     *
     *   [
     *     { supported: false },
     *     { supported: true }
     *   ]
     *   ```
     *
     *
     * Example usage:
     * ```javascript
     *
     *   this.oCrossAppNav.isNavigationSupported([ ])
     *   .done(function(aResponses) {
     *     if (oResponse[0].supported===true){
     *       // enable link
     *     }
     *     else {
     *       // disable link
     *     }
     *   })
     *   .fail(function() {
     *     // disable link
     *     // request failed or other fatal error
     *   });
     * ```
     */
    isNavigationSupported(
      /**
       * the intents (such as `["#AnObject-action?A=B&c=e"]`) to be checked with object being instances the oArgs
       * object of toExternal, hrefForExternal etc. e.g.
       * ```javascript
       *
       *   {
       *     target : { semanticObject : "AnObject", action: "action" },
       *     params : { A : "B" }
       *   }
       * ```
       *  or e.g.
       * ```javascript
       *
       *   {
       *     target : { semanticObject : "AnObject", action: "action" },
       *     params : { A : "B", c : "e" }
       *   }
       * ```
       *  or `{ target : { shellHash : "AnObject-action?A=B&c=e" } }`
       */
      aIntents: object[]
    ): jQuery.Promise;
    /**
     * Resolves the URL hash fragment.
     *
     * This function should be used by a custom renderer in order to implement custom navigation. Do not use
     * this function for developing Fiori applications.
     *
     * This function gets the hash part of the URL and returns data of the target application.
     *
     * Example of the returned data:
     * ```javascript
     *
     *   {
     *     "additionalInformation": "SAPUI5.Component=sap.ushell.renderer.search.container",
     *     "applicationType": "URL",
     *     "url": "/sap/bc/ui5_ui5/ui2/ushell/resources/sap/ushell/renderer/search/container",
     *     "navigationMode": "embedded"
     *   }
     *   ```
     *
     *
     * This is an asynchronous operation.
     *
     *
     * @returns Resolves an object that you can use to create a {@link sap.ushell.components.container.ApplicationContainer }
     * or `undefined` in case the hash fragment was empty. Typically it contains the following information:
     *
     * ```javascript
     *
     *   {
     *     "applicationType": "URL",
     *     "url": "/sap/bc/",
     *     "additionalInformation": "SAPUI5.Component=com.sap.AComponent",
     *     "text": "My targetmapping description",
     *     "navigationMode": "embedded"
     *   }
     *   ```
     *   The `navigationMode` indicates how the target application should be navigated. It is added to the
     * result using the logic in {@link navigationMode#getNavigationMode} if none of the resolvers in the chain
     * added it.  No navigation should occur when the promise is resolved to `undefined`.
     */
    resolveHashFragment(
      /**
       * The formatted URL hash fragment in internal format (as obtained by the SAPUI5 hasher service) not as
       * given in `location.hash`)! Example: `#SemanticObject-action?P1=V1&P2=A%20B%20C`
       */
      sHashFragment: string
    ): jQuery.Promise;
    /**
     * Resolves a navigation target taking into account the sap-system
     *
     * This function should be used by the NWBC browser in order to get a resolved target corresponding to a
     * certain configuration object describing the target. Do not use this function for developing Fiori applications.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Resolves an object. Typically it contains the following information:
     * ```javascript
     *
     *   {
     *     "url": "/sap/bc/",
     *     "text": "My targetmapping description",
     *     "externalNavigationMode": boolean
     *   }
     *   ```
     */
    resolveTarget(
      /**
       *
       * ```javascript
       *
       *   {
       *     target : {
       *       semanticObject : "semantic object",
       *       action : "action",
       *     },
       *     params :  {
       *       "sap-system-src": "e.g. sid(UR5.120)",
       *       "sap-system": {
       *         ... data related to the sap-system
       *       }
       *     }
       *   }
       * ```
       */
      oArgs: object
    ): jQuery.Promise;
  }
}

declare module "sap/ushell/services/Notifications" {
  /**
   * UShell service for fetching user notification data from the Notification center/service
   *  and exposing them to the Unified Shell and Fiori applications UI controls.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Notifications = await Container.getServiceAsync("Notifications");
   *     // do something with the Notifications service
   *   });
   * ```
   *
   *
   * In order to get user notifications, Unified Shell notification service issues OData requests
   *  to the service defined by the configuration property `serviceUrl`,
   *  for example: "/sap/opu/odata4/iwngw/notification/default/iwngw/notification_srv/0001"
   * .
   *
   * Unified Shell Notification service has several working modes, depending on the environment and the available
   * resources:
   *  PackagedApp mode: Fiori launchpad runs in the context of PackagedApp
   *  FioriClient mode: Fiori launchpad runs in the context of FioriLaunchpad
   *  WebSocket mode: Fiori launchpad runs in a browser, and WebSocket connection to the notifications provider
   * is available
   *  Polling mode: Fiori launchpad in runs in a browser, and WebSocket connection to the notifications provider
   * is not available
   *
   *
   * The notification service exposes an API that includes: - Service enabling and initialization
   *  - Registration of callback functions (by Shell/FLP controls) that will be called for every data update
   * . - Retrieval of notification data (e.g. notifications, number of unseen notifications) - Execution of
   * a notification actions - Marking user notifications as seen
   *
   * @since 1.32.0
   * @deprecated As of version 1.119. Please use {@link sap.ushell.services.NotificationsV2} instead.
   */
  export default class Notifications extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Launches dismiss notification call.
     *
     *
     * @since 1.34
     *
     * @returns Resolves to undefined or it is rejected with a message object
     */
    dismissNotification(
      /**
       * The ID of the notification whose action is being executed
       */
      sNotificationId: string
    ): jQuery.Promise;
    /**
     * Launches a notification action oData call.
     *  After launching the action, the function gets updated notification data in order to push the updated
     * data to the consumers.
     *
     * @since 1.32
     *
     * @returns Promise object that on success resolves to undefined or it is rejected with failed notifications
     */
    executeBulkAction(
      /**
       * The ID of the notification header/group whose action is being executed
       */
      sNotificationGroupId: string,
      /**
       * The ID of the action that is being executed
       */
      sActionId: string
    ): Promise<undefined>;
    /**
     * Returns the notifications of the user sorted by type include the group headers and the notifications
     *
     * @since 1.38
     *
     * @returns Resolves all notification items
     */
    getNotificationsByTypeWithGroupHeaders(): jQuery.Promise;
    /**
     * Returns the number of notifications
     *  e.g. Notifications for user.
     *
     * @since 1.44
     *
     * @returns Returns the number of notifications of the user
     */
    getNotificationsCount(): int;
    /**
     * Returns the group headers of the user notifications
     *
     * @since 1.44
     *
     * @returns Resolves all group headers
     */
    getNotificationsGroupHeaders(): jQuery.Promise;
    /**
     * Returns the number of unseen notifications
     *  e.g. Notifications that the user hasn't seen yet.
     *
     * @since 1.32
     *
     * @returns Resolves the number of unread notifications of the user
     */
    getUnseenNotificationsCount(): jQuery.Promise;
    /**
     * Initializes the notification service
     *
     * Initialization is performed only if the following two conditions are fulfilled:
     *  1. Notification service is enabled
     *  2. Notification service hasn't been initialized yet
     *
     *
     * The main initialization functionality is determining and setting the mode in which notifications are
     * consumed.
     *  The possible modes are:
     *  PACKAGED_APP - Notifications are fetched when a callback is called by PackagedApp environment
     *  FIORI_CLIENT - Notifications are fetched when a callback is called by FioriClient environment
     *  WEB_SOCKET - Notifications are fetched on WebSocket "ping"
     *  POLLING - Notifications are fetched using periodic polling mechanism
     *
     *
     * @since 1.32
     */
    init(): void;
    /**
     * Indicates whether notification service is enabled.
     *  Enabling is based on the `enable` service configuration flag.
     *  The service configuration must also include serviceUrl attribute.
     *
     *
     * @since 1.32.0
     *
     * @returns A boolean value indicating whether the notifications service is enabled
     */
    isEnabled(): boolean;
    /**
     * @since 1.38
     *
     * @returns boolean value whether first request was already performed and data was returned.
     */
    isFirstDataLoaded(): boolean;
    /**
     * Launches mark as read notification call.
     *  After launching the action, the function gets updated notification data in order to push the updated
     * data to the consumers.
     *
     * @since 1.34
     *
     * @returns Resolves to undefined or it is rejected with a message object
     */
    markRead(
      /**
       * The ID of the notification whose action is being executed
       */
      sNotificationId: string
    ): jQuery.Promise;
    /**
     * Mark all notifications as seen.
     *  the main use-case is when the user navigated to the notification center and sees all the pending notifications.
     *
     *
     * @since 1.32
     */
    notificationsSeen(): void;
    /**
     * Gets a callback function that will be called when updated unseen notifications count is available.
     *
     * @since 1.32
     */
    registerNotificationCountUpdateCallback(
      /**
       * The callback function that is registered and called on data update.
       */
      callback: Function
    ): void;
    /**
     * Gets a callback function that will be called when updated notifications data is available.
     *
     * @since 1.32
     */
    registerNotificationsUpdateCallback(
      /**
       * The callback function that is registered and called on data update.
       */
      callback: Function
    ): void;
  }
}

declare module "sap/ushell/services/NotificationsV2" {
  /**
   * UShell service for fetching user notification data from the Notification center/service
   *  and exposing them to the Unified Shell and Fiori applications UI controls.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const NotificationsV2 = await Container.getServiceAsync("NotificationsV2");
   *     // do something with the NotificationsV2 service
   *   });
   * ```
   *
   *
   * In order to get user notifications, Unified Shell notification service issues OData requests
   *  to the service defined by the configuration property `serviceUrl`,
   *  for example: "/sap/opu/odata4/iwngw/notification/default/iwngw/notification_srv/0001"
   * .
   *
   * Unified Shell Notification service has several working modes, depending on the environment and the available
   * resources:
   *  PackagedApp mode: Fiori launchpad runs in the context of PackagedApp
   *  FioriClient mode: Fiori launchpad runs in the context of FioriLaunchpad
   *  WebSocket mode: Fiori launchpad runs in a browser, and WebSocket connection to the notifications provider
   * is available
   *  Polling mode: Fiori launchpad in runs in a browser, and WebSocket connection to the notifications provider
   * is not available
   *
   *
   * The notification service exposes an API that includes: - Service enabling and initialization
   *  - Registration of callback functions (by Shell/FLP controls) that will be called for every data update
   * . - Retrieval of notification data (e.g. notifications, number of unseen notifications) - Execution of
   * a notification actions - Marking user notifications as seen
   *
   * @since 1.119
   */
  export default class NotificationsV2 extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
    /**
     * Enumeration for The nature of the notification
     *
     * This enum is part of the 'sap/ushell/services/NotificationsV2' module export and must be accessed by
     * the property 'Nature'.
     *
     * @since 1.120.0
     */
    static Nature: typeof Nature;

    /**
     * Enumeration for the priority of a notification
     *
     * This enum is part of the 'sap/ushell/services/NotificationsV2' module export and must be accessed by
     * the property 'Priority'.
     *
     * @since 1.120.0
     */
    static Priority: typeof Priority;

    /**
     * Launches dismiss notification call.
     *
     *
     *
     * @returns Promise object that on success resolves to undefined or it is rejected with a message object
     */
    dismissNotification(
      /**
       * The ID of the notification whose action is being executed
       */
      sNotificationId: string
    ): Promise<any>;
    /**
     * Launches a notification action oData call.
     *  After launching the action, the function gets updated notification data in order to push the updated
     * data to the consumers.
     *
     *
     * @returns Promise object that on success resolves to undefined or it is rejected with failed notifications
     */
    executeBulkAction(
      /**
       * The ID of the notification header/group whose action is being executed
       */
      sNotificationGroupId: string,
      /**
       * The ID of the action that is being executed
       */
      sActionId: string
    ): Promise<BulkAction[]>;
    /**
     * Returns the notifications of the user sorted by type include the group headers and the notifications
     *
     *
     * @returns Promise for all notification items The notifications items have value true for attribute group
     * header if they are group headers.
     */
    getNotificationsByTypeWithGroupHeaders(): Promise<NotificationItem[]>;
    /**
     * Returns the number of notifications
     *  e.g. Notifications for user.
     *
     *
     * @returns Returns the number of notifications of the user
     */
    getNotificationsCount(): int;
    /**
     * Returns the group headers of the user notifications
     *
     *
     * @returns Promise for all group headers The notifications items have value true for attribute group header
     */
    getNotificationsGroupHeaders(): Promise<NotificationItem[]>;
    /**
     * Returns the number of unseen notifications
     *  e.g. Notifications that the user hasn't seen yet.
     *
     *
     * @returns Promise resolves with the number of unread notifications of the user
     */
    getUnseenNotificationsCount(): Promise<int>;
    /**
     * Initializes the notification service
     *
     * Initialization is performed only if the following two conditions are fulfilled:
     *  1. Notification service is enabled
     *  2. Notification service hasn't been initialized yet
     *
     *
     * The main initialization functionality is determining and setting the mode in which notifications are
     * consumed.
     *  The possible modes are:
     *  PACKAGED_APP - Notifications are fetched when a callback is called by PackagedApp environment
     *  FIORI_CLIENT - Notifications are fetched when a callback is called by FioriClient environment
     *  WEB_SOCKET - Notifications are fetched on WebSocket "ping"
     *  POLLING - Notifications are fetched using periodic polling mechanism
     */
    init(): void;
    /**
     * Indicates whether notification service is enabled.
     *  Enabling is based on the `enable` service configuration flag.
     *  The service configuration must also include serviceUrl attribute.
     *
     *
     *
     * @returns A boolean value indicating whether the notifications service is enabled
     */
    isEnabled(): boolean;
    /**
     *
     * @returns boolean value whether first request was already performed and data was returned.
     */
    isFirstDataLoaded(): boolean;
    /**
     * Launches mark as read notification call.
     *  After launching the action, the function gets updated notification data in order to push the updated
     * data to the consumers.
     *
     *
     * @returns Promise object that on success resolves to undefined or it is rejected with a message object
     */
    markRead(
      /**
       * The ID of the notification whose action is being executed
       */
      sNotificationId: string
    ): Promise<any>;
    /**
     * Mark all notifications as seen.
     *  the main use-case is when the user navigated to the notification center and sees all the pending notifications.
     *
     *
     * @returns Promise that resolves when operation is finished
     */
    notificationsSeen(): Promise<any>;
    /**
     * Gets a callback function that will be called when updated unseen notifications count is available.
     */
    registerNotificationCountUpdateCallback(
      /**
       * The callback function that is registered and called on data update.
       */
      callback: Function
    ): void;
    /**
     * Gets a callback function that will be called when updated notifications data is available.
     */
    registerNotificationsUpdateCallback(
      /**
       * The callback function that is registered and called on data update.
       */
      callback: Function
    ): void;
    /**
     * Set the number of unseen notifications
     *  e.g. Notifications that the user hasn't seen yet.
     *
     *
     * @returns Promise resolves when the unseen notifications count is set
     */
    setUnseenNotificationsCount(
      /**
       * The number of unseen notifications to set
       */
      number: int
    ): Promise<any>;
  }
  /**
   * Type for Action
   *
   * @since 1.120.0
   */
  export type Action = {
    /**
     * The ID of the action
     */
    ActionId: string;
    /**
     * The text of the action
     */
    ActionText: string;
    /**
     * The group action text
     */
    GroupActionText: string;
    /**
     * The nature of the action
     */
    Nature: Nature | keyof typeof Nature;
  };

  /**
   * Type for Actor
   *
   * @since 1.120.0
   */
  export type Actor = {
    /**
     * The ID of the actor
     */
    Id: string;
    /**
     * The display text of the actor
     */
    DisplayText: string;
    /**
     * The image source of the actor
     */
    ImageSource: string;
  };

  /**
   * Type for executeBulkAction
   *
   * @since 1.120.0
   */
  export type BulkAction = {
    /**
     * Indicates whether the notification should be deleted after the action is executed
     */
    DeleteOnReturn: boolean;
    /**
     * Indicates whether the action was executed successfully
     */
    Success: boolean;
    /**
     * The ID of the notification
     */
    NotificationId: string;
  };

  /**
   * Enumeration for The nature of the notification
   *
   * This enum is part of the 'sap/ushell/services/NotificationsV2' module export and must be accessed by
   * the property 'Nature'.
   *
   * @since 1.120.0
   */
  enum Nature {
    /**
     * The Negative nature.
     */
    NEGATIVE = "NEGATIVE",
    /**
     * The Neutral nature.
     */
    NEUTRAL = "NEUTRAL",
    /**
     * The Positive nature.
     */
    POSITIVE = "POSITIVE",
  }
  /**
   * Type for the notification item
   *
   * @since 1.120.0
   */
  export type NotificationItem = {
    /**
     * The ID of the notification.
     */
    Id: string;
    /**
     * The ID of the origin, can be a combination of system and client or the value `LOCAL`.
     */
    OriginId: string;
    /**
     * The date and time the notification was created.
     */
    CreatedAt: string;
    /**
     * Indicates whether the notification is actionable.
     */
    IsActionable: boolean;
    /**
     * Indicates whether the notification has been read.
     */
    IsRead: boolean;
    /**
     * Indicates whether the notification can be grouped.
     */
    IsGroupable: boolean;
    /**
     * Indicates whether the notification is a group header.
     */
    IsGroupHeader: boolean;
    /**
     * The action to be executed when the notification is clicked.
     */
    NavigationTargetAction: string;
    /**
     * The object to be navigated to when the notification is clicked.
     */
    NavigationTargetObject: string;
    /**
     * The intent for navigation when the notification is clicked.
     */
    NavigationIntent: string;
    /**
     * The ID for the notification type specified in `NotificationTypeKey`.
     */
    NotificationTypeId: string;
    /**
     * The key of the notification type.
     */
    NotificationTypeKey: string;
    /**
     * The ID of the parent notification.
     */
    ParentId: string;
    /**
     * The priority of the notification.
     */
    Priority: Priority | keyof typeof Priority;
    /**
     * The sensitive text of the notification.
     */
    SensitiveText: string;
    /**
     * The text of the notification.
     */
    Text: string;
    /**
     * The header text of the notification group.
     */
    GroupHeaderText: string;
    /**
     * The number of notifications.
     */
    NotificationCount: number;
    /**
     * The subtitle of the notification.
     */
    SubTitle: string;
    /**
     * The description of the notification type.
     */
    NotificationTypeDesc: string;
    /**
     * The actor of the notification.
     */
    Actor: Actor;
    /**
     * The navigation target parameters of the notification.
     */
    NavigationTargetParams: NotificationTargetParameter[];
    /**
     * The actions of the notification.
     */
    Actions: Action[];
  };

  /**
   * Type for notification target parameters.
   *
   * @since 1.120.0
   */
  export type NotificationTargetParameter = {
    /**
     * The ID of the notification.
     */
    NotificationId: string;
    /**
     * The key of the notification target parameter.
     */
    Key: string;
    /**
     * The value of the notification target parameter.
     */
    Value: string;
  };

  /**
   * Enumeration for the priority of a notification
   *
   * This enum is part of the 'sap/ushell/services/NotificationsV2' module export and must be accessed by
   * the property 'Priority'.
   *
   * @since 1.120.0
   */
  enum Priority {
    /**
     * High priority.
     */
    HIGH = "HIGH",
    /**
     * Low priority.
     */
    LOW = "LOW",
    /**
     * Medium priority.
     */
    MEDIUM = "MEDIUM",
  }
}

declare module "sap/ushell/services/Personalization" {
  import Component from "sap/ui/core/Component";

  /**
   * The Unified Shell's personalization service, which provides a personalizer object that handles all personalization
   * operations.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const Personalization = await Container.getServiceAsync("Personalization");
   *     // do something with the Personalization service
   *   });
   * ```
   *
   *
   * @since 1.15.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2} instead.
   */
  export default class Personalization extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Factory method to obtain an empty Data Context object. When data present in a prior context is not relevant
     * (e.g. when using a "uniquely" generated key and planning to overwrite any colliding front-end server
     * data).
     *
     * The call always returns an cleared container().
     *
     * Note that an existing container at the front-end server is not actually deleted or overwritten unless
     * a save operation is executed.
     *
     * An initial object is returned.
     *
     * @since 1.22.0
     *
     * @returns Resolves a {@link sap.ushell.services.Personalization.ContextContainer} object as parameter.
     * The personalization container provides two different interfaces to synchronously operate on personalization
     * data. In the item mode the container contains items as name value pairs for personalization data. In
     * the variant mode the container contains variant sets which contain variants containing items.
     */
    createEmptyContainer(
      /**
       * identifies the container. The string length is restricted to 40 characters
       */
      sContainerKey: string,
      /**
       * scope object. Currently the validity property of the scope object is relevant: E.g. ` { validity : 30}`
       * indicates a validity of the data for 30 minutes.
       *  oScope.validity : validity of the container persistence in minutes valid values include: 0 ( per FLP
       * Window), Infinity, undefined ( Backend persistence per user ) [Default] nn Minutes ( Backend persistence
       * per user, ignored if older than nn minutes)
       */
      oScope: object,
      /**
       * Since 1.27.0. SAPUI5 component which uses the container. This allows to associate the stored data with
       * the application.
       */
      oComponent: Component
    ): jQuery.Promise;
    /**
     * Asynchronously starts a deletion request for the given container identified by sContainerKey. Can be
     * called without having ever called getContainer with the corresponding key
     *
     * Note: After invoking this operation, the state of other Containers obtained for the same key is undefined!
     * If you want to use the container after deletion, it is strongly recommended to obtain a new instance
     * of a container for the given key *after* the promise has returned.
     *
     * Note: Invoking this operation while another save or load operation is under way may result in failure.
     *
     * @since 1.22.0
     *
     * @returns Resolves once the container was deleted.
     */
    delContainer(
      /**
       * identifies the container
       */
      sContainerKey: string,
      /**
       * scope object
       */
      oScope: object
    ): jQuery.Promise;
    /**
     * Asynchronously starts a deletion request for the given container identified by sContainerKey. Can be
     * called without having ever created a personalization container.
     *
     * Note: After invoking this operation, the state of other PersonalizationContainers obtained for the same
     * key is undefined! If you want to use the container after deletion, it is strongly recommended to obtain
     * a new instance of PersonalizationContainer for the given key *after* the promise has returned.
     *
     * Note: Invoking this operation while another save or load operation is under way may result in failure.
     *
     * @since 1.18.0
     * @deprecated As of version 1.22. Please use {@link #delContainer} instead.
     *
     * @returns Resolves once the container was deleted.
     */
    delPersonalizationContainer(
      /**
       * identifies the container
       */
      sContainerKey: string
    ): jQuery.Promise;
    /**
     * Factory method to obtain a Data Context object, which is a local copy of the persistence layer data.
     * The Container data is asynchronously read on creation if present, otherwise an initial object is created.
     * The Container data can then be *synchronously* modified (getItemValue, setItemValue). Only on invoking
     * the save()/saveDeferred() method the data is transferred to the persistence. This allows the application
     * to perform multiple local modifications and delay the save operation.
     *
     * Every getContainer operation returns a new local copy, containing the full data at the point of creation.
     *
     * Executing load() on the container reloads the data from the persistence, discarding local changes.
     *
     * Note that the container allows the application to control the round trips to the front-end server persistence.
     * The factory method getContainer is asynchronous and loads the container via the connected adapter from
     * the front-end server. All operations (but for the save operation) are executed synchronously, operating
     * on the local data. This allows the application to control the round trips to the front-end server persistence.
     *
     * A container can contain a set of items, identified by a key.
     *
     * You can wrap a container in a VariantSetAdapter to read and write a more complex structure (with multiple
     * keys (variantSet,variant,item)).
     *
     * Do not mix up the usage of a personalizer and a container for one containerKey. Do not use a PersonalizationContainer
     * and a Container for the same key except for migration scenarios.
     *
     * scope / validity parameter (@since 1.22.0): An unspecified (undefined validity) or infinite (Infinity)
     * validity indicates that data is persisted in the Personalization data of the front-end server. A round
     * trip is executed on an initial get and at least every save operation. Data is stored per user and retained
     * indefinitely at the front-end server.
     *
     * The validity parameter allows a designated storage validity for the created container. A 0 validity indicates
     * the data is only persisted within the Fiori launchpad window. No round trips to the front-end server
     * are executed. Data is lost if the Fiori launchpad window state is lost (e.g. by navigating to a different
     * page, pressing F5 (reload page) or duplicating the window).
     *
     * For versions > 1.24 it may happen that for cross-app navigation a reload of the Fiori launchpad is triggered.
     * In this case a storage of the personalization data in the Fiori launchpad window would lead to data loss.
     * To overcome this a validity 0 is automatically changed to a validity 1440 (24h; storage on the front-end
     * server). This is only done if a reload of the Fiori launchpad is triggered for a cross-app navigation.
     *
     * Security: It is the responsibility of the application to not persist information relevant to auditing
     * or security using the PersonalizationService with inappropriate validity models. No mechanisms exist
     * to destroy or selectively destroy application-specific data in the front-end server persistence (especially
     * for validity Infinity).
     *
     * For non-zero validity scopes, data will be transmitted and persisted in the front-end server system.
     *
     * For limited validity, actual deletion of data on the front-end server is subject to explicit cleanup
     * execution of front-end server jobs and not guaranteed. The data may still be persisted and retrievable.
     * The interface only assures that expired data is no longer exposed to the application code in the Fiori
     * launchpad.
     *
     * The ContainerKey uniquely defines the Container, validity is not part of the key (there are no separate
     * namespaces per validity).
     *
     * In general, mixing different validity models for a given container key is not supported. Fast chaining
     * of different methods may source arbitrary persistence layers. The validity of the resolved object is
     * the last get validity.
     *
     * The validity associated with the last getContainer or createEmptyContainer determines the current validity
     * of the container and the validity used during the next save operation.
     *
     * Naturally, if a delete or get with validity 0 is issued, it will *not* delete or retrieve a front-end
     * server persistent storage. Thus a sequence delete( [validity 0])/wait for promise, getContainer(sKey,{
     * validity : Infinity}) may return a valid dataset.
     *
     * @since 1.22.0
     *
     * @returns Resolves a {@link sap.ushell.services.Personalization.ContextContainer} object as parameter.
     * The container provides setItemValue / getItemValue methods to synchronously operate on personalization
     * data. By wrapping it in a VariantSetAdapter, an alternate interface to maintain variants can be obtained.
     */
    getContainer(
      /**
       * identifies the container. The string length is restricted to 40 characters
       */
      sContainerKey: string,
      /**
       * scope object. Currently the validity property of the scope object is relevant: E.g. ` { validity : 30}`
       * indicates a validity of the data for 30 minutes.
       *  oScope.validity : validity of the container persistence in minutes
       *  valid values include: 0 ( per FLP Window),
       *  Infinity, undefined (front-end server persistence per user ) [Default]
       *  nn Minutes (front-end server persistence per user, ignored if older than nn minutes) oScope.shared To
       * indicate that this container is intended to be shared by several applications
       */
      oScope: object,
      /**
       * Since 1.27.0. SAPUI5 component which uses the container. This allows to associate the stored data with
       * the application.
       */
      oComponent: Component
    ): jQuery.Promise;
    /**
     * Returns a generated key. This key is suitably random, but it is susceptible to brute force attacks. Storages
     * based on the generated key must not be used for sensitive data.
     *
     * @since 1.28.0
     *
     * @returns 40 character string consisting of A-Z and 0-9 which can be used as a generated key for personalization
     * container. Every invocation returns a new key. Seed of random function is OS Random Seed.
     */
    getGeneratedKey(): string;
    /**
     * This interface is deprecated since 1.22, please use getContainer / delContainer.
     *
     * Note: the underlying storage model for Objects stored with getContainer / getPersonalizationContainer
     * is identical.
     *  Thus you can safely migrate your client implementation from the deprecated `getPersonalizationContainer`
     * to `getContainer` without loss of data. One may even run mixed set of applications on the same container
     * keys. The sole differences are w.r.t. client side handling of the Context data within one session.
     *
     * If you want to use the variant interface, use the following pattern
     * ```javascript
     *
     *   getContainer(sContainerKey).done(function(oContainer) {
     *     var variantSetAdapter = new Personalization.VariantSetAdapter(oContainer);
     *   }
     * ```
     *
     *
     * Factory method to obtain a personalization container object which is a client-local buffer for personalization
     * data. The Container data is asynchronously read on creation (if present, otherwise an initial object
     * is created). The Container data can then be *synchronously* modified (read/write/delete). Only on invoking
     * the save() method the data is persisted at the front-end server. This allows the application to perform
     * multiple local modifications and delay the save operation. Note that the personalization container allows
     * the application to control the round trips to the front-end server persistence. The factory method getPersonalizationContainer
     * is asynchronous and loads the container via the connected adapter from the front-end server. All operations
     * (but for the save operation) are executed synchronously, operating on the local data. This allows the
     * application to control the round trips to the front-end server persistence.
     *
     * A personalization container can contain items as well as variant sets. Variant sets have the following
     * structure: variantSet.variant.item A variant set is enclosing several variants of the same data.
     *
     * Example: An application has two types of variants. Variant type 1 contains filter values for a query,
     * which are stored in item 1 of the variant, and personalization data for a table, which are stored in
     * item 2 of the variant. Variant type 2 contains a setting (item 3) that is independent of the filtering
     * and the table settings. It might be used for a different screen than the variants of type 1. In this
     * example you would have 2 variant sets, one for each variant type.
     *
     * Do not mix up the usage of a personalizer and a personalization container for one containerKey.
     *
     * @since 1.18.0
     * @deprecated As of version 1.21. Please use {@link #getContainer} instead.
     *
     * @returns Resolves a {@link sap.ushell.services.PersonalizationContainer} object as parameter. The personalization
     * container provides two different interfaces to synchronously operate on personalization data. In the
     * item mode the container contains items as name-value pairs for personalization data. In the variant mode
     * the container contains variant sets which contain variants containing items.
     */
    getPersonalizationContainer(
      /**
       * identifies the container
       */
      sContainerKey: string
    ): jQuery.Promise;
    /**
     * Returns a personalizer object which handles personalization by asynchronous operations storing the personalization
     * data immediately via the connected adapter. For each operation a round trip is executed.
     *
     * Do not mix the usage of a personalizer and a personalization container for one containerKey.
     *
     * Fetching multiple Personalizer for the same container, but different items is not supported. Use {@link sap.ushell.services.Personalizer#getContainer }
     * instead for this scenario.
     *
     * @since 1.15.0
     *
     * @returns A Personalizer which provides generic read and write access to the currently logged on user's
     * personalization settings.
     */
    getPersonalizer(
      /**
       * JSON object consisting of the following parts: container - Identifies the set of personalization data
       * that is loaded/saved as one bundle from the front-end server. item - The name of the object the personalization
       * is applied to.
       */
      oPersId: object,
      /**
       * scope object
       *  currently the validity property of the scope object is relevant: oScope.validity : validity of the container
       * persistence in minutes
       *  oScope.keyCategory : Type or category of key
       *  oScope.writeFrequency : Expected frequency how often users will use this container to store data inside
       *  oScope.clientStorageAllowed : Defines if storage on client side should be allowed or not
       *  oScope.shared: Indicates the container is intended to be shared across multiple applications
       *  E.g. ` { validity : 30}` indicates a validity of the data for 30 minutes.
       */
      oScope: object,
      /**
       * Since 1.27.0. SAPUI5 component which uses the personalizer. This allows to associate the stored data
       * with the application.
       */
      oComponent?: Component
    ): /* was: sap.ushell.services.Personalizer */ any;
    /**
     * Returns a transient personalizer object which handles personalization by asynchronous operations storing
     * the personalization data transiently as an object property. Primary usage of the transient personalizer
     * is a personalization scenario with variants where the transient personalizer is used as a buffer for
     * table personalization data.
     *
     * @since 1.18.0
     *
     * @returns A TransientPersonalizer which provides asynchronous read and write access to a transient personalization
     * data storage.
     */
    getTransientPersonalizer(): /* was: sap.ushell.services.TransientPersonalizer */ any;
  }
}

declare module "sap/ushell/services/_Personalization/ContextContainer" {
  /**
   * The container is the anchor object of the unified shell personalization in container mode.
   *
   * To be called by the personalization service getContainer method.
   *
   * @since 1.22.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2.ContextContainer }
   * instead.
   */
  export default class ContextContainer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Returns an array with all internal keys of direct items in the container.
     *
     * @since 1.22.0
     * @deprecated As of version 1.120.
     *
     * @returns item keys
     */
    _getInternalKeys(): string[];
    /**
     * clears the local copy data of this container
     *
     * @since 1.22.0
     */
    clear(): void;
    /**
     * Checks if a specific direct item is contained in the container.
     *
     * @since 1.22.0
     *
     * @returns true if the container contains a direct item with the key
     */
    containsItem(
      /**
       * item key
       */
      sItemKey: string
    ): boolean;
    /**
     * Deletes a direct item from the container. In case the item does not exist, nothing happens.
     *
     * @since 1.22.0
     */
    delItem(
      /**
       * item key
       */
      sItemKey: string
    ): void;
    /**
     * flush all pending request; The result of the promise may reflect the last pending operation in the queue
     *
     * @since 1.22.0
     *
     * @returns Resolves once the requests were flushed.
     */
    flush(): jQuery.Promise;
    /**
     * Returns an array with the keys of direct items in the container.
     *
     * @since 1.22.0
     *
     * @returns item keys
     */
    getItemKeys(): string[];
    /**
     * Returns the value for a direct item from the container. (Value semantics, new copy is returned)
     *
     * @since 1.22.0
     *
     * @returns item value (JSON object). In case the container does not contain a direct item with this key
     * `undefined` is returned.
     */
    getItemValue(
      /**
       * item key
       */
      sItemKey: string
    ): object;
    /**
     * return the container key as a string variable
     *
     * @since 1.28.0
     *
     * @returns the container key
     */
    getKey(): string;
    /**
     * Return an instance unmodifiable container instance. There is one instance of this wrapper per container.
     * It will permit all read accesses to the container, but block all modifying accesses.
     *
     * @since 1.28.0
     *
     * @returns unmodifiable wrapper instance
     */
    getUnmodifiableContainer(): object;
    /**
     * return the validity of this container only for testing!
     *
     * @since 1.22.0
     * @deprecated As of version 1.31. Support for this function has been discontinued.
     */
    getValidity(): void;
    /**
     * (Re)loads the current container data from the underlying storage asynchronously. The current local data
     * is discarded.
     *
     * Returns a promise for the load operation. If another save/load/delete operation is not completed, the
     * operation may fail! (wait for the other promise).
     *
     * Synchronous read and write operations before the load is done have undefined effects.
     *
     * @since 1.22.0
     *
     * @returns Resolves once the context container is loaded.
     */
    load(): jQuery.Promise;
    /**
     * Attempts to save the current container data at the underlying storage asynchronously. The current state
     * is serialized.
     *
     * @since 1.22.0
     * @deprecated As of version 1.120. Use {@link sap.ushell.services.Personalization.ContextContainer#saveDeferred }
     * instead.
     *
     * @returns Resolves once the container is saved.
     *
     * If another save/load/delete operation is not completed, the operation may fail! (wait for the other promise).
     */
    save(): jQuery.Promise;
    /**
     * Save the current container data at the underlying storage asynchronously at the earlies nDelayInMilliseconds
     * seconds before. The current state is serialized.
     *
     * @since 1.22.0
     *
     * @returns Resolves once the container is saved.
     *
     * The operation may wait for completion of another pending operation.
     */
    saveDeferred(): jQuery.Promise;
    /**
     * Sets the value of a direct item in the container. In case the item is already existing its value is overwritten.
     * In case it is not existing a new item with this key and value is created. The value is serialized during
     * set
     *
     * @since 1.22.0
     */
    setItemValue(
      /**
       * item key The string length is restricted to 40 characters
       */
      sItemKey: string,
      /**
       * item value (JSON object)
       */
      sItemValue: object
    ): void;
  }
}

declare module "sap/ushell/services/_Personalization/PersonalizationContainer" {
  /**
   * The personalization container is the anchor object of the unified shell personalization in container
   * mode.
   *
   * To be called by the personalization service getPersonalizationContainer method.
   *
   * @since 1.18.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.Personalization#getContainer }
   * instead.
   */
  export default class PersonalizationContainer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
  }
}

declare module "sap/ushell/services/_Personalization/PersonalizationContainerVariant" {
  /**
   * The personalization variant contains personalization data. It is used in the personalization container
   * mode.
   *
   * To be called by the personalization variant set.
   *
   * @since 1.18.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.Personalization#getContainer }
   * instead.
   */
  export default class PersonalizationContainerVariant {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Checks if a specific item is contained in this variant.
     *
     * @since 1.18.0
     *
     * @returns true if the variant contains an item with the key
     */
    containsItem(
      /**
       * item key
       */
      sItemKey: string
    ): boolean;
    /**
     * Deletes an item from this variant. In case the item does not exist, nothing happens.
     *
     * @since 1.18.0
     */
    delItem(
      /**
       * item key
       */
      sItemKey: string
    ): void;
    /**
     * Returns an array with the keys of all items in this variant.
     *
     * @since 1.18.0
     *
     * @returns item keys
     */
    getItemKeys(): string[];
    /**
     * Returns the value for an item in this variant.
     *
     * @since 1.18.0
     *
     * @returns item value (JSON object). In case the variant does not contain an item with this key `undefined`
     * is returned.
     */
    getItemValue(
      /**
       * item key
       */
      sItemKey: string
    ): object;
    /**
     * Returns the key of this variant.
     *
     * @since 1.18.0
     *
     * @returns variant key.
     */
    getVariantKey(): string;
    /**
     * Returns the name of this variant.
     *
     * @since 1.18.0
     *
     * @returns variant name.
     */
    getVariantName(): string;
    /**
     * Sets the value for an item in this variant.
     *
     * @since 1.18.0
     */
    setItemValue(
      /**
       * item key
       */
      sItemKey: string,
      /**
       * value (JSON object)
       */
      item: object
    ): void;
  }
}

declare module "sap/ushell/services/_Personalization/PersonalizationContainerVariantSet" {
  /**
   * The personalization variant set contains variants of personalization data. It is used in the personalization
   * container mode.
   *
   * To be called by the personalization container.
   *
   * @since 1.18.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.Personalization#getContainer }
   * instead.
   */
  export default class PersonalizationContainerVariantSet {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Checks if a specific variant is contained in the variant set.
     *
     * @since 1.18.0
     *
     * @returns true if the variant set contains a variant with the key
     */
    containsVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): boolean;
    /**
     * Deletes a variant from the variant set. In case the variant does not exist nothing happens.
     *
     * @since 1.18.0
     */
    delVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): void;
    /**
     * Returns the current variant key.
     *
     * @since 1.18.0
     *
     * @returns current variant key. In case the current variant was never set `null` is returned.
     */
    getCurrentVariantKey(): string;
    /**
     * Returns a variant object.
     *
     * @since 1.18.0
     *
     * @returns {@link sap.ushell.services.Personalization.PersonalizationContainerVariant} In case the variant
     * set does not contain a variant with this key `undefined` is returned.
     */
    getVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): object;
    /**
     * Returns the variant key corresponding to a variant name.
     *
     * @since 1.18.0
     *
     * @returns variant key. In case the variant set does not contain a variant with this name `undefined` is
     * returned.
     */
    getVariantKeyByName(
      /**
       * variant name
       */
      sVariantName: string
    ): object;
    /**
     * Returns an array with the keys of the variants in the variant set.
     *
     * @since 1.18.0
     *
     * @returns variant keys
     */
    getVariantKeys(): string[];
    /**
     * Sets the current variant key.
     *
     * @since 1.18.0
     */
    setCurrentVariantKey(
      /**
       * There is no validity check for the variant key.
       */
      sVariantKey: string
    ): void;
  }
}

declare module "sap/ushell/services/_Personalization/Personalizer" {
  /**
   * The Unified Shell personalizer providing set get delete methods to access the persisted personalization
   * data in direct mode.
   *
   * To be called by the personalization service getPersonalizer method.
   *
   * @since 1.15.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2.Personalizer }
   * instead.
   */
  export default class Personalizer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Deletes a personalization data value.
     *
     * @since 1.15.0
     *
     * @returns Resolves once the pers data was deleted or rejects with an error message.
     */
    delPersData(): jQuery.Promise;
    /**
     * Gets a personalization data value.
     *
     * @since 1.15.0
     *
     * @returns Resolves the personalization value. If there is no personalization data for the item, undefined
     * is returned. Promise object fail function: param {string} sMessage Error message.
     */
    getPersData(): jQuery.Promise;
    /**
     * Sets a personalization data value.
     *
     * @since 1.15.0
     *
     * @returns Resolves once the pers data was stored or rejects with an error message.
     */
    setPersData(
      /**
       * JSON object containing the personalization value.
       */
      oValue: object
    ): jQuery.Promise;
  }
}

declare module "sap/ushell/services/_Personalization/TransientPersonalizer" {
  /**
   * The transient personalizer shall be used in container mode for table personalization. To be called by
   * the personalization service getTransientPersonalizer method.
   *
   * @since 1.18.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2.TransientPersonalizer }
   * instead.
   */
  export default class TransientPersonalizer {
    constructor();
  }
}

declare module "sap/ushell/services/_Personalization/Variant" {
  /**
   * The personalization variant contains personalization data. It is used in the personalization container
   * mode.
   *
   * To be instantiated via Personalization.VariantSet add / get Variant only
   *
   * @since 1.22.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2.Variant} instead.
   */
  export default class Variant {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Checks if a specific item is contained in this variant.
     *
     * @since 1.18.0
     *
     * @returns true if the variant contains an item with the key
     */
    containsItem(
      /**
       * item key
       */
      sItemKey: string
    ): boolean;
    /**
     * Deletes an item from this variant. In case the item does not exist, nothing happens.
     *
     * @since 1.22.0
     */
    delItem(
      /**
       * item key
       */
      sItemKey: string
    ): void;
    /**
     * Returns an array with the keys of all items in this variant.
     *
     * @since 1.22.0
     *
     * @returns item keys
     */
    getItemKeys(): string[];
    /**
     * Returns the value for an item in this variant.
     *
     * @since 1.18.0
     *
     * @returns item value (JSON object). In case the variant does not contain an item with this key `undefined`
     * is returned.
     */
    getItemValue(
      /**
       * item key
       */
      sItemKey: string
    ): object;
    /**
     * Returns the key of this variant.
     *
     * @since 1.22.0
     *
     * @returns variant key.
     */
    getVariantKey(): string;
    /**
     * Returns the name of this variant.
     *
     * @since 1.22.0
     *
     * @returns variant name.
     */
    getVariantName(): string;
    /**
     * Sets the value for an item in this variant.
     *
     * @since 1.18.0
     */
    setItemValue(
      /**
       * item key
       */
      sItemKey: string,
      /**
       * value (JSON object)
       */
      item: object
    ): void;
    /**
     * Sets the name of the variant.
     *
     * In case a variant with `sVariantName` is already existing in the corresponding variant set an exception
     * is thrown.
     *
     * @since 1.24.0
     */
    setVariantName(
      /**
       * variant name
       */
      sVariantName: string
    ): void;
  }
}

declare module "sap/ushell/services/_Personalization/VariantSet" {
  /**
   * The personalization variant set contains variants of personalization data. It is used in the personalization
   * container mode. A VariantSet is a class representing a collection of Variants (identified by a key and
   * name) and a member variable indicating the "current variable"
   *
   * When manipulating the underlying data, additional constraints are enforced.
   *
   * To be called by the personalization container.
   *
   * @since 1.22.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2.VariantSet }
   * instead.
   */
  export default class VariantSet {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new variant in the variant set. In case a variant with this name is already existing an exception
     * is thrown.
     *
     * @since 1.22.0
     *
     * @returns {@link sap.ushell.services.PersonalizationContainerVariant}
     */
    addVariant(
      /**
       * variant set name
       */
      sVariantSetName: string
    ): object;
    /**
     * Checks if a specific variant is contained in the variant set.
     *
     * @since 1.22.0
     *
     * @returns true if the variant set contains a variant with the key
     */
    containsVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): boolean;
    /**
     * Deletes a variant from the variant set. In case the variant does not exist nothing happens.
     *
     * @since 1.22.0
     */
    delVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): void;
    /**
     * Returns the current variant key.
     *
     * @since 1.22.0
     *
     * @returns current variant key. In case the current variant was never set `null` is returned.
     */
    getCurrentVariantKey(): string;
    /**
     * Returns a variant object.
     *
     * @since 1.22.0
     *
     * @returns {@link sap.ushell.services.PersonalizationContainerVariant}. In case the variant set does not
     * contain a variant with this key `undefined` is returned.
     */
    getVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): object;
    /**
     * Returns the variant key corresponding to a variant name.
     *
     * @since 1.22.0
     *
     * @returns variant key. In case the variant set does not contain a variant with this name `undefined` is
     * returned.
     */
    getVariantKeyByName(
      /**
       * variant name
       */
      sVariantName: string
    ): string;
    /**
     * Returns an array with the keys of the variants in the variant set.
     *
     * @since 1.22.0
     *
     * @returns variant keys
     */
    getVariantKeys(): string[];
    /**
     * Sets the current variant key.
     *
     * @since 1.22.0
     */
    setCurrentVariantKey(
      /**
       * There is no validity check for the variant key.
       */
      sVariantKey: string
    ): void;
  }
}

declare module "sap/ushell/services/personalization/VariantSetAdapter" {
  /**
   * Wrapper object to expose a variant interface on a ContextContainer object obtained from the Personalization
   * service:
   * ```javascript
   *
   * getContainer(...).done( function(oContainer) {
   *   that.oVariantSetContainer = new VariantSetAdapter(oContainer);
   * });
   * ```
   *
   *
   * @since 1.18.0
   * @deprecated As of version 1.120. Please use {@link sap.ushell.services.PersonalizationV2.VariantSetAdapter }
   * instead.
   */
  export default class VariantSetAdapter {
    /**
     * VariantSetAdapter amends ContextContainer with functionality to
     *
     * Example: An application has two types of variants. Variant type 1 contains filter values for a query,
     * which are stored in item 1 of the variant, and personalization data for a table, which are stored in
     * item 2 of the variant. Variant type 2 contains a setting (item 3) that is independent of the filtering
     * and the table settings. It might be used for a different screen than the variants of type 1. In this
     * example you would have 2 variant sets, one for each variant type.
     */
    constructor(
      /**
       * Context
       */
      oContextContainer: object
    );

    /**
     * Creates a new variant set in the container. In case a variant set with this key is already existing an
     * exception is thrown.
     *
     * @since 1.22.0
     *
     * @returns {@link ontainerVariantSet}
     */
    addVariantSet(
      /**
       * variant set key
       */
      sVariantSetKey: string
    ): object;
    /**
     * Checks if a specific variant set is contained in the container.
     *
     * @since 1.18.0
     *
     * @returns true if the container contains a variant set with the key
     */
    containsVariantSet(
      /**
       * variant set key
       */
      sVariantSetKey: string
    ): boolean;
    /**
     * Deletes a variant set from the container. In case the variant set does not exist nothing happens.
     *
     * @since 1.22.0
     */
    delVariantSet(
      /**
       * variant set key
       */
      sVariantSetKey: string
    ): void;
    /**
     * Returns the variant set object from the container.
     *
     * @since 1.22.0
     *
     * @returns {@link ontainerVariantSet}. In case the container does not contain a variant set with this key
     * `undefined` is returned.
     */
    getVariantSet(
      /**
       * variant set key The string length is restricted to 40 characters
       */
      sVariantSetKey: string
    ): object;
    /**
     * Returns an array with the keys of the variant sets in the container.
     *
     * @since 1.18.0
     *
     * @returns variant set keys
     */
    getVariantSetKeys(): string[];
  }
}

declare module "sap/ushell/services/PersonalizationV2" {
  import Component from "sap/ui/core/Component";

  import ContextContainer from "sap/ushell/services/PersonalizationV2/ContextContainer";

  import Personalizer from "sap/ushell/services/PersonalizationV2/Personalizer";

  import TransientPersonalizer from "sap/ushell/services/PersonalizationV2/TransientPersonalizer";

  /**
   * The Unified Shell's personalization service. Provides a personalizer object that handles all personalization
   * operations.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const PersonalizationV2 = await Container.getServiceAsync("PersonalizationV2");
   *     // do something with the PersonalizationV2 service
   *   });
   * ```
   *
   *
   * @since 1.120.0
   */
  export default class PersonalizationV2 extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Factory method to obtain an empty Data Context object. When data present in a prior context is not relevant
     * (e.g. when using a "uniquely" generated key and planning to overwrite any colliding front-end server
     * data).
     *
     * The call always returns an cleared container().
     *
     * Note that an existing container at the front-end server is not actually deleted or overwritten unless
     * a save operation is executed.
     *
     * An initial object is returned.
     *
     * @since 1.120.0
     *
     * @returns Resolves a ContextContainer as parameter. object as parameter. The personalization container
     * provides two different interfaces to synchronously operate on personalization data. In the item mode
     * the container contains items as name value pairs for personalization data. In the variant mode the container
     * contains variant sets which contain variants containing items.
     */
    createEmptyContainer(
      /**
       * Identifies the container. The string length is restricted to 40 characters
       */
      sContainerKey: string,
      /**
       * Currently the validity property of the scope object is relevant.
       *  E.g. ` { validity : 30}` indicates a validity of the data for 30 minutes.
       */
      oScope: Scope,
      /**
       * Component which uses the container. This allows to associate the stored data with the application.
       */
      oComponent: Component
    ): Promise<ContextContainer>;
    /**
     * Asynchronously starts a deletion request for the given container identified by sContainerKey. Can be
     * called without having ever called getContainer with the corresponding key
     *
     * Note: After invoking this operation, the state of other containers obtained for the same key is undefined!
     * If you want to use the container after deletion, it is strongly recommended to obtain a new instance
     * of a container for the given key *after* the promise has returned.
     *
     * Note: Invoking this operation while another save or load operation is under way may result in failure.
     *
     * @since 1.120.0
     *
     * @returns Resolves once the container was deleted.
     */
    deleteContainer(
      /**
       * identifies the container
       */
      sContainerKey: string,
      /**
       * The scope
       */
      oScope: Scope
    ): Promise<any>;
    /**
     * Factory method to obtain a Data Context object, which is a local copy of the persistence layer data.
     * The Container data is asynchronously read on creation if present, otherwise an initial object is created.
     * The Container data can then be *synchronously* modified (getItemValue, setItemValue). Only on invoking
     * the save() method the data is transferred to the persistence. This allows the application to perform
     * multiple local modifications and delay the save operation.
     *
     * Every getContainer operation returns a new local copy, containing the full data at the point of creation.
     *
     * Executing load() on the container reloads the data from the persistence, discarding local changes.
     *
     * Note that the container allows the application to control the round trips to the front-end server persistence.
     * The factory method getContainer is asynchronous and loads the container via the connected adapter from
     * the front-end server. All operations (but for the save operation) are executed synchronously, operating
     * on the local data. This allows the application to control the round trips to the front-end server persistence.
     *
     * A container can contain a set of items, identified by a key.
     *
     * You can wrap a container in a VariantSetAdapter to read and write a more complex structure (with multiple
     * keys (variantSet,variant,item)).
     *
     * Do not mix up the usage of a personalizer and a container for one containerKey. Do not use a PersonalizationContainer
     * and a Container for the same key except for migration scenarios.
     *
     * scope / validity parameter: An unspecified (undefined validity) or infinite (Infinity) validity indicates
     * that data is persisted in the Personalization data of the front-end server. A round trip is executed
     * on an initial get and at least every save operation. Data is stored per user and retained indefinitely
     * at the front-end server.
     *
     * The validity parameter allows a designated storage validity for the created container. A 0 validity indicates
     * the data is only persisted within the Fiori launchpad window. No round trips to the front-end server
     * are executed. Data is lost if the Fiori launchpad window state is lost (e.g. by navigating to a different
     * page, pressing F5 (reload page) or duplicating the window).
     *
     * For versions > 1.24 it may happen that for cross-app navigation a reload of the Fiori launchpad is triggered.
     * In this case a storage of the personalization data in the Fiori launchpad window would lead to data loss.
     * To overcome this a validity 0 is automatically changed to a validity 1440 (24h; storage on the front-end
     * server). This is only done if a reload of the Fiori launchpad is triggered for a cross-app navigation.
     *
     * Security: It is the responsibility of the application to not persist information relevant to auditing
     * or security using the PersonalizationService with inappropriate validity models. No mechanisms exist
     * to destroy or selectively destroy application-specific data in the front-end server persistence (especially
     * for validity Infinity).
     *
     * For non-zero validity scopes, data will be transmitted and persisted in the front-end server system.
     *
     * For limited validity, actual deletion of data on the front-end server is subject to explicit cleanup
     * execution of front-end server jobs and not guaranteed. The data may still be persisted and retrievable.
     * The interface only assures that expired data is no longer exposed to the application code in the Fiori
     * launchpad.
     *
     * The ContainerKey uniquely defines the Container, validity is not part of the key (there are no separate
     * namespaces per validity).
     *
     * In general, mixing different validity models for a given container key is not supported. Fast chaining
     * of different methods may source arbitrary persistence layers. The validity of the resolved object is
     * the last get validity.
     *
     * The validity associated with the last getContainer or createEmptyContainer determines the current validity
     * of the container and the validity used during the next save operation.
     *
     * Naturally, if a delete or get with validity 0 is issued, it will *not* delete or retrieve a front-end
     * server persistent storage. Thus a sequence delete( [validity 0])/wait for promise, getContainer(sKey,{
     * validity : Infinity}) may return a valid dataset.
     *
     * @since 1.120.0
     *
     * @returns Resolves a ContextContainer as parameter. The container provides setItemValue / getItemValue
     * methods to synchronously operate on personalization data. By wrapping it in a VariantSetAdapter, an alternate
     * interface to maintain variants can be obtained.
     */
    getContainer(
      /**
       * Identifies the container. The string length is restricted to 40 characters
       */
      sContainerKey: string,
      /**
       * Currently the validity property of the scope object is relevant: E.g. ` { validity : 30}` indicates a
       * validity of the data for 30 minutes.
       */
      oScope: Scope,
      /**
       * Component which uses the container. This allows to associate the stored data with the application.
       */
      oComponent: Component
    ): Promise<ContextContainer>;
    /**
     * Returns a generated key. This key is suitably random, but it is susceptible to brute force attacks. Storages
     * based on the generated key must not be used for sensitive data.
     *
     * @since 1.120.0
     *
     * @returns 40 character string consisting of A-Z and 0-9 which can be used as a generated key for personalization
     * container. Every invocation returns a new key. Seed of random function is OS Random Seed.
     */
    getGeneratedKey(): Promise<string>;
    /**
     * Returns a personalizer object which handles personalization by asynchronous operations storing the personalization
     * data immediately via the connected adapter. For each operation a round trip is executed.
     *
     * Do not mix the usage of a personalizer and a personalization container for one containerKey.
     *
     * Fetching multiple Personalizer for the same container, but different items is not supported. Use {@link sap.ushell.services.Personalizer#getContainer }
     * instead for this scenario.
     *
     * @since 1.120.0
     *
     * @returns which provides generic read and write access to the currently logged on user's personalization
     * settings.
     */
    getPersonalizer(
      /**
       * object for identifying the data
       */
      oPersId: PersId,
      /**
       * scope object
       *  E.g. ` { validity: 30}` indicates a validity of the data for 30 minutes.
       */
      oScope: Scope,
      /**
       * Component which uses the personalizer. This allows to associate the stored data with the application.
       */
      oComponent?: Component
    ): Promise<Personalizer>;
    /**
     * Returns a transient personalizer object which handles personalization by asynchronous operations storing
     * the personalization data transiently as an object property. Primary usage of the transient personalizer
     * is a personalization scenario with variants where the transient personalizer is used as a buffer for
     * table personalization data.
     *
     * @since 1.120.0
     *
     * @returns which provides asynchronous read and write access to a transient personalization data storage.
     */
    getTransientPersonalizer(): Promise<TransientPersonalizer>;
  }
  /**
   * The persId identifies the stored personalization container.
   */
  export type PersId = {
    /**
     * Identifies the set of personalization data that is loaded/saved as one bundle from the front-end server.
     */
    container: string;
    /**
     * The name of the object the personalization is applied to.
     */
    item: string;
  };

  /**
   * The scope controls the behavior of the container used by the personalization service.
   */
  export type Scope = {
    /**
     * validity of the container persistence in minutes. Available values:
     *  · 0 - The data is persisted in the launchpad window, and is lost when the window is closed or when the
     * launchpad is reloaded.
     *  · Infinity - The data is persisted on the front-end server without any time restrictions.
     *  · x Minutes - Number of minutes the data is to be persisted on the front-end server, for example 30.
     *
     *
     * For validity > 0 (including infinity) a copy of the container is stored in the volatile memory of the
     * launchpad window in the browser. Therefore, no roundtrip is necessary for reloading a container at a
     * later point in time. Only if the launchpad itself is reloaded, the copy is lost and a roundtrip is necessary.
     */
    validity?: int;
    /**
     * Type or category of key
     */
    keyCategory?:
      | sap.ushell.services.PersonalizationV2.KeyCategory
      | keyof typeof sap.ushell.services.PersonalizationV2.KeyCategory;
    /**
     * Expected frequency how often users will use this container to store data inside
     */
    writeFrequency?:
      | sap.ushell.services.PersonalizationV2.WriteFrequency
      | keyof typeof sap.ushell.services.PersonalizationV2.WriteFrequency;
    /**
     * Defines if storage on client side should be allowed or not. Security-relevant data must not be stored
     * on client side, for instance in local storage or in the HTTP browser cache. Applications should set this
     * parameter to `true` only if the data is not critical from a security point of view.
     */
    clientStorageAllowed?: boolean;
    /**
     * Indicates the container is intended to be shared across multiple applications.
     */
    shared?: boolean;
  };
}

declare module "sap/ushell/services/PersonalizationV2/ContextContainer" {
  /**
   * The container is the anchor object of the unified shell personalization in container mode.
   *
   * To be called by the personalization service getContainer method.
   *
   * @since 1.120.0
   */
  export default class ContextContainer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * clears the local copy data of this container
     *
     * @since 1.120.0
     */
    clearData(): void;
    /**
     * Checks if a specific direct item is contained in the container.
     *
     * @since 1.120.0
     *
     * @returns `true` if the container contains a direct item with the key
     */
    containsItem(
      /**
       * item key
       */
      sItemKey: string
    ): boolean;
    /**
     * Deletes a direct item from the container. In case the item does not exist, nothing happens.
     *
     * @since 1.120.0
     */
    deleteItem(
      /**
       * item key
       */
      sItemKey: string
    ): void;
    /**
     * flush all pending request; The result of the promise may reflect the last pending operation in the queue
     *
     * @since 1.120.0
     *
     * @returns Resolves once the pending requests were flushed.
     */
    flushPendingRequests(): Promise<any>;
    /**
     * Returns an array with the keys of direct items in the container.
     *
     * @since 1.120.0
     *
     * @returns item keys
     */
    getItemKeys(): string[];
    /**
     * Returns the value for a direct item from the container. (Value semantics, new copy is returned)
     *
     * @since 1.120.0
     *
     * @returns item value (JSON object). In case the container does not contain a direct item with this key
     * `undefined` is returned.
     */
    getItemValue(
      /**
       * item key
       */
      sItemKey: string
    ): object;
    /**
     * return the container key as a string variable
     *
     * @since 1.120.0
     *
     * @returns the container key
     */
    getKey(): string;
    /**
     * (Re)loads the current container data from the underlying storage asynchronously. The current local data
     * is discarded.
     *
     * Returns a promise for the load operation. If another save/load/delete operation is not completed, the
     * operation may fail! (wait for the other promise).
     *
     * Synchronous read and write operations before the load is done have undefined effects.
     *
     * @since 1.120.0
     *
     * @returns Resolves with undefined on success or rejects on failure
     */
    load(): Promise<any>;
    /**
     * Save the current container data at the underlying storage asynchronously at the earlies nDelayInMilliseconds
     * seconds before. The current state is serialized.
     *
     * @since 1.120.0
     *
     * @returns Promise object
     *
     * The operation may wait for completion of another pending operation.
     */
    save(nDelayInMilliseconds: int): Promise<any>;
    /**
     * Sets the value of a direct item in the container. In case the item is already existing its value is overwritten.
     * In case it is not existing a new item with this key and value is created. The value is serialized during
     * set
     *
     * @since 1.120.0
     */
    setItemValue(
      /**
       * item key. The string length is restricted to 40 characters
       */
      sItemKey: string,
      /**
       * item value (JSON object)
       */
      oItemValue: object
    ): void;
  }
}

declare module "sap/ushell/services/PersonalizationV2/Personalizer" {
  /**
   * The Unified Shell personalizer providing set get delete methods to access the persisted personalization
   * data in direct mode.
   *
   * To be called by the personalization service getPersonalizer method.
   *
   * @since 1.120.0
   */
  export default class Personalizer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Deletes a personalization data value.
     *
     * @since 1.120.0
     *
     * @returns Resolves if delete was successful
     */
    deletePersData(): Promise<any>;
    /**
     * Gets a personalization data value.
     *
     * @since 1.120.0
     *
     * @returns Resolves with the personalization data or rejects on failure
     */
    getPersData(): Promise<object>;
    /**
     * Sets a personalization data value.
     *
     * @since 1.120.0
     *
     * @returns Resolves if save was successful
     */
    setPersData(
      /**
       * JSON object containing the personalization value.
       */
      oValue: object
    ): Promise<any>;
  }
}

declare module "sap/ushell/services/PersonalizationV2/TransientPersonalizer" {
  /**
   * The transient personalizer shall be used in container mode for table personalization. To be called by
   * the personalization service getTransientPersonalizer method.
   *
   * @since 1.120.0
   */
  export default class TransientPersonalizer {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Deletes a personalization data value.
     *
     * @since 1.120.0
     *
     * @returns Resolves if delete was successful.
     */
    deletePersData(): Promise<any>;
    /**
     * Gets a personalization data value.
     *
     * @since 1.120.0
     *
     * @returns Resolves the data.
     */
    getPersData(): Promise<object>;
    /**
     * Sets a personalization data value.
     *
     * @since 1.120.0
     *
     * @returns Resolves if save was successful.
     */
    setPersData(
      /**
       * JSON object containing the personalization value.
       */
      oValue: object
    ): Promise<any>;
  }
}

declare module "sap/ushell/services/PersonalizationV2/Variant" {
  /**
   * The personalization variant contains personalization data. It is used in the personalization container
   * mode.
   *
   * To be instantiated via Personalization.VariantSet add / get Variant only
   *
   * @since 1.120.0
   */
  export default class Variant {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Checks if a specific item is contained in this variant.
     *
     * @since 1.120.0
     *
     * @returns `true` if the variant contains an item with the key
     */
    containsItem(
      /**
       * item key
       */
      sItemKey: string
    ): boolean;
    /**
     * Deletes an item from this variant. In case the item does not exist, nothing happens.
     *
     * @since 1.120.0
     */
    deleteItem(
      /**
       * item key
       */
      sItemKey: string
    ): void;
    /**
     * Returns an array with the keys of all items in this variant.
     *
     * @since 1.120.0
     *
     * @returns item keys
     */
    getItemKeys(): string[];
    /**
     * Returns the value for an item in this variant.
     *
     * @since 1.120.0
     *
     * @returns item value (JSON object). In case the variant does not contain an item with this key `undefined`
     * is returned.
     */
    getItemValue(
      /**
       * item key
       */
      sItemKey: string
    ): object;
    /**
     * Returns the key of this variant.
     *
     * @since 1.120.0
     *
     * @returns variant key.
     */
    getVariantKey(): string;
    /**
     * Returns the name of this variant.
     *
     * @since 1.120.0
     *
     * @returns variant name.
     */
    getVariantName(): string;
    /**
     * Sets the value for an item in this variant.
     *
     * @since 1.120.0
     */
    setItemValue(
      /**
       * item key
       */
      sItemKey: string,
      /**
       * value (JSON object)
       */
      oItemValue: object
    ): void;
    /**
     * Sets the name of the variant.
     *
     * In case a variant with `sVariantName` is already existing in the corresponding variant set an exception
     * is thrown.
     *
     * @since 1.120.0
     */
    setVariantName(
      /**
       * variant name
       */
      sVariantName: string
    ): void;
  }
}

declare module "sap/ushell/services/PersonalizationV2/VariantSet" {
  import Variant from "sap/ushell/services/PersonalizationV2/Variant";

  /**
   * A VariantSet is a class representing a collection of Variants (identified by a key and name) and a member
   * variable indicating the "current variable"
   *
   * When manipulating the underlying data, additional constraints are enforced.
   *
   * The personalization variant set contains variants of personalization data. It is used in the personalization
   * container mode.
   *
   * To be called by the personalization container
   *
   * @since 1.120.0
   */
  export default class VariantSet {
    constructor();

    /**
     * Creates a new variant in the variant set. In case a variant with this name is already existing an exception
     * is thrown.
     *
     * @since 1.120.0
     */
    addVariant(
      /**
       * variant set name
       */
      sVariantName: string
    ): Variant;
    /**
     * Checks if a specific variant is contained in the variant set.
     *
     * @since 1.120.0
     *
     * @returns `true` if the variant set contains a variant with the key
     */
    containsVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): boolean;
    /**
     * Deletes a variant from the variant set. In case the variant does not exist nothing happens.
     *
     * @since 1.120.0
     */
    deleteVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): void;
    /**
     * Returns the current variant key.
     *
     * @since 1.120.0
     *
     * @returns current variant key. In case the current variant was never set `null` is returned.
     */
    getCurrentVariantKey(): string;
    /**
     * Returns a variant object.
     *
     * @since 1.120.0
     *
     * @returns In case the variant set does not contain a variant with this key `undefined` is returned.
     */
    getVariant(
      /**
       * variant key
       */
      sVariantKey: string
    ): Variant;
    /**
     * Returns the variant key corresponding to a variant name.
     *
     * @since 1.120.0
     *
     * @returns variant key. In case the variant set does not contain a variant with this name `undefined` is
     * returned.
     */
    getVariantKeyByName(
      /**
       * variant name
       */
      sVariantName: string
    ): string;
    /**
     * Returns an array with the keys of the variants in the variant set.
     *
     * @since 1.120.0
     *
     * @returns variant keys
     */
    getVariantKeys(): string[];
    /**
     * Sets the current variant key.
     *
     * @since 1.120.0
     */
    setCurrentVariantKey(
      /**
       * There is no validity check for the variant key.
       */
      sVariantKey: string
    ): void;
  }
}

declare module "sap/ushell/services/PersonalizationV2/VariantSetAdapter" {
  import ContextContainer from "sap/ushell/services/PersonalizationV2/ContextContainer";

  import VariantSet from "sap/ushell/services/PersonalizationV2/VariantSet";

  /**
   * Wrapper object to expose a variant interface on a ContextContainer object obtained from the PersonalizationV2
   * service:
   * ```javascript
   *
   * oPersonalizationV2Service.getContainer(...).then(function(oContainer) {
   *   that.oVariantSetContainer = new VariantSetAdapter(oContainer);
   * });
   * ```
   *
   *
   * VariantSetAdapter amends ContextContainer with functionality to
   *
   * Example: An application has two types of variants. Variant type 1 contains filter values for a query,
   * which are stored in item 1 of the variant, and personalization data for a table, which are stored in
   * item 2 of the variant. Variant type 2 contains a setting (item 3) that is independent of the filtering
   * and the table settings. It might be used for a different screen than the variants of type 1. In this
   * example you would have 2 variant sets, one for each variant type.
   *
   * @since 1.120.0
   */
  export default class VariantSetAdapter {
    constructor(
      /**
       * Context
       */
      oContextContainer: ContextContainer
    );

    /**
     * Creates a new variant set in the container. In case a variant set with this key is already existing an
     * exception is thrown.
     *
     * @since 1.120.0
     *
     * @returns The new VariantSet
     */
    addVariantSet(
      /**
       * variant set key
       */
      sVariantSetKey: string
    ): VariantSet;
    /**
     * Checks if a specific variant set is contained in the container.
     *
     * @since 1.120.0
     *
     * @returns `true` if the container contains a variant set with the key
     */
    containsVariantSet(
      /**
       * variant set key
       */
      sVariantSetKey: string
    ): boolean;
    /**
     * Deletes a variant set from the container. In case the variant set does not exist nothing happens.
     *
     * @since 1.120.0
     */
    deleteVariantSet(
      /**
       * variant set key
       */
      sVariantSetKey: string
    ): void;
    /**
     * Returns the variant set object from the container.
     *
     * @since 1.120.0
     *
     * @returns In case the container does not contain a variant set with this key `undefined` is returned.
     */
    getVariantSet(
      /**
       * variant set key. The string length is restricted to 40 characters.
       */
      sVariantSetKey: string
    ): VariantSet;
    /**
     * Returns an array with the keys of the variant sets in the container.
     *
     * @since 1.120.0
     *
     * @returns variant set keys
     */
    getVariantSetKeys(): string[];
  }
}

declare module "sap/ushell/services/ShellNavigation" {
  /**
   * The Unified Shell's internal navigation service (platform independent).
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const ShellNavigation = await Container.getServiceAsync("ShellNavigation");
   *     // do something with the ShellNavigation service
   *   });
   * ```
   *
   *
   * This interface is for consumption by shell renderers/containers only
   *
   * It is not for direct usage by applications, see inner app navigation : UI5 interfaces (hashChanger, Router)
   * cross app navigation : @see sap.ushell.services.CrossApplicationNavigation
   *
   * Usage:
   *
   * Example: see renders/fiorisandbox/Shell.controller.js
   *
   *
   * ```javascript
   *
   *   sap.ui.define([
   *      "sap/ushell/services/ShellNavigation"
   *   ], function (ShellNavigation) {
   *       Shell.onHashChange(shellHash,appHash) {  / *resolve url, load app and exchange root view* / }
   *       Shell.init() {
   *         this.privShellNavigator = new ShellNavigation();
   *         this.privShellNavigator.init(jQuery.proxy(this.doHashChange, this));
   *       }
   *   });
   *   ```
   *
   *
   * Note: further app specific integration via the reference app reuse code (setting of app specific handler)
   *
   * Note: the ShellNavigation service replaces the UI5 core HashChanger which abstracts from the browser
   * url modification.
   *
   * It performs the following services: - encoding of the actual browser url hash ( via hasher.js). - expansion
   * of "shortened" urls ( AppParameterParts) via invocation. - splitting of shellHash and AppSpecific hash
   * and abstraction w.r.t. Eventing
   *
   * Thus it is crucial to use appropriate interfaces and not directly invoke window.location.hash.
   *
   * - internal construction methods for a "current" App specific and non-app specific hash (invoked by CrossApplicationNavigation),
   *     not to be invoked directly!
   *
   * @since 1.15.0
   * @deprecated As of version 1.120. Use {@link sap.ushell.services.Navigation} for Navigation instead.
   */
  export default class ShellNavigation {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * compact the parameter object, if required a number of parameters will be removed, instead a corresponding
     * "sap-intent-param" containing a key of an appstate representing the removed parameters will be inserted
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns a promise, whose first argument of resolve is
     */
    compactParams(
      /**
       * A parameter object
       */
      oParams: object,
      /**
       * An array of string value of parameters which shall not be compacted The array may contains a *-terminated
       * string, which will match and strings with the same prefix ( e.g. "sap-*" will match "sap-ushell", "sap-wd",
       * "sap-" etc. )
       */
      aRetainedParameters?: any[],
      /**
       * optional, a SAP UI5 Component
       */
      oComponent?: object,
      /**
       * whether an transient appstate is sufficient
       */
      bTransient?: boolean
    ): Promise<any>;
    /**
     * Returns the current navigation context.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns An object like:
     * ```javascript
     *
     *   {
     *      "status": sap.ushell.NavigationState.Navigating,
     *      "isCrossAppNavigation": true,
     *      "innerAppRoute": "employee/overview"
     *   }
     *   ```
     *
     *
     * This object can be used inside dirty flag providers to take corresponding actions.
     */
    getNavigationContext(): object;
    /**
     * Initializes ShellNavigation
     *
     * This function should be used by a custom renderer in order to implement custom navigation. Do not use
     * this function for developing Fiori applications.
     *
     * This method should be invoked by the Shell in order to: - Register the event listener - Register the
     * container callback for the (currently single) ShellHash changes.
     *
     * Signature of the callback function sShellHashPart, // The hash part on the URL that is resolved and used
     * for application loading sAppSpecificPart // Typically ignored sOldShellHashPart, // The old shell hash
     * part, if exist sOldAppSpecificPart, // The old app hash part, if exist
     *
     *
     * @returns Reference to `this` for method chaining.
     */
    init(
      /**
       * The callback method for hash changes
       */
      fnShellCallback: Function
    ): this;
    /**
     * Rewrite the hash fragment identifier without triggering any navigation at
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    replaceHashWithoutNavigation(
      /**
       * new hash fragment
       */
      sNewHash: string
    ): void;
    /**
     * Resets the internal flag used to track whether the last navigation is made via hasher#setHash or hasher#replaceHash.
     * This method should be called after a navigation is successfully made to a target application to avoid
     * returning an inconsistent answer when calling `#wasHistoryEntryReplaced`. An inconsistent answer might
     * occur when a navigation is made via forward/back button without passing via `hasher#replaceHash` or `hasher#setHash`.
     *
     * This method should not be used externally. It's reserved uniquely for internal shell consumption and
     * its signature or result might change at any time.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    resetHistoryEntryReplaced(): void;
    /**
     * Returns true if the history entry was replaced immediately after the last navigation. To be useful, this
     * method should be called immediately after the hash enters the URL but before the target application is
     * finally navigated to.
     *
     * This method should not be used externally. It's reserved uniquely for internal shell consumption and
     * its signature or result might change at any time.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether `hasher#replaceHash` was called after the last navigation.
     */
    wasHistoryEntryReplaced(): boolean;
  }
}

declare module "sap/ushell/services/SmartNavigation" {
  /**
   * Constructs an instance of SmartNavigation.  The constructed service provides an enhancement on {@link CrossApplicationNavigation#getLinks }
   * and {@link CrossApplicationNavigation#toExternal}. In order for an application to leverage this enhancement,
   * it is pertinent that the application uses {@link SmartNavigation#toExternal} for navigation. Hence the
   * caller can subsequently use {@link SmartNavigation#getLinks} with the outcome that it sorts the resulting
   * list in the order of frequency of attempted navigation from the application to respective links.
   *  Attempted in the previous paragraph is emphasized due to the fact that a click on the link
   * will cause an increment of the frequency count, regardless of whether or not the navigation was successful.
   *
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const SmartNavigation = await Container.getServiceAsync("SmartNavigation");
   *     // do something with the SmartNavigation service
   *   });
   * ```
   *
   *
   * @since 1.44.0
   * @deprecated As of version 1.112. Please use the CrossApplicationNavigation service instead.
   */
  export default class SmartNavigation extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Resolves the given semantic object (or action) and business parameters to a list of links available to
     * the user, sorted according their relevance to the calling application.
     *
     * The relevance of link is defined by the frequency with which a navigation activity from the calling application
     * to that link occurs.
     *
     * Internally, this method delegates to {@link sap.ushell.services.CrossApplicationNavigation#getLinks }
     * and then sorts the resulting list accordingly.
     * See:
     * 	sap.ushell.services.CrossApplicationNavigation#getLinks
     *
     * @since 1.44.0
     *
     * @returns Resolves with an array of link objects sorted according to their relevance to the calling application.
     */
    getLinks(): jQuery.Promise;
    /**
     * Completely delegates to {@link sap.ushell.services.CrossApplicationNavigation#getPrimaryIntent}, and
     * either may be used in place of the other with exactly the same outcome.
     * See:
     * 	sap.ushell.services.CrossApplicationNavigation#getPrimaryIntent
     *
     * @since 1.48.0
     */
    getPrimaryIntent(): void;
    /**
     * Completely delegates to {@link sap.ushell.services.CrossApplicationNavigation#hrefForExternal}, and may
     * be used in place of the other with exactly the same outcome.
     * See:
     * 	sap.ushell.services.CrossApplicationNavigation#hrefForExternal
     *
     * @since 1.46.0
     * @deprecated As of version 1.94. Please use {@link #hrefForExternalAsync} instead.
     */
    hrefForExternal(): void;
    /**
     * Completely delegates to {@link sap.ushell.services.CrossApplicationNavigation#hrefForExternalAsync},
     * and may be used in place of the other with exactly the same outcome.
     * See:
     * 	sap.ushell.services.CrossApplicationNavigation#hrefForExternalAsync
     *
     * @since 1.94.0
     *
     * @returns A promise that is resolved to a string that can be put into an href attribute of an HTML anchor.
     * The returned string will always start with a hash character.
     */
    hrefForExternalAsync(): Promise<string>;
    /**
     * Usage of this method in place of {@link sap.ushell.services.CrossApplicationNavigation#toExternal} drives
     * the smartness of the results returned by {@link sap.ushell.services.SmartNavigation#getLinks}.
     * See:
     * 	sap.ushell.services.CrossApplicationNavigation#toExternal
     *
     * @since 1.44.0
     */
    toExternal(): void;
    /**
     * Tracks a navigation to a valid intent if provided via arguments but does not perform the navigation itself.
     * If no valid intent was provided tracking will be prevented. The intent has to consist of SemanticObject
     * and Action. It may be passed as complete shellHash (presidence) or as individual parts Additional parameters
     * will not be part of the tracking and ignored This Method can be used to track a click if the actual navigation
     * was triggered via clicking a link on the UI.
     *
     * @since 1.46.0
     *
     * @returns Resolves once the navigation was tracked.
     */
    trackNavigation(
      /**
       * The navigation target as object, for example: `{ target: { shellHash: 'SaleOrder-display' } }` or
       * ```javascript
       *
       *   {
       *     target: {
       *       semanticObject: 'SalesOrder',
       *       action: 'action'
       *     }
       *   }
       * ```
       */
      oArgs: object
    ): jQuery.Promise;
  }
}

declare module "sap/ushell/services/SpaceContent" {
  /**
   * Type for the value of a UserDefault parameter. It contains either a value, an extendedValue, or both.
   *
   * Example:
   * ```javascript
   *
   *      {
   *          "value": "ZMAT1",
   *          "extendedValue": {
   *              "Ranges": [
   *                  {
   *                      "Sign": "I",
   *                      "Option": "BT",
   *                      "Low": "A*",
   *                      "High": "F*"
   *                  }
   *              ]
   *          }
   *      }
   * ```
   *
   *
   * @since 1.120.0
   */
  export type ParameterValue = {
    /**
     * The value of a single-parameter.
     */
    value?: string;
    /**
     * Object containing the ranges for a range-parameter.
     */
    extendedValue?: {
      Ranges: Range[];
    };
  };

  /**
   * Type for describing a parameter value range.
   *
   * @since 1.120.0
   */
  export type Range = {
    /**
     * The sign value of the range.
     */
    Sign: string;
    /**
     * The option value of the range.
     */
    Option: string;
    /**
     * The low value of the range.
     */
    Low: string;
    /**
     * The high value of the range.
     */
    High: string;
  };
}

declare module "sap/ushell/services/SupportTicket" {
  /**
   * The Unified Shell's SupportTicket service.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const SupportTicket = await Container.getServiceAsync("SupportTicket");
   *     // do something with the SupportTicket service
   *   });
   * ```
   *
   *
   * @since 1.19.1
   */
  export default class SupportTicket extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a Support Ticket. Forwards the given data (JSON object) to the associated adapter.
     *
     * @since 1.20.0
     *
     * @returns Promise, that returns the ID of the generated message
     */
    createTicket(
      /**
       * JSON object containing the input fields required for the support ticket.
       */
      oSupportTicketData: {
        /**
         * Subject line of the ticket.
         */
        subject: string;
        /**
         * Long text or description of the support ticket.
         */
        text: string;
        /**
         * JSON object containing client-related information.
         */
        clientContext: object;
      }
    ): Promise<string>;
    /**
     * Checks if the service is enabled.  The service enablement depends on the configuration in the back-end
     * system and the bootstrap configuration.
     *
     * @since 1.20.0
     *
     * @returns `true` if the service is enabled; `false` otherwise
     */
    isEnabled(): boolean;
  }
}

declare module "sap/ushell/services/URLParsing" {
  import Component from "sap/ui/core/Component";

  import {
    TargetIntentStrict,
    TargetIntent,
  } from "sap/ushell/services/Navigation";

  import { URI } from "sap/ui/core/library";

  /**
   * The Unified Shell's internal URL parsing service (platform independent).
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const URLParsing = await Container.getServiceAsync("URLParsing");
   *     // do something with the URLParsing service
   *   });
   * ```
   *
   *
   * Methods in this class allow to break down a shell compliant hash into it's respective parts (SemanticObject,Action,Context,
   * Parameters, appSpecificHash) or (ShellPart,appSpecificHash) respectively or construct a hash from its
   * constituents.
   *
   * All methods deal with the *internal* shellHash format.
   *
   * Most of the parse methods are robust w.r.t. a leading "#".
   *
   * Note: The functions were designed with a "truthy" behavior for not present values, Thus a client should
   * not rely on the difference between null, "undefined", "" when testing for the result of a parse action.
   *
   * The parsing functions are deliberately restrictive and fragile, only shell compliant hashes are parsed
   * correctly, behavior for non-compliant hashes is undefined and subject to change, notably we do not aim
   * do "degrade" nicely or support partial parsing of corrupted urls.
   *
   * @since 1.15.0
   */
  export default class URLParsing extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Note: deprecated, please use `sap.ui.model.odata.ODataUtils.setOrigin(sServiceUrl, { alias : sSystem
     * });` Makes the given server-relative SAP OData service URL point to the system given explicitly as parameter
     * `vComponentOrSystem`. If this parameter is not provided, it makes the server-relative URL point to the
     * system of the current application. ***Server-relative URL*** means a URL starting with exactly one "/"
     * (also known as absolute-path URL). The ***system of the current application*** is taken from the parameter
     * "sap-system" of the last navigation target resolution result.  If either a multiple-origin
     * parameter `;mo/` or an origin parameter with qualified system (`;o=sid(SYS.123)` or `o=SYSALIAS`) is
     * already present, the `sServiceUrl` is returned unchanged.  The framework invokes this function for
     * SAPUI5 applications that have been built using declarative model instantiation with the application descriptor
     * (data source) mechanism or using an sap.ca framework. For these applications, you do not need to invoke
     * this function explicitly in the application code. If the application does not use any of these mechanisms,
     * but explicitly constructs additional OData models or performs OData requests, the application code shall
     * invoke this function. It shall pass its root component instance as `vComponentOrSystem` - the function
     * will then determine the system from the navigation start-up parameter "sap-system" (`getComponentData().startupParameters["sap-system"][0])`.
     * Applications may call this API with parameter `vComponentOrSystem` and a non-empty string value if application-specific
     * logic is used to determine the target system for service calls.  With service URLs converted using
     * this API, administrators can redirect service calls to servers other than the default SAP Gateway and
     * back-end server either via reverse proxy (e.g. SAP Web Dispatcher) configuration or using the system
     * alias functionality of the SAP Gateway server.  The system is added to the last URL segment of the
     * service URL with the segment parameter `;o=`. You can also make this function put the system to a different
     * URL path segment of the service URL by specifying the empty segment parameter `;o=`, e.g. `/sap/opu/odata/MyService;o=/MyEntities/$count?p1=v1`.
     * If both `vComponentOrSystem` is empty and the current application has no system, no system is added and
     * the empty segment parameter `;o` is removed.
     *
     *
     * **Example 1:** `/sap/opu/odata/MyService/?p1=v1` is converted to `/sap/opu/odata/MyService;o=SYS/?p1=v1`
     * if the target system is "SYS". However it remains unchanged if both the current application's
     * system ***and*** the parameter `vComponentOrSystem` are empty.
     *
     *
     * **Example 2:** `/sap/opu/odata/MyService;o=/MyEntities/$count?p1=v1` is converted to `/sap/opu/odata/MyService;o=sid(SYS.123)/MyEntities/$count?p1=v1`
     * if parameter `vComponentOrSystem` is set to "sid(SYS.123)".  The URL is in no way
     * normalized.
     *
     * @since 1.19.1
     * @deprecated As of version 1.31. Please use {@link sap.ui.model.odata.ODataUtils#setOrigin} instead.
     *
     * @returns the service URL pointing to the system specified in parameter `vComponentOrSystem` or to the
     * system of the current application
     */
    addSystemToServiceUrl(
      /**
       * a server-relative URL without system alias information
       */
      sServiceUrl: string,
      /**
       * the root component of the FLP application ( `getComponentData().startupParameters["sap-system"][0]`
       * is used as system alias if present) or a string valued system specification like "SYS" or "sid(SYS.123)"
       * if undefined or falsy the system of the current application is used
       */
      vComponentOrSystem?: string | Component
    ): string;
    /**
     * compose a shell Hash from it's respective parts Note that it also may append an app specific route!
     *
     * @since 1.16.0
     *
     * @returns the hash part of an URL, e.g. `"Object-name~AFE2==?PV1=PV2&PV4=V5&/display/detail/7?UU=HH` Returns
     * an empty string in case no shell hash was provided.
     */
    constructShellHash(
      /**
       * The parts of a shell hash. Its action must be a valid action, It may not contain "?" or directly a parameter
       * string. Note: In general it is preferred to add an appStateKey directly to the params object.
       */
      oShellHash?: SimpleDecomposedHash | DecomposedHash
    ): TargetIntentStrict;
    /**
     * Extract a hash part from an URL, including an app-specific part
     *
     * @since 1.16.0
     *
     * @returns `extracted string` if and only if a hash is present, undefined otherwise
     */
    getHash(
      /**
       * any value
       */
      sURL: string
    ): string;
    /**
     * Extract the Shell hash# part from an URL The application specific route part is removed See {@link #getHash }
     * for a function which retains the app specific route.
     *
     * Shell services shall use this service to extract relevant parts of an URL from an actual URL string (which
     * should be treated as opaque)  The URL has to comply with the Fiori-Wave 2 agreed upon format  This
     * service shall be used to extract a hash part from an url. The result can be further broken up by parseShellHash
     *
     * Examples http://a.b.c?defhij#SemanticObject-Action~Context?PV1=A&PV2=B&/appspecific
     *  returns : "#SemanticObject-Action~Context?PV1=A&PV2=B&/appspecific"
     *
     * Note: the results when passing an illegal (non-compliant) url are undefined and subject to change w.o.
     * notice. Notably further checks may added. The design is deliberately restrictive and non-robust.
     *
     * @since 1.16.0
     *
     * @returns the parsed result
     */
    getShellHash(
      /**
       * a valid (Shell) url, e.g.
       *  `http://xx.b.c#Object-name~AFE2==?PV1=PV2&PV4=V5&/display/detail/7?UU=HH`
       */
      sShellHashString: URI
    ): TargetIntent;
    /**
     * Check if a URL has an intent based navigation part which can be parsed into a semantic object and action
     * part. Accepts only a relative URL (must contain #) or fully qualified Urls for which origin and filename
     * must correspond to the running launchpad.
     *
     * Given actual url `http://www.mycorp.com/sap/fiori/FioriLaunchpad.html?sap-language=DE#SO-action?P1=value1`,
     * the following parts `http://www.mycorp.com/sap/fiori/FioriLaunchpad.html` must match.
     *
     * The actual test is synchronous and *only* tests whether the hash part can be parsed and contains a semantic
     * object and action. It does not test whether the intent or its parameters are valid for a given user
     *
     * @since 1.30.0
     * @deprecated As of version 1.96. Please use {@link #isIntentUrlAsync} instead.
     *
     * @returns true if the conditions are fulfilled.
     */
    isIntentUrl(
      /**
       * the URL to test. Note: this url must be in internal format.
       */
      sUrl: string
    ): boolean;
    /**
     * Check if a URL has an intent based navigation part which can be parsed into a semantic object and action
     * part. Accepts only a relative URL (must contain #) or fully qualified Urls for which origin and filename
     * must correspond to the running launchpad.
     *
     * Given actual url `http://www.mycorp.com/sap/fiori/FioriLaunchpad.html?sap-language=DE#SO-action?P1=value1`,
     * the following parts `http://www.mycorp.com/sap/fiori/FioriLaunchpad.html` must match.
     *
     * This function *only* tests whether the hash part can be parsed and contains a semantic object and action.
     * It does not test whether the intent or its parameters are valid for a given user
     *
     * @since 1.96.0
     *
     * @returns true if the conditions are fulfilled.
     */
    isIntentUrlAsync(
      /**
       * the URL to test. Note: this url must be in internal format.
       */
      sUrl: string
    ): Promise<boolean>;
    /**
     * combine members of a javascript object into a parameter string, note that parameters are ordered in an
     * arbitrary manner which is subject to change
     *
     * @since 1.20.0
     *
     * @returns * @returns {sap.ui.core.URI} The parameter string, e.g. `ABC=1&ABC=1%202&DEF=4`. Note that the
     * result is *not* prefixed with a "?", parameter values are encodeURIComponent encoded.
     */
    paramsToString(
      /**
       * The parameters to combine into the parameter String, e.g. `{ ABC : [1,"1 2"], DEF : ["4"]}`
       */
      oParams: Record<string, URLValue[]>
    ): URI;
    /**
     * This method parses parameters from a URI query string (starting with ?) and puts the result into a parameter
     * object.
     *
     * @since 1.20.0
     *
     * @returns The parsed parameters, e.g. { ABC : ["1", "1 2"], DEF : ["4"]}.
     */
    parseParameters(
      /**
       * Parameter string, e.g. `?ABC=1&ABC=1%202&DEF=4`
       */
      sParams: URI
    ): Record<string, URLValue[]>;
    /**
     * Decompose a shell hash into the respective parts
     *
     * @since 1.16.0
     *
     * @returns `undefined` if not a parsable hash
     *  Note that params always has an Array for each parameter value!
     */
    parseShellHash(
      /**
       * Hash part of a shell compliant URL `#SO-Action~Context?P1=a&P2=x&/route?RPV=1` the hash part of an URL,
       *
       *  e.g. `"#Object-name~AFE2==?PV1=PV2&PV4=V5&/display/detail/7?UU=HH`
       */
      sHash: TargetIntent
    ): DecomposedHash;
    /**
     * split a Unified Shell compliant hash into an Object containing a shell specific part and an app specific
     * parts
     *  for non compliant hash strings, the empty object {} is returned. an optional leading # is stripped
     *
     * @since 1.16.0
     *
     * @returns `{}`(empty object) if not a parsable hash
     * ```javascript
     *
     *   {
     *     shellPart : "Object-name~AFE2==?PV1=PV2&PV4=V5",
     *     appSpecificRoute : "display/detail/7?UU=HH"
     *   }
     * ```
     *  otherwise Note that params always has an Array for each parameter value!
     */
    splitHash(
      /**
       * The hash part of a shell conformant URL. It has to have the following format: #SO-Action~Context?P1=a&P2=x&/route?RPV=1
       * Here is an example for the hash part of an URL: "#Object-name~AFE2==?PV1=PV2&PV4=V5&/display/detail/7?UU=HH
       */
      sHash: TargetIntent
    ): SplitHash;
  }
  /**
   * Type for DecomposedHash
   *
   * @since 1.120.0
   */
  export type DecomposedHash = {
    /**
     * the semantic object
     */
    semanticObject: string;
    /**
     * the action
     */
    action: string;
    /**
     * the raw context string
     */
    contextRaw: string;
    /**
     * the parameters
     */
    params: Record<string, string[]>;
    /**
     * the app state key
     */
    appStateKey?: string;
    /**
     * the app specific route
     */
    appSpecificRoute?: string;
  };

  /**
   * Simple Type for DecomposedHash with shell hash as part of the target property. Use this type for edge
   * cases only. Use {@link sap.ushell.services.URLParsing.DecomposedHash} instead.
   *
   * @since 1.124.0
   */
  export type SimpleDecomposedHash = {
    /**
     * The target object
     */
    target: {
      /**
       * The shell hash
       */
      shallHash: TargetIntent;
    };
  };

  /**
   * Type for SplitHash
   *
   * @since 1.120.0
   */
  export type SplitHash = {
    /**
     * the shell part of the hash
     */
    shellPart: URI;
    /**
     * the app specific route part of the hash
     */
    appSpecificRoute: URI;
  };

  /**
   * Type for Url value
   *
   * @since 1.120.0
   */
  export type URLValue = string | int;
}

declare module "sap/ushell/services/UsageAnalytics" {
  /**
   * A UShell service for tracking business flows and user actions.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const UsageAnalytics = await Container.getServiceAsync("UsageAnalytics");
   *     // do something with the UsageAnalytics service
   *   });
   * ```
   *
   *
   * The UsageAnalytics service exposes API for logging custom events and setting custom field values in the
   * logged events.
   *  The data is sent via http and recorded on a server, whose URL is defined by the `baseUrl` service configuration
   * property.
   *  The service configuration must also include the site ID from the `pubToken` attribute.
   *  You can find the pubToken in the code snippet provided in the WARP when creating a new site.
   *
   * Each tracked event is represented by a table entry on the server database.
   *  The administrator can produce reports based on the the recorded data.
   *
   * Two types of events can be logged:
   *  - Automatic events: Click or pageLoad are predefined events, logged by the base tracking library.
   *  You can disable these events in the service configuration.
   *  - Custom events: You can use the service API to log an event with custom data using the function logCustomEvent
   *
   *
   * Each tracked event (either automatic or custom) is represented by a database row, that includes 10 custom
   * attributes named custom1...custom10.
   *  Some of these values can be set using UsageAnalytics service API.
   *
   *
   * @since 1.32.0
   * @deprecated As of version 1.120. The corresponding cloud service "SAP Web Analytics" has been retired,
   * therefore this client-side service API cannot be used any longer.
   */
  export default class UsageAnalytics extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Sets up to 6 customer attributes of logged events according to the given object attributes.
     *  A customer attribute can be set only once during a session.
     *  Currently these attributes correspond to database columns custom5...custom10.
     *
     * @since 1.32.0
     * @deprecated As of version 1.120.
     */
    setCustomAttributes(
      /**
       * An json object that includes attribute1...attribute6 (or subset)
       *  with values of type string/number/boolean or a function that returns any of these types.
       *  For example:
       *  {
       *  attribute1: "value3",
       *  attribute2: function () {return "value4"},
       *  attribute3: 55
       *  }
       *  in this example the custom field "custom5" gets the string "value3"
       *  the custom field custom6 gets the function that returns the string "value4",
       *  the custom field custom7 gets a string "55".
       *  Any property of oCustomFieldValues which is not in the range of attribute1...attribute6 is ignored.
       */
      oCustomFieldValues: object
    ): void;
    /**
     * Enables the renderer to set the content of the legal message..
     *
     * @since 1.32.0
     * @deprecated As of version 1.120.
     */
    setLegalText(): void;
    /**
     * Indicates whether the service is available.
     *
     *
     *
     * Since the service is deprecated and no longer supported, this method always returns `false`.
     *
     * @since 1.32.0
     * @deprecated As of version 1.120.
     *
     * @returns A boolean value indicating whether the UsageAnalytics service is enabled
     */
    systemEnabled(): boolean;
    /**
     * Indicates whether the user has specified to track activities.
     *
     *
     *
     * Since the service is deprecated and no longer supported, this method always returns `false`.
     *
     * @since 1.32.0
     * @deprecated As of version 1.120.
     *
     * @returns A boolean value indicating whether the user has specified to track activities
     */
    userEnabled(): boolean;
  }
}

declare module "sap/ushell/services/UserInfo" {
  /**
   * The Unified Shell's user information service. Allows retrieving information about the logged-in user.
   *
   * **Note:** To retrieve a valid instance of this service, it is necessary to call {@link sap.ushell.Container#getServiceAsync}.
   *
   * ```javascript
   *
   *   sap.ui.require(["sap/ushell/Container"], async function (Container) {
   *     const UserInfo = await Container.getServiceAsync("UserInfo");
   *     // do something with the UserInfo service
   *   });
   * ```
   *
   *
   * @since 1.16.3
   */
  export default class UserInfo extends sap.ushell.services.Service {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Returns the email address of the user.
     *
     * @since 1.86.0
     *
     * @returns The user's email address.
     */
    getEmail(): string;
    /**
     * Returns the first name of the user.
     *
     * @since 1.86.0
     *
     * @returns The user's first name.
     */
    getFirstName(): string;
    /**
     * Returns the full name of the user.
     *
     * @since 1.86.0
     *
     * @returns The user's full name.
     */
    getFullName(): string;
    /**
     * Returns the id of the user.
     *
     * @since 1.16.3
     *
     * @returns The user id.
     */
    getId(): string;
    /**
     * Returns the last name of the user.
     *
     * @since 1.86.0
     *
     * @returns The user's last name.
     */
    getLastName(): string;
    /**
     * Returns an object representing data about the user.
     *
     * @since 1.71.0
     *
     * @returns Object providing information about the logged-in user.
     */
    getShellUserInfo(): Promise<ShellUserInfo>;
  }
  /**
   * Type for an object representing data about the user: ID, first name, last name, full name, e-mail address.
   *
   * @since 1.120.0
   */
  export type ShellUserInfo = {
    /**
     * The user id.
     */
    id: string;
    /**
     * The user's email address.
     */
    email: string;
    /**
     * The user's first name.
     */
    firstName: string;
    /**
     * The user's last name.
     */
    lastName: string;
    /**
     * The user's full name.
     */
    fullName: string;
  };
}

declare module "sap/ushell/System" {
  /**
   * A representation of a system Constructs a new system object representing a system used in the Unified
   * Shell.
   *
   * @since 1.15.0
   */
  export default class System {
    constructor(
      /**
       * An object containing the system data
       */
      oData: {
        /**
         * The unique system alias such as `'ENTERPRISE_SEARCH'`.
         */
        alias: string;
        /**
         * The server relative base URL of this system such as `'/ENTERPRISE_SEARCH'`. **Note:** This has to correspond
         * to an SAP Web Dispatcher routing rule.
         */
        baseUrl: string;
        /**
         * The system platform such as `'abap'` or `'hana'`.
         */
        platform: string;
      }
    );
  }
}

declare module "sap/ushell/ui/appfinder/AppBox" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  /**
   * Constructor for a new ui/appfinder/AppBox.
   *
   * @deprecated As of version 1.120.
   */
  export default class AppBox extends Control {
    constructor(
      /**
       * initial settings for the new control
       *
       * Add your documentation for the new ui/appfinder/AppBox
       */
      mSettings?: $AppBoxSettings
    );

    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       *
       * Add your documentation for the new ui/appfinder/AppBox
       */
      mSettings?: $AppBoxSettings
    );
  }
  /**
   * Describes the settings that can be provided to the AppBox constructor.
   *
   * @deprecated As of version 1.120.
   */
  export interface $AppBoxSettings extends $ControlSettings {}
}

declare module "sap/ushell/ui/footerbar/AddBookmarkButton" {
  import { default as Button, $ButtonSettings } from "sap/m/Button";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Enables users to save bookmark tiles in the Fiori launchpad. Clicking the button opens a dialog box for
   * saving the app state, so that the app can be launched directly in that state from the launchpad.
   *
   * @deprecated As of version 1.136.
   */
  export default class AddBookmarkButton extends Button {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AddBookmarkButtonSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AddBookmarkButtonSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.footerbar.AddBookmarkButton with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Button.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AddBookmarkButton>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.footerbar.AddBookmarkButton.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAfterPressHandler afterPressHandler}.
     *
     * A callback function that is called after the save-as-tile dialog is closed.
     *
     *
     * @returns Value of property `afterPressHandler`
     */
    getAfterPressHandler(): Function;
    /**
     * Gets current value of property {@link #getAppData appData}.
     *
     * An object containing properties with information about the app, e.g. serviceUrl, numberUnit, ... .
     *
     * @deprecated As of version 1.31. Use dedicated properties like afterPressHandler, beforePresshandler,
     * customUrl, ... of the AddBookmarkButton instead.
     *
     * @returns Value of property `appData`
     */
    getAppData(): object;
    /**
     * Gets current value of property {@link #getBeforePressHandler beforePressHandler}.
     *
     * A callback function that is called before the save-as-tile dialog is opened.
     *
     *
     * @returns Value of property `beforePressHandler`
     */
    getBeforePressHandler(): Function;
    /**
     * Gets current value of property {@link #getCustomUrl customUrl}.
     *
     * The target intent or URL of the bookmark. If the target app runs in the current shell, the URL has to
     * be a valid intent, i.e. in the format `"#SO-Action?P1=a&P2=x&/route?RPV=1"`. See also {@link sap.ushell.services.URLParsing#getHash}.
     *
     *
     * @returns Value of property `customUrl`
     */
    getCustomUrl(): any;
    /**
     * Gets current value of property {@link #getDataSource dataSource}.
     *
     * Data source of the OData service. See same parameter of {@link sap.ushell.services.Bookmark#addBookmark }
     * for details
     *
     *
     * @returns Value of property `dataSource`
     */
    getDataSource(): any;
    /**
     * Gets current value of property {@link #getInfo info}.
     *
     * Text to be displayed at the bottom of the tile.
     *
     *
     * @returns Value of property `info`
     */
    getInfo(): string;
    /**
     * Gets current value of property {@link #getKeywords keywords}.
     *
     * The keywords based on which the future tile should be indexed and filtered.
     *
     *
     * @returns Value of property `keywords`
     */
    getKeywords(): string;
    /**
     * Gets current value of property {@link #getNumberUnit numberUnit}.
     *
     * For dynamic tile, the unit to be displayed below the number, for example, USD.
     *
     *
     * @returns Value of property `numberUnit`
     */
    getNumberUnit(): string;
    /**
     * Gets current value of property {@link #getServiceRefreshInterval serviceRefreshInterval}.
     *
     * Number of seconds after which dynamic content is read from the data source and the display is refreshed.
     *
     *
     * @returns Value of property `serviceRefreshInterval`
     */
    getServiceRefreshInterval(): string;
    /**
     * Gets current value of property {@link #getServiceUrl serviceUrl}.
     *
     * URL of an OData service from which data for a dynamic tile should be read.
     *
     *
     * @returns Value of property `serviceUrl`
     */
    getServiceUrl(): any;
    /**
     * Gets current value of property {@link #getShowGroupSelection showGroupSelection}.
     *
     * Whether to display the control for group selection in the save-as-tile dialog in launchpad homepage mode.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showGroupSelection`
     */
    getShowGroupSelection(): boolean;
    /**
     * Gets current value of property {@link #getShowPageSelection showPageSelection}.
     *
     * Whether to display the control for page selection in the save-bookmark dialog in launchpad spaces mode.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showPageSelection`
     */
    getShowPageSelection(): boolean;
    /**
     * Gets current value of property {@link #getSubtitle subtitle}.
     *
     * Subtitle to be displayed below the tile title.
     *
     *
     * @returns Value of property `subtitle`
     */
    getSubtitle(): string;
    /**
     * Gets current value of property {@link #getTileIcon tileIcon}.
     *
     * Icon to be displayed in the Tile.
     *
     *
     * @returns Value of property `tileIcon`
     */
    getTileIcon(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title to be displayed on the tile.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets a new value for property {@link #getAfterPressHandler afterPressHandler}.
     *
     * A callback function that is called after the save-as-tile dialog is closed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAfterPressHandler(
      /**
       * New value for property `afterPressHandler`
       */
      fnAfterPressHandler?: Function
    ): this;
    /**
     * Sets a new value for property {@link #getAppData appData}.
     *
     * An object containing properties with information about the app, e.g. serviceUrl, numberUnit, ... .
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.31. Use dedicated properties like afterPressHandler, beforePresshandler,
     * customUrl, ... of the AddBookmarkButton instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAppData(
      /**
       * New value for property `appData`
       */
      oAppData?: object
    ): this;
    /**
     * Sets a new value for property {@link #getBeforePressHandler beforePressHandler}.
     *
     * A callback function that is called before the save-as-tile dialog is opened.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBeforePressHandler(
      /**
       * New value for property `beforePressHandler`
       */
      fnBeforePressHandler?: Function
    ): this;
    /**
     * Sets a new value for property {@link #getCustomUrl customUrl}.
     *
     * The target intent or URL of the bookmark. If the target app runs in the current shell, the URL has to
     * be a valid intent, i.e. in the format `"#SO-Action?P1=a&P2=x&/route?RPV=1"`. See also {@link sap.ushell.services.URLParsing#getHash}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomUrl(
      /**
       * New value for property `customUrl`
       */
      oCustomUrl?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDataSource dataSource}.
     *
     * Data source of the OData service. See same parameter of {@link sap.ushell.services.Bookmark#addBookmark }
     * for details
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataSource(
      /**
       * New value for property `dataSource`
       */
      oDataSource?: any
    ): this;
    /**
     * Sets a new value for property {@link #getInfo info}.
     *
     * Text to be displayed at the bottom of the tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInfo(
      /**
       * New value for property `info`
       */
      sInfo?: string
    ): this;
    /**
     * Sets a new value for property {@link #getKeywords keywords}.
     *
     * The keywords based on which the future tile should be indexed and filtered.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKeywords(
      /**
       * New value for property `keywords`
       */
      sKeywords?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNumberUnit numberUnit}.
     *
     * For dynamic tile, the unit to be displayed below the number, for example, USD.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNumberUnit(
      /**
       * New value for property `numberUnit`
       */
      sNumberUnit?: string
    ): this;
    /**
     * Sets a new value for property {@link #getServiceRefreshInterval serviceRefreshInterval}.
     *
     * Number of seconds after which dynamic content is read from the data source and the display is refreshed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setServiceRefreshInterval(
      /**
       * New value for property `serviceRefreshInterval`
       */
      sServiceRefreshInterval?: string
    ): this;
    /**
     * Sets a new value for property {@link #getServiceUrl serviceUrl}.
     *
     * URL of an OData service from which data for a dynamic tile should be read.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setServiceUrl(
      /**
       * New value for property `serviceUrl`
       */
      oServiceUrl?: any
    ): this;
    /**
     * Sets a new value for property {@link #getShowGroupSelection showGroupSelection}.
     *
     * Whether to display the control for group selection in the save-as-tile dialog in launchpad homepage mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowGroupSelection(
      /**
       * New value for property `showGroupSelection`
       */
      bShowGroupSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPageSelection showPageSelection}.
     *
     * Whether to display the control for page selection in the save-bookmark dialog in launchpad spaces mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPageSelection(
      /**
       * New value for property `showPageSelection`
       */
      bShowPageSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSubtitle subtitle}.
     *
     * Subtitle to be displayed below the tile title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSubtitle(
      /**
       * New value for property `subtitle`
       */
      sSubtitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTileIcon tileIcon}.
     *
     * Icon to be displayed in the Tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileIcon(
      /**
       * New value for property `tileIcon`
       */
      sTileIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title to be displayed on the tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AddBookmarkButton constructor.
   *
   * @deprecated As of version 1.136.
   */
  export interface $AddBookmarkButtonSettings extends $ButtonSettings {
    /**
     * A callback function that is called before the save-as-tile dialog is opened.
     */
    beforePressHandler?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback function that is called after the save-as-tile dialog is closed.
     */
    afterPressHandler?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Title to be displayed on the tile.
     */
    title?: string | PropertyBindingInfo;

    /**
     * Subtitle to be displayed below the tile title.
     */
    subtitle?: string | PropertyBindingInfo;

    /**
     * Text to be displayed at the bottom of the tile.
     */
    info?: string | PropertyBindingInfo;

    /**
     * Icon to be displayed in the Tile.
     */
    tileIcon?: string | PropertyBindingInfo;

    /**
     * For dynamic tile, the unit to be displayed below the number, for example, USD.
     */
    numberUnit?: string | PropertyBindingInfo;

    /**
     * The keywords based on which the future tile should be indexed and filtered.
     */
    keywords?: string | PropertyBindingInfo;

    /**
     * The target intent or URL of the bookmark. If the target app runs in the current shell, the URL has to
     * be a valid intent, i.e. in the format `"#SO-Action?P1=a&P2=x&/route?RPV=1"`. See also {@link sap.ushell.services.URLParsing#getHash}.
     */
    customUrl?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * URL of an OData service from which data for a dynamic tile should be read.
     */
    serviceUrl?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Data source of the OData service. See same parameter of {@link sap.ushell.services.Bookmark#addBookmark }
     * for details
     */
    dataSource?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of seconds after which dynamic content is read from the data source and the display is refreshed.
     */
    serviceRefreshInterval?: string | PropertyBindingInfo;

    /**
     * Whether to display the control for group selection in the save-as-tile dialog in launchpad homepage mode.
     */
    showGroupSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether to display the control for page selection in the save-bookmark dialog in launchpad spaces mode.
     */
    showPageSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * An object containing properties with information about the app, e.g. serviceUrl, numberUnit, ... .
     *
     * @deprecated As of version 1.31. Use dedicated properties like afterPressHandler, beforePresshandler,
     * customUrl, ... of the AddBookmarkButton instead.
     */
    appData?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ushell/ui/launchpad/ActionItem" {
  import {
    default as Button,
    $ButtonSettings,
    Button$PressEventParameters,
  } from "sap/m/Button";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Constructor for a new ui/launchpad/ActionItem.
   */
  export default class ActionItem extends Button {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionItemSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionItemSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.launchpad.ActionItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Button.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ActionItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.launchpad.ActionItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.ActionItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.ActionItem` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterRendering(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.ActionItem`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.ActionItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.ActionItem` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterRendering(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.ActionItem`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.launchpad.ActionItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.ActionItem` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.ActionItem`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.launchpad.ActionItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.ActionItem` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.ActionItem`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.ActionItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterRendering(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.ushell.ui.launchpad.ActionItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterRendering afterRendering} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterRendering(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getActionType actionType}.
     *
     * Default value is `"standard"`.
     *
     *
     * @returns Value of property `actionType`
     */
    getActionType(): string;
    /**
     * Sets a new value for property {@link #getActionType actionType}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"standard"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActionType(
      /**
       * New value for property `actionType`
       */
      sActionType?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ActionItem constructor.
   */
  export interface $ActionItemSettings extends $ButtonSettings {
    actionType?: string | PropertyBindingInfo;

    press?: (oEvent: Event) => void;

    afterRendering?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ActionItem#afterRendering event.
   */
  export interface ActionItem$AfterRenderingEventParameters {}

  /**
   * Event object of the ActionItem#afterRendering event.
   */
  export type ActionItem$AfterRenderingEvent = Event<
    ActionItem$AfterRenderingEventParameters,
    ActionItem
  >;

  /**
   * Parameters of the ActionItem#press event.
   */
  export interface ActionItem$PressEventParameters
    extends Button$PressEventParameters {}

  /**
   * Event object of the ActionItem#press event.
   */
  export type ActionItem$PressEvent = Event<
    ActionItem$PressEventParameters,
    ActionItem
  >;
}

declare module "sap/ushell/ui/launchpad/DashboardGroupsContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Constructor for "sap.ushell.ui.launchpad.DashboardGroupsContainer".
   *
   * @deprecated As of version 1.120.
   */
  export default class DashboardGroupsContainer extends Control {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control.
       */
      mSettings?: $DashboardGroupsContainerSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no id is given.
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: $DashboardGroupsContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.launchpad.DashboardGroupsContainer with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DashboardGroupsContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.launchpad.DashboardGroupsContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some group to the aggregation {@link #getGroups groups}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addGroup(
      /**
       * The group to add; if empty, nothing is inserted
       */
      oGroup: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.DashboardGroupsContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.DashboardGroupsContainer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterRendering(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.DashboardGroupsContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.DashboardGroupsContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.DashboardGroupsContainer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterRendering(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.DashboardGroupsContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the groups in the aggregation {@link #getGroups groups}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGroups(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.DashboardGroupsContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterRendering(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterRendering afterRendering} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterRendering(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibilityLabel accessibilityLabel}.
     *
     * A value for an optional accessibility label.
     *
     *
     * @returns Value of property `accessibilityLabel`
     */
    getAccessibilityLabel(): string;
    /**
     * Gets current value of property {@link #getDisplayMode displayMode}.
     *
     *
     * @returns Value of property `displayMode`
     */
    getDisplayMode(): string;
    /**
     * Gets content of aggregation {@link #getGroups groups}.
     */
    getGroups(): Control[];
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getGroups groups}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfGroup(
      /**
       * The group whose index is looked for
       */
      oGroup: Control
    ): int;
    /**
     * Inserts a group into the aggregation {@link #getGroups groups}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertGroup(
      /**
       * The group to insert; if empty, nothing is inserted
       */
      oGroup: Control,
      /**
       * The `0`-based index the group should be inserted at; for a negative value of `iIndex`, the group is inserted
       * at position 0; for a value greater than the current size of the aggregation, the group is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getGroups groups}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllGroups(): Control[];
    /**
     * Removes a group from the aggregation {@link #getGroups groups}.
     *
     *
     * @returns The removed group or `null`
     */
    removeGroup(
      /**
       * The group to remove or its index or id
       */
      vGroup: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccessibilityLabel accessibilityLabel}.
     *
     * A value for an optional accessibility label.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibilityLabel(
      /**
       * New value for property `accessibilityLabel`
       */
      sAccessibilityLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayMode displayMode}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayMode(
      /**
       * New value for property `displayMode`
       */
      sDisplayMode?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DashboardGroupsContainer constructor.
   *
   * @deprecated As of version 1.120.
   */
  export interface $DashboardGroupsContainerSettings extends $ControlSettings {
    /**
     * A value for an optional accessibility label.
     */
    accessibilityLabel?: string | PropertyBindingInfo;

    displayMode?: string | PropertyBindingInfo;

    groups?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    afterRendering?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DashboardGroupsContainer#afterRendering event.
   */
  export interface DashboardGroupsContainer$AfterRenderingEventParameters {}

  /**
   * Event object of the DashboardGroupsContainer#afterRendering event.
   */
  export type DashboardGroupsContainer$AfterRenderingEvent = Event<
    DashboardGroupsContainer$AfterRenderingEventParameters,
    DashboardGroupsContainer
  >;
}

declare module "sap/ushell/ui/launchpad/LinkTileWrapper" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Constructor for a new ui/launchpad/LinkTileWrapper. A link tile to be displayed in the tile container.
   * This control acts as container for specialized tile implementations.
   *
   * @deprecated As of version 1.120.
   */
  export default class LinkTileWrapper extends Control {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LinkTileWrapperSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LinkTileWrapperSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.launchpad.LinkTileWrapper with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LinkTileWrapper>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.launchpad.LinkTileWrapper.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some footItem to the aggregation {@link #getFootItems footItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFootItem(
      /**
       * The footItem to add; if empty, nothing is inserted
       */
      oFootItem: Control
    ): this;
    /**
     * Adds some tileView to the aggregation {@link #getTileViews tileViews}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addTileView(
      /**
       * The tileView to add; if empty, nothing is inserted
       */
      oTileView: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterRendering(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterRendering(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:coverDivPress coverDivPress} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCoverDivPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:coverDivPress coverDivPress} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCoverDivPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showActions showActions} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowActions(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showActions showActions} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.LinkTileWrapper` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowActions(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.LinkTileWrapper`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the footItems in the aggregation {@link #getFootItems footItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFootItems(): this;
    /**
     * Destroys all the tileViews in the aggregation {@link #getTileViews tileViews}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTileViews(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterRendering afterRendering} event of this
     * `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterRendering(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:coverDivPress coverDivPress} event of this
     * `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCoverDivPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showActions showActions} event of this `sap.ushell.ui.launchpad.LinkTileWrapper`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowActions(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterRendering afterRendering} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterRendering(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:coverDivPress coverDivPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCoverDivPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showActions showActions} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowActions(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAnimationRendered animationRendered}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `animationRendered`
     */
    getAnimationRendered(): boolean;
    /**
     * Gets current value of property {@link #getDebugInfo debugInfo}.
     *
     *
     * @returns Value of property `debugInfo`
     */
    getDebugInfo(): string;
    /**
     * Gets content of aggregation {@link #getFootItems footItems}.
     */
    getFootItems(): Control[];
    /**
     * Gets current value of property {@link #getIeHtml5DnD ieHtml5DnD}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `ieHtml5DnD`
     */
    getIeHtml5DnD(): boolean;
    /**
     * Gets current value of property {@link #getIsLocked isLocked}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `isLocked`
     */
    getIsLocked(): boolean;
    /**
     * Gets current value of property {@link #getTarget target}.
     *
     *
     * @returns Value of property `target`
     */
    getTarget(): string;
    /**
     * Gets current value of property {@link #getTileActionModeActive tileActionModeActive}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `tileActionModeActive`
     */
    getTileActionModeActive(): boolean;
    /**
     * Gets current value of property {@link #getTileCatalogId tileCatalogId}.
     *
     *
     * @returns Value of property `tileCatalogId`
     */
    getTileCatalogId(): string;
    /**
     * Gets current value of property {@link #getTileCatalogIdStable tileCatalogIdStable}.
     *
     *
     * @returns Value of property `tileCatalogIdStable`
     */
    getTileCatalogIdStable(): string;
    /**
     * Gets content of aggregation {@link #getTileViews tileViews}.
     */
    getTileViews(): Control[];
    /**
     * Gets current value of property {@link #getUuid uuid}.
     *
     *
     * @returns Value of property `uuid`
     */
    getUuid(): string;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getFootItems footItems}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFootItem(
      /**
       * The footItem whose index is looked for
       */
      oFootItem: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getTileViews tileViews}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfTileView(
      /**
       * The tileView whose index is looked for
       */
      oTileView: Control
    ): int;
    /**
     * Inserts a footItem into the aggregation {@link #getFootItems footItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertFootItem(
      /**
       * The footItem to insert; if empty, nothing is inserted
       */
      oFootItem: Control,
      /**
       * The `0`-based index the footItem should be inserted at; for a negative value of `iIndex`, the footItem
       * is inserted at position 0; for a value greater than the current size of the aggregation, the footItem
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a tileView into the aggregation {@link #getTileViews tileViews}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertTileView(
      /**
       * The tileView to insert; if empty, nothing is inserted
       */
      oTileView: Control,
      /**
       * The `0`-based index the tileView should be inserted at; for a negative value of `iIndex`, the tileView
       * is inserted at position 0; for a value greater than the current size of the aggregation, the tileView
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getFootItems footItems}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllFootItems(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getTileViews tileViews}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllTileViews(): Control[];
    /**
     * Removes a footItem from the aggregation {@link #getFootItems footItems}.
     *
     *
     * @returns The removed footItem or `null`
     */
    removeFootItem(
      /**
       * The footItem to remove or its index or id
       */
      vFootItem: int | string | Control
    ): Control | null;
    /**
     * Removes a tileView from the aggregation {@link #getTileViews tileViews}.
     *
     *
     * @returns The removed tileView or `null`
     */
    removeTileView(
      /**
       * The tileView to remove or its index or id
       */
      vTileView: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAnimationRendered animationRendered}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnimationRendered(
      /**
       * New value for property `animationRendered`
       */
      bAnimationRendered?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDebugInfo debugInfo}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDebugInfo(
      /**
       * New value for property `debugInfo`
       */
      sDebugInfo?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIeHtml5DnD ieHtml5DnD}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIeHtml5DnD(
      /**
       * New value for property `ieHtml5DnD`
       */
      bIeHtml5DnD?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsLocked isLocked}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsLocked(
      /**
       * New value for property `isLocked`
       */
      bIsLocked?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTarget target}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * New value for property `target`
       */
      sTarget?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTileActionModeActive tileActionModeActive}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileActionModeActive(
      /**
       * New value for property `tileActionModeActive`
       */
      bTileActionModeActive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTileCatalogId tileCatalogId}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileCatalogId(
      /**
       * New value for property `tileCatalogId`
       */
      sTileCatalogId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTileCatalogIdStable tileCatalogIdStable}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileCatalogIdStable(
      /**
       * New value for property `tileCatalogIdStable`
       */
      sTileCatalogIdStable?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUuid uuid}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUuid(
      /**
       * New value for property `uuid`
       */
      sUuid?: string
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LinkTileWrapper constructor.
   *
   * @deprecated As of version 1.120.
   */
  export interface $LinkTileWrapperSettings extends $ControlSettings {
    uuid?: string | PropertyBindingInfo;

    tileCatalogId?: string | PropertyBindingInfo;

    tileCatalogIdStable?: string | PropertyBindingInfo;

    target?: string | PropertyBindingInfo;

    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    debugInfo?: string | PropertyBindingInfo;

    animationRendered?: boolean | PropertyBindingInfo | `{${string}}`;

    isLocked?: boolean | PropertyBindingInfo | `{${string}}`;

    tileActionModeActive?: boolean | PropertyBindingInfo | `{${string}}`;

    ieHtml5DnD?: boolean | PropertyBindingInfo | `{${string}}`;

    tileViews?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    footItems?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    press?: (oEvent: Event) => void;

    coverDivPress?: (oEvent: Event) => void;

    afterRendering?: (oEvent: Event) => void;

    showActions?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the LinkTileWrapper#afterRendering event.
   */
  export interface LinkTileWrapper$AfterRenderingEventParameters {}

  /**
   * Event object of the LinkTileWrapper#afterRendering event.
   */
  export type LinkTileWrapper$AfterRenderingEvent = Event<
    LinkTileWrapper$AfterRenderingEventParameters,
    LinkTileWrapper
  >;

  /**
   * Parameters of the LinkTileWrapper#coverDivPress event.
   */
  export interface LinkTileWrapper$CoverDivPressEventParameters {}

  /**
   * Event object of the LinkTileWrapper#coverDivPress event.
   */
  export type LinkTileWrapper$CoverDivPressEvent = Event<
    LinkTileWrapper$CoverDivPressEventParameters,
    LinkTileWrapper
  >;

  /**
   * Parameters of the LinkTileWrapper#press event.
   */
  export interface LinkTileWrapper$PressEventParameters {}

  /**
   * Event object of the LinkTileWrapper#press event.
   */
  export type LinkTileWrapper$PressEvent = Event<
    LinkTileWrapper$PressEventParameters,
    LinkTileWrapper
  >;

  /**
   * Parameters of the LinkTileWrapper#showActions event.
   */
  export interface LinkTileWrapper$ShowActionsEventParameters {}

  /**
   * Event object of the LinkTileWrapper#showActions event.
   */
  export type LinkTileWrapper$ShowActionsEvent = Event<
    LinkTileWrapper$ShowActionsEventParameters,
    LinkTileWrapper
  >;
}

declare module "sap/ushell/ui/launchpad/TileState" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Constructor for a new ui/launchpad/TileState. The tile state control that displays loading indicator,
   * while tile view is loading and failed status in case tile view is not available.
   *
   * @deprecated As of version 1.120.
   */
  export default class TileState extends Control {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $TileStateSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $TileStateSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.launchpad.TileState with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TileState>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.launchpad.TileState.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.launchpad.TileState`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.TileState` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.TileState` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.launchpad.TileState`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.launchpad.TileState` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.launchpad.TileState` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.ushell.ui.launchpad.TileState`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getState state}.
     *
     * Default value is `"Loaded"`.
     *
     *
     * @returns Value of property `state`
     */
    getState(): string;
    /**
     * Sets a new value for property {@link #getState state}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Loaded"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setState(
      /**
       * New value for property `state`
       */
      sState?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TileState constructor.
   *
   * @deprecated As of version 1.120.
   */
  export interface $TileStateSettings extends $ControlSettings {
    state?: string | PropertyBindingInfo;

    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the TileState#press event.
   */
  export interface TileState$PressEventParameters {}

  /**
   * Event object of the TileState#press event.
   */
  export type TileState$PressEvent = Event<
    TileState$PressEventParameters,
    TileState
  >;
}

declare module "sap/ushell/ui/shell/ShellHeadItem" {
  import { URI, aria } from "sap/ui/core/library";

  export type Properties = {
    /**
     * The icon of the item, either defined in the sap.ui.core.IconPool or an URI to a custom image.
     */
    icon: URI;
    /**
     * The text of the item. It is either visible as tooltip or as label when the item is rendered as part of
     * an overflow button in a popover.
     */
    text?: string;
    /**
     * Target URI of the item.
     */
    target?: URI;
    /**
     * The aria-label attribute of the item.
     */
    ariaLabel?: string;
    /**
     * Specifies whether the aria-hidden attribute is set to true.
     */
    ariaHidden?: boolean;
    /**
     * Specifies the value of the aria-haspopup attribute
     */
    ariaHaspopup?: aria.HasPopup | keyof typeof aria.HasPopup;
    /**
     * The press handler function.
     */
    press?: Function;
  };
}

declare module "sap/ushell/ui/shell/ToolAreaItem" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A control to be placed in the tool area
   *
   * @since 1.30.5
   */
  export default class ToolAreaItem extends Control {
    /**
     * Constructor for a new ToolAreaItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ToolAreaItemSettings
    );
    /**
     * Constructor for a new ToolAreaItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ToolAreaItemSettings
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.shell.ToolAreaItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ToolAreaItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.shell.ToolAreaItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.ushell.ui.shell.ToolAreaItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.shell.ToolAreaItem` itself.
     *
     * Event is fired when the user presses the Expand icon.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.shell.ToolAreaItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.ushell.ui.shell.ToolAreaItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.shell.ToolAreaItem` itself.
     *
     * Event is fired when the user presses the Expand icon.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.shell.ToolAreaItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.shell.ToolAreaItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.shell.ToolAreaItem` itself.
     *
     * Event is fired when the user presses the item.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.shell.ToolAreaItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ushell.ui.shell.ToolAreaItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ushell.ui.shell.ToolAreaItem` itself.
     *
     * Event is fired when the user presses the item.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ushell.ui.shell.ToolAreaItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:expand expand} event of this `sap.ushell.ui.shell.ToolAreaItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachExpand(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.ushell.ui.shell.ToolAreaItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:expand expand} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireExpand(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAriaLabel ariaLabel}.
     *
     * Text which will be read by screenreader.
     *
     * @since 1.30
     *
     * @returns Value of property `ariaLabel`
     */
    getAriaLabel(): string;
    /**
     * Gets current value of property {@link #getExpandable expandable}.
     *
     * Defines whether the control will have an expand functionality containing sub-items or actions. If the
     * property is set to true, a small "expand" icon appears in the lower corner of the control. The "expand"
     * event is fired when the "expand" icon is pressed.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `expandable`
     */
    getExpandable(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon that is displayed in the item.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Defines whether to mark the control as selected
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Defines whether to display the control
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Sets a new value for property {@link #getAriaLabel ariaLabel}.
     *
     * Text which will be read by screenreader.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.30
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAriaLabel(
      /**
       * New value for property `ariaLabel`
       */
      sAriaLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getExpandable expandable}.
     *
     * Defines whether the control will have an expand functionality containing sub-items or actions. If the
     * property is set to true, a small "expand" icon appears in the lower corner of the control. The "expand"
     * event is fired when the "expand" icon is pressed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandable(
      /**
       * New value for property `expandable`
       */
      bExpandable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon that is displayed in the item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Defines whether to mark the control as selected
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Defines whether to display the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ToolAreaItem constructor.
   */
  export interface $ToolAreaItemSettings extends $ControlSettings {
    /**
     * Icon that is displayed in the item.
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether to mark the control as selected
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    text?: string | PropertyBindingInfo;

    /**
     * Text which will be read by screenreader.
     *
     * @since 1.30
     */
    ariaLabel?: string | PropertyBindingInfo;

    /**
     * Defines whether to display the control
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control will have an expand functionality containing sub-items or actions. If the
     * property is set to true, a small "expand" icon appears in the lower corner of the control. The "expand"
     * event is fired when the "expand" icon is pressed.
     */
    expandable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Event is fired when the user presses the item.
     */
    press?: (oEvent: Event) => void;

    /**
     * Event is fired when the user presses the Expand icon.
     */
    expand?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ToolAreaItem#expand event.
   */
  export interface ToolAreaItem$ExpandEventParameters {}

  /**
   * Event object of the ToolAreaItem#expand event.
   */
  export type ToolAreaItem$ExpandEvent = Event<
    ToolAreaItem$ExpandEventParameters,
    ToolAreaItem
  >;

  /**
   * Parameters of the ToolAreaItem#press event.
   */
  export interface ToolAreaItem$PressEventParameters {}

  /**
   * Event object of the ToolAreaItem#press event.
   */
  export type ToolAreaItem$PressEvent = Event<
    ToolAreaItem$PressEventParameters,
    ToolAreaItem
  >;
}

declare module "sap/ushell/ui/tile/StaticTile" {
  import Metadata from "sap/ui/base/Metadata";

  /**
   * Constructor for a new ui/tile/StaticTile. An applauncher tile for simple, static apps, displaying title,
   * subtitle, an icon and additional information
   *
   * @since 1.15.0
   * @deprecated As of version 1.120.
   */
  export default class StaticTile
    extends /* was: sap.ushell.ui.tile.TileBase */ Object
  {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ushell.ui.tile.TileBase#constructor sap.ushell.ui.tile.TileBase }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: object
    );

    /**
     * Creates a new subclass of class sap.ushell.ui.tile.StaticTile with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ushell.ui.tile.TileBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StaticTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui.tile.StaticTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/ushell/ui5service/ShellUIService" {
  import Metadata from "sap/ui/base/Metadata";

  /**
   * The ShellUIService for the unified shell can be used to modify the app title or the app hierarchy.
   *
   * Usage:
   *
   * Allows apps to interact with the SAP Fiori launchpad UI. A defined service is injected in the app components
   * by the FLP before the corresponding apps start. To consume the service, app components should declare
   * it in their "manifest.json" as follows:
   *
   *
   * ```javascript
   *
   * {
   *    ...
   *    "sap.ui5": {
   *       "services" : {
   *          "ShellUIService": {
   *              "factoryName": "sap.ushell.ui5service.ShellUIService"
   *          }
   *       }
   *    }
   *    ...
   * }
   * ```
   *
   *
   * The service can then be retrieved and consumed by the app component as in the following example:
   *
   *
   * ```javascript
   *
   * // Component.js (the app component)
   * ...
   * this.getService("ShellUIService") // promise is returned
   *     .then(function (oService) {
   *         oService.setTitle("Application Title");
   *     })
   *     .catch(function (oError) {
   *         Log.error("Cannot get ShellUIService", oError, "my.app.Component");
   *     });
   * ...
   * ```
   *
   *
   * The ShellUIService can also be used within nested components. Every component receives a separate instance
   * of the service. All service instances are independent and do not share any state. With this they can
   * also overwrite each other's settings. Nested components have to define the service in their own manifest
   * as well.
   *
   * **Note:** The ShellUIService is intended for use by the active app only. Calls from other types of components
   * (e.g. plugins) or inactive components (e.g. from a hidden app) are ignored.
   *
   * Auto Title and Hierarchy:
   *
   * The ShellUIService can work together with the routing defined in a UI5 app to set title and hierarchy
   * automatically, as the navigation within the app occurs. This can be achieved by enabling the ShellUIService
   * to load instantly and configuring one or both `setTitle` and `setHierarchy` options to `auto` in the
   * app manifest. Using this mechanism disables the API to manually set the title or hierarchy via `setTitle`
   * and `setHierarchy`.
   *
   *
   * ```javascript
   *
   * {
   *    "sap.ui5": {
   *       "services" : {
   *          "ShellUIService": {
   *              "lazy": false,
   *              "factoryName": "sap.ushell.ui5service.ShellUIService",
   *              "settings": {
   *                  "setHierarchy": "auto",
   *                  "setTitle": "auto"
   *              }
   *          }
   *       }
   *    }
   * }
   * ```
   *
   *
   * **Note:** Please be aware that the sapFiori2Adaptation configuration of the application may cause the
   * ShellUIService service to work incorrectly. We recommend to disable the sapFiori2Adaptation configuration
   * for the new applications if you use the ShellUIService.
   *
   * @since 1.38.0
   */
  export default class ShellUIService
    extends /* was: sap.ui.core.service.Service */ Object
  {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.ushell.ui5service.ShellUIService with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.service.Service.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ShellUIService>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui5service.ShellUIService.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Returns the current title shown in the header. This might differ from the title set by the via {@link #setTitle}.
     *
     * @since 1.38.0
     *
     * @returns The current title.
     */
    getTitle(): string;
    /**
     * Sets the application screen size to either full width or letterbox.
     *
     * @since 1.133.0
     */
    setApplicationFullWidth(
      /**
       * Whether the application should be displayed in full width.
       */
      bFullWidth: boolean
    ): void;
    /**
     * Displays the given hierarchy in the shell header. The default app hierarchy is applied if no parameter
     * is given.
     *
     * @since 1.38.0
     */
    setHierarchy(
      /**
       * An array representing hierarchies of the currently displayed app.
       */
      aHierarchyLevels?: AppInfo[]
    ): void;
    /**
     * Used by apps to set related apps. This setting is propagated towards the Shell Header via corresponding
     * events.
     *
     * @since 1.40.0
     */
    setRelatedApps(
      /**
       * An array of related apps.
       */
      aRelatedApps?: AppInfo[]
    ): void;
    /**
     * Displays the given title in the shell header. This method should not be called - and will be without
     * effect - if the app calling the method is not currently displayed in the Fiori launchpad.
     *
     * The sTitle will be concatenated with the window title extension and displayed as browser tab title. If
     * oAdditionalInformation is set, the browser tab title will be constructed from the oAdditionalInformation
     * plus window title extension. sTitle is still used in the shell header.
     *
     * Examples:
     * ```javascript
     *
     *   // Window Title Extension is: "Fiori Launchpad"
     *
     *   setTitle("My App Title");
     *   // Shell Header title: "My App Title"
     *   // Browser Window Title: "My App Title - Fiori Launchpad"
     * ```
     *
     *
     *
     * ```javascript
     *
     *   // Window Title Extension is: "Fiori Launchpad"
     *
     *   setTitle("My App Title", {
     *     headerText: "My Header Text",
     *     additionalContext: "My Additional Context",
     *     searchTerm: "My Search Term",
     *     searchScope: "My Search Scope"
     *   });
     *   // Search Term has precedence over headerText and additionalContext.
     *   // Shell Header title: "My App Title"
     *   // Browser Window Title: "My Search Term in My Search Scope - Search - Fiori Launchpad"
     * ```
     *
     *
     *
     * ```javascript
     *
     *   // Window Title Extension is: "Fiori Launchpad"
     *
     *   setTitle("My App Title", {
     *     headerText: "My Header Text",
     *     additionalContext: "My Additional Context"
     *   });
     *   // Shell Header title: "My App Title"
     *   // Browser Window Title: "My Header Text - My Additional Context - Fiori Launchpad"
     * ```
     *
     *
     * @since 1.38.0
     */
    setTitle(
      /**
       * The new title. The default title is set if this argument is not given.
       */
      sTitle?: string,
      /**
       * An object of additional information to be displayed in the browser window title
       */
      oAdditionalInformation?: {
        /**
         * Optional header text
         */
        headerText?: string;
        /**
         * Optional additional context information
         */
        additionalContext?: string;
        /**
         * Optional search term. If given, headerText and additionalContext will be ignored
         */
        searchTerm?: string;
        /**
         * Optional search scope, only used if searchTerm is given
         */
        searchScope?: string;
      }
    ): void;
  }
  /**
   * Defines essential information about an app.
   *
   * Example:
   * ```javascript
   *
   * {
   *      title: "App 1",
   *      icon: "sap-icon://folder",
   *      subtitle: "go to app 1",
   *      intent: "#Action-toapp1"
   * }
   * ```
   *
   *
   * @since 1.120.0
   */
  export type AppInfo = {
    /**
     * The title of the app.
     */
    title: string;
    /**
     * The icon src representing the app.
     */
    icon: string;
    /**
     * An optional subtitle of the app.
     */
    subtitle?: string;
    /**
     * The navigation intent of the app.
     */
    intent: string;
  };
}

declare module "sap/ushell/ui5service/UserStatus" {
  import Metadata from "sap/ui/base/Metadata";

  /**
   * @deprecated As of version 1.70. Support for this service has been discontinued.
   */
  export default class UserStatus
    extends /* was: sap.ui.core.service.Service */ Object
  {
    constructor();

    /**
     * Creates a new subclass of class sap.ushell.ui5service.UserStatus with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.service.Service.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UserStatus>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ushell.ui5service.UserStatus.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attaches an event handler fnFunction to be called upon the 'statusChanged' event. Event is fired when
     * the setStatus method is called.
     *
     * @since 1.46
     * @deprecated As of version 1.70.
     */
    attachStatusChanged(
      /**
       * The function to be called when the event occurs.
       */
      fnFunction?: Function
    ): void;
    /**
     * Detaches an event handler from the 'statusChanged' event.
     *
     * @since 1.46
     * @deprecated As of version 1.70.
     */
    detachStatusChanged(
      /**
       * Event handler to be detached.
       */
      fnFunction: Function
    ): void;
    /**
     * Enable the User Status service (online status)
     *
     * If the user has never agreed to share their online status, then the method will show the opt-in screen
     * to the user. If the user already agreed to share their online status, the setStatus method will be called
     * with the default online status that was set by the user. If the user already declined to share their
     * online status, the setStatus method will be called with a null value.
     *
     * @since 1.46
     * @deprecated As of version 1.70.
     */
    setEnabled(
      /**
       * boolean.
       */
      bEnable: boolean
    ): void;
    /**
     * Publish the user status. This method is used to publish the status to other components.
     *
     * The publication of the status by firing the 'statusChanged' event will happen when all the following
     * apply: 1) the User Status service is enabled 2) the status is null or exists in the list of available
     * statuses (sap.ushell.ui5service.UserStatus.prototype.AvailableStatus) 3) the user has agreed to share
     * their online status
     *
     * @since 1.46
     * @deprecated As of version 1.70.
     */
    setStatus(
      /**
       * sap.ushell.ui5service.UserStatus.prototype.AvailableStatus
       */
      oNewStatus: object
    ): void;
  }
}

declare namespace sap {
  /**
   * SAP library: sap.ushell
   *
   * @since 1.15.0
   */
  namespace ushell {
    /**
     * Initializes the Unified Shell Container.
     *
     * This platform-specific method must be called exactly once in the very beginning to resolve all necessary
     * dependencies and prepare Unified Shell's global infrastructure. As soon as the returned promise has been
     * resolved, the container will be available as a singleton object in namespace `sap.ushell.Container`.
     *
     * **Note:** `sap.ushell.bootstrap` is used internally by the SAP Fiori launchpad. Developers who build
     * apps or plugins for the SAP Fiori launchpad should use `sap.ushell.bootstrap` in their code. However,
     * there are special use cases where a customized bootstrap of Unified Shell is helpful, e.g. when Unified
     * Shell UI services need to be accessed without having loaded the Unified Shell's UI. In such cases, additional
     * dependencies need to be required to allow proper usage of the Unified Shell's functionality.
     *
     * **Example:**
     * ```javascript
     *
     * <script id="sap-ui-bootstrap"
     *         src=".../sap-ui-core.js"
     *         data-sap-ui-libs="sap.ushell, sap.m">
     * </script>
     *
     * <!--...-->
     *
     * <script>
     *   sap.ui.getCore().attachInit(function () {
     *   // Container needs to be required to make sap.ushell.bootstrap available
     *     sap.ui.require(["sap/ushell/Container", ... ], function (Container) {
     *       window["sap-ushell-config"] = {...};
     *
     *       sap.ushell.bootstrap("abap", {
     *         abap: "sap.ushell_abap.adapters.abap"
     *       }).then(function () {
     *         sap.ushell.Container.getServiceAsync(\/* Service *\/).then(function (serviceInstance) {
     *           ...
     *         });
     *       });
     *     });
     *   });
     * </script>
     * ```
     *
     *
     * @since 1.15.0
     * @deprecated As of version 1.120.
     *
     * @returns Resolves once the container is available.
     */
    function bootstrap(
      /**
       * the target platform, such as "abap" or "cdm".
       */
      sPlatform: string,
      /**
       * the map with platform specific package names for the service adapters. You only need to specify these
       * package names if they differ from the standard name `"sap.ushell.adapters." + sPlatform`.
       */
      mAdapterPackagesByPlatform?: Record<string, string>
    ): jQuery.Promise;
    /**
     * Default namespace for Unified Shell services.
     * See:
     * 	sap.ushell.Container.getServiceAsync
     *
     * @since 1.15.0
     */
    namespace services {
      namespace PersonalizationV2 {
        /**
         * @since 1.124.0
         */
        enum KeyCategory {
          /**
           * A static hard-coded key which does not change. This value is required for caching to take place.
           */
          FIXED_KEY = "FIXED_KEY",
          /**
           * For all other cases.
           */
          GENERATED_KEY = "GENERATED_KEY",
        }
        /**
         * @since 1.124.0
         */
        enum WriteFrequency {
          HIGH = "HIGH",
          /**
           * The key is typically rarely updated, for example in explicit table personalization by end users.
           */
          LOW = "LOW",
        }
      }

      /**
       * Abstract base class for ushell services. For details, see {@link sap.ushell.Container#getServiceAsync}.
       *
       * @since 1.121.0
       */
      abstract class Service {
        /**
         * @ui5-protected Do not call from applications (only from related classes in the framework)
         */
        protected constructor();
      }
    }
  }

  interface IUI5DefineDependencyNames {
    "sap/ushell/api/BootstrapObserver": undefined;

    "sap/ushell/api/Copilot": undefined;

    "sap/ushell/api/DWS": undefined;

    "sap/ushell/api/Inbox": undefined;

    "sap/ushell/api/NewExperience": undefined;

    "sap/ushell/api/RTA": undefined;

    "sap/ushell/api/S4MyHome": undefined;

    "sap/ushell/api/SAPBusinessClient": undefined;

    "sap/ushell/api/workpage/Designtime": undefined;

    "sap/ushell/api/workpage/Runtime": undefined;

    "sap/ushell/components/factsheet/controls/PictureTile": undefined;

    "sap/ushell/components/factsheet/controls/PictureViewer": undefined;

    "sap/ushell/components/factsheet/controls/PictureViewerItem": undefined;

    "sap/ushell/Container": undefined;

    "sap/ushell/library": undefined;

    "sap/ushell/modules/NavigationMenu": undefined;

    "sap/ushell/renderer/ShellLayout": undefined;

    "sap/ushell/renderers/fiori2/Renderer": undefined;

    "sap/ushell/services/_Personalization/ContextContainer": undefined;

    "sap/ushell/services/_Personalization/PersonalizationContainer": undefined;

    "sap/ushell/services/_Personalization/PersonalizationContainerVariant": undefined;

    "sap/ushell/services/_Personalization/PersonalizationContainerVariantSet": undefined;

    "sap/ushell/services/_Personalization/Personalizer": undefined;

    "sap/ushell/services/_Personalization/TransientPersonalizer": undefined;

    "sap/ushell/services/_Personalization/Variant": undefined;

    "sap/ushell/services/_Personalization/VariantSet": undefined;

    "sap/ushell/services/AppConfiguration": undefined;

    "sap/ushell/services/AppLifeCycle": undefined;

    "sap/ushell/services/Bookmark": undefined;

    "sap/ushell/services/BookmarkV2": undefined;

    "sap/ushell/services/Configuration": undefined;

    "sap/ushell/services/ContentExtensionAdapterFactory": undefined;

    "sap/ushell/services/CrossApplicationNavigation": undefined;

    "sap/ushell/services/EndUserFeedback": undefined;

    "sap/ushell/services/Extension": undefined;

    "sap/ushell/services/Extension/Item": undefined;

    "sap/ushell/services/FrameBoundExtension": undefined;

    "sap/ushell/services/FrameBoundExtension/FloatingContainer": undefined;

    "sap/ushell/services/FrameBoundExtension/Footer": undefined;

    "sap/ushell/services/FrameBoundExtension/Item": undefined;

    "sap/ushell/services/FrameBoundExtension/SidePane": undefined;

    "sap/ushell/services/FrameBoundExtension/ToolArea": undefined;

    "sap/ushell/services/FrameBoundExtension/UserSettingsEntry": undefined;

    "sap/ushell/services/LaunchPage": undefined;

    "sap/ushell/services/Message": undefined;

    "sap/ushell/services/Navigation": undefined;

    "sap/ushell/services/NavTargetResolution": undefined;

    "sap/ushell/services/Notifications": undefined;

    "sap/ushell/services/NotificationsV2": undefined;

    "sap/ushell/services/Pages": undefined;

    "sap/ushell/services/Personalization": undefined;

    "sap/ushell/services/personalization/VariantSetAdapter": undefined;

    "sap/ushell/services/PersonalizationV2": undefined;

    "sap/ushell/services/PersonalizationV2/constants": undefined;

    "sap/ushell/services/PersonalizationV2/ContextContainer": undefined;

    "sap/ushell/services/PersonalizationV2/Personalizer": undefined;

    "sap/ushell/services/PersonalizationV2/TransientPersonalizer": undefined;

    "sap/ushell/services/PersonalizationV2/Variant": undefined;

    "sap/ushell/services/PersonalizationV2/VariantSet": undefined;

    "sap/ushell/services/PersonalizationV2/VariantSetAdapter": undefined;

    "sap/ushell/services/SearchableContent": undefined;

    "sap/ushell/services/ShellNavigation": undefined;

    "sap/ushell/services/ShellNavigationInternal": undefined;

    "sap/ushell/services/SmartNavigation": undefined;

    "sap/ushell/services/SpaceContent": undefined;

    "sap/ushell/services/SupportTicket": undefined;

    "sap/ushell/services/URLParsing": undefined;

    "sap/ushell/services/UsageAnalytics": undefined;

    "sap/ushell/services/UserDefaultParameters": undefined;

    "sap/ushell/services/UserInfo": undefined;

    "sap/ushell/services/UserRecents": undefined;

    "sap/ushell/services/VisualizationInstantiation": undefined;

    "sap/ushell/System": undefined;

    "sap/ushell/ui/appfinder/AppBox": undefined;

    "sap/ushell/ui/footerbar/AddBookmarkButton": undefined;

    "sap/ushell/ui/launchpad/ActionItem": undefined;

    "sap/ushell/ui/launchpad/DashboardGroupsContainer": undefined;

    "sap/ushell/ui/launchpad/LinkTileWrapper": undefined;

    "sap/ushell/ui/launchpad/TileState": undefined;

    "sap/ushell/ui/launchpad/VizInstanceBase": undefined;

    "sap/ushell/ui/shell/ShellHeadItem": undefined;

    "sap/ushell/ui/shell/ToolAreaItem": undefined;

    "sap/ushell/ui/tile/StaticTile": undefined;

    "sap/ushell/ui5service/ShellUIService": undefined;

    "sap/ushell/ui5service/ShellUIServiceFactory": undefined;

    "sap/ushell/ui5service/UserStatus": undefined;

    "sap/ushell/utils/UriParameters": undefined;
  }
}
