import ts from "typescript";
export declare function isSourceFileOfTypeScriptLib(sourceFile: ts.SourceFile): boolean;
export declare function isSourceFileOfPseudoModuleType(sourceFile: ts.SourceFile): boolean;
/**
 * Returns the text of a PropertyName node.
 * This function will not return the source code text of the node, but the text that can be
 * used to check against when looking for a specific property.
 *
 * If the text can't be determined, undefined is returned.
 * This may happen in the following cases:
 * - A ComputedPropertyName with a non-string literal-like expression
 * - A BigIntLiteral, which technically is a PropertyName, but is not valid in this context
 *
 * @param node
 * @returns text of the given node or undefined
 */
export declare function getPropertyNameText(node: ts.PropertyName): string | undefined;
/**
 * Searches for the symbol of an argument within the given construct signatures.
 * The first match is returned.
 *
 * Returns undefined if the argument is not found in any of the construct signatures.
 *
 * @param constructSignatures construct signatures to search in
 * @param argumentPosition position of the argument in the signature
 * @returns symbol of the found property or undefined
 */
export declare function getSymbolForArgumentInConstructSignatures(constructSignatures: readonly ts.Signature[], argumentPosition: number): ts.Symbol | undefined;
/**
 * Searches for the symbol of a property within the given construct signatures.
 * The first match is returned.
 *
 * Returns undefined if the property is not found in any of the construct signatures.
 *
 * @param constructSignatures construct signatures to search in
 * @param argumentPosition position of the signature parameter to search in
 * @param propertyName property name to search for
 * @returns symbol of the found property or undefined
 */
export declare function getSymbolForPropertyInConstructSignatures(constructSignatures: readonly ts.Signature[], argumentPosition: number, propertyName: string): ts.Symbol | undefined;
/**
 * Searches for a class member with the given name.
 * If no modifiers are passed, any member with the given name is returned.
 * If modifiers are passed, only members with at least the given modifiers are returned.
 *
 * Returns undefined if no matching member is found.
 *
 * @param node
 * @param memberName
 * @param modifiers
 * @returns
 */
export declare function findClassMember(node: ts.ClassDeclaration, memberName: string, modifiers?: {
    modifier: ts.ModifierSyntaxKind;
    not?: boolean;
}[]): ts.ClassElement | undefined;
/**
 * Checks whether the given class member is a method or function.
 * This includes the type lookup of a referenced function.
 *
 * @param node
 * @param methodName
 * @param checker
 * @returns
 */
export declare function isClassMethod(node: ts.ClassElement, checker: ts.TypeChecker): boolean;
/**
 * Returns the PropertyAssignment of the given property name in the given ObjectLiteralExpression.
 * If the property is not found, undefined is returned.
 *
 * @param propertyName
 * @param node
 * @returns
 */
export declare function getPropertyAssignmentInObjectLiteralExpression(propertyName: string, node: ts.ObjectLiteralExpression): ts.PropertyAssignment | undefined;
/**
 * Returns the PropertyAssignments of the given property names in the given ObjectLiteralExpression.
 * The order of the returned array matches the order of the propertyNames array and may contain undefined
 * values for properties that are not found.
 *
 * @param propertyNames
 * @param node
 * @returns
 */
export declare function getPropertyAssignmentsInObjectLiteralExpression(propertyNames: string[], node: ts.ObjectLiteralExpression): (ts.PropertyAssignment | undefined)[];
export declare function resolveUniqueName(inputName: string, existingIdentifiers?: Set<string>): string;
export declare function isAssignment(node: ts.AccessExpression): boolean;
export declare function isReturnValueUsed(node: ts.Node): boolean;
export declare function isConditionalAccess(node: ts.Node): boolean;
export declare function extractNamespace(node: ts.PropertyAccessExpression | ts.ElementAccessExpression | ts.CallExpression): string;
export declare function isGlobalThis(nodeType: string): boolean;
export declare function getSymbolModuleDeclaration(symbol: ts.Symbol): ts.ModuleDeclaration | undefined;
/**
 * Extracts the sap.ui API namespace from a symbol name and a module declaration
 * (from @sapui5/types sap.ui.core.d.ts), e.g. sap.ui.view.
 */
export declare function extractSapUiNamespace(symbolName: string, moduleDeclaration: ts.ModuleDeclaration): string | undefined;
/**
 * Recursively count all child nodes matching the filter
 */
export declare function countChildNodesRecursive(node: ts.Node, filterKinds?: ts.SyntaxKind[]): number;
export declare function findNodeRecursive<T extends ts.Node>(node: ts.Node, filterKinds?: ts.SyntaxKind[]): T | undefined;
