import ts from "typescript";
import { PositionInfo } from "../../LinterContext.js";
import BaseFix, { BaseFixParams } from "./BaseFix.js";
import { FixHelpers } from "./Fix.js";
import { Ui5TypeInfo } from "../Ui5TypeInfo.js";
export interface CallExpressionBaseFixParams extends BaseFixParams {
    /**
     * Validation: If set to true, the fix will only be applied if the return value of the code does not use the
     * return value of the call expression.
     */
    mustNotUseReturnValue?: boolean;
}
export default abstract class CallExpressionBaseFix extends BaseFix {
    protected params: CallExpressionBaseFixParams;
    protected nodeTypes: ts.SyntaxKind[];
    protected containedCallExpressionCount: number;
    constructor(params: CallExpressionBaseFixParams, ui5TypeInfo: Ui5TypeInfo);
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo, helpers: FixHelpers): boolean;
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
}
