import { ChangeAction } from "../../../utils/textChanges.js";
import AccessExpressionBaseFix from "./AccessExpressionBaseFix.js";
/**
 * Fix a property access. This could also be the property access of a call expression, allowing for a more general
 * replacement in cases where the arguments or other conditions of the call expression do not matter.
 */
export default class AccessExpressionGeneratorFix extends AccessExpressionBaseFix {
    params;
    constructor(params, ui5TypeInfo) {
        super(params, ui5TypeInfo);
        this.params = params;
    }
    getNewModuleDependencies() {
        if (this.params.moduleName && this.params.moduleImports) {
            throw new Error("Parameters 'moduleName' and 'moduleImports' are both defined. Only one may be used at a time.");
        }
        else if (this.params.moduleName) {
            return super.getNewModuleDependencies();
        }
        else if (!this.params.moduleImports) {
            return;
        }
        const usagePosition = this.startPos;
        if (usagePosition === undefined) {
            throw new Error("Start position is not defined");
        }
        return this.params.moduleImports.map((moduleImport) => {
            return {
                ...moduleImport,
                usagePosition,
            };
        });
    }
    getNewGlobalAccess() {
        if (this.params.globalName && this.params.globalNames) {
            throw new Error("Parameters 'globalName' and 'globalNames' are both defined. Only one may be used at a time.");
        }
        else if (this.params.globalName) {
            return super.getNewGlobalAccess();
        }
        else if (!this.params.globalNames) {
            return;
        }
        const usagePosition = this.startPos;
        if (usagePosition === undefined) {
            throw new Error("Start position is not defined");
        }
        return this.params.globalNames.map((globalName) => {
            return {
                globalName,
                usagePosition,
            };
        });
    }
    generateChanges() {
        if (this.startPos === undefined || this.endPos === undefined) {
            throw new Error("Start and end position are not defined");
        }
        let moduleNames;
        if (this.params.moduleName) {
            moduleNames = [this.params.moduleName];
        }
        else if (this.params.moduleImports) {
            moduleNames = this.params.moduleImports.map((moduleImport) => moduleImport.moduleName);
        }
        const globalNames = this.params.globalName ? [this.params.globalName] : this.params.globalNames;
        const identifiers = this.getIdentifiersForMultipleRequests(moduleNames, globalNames);
        if (!identifiers) {
            return;
        }
        // If a generator function is provided, use it to generate the change
        const value = this.params.generator(identifiers);
        if (value === undefined) {
            return;
        }
        return {
            action: ChangeAction.REPLACE,
            start: this.startPos,
            end: this.endPos,
            value,
        };
    }
}
//# sourceMappingURL=AccessExpressionGeneratorFix.js.map