import { Attribute } from "sax-wasm";
import { ChangeSet } from "../../../utils/textChanges.js";
import { HtmlFix } from "./HtmlFix.js";
import { ToPositionCallback } from "../../ui5Types/fix/XmlEnabledFix.js";
/**
 * Fix to rename the identifier of an attribute in an HTML tag.
 * @param attribute The identifier to be renamed.
 * @param newName The new identifier for the attribute.
 */
export default class RenameAttributeFix extends HtmlFix {
    private newName;
    private startPositionDetail;
    private endPositionDetail;
    constructor(attribute: Attribute, newName: string);
    calculateSourceCodeRange(toPosition: ToPositionCallback): void;
    generateChanges(): ChangeSet;
}
