"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uninstallPackage = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const execa_1 = __importDefault(require("execa"));
function getPkgManager(baseDir) {
    for (const { lockFile, packageManager } of [
        { lockFile: 'yarn.lock', packageManager: 'yarn' },
        { lockFile: 'pnpm-lock.yaml', packageManager: 'pnpm' },
        { lockFile: 'package-lock.json', packageManager: 'npm' },
    ]) {
        if (fs_1.default.existsSync(path_1.default.join(baseDir, lockFile))) {
            return packageManager;
        }
    }
}
function uninstallPackage(packageToUninstall) {
    const pkgManager = getPkgManager(process.cwd());
    if (!pkgManager)
        throw new Error('Failed to find package manager');
    let command = 'uninstall';
    if (pkgManager === 'yarn') {
        command = 'remove';
    }
    execa_1.default.sync(pkgManager, [command, packageToUninstall], { stdio: 'inherit' });
}
exports.uninstallPackage = uninstallPackage;
//# sourceMappingURL=uninstall-package.js.map