// For Library Version: 1.136.2

declare module "sap/ui/vbm/library" {
  /**
   * Cluster Info Type
   *
   * This enum is part of the 'sap/ui/vbm/library' module export and must be accessed by the property 'ClusterInfoType'.
   */
  export enum ClusterInfoType {
    /**
     * Type indicating that Cluster Info should return info on child cluster nodes (next LOD). This is only
     * supported for tree clustering.
     */
    ChildCluster = "1",
    /**
     * Type indicating that Cluster Info should return only VOs covered by the Cluster object
     */
    ContainedVOs = "0",
    /**
     * Type indicating that Cluster Info should return info on Edges of the Voronoi Area for the cluster. This
     * is only supported for tree clustering. Edges not merged with rectangles.
     */
    Edges = "11",
    /**
     * Type indicating that Cluster Info should return info on cluster node itself.
     */
    NodeInfo = "10",
    /**
     * Type indicating that Cluster Info should return info on parent cluster node (previous LOD). This is only
     * supported for tree clustering.
     */
    ParentNode = "2",
  }
  /**
   * Route type, determining how line between start and endpoint should be drawn.
   *
   * This enum is part of the 'sap/ui/vbm/library' module export and must be accessed by the property 'RouteType'.
   */
  export enum RouteType {
    /**
     * Type indicating a geodesic connection
     */
    Geodesic = "Geodesic",
    /**
     * Type indicating a straight connection
     */
    Straight = "Straight",
  }
  /**
   * Semantic type with pre-defined display properties, like colors, icon, pin image, and so on. Semantic
   * types enforce to fiori guidelines.
   *
   * This enum is part of the 'sap/ui/vbm/library' module export and must be accessed by the property 'SemanticType'.
   */
  export enum SemanticType {
    /**
     * Type indicating the Default state
     */
    Default = "Default",
    /**
     * Type indicating an Error state
     */
    Error = "Error",
    /**
     * Type indicating a Hidden state
     */
    Hidden = "Hidden",
    /**
     * Type indicating an Inactive state
     */
    Inactive = "Inactive",
    /**
     * Type indicating no state
     */
    None = "None",
    /**
     * Type indicating a Success/Positive state
     */
    Success = "Success",
    /**
     * Type indicating a Warning state
     */
    Warning = "Warning",
  }
}

declare module "sap/ui/vbm/Adapter" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import GeoMap from "sap/ui/vbm/GeoMap";

  import Event from "sap/ui/base/Event";

  /**
   * Provides the ability to load VBI JSON into {@link sap.ui.vbm.GeoMap sap.ui.vbm.GeoMap} control.
   */
  export default class Adapter extends UI5Element {
    /**
     * Constructor for a new GeoMap Adapter.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new object
       */
      mSettings?: $AdapterSettings
    );
    /**
     * Constructor for a new GeoMap Adapter.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new object
       */
      mSettings?: $AdapterSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Adapter with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Adapter>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Adapter.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:submit submit} event of this `sap.ui.vbm.Adapter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Adapter` itself.
     *
     * The event is raised when a when the Adapter receives an event from GeoMap control. It is intended to
     * unify the various GeoMap events as provided by VBI.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSubmit(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Adapter$SubmitEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Adapter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:submit submit} event of this `sap.ui.vbm.Adapter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Adapter` itself.
     *
     * The event is raised when a when the Adapter receives an event from GeoMap control. It is intended to
     * unify the various GeoMap events as provided by VBI.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSubmit(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Adapter$SubmitEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Adapter` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:submit submit} event of this `sap.ui.vbm.Adapter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSubmit(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Adapter$SubmitEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:submit submit} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSubmit(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Adapter$SubmitEventParameters
    ): this;
    /**
     * ID of the element which is the current target of the association {@link #getMap map}, or `null`.
     */
    getMap(): ID | null;
    /**
     * Parses and process sections of the VBI JSON and loads them into JSON Model bound to the GeoMap
     *
     *
     * @returns A Promise object that is resolved when the VBI JSON is processed.
     */
    load(
      /**
       * VBI JSON to be loaded into the GeoMap control.
       */
      data: string | object
    ): Promise<any>;
    /**
     * Sets the associated {@link #getMap map}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMap(
      /**
       * ID of an element which becomes the new target of this map association; alternatively, an element instance
       * may be given
       */
      oMap: ID | GeoMap
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Adapter constructor.
   */
  export interface $AdapterSettings extends $ElementSettings {
    /**
     * The GeoMap control associated with the Adapter. The adapter would invoke methods and subscribe to events
     * on this GeoMap instance
     */
    map?: GeoMap | string;

    /**
     * The event is raised when a when the Adapter receives an event from GeoMap control. It is intended to
     * unify the various GeoMap events as provided by VBI.
     */
    submit?: (oEvent: Adapter$SubmitEvent) => void;
  }

  /**
   * Parameters of the Adapter#submit event.
   */
  export interface Adapter$SubmitEventParameters {
    data?: string;
  }

  /**
   * Event object of the Adapter#submit event.
   */
  export type Adapter$SubmitEvent = Event<
    Adapter$SubmitEventParameters,
    Adapter
  >;
}

declare module "sap/ui/vbm/Adapter3D" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ID } from "sap/ui/core/library";

  import Viewport from "sap/ui/vbm/Viewport";

  import Event from "sap/ui/base/Event";

  /**
   * Provides the ability to load VBI JSON into {@link sap.ui.vbm.Viewport sap.ui.vbm.Viewport} control.
   */
  export default class Adapter3D extends UI5Element {
    /**
     * Constructor for a new Visual Business Adapter 3D.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new object
       */
      mSettings?: $Adapter3DSettings
    );
    /**
     * Constructor for a new Visual Business Adapter 3D.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new object
       */
      mSettings?: $Adapter3DSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Adapter3D with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Adapter3D>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Adapter3D.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:submit submit} event of this `sap.ui.vbm.Adapter3D`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Adapter3D` itself.
     *
     * This event is fired when interactions in the viewport happen.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSubmit(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Adapter3D$SubmitEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Adapter3D` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:submit submit} event of this `sap.ui.vbm.Adapter3D`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Adapter3D` itself.
     *
     * This event is fired when interactions in the viewport happen.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSubmit(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Adapter3D$SubmitEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Adapter3D` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:submit submit} event of this `sap.ui.vbm.Adapter3D`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSubmit(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Adapter3D$SubmitEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:submit submit} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSubmit(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Adapter3D$SubmitEventParameters
    ): this;
    /**
     * ID of the element which is the current target of the association {@link #getViewport viewport}, or `null`.
     */
    getViewport(): ID | null;
    /**
     * Processes the various sections from the VBI JSON.
     *
     * The Resources, DataTypes, Scenes and Data sections from the VBI JSON are sequentially processed.
     *
     *
     * @returns A Promise object that is resolved when the VBI JSON is processed.
     */
    load(
      /**
       * The VBI JSON.
       */
      data: object | string
    ): Promise<any>;
    /**
     * Sets the associated {@link #getViewport viewport}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewport(
      /**
       * ID of an element which becomes the new target of this viewport association; alternatively, an element
       * instance may be given
       */
      oViewport: ID | Viewport
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Adapter3D constructor.
   */
  export interface $Adapter3DSettings extends $ElementSettings {
    /**
     * The {@link sap.ui.vbm.Viewport Viewport} control associated with the Adapter3D. The Adapter3D would invoke
     * methods and subscribe to events on this {@link sap.ui.vbm.Viewport Viewport} instance.
     */
    viewport?: Viewport | string;

    /**
     * This event is fired when interactions in the viewport happen.
     */
    submit?: (oEvent: Adapter3D$SubmitEvent) => void;
  }

  /**
   * Parameters of the Adapter3D#submit event.
   */
  export interface Adapter3D$SubmitEventParameters {
    /**
     * A string in the VBI JSON format.
     */
    data?: string;
  }

  /**
   * Event object of the Adapter3D#submit event.
   */
  export type Adapter3D$SubmitEvent = Event<
    Adapter3D$SubmitEventParameters,
    Adapter3D
  >;
}

declare module "sap/ui/vbm/AnalyticMap" {
  import { default as GeoMap, $GeoMapSettings } from "sap/ui/vbm/GeoMap";

  import Region from "sap/ui/vbm/Region";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The AnalyticMap control. This control renders a Map based on a GeoJSON source. The GeoJSON file is searched
   * in the following places in the given sequence:
   * 	 <server>:<port>/sap/bc/vbi/geojson/L0.json  ./media/analyticmap/L0.json  Further
   * it is possible to specify a different URL by setting static attribute sap.ui.vbm.AnalyticMap.GeoJSONURL.
   *  The Features from the GeoJSON get rendered as neutral background in gray. They are not active, but may
   * report a name via tooltip. Each feature is expected to have a property id or id2, where as id2 should
   * be an ISO country according to ISO 3166-2.
   *  By adding Region elements to the regions aggregation it is possible to make feature from the GeoJSON
   * interactive. Region elements need to match by ISO code.
   */
  export default class AnalyticMap extends GeoMap {
    /**
     * Constructor for a new AnalyticMap.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AnalyticMapSettings
    );
    /**
     * Constructor for a new AnalyticMap.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AnalyticMapSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.AnalyticMap with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.GeoMap.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AnalyticMap>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.AnalyticMap.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some region to the aggregation {@link #getRegions regions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addRegion(
      /**
       * The region to add; if empty, nothing is inserted
       */
      oRegion: Region
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionClick regionClick} event of this `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * The event is raised when there is a click or a tap on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticMap$RegionClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionClick regionClick} event of this `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * The event is raised when there is a click or a tap on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticMap$RegionClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionContextMenu regionContextMenu} event of
     * this `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticMap$RegionContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionContextMenu regionContextMenu} event of
     * this `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticMap$RegionContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionDeselect regionDeselect} event of this
     * `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * Event is raised when regions get deselected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionDeselect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionDeselect regionDeselect} event of this
     * `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * Event is raised when regions get deselected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionDeselect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionSelect regionSelect} event of this `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * Raised when regions get selected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:regionSelect regionSelect} event of this `sap.ui.vbm.AnalyticMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.AnalyticMap` itself.
     *
     * Raised when regions get selected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRegionSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.AnalyticMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the regions in the aggregation {@link #getRegions regions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRegions(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:regionClick regionClick} event of this `sap.ui.vbm.AnalyticMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRegionClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnalyticMap$RegionClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:regionContextMenu regionContextMenu} event
     * of this `sap.ui.vbm.AnalyticMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRegionContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnalyticMap$RegionContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:regionDeselect regionDeselect} event of this
     * `sap.ui.vbm.AnalyticMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRegionDeselect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:regionSelect regionSelect} event of this `sap.ui.vbm.AnalyticMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRegionSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:regionClick regionClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRegionClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnalyticMap$RegionClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:regionContextMenu regionContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRegionContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnalyticMap$RegionContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:regionDeselect regionDeselect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRegionDeselect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:regionSelect regionSelect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRegionSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getRegions regions}.
     *
     * Regions that are different from the defaults. It is possible to specify the tooltip and color for regions.
     * The region code must match the GeoJSON id2 identifier.
     */
    getRegions(): Region[];
    /**
     * Returns Infos for Regions like name, bounding box and midpoint
     *
     *
     * @returns Array of Region Information Objects. Each object in the array has the properties BBox: Bounding
     * Box for Region in format "lonMin;latMin;lonMax;latMax", Midpoint: Centerpoint for Region in format "lon;lat",
     * Name: Name of the region, and Properties: Array of name-value-pair associated with the region
     */
    getRegionsInfo(
      /**
       * Array of region codes. The region code must match the geo json tag.
       */
      aCodes: string[]
    ): any[];
    /**
     * Checks for the provided `sap.ui.vbm.Region` in the aggregation {@link #getRegions regions}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRegion(
      /**
       * The region whose index is looked for
       */
      oRegion: Region
    ): int;
    /**
     * Inserts a region into the aggregation {@link #getRegions regions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertRegion(
      /**
       * The region to insert; if empty, nothing is inserted
       */
      oRegion: Region,
      /**
       * The `0`-based index the region should be inserted at; for a negative value of `iIndex`, the region is
       * inserted at position 0; for a value greater than the current size of the aggregation, the region is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getRegions regions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllRegions(): Region[];
    /**
     * Removes a region from the aggregation {@link #getRegions regions}.
     *
     *
     * @returns The removed region or `null`
     */
    removeRegion(
      /**
       * The region to remove or its index or id
       */
      vRegion: int | string | Region
    ): Region | null;
    /**
     * Zoom to one ore more regions.
     */
    zoomToRegions(
      /**
       * Array of region codes. The region codes must match the geo json tags.
       */
      aCodes: string[],
      /**
       * Correction for the calculated zoom factor. You can either a factor, the calculated zoom is multplied
       * with or a array with pixels to be added as border in the sequence [left, top,right, bottom].
       */
      oCorr: object
    ): void;
  }
  /**
   * Describes the settings that can be provided to the AnalyticMap constructor.
   */
  export interface $AnalyticMapSettings extends $GeoMapSettings {
    /**
     * Regions that are different from the defaults. It is possible to specify the tooltip and color for regions.
     * The region code must match the GeoJSON id2 identifier.
     */
    regions?: Region[] | Region | AggregationBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click or a tap on a region.
     */
    regionClick?: (oEvent: AnalyticMap$RegionClickEvent) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a region.
     */
    regionContextMenu?: (oEvent: AnalyticMap$RegionContextMenuEvent) => void;

    /**
     * Raised when regions get selected
     */
    regionSelect?: (oEvent: Event) => void;

    /**
     * Event is raised when regions get deselected
     */
    regionDeselect?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AnalyticMap#regionClick event.
   */
  export interface AnalyticMap$RegionClickEventParameters {
    /**
     * The regions code.
     */
    code?: string;
  }

  /**
   * Event object of the AnalyticMap#regionClick event.
   */
  export type AnalyticMap$RegionClickEvent = Event<
    AnalyticMap$RegionClickEventParameters,
    AnalyticMap
  >;

  /**
   * Parameters of the AnalyticMap#regionContextMenu event.
   */
  export interface AnalyticMap$RegionContextMenuEventParameters {
    /**
     * The regions code.
     */
    code?: string;
  }

  /**
   * Event object of the AnalyticMap#regionContextMenu event.
   */
  export type AnalyticMap$RegionContextMenuEvent = Event<
    AnalyticMap$RegionContextMenuEventParameters,
    AnalyticMap
  >;

  /**
   * Parameters of the AnalyticMap#regionDeselect event.
   */
  export interface AnalyticMap$RegionDeselectEventParameters {}

  /**
   * Event object of the AnalyticMap#regionDeselect event.
   */
  export type AnalyticMap$RegionDeselectEvent = Event<
    AnalyticMap$RegionDeselectEventParameters,
    AnalyticMap
  >;

  /**
   * Parameters of the AnalyticMap#regionSelect event.
   */
  export interface AnalyticMap$RegionSelectEventParameters {}

  /**
   * Event object of the AnalyticMap#regionSelect event.
   */
  export type AnalyticMap$RegionSelectEvent = Event<
    AnalyticMap$RegionSelectEventParameters,
    AnalyticMap
  >;
}

declare module "sap/ui/vbm/Area" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for an Area. An Area is a filled polygon, which border is given
   * as a list of geo-coordinates. Areas can have multiple disjunct parts as well as each part can have an
   * arbitrary number of exclusions/holes.
   *  The inner part and the edges of areas are interactive and fire events on click.
   *  Since the actual size of an area depends on the zoom level it might be only partly visible. Thus detail
   * windows will open at the click position.
   */
  export default class Area extends VoBase {
    /**
     * Constructor for a new Area.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaSettings
    );
    /**
     * Constructor for a new Area.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Area with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Area>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Area.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeClick edgeClick} event of this `sap.ui.vbm.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Area` itself.
     *
     * This event is raised when the edge of an Area is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeClick edgeClick} event of this `sap.ui.vbm.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Area` itself.
     *
     * This event is raised when the edge of an Area is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeContextMenu edgeContextMenu} event of this
     * `sap.ui.vbm.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Area` itself.
     *
     * This event is raised when the edge of an Area is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeContextMenu edgeContextMenu} event of this
     * `sap.ui.vbm.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Area` itself.
     *
     * This event is raised when the edge of an Area is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:edgeClick edgeClick} event of this `sap.ui.vbm.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEdgeClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:edgeContextMenu edgeContextMenu} event of
     * this `sap.ui.vbm.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEdgeContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:edgeClick edgeClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEdgeClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:edgeContextMenu edgeContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEdgeContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getBorderDash borderDash}.
     *
     * Defines the dashing style of the area border using an array.
     *
     *
     * @returns Value of property `borderDash`
     */
    getBorderDash(): string;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The fill color of the Area.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getColorBorder colorBorder}.
     *
     * The border color of the Area.
     *
     *
     * @returns Value of property `colorBorder`
     */
    getColorBorder(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position array for the Area. For single part areas the format is "lon0;lat0;0.0;...;lonN,latN,0.0".
     * For multi part areas you need to provide an array of arrays of the above position string: "[['lon0...'],['lon0...']]"
     * (sequence of single and double quotes is important). **Single and Multi part areas must not be mixed
     * within one Areas aggregation.**
     *  Finally each area part can have multiple exclusions/holes. In that case the position list of excluded
     * areas has follow the list of the base shape: "['lon0...', 'exLon0...']".
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Sets a new value for property {@link #getBorderDash borderDash}.
     *
     * Defines the dashing style of the area border using an array.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBorderDash(
      /**
       * New value for property `borderDash`
       */
      sBorderDash: string
    ): this;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The fill color of the Area.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorBorder colorBorder}.
     *
     * The border color of the Area.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorBorder(
      /**
       * New value for property `colorBorder`
       */
      sColorBorder: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position array for the Area. For single part areas the format is "lon0;lat0;0.0;...;lonN,latN,0.0".
     * For multi part areas you need to provide an array of arrays of the above position string: "[['lon0...'],['lon0...']]"
     * (sequence of single and double quotes is important). **Single and Multi part areas must not be mixed
     * within one Areas aggregation.**
     *  Finally each area part can have multiple exclusions/holes. In that case the position list of excluded
     * areas has follow the list of the base shape: "['lon0...', 'exLon0...']".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Area constructor.
   */
  export interface $AreaSettings extends $VoBaseSettings {
    /**
     * The position array for the Area. For single part areas the format is "lon0;lat0;0.0;...;lonN,latN,0.0".
     * For multi part areas you need to provide an array of arrays of the above position string: "[['lon0...'],['lon0...']]"
     * (sequence of single and double quotes is important). **Single and Multi part areas must not be mixed
     * within one Areas aggregation.**
     *  Finally each area part can have multiple exclusions/holes. In that case the position list of excluded
     * areas has follow the list of the base shape: "['lon0...', 'exLon0...']".
     */
    position?: string | PropertyBindingInfo;

    /**
     * The fill color of the Area.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The border color of the Area.
     */
    colorBorder?: string | PropertyBindingInfo;

    /**
     * Defines the dashing style of the area border using an array.
     */
    borderDash?: string | PropertyBindingInfo;

    /**
     * This event is raised when the edge of an Area is clicked.
     */
    edgeClick?: (oEvent: Event) => void;

    /**
     * This event is raised when the edge of an Area is right clicked.
     */
    edgeContextMenu?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Area#edgeClick event.
   */
  export interface Area$EdgeClickEventParameters {}

  /**
   * Event object of the Area#edgeClick event.
   */
  export type Area$EdgeClickEvent = Event<Area$EdgeClickEventParameters, Area>;

  /**
   * Parameters of the Area#edgeContextMenu event.
   */
  export interface Area$EdgeContextMenuEventParameters {}

  /**
   * Event object of the Area#edgeContextMenu event.
   */
  export type Area$EdgeContextMenuEvent = Event<
    Area$EdgeContextMenuEventParameters,
    Area
  >;
}

declare module "sap/ui/vbm/Areas" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import Area from "sap/ui/vbm/Area";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Type specific Visual Object aggregation for Area instances.
   */
  export default class Areas extends VoAggregation {
    /**
     * Constructor for a new Areas.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AreasSettings
    );
    /**
     * Constructor for a new Areas.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AreasSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Areas with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Areas>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Areas.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Area
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeClick edgeClick} event of this `sap.ui.vbm.Areas`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Areas` itself.
     *
     * This event is raised when the edge of an Area is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Areas$EdgeClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Areas` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeClick edgeClick} event of this `sap.ui.vbm.Areas`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Areas` itself.
     *
     * This event is raised when the edge of an Area is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Areas$EdgeClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Areas` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeContextMenu edgeContextMenu} event of this
     * `sap.ui.vbm.Areas`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Areas` itself.
     *
     * This event is raised when the edge of an Area is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Areas$EdgeContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Areas` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeContextMenu edgeContextMenu} event of this
     * `sap.ui.vbm.Areas`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Areas` itself.
     *
     * This event is raised when the edge of an Area is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Areas$EdgeContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Areas` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:edgeClick edgeClick} event of this `sap.ui.vbm.Areas`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEdgeClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Areas$EdgeClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:edgeContextMenu edgeContextMenu} event of
     * this `sap.ui.vbm.Areas`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEdgeContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Areas$EdgeContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:edgeClick edgeClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEdgeClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Areas$EdgeClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:edgeContextMenu edgeContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEdgeContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Areas$EdgeContextMenuEventParameters
    ): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Area object aggregation
     */
    getItems(): Area[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.Area` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Area
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Area,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Area[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Area
    ): Area | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Areas constructor.
   */
  export interface $AreasSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Area object aggregation
     */
    items?: Area[] | Area | AggregationBindingInfo | `{${string}}`;

    /**
     * This event is raised when the edge of an Area is clicked.
     */
    edgeClick?: (oEvent: Areas$EdgeClickEvent) => void;

    /**
     * This event is raised when the edge of an Area is right clicked.
     */
    edgeContextMenu?: (oEvent: Areas$EdgeContextMenuEvent) => void;
  }

  /**
   * Parameters of the Areas#edgeClick event.
   */
  export interface Areas$EdgeClickEventParameters {
    /**
     * Clicked instance
     */
    instance?: Area;

    /**
     * The number of the edge where the click occured. Edges are numbered zero based: e.g. edge from point 1
     * to point 2 has number 0
     */
    edge?: int;
  }

  /**
   * Event object of the Areas#edgeClick event.
   */
  export type Areas$EdgeClickEvent = Event<
    Areas$EdgeClickEventParameters,
    Areas
  >;

  /**
   * Parameters of the Areas#edgeContextMenu event.
   */
  export interface Areas$EdgeContextMenuEventParameters {
    /**
     * Clicked instance
     */
    instance?: Area;

    /**
     * The number of the edge where the click occured. Edges are numbered zero based: e.g. edge from point 1
     * to point 2 has number 0
     */
    edge?: int;
  }

  /**
   * Event object of the Areas#edgeContextMenu event.
   */
  export type Areas$EdgeContextMenuEvent = Event<
    Areas$EdgeContextMenuEventParameters,
    Areas
  >;
}

declare module "sap/ui/vbm/Box" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for a Box. A Box is a rectangle, which is positioned with its centerpoint
   * at the given position. The ratio between width and height can be controlled with property scale.
   * Depending on the property fxsize a box has an absolute or relative size.
   *  Since the actual size of a box may depend on the zoom level it might be only partly visible. Thus detail
   * windows will open at the click position.
   */
  export default class Box extends VoBase {
    /**
     * Constructor for a new Box.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BoxSettings
    );
    /**
     * Constructor for a new Box.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BoxSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Box with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Box>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Box.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the box.
     *
     * Default value is `'RGB(255;0;0)'`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getColorBorder colorBorder}.
     *
     * The border color of the box.
     *
     * Default value is `'RGB(255;0;0)'`.
     *
     *
     * @returns Value of property `colorBorder`
     */
    getColorBorder(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of the Box. The format is "lon;lat;0".
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getScale scale}.
     *
     * The scale of the box. The format is "x-Scale;y-Scale;z-Scale" whereas z-Scale is currently ignored.
     *
     * Default value is `'1;1;1'`.
     *
     *
     * @returns Value of property `scale`
     */
    getScale(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the box.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(255;0;0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorBorder colorBorder}.
     *
     * The border color of the box.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(255;0;0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorBorder(
      /**
       * New value for property `colorBorder`
       */
      sColorBorder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of the Box. The format is "lon;lat;0".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getScale scale}.
     *
     * The scale of the box. The format is "x-Scale;y-Scale;z-Scale" whereas z-Scale is currently ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1;1;1'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScale(
      /**
       * New value for property `scale`
       */
      sScale?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Box constructor.
   */
  export interface $BoxSettings extends $VoBaseSettings {
    /**
     * The position of the Box. The format is "lon;lat;0".
     */
    position?: string | PropertyBindingInfo;

    /**
     * The scale of the box. The format is "x-Scale;y-Scale;z-Scale" whereas z-Scale is currently ignored.
     */
    scale?: string | PropertyBindingInfo;

    /**
     * The color of the box.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The border color of the box.
     */
    colorBorder?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/Boxes" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import Box from "sap/ui/vbm/Box";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for Box instances.
   */
  export default class Boxes extends VoAggregation {
    /**
     * Constructor for a new Boxes.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BoxesSettings
    );
    /**
     * Constructor for a new Boxes.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BoxesSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Boxes with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Boxes>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Boxes.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Box
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Box object aggregation
     */
    getItems(): Box[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Gets current value of property {@link #getScaleChangeable scaleChangeable}.
     *
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `scaleChangeable`
     */
    getScaleChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.Box` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Box
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Box,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Box[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Box
    ): Box | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getScaleChangeable scaleChangeable}.
     *
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScaleChangeable(
      /**
       * New value for property `scaleChangeable`
       */
      bScaleChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Boxes constructor.
   */
  export interface $BoxesSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    scaleChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Box object aggregation
     */
    items?: Box[] | Box | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Circle" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for an Circle. A Circle is positioned with its centerpoint at the
   * given position. The detail window will open at the center of the circle.
   */
  export default class Circle extends VoBase {
    /**
     * Constructor for a new Circle.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CircleSettings
    );
    /**
     * Constructor for a new Circle.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CircleSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Circle with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Circle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Circle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the circle.
     *
     * Default value is `'RGBA(0,0,128,128)'`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getColorBorder colorBorder}.
     *
     * The border color of the circle.
     *
     * Default value is `'RGB(0,0,0)'`.
     *
     *
     * @returns Value of property `colorBorder`
     */
    getColorBorder(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of the circle.
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getRadius radius}.
     *
     * The pixel radius of the circle.
     *
     * Default value is `'20'`.
     *
     *
     * @returns Value of property `radius`
     */
    getRadius(): string;
    /**
     * Gets current value of property {@link #getSlices slices}.
     *
     * Number of circle slices. The property is required only when the PlugIn is used.
     *
     *
     * @returns Value of property `slices`
     */
    getSlices(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the circle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGBA(0,0,128,128)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorBorder colorBorder}.
     *
     * The border color of the circle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(0,0,0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorBorder(
      /**
       * New value for property `colorBorder`
       */
      sColorBorder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of the circle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRadius radius}.
     *
     * The pixel radius of the circle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'20'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadius(
      /**
       * New value for property `radius`
       */
      sRadius?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSlices slices}.
     *
     * Number of circle slices. The property is required only when the PlugIn is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSlices(
      /**
       * New value for property `slices`
       */
      sSlices?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Circle constructor.
   */
  export interface $CircleSettings extends $VoBaseSettings {
    /**
     * The position of the circle.
     */
    position?: string | PropertyBindingInfo;

    /**
     * The pixel radius of the circle.
     */
    radius?: string | PropertyBindingInfo;

    /**
     * The color of the circle.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The border color of the circle.
     */
    colorBorder?: string | PropertyBindingInfo;

    /**
     * Number of circle slices. The property is required only when the PlugIn is used.
     */
    slices?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/Circles" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import Circle from "sap/ui/vbm/Circle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for Circle elements.
   */
  export default class Circles extends VoAggregation {
    /**
     * Constructor for a new Circles.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CirclesSettings
    );
    /**
     * Constructor for a new Circles.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CirclesSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Circles with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Circles>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Circles.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Circle
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * circle object aggregation
     */
    getItems(): Circle[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Gets current value of property {@link #getRadiusChangeable radiusChangeable}.
     *
     * Set to true if radius may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `radiusChangeable`
     */
    getRadiusChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.Circle` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Circle
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Circle,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Circle[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Circle
    ): Circle | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRadiusChangeable radiusChangeable}.
     *
     * Set to true if radius may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadiusChangeable(
      /**
       * New value for property `radiusChangeable`
       */
      bRadiusChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Circles constructor.
   */
  export interface $CirclesSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set to true if radius may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    radiusChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * circle object aggregation
     */
    items?: Circle[] | Circle | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Cluster" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SemanticType } from "sap/ui/vbm/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Cluster control to visualize clustered objects on a map. The Cluster control does not cluster anything
   * itself, instead it only shows a predefined image. The image can be configured with the properties type,
   * color, icon and text. If a text is given it is shown in the upper right corner
   * of the control with a rounded border around. With the color property any color can be chosen.
   * The type property overwrites a property color with semantic color of the type and provides
   * a particular semantic icon in the middle of the control. With the icon property an icon can be
   * defined and may overrule the semantic icon; if no icon is defined ( and no type) then the semantic icon
   * for type inactive is chosen.
   */
  export default class Cluster extends Control {
    /**
     * Constructor for a new Cluster.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterSettings
    );
    /**
     * Constructor for a new Cluster.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Cluster with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Cluster>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Cluster.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Set the color of the control. If a type is set then the semantic color of the type is taken instead.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Set the icon of the control. If a type is set then the semantic icon of the type can be overwritten with
     * this property. If no icon and no type is set then the icon for the semantic type 'inactive' is taken.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Set the text of the control.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * semantic type for cluster. The type specifies the icon and the color of the cluster control.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): SemanticType;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Set the color of the control. If a type is set then the semantic color of the type is taken instead.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Set the icon of the control. If a type is set then the semantic icon of the type can be overwritten with
     * this property. If no icon and no type is set then the icon for the semantic type 'inactive' is taken.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Set the text of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * semantic type for cluster. The type specifies the icon and the color of the cluster control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: SemanticType | keyof typeof SemanticType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Cluster constructor.
   */
  export interface $ClusterSettings extends $ControlSettings {
    /**
     * Set the color of the control. If a type is set then the semantic color of the type is taken instead.
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the icon of the control. If a type is set then the semantic icon of the type can be overwritten with
     * this property. If no icon and no type is set then the icon for the semantic type 'inactive' is taken.
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Set the text of the control.
     */
    text?: string | PropertyBindingInfo;

    /**
     * semantic type for cluster. The type specifies the icon and the color of the cluster control.
     */
    type?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vbm/ClusterBase" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Control from "sap/ui/core/Control";

  import Spot from "sap/ui/vbm/Spot";

  import ClusterContainer from "sap/ui/vbm/ClusterContainer";

  import Menu from "sap/ui/unified/Menu";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Abtract base class for Clustering types. This element implements the common part for all specific Cluster
   * elements. It must not be used directly, but is the base for further extension.
   *  There are two optional aggregations: `vizTemplate` and `vizVo` determining how cluster objects should
   * be visualized. Only the one or the other should be provided.
   *  With aggregation `vizTemplate` you can provide an arbitrary SAPUI5 control for the actual visualization.
   * If you want this control to display the number of clustered object you need to provide the name of the
   * receiving property of the template via property `textProperty`. For interaction with the cluster you
   * can either use the events provided by the visualization template or, if it does not provide appropriate
   * events, the cluster element events `click` and `contextMenu`. The event handler will receive an instance
   * of `sap.ui.vbm.ClusterContainer`.
   *  With aggregation `vizVo` you provide an instance of `sap.ui.vbm.Spot` as visualization object. Spots
   * are based on an image. The text for the number of clustered objects needs to be placed over the image.
   * The actual color, font, size, and positioning of the text can be influence via property `textSettings`.
   * For interaction with the cluster you can use the events provided by the spot.
   */
  export default class ClusterBase extends UI5Element {
    /**
     * Constructor for a new ClusterBase.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterBaseSettings
    );
    /**
     * Constructor for a new ClusterBase.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterBaseSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ClusterBase with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClusterBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ClusterBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.ClusterBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ClusterBase` itself.
     *
     * The event is raised when there is a click action on a Cluster Object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ClusterBase$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ClusterBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.ClusterBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ClusterBase` itself.
     *
     * The event is raised when there is a click action on a Cluster Object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ClusterBase$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ClusterBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.ClusterBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ClusterBase` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a Cluster.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ClusterBase$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ClusterBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.ClusterBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ClusterBase` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a Cluster.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ClusterBase$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ClusterBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the vizTemplate in the aggregation {@link #getVizTemplate vizTemplate}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVizTemplate(): this;
    /**
     * Destroys the vizVo in the aggregation {@link #getVizVo vizVo}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVizVo(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.ClusterBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ClusterBase$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.ClusterBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ClusterBase$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ClusterBase$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ClusterBase$ContextMenuEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAreaAlwaysVisible areaAlwaysVisible}.
     *
     * Flag controlling the visibility of the area convered by a cluster object.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `areaAlwaysVisible`
     */
    getAreaAlwaysVisible(): boolean;
    /**
     * Gets current value of property {@link #getAreaColor areaColor}.
     *
     * Fill color for the area covered by a cluster object
     *
     * Default value is `"rgba(200,0,0,0.2)"`.
     *
     *
     * @returns Value of property `areaColor`
     */
    getAreaColor(): CSSColor;
    /**
     * Gets current value of property {@link #getAreaColorBorder areaColorBorder}.
     *
     * Border color for the area covered by a cluster object
     *
     * Default value is `"rgba(220,220,220,0.5)"`.
     *
     *
     * @returns Value of property `areaColorBorder`
     */
    getAreaColorBorder(): CSSColor;
    /**
     * Gets current value of property {@link #getRule rule}.
     *
     * Clustering rule, describing which visual objects should be considered for clustering
     *
     *
     * @returns Value of property `rule`
     */
    getRule(): string;
    /**
     * Gets current value of property {@link #getTextProperty textProperty}.
     *
     * Name of property of the visualization control receiving the number of clustered objects. This setting
     * applys only if aggregation vizTemplate is used.
     *
     * Default value is `"text"`.
     *
     *
     * @returns Value of property `textProperty`
     */
    getTextProperty(): string;
    /**
     * Gets current value of property {@link #getTextSettings textSettings}.
     *
     * Settings for the text placed on the given Spot telling the number of clustered objects. This setting
     * applys only if aggregation vizVo is used. If omitted the number of clustered object will **not** be shown!
     *
     *
     * @returns Value of property `textSettings`
     */
    getTextSettings(): object;
    /**
     * Gets content of aggregation {@link #getVizTemplate vizTemplate}.
     *
     * Optional: Instance of a control, which is used as template for visualizing cluster objects. This is the
     * prefered choise.
     */
    getVizTemplate(): Control;
    /**
     * Gets content of aggregation {@link #getVizVo vizVo}.
     *
     * Optional: Instance of a spot, which is used as template for visualizing cluster objects
     */
    getVizVo(): Spot;
    /**
     * Open a context menu
     */
    openContextMenu(
      /**
       * Type of VO
       */
      sType: string,
      /**
       * VO instance for which the Context Menu should be opened
       */
      oContainer: ClusterContainer,
      /**
       * the context menu to be opened
       */
      oMenu: Menu
    ): void;
    /**
     * Open a Detail Window. This function can only be used with a Spot as Cluster visualization object!
     */
    openDetailWindow(
      /**
       * Spot instance for which the Detail Window should be opened
       */
      oSpotInst: Spot,
      /**
       * Parameter object
       */
      oParams: {
        /**
         * Text for Detail Window caption
         */
        caption: string;
        /**
         * position offset in x-direction from the anchor point
         */
        offsetX: string;
        /**
         * position offset in y-direction from the anchor point
         */
        offsetY: string;
      }
    ): void;
    /**
     * Sets a new value for property {@link #getAreaAlwaysVisible areaAlwaysVisible}.
     *
     * Flag controlling the visibility of the area convered by a cluster object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAreaAlwaysVisible(
      /**
       * New value for property `areaAlwaysVisible`
       */
      bAreaAlwaysVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAreaColor areaColor}.
     *
     * Fill color for the area covered by a cluster object
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(200,0,0,0.2)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAreaColor(
      /**
       * New value for property `areaColor`
       */
      sAreaColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getAreaColorBorder areaColorBorder}.
     *
     * Border color for the area covered by a cluster object
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(220,220,220,0.5)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAreaColorBorder(
      /**
       * New value for property `areaColorBorder`
       */
      sAreaColorBorder?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getRule rule}.
     *
     * Clustering rule, describing which visual objects should be considered for clustering
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRule(
      /**
       * New value for property `rule`
       */
      sRule?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextProperty textProperty}.
     *
     * Name of property of the visualization control receiving the number of clustered objects. This setting
     * applys only if aggregation vizTemplate is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"text"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextProperty(
      /**
       * New value for property `textProperty`
       */
      sTextProperty?: string
    ): this;
    /**
     * Set the settings for the text placed on the Spot for number of clustered objects
     *
     *
     * @returns this To allow method chaining
     */
    setTextSettings(
      /**
       * Settings object
       */
      oSettings: object
    ): undefined;
    /**
     * Sets the aggregated {@link #getVizTemplate vizTemplate}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVizTemplate(
      /**
       * The vizTemplate to set
       */
      oVizTemplate: Control
    ): this;
    /**
     * Sets the aggregated {@link #getVizVo vizVo}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVizVo(
      /**
       * The vizVo to set
       */
      oVizVo: Spot
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ClusterBase constructor.
   */
  export interface $ClusterBaseSettings extends $ElementSettings {
    /**
     * Flag controlling the visibility of the area convered by a cluster object.
     */
    areaAlwaysVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Fill color for the area covered by a cluster object
     */
    areaColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Border color for the area covered by a cluster object
     */
    areaColorBorder?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of property of the visualization control receiving the number of clustered objects. This setting
     * applys only if aggregation vizTemplate is used.
     */
    textProperty?: string | PropertyBindingInfo;

    /**
     * Settings for the text placed on the given Spot telling the number of clustered objects. This setting
     * applys only if aggregation vizVo is used. If omitted the number of clustered object will **not** be shown!
     */
    textSettings?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Clustering rule, describing which visual objects should be considered for clustering
     */
    rule?: string | PropertyBindingInfo;

    /**
     * Optional: Instance of a control, which is used as template for visualizing cluster objects. This is the
     * prefered choise.
     */
    vizTemplate?: Control;

    /**
     * Optional: Instance of a spot, which is used as template for visualizing cluster objects
     */
    vizVo?: Spot;

    /**
     * The event is raised when there is a click action on a Cluster Object.
     */
    click?: (oEvent: ClusterBase$ClickEvent) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a Cluster.
     */
    contextMenu?: (oEvent: ClusterBase$ContextMenuEvent) => void;
  }

  /**
   * Parameters of the ClusterBase#click event.
   */
  export interface ClusterBase$ClickEventParameters {
    /**
     * ID of the clicked cluster object. Can serve as input for GeoMap function getInfoForCluster
     */
    clusterID?: string;
  }

  /**
   * Event object of the ClusterBase#click event.
   */
  export type ClusterBase$ClickEvent = Event<
    ClusterBase$ClickEventParameters,
    ClusterBase
  >;

  /**
   * Parameters of the ClusterBase#contextMenu event.
   */
  export interface ClusterBase$ContextMenuEventParameters {
    /**
     * ID of the clicked cluster object. Can serve as input for GeoMap function getInfoForCluster
     */
    clusterID?: string;

    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the ClusterBase#contextMenu event.
   */
  export type ClusterBase$ContextMenuEvent = Event<
    ClusterBase$ContextMenuEventParameters,
    ClusterBase
  >;
}

declare module "sap/ui/vbm/ClusterContainer" {
  import {
    default as Container,
    $ContainerSettings,
  } from "sap/ui/vbm/Container";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Specific Visual Object element acting as a container for cluster visualization objects. A ClusterContainer
   * is positioned at a calculated position on the map. It aggregates a visualization controls, which will
   * then move with the map.
   *  **Since a ClusterContainer is not a real visual object most features borrowed from VoBase and
   * event Container will not work. There is no label, no edit mode, and no drop support. Events like
   * click may only be fired if the aggregated control is not handling them. The properties are not changeable
   * as well as the aggregated item. Only read access is possible**
   */
  export default class ClusterContainer extends Container {
    /**
     * Constructor for a new ClusterContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vbm.Container#constructor sap.ui.vbm.Container }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterContainerSettings
    );
    /**
     * Constructor for a new ClusterContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vbm.Container#constructor sap.ui.vbm.Container }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ClusterContainer with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.Container.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClusterContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ClusterContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the ClusterContainer constructor.
   */
  export interface $ClusterContainerSettings extends $ContainerSettings {}
}

declare module "sap/ui/vbm/ClusterDistance" {
  import {
    default as ClusterBase,
    $ClusterBaseSettings,
  } from "sap/ui/vbm/ClusterBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Cluster definition element for distance based clusters. Visual objects are clustered based on the visible
   * distance between them. Objects get aggregated to a cluster object as long as they are inside the given
   * distance range to the start object. The start object for a cluster is not specifically defined, just
   * the next object not belonging to a cluster is taken. The visualization objects are placed in the center
   * of gravity of the covered objects. Thus the actual distance between them may vary.
   *  This clustering is fast, but the results may not be very convincing.
   */
  export default class ClusterDistance extends ClusterBase {
    /**
     * Constructor for a new ClusterDistance.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterDistanceSettings
    );
    /**
     * Constructor for a new ClusterDistance.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterDistanceSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ClusterDistance with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.ClusterBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClusterDistance>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ClusterDistance.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDistance distance}.
     *
     * Distance in pixels between cluster objects. This distance is used as parameter during the clustering.
     * The visualization objects are placed in center of gravity of the covered objects. Thus the actual distance
     * between them may vary.
     *
     * Default value is `"128"`.
     *
     *
     * @returns Value of property `distance`
     */
    getDistance(): int;
    /**
     * Sets a new value for property {@link #getDistance distance}.
     *
     * Distance in pixels between cluster objects. This distance is used as parameter during the clustering.
     * The visualization objects are placed in center of gravity of the covered objects. Thus the actual distance
     * between them may vary.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"128"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDistance(
      /**
       * New value for property `distance`
       */
      iDistance?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ClusterDistance constructor.
   */
  export interface $ClusterDistanceSettings extends $ClusterBaseSettings {
    /**
     * Distance in pixels between cluster objects. This distance is used as parameter during the clustering.
     * The visualization objects are placed in center of gravity of the covered objects. Thus the actual distance
     * between them may vary.
     */
    distance?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/ClusterGrid" {
  import {
    default as ClusterBase,
    $ClusterBaseSettings,
  } from "sap/ui/vbm/ClusterBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Cluster definition element for grid based clusters. Visual objects are clustered based on a grid. It
   * is possible to have multiple grid based clusters. The visualization object is placed in the center of
   * the grid cell plus a given offset.
   */
  export default class ClusterGrid extends ClusterBase {
    /**
     * Constructor for a new ClusterGrid.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterGridSettings
    );
    /**
     * Constructor for a new ClusterGrid.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterGridSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ClusterGrid with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.ClusterBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClusterGrid>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ClusterGrid.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCellSpacing cellSpacing}.
     *
     * Space between grid cells if cell area is shown
     *
     * Default value is `"4"`.
     *
     *
     * @returns Value of property `cellSpacing`
     */
    getCellSpacing(): int;
    /**
     * Gets current value of property {@link #getGridSize gridSize}.
     *
     * Size of grid cells in pixels. Format is "distanceX;distanceY"
     *
     * Default value is `"256;256"`.
     *
     *
     * @returns Value of property `gridSize`
     */
    getGridSize(): string;
    /**
     * Gets current value of property {@link #getLimit limit}.
     *
     * Minimal number of objects covered by grid cell fullfilling the cluster rule until clustering is applied.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `limit`
     */
    getLimit(): int;
    /**
     * Gets current value of property {@link #getLimitTotal limitTotal}.
     *
     * Minimal total number of objects covered by grid cell until clustering is applied.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `limitTotal`
     */
    getLimitTotal(): int;
    /**
     * Gets current value of property {@link #getOffset offset}.
     *
     * Offset for the visualization object from the center of the grid cell. This can be used to show multiple
     * visualization objects in on grid cell without overlapping. Format is "offsetX;offsetY"
     *
     * Default value is `"0;0"`.
     *
     *
     * @returns Value of property `offset`
     */
    getOffset(): string;
    /**
     * Gets current value of property {@link #getOrderIndex orderIndex}.
     *
     * Ordering index of given cluster in the sequence of all grid based clusters
     *
     *
     * @returns Value of property `orderIndex`
     */
    getOrderIndex(): int;
    /**
     * Sets a new value for property {@link #getCellSpacing cellSpacing}.
     *
     * Space between grid cells if cell area is shown
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"4"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCellSpacing(
      /**
       * New value for property `cellSpacing`
       */
      iCellSpacing?: int
    ): this;
    /**
     * Sets a new value for property {@link #getGridSize gridSize}.
     *
     * Size of grid cells in pixels. Format is "distanceX;distanceY"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"256;256"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGridSize(
      /**
       * New value for property `gridSize`
       */
      sGridSize?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLimit limit}.
     *
     * Minimal number of objects covered by grid cell fullfilling the cluster rule until clustering is applied.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLimit(
      /**
       * New value for property `limit`
       */
      iLimit?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLimitTotal limitTotal}.
     *
     * Minimal total number of objects covered by grid cell until clustering is applied.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLimitTotal(
      /**
       * New value for property `limitTotal`
       */
      iLimitTotal?: int
    ): this;
    /**
     * Sets a new value for property {@link #getOffset offset}.
     *
     * Offset for the visualization object from the center of the grid cell. This can be used to show multiple
     * visualization objects in on grid cell without overlapping. Format is "offsetX;offsetY"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0;0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOffset(
      /**
       * New value for property `offset`
       */
      sOffset?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOrderIndex orderIndex}.
     *
     * Ordering index of given cluster in the sequence of all grid based clusters
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOrderIndex(
      /**
       * New value for property `orderIndex`
       */
      iOrderIndex?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ClusterGrid constructor.
   */
  export interface $ClusterGridSettings extends $ClusterBaseSettings {
    /**
     * Size of grid cells in pixels. Format is "distanceX;distanceY"
     */
    gridSize?: string | PropertyBindingInfo;

    /**
     * Minimal number of objects covered by grid cell fullfilling the cluster rule until clustering is applied.
     */
    limit?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Minimal total number of objects covered by grid cell until clustering is applied.
     */
    limitTotal?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Ordering index of given cluster in the sequence of all grid based clusters
     */
    orderIndex?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Offset for the visualization object from the center of the grid cell. This can be used to show multiple
     * visualization objects in on grid cell without overlapping. Format is "offsetX;offsetY"
     */
    offset?: string | PropertyBindingInfo;

    /**
     * Space between grid cells if cell area is shown
     */
    cellSpacing?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/ClusterTree" {
  import {
    default as ClusterBase,
    $ClusterBaseSettings,
  } from "sap/ui/vbm/ClusterBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Cluster definition element for tree clusters. Complex clustering based on Voronoi diagrams. The actual
   * clustering is based on the areas in the Voronoi diagram and cluster objects get aggregated to a hierarchy
   * over several levels of detail.
   */
  export default class ClusterTree extends ClusterBase {
    /**
     * Constructor for a new ClusterTree.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterTreeSettings
    );
    /**
     * Constructor for a new ClusterTree.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterTreeSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ClusterTree with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.ClusterBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClusterTree>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ClusterTree.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAnimateClusterSplit animateClusterSplit}.
     *
     * Indicates whether the split of a cluster object into sub clusterers or visual objects should be animated
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `animateClusterSplit`
     */
    getAnimateClusterSplit(): boolean;
    /**
     * Sets a new value for property {@link #getAnimateClusterSplit animateClusterSplit}.
     *
     * Indicates whether the split of a cluster object into sub clusterers or visual objects should be animated
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnimateClusterSplit(
      /**
       * New value for property `animateClusterSplit`
       */
      bAnimateClusterSplit?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ClusterTree constructor.
   */
  export interface $ClusterTreeSettings extends $ClusterBaseSettings {
    /**
     * Indicates whether the split of a cluster object into sub clusterers or visual objects should be animated
     */
    animateClusterSplit?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Container" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element acting as a container for other controls. A Container is positioned at
   * the given position on the map. It can aggregate other controls, which will then move with the map.
   *  **Since a Container is not a real visual object most features borrowed from VoBase will not work.
   * There is no label, no edit mode, and no drop support. Events like click will only be fired if the aggregated
   * control is not handling them.**
   */
  export default class Container extends VoBase {
    /**
     * Constructor for a new Container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerSettings
    );
    /**
     * Constructor for a new Container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Container with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Container>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Container.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the item in the aggregation {@link #getItem item}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItem(): this;
    /**
     * Gets current value of property {@link #getAlignment alignment}.
     *
     * Alignment of the container to its position:
     * 	0: center 1: top center 2: top right 3: center right 4: bottom right 5: bottom center
     * 6: bottom left 7: center left 8: top left
     *
     * Default value is `'0'`.
     *
     *
     * @returns Value of property `alignment`
     */
    getAlignment(): string;
    /**
     * Gets content of aggregation {@link #getItem item}.
     *
     * The control that should be placed in the container.
     */
    getItem(): Control;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position for the Container. The format is "lon;lat;0".
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Sets a new value for property {@link #getAlignment alignment}.
     *
     * Alignment of the container to its position:
     * 	0: center 1: top center 2: top right 3: center right 4: bottom right 5: bottom center
     * 6: bottom left 7: center left 8: top left
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAlignment(
      /**
       * New value for property `alignment`
       */
      sAlignment?: string
    ): this;
    /**
     * Sets the aggregated {@link #getItem item}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItem(
      /**
       * The item to set
       */
      oItem: Control
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position for the Container. The format is "lon;lat;0".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Container constructor.
   */
  export interface $ContainerSettings extends $VoBaseSettings {
    /**
     * The position for the Container. The format is "lon;lat;0".
     */
    position?: string | PropertyBindingInfo;

    /**
     * Alignment of the container to its position:
     * 	0: center 1: top center 2: top right 3: center right 4: bottom right 5: bottom center
     * 6: bottom left 7: center left 8: top left
     */
    alignment?: string | PropertyBindingInfo;

    /**
     * The control that should be placed in the container.
     */
    item?: Control;
  }
}

declare module "sap/ui/vbm/ContainerBase" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID } from "sap/ui/core/library";

  import ContainerContent from "sap/ui/vbm/ContainerContent";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Abstract Constructor for a new Container.
   *
   * @since 1.38.0
   */
  export default class ContainerBase extends Control {
    /**
     * Abstract Constructor for a new Container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerBaseSettings
    );
    /**
     * Abstract Constructor for a new Container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerBaseSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ContainerBase with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContainerBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ContainerBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * adjusts customizable buttons of overflow toolbar, displays content buttons
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _addToolbarContent(): void;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * add container content - map, table..
     */
    addContent(
      /**
       * content object to add
       */
      oObject: ContainerContent
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChange contentChange} event of this `sap.ui.vbm.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContainerBase$ContentChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChange contentChange} event of this `sap.ui.vbm.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContainerBase$ContentChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:settingsPressed settingsPressed} event of this
     * `sap.ui.vbm.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSettingsPressed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:settingsPressed settingsPressed} event of this
     * `sap.ui.vbm.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSettingsPressed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChange contentChange} event of this
     * `sap.ui.vbm.ContainerBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContainerBase$ContentChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:settingsPressed settingsPressed} event of
     * this `sap.ui.vbm.ContainerBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSettingsPressed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contentChange contentChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContainerBase$ContentChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:settingsPressed settingsPressed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSettingsPressed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getAutoAdjustHeight autoAdjustHeight}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `autoAdjustHeight`
     */
    getAutoAdjustHeight(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Content Aggregation.
     */
    getContent(): ContainerContent[];
    /**
     * Gets current value of property {@link #getFullScreen fullScreen}.
     *
     * Controls whether the control is show fullscreen or embedded
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `fullScreen`
     */
    getFullScreen(): boolean;
    /**
     * get selected content
     *
     *
     * @returns the currently selected content container
     */
    getSelectedContent(): ContainerContent;
    /**
     * Gets current value of property {@link #getShowFullScreen showFullScreen}.
     *
     * Show fullscreen toggle button in toolbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showFullScreen`
     */
    getShowFullScreen(): boolean;
    /**
     * Gets current value of property {@link #getShowSelection showSelection}.
     *
     * Show selection button in toolbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showSelection`
     */
    getShowSelection(): boolean;
    /**
     * Gets current value of property {@link #getShowSettings showSettings}.
     *
     * Show settings button in toolbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showSettings`
     */
    getShowSettings(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title to show in toolbar
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Checks for the provided `sap.ui.vbm.ContainerContent` in the aggregation {@link #getContent content}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: ContainerContent
    ): int;
    /**
     * insert container content - map, table..
     */
    insertContent(
      /**
       * content object to insert
       */
      oObject: ContainerContent,
      /**
       * index in the content aggregation where to insert the new content object
       */
      iIndex: int
    ): void;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): ContainerContent[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | ContainerContent
    ): ContainerContent | null;
    /**
     * Sets a new value for property {@link #getAutoAdjustHeight autoAdjustHeight}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAutoAdjustHeight(
      /**
       * New value for property `autoAdjustHeight`
       */
      bAutoAdjustHeight?: boolean
    ): this;
    /**
     * set FullScreen - default is normal mode, but app can call this method to set the default to full screen
     */
    setFullScreen(
      /**
       * Fullscreen mode on or off
       */
      bFullScreen: boolean
    ): void;
    /**
     * set selected content
     */
    setSelectedContent(
      /**
       * the selected content; involves no re-rendering
       */
      oContent: ContainerContent
    ): void;
    /**
     * Sets a new value for property {@link #getShowFullScreen showFullScreen}.
     *
     * Show fullscreen toggle button in toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFullScreen(
      /**
       * New value for property `showFullScreen`
       */
      bShowFullScreen?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSelection showSelection}.
     *
     * Show selection button in toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSelection(
      /**
       * New value for property `showSelection`
       */
      bShowSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSettings showSettings}.
     *
     * Show settings button in toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSettings(
      /**
       * New value for property `showSettings`
       */
      bShowSettings?: boolean
    ): this;
    /**
     * Display title
     */
    setTitle(
      /**
       * the title
       */
      sValue: string
    ): void;
    /**
     * default Content could be defined in application
     */
    switchContent(
      /**
       * the content to be visible; involves re-rendering
       */
      oContent: ContainerContent
    ): void;
    /**
     * update container to allow dynamic change button layout
     */
    updateContainer(): void;
  }
  /**
   * Describes the settings that can be provided to the ContainerBase constructor.
   */
  export interface $ContainerBaseSettings extends $ControlSettings {
    /**
     * Show fullscreen toggle button in toolbar
     */
    showFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show settings button in toolbar
     */
    showSettings?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show selection button in toolbar
     */
    showSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the control is show fullscreen or embedded
     */
    fullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Title to show in toolbar
     */
    title?: string | PropertyBindingInfo;

    autoAdjustHeight?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Content Aggregation.
     */
    content?:
      | ContainerContent[]
      | ContainerContent
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledBy).
     */
    ariaLabelledBy?: Array<Control | string>;

    contentChange?: (oEvent: ContainerBase$ContentChangeEvent) => void;

    settingsPressed?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ContainerBase#contentChange event.
   */
  export interface ContainerBase$ContentChangeEventParameters {
    selectedItemId?: string;
  }

  /**
   * Event object of the ContainerBase#contentChange event.
   */
  export type ContainerBase$ContentChangeEvent = Event<
    ContainerBase$ContentChangeEventParameters,
    ContainerBase
  >;

  /**
   * Parameters of the ContainerBase#settingsPressed event.
   */
  export interface ContainerBase$SettingsPressedEventParameters {}

  /**
   * Event object of the ContainerBase#settingsPressed event.
   */
  export type ContainerBase$SettingsPressedEvent = Event<
    ContainerBase$SettingsPressedEventParameters,
    ContainerBase
  >;
}

declare module "sap/ui/vbm/ContainerContent" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Aggregation element for the Container Base
   *
   * @since 1.38.0
   */
  export default class ContainerContent extends Control {
    /**
     * Constructor for a new ContainerContent.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerContentSettings
    );
    /**
     * Constructor for a new ContainerContent.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerContentSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ContainerContent with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContainerContent>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ContainerContent.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     */
    getContent(): Control;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon to show up in the toolbar
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title for the icon in the toolbar
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets the aggregated {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * The content to set
       */
      oContent: Control
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon to show up in the toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title for the icon in the toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContainerContent constructor.
   */
  export interface $ContainerContentSettings extends $ControlSettings {
    /**
     * Icon to show up in the toolbar
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Title for the icon in the toolbar
     */
    title?: string | PropertyBindingInfo;

    content?: Control;
  }
}

declare module "sap/ui/vbm/ContainerLegendItem" {
  import {
    default as StandardListItem,
    $StandardListItemSettings,
  } from "sap/m/StandardListItem";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SemanticType } from "sap/ui/vbm/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Legend item control
   *
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class ContainerLegendItem extends StandardListItem {
    /**
     * Constructor for a new ContainerLegendItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerLegendItemSettings
    );
    /**
     * Constructor for a new ContainerLegendItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerLegendItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ContainerLegendItem with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.StandardListItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContainerLegendItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ContainerLegendItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * show color square
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Gets current value of property {@link #getSemanticSpotType semanticSpotType}.
     *
     * The semantic spot type for the legend marker.
     *
     *
     * @returns Value of property `semanticSpotType`
     */
    getSemanticSpotType(): SemanticType;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * show color square
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticSpotType semanticSpotType}.
     *
     * The semantic spot type for the legend marker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticSpotType(
      /**
       * New value for property `semanticSpotType`
       */
      sSemanticSpotType?: SemanticType | keyof typeof SemanticType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContainerLegendItem constructor.
   *
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $ContainerLegendItemSettings
    extends $StandardListItemSettings {
    /**
     * show color square
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The semantic spot type for the legend marker.
     */
    semanticSpotType?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Containers" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import Container from "sap/ui/vbm/Container";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for Container instances.
   */
  export default class Containers extends VoAggregation {
    /**
     * Constructor for a new Containers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainersSettings
    );
    /**
     * Constructor for a new Containers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainersSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Containers with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Containers>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Containers.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Container
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Container object aggregation
     */
    getItems(): Container[];
    /**
     * Checks for the provided `sap.ui.vbm.Container` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Container
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Container,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Container[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Container
    ): Container | null;
  }
  /**
   * Describes the settings that can be provided to the Containers constructor.
   */
  export interface $ContainersSettings extends $VoAggregationSettings {
    /**
     * Container object aggregation
     */
    items?: Container[] | Container | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/DragSource" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * DragSource Aggregation element
   */
  export default class DragSource extends UI5Element {
    /**
     * Constructor for a new DragSource.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DragSourceSettings
    );
    /**
     * Constructor for a new DragSource.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DragSourceSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.DragSource with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DragSource>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.DragSource.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Drag type
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Drag type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DragSource constructor.
   */
  export interface $DragSourceSettings extends $ElementSettings {
    /**
     * Drag type
     */
    type?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/DropTarget" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * DropTarget Aggregation element
   */
  export default class DropTarget extends UI5Element {
    /**
     * Constructor for a new DropTarget.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DropTargetSettings
    );
    /**
     * Constructor for a new DropTarget.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DropTargetSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.DropTarget with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DropTarget>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.DropTarget.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Drop type
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Drop type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DropTarget constructor.
   */
  export interface $DropTargetSettings extends $ElementSettings {
    /**
     * Drop type
     */
    type?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/Feature" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Menu from "sap/ui/unified/Menu";

  /**
   * The Feature element can be added to the items aggregation of a FeatureCollection. By matching
   * the id it allows to redefine the color of a GeoJSON feature and adds interactivity.
   */
  export default class Feature extends UI5Element {
    /**
     * Constructor for a new Feature.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FeatureSettings
    );
    /**
     * Constructor for a new Feature.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FeatureSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Feature with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Feature>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Feature.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Feature`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Feature` itself.
     *
     * The event is raised when there is a click action on a Feature.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Feature` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Feature`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Feature` itself.
     *
     * The event is raised when there is a click action on a Feature.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Feature` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Feature`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Feature` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a Feature.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Feature$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Feature` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Feature`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Feature` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a Feature.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Feature$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Feature` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.Feature`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Feature`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Feature$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Feature$ContextMenuEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color, this should be provided in the rgba(r,g,b,a) format.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Gets current value of property {@link #getFeatureId featureId}.
     *
     * The Feature ID. Used to match with the feature in the GeoJSON given to the parent (FeatureCollection).
     *
     *
     * @returns Value of property `featureId`
     */
    getFeatureId(): string;
    /**
     * Open the context menu
     */
    openContextMenu(
      /**
       * the context menu to be opened
       */
      oMenu: object
    ): void;
    /**
     * Open a Detail Window for the Feature at click position
     */
    openDetailWindow(
      /**
       * caption of detail window
       */
      sCaption: string,
      /**
       * position offset in x-direction from the anchor point
       */
      sOffsetX: string,
      /**
       * position offset in y-direction from the anchor point
       */
      sOffsetY: string
    ): void;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color, this should be provided in the rgba(r,g,b,a) format.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getFeatureId featureId}.
     *
     * The Feature ID. Used to match with the feature in the GeoJSON given to the parent (FeatureCollection).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFeatureId(
      /**
       * New value for property `featureId`
       */
      sFeatureId?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Feature constructor.
   */
  export interface $FeatureSettings extends $ElementSettings {
    /**
     * The color, this should be provided in the rgba(r,g,b,a) format.
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The Feature ID. Used to match with the feature in the GeoJSON given to the parent (FeatureCollection).
     */
    featureId?: string | PropertyBindingInfo;

    /**
     * The event is raised when there is a click action on a Feature.
     */
    click?: (oEvent: Event) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a Feature.
     */
    contextMenu?: (oEvent: Feature$ContextMenuEvent) => void;
  }

  /**
   * Parameters of the Feature#click event.
   */
  export interface Feature$ClickEventParameters {}

  /**
   * Event object of the Feature#click event.
   */
  export type Feature$ClickEvent = Event<Feature$ClickEventParameters, Feature>;

  /**
   * Parameters of the Feature#contextMenu event.
   */
  export interface Feature$ContextMenuEventParameters {
    /**
     * Menu object to be used with openContextMenu().
     */
    menu?: Menu;
  }

  /**
   * Event object of the Feature#contextMenu event.
   */
  export type Feature$ContextMenuEvent = Event<
    Feature$ContextMenuEventParameters,
    Feature
  >;
}

declare module "sap/ui/vbm/FeatureCollection" {
  import {
    default as GeoJsonLayer,
    $GeoJsonLayerSettings,
    GeoJsonLayer$ClickEventParameters,
    GeoJsonLayer$ContextMenuEventParameters,
  } from "sap/ui/vbm/GeoJsonLayer";

  import Feature from "sap/ui/vbm/Feature";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * FeatureCollection aggregation container. A FeatureCollection can render the content of an assigned GeoJSON.
   * The naming is associated to the GeoJSON standard. All features found in the GeoJSON are rendered as separated
   * objects. From the possible feature types only
   * 	Polygon and Multipolygon  are supported so far. The feature type support will be extended in
   * the upcoming releases.
   *  All features from the GeoJSON will be rendered with the given default colors and are inactive. They
   * do not react on mouse over, except with tooltip, or raise any events on click or right click.
   *  By adding Feature elements to the items aggregation you can make the match (by id) feature from
   * the GeoJSON interactive and give it alternative colors.
   */
  export default class FeatureCollection extends GeoJsonLayer {
    /**
     * Constructor for a new FeatureCollection.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FeatureCollectionSettings
    );
    /**
     * Constructor for a new FeatureCollection.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FeatureCollectionSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.FeatureCollection with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.GeoJsonLayer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FeatureCollection>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.FeatureCollection.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Feature
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.FeatureCollection`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.FeatureCollection` itself.
     *
     * The event is raised when there is a click action on an aggregated Feature. Clicks on other Features from
     * the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeatureCollection$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.FeatureCollection` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.FeatureCollection`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.FeatureCollection` itself.
     *
     * The event is raised when there is a click action on an aggregated Feature. Clicks on other Features from
     * the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeatureCollection$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.FeatureCollection` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.FeatureCollection`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.FeatureCollection` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on an aggregated Feature. Clicks
     * on other Features from the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeatureCollection$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.FeatureCollection` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.FeatureCollection`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.FeatureCollection` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on an aggregated Feature. Clicks
     * on other Features from the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeatureCollection$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.FeatureCollection` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.FeatureCollection`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FeatureCollection$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.FeatureCollection`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FeatureCollection$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FeatureCollection$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FeatureCollection$ContextMenuEventParameters
    ): this;
    /**
     * Returns Properties for Features like name, bounding box, and midpoint
     *
     *
     * @returns Array of Feature Information Objects. Each object in the array has the properties BBox: Bounding
     * Box for the Feature in format "lonMin;latMin;lonMax;latMax", Midpoint: Centerpoint for Feature in format
     * "lon;lat", Name: Name of the Feature, and Properties: Array of name-value-pairs associated with the Feature
     */
    getFeaturesInfo(
      /**
       * Array of Feature Ids. The Feature Id must match the GeoJSON tag.
       */
      aFeatureIds: string[]
    ): any[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Feature object aggregation
     */
    getItems(): Feature[];
    /**
     * Checks for the provided `sap.ui.vbm.Feature` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Feature
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Feature,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Feature[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Feature
    ): Feature | null;
  }
  /**
   * Describes the settings that can be provided to the FeatureCollection constructor.
   */
  export interface $FeatureCollectionSettings extends $GeoJsonLayerSettings {
    /**
     * Feature object aggregation
     */
    items?: Feature[] | Feature | AggregationBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click action on an aggregated Feature. Clicks on other Features from
     * the GeoJSON are ignored.
     */
    click?: (oEvent: FeatureCollection$ClickEvent) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on an aggregated Feature. Clicks
     * on other Features from the GeoJSON are ignored.
     */
    contextMenu?: (oEvent: FeatureCollection$ContextMenuEvent) => void;
  }

  /**
   * Parameters of the FeatureCollection#click event.
   */
  export interface FeatureCollection$ClickEventParameters
    extends GeoJsonLayer$ClickEventParameters {}

  /**
   * Event object of the FeatureCollection#click event.
   */
  export type FeatureCollection$ClickEvent = Event<
    FeatureCollection$ClickEventParameters,
    FeatureCollection
  >;

  /**
   * Parameters of the FeatureCollection#contextMenu event.
   */
  export interface FeatureCollection$ContextMenuEventParameters
    extends GeoJsonLayer$ContextMenuEventParameters {}

  /**
   * Event object of the FeatureCollection#contextMenu event.
   */
  export type FeatureCollection$ContextMenuEvent = Event<
    FeatureCollection$ContextMenuEventParameters,
    FeatureCollection
  >;
}

declare module "sap/ui/vbm/GeoCircle" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for a GeoCircle. A GeoCircle is positioned with its centerpoint
   * at the given position. Since the actual size of a geocircle may depend on the zoom level it might
   * be only partly visible. Thus detail windows will open at the click position.
   */
  export default class GeoCircle extends VoBase {
    /**
     * Constructor for a new GeoCircle.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoCircleSettings
    );
    /**
     * Constructor for a new GeoCircle.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoCircleSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.GeoCircle with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GeoCircle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.GeoCircle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the geocirle.
     *
     * Default value is `'RGB(0,0,0)'`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getColorBorder colorBorder}.
     *
     * The border color of the geocirle.
     *
     * Default value is `'RGB(0,0,0)'`.
     *
     *
     * @returns Value of property `colorBorder`
     */
    getColorBorder(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of the geocircle. The format is "lon;lat;0".
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getRadius radius}.
     *
     * The radius in meters of the geocirle.
     *
     * Default value is `'10000'`.
     *
     *
     * @returns Value of property `radius`
     */
    getRadius(): string;
    /**
     * Gets current value of property {@link #getSlices slices}.
     *
     * The number of slices of the geocircle.
     *
     * Default value is `'20'`.
     *
     *
     * @returns Value of property `slices`
     */
    getSlices(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the geocirle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(0,0,0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorBorder colorBorder}.
     *
     * The border color of the geocirle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(0,0,0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorBorder(
      /**
       * New value for property `colorBorder`
       */
      sColorBorder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of the geocircle. The format is "lon;lat;0".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRadius radius}.
     *
     * The radius in meters of the geocirle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'10000'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadius(
      /**
       * New value for property `radius`
       */
      sRadius?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSlices slices}.
     *
     * The number of slices of the geocircle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'20'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSlices(
      /**
       * New value for property `slices`
       */
      sSlices?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GeoCircle constructor.
   */
  export interface $GeoCircleSettings extends $VoBaseSettings {
    /**
     * The position of the geocircle. The format is "lon;lat;0".
     */
    position?: string | PropertyBindingInfo;

    /**
     * The border color of the geocirle.
     */
    colorBorder?: string | PropertyBindingInfo;

    /**
     * The radius in meters of the geocirle.
     */
    radius?: string | PropertyBindingInfo;

    /**
     * The color of the geocirle.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The number of slices of the geocircle.
     */
    slices?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/GeoCircles" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import GeoCircle from "sap/ui/vbm/GeoCircle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for GeoCircle elements.
   */
  export default class GeoCircles extends VoAggregation {
    /**
     * Constructor for a new GeoCircles.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoCirclesSettings
    );
    /**
     * Constructor for a new GeoCircles.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoCirclesSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.GeoCircles with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GeoCircles>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.GeoCircles.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: GeoCircle
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * GeoCircle element aggregation
     */
    getItems(): GeoCircle[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Gets current value of property {@link #getRadiusChangeable radiusChangeable}.
     *
     * Set to true if radius may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `radiusChangeable`
     */
    getRadiusChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.GeoCircle` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: GeoCircle
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: GeoCircle,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): GeoCircle[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | GeoCircle
    ): GeoCircle | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRadiusChangeable radiusChangeable}.
     *
     * Set to true if radius may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadiusChangeable(
      /**
       * New value for property `radiusChangeable`
       */
      bRadiusChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GeoCircles constructor.
   */
  export interface $GeoCirclesSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set to true if radius may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    radiusChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * GeoCircle element aggregation
     */
    items?: GeoCircle[] | GeoCircle | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/GeoJsonLayer" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Feature from "sap/ui/vbm/Feature";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * GeoJsonLayer aggregation container. A GeoJsonLayer can render the content of an assigned GeoJSON. The
   * naming is associated to the GeoJSON standard. All features found in the GeoJSON are rendered as separated
   * objects. From the possible feature types only
   * 	Polygon and Multipolygon, LineString, and Point  are supported so far. The feature type
   * support will be extended in the upcoming releases.
   *  All features from the GeoJSON will be rendered with the given default colors and are inactive. They
   * do not react on mouse over, except with tooltip, or raise any events on click or right click.
   *  By adding Feature elements to the items aggregation you can make the match (by id) feature from
   * the GeoJSON interactive and give it alternative colors.
   *  The GeoJSON can be given as a URL using property srcURL, directly as object using property data,
   * or as a combination of both.
   */
  export default class GeoJsonLayer extends UI5Element {
    /**
     * Constructor for a new GeoJsonLayer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoJsonLayerSettings
    );
    /**
     * Constructor for a new GeoJsonLayer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoJsonLayerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.GeoJsonLayer with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GeoJsonLayer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.GeoJsonLayer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Add GeoJSON object to the layer
     */
    addData(
      /**
       * GeoJSON object or an array of those
       */
      aData: object
    ): void;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Feature
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.GeoJsonLayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoJsonLayer` itself.
     *
     * The event is raised when there is a click action on an aggregated Feature. Clicks on other Features from
     * the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoJsonLayer$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoJsonLayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.GeoJsonLayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoJsonLayer` itself.
     *
     * The event is raised when there is a click action on an aggregated Feature. Clicks on other Features from
     * the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoJsonLayer$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoJsonLayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.GeoJsonLayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoJsonLayer` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on an aggregated Feature. Clicks
     * on other Features from the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoJsonLayer$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoJsonLayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.GeoJsonLayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoJsonLayer` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on an aggregated Feature. Clicks
     * on other Features from the GeoJSON are ignored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoJsonLayer$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoJsonLayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.GeoJsonLayer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoJsonLayer$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.GeoJsonLayer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoJsonLayer$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoJsonLayer$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoJsonLayer$ContextMenuEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getData data}.
     *
     * GeoJSON object according to the {@link http://geojson.org/geojson-spec.html#geojson-objects|specification }
     * or array of such objects
     *
     *
     * @returns Value of property `data`
     */
    getData(): object;
    /**
     * Gets current value of property {@link #getDefaultBorderColor defaultBorderColor}.
     *
     * Default border color for GeoJSON features, if applicable (Polygons and LineStrings)
     *
     * Default value is `"rgba(255, 255, 255, 1.0)"`.
     *
     *
     * @returns Value of property `defaultBorderColor`
     */
    getDefaultBorderColor(): CSSColor;
    /**
     * Gets current value of property {@link #getDefaultFillColor defaultFillColor}.
     *
     * Default Fill color for GeoJSON features (Polygons and LineStrings)
     *
     * Default value is `"rgba(186, 193, 196, 0.5)"`.
     *
     *
     * @returns Value of property `defaultFillColor`
     */
    getDefaultFillColor(): CSSColor;
    /**
     * Gets current value of property {@link #getDefaultLineWidth defaultLineWidth}.
     *
     * Default line width for LineStrings
     *
     * Default value is `5`.
     *
     *
     * @returns Value of property `defaultLineWidth`
     */
    getDefaultLineWidth(): int;
    /**
     * Returns Properties for Features like name, bounding box, and midpoint
     *
     *
     * @returns Array of Feature Information Objects. Each object in the array has the properties BBox: Bounding
     * Box for the Feature in format "lonMin;latMin;lonMax;latMax", Midpoint: Centerpoint for Feature in format
     * "lon;lat", Name: Name of the Feature, and Properties: Array of name-value-pairs associated with the Feature
     */
    getFeaturesInfo(
      /**
       * Array of Feature Ids. The Feature Id must match the GeoJSON tag.
       */
      aFeatureIds: string[]
    ): any[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Feature object aggregation
     */
    getItems(): Feature[];
    /**
     * Gets current value of property {@link #getSrcURL srcURL}.
     *
     * Source URL for GeoJSON
     *
     *
     * @returns Value of property `srcURL`
     */
    getSrcURL(): string;
    /**
     * Checks for the provided `sap.ui.vbm.Feature` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Feature
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Feature,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * open the context menu
     */
    openContextMenu(
      /**
       * VO instance for which the Detail Window should be opened
       */
      oFeature: Feature,
      /**
       * the context menu to be opened
       */
      oMenu: object
    ): void;
    /**
     * open a Detail Window
     */
    openDetailWindow(
      /**
       * VO instance for which the Detail Window should be opened
       */
      oFeature: Feature,
      /**
       * Parameter object
       */
      oParams: {
        /**
         * Text for Detail Window caption
         */
        caption: string;
        /**
         * position offset in x-direction from the anchor point
         */
        offsetX: string;
        /**
         * position offset in y-direction from the anchor point
         */
        offsetY: string;
      }
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Feature[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Feature
    ): Feature | null;
    /**
     * Sets a new value for property {@link #getData data}.
     *
     * GeoJSON object according to the {@link http://geojson.org/geojson-spec.html#geojson-objects|specification }
     * or array of such objects
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setData(
      /**
       * New value for property `data`
       */
      oData?: object
    ): this;
    /**
     * Sets a new value for property {@link #getDefaultBorderColor defaultBorderColor}.
     *
     * Default border color for GeoJSON features, if applicable (Polygons and LineStrings)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(255, 255, 255, 1.0)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultBorderColor(
      /**
       * New value for property `defaultBorderColor`
       */
      sDefaultBorderColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getDefaultFillColor defaultFillColor}.
     *
     * Default Fill color for GeoJSON features (Polygons and LineStrings)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(186, 193, 196, 0.5)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultFillColor(
      /**
       * New value for property `defaultFillColor`
       */
      sDefaultFillColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getDefaultLineWidth defaultLineWidth}.
     *
     * Default line width for LineStrings
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultLineWidth(
      /**
       * New value for property `defaultLineWidth`
       */
      iDefaultLineWidth?: int
    ): this;
    /**
     * Sets a new value for property {@link #getSrcURL srcURL}.
     *
     * Source URL for GeoJSON
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSrcURL(
      /**
       * New value for property `srcURL`
       */
      sSrcURL?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GeoJsonLayer constructor.
   */
  export interface $GeoJsonLayerSettings extends $ElementSettings {
    /**
     * Source URL for GeoJSON
     */
    srcURL?: string | PropertyBindingInfo;

    /**
     * GeoJSON object according to the {@link http://geojson.org/geojson-spec.html#geojson-objects|specification }
     * or array of such objects
     */
    data?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Default line width for LineStrings
     */
    defaultLineWidth?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Default Fill color for GeoJSON features (Polygons and LineStrings)
     */
    defaultFillColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Default border color for GeoJSON features, if applicable (Polygons and LineStrings)
     */
    defaultBorderColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Feature object aggregation
     */
    items?: Feature[] | Feature | AggregationBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click action on an aggregated Feature. Clicks on other Features from
     * the GeoJSON are ignored.
     */
    click?: (oEvent: GeoJsonLayer$ClickEvent) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on an aggregated Feature. Clicks
     * on other Features from the GeoJSON are ignored.
     */
    contextMenu?: (oEvent: GeoJsonLayer$ContextMenuEvent) => void;
  }

  /**
   * Parameters of the GeoJsonLayer#click event.
   */
  export interface GeoJsonLayer$ClickEventParameters {
    /**
     * Id of clicked Feature
     */
    featureId?: string;
  }

  /**
   * Event object of the GeoJsonLayer#click event.
   */
  export type GeoJsonLayer$ClickEvent = Event<
    GeoJsonLayer$ClickEventParameters,
    GeoJsonLayer
  >;

  /**
   * Parameters of the GeoJsonLayer#contextMenu event.
   */
  export interface GeoJsonLayer$ContextMenuEventParameters {
    /**
     * Id of clicked Feature
     */
    featureId?: string;
  }

  /**
   * Event object of the GeoJsonLayer#contextMenu event.
   */
  export type GeoJsonLayer$ContextMenuEvent = Event<
    GeoJsonLayer$ContextMenuEventParameters,
    GeoJsonLayer
  >;
}

declare module "sap/ui/vbm/GeoMap" {
  import { default as VBI, $VBISettings } from "sap/ui/vbm/VBI";

  import ClusterBase from "sap/ui/vbm/ClusterBase";

  import FeatureCollection from "sap/ui/vbm/FeatureCollection";

  import GeoJsonLayer from "sap/ui/vbm/GeoJsonLayer";

  import Resource from "sap/ui/vbm/Resource";

  import VoAbstract from "sap/ui/vbm/VoAbstract";

  import Event from "sap/ui/base/Event";

  import ClusterContainer from "sap/ui/vbm/ClusterContainer";

  import Spot from "sap/ui/vbm/Spot";

  import Legend from "sap/ui/vbm/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import VoBase from "sap/ui/vbm/VoBase";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Map control with the option to position multiple visual objects on top of a map. The GeoMap control shows
   * an image based map loaded from one or more configurable external providers. Per default a map from MapQuest is used. Other map providers can be configured via property
   * mapConfiguration. Multiple maps can be mashed up into one map layer stack. If multiple map layer
   * stacks are provided via configuration it is possible to switch between them during runtime. The control
   * supports the display of copyright information for the visible maps.
   *  On top of the map the GeoMap control provides a navigation control, a scale, and a legend. Each of them
   * can be switched off separately.
   *  It is possible to set the initial position and zoom for the map display. Further the control allows
   * to restrict the potentially visible map area and zoom range.
   *  Different visual objects can be placed on the map. Visual objects are grouped in VO aggregations and
   * an arbitrary number of VO aggregations can be assigned to the vos aggregation.
   *  The second aggregation featureCollections allows the use of GeoJSON as source for visual objects.
   */
  export default class GeoMap extends VBI {
    /**
     * Constructor for a new GeoMap.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoMapSettings
    );
    /**
     * Constructor for a new GeoMap.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GeoMapSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.GeoMap with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VBI.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GeoMap>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.GeoMap.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some cluster to the aggregation {@link #getClusters clusters}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCluster(
      /**
       * The cluster to add; if empty, nothing is inserted
       */
      oCluster: ClusterBase
    ): this;
    /**
     * Adds some featureCollection to the aggregation {@link #getFeatureCollections featureCollections}.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFeatureCollection(
      /**
       * The featureCollection to add; if empty, nothing is inserted
       */
      oFeatureCollection: FeatureCollection
    ): this;
    /**
     * Adds some geoJsonLayer to the aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addGeoJsonLayer(
      /**
       * The geoJsonLayer to add; if empty, nothing is inserted
       */
      oGeoJsonLayer: GeoJsonLayer
    ): this;
    /**
     * Adds some resource to the aggregation {@link #getResources resources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addResource(
      /**
       * The resource to add; if empty, nothing is inserted
       */
      oResource: Resource
    ): this;
    /**
     * Adds some vo to the aggregation {@link #getVos vos}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addVo(
      /**
       * The vo to add; if empty, nothing is inserted
       */
      oVo: VoAbstract
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:centerChanged centerChanged} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map move.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCenterChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$CenterChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:centerChanged centerChanged} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map move.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCenterChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$CenterChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * Raised when the map is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * Raised when the map is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * Raised when the map is right clicked/longPressed(tap and hold).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * Raised when the map is right clicked/longPressed(tap and hold).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * Raised when something is dropped on the map.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$DropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * Raised when something is dropped on the map.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$DropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:keyDown keyDown} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map key down
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachKeyDown(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyDownEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:keyDown keyDown} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map key down
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachKeyDown(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyDownEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:keyPress keyPress} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map key press
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachKeyPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:keyPress keyPress} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map key press
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachKeyPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:keyUp keyUp} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map key up
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachKeyUp(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyUpEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:keyUp keyUp} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on map key up
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachKeyUp(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyUpEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * This event is raised when a multi selection of visual objects has occurred
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * This event is raised when a multi selection of visual objects has occurred
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoomChanged zoomChanged} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on zoom in or zoom out.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoomChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$ZoomChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoomChanged zoomChanged} event of this `sap.ui.vbm.GeoMap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.GeoMap` itself.
     *
     * this event is raised on zoom in or zoom out.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoomChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GeoMap$ZoomChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.GeoMap` itself
       */
      oListener?: object
    ): this;
    /**
     * Close any open Detail window
     */
    closeAnyDetailWindow(): void;
    /**
     * Destroys all the clusters in the aggregation {@link #getClusters clusters}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyClusters(): this;
    /**
     * Destroys all the featureCollections in the aggregation {@link #getFeatureCollections featureCollections}.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFeatureCollections(): this;
    /**
     * Destroys all the geoJsonLayers in the aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeoJsonLayers(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys all the resources in the aggregation {@link #getResources resources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyResources(): this;
    /**
     * Destroys all the vos in the aggregation {@link #getVos vos}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVos(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:centerChanged centerChanged} event of this
     * `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCenterChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$CenterChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:drop drop} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDrop(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$DropEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:keyDown keyDown} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachKeyDown(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyDownEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:keyPress keyPress} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachKeyPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyPressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:keyUp keyUp} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachKeyUp(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$KeyUpEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:select select} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:zoomChanged zoomChanged} event of this `sap.ui.vbm.GeoMap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachZoomChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GeoMap$ZoomChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:centerChanged centerChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCenterChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$CenterChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$ContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:drop drop} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDrop(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$DropEventParameters
    ): this;
    /**
     * Fires event {@link #event:keyDown keyDown} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireKeyDown(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$KeyDownEventParameters
    ): this;
    /**
     * Fires event {@link #event:keyPress keyPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireKeyPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$KeyPressEventParameters
    ): this;
    /**
     * Fires event {@link #event:keyUp keyUp} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireKeyUp(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$KeyUpEventParameters
    ): this;
    /**
     * Fires event {@link #event:select select} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:zoomChanged zoomChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireZoomChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GeoMap$ZoomChangedEventParameters
    ): this;
    /**
     * Retrieves the center position of the current map.
     *
     *
     * @returns centerPosition A string representing the center position; it is retrieved in the form of "x;y".
     */
    getCenterPosition(): string;
    /**
     * Retrieves all spot instances of a {sap.ui.vbm.ClusterContainer}
     *
     *
     * @returns spots An array of sap.ui.vbm.Spot instances.
     */
    getClusteredSpots(
      /**
       * The cluster container whose spots we want to retrieve.
       */
      clusterContainer: ClusterContainer
    ): Spot[];
    /**
     * Gets current value of property {@link #getClustering clustering}.
     *
     * @deprecated As of version 1.31. This property should not longer be used. Its functionality has been replaced
     * by the `clusters` aggregation.
     *
     * @returns Value of property `clustering`
     */
    getClustering(): object;
    /**
     * Gets content of aggregation {@link #getClusters clusters}.
     *
     * Aggregation of clusters.
     */
    getClusters(): ClusterBase[];
    /**
     * Gets current value of property {@link #getDisablePan disablePan}.
     *
     * Disable Map Paning. This setting works only upon initialization and cannot be changed later on.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `disablePan`
     */
    getDisablePan(): boolean;
    /**
     * Gets current value of property {@link #getDisableZoom disableZoom}.
     *
     * Disable Map Zooming. This setting works only upon initialization and cannot be changed later on.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `disableZoom`
     */
    getDisableZoom(): boolean;
    /**
     * Gets current value of property {@link #getEnableAnimation enableAnimation}.
     *
     * Enable Animation of Map Zoom. Works in combination of setZoomlevel.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableAnimation`
     */
    getEnableAnimation(): boolean;
    /**
     * Gets content of aggregation {@link #getFeatureCollections featureCollections}.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     */
    getFeatureCollections(): FeatureCollection[];
    /**
     * Gets content of aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     *
     * Aggregation of GeoJSON layers. Object from a GeoJSON layer will be behind all other Visual Objects from
     * the `vos` aggregation. In case of multiple GeoJSON layers the objects are orderer with the layers they
     * belong to.
     */
    getGeoJsonLayers(): GeoJsonLayer[];
    /**
     * Gets current value of property {@link #getInitialPosition initialPosition}.
     *
     * Initial position of the Map. Set is only supported on initialization! Format is "<longitude>;<latitude>;0".
     *
     * Default value is `"0;0;0"`.
     *
     *
     * @returns Value of property `initialPosition`
     */
    getInitialPosition(): string;
    /**
     * Gets current value of property {@link #getInitialZoom initialZoom}.
     *
     * Initial zoom. Value needs to be positive whole number. Set is only supported on initialization!
     *
     * Default value is `"2"`.
     *
     *
     * @returns Value of property `initialZoom`
     */
    getInitialZoom(): string;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Legend for the Map
     */
    getLegend(): Legend;
    /**
     * Gets current value of property {@link #getLegendVisible legendVisible}.
     *
     * Toggles the visibility of the legend
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `legendVisible`
     */
    getLegendVisible(): boolean;
    /**
     * Gets current value of property {@link #getMapConfiguration mapConfiguration}.
     *
     * This is the map configuration for the geo map. The map configuration defines the used maps, the layering
     * of the maps and the servers that can be used to request the map tiles.
     *
     *
     * @returns Value of property `mapConfiguration`
     */
    getMapConfiguration(): object;
    /**
     * Gets current value of property {@link #getNavcontrolVisible navcontrolVisible}.
     *
     * Defines the visibility of the navigation control. Only supported on initialization!
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `navcontrolVisible`
     */
    getNavcontrolVisible(): boolean;
    /**
     * Trigger the interactive creation mode to get a position or position array.
     *
     * @experimental As of version 1.30.0. This method is experimental and might be modified or removerd in
     * future versions.
     *
     * @returns Indicator whether the creation mode could be triggered successfully or not.
     */
    getPositionInteractive(
      /**
       * Indicator if a single position or an array is requested
       */
      bPosArray: boolean,
      /**
       * Callback function func( sPosArray ) to be called when done. Position(array) sPosArray is provided in
       * format "lon;lat;0;..."
       */
      callback: Function
    ): boolean;
    /**
     * Gets current value of property {@link #getRefMapLayerStack refMapLayerStack}.
     *
     * Name of the map layer stack (provided in mapConfiguration) which is used for map rendering. If not set
     * the layer stack with the name 'Default' is chosen. Property can be changed at runtime to switch between
     * map layer stack.
     *
     * Default value is `"Default"`.
     *
     *
     * @returns Value of property `refMapLayerStack`
     */
    getRefMapLayerStack(): string;
    /**
     * Gets content of aggregation {@link #getResources resources}.
     *
     * Aggregation of resources. The images for e.g. Spots have to be provided as resources.
     */
    getResources(): Resource[];
    /**
     * Gets current value of property {@link #getScaleVisible scaleVisible}.
     *
     * Defines the visibility of the scale. Only supported on initialization!
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `scaleVisible`
     */
    getScaleVisible(): boolean;
    /**
     * Gets current value of property {@link #getVisualFrame visualFrame}.
     *
     * Visual Frame object. Defining a frame {minX, maxX, minY, maxY, maxLOD, minLOD} to which the scene display
     * is restricted.
     *
     *
     * @returns Value of property `visualFrame`
     */
    getVisualFrame(): object;
    /**
     * Get an aggregated VO instance by its internal ID returned by e.g. function `getInfoForCluster`.
     *
     *
     * @returns VO instance element or null if nothing found
     */
    getVoByInternalId(
      /**
       * Internal VO Identifier
       */
      voIdentifier?: string
    ): VoBase;
    /**
     * Gets content of aggregation {@link #getVos vos}.
     *
     * Aggregation of visual object types. A VO aggregation can be considered to be a table of VOs of a common
     * type.
     */
    getVos(): VoAbstract[];
    /**
     * Gets current value of property {@link #getZoomlevel zoomlevel}.
     *
     * Zoomlevel for the Map. Value needs to be positive whole number.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `zoomlevel`
     */
    getZoomlevel(): int;
    /**
     * Go to Initial Start Position with Initial Zoom Level
     */
    goToStartPosition(): void;
    /**
     * Checks for the provided `sap.ui.vbm.ClusterBase` in the aggregation {@link #getClusters clusters}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCluster(
      /**
       * The cluster whose index is looked for
       */
      oCluster: ClusterBase
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.FeatureCollection` in the aggregation {@link #getFeatureCollections featureCollections}.
     * and returns its index if found or -1 otherwise.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFeatureCollection(
      /**
       * The featureCollection whose index is looked for
       */
      oFeatureCollection: FeatureCollection
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.GeoJsonLayer` in the aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfGeoJsonLayer(
      /**
       * The geoJsonLayer whose index is looked for
       */
      oGeoJsonLayer: GeoJsonLayer
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.Resource` in the aggregation {@link #getResources resources}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfResource(
      /**
       * The resource whose index is looked for
       */
      oResource: Resource
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.VoAbstract` in the aggregation {@link #getVos vos}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfVo(
      /**
       * The vo whose index is looked for
       */
      oVo: VoAbstract
    ): int;
    /**
     * Inserts a cluster into the aggregation {@link #getClusters clusters}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCluster(
      /**
       * The cluster to insert; if empty, nothing is inserted
       */
      oCluster: ClusterBase,
      /**
       * The `0`-based index the cluster should be inserted at; for a negative value of `iIndex`, the cluster
       * is inserted at position 0; for a value greater than the current size of the aggregation, the cluster
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a featureCollection into the aggregation {@link #getFeatureCollections featureCollections}.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertFeatureCollection(
      /**
       * The featureCollection to insert; if empty, nothing is inserted
       */
      oFeatureCollection: FeatureCollection,
      /**
       * The `0`-based index the featureCollection should be inserted at; for a negative value of `iIndex`, the
       * featureCollection is inserted at position 0; for a value greater than the current size of the aggregation,
       * the featureCollection is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a geoJsonLayer into the aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertGeoJsonLayer(
      /**
       * The geoJsonLayer to insert; if empty, nothing is inserted
       */
      oGeoJsonLayer: GeoJsonLayer,
      /**
       * The `0`-based index the geoJsonLayer should be inserted at; for a negative value of `iIndex`, the geoJsonLayer
       * is inserted at position 0; for a value greater than the current size of the aggregation, the geoJsonLayer
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a resource into the aggregation {@link #getResources resources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertResource(
      /**
       * The resource to insert; if empty, nothing is inserted
       */
      oResource: Resource,
      /**
       * The `0`-based index the resource should be inserted at; for a negative value of `iIndex`, the resource
       * is inserted at position 0; for a value greater than the current size of the aggregation, the resource
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a vo into the aggregation {@link #getVos vos}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertVo(
      /**
       * The vo to insert; if empty, nothing is inserted
       */
      oVo: VoAbstract,
      /**
       * The `0`-based index the vo should be inserted at; for a negative value of `iIndex`, the vo is inserted
       * at position 0; for a value greater than the current size of the aggregation, the vo is inserted at the
       * last position
       */
      iIndex: int
    ): this;
    /**
     * Open Detail window
     */
    openDetailWindow(
      /**
       * Postion for the Detail Window in format "lon;lat;0"
       */
      sPosition: string,
      /**
       * Parameter Objects
       */
      oParams?: {
        /**
         * Caption of the Detail Window
         */
        caption?: string;
      }
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getClusters clusters}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllClusters(): ClusterBase[];
    /**
     * Removes all the controls from the aggregation {@link #getFeatureCollections featureCollections}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllFeatureCollections(): FeatureCollection[];
    /**
     * Removes all the controls from the aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllGeoJsonLayers(): GeoJsonLayer[];
    /**
     * Removes all the controls from the aggregation {@link #getResources resources}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllResources(): Resource[];
    /**
     * Removes all the controls from the aggregation {@link #getVos vos}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllVos(): VoAbstract[];
    /**
     * Removes a cluster from the aggregation {@link #getClusters clusters}.
     *
     *
     * @returns The removed cluster or `null`
     */
    removeCluster(
      /**
       * The cluster to remove or its index or id
       */
      vCluster: int | string | ClusterBase
    ): ClusterBase | null;
    /**
     * Removes a featureCollection from the aggregation {@link #getFeatureCollections featureCollections}.
     *
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     *
     * @returns The removed featureCollection or `null`
     */
    removeFeatureCollection(
      /**
       * The featureCollection to remove or its index or id
       */
      vFeatureCollection: int | string | FeatureCollection
    ): FeatureCollection | null;
    /**
     * Removes a geoJsonLayer from the aggregation {@link #getGeoJsonLayers geoJsonLayers}.
     *
     *
     * @returns The removed geoJsonLayer or `null`
     */
    removeGeoJsonLayer(
      /**
       * The geoJsonLayer to remove or its index or id
       */
      vGeoJsonLayer: int | string | GeoJsonLayer
    ): GeoJsonLayer | null;
    /**
     * Removes a resource from the aggregation {@link #getResources resources}.
     *
     *
     * @returns The removed resource or `null`
     */
    removeResource(
      /**
       * The resource to remove or its index or id
       */
      vResource: int | string | Resource
    ): Resource | null;
    /**
     * Removes a vo from the aggregation {@link #getVos vos}.
     *
     *
     * @returns The removed vo or `null`
     */
    removeVo(
      /**
       * The vo to remove or its index or id
       */
      vVo: int | string | VoAbstract
    ): VoAbstract | null;
    /**
     * Sets a new value for property {@link #getCenterPosition centerPosition}.
     *
     * Center position of the Map. Format is "<longitude>;<latitude>".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0;0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCenterPosition(
      /**
       * New value for property `centerPosition`
       */
      sCenterPosition?: string
    ): this;
    /**
     * Set clustering definitions.
     *
     * @deprecated As of version 1.31. This property should not longer be used. Its functionality has been replaced
     * by the `clusters` aggregation.
     *
     * @returns This allows method chaining
     */
    setClustering(
      /**
       * Cluster Definition object
       */
      oClustering: object
    ): GeoMap;
    /**
     * Sets a new value for property {@link #getDisablePan disablePan}.
     *
     * Disable Map Paning. This setting works only upon initialization and cannot be changed later on.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisablePan(
      /**
       * New value for property `disablePan`
       */
      bDisablePan?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDisableZoom disableZoom}.
     *
     * Disable Map Zooming. This setting works only upon initialization and cannot be changed later on.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisableZoom(
      /**
       * New value for property `disableZoom`
       */
      bDisableZoom?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAnimation enableAnimation}.
     *
     * Enable Animation of Map Zoom. Works in combination of setZoomlevel.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAnimation(
      /**
       * New value for property `enableAnimation`
       */
      bEnableAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getInitialPosition initialPosition}.
     *
     * Initial position of the Map. Set is only supported on initialization! Format is "<longitude>;<latitude>;0".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0;0;0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialPosition(
      /**
       * New value for property `initialPosition`
       */
      sInitialPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getInitialZoom initialZoom}.
     *
     * Initial zoom. Value needs to be positive whole number. Set is only supported on initialization!
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"2"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialZoom(
      /**
       * New value for property `initialZoom`
       */
      sInitialZoom?: string
    ): this;
    /**
     * Set Tracking Mode for Lasso Selection on/off.
     *
     *
     * @returns This allows method chaining
     */
    setLassoSelection(
      /**
       * to start or stop tracking mode
       */
      bSet: boolean
    ): GeoMap;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Legend
    ): this;
    /**
     * Sets a new value for property {@link #getLegendVisible legendVisible}.
     *
     * Toggles the visibility of the legend
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendVisible(
      /**
       * New value for property `legendVisible`
       */
      bLegendVisible?: boolean
    ): this;
    /**
     * Set Map configuration data. Map Configurations contain a set of Map Providers and Map Layer Stacks refering
     * to those providers. The GeoMap property refMapLayerStack defines, which Map Layer Stack becomes visible.
     *
     *
     * @returns This allows method chaining
     */
    setMapConfiguration(
      /**
       * Map Configuration object
       */
      oMapConfiguration: {
        /**
         * Array of Map Provider definitions.
         */
        MapProvider: any[];
        /**
         * Array of Map Layer Stacks
         */
        MapLayerStacks: any[];
      }
    ): GeoMap;
    /**
     * Sets a new value for property {@link #getNavcontrolVisible navcontrolVisible}.
     *
     * Defines the visibility of the navigation control. Only supported on initialization!
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavcontrolVisible(
      /**
       * New value for property `navcontrolVisible`
       */
      bNavcontrolVisible?: boolean
    ): this;
    /**
     * Set Tracking Mode for Rectangular Selection on/off.
     *
     *
     * @returns This allows method chaining
     */
    setRectangularSelection(
      /**
       * to start or stop tracking mode
       */
      bSet: boolean
    ): GeoMap;
    /**
     * Set Tracking Mode for Rectangular Zoom on/off.
     *
     *
     * @returns This allows method chaining
     */
    setRectZoom(
      /**
       * to start or stop tracking mode
       */
      bSet: boolean
    ): GeoMap;
    /**
     * Sets a new value for property {@link #getRefMapLayerStack refMapLayerStack}.
     *
     * Name of the map layer stack (provided in mapConfiguration) which is used for map rendering. If not set
     * the layer stack with the name 'Default' is chosen. Property can be changed at runtime to switch between
     * map layer stack.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Default"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRefMapLayerStack(
      /**
       * New value for property `refMapLayerStack`
       */
      sRefMapLayerStack?: string
    ): this;
    /**
     * Sets a new value for property {@link #getScaleVisible scaleVisible}.
     *
     * Defines the visibility of the scale. Only supported on initialization!
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScaleVisible(
      /**
       * New value for property `scaleVisible`
       */
      bScaleVisible?: boolean
    ): this;
    /**
     * Set Visual Frame definition.
     *
     *
     * @returns This allows method chaining
     */
    setVisualFrame(
      /**
       * Visual Frame definition object
       */
      oVisFrame: {
        /**
         * Minimal longitude of visual frame
         */
        minLon: float;
        /**
         * Maximal longitude of visual frame
         */
        maxLon: float;
        /**
         * Minimal latitude of visual frame
         */
        minLat: float;
        /**
         * Maximal latitude of visual frame
         */
        maxLat: float;
        /**
         * Minimal Level of Detail for visual frame
         */
        minLOD: float;
        /**
         * Maximal Level of Detail for visual frame
         */
        maxLOD: float;
        /**
         * Maximal fraction [0..1] of minLOD which is acceptable, otherwise minLOD is rounded upwards
         */
        maxFraction: float;
      }
    ): GeoMap;
    /**
     * Sets a new value for property {@link #getZoomlevel zoomlevel}.
     *
     * Zoomlevel for the Map. Value needs to be positive whole number.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomlevel(
      /**
       * New value for property `zoomlevel`
       */
      iZoomlevel?: int
    ): this;
    /**
     * Zoom to Areas by Id.
     *
     *
     * @returns This allows method chaining
     */
    zoomToAreasById(
      /**
       * is an Array of areas that we want to zoom to.
       */
      ui5AreaIds: string[],
      /**
       * is the correction factor, if correlationFactor is set to 1.0 the bounding box points are exactly on the
       * visible boder of the new area
       */
      correlationFactor: float
    ): GeoMap;
  }
  /**
   * Describes the settings that can be provided to the GeoMap constructor.
   */
  export interface $GeoMapSettings extends $VBISettings {
    /**
     * This is the map configuration for the geo map. The map configuration defines the used maps, the layering
     * of the maps and the servers that can be used to request the map tiles.
     */
    mapConfiguration?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toggles the visibility of the legend
     */
    legendVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the visibility of the scale. Only supported on initialization!
     */
    scaleVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the visibility of the navigation control. Only supported on initialization!
     */
    navcontrolVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Initial position of the Map. Set is only supported on initialization! Format is "<longitude>;<latitude>;0".
     */
    initialPosition?: string | PropertyBindingInfo;

    /**
     * Initial zoom. Value needs to be positive whole number. Set is only supported on initialization!
     */
    initialZoom?: string | PropertyBindingInfo;

    /**
     * Center position of the Map. Format is "<longitude>;<latitude>".
     */
    centerPosition?: string | PropertyBindingInfo;

    /**
     * Zoomlevel for the Map. Value needs to be positive whole number.
     */
    zoomlevel?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of the map layer stack (provided in mapConfiguration) which is used for map rendering. If not set
     * the layer stack with the name 'Default' is chosen. Property can be changed at runtime to switch between
     * map layer stack.
     */
    refMapLayerStack?: string | PropertyBindingInfo;

    /**
     * Visual Frame object. Defining a frame {minX, maxX, minY, maxY, maxLOD, minLOD} to which the scene display
     * is restricted.
     */
    visualFrame?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * @deprecated As of version 1.31. This property should not longer be used. Its functionality has been replaced
     * by the `clusters` aggregation.
     */
    clustering?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Disable Map Zooming. This setting works only upon initialization and cannot be changed later on.
     */
    disableZoom?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Disable Map Paning. This setting works only upon initialization and cannot be changed later on.
     */
    disablePan?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enable Animation of Map Zoom. Works in combination of setZoomlevel.
     */
    enableAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation of visual object types. A VO aggregation can be considered to be a table of VOs of a common
     * type.
     */
    vos?: VoAbstract[] | VoAbstract | AggregationBindingInfo | `{${string}}`;

    /**
     * Aggregation of GeoJSON layers. Object from a GeoJSON layer will be behind all other Visual Objects from
     * the `vos` aggregation. In case of multiple GeoJSON layers the objects are orderer with the layers they
     * belong to.
     */
    geoJsonLayers?:
      | GeoJsonLayer[]
      | GeoJsonLayer
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * @deprecated As of version 1.31. This aggregation should not longer be used. Its functionality has been
     * replaced by the more generic`geoJsonLayers` aggregation.
     */
    featureCollections?:
      | FeatureCollection[]
      | FeatureCollection
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregation of resources. The images for e.g. Spots have to be provided as resources.
     */
    resources?: Resource[] | Resource | AggregationBindingInfo | `{${string}}`;

    /**
     * Legend for the Map
     */
    legend?: Legend;

    /**
     * Aggregation of clusters.
     */
    clusters?:
      | ClusterBase[]
      | ClusterBase
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Raised when the map is clicked.
     */
    click?: (oEvent: GeoMap$ClickEvent) => void;

    /**
     * Raised when the map is right clicked/longPressed(tap and hold).
     */
    contextMenu?: (oEvent: GeoMap$ContextMenuEvent) => void;

    /**
     * Raised when something is dropped on the map.
     */
    drop?: (oEvent: GeoMap$DropEvent) => void;

    /**
     * This event is raised when a multi selection of visual objects has occurred
     */
    select?: (oEvent: Event) => void;

    /**
     * this event is raised on zoom in or zoom out.
     */
    zoomChanged?: (oEvent: GeoMap$ZoomChangedEvent) => void;

    /**
     * this event is raised on map move.
     */
    centerChanged?: (oEvent: GeoMap$CenterChangedEvent) => void;

    /**
     * this event is raised on map key down
     */
    keyDown?: (oEvent: GeoMap$KeyDownEvent) => void;

    /**
     * this event is raised on map key press
     */
    keyPress?: (oEvent: GeoMap$KeyPressEvent) => void;

    /**
     * this event is raised on map key up
     */
    keyUp?: (oEvent: GeoMap$KeyUpEvent) => void;
  }

  /**
   * Parameters of the GeoMap#centerChanged event.
   */
  export interface GeoMap$CenterChangedEventParameters {
    /**
     * Center point of the map. Format : Lon;Lat;0.0.
     */
    centerPoint?: string;

    /**
     * Viewport bounding box's upperLeft and lowerRight coordinates. Format : Lon;Lat;0.0.
     */
    viewportBB?: object;

    /**
     * Level of detail.
     */
    zoomLevel?: int;
  }

  /**
   * Event object of the GeoMap#centerChanged event.
   */
  export type GeoMap$CenterChangedEvent = Event<
    GeoMap$CenterChangedEventParameters,
    GeoMap
  >;

  /**
   * Parameters of the GeoMap#click event.
   */
  export interface GeoMap$ClickEventParameters {
    /**
     * Geo coordinates in format "<longitude>;<latitude>;0"
     */
    pos?: string;
  }

  /**
   * Event object of the GeoMap#click event.
   */
  export type GeoMap$ClickEvent = Event<GeoMap$ClickEventParameters, GeoMap>;

  /**
   * Parameters of the GeoMap#contextMenu event.
   */
  export interface GeoMap$ContextMenuEventParameters {
    /**
     * Client coordinate X
     */
    clientX?: int;

    /**
     * Client coordinate Y
     */
    clientY?: int;

    /**
     * Geo coordinates in format "<longitude>;<latitude>;0"
     */
    pos?: string;
  }

  /**
   * Event object of the GeoMap#contextMenu event.
   */
  export type GeoMap$ContextMenuEvent = Event<
    GeoMap$ContextMenuEventParameters,
    GeoMap
  >;

  /**
   * Parameters of the GeoMap#drop event.
   */
  export interface GeoMap$DropEventParameters {
    /**
     * Geo coordinates in format "<longitude>;<latitude>;0"
     */
    pos?: string;
  }

  /**
   * Event object of the GeoMap#drop event.
   */
  export type GeoMap$DropEvent = Event<GeoMap$DropEventParameters, GeoMap>;

  /**
   * Parameters of the GeoMap#keyDown event.
   */
  export interface GeoMap$KeyDownEventParameters {
    /**
     * Key value of the key
     */
    key?: string;

    /**
     * Code value of the key
     */
    code?: int;

    /**
     * Shift key modifier state
     */
    shift?: boolean;

    /**
     * Ctrl key modifier state
     */
    ctrl?: boolean;

    /**
     * Alt key modifier state
     */
    alt?: boolean;

    /**
     * Meta key modifier state
     */
    meta?: boolean;
  }

  /**
   * Event object of the GeoMap#keyDown event.
   */
  export type GeoMap$KeyDownEvent = Event<
    GeoMap$KeyDownEventParameters,
    GeoMap
  >;

  /**
   * Parameters of the GeoMap#keyPress event.
   */
  export interface GeoMap$KeyPressEventParameters {
    /**
     * Key value of the key
     */
    key?: string;

    /**
     * Code value of the key
     */
    code?: int;

    /**
     * Shift key modifier state
     */
    shift?: boolean;

    /**
     * Ctrl key modifier state
     */
    ctrl?: boolean;

    /**
     * Alt key modifier state
     */
    alt?: boolean;

    /**
     * Meta key modifier state
     */
    meta?: boolean;
  }

  /**
   * Event object of the GeoMap#keyPress event.
   */
  export type GeoMap$KeyPressEvent = Event<
    GeoMap$KeyPressEventParameters,
    GeoMap
  >;

  /**
   * Parameters of the GeoMap#keyUp event.
   */
  export interface GeoMap$KeyUpEventParameters {
    /**
     * Key value of the key
     */
    key?: string;

    /**
     * Code value of the key
     */
    code?: int;

    /**
     * Shift key modifier state
     */
    shift?: boolean;

    /**
     * Ctrl key modifier state
     */
    ctrl?: boolean;

    /**
     * Alt key modifier state
     */
    alt?: boolean;

    /**
     * Meta key modifier state
     */
    meta?: boolean;
  }

  /**
   * Event object of the GeoMap#keyUp event.
   */
  export type GeoMap$KeyUpEvent = Event<GeoMap$KeyUpEventParameters, GeoMap>;

  /**
   * Parameters of the GeoMap#select event.
   */
  export interface GeoMap$SelectEventParameters {}

  /**
   * Event object of the GeoMap#select event.
   */
  export type GeoMap$SelectEvent = Event<GeoMap$SelectEventParameters, GeoMap>;

  /**
   * Parameters of the GeoMap#zoomChanged event.
   */
  export interface GeoMap$ZoomChangedEventParameters {
    /**
     * Center point of the map. Format : Lon;Lat;0.0.
     */
    centerPoint?: string;

    /**
     * Viewport bounding box's upperLeft and lowerRight coordinates. Format : Lon;Lat;0.0.
     */
    viewportBB?: object;

    /**
     * Level of detail.
     */
    zoomLevel?: int;
  }

  /**
   * Event object of the GeoMap#zoomChanged event.
   */
  export type GeoMap$ZoomChangedEvent = Event<
    GeoMap$ZoomChangedEventParameters,
    GeoMap
  >;
}

declare module "sap/ui/vbm/Heatmap" {
  import {
    default as VoAbstract,
    $VoAbstractSettings,
  } from "sap/ui/vbm/VoAbstract";

  import HeatPoint from "sap/ui/vbm/HeatPoint";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for HeatPoint instances.
   */
  export default class Heatmap extends VoAbstract {
    /**
     * Constructor for a new Heatmap.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HeatmapSettings
    );
    /**
     * Constructor for a new Heatmap.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HeatmapSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Heatmap with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAbstract.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Heatmap>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Heatmap.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: HeatPoint
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets current value of property {@link #getAlphaExponent alphaExponent}.
     *
     * Exponent for the alphaChannel
     *  aE = 1 : alpha Channel remains linear
     *  0 < aE < 1 : (e.g. aE=0.5 "square root") sub linear alpha channeling (lower value colors remain longer
     * visible; range appears wider)
     *  aE > 1 (e.g. aE=2: "squared") above linear alpha channeling ( lower value colors remain shortly visible;
     * range appears chopped)
     *
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Value of property `alphaExponent`
     */
    getAlphaExponent(): string;
    /**
     * Gets current value of property {@link #getBehavior behavior}.
     *
     * Behavior of the HeatPoint, 0 Density Map, 2: Heat Map, 1: Intermediate.
     *
     * Default value is `'2'`.
     *
     *
     * @returns Value of property `behavior`
     */
    getBehavior(): string;
    /**
     * Gets current value of property {@link #getColorExponent colorExponent}.
     *
     * Exponent for the color
     *  aE = 1 : Linear Gradient
     *  0 < aE < 1 : Sublinear Gradient; i.E. with cE=0.5 point values are square rooted before usage [share
     * of lower value cols will decrease]
     *  aE > 1 : Higher Level Gradient; i.E. with cE=2 point values are squared before usage [share of lower
     * value cols will increase]
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Value of property `colorExponent`
     */
    getColorExponent(): string;
    /**
     * Gets current value of property {@link #getGradient gradient}.
     *
     * Gradient Definition. Can be either provided as Ressource - then it is type string.
     *  Or as Array [n0,c0,n1,c1,...,nk,ck] (ni > ni-1; ci respective colors) with an arbitrary number of color
     * stops as in the following
     *  Example: [0,'rgba(0,255,0,1)',220,'rgba(255,255,0,1)',255,'rgba(255,0,0,1)']
     *
     *
     * @returns Value of property `gradient`
     */
    getGradient(): any[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * HeatPoint object aggregation
     */
    getItems(): HeatPoint[];
    /**
     * Gets current value of property {@link #getOpacity opacity}.
     *
     * Opacity of the heatmap.
     *
     * Default value is `'0.5'`.
     *
     *
     * @returns Value of property `opacity`
     */
    getOpacity(): string;
    /**
     * Gets current value of property {@link #getRadiusScale radiusScale}.
     *
     * Scaling factor for the sample radiuses.
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Value of property `radiusScale`
     */
    getRadiusScale(): string;
    /**
     * Gets current value of property {@link #getValueScale valueScale}.
     *
     * Scaling factor for the sample values.
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Value of property `valueScale`
     */
    getValueScale(): string;
    /**
     * Checks for the provided `sap.ui.vbm.HeatPoint` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: HeatPoint
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: HeatPoint,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): HeatPoint[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | HeatPoint
    ): HeatPoint | null;
    /**
     * Sets a new value for property {@link #getAlphaExponent alphaExponent}.
     *
     * Exponent for the alphaChannel
     *  aE = 1 : alpha Channel remains linear
     *  0 < aE < 1 : (e.g. aE=0.5 "square root") sub linear alpha channeling (lower value colors remain longer
     * visible; range appears wider)
     *  aE > 1 (e.g. aE=2: "squared") above linear alpha channeling ( lower value colors remain shortly visible;
     * range appears chopped)
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAlphaExponent(
      /**
       * New value for property `alphaExponent`
       */
      sAlphaExponent?: string
    ): this;
    /**
     * Sets a new value for property {@link #getBehavior behavior}.
     *
     * Behavior of the HeatPoint, 0 Density Map, 2: Heat Map, 1: Intermediate.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'2'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBehavior(
      /**
       * New value for property `behavior`
       */
      sBehavior?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorExponent colorExponent}.
     *
     * Exponent for the color
     *  aE = 1 : Linear Gradient
     *  0 < aE < 1 : Sublinear Gradient; i.E. with cE=0.5 point values are square rooted before usage [share
     * of lower value cols will decrease]
     *  aE > 1 : Higher Level Gradient; i.E. with cE=2 point values are squared before usage [share of lower
     * value cols will increase]
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorExponent(
      /**
       * New value for property `colorExponent`
       */
      sColorExponent?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGradient gradient}.
     *
     * Gradient Definition. Can be either provided as Ressource - then it is type string.
     *  Or as Array [n0,c0,n1,c1,...,nk,ck] (ni > ni-1; ci respective colors) with an arbitrary number of color
     * stops as in the following
     *  Example: [0,'rgba(0,255,0,1)',220,'rgba(255,255,0,1)',255,'rgba(255,0,0,1)']
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGradient(
      /**
       * New value for property `gradient`
       */
      sGradient?: any[]
    ): this;
    /**
     * Sets a new value for property {@link #getOpacity opacity}.
     *
     * Opacity of the heatmap.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0.5'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpacity(
      /**
       * New value for property `opacity`
       */
      sOpacity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRadiusScale radiusScale}.
     *
     * Scaling factor for the sample radiuses.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadiusScale(
      /**
       * New value for property `radiusScale`
       */
      sRadiusScale?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueScale valueScale}.
     *
     * Scaling factor for the sample values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1.0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueScale(
      /**
       * New value for property `valueScale`
       */
      sValueScale?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Heatmap constructor.
   */
  export interface $HeatmapSettings extends $VoAbstractSettings {
    /**
     * Gradient Definition. Can be either provided as Ressource - then it is type string.
     *  Or as Array [n0,c0,n1,c1,...,nk,ck] (ni > ni-1; ci respective colors) with an arbitrary number of color
     * stops as in the following
     *  Example: [0,'rgba(0,255,0,1)',220,'rgba(255,255,0,1)',255,'rgba(255,0,0,1)']
     */
    gradient?: any[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Opacity of the heatmap.
     */
    opacity?: string | PropertyBindingInfo;

    /**
     * Behavior of the HeatPoint, 0 Density Map, 2: Heat Map, 1: Intermediate.
     */
    behavior?: string | PropertyBindingInfo;

    /**
     * Scaling factor for the sample values.
     */
    valueScale?: string | PropertyBindingInfo;

    /**
     * Scaling factor for the sample radiuses.
     */
    radiusScale?: string | PropertyBindingInfo;

    /**
     * Exponent for the alphaChannel
     *  aE = 1 : alpha Channel remains linear
     *  0 < aE < 1 : (e.g. aE=0.5 "square root") sub linear alpha channeling (lower value colors remain longer
     * visible; range appears wider)
     *  aE > 1 (e.g. aE=2: "squared") above linear alpha channeling ( lower value colors remain shortly visible;
     * range appears chopped)
     */
    alphaExponent?: string | PropertyBindingInfo;

    /**
     * Exponent for the color
     *  aE = 1 : Linear Gradient
     *  0 < aE < 1 : Sublinear Gradient; i.E. with cE=0.5 point values are square rooted before usage [share
     * of lower value cols will decrease]
     *  aE > 1 : Higher Level Gradient; i.E. with cE=2 point values are squared before usage [share of lower
     * value cols will increase]
     */
    colorExponent?: string | PropertyBindingInfo;

    /**
     * HeatPoint object aggregation
     */
    items?: HeatPoint[] | HeatPoint | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/HeatPoint" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for a HeatPoint.
   */
  export default class HeatPoint extends VoBase {
    /**
     * Constructor for a new HeatPoint.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HeatPointSettings
    );
    /**
     * Constructor for a new HeatPoint.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HeatPointSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.HeatPoint with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HeatPoint>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.HeatPoint.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of a sample element of the heatmap. Should be bound. The format is "lon;lat;0"
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getRadius radius}.
     *
     * Radius of the sample values. May be bound
     *
     * Default value is `'5'`.
     *
     *
     * @returns Value of property `radius`
     */
    getRadius(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Heat Value of the sample element of the heatmap. May be bound.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of a sample element of the heatmap. Should be bound. The format is "lon;lat;0"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRadius radius}.
     *
     * Radius of the sample values. May be bound
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'5'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadius(
      /**
       * New value for property `radius`
       */
      sRadius?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Heat Value of the sample element of the heatmap. May be bound.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HeatPoint constructor.
   */
  export interface $HeatPointSettings extends $VoBaseSettings {
    /**
     * The position of a sample element of the heatmap. Should be bound. The format is "lon;lat;0"
     */
    position?: string | PropertyBindingInfo;

    /**
     * Heat Value of the sample element of the heatmap. May be bound.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Radius of the sample values. May be bound
     */
    radius?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/Legend" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import LegendItem from "sap/ui/vbm/LegendItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The Legend is a window in the GeoMap or AnalyticMap control wich can be used to display color/icon-text
   * pairs on a map.
   */
  export default class Legend extends UI5Element {
    /**
     * Constructor for a new Legend.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LegendSettings
    );
    /**
     * Constructor for a new Legend.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LegendSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Legend with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Legend>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Legend.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: LegendItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Legend`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Legend` itself.
     *
     * The event is raised when there is a click action on a legend.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Legend$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Legend` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Legend`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Legend` itself.
     *
     * The event is raised when there is a click action on a legend.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Legend$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Legend` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.Legend`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Legend$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Legend$ClickEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCaption caption}.
     *
     * The caption of the legend.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Value of property `caption`
     */
    getCaption(): string;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * LegendItem object aggregation
     */
    getItems(): LegendItem[];
    /**
     * Checks for the provided `sap.ui.vbm.LegendItem` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: LegendItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: LegendItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): LegendItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | LegendItem
    ): LegendItem | null;
    /**
     * Sets a new value for property {@link #getCaption caption}.
     *
     * The caption of the legend.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCaption(
      /**
       * New value for property `caption`
       */
      sCaption?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Legend constructor.
   */
  export interface $LegendSettings extends $ElementSettings {
    /**
     * The caption of the legend.
     */
    caption?: string | PropertyBindingInfo;

    /**
     * LegendItem object aggregation
     */
    items?: LegendItem[] | LegendItem | AggregationBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click action on a legend.
     */
    click?: (oEvent: Legend$ClickEvent) => void;
  }

  /**
   * Parameters of the Legend#click event.
   */
  export interface Legend$ClickEventParameters {
    /**
     * Event data object
     */
    data?: object;

    /**
     * The row number where the click occurred
     */
    row?: int;

    /**
     * key modifier Ctrl pressed
     */
    ctrlKey?: boolean;

    /**
     * key modifier Shift pressed
     */
    shiftKey?: boolean;

    /**
     * key modifier Meta pressed
     */
    metaKey?: boolean;

    /**
     * key modifier Alt pressed
     */
    altKey?: boolean;
  }

  /**
   * Event object of the Legend#click event.
   */
  export type Legend$ClickEvent = Event<Legend$ClickEventParameters, Legend>;
}

declare module "sap/ui/vbm/LegendItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SemanticType } from "sap/ui/vbm/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Aggregation element for the Legend. A LegendItem consists of marker and an associated text. The marker
   * is either a rectangle in the given color or the given image or a semantic spot type. If no marker but
   * only a text is provided then it is shown in italic letters and can be regarded as a header.
   */
  export default class LegendItem extends UI5Element {
    /**
     * Constructor for a new LegendItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LegendItemSettings
    );
    /**
     * Constructor for a new LegendItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LegendItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.LegendItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LegendItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.LegendItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.LegendItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.LegendItem` itself.
     *
     * The event is raised when there is a click action on a legend item.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: LegendItem$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.LegendItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.LegendItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.LegendItem` itself.
     *
     * The event is raised when there is a click action on a legend item.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: LegendItem$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.LegendItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.LegendItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: LegendItem$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: LegendItem$ClickEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the legend marker.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getImage image}.
     *
     * The image for the legend marker.
     *
     *
     * @returns Value of property `image`
     */
    getImage(): string;
    /**
     * Gets current value of property {@link #getSemanticSpotType semanticSpotType}.
     *
     * The semantic spot type for the legend marker.
     *
     *
     * @returns Value of property `semanticSpotType`
     */
    getSemanticSpotType(): SemanticType;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * The text of the legend item.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the legend marker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getImage image}.
     *
     * The image for the legend marker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImage(
      /**
       * New value for property `image`
       */
      sImage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticSpotType semanticSpotType}.
     *
     * The semantic spot type for the legend marker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticSpotType(
      /**
       * New value for property `semanticSpotType`
       */
      sSemanticSpotType?: SemanticType | keyof typeof SemanticType
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * The text of the legend item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LegendItem constructor.
   */
  export interface $LegendItemSettings extends $ElementSettings {
    /**
     * The color of the legend marker.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The image for the legend marker.
     */
    image?: string | PropertyBindingInfo;

    /**
     * The semantic spot type for the legend marker.
     */
    semanticSpotType?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The text of the legend item.
     */
    text?: string | PropertyBindingInfo;

    /**
     * The event is raised when there is a click action on a legend item.
     */
    click?: (oEvent: LegendItem$ClickEvent) => void;
  }

  /**
   * Parameters of the LegendItem#click event.
   */
  export interface LegendItem$ClickEventParameters {
    /**
     * Event data object
     */
    data?: object;

    /**
     * key modifier Ctrl pressed
     */
    ctrlKey?: boolean;

    /**
     * key modifier Shift pressed
     */
    shiftKey?: boolean;

    /**
     * key modifier Meta pressed
     */
    metaKey?: boolean;

    /**
     * key modifier Alt pressed
     */
    altKey?: boolean;
  }

  /**
   * Event object of the LegendItem#click event.
   */
  export type LegendItem$ClickEvent = Event<
    LegendItem$ClickEventParameters,
    LegendItem
  >;
}

declare module "sap/ui/vbm/ListPanel" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ListItemBase from "sap/m/ListItemBase";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ListMode } from "sap/m/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Aggregation control for the Legend
   *
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class ListPanel extends Control {
    /**
     * Constructor for a new ListPanel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelSettings
    );
    /**
     * Constructor for a new ListPanel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ListPanel with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ListPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ListPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: ListItemBase
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired if the panel is expanded of collapsed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired if the panel is expanded of collapsed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:headerIconPress headerIconPress} event of this
     * `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired if the header icon is pressed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHeaderIconPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:headerIconPress headerIconPress} event of this
     * `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired if the header icon is pressed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHeaderIconPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPress itemPress} event of this `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired when an item is pressed unless the item's `type` property is `Inactive`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$ItemPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPress itemPress} event of this `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired when an item is pressed unless the item's `type` property is `Inactive`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$ItemPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired when selection is changed via user interaction inside the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.vbm.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.ListPanel` itself.
     *
     * Event is fired when selection is changed via user interaction inside the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:expand expand} event of this `sap.ui.vbm.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachExpand(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:headerIconPress headerIconPress} event of
     * this `sap.ui.vbm.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHeaderIconPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemPress itemPress} event of this `sap.ui.vbm.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ListPanel$ItemPressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.ui.vbm.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ListPanel$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:expand expand} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireExpand(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:headerIconPress headerIconPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHeaderIconPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:itemPress itemPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ListPanel$ItemPressEventParameters
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ListPanel$SelectionChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expandAnimation`
     */
    getExpandAnimation(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getHeaderIcon headerIcon}.
     *
     * Header icon
     *
     *
     * @returns Value of property `headerIcon`
     */
    getHeaderIcon(): URI;
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * Header text
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Item aggregation
     */
    getItems(): ListItemBase[];
    /**
     * Returns selected list item. When no item is selected, "null" is returned. When "multi-selection" is enabled
     * and multiple items are selected, only the up-most selected item is returned.
     *
     *
     * @returns Selected item.
     */
    getSelectedItem(): ListItemBase;
    /**
     * Returns an array containing the selected list items. If no items are selected, an empty array is returned.
     *
     *
     * @returns Selected items
     */
    getSelectedItems(): ListItemBase[];
    /**
     * Gets current value of property {@link #getSelectionMode selectionMode}.
     *
     * Selection Mode
     *
     * Default value is `MultiSelect`.
     *
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode(): ListMode;
    /**
     * Checks for the provided `sap.m.ListItemBase` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: ListItemBase
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: ListItemBase,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): ListItemBase[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | ListItemBase
    ): ListItemBase | null;
    /**
     * Sets a new value for property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandAnimation(
      /**
       * New value for property `expandAnimation`
       */
      bExpandAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderIcon headerIcon}.
     *
     * Header icon
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderIcon(
      /**
       * New value for property `headerIcon`
       */
      sHeaderIcon: URI
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * Header text
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText: string
    ): this;
    /**
     * Selects or deselects the given list item.
     */
    setSelectedItem(
      /**
       * The list item whose selection to be changed. This parameter is mandatory.
       */
      oListItem: ListItemBase,
      /**
       * Sets selected status of the list item. Default value is true.
       */
      bSelect: boolean,
      /**
       * Whether to fire the event or not.
       */
      bFireEvent: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getSelectionMode selectionMode}.
     *
     * Selection Mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MultiSelect`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionMode(
      /**
       * New value for property `selectionMode`
       */
      sSelectionMode?: ListMode | keyof typeof ListMode
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ListPanel constructor.
   *
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $ListPanelSettings extends $ControlSettings {
    /**
     * Header text
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Header icon
     */
    headerIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Expansion state
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Expand animation
     */
    expandAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Selection Mode
     */
    selectionMode?:
      | (ListMode | keyof typeof ListMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Item aggregation
     */
    items?:
      | ListItemBase[]
      | ListItemBase
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Event is fired if the header icon is pressed
     */
    headerIconPress?: (oEvent: Event) => void;

    /**
     * Event is fired if the panel is expanded of collapsed
     */
    expand?: (oEvent: Event) => void;

    /**
     * Event is fired when selection is changed via user interaction inside the control.
     */
    selectionChange?: (oEvent: ListPanel$SelectionChangeEvent) => void;

    /**
     * Event is fired when an item is pressed unless the item's `type` property is `Inactive`.
     */
    itemPress?: (oEvent: ListPanel$ItemPressEvent) => void;
  }

  /**
   * Parameters of the ListPanel#expand event.
   */
  export interface ListPanel$ExpandEventParameters {}

  /**
   * Event object of the ListPanel#expand event.
   */
  export type ListPanel$ExpandEvent = Event<
    ListPanel$ExpandEventParameters,
    ListPanel
  >;

  /**
   * Parameters of the ListPanel#headerIconPress event.
   */
  export interface ListPanel$HeaderIconPressEventParameters {}

  /**
   * Event object of the ListPanel#headerIconPress event.
   */
  export type ListPanel$HeaderIconPressEvent = Event<
    ListPanel$HeaderIconPressEventParameters,
    ListPanel
  >;

  /**
   * Parameters of the ListPanel#itemPress event.
   */
  export interface ListPanel$ItemPressEventParameters {
    /**
     * The item which fired the pressed event.
     */
    listItem?: ListItemBase;

    /**
     * The control which caused the press event within the container.
     */
    srcControl?: Control;
  }

  /**
   * Event object of the ListPanel#itemPress event.
   */
  export type ListPanel$ItemPressEvent = Event<
    ListPanel$ItemPressEventParameters,
    ListPanel
  >;

  /**
   * Parameters of the ListPanel#selectionChange event.
   */
  export interface ListPanel$SelectionChangeEventParameters {
    /**
     * The item whose selection has changed. In `MultiSelect` mode, only the up-most selected item is returned.
     * This parameter can be used for single-selection modes.
     */
    listItem?: ListItemBase;

    /**
     * Array of items whose selection has changed. This parameter can be used for `MultiSelect` mode.
     */
    listItems?: ListItemBase[];

    /**
     * Indicates whether the `listItem` parameter is selected or not.
     */
    selected?: boolean;
  }

  /**
   * Event object of the ListPanel#selectionChange event.
   */
  export type ListPanel$SelectionChangeEvent = Event<
    ListPanel$SelectionChangeEventParameters,
    ListPanel
  >;
}

declare module "sap/ui/vbm/ListPanelStack" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ListPanel from "sap/ui/vbm/ListPanel";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * ListPanelStack control
   *
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class ListPanelStack extends Control {
    /**
     * Constructor for a new ListPanelStack.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelStackSettings
    );
    /**
     * Constructor for a new ListPanelStack.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelStackSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.ListPanelStack with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ListPanelStack>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.ListPanelStack.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: ListPanel
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets current value of property {@link #getCollapsible collapsible}.
     *
     * Ability to collapse
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `collapsible`
     */
    getCollapsible(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     */
    getContent(): ListPanel[];
    /**
     * Gets current value of property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expandAnimation`
     */
    getExpandAnimation(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Control width
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.vbm.ListPanel` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: ListPanel
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: ListPanel,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): ListPanel[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | ListPanel
    ): ListPanel | null;
    /**
     * Sets a new value for property {@link #getCollapsible collapsible}.
     *
     * Ability to collapse
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCollapsible(
      /**
       * New value for property `collapsible`
       */
      bCollapsible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandAnimation(
      /**
       * New value for property `expandAnimation`
       */
      bExpandAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Control width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ListPanelStack constructor.
   *
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $ListPanelStackSettings extends $ControlSettings {
    /**
     * Control width
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Expansion state
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Expand animation
     */
    expandAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Ability to collapse
     */
    collapsible?: boolean | PropertyBindingInfo | `{${string}}`;

    content?: ListPanel[] | ListPanel | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/MapContainer" {
  import {
    default as ContainerBase,
    $ContainerBaseSettings,
  } from "sap/ui/vbm/ContainerBase";

  import ListPanelStack from "sap/ui/vbm/ListPanelStack";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { URI } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Abstract Constructor for a new Container.
   */
  export default class MapContainer extends ContainerBase {
    /**
     * Constructor for a new MapContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MapContainerSettings
    );
    /**
     * Constructor for a new MapContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MapContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.MapContainer with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.ContainerBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MapContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.MapContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the listPanelStack in the aggregation {@link #getListPanelStack listPanelStack}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyListPanelStack(): this;
    /**
     * Gets content of aggregation {@link #getListPanelStack listPanelStack}.
     *
     * List Panel aggregation
     */
    getListPanelStack(): ListPanelStack;
    /**
     * Gets current value of property {@link #getShowHome showHome}.
     *
     * Controls the visibility of the home button
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showHome`
     */
    getShowHome(): boolean;
    /**
     * Gets current value of property {@link #getShowMapLayer showMapLayer}.
     *
     * Controls the visibility of the Map Layer Select
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showMapLayer`
     */
    getShowMapLayer(): boolean;
    /**
     * Gets current value of property {@link #getShowNavbar showNavbar}.
     *
     * Show navbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showNavbar`
     */
    getShowNavbar(): boolean;
    /**
     * Gets current value of property {@link #getShowRectangularZoom showRectangularZoom}.
     *
     * Controls the visibility of the rectangular zoom button
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showRectangularZoom`
     */
    getShowRectangularZoom(): boolean;
    /**
     * Gets current value of property {@link #getShowZoom showZoom}.
     *
     * Controls the visibility of the zoom buttons
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showZoom`
     */
    getShowZoom(): boolean;
    /**
     * Sets the aggregated {@link #getListPanelStack listPanelStack}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setListPanelStack(
      /**
       * The listPanelStack to set
       */
      oListPanelStack: ListPanelStack
    ): this;
    /**
     * Sets a new value for property {@link #getShowHome showHome}.
     *
     * Controls the visibility of the home button
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowHome(
      /**
       * New value for property `showHome`
       */
      bShowHome?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowMapLayer showMapLayer}.
     *
     * Controls the visibility of the Map Layer Select
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowMapLayer(
      /**
       * New value for property `showMapLayer`
       */
      bShowMapLayer?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowNavbar showNavbar}.
     *
     * Show navbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowNavbar(
      /**
       * New value for property `showNavbar`
       */
      bShowNavbar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowRectangularZoom showRectangularZoom}.
     *
     * Controls the visibility of the rectangular zoom button
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRectangularZoom(
      /**
       * New value for property `showRectangularZoom`
       */
      bShowRectangularZoom?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowZoom showZoom}.
     *
     * Controls the visibility of the zoom buttons
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowZoom(
      /**
       * New value for property `showZoom`
       */
      bShowZoom?: boolean
    ): this;
    /**
     * Set custom item on the MapContainer toolbar. All custom items added between selection segment button
     * and setting button.
     *
     *
     * @returns Item configuration object
     */
    setToolbarItem(
      /**
       * Item configuration object.
       */
      item: {
        /**
         * Id of the item for future references.
         */
        id: string;
        /**
         * Relative index of an item across all custom items.
         */
        index: int;
        /**
         * Visibility of an item.
         */
        visible: boolean;
        /**
         * Active item or not.
         */
        active: boolean;
        /**
         * Text of an item.
         */
        text: string;
        /**
         * Tooltip of an item.
         */
        tooltip: string;
        /**
         * If true create Overflow button or standard if false.
         */
        overflow: boolean;
        /**
         * Icon of an item.
         */
        icon: URI;
        /**
         * Alternative icon of an item, see {@link sap.m.Button} for details.
         */
        activeIcon: URI;
        /**
         * The {@link sap.ui.vk.MapContainerButtonType} enum.
         */
        type: string;
        /**
         * Callback function which is called when item gets pressed.
         */
        press: Function;
        /**
         * sets the initial pressed state for a {@link sap.ui.vk.MapContainerButtonType} Toggle button. This does
         * not fire the pressed event handler. It should be used if pressed logic is activated by application code
         * on first load.
         */
        toggled: boolean;
      }
    ): object;
  }
  /**
   * Describes the settings that can be provided to the MapContainer constructor.
   */
  export interface $MapContainerSettings extends $ContainerBaseSettings {
    /**
     * Show navbar
     */
    showNavbar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the home button
     */
    showHome?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Map Layer Select
     */
    showMapLayer?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the rectangular zoom button
     */
    showRectangularZoom?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the zoom buttons
     */
    showZoom?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * List Panel aggregation
     */
    listPanelStack?: ListPanelStack;
  }
}

declare module "sap/ui/vbm/MapContainerButtonType" {
  /**
   * Types of custom buttons supported on the MapContainer toolbar
   */
  enum MapContainerButtonType {
    Click = "Click",

    Toggle = "Toggle",
  }
  export default MapContainerButtonType;
}

declare module "sap/ui/vbm/Pie" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import PieItem from "sap/ui/vbm/PieItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for a Pie Chart. A Pie is a round chart, which is positioned with
   * its centerpoint at the given position. The size of the pie can be controlled with property scale.
   * The slices of the pie chart are defined by the aggregated PieItem elements. The detail window
   * will open at the center of the pie.
   *  The property hotDeltaColor borrowed from VoBase is applied only to the hot PieItem and not the
   * whole pie.
   */
  export default class Pie extends VoBase {
    /**
     * Constructor for a new Pie.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PieSettings
    );
    /**
     * Constructor for a new Pie.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PieSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Pie with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Pie>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Pie.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: PieItem
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * PieItem object aggregation. A PieItem holds the data for one slice in a Pie.
     */
    getItems(): PieItem[];
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of the Pie.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getScale scale}.
     *
     * The scaling of the Pie. The scale must be a vector "x-Scale;y-Scale;z-Scale", but currently only the
     * x scaling is applied to the Pie.
     *
     *
     * @returns Value of property `scale`
     */
    getScale(): string;
    /**
     * Checks for the provided `sap.ui.vbm.PieItem` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: PieItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: PieItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): PieItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | PieItem
    ): PieItem | null;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of the Pie.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getScale scale}.
     *
     * The scaling of the Pie. The scale must be a vector "x-Scale;y-Scale;z-Scale", but currently only the
     * x scaling is applied to the Pie.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScale(
      /**
       * New value for property `scale`
       */
      sScale?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Pie constructor.
   */
  export interface $PieSettings extends $VoBaseSettings {
    /**
     * The position of the Pie.
     */
    position?: string | PropertyBindingInfo;

    /**
     * The scaling of the Pie. The scale must be a vector "x-Scale;y-Scale;z-Scale", but currently only the
     * x scaling is applied to the Pie.
     */
    scale?: string | PropertyBindingInfo;

    /**
     * PieItem object aggregation. A PieItem holds the data for one slice in a Pie.
     */
    items?: PieItem[] | PieItem | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/PieItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Slice element for a Pie Chart.
   */
  export default class PieItem extends UI5Element {
    /**
     * Constructor for a new PieItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PieItemSettings
    );
    /**
     * Constructor for a new PieItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PieItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.PieItem with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PieItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.PieItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.PieItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.PieItem` itself.
     *
     * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
     * includes Pie Item index when event occurs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.PieItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.PieItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.PieItem` itself.
     *
     * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
     * includes Pie Item index when event occurs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.PieItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.PieItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
     * includes Pie Item index when event occurs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
     * includes Pie Item index when event occurs.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the Pie Item.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * The name of the Pie item.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The value of the Pie item.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the Pie Item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * The name of the Pie item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The value of the Pie item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PieItem constructor.
   */
  export interface $PieItemSettings extends $ElementSettings {
    /**
     * The name of the Pie item.
     */
    name?: string | PropertyBindingInfo;

    /**
     * The value of the Pie item.
     */
    value?: string | PropertyBindingInfo;

    /**
     * The color of the Pie Item.
     */
    color?: string | PropertyBindingInfo;

    /**
     * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
     * includes Pie Item index when event occurs.
     */
    click?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the PieItem#click event.
   *
   * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
   * includes Pie Item index when event occurs.
   */
  export interface PieItem$ClickEventParameters {}

  /**
   * Event object of the PieItem#click event.
   *
   * @deprecated As of version 1.31. This event should no longer be used. Click event from Pie and Pies now
   * includes Pie Item index when event occurs.
   */
  export type PieItem$ClickEvent = Event<PieItem$ClickEventParameters, PieItem>;
}

declare module "sap/ui/vbm/Pies" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import Pie from "sap/ui/vbm/Pie";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for Pie instances.
   */
  export default class Pies extends VoAggregation {
    /**
     * Constructor for a new Pies.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PiesSettings
    );
    /**
     * Constructor for a new Pies.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PiesSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Pies with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Pies>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Pies.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Pie
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Pie object aggregation
     */
    getItems(): Pie[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Gets current value of property {@link #getScaleChangeable scaleChangeable}.
     *
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `scaleChangeable`
     */
    getScaleChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.Pie` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Pie
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Pie,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Pie[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Pie
    ): Pie | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getScaleChangeable scaleChangeable}.
     *
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScaleChangeable(
      /**
       * New value for property `scaleChangeable`
       */
      bScaleChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Pies constructor.
   */
  export interface $PiesSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    scaleChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Pie object aggregation
     */
    items?: Pie[] | Pie | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Region" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { CSSColor } from "sap/ui/core/library";

  import { SemanticType } from "sap/ui/vbm/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Region properties.
   */
  export default class Region extends UI5Element {
    /**
     * Constructor for a new Region.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $RegionSettings
    );
    /**
     * Constructor for a new Region.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $RegionSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Region with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Region>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Region.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Region`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Region` itself.
     *
     * The event is raised when there is a click action on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Region$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Region` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Region`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Region` itself.
     *
     * The event is raised when there is a click action on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Region$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Region` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Region`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Region` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Region$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Region` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Region`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Region` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a region.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Region$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Region` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.Region`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Region$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Region`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Region$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Region$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Region$ContextMenuEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCode code}.
     *
     * The region code.
     *
     *
     * @returns Value of property `code`
     */
    getCode(): string;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color, this must be provided in the rgba(r,g,b,a) format.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Returns Infos for the Region like name, bounding box and midpoint
     *
     *
     * @returns Region Information Object. Object has the properties BBox: Bounding Box for Region in format
     * "lonMin;latMin;lonMax;latMax", Midpoint: Centerpoint for Region in format "lon;lat", Name: Name of the
     * region, and Properties: Array of name-value-pair associated with the region
     */
    getInfo(): object;
    /**
     * Gets current value of property {@link #getLabelArrow labelArrow}.
     *
     * The visual objects label arrow. For left/right/top/bottom aligned labels an additional arrow points to
     * the label's object.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `labelArrow`
     */
    getLabelArrow(): boolean;
    /**
     * Gets current value of property {@link #getLabelBgColor labelBgColor}.
     *
     * Default value is `'RGB(255;255;255)'`.
     *
     *
     * @returns Value of property `labelBgColor`
     */
    getLabelBgColor(): string;
    /**
     * Gets current value of property {@link #getLabelBorderColor labelBorderColor}.
     *
     *
     * @returns Value of property `labelBorderColor`
     */
    getLabelBorderColor(): string;
    /**
     * Gets current value of property {@link #getLabelText labelText}.
     *
     *
     * @returns Value of property `labelText`
     */
    getLabelText(): string;
    /**
     * Gets current value of property {@link #getLabelType labelType}.
     *
     * Type for semantic labels. A given semantic type will overrule color settings and add an icon.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `labelType`
     */
    getLabelType(): SemanticType;
    /**
     * Gets current value of property {@link #getSelect select}.
     *
     * set to true if the element is selected
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `select`
     */
    getSelect(): boolean;
    /**
     * Sets a new value for property {@link #getCode code}.
     *
     * The region code.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCode(
      /**
       * New value for property `code`
       */
      sCode?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color, this must be provided in the rgba(r,g,b,a) format.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getLabelArrow labelArrow}.
     *
     * The visual objects label arrow. For left/right/top/bottom aligned labels an additional arrow points to
     * the label's object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelArrow(
      /**
       * New value for property `labelArrow`
       */
      bLabelArrow?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLabelBgColor labelBgColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(255;255;255)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelBgColor(
      /**
       * New value for property `labelBgColor`
       */
      sLabelBgColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelBorderColor labelBorderColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelBorderColor(
      /**
       * New value for property `labelBorderColor`
       */
      sLabelBorderColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelText labelText}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelText(
      /**
       * New value for property `labelText`
       */
      sLabelText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelType labelType}.
     *
     * Type for semantic labels. A given semantic type will overrule color settings and add an icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelType(
      /**
       * New value for property `labelType`
       */
      sLabelType?: SemanticType | keyof typeof SemanticType
    ): this;
    /**
     * Sets a new value for property {@link #getSelect select}.
     *
     * set to true if the element is selected
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelect(
      /**
       * New value for property `select`
       */
      bSelect?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Region constructor.
   */
  export interface $RegionSettings extends $ElementSettings {
    /**
     * The color, this must be provided in the rgba(r,g,b,a) format.
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The region code.
     */
    code?: string | PropertyBindingInfo;

    /**
     * set to true if the element is selected
     */
    select?: boolean | PropertyBindingInfo | `{${string}}`;

    labelText?: string | PropertyBindingInfo;

    /**
     * Type for semantic labels. A given semantic type will overrule color settings and add an icon.
     */
    labelType?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;

    labelBgColor?: string | PropertyBindingInfo;

    labelBorderColor?: string | PropertyBindingInfo;

    /**
     * The visual objects label arrow. For left/right/top/bottom aligned labels an additional arrow points to
     * the label's object.
     */
    labelArrow?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click action on a region.
     */
    click?: (oEvent: Region$ClickEvent) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a region.
     */
    contextMenu?: (oEvent: Region$ContextMenuEvent) => void;
  }

  /**
   * Parameters of the Region#click event.
   */
  export interface Region$ClickEventParameters {
    /**
     * The region code.
     */
    code?: string;
  }

  /**
   * Event object of the Region#click event.
   */
  export type Region$ClickEvent = Event<Region$ClickEventParameters, Region>;

  /**
   * Parameters of the Region#contextMenu event.
   */
  export interface Region$ContextMenuEventParameters {
    /**
     * The region code.
     */
    code?: string;
  }

  /**
   * Event object of the Region#contextMenu event.
   */
  export type Region$ContextMenuEvent = Event<
    Region$ContextMenuEventParameters,
    Region
  >;
}

declare module "sap/ui/vbm/Resource" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A resource is a Base64 encoded representation of an image binary that can be referenced by name in e.g.
   * a Spot element. When images are specified as a string resource it is guaranteed that the control
   * can access the bits in the image. If just a URL to the resource is given it is loaded and converted to
   * a Base64 encoded binary. This happens asynchronously and it may require several re-renderings of the
   * control until all resource show up correctly.
   */
  export default class Resource extends UI5Element {
    /**
     * Constructor for a new Resource.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ResourceSettings
    );
    /**
     * Constructor for a new Resource.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ResourceSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Resource with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Resource>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Resource.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Name of the resource. The name should be always used when a resource is referenced.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getSrc src}.
     *
     * URL to an image. It is important that the image data is readable fom the visual business control. Therefore
     * e.g. images coming from a local drive or cross domains are not allowed. The preferred way is to use the
     * Base64 encoded data provided using the value property.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `src`
     */
    getSrc(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Value of the resource. Base64 endode binary.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Name of the resource. The name should be always used when a resource is referenced.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSrc src}.
     *
     * URL to an image. It is important that the image data is readable fom the visual business control. Therefore
     * e.g. images coming from a local drive or cross domains are not allowed. The preferred way is to use the
     * Base64 encoded data provided using the value property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSrc(
      /**
       * New value for property `src`
       */
      sSrc?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Value of the resource. Base64 endode binary.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Resource constructor.
   */
  export interface $ResourceSettings extends $ElementSettings {
    /**
     * Value of the resource. Base64 endode binary.
     */
    value?: string | PropertyBindingInfo;

    /**
     * URL to an image. It is important that the image data is readable fom the visual business control. Therefore
     * e.g. images coming from a local drive or cross domains are not allowed. The preferred way is to use the
     * Base64 encoded data provided using the value property.
     */
    src?: string | PropertyBindingInfo;

    /**
     * Name of the resource. The name should be always used when a resource is referenced.
     */
    name?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vbm/Route" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import DragSource from "sap/ui/vbm/DragSource";

  import DropTarget from "sap/ui/vbm/DropTarget";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { RouteType } from "sap/ui/vbm/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for a Route. A Route is a polyline, which is given as a list of
   * geo-coordinates. In order to indicate direction an arrow head can be added at start and end. Further
   * it is possible to have a dot at each point of the coordinate list.
   *  Since the actual length of a route depends on the zoom level it might be only partly visible. Thus detail
   * windows will be dynamically positioned in the middle of the visible route part.
   *  A Route supports GeoMap internal drag'n drop with fine grained control on matching drag sources and
   * drop targets. A drag'n drop operation is possible if any type in the drag source aggregation of the dragged
   * visual object matches a type in the drop target aggregation of the target vo. Drag source and drop target
   * types defined on element level apply only for a single element instance, except the element is used as
   * template.
   */
  export default class Route extends VoBase {
    /**
     * Constructor for a new Route.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $RouteSettings
    );
    /**
     * Constructor for a new Route.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $RouteSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Route with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Route>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Route.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some dragSource to the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDragSource(
      /**
       * The dragSource to add; if empty, nothing is inserted
       */
      oDragSource: DragSource
    ): this;
    /**
     * Adds some dropTarget to the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDropTarget(
      /**
       * The dropTarget to add; if empty, nothing is inserted
       */
      oDropTarget: DropTarget
    ): this;
    /**
     * Destroys all the dragSource in the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDragSource(): this;
    /**
     * Destroys all the dropTarget in the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDropTarget(): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the route.
     *
     * Default value is `'RGB(0;0;0)'`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getColorBorder colorBorder}.
     *
     * The border color of the route.
     *
     *
     * @returns Value of property `colorBorder`
     */
    getColorBorder(): string;
    /**
     * Gets current value of property {@link #getDirectionIndicator directionIndicator}.
     *
     * Set to true if intermediate triangles along the route should show the direction only applicable if arrow
     * head is defined ( start and/or end ) it is not recommended to use line dots in addition because the direction
     * indicators generate additional line points at their head and base positions
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `directionIndicator`
     */
    getDirectionIndicator(): boolean;
    /**
     * Gets current value of property {@link #getDotbordercolor dotbordercolor}.
     *
     * The border color of the line dots of a route.
     *
     * Default value is `'RGB(0;0;0)'`.
     *
     *
     * @returns Value of property `dotbordercolor`
     */
    getDotbordercolor(): string;
    /**
     * Gets current value of property {@link #getDotcolor dotcolor}.
     *
     * The color for the line dots of a route.
     *
     * Default value is `'RGB(0;0;0)'`.
     *
     *
     * @returns Value of property `dotcolor`
     */
    getDotcolor(): string;
    /**
     * Gets current value of property {@link #getDotwidth dotwidth}.
     *
     * The diameter of a dot in a route.
     *
     * Default value is `'0'`.
     *
     *
     * @returns Value of property `dotwidth`
     */
    getDotwidth(): string;
    /**
     * Gets content of aggregation {@link #getDragSource dragSource}.
     *
     * DragSource aggregation
     */
    getDragSource(): DragSource[];
    /**
     * Gets content of aggregation {@link #getDropTarget dropTarget}.
     *
     * DropTarget aggregation
     */
    getDropTarget(): DropTarget[];
    /**
     * Gets current value of property {@link #getEnd end}.
     *
     * The end point type of the route.
     * 	0: no endpoint 1: arrow as endpoint
     *
     * Default value is `'0'`.
     *
     *
     * @returns Value of property `end`
     */
    getEnd(): string;
    /**
     * Gets current value of property {@link #getLineDash lineDash}.
     *
     * Defines the dashing style of the route using an array. The first value gives the length of the stroke
     * and the second the length of the gap. Thus "1;1", would result in a doted line. However, strokes are
     * painted with rounded endings. Thus the actual stroke length depends also on the line width. As a sample
     * a stroke of 1 pixel length and a line width of 6 will result in at least 6 pixels total length. In that
     * case the line dashing should be set to "1;6" for an equal length of stroke and gap!
     *  The line dashing array can be extended to achive more complex pattern, e.g. "1;1;5;2" and so on.
     *
     *
     * @returns Value of property `lineDash`
     */
    getLineDash(): string;
    /**
     * Gets current value of property {@link #getLinewidth linewidth}.
     *
     * The width of the route line. With width 0 no line is drawn.
     *
     * Default value is `'3'`.
     *
     *
     * @returns Value of property `linewidth`
     */
    getLinewidth(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position array of the route. The format is "lon0;lat0;0;...lonN;latN;0".
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getRoutetype routetype}.
     *
     * Defines the type of the route, default is 'Straight'. Other types are 'Geodesic' which show the shortest
     * path between two points, e.g. flightroutes
     *
     * Default value is `'Straight'`.
     *
     * @experimental As of version 1.32.0. this method is experimental and might be modified or removed in future
     * versions.
     *
     * @returns Value of property `routetype`
     */
    getRoutetype(): RouteType;
    /**
     * Gets current value of property {@link #getStart start}.
     *
     * The start point type of the route.
     * 	0: no startpoint 1: arrow head as startpoint
     *
     * Default value is `'0'`.
     *
     *
     * @returns Value of property `start`
     */
    getStart(): string;
    /**
     * Checks for the provided `sap.ui.vbm.DragSource` in the aggregation {@link #getDragSource dragSource}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDragSource(
      /**
       * The dragSource whose index is looked for
       */
      oDragSource: DragSource
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.DropTarget` in the aggregation {@link #getDropTarget dropTarget}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDropTarget(
      /**
       * The dropTarget whose index is looked for
       */
      oDropTarget: DropTarget
    ): int;
    /**
     * Inserts a dragSource into the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDragSource(
      /**
       * The dragSource to insert; if empty, nothing is inserted
       */
      oDragSource: DragSource,
      /**
       * The `0`-based index the dragSource should be inserted at; for a negative value of `iIndex`, the dragSource
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dragSource
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a dropTarget into the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDropTarget(
      /**
       * The dropTarget to insert; if empty, nothing is inserted
       */
      oDropTarget: DropTarget,
      /**
       * The `0`-based index the dropTarget should be inserted at; for a negative value of `iIndex`, the dropTarget
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dropTarget
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDragSource dragSource}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDragSource(): DragSource[];
    /**
     * Removes all the controls from the aggregation {@link #getDropTarget dropTarget}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDropTarget(): DropTarget[];
    /**
     * Removes a dragSource from the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns The removed dragSource or `null`
     */
    removeDragSource(
      /**
       * The dragSource to remove or its index or id
       */
      vDragSource: int | string | DragSource
    ): DragSource | null;
    /**
     * Removes a dropTarget from the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns The removed dropTarget or `null`
     */
    removeDropTarget(
      /**
       * The dropTarget to remove or its index or id
       */
      vDropTarget: int | string | DropTarget
    ): DropTarget | null;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the route.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(0;0;0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorBorder colorBorder}.
     *
     * The border color of the route.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorBorder(
      /**
       * New value for property `colorBorder`
       */
      sColorBorder: string
    ): this;
    /**
     * Sets a new value for property {@link #getDirectionIndicator directionIndicator}.
     *
     * Set to true if intermediate triangles along the route should show the direction only applicable if arrow
     * head is defined ( start and/or end ) it is not recommended to use line dots in addition because the direction
     * indicators generate additional line points at their head and base positions
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDirectionIndicator(
      /**
       * New value for property `directionIndicator`
       */
      bDirectionIndicator?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDotbordercolor dotbordercolor}.
     *
     * The border color of the line dots of a route.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(0;0;0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDotbordercolor(
      /**
       * New value for property `dotbordercolor`
       */
      sDotbordercolor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDotcolor dotcolor}.
     *
     * The color for the line dots of a route.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(0;0;0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDotcolor(
      /**
       * New value for property `dotcolor`
       */
      sDotcolor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDotwidth dotwidth}.
     *
     * The diameter of a dot in a route.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDotwidth(
      /**
       * New value for property `dotwidth`
       */
      sDotwidth?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnd end}.
     *
     * The end point type of the route.
     * 	0: no endpoint 1: arrow as endpoint
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnd(
      /**
       * New value for property `end`
       */
      sEnd?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLineDash lineDash}.
     *
     * Defines the dashing style of the route using an array. The first value gives the length of the stroke
     * and the second the length of the gap. Thus "1;1", would result in a doted line. However, strokes are
     * painted with rounded endings. Thus the actual stroke length depends also on the line width. As a sample
     * a stroke of 1 pixel length and a line width of 6 will result in at least 6 pixels total length. In that
     * case the line dashing should be set to "1;6" for an equal length of stroke and gap!
     *  The line dashing array can be extended to achive more complex pattern, e.g. "1;1;5;2" and so on.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLineDash(
      /**
       * New value for property `lineDash`
       */
      sLineDash: string
    ): this;
    /**
     * Sets a new value for property {@link #getLinewidth linewidth}.
     *
     * The width of the route line. With width 0 no line is drawn.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'3'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLinewidth(
      /**
       * New value for property `linewidth`
       */
      sLinewidth?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position array of the route. The format is "lon0;lat0;0;...lonN;latN;0".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRoutetype routetype}.
     *
     * Defines the type of the route, default is 'Straight'. Other types are 'Geodesic' which show the shortest
     * path between two points, e.g. flightroutes
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'Straight'`.
     *
     * @experimental As of version 1.32.0. this method is experimental and might be modified or removed in future
     * versions.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRoutetype(
      /**
       * New value for property `routetype`
       */
      sRoutetype?: RouteType | keyof typeof RouteType
    ): this;
    /**
     * Sets a new value for property {@link #getStart start}.
     *
     * The start point type of the route.
     * 	0: no startpoint 1: arrow head as startpoint
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStart(
      /**
       * New value for property `start`
       */
      sStart?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Route constructor.
   */
  export interface $RouteSettings extends $VoBaseSettings {
    /**
     * The position array of the route. The format is "lon0;lat0;0;...lonN;latN;0".
     */
    position?: string | PropertyBindingInfo;

    /**
     * The color of the route.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The start point type of the route.
     * 	0: no startpoint 1: arrow head as startpoint
     */
    start?: string | PropertyBindingInfo;

    /**
     * The end point type of the route.
     * 	0: no endpoint 1: arrow as endpoint
     */
    end?: string | PropertyBindingInfo;

    /**
     * The width of the route line. With width 0 no line is drawn.
     */
    linewidth?: string | PropertyBindingInfo;

    /**
     * The color for the line dots of a route.
     */
    dotcolor?: string | PropertyBindingInfo;

    /**
     * The border color of the line dots of a route.
     */
    dotbordercolor?: string | PropertyBindingInfo;

    /**
     * The border color of the route.
     */
    colorBorder?: string | PropertyBindingInfo;

    /**
     * Defines the dashing style of the route using an array. The first value gives the length of the stroke
     * and the second the length of the gap. Thus "1;1", would result in a doted line. However, strokes are
     * painted with rounded endings. Thus the actual stroke length depends also on the line width. As a sample
     * a stroke of 1 pixel length and a line width of 6 will result in at least 6 pixels total length. In that
     * case the line dashing should be set to "1;6" for an equal length of stroke and gap!
     *  The line dashing array can be extended to achive more complex pattern, e.g. "1;1;5;2" and so on.
     */
    lineDash?: string | PropertyBindingInfo;

    /**
     * The diameter of a dot in a route.
     */
    dotwidth?: string | PropertyBindingInfo;

    /**
     * Defines the type of the route, default is 'Straight'. Other types are 'Geodesic' which show the shortest
     * path between two points, e.g. flightroutes
     *
     * @experimental As of version 1.32.0. this method is experimental and might be modified or removed in future
     * versions.
     */
    routetype?:
      | (RouteType | keyof typeof RouteType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Set to true if intermediate triangles along the route should show the direction only applicable if arrow
     * head is defined ( start and/or end ) it is not recommended to use line dots in addition because the direction
     * indicators generate additional line points at their head and base positions
     */
    directionIndicator?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * DragSource aggregation
     */
    dragSource?:
      | DragSource[]
      | DragSource
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * DropTarget aggregation
     */
    dropTarget?:
      | DropTarget[]
      | DropTarget
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Routes" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
    VoAggregation$ClickEventParameters,
    VoAggregation$ContextMenuEventParameters,
    VoAggregation$DropEventParameters,
  } from "sap/ui/vbm/VoAggregation";

  import DragSource from "sap/ui/vbm/DragSource";

  import DropTarget from "sap/ui/vbm/DropTarget";

  import Route from "sap/ui/vbm/Route";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for Route elements.
   *  Routes support GeoMap internal drag'n drop with fine grained control on matching drag sources and drop
   * targets. A drag'n drop operation is possible if any type in the drag source aggregation of the dragged
   * visual object matches a type in the drop target aggregation of the target vo. If drag source and drop
   * target types are defined on aggregation level they apply for all aggregated elements.
   */
  export default class Routes extends VoAggregation {
    /**
     * Constructor for a new Routes.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $RoutesSettings
    );
    /**
     * Constructor for a new Routes.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $RoutesSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Routes with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Routes>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Routes.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some dragSource to the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDragSource(
      /**
       * The dragSource to add; if empty, nothing is inserted
       */
      oDragSource: DragSource
    ): this;
    /**
     * Adds some dropTarget to the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDropTarget(
      /**
       * The dropTarget to add; if empty, nothing is inserted
       */
      oDropTarget: DropTarget
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Route
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Routes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Routes` itself.
     *
     * The event is raised when there is a click action on a Route.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Routes` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.Routes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Routes` itself.
     *
     * The event is raised when there is a click action on a Route.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Routes` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Routes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Routes` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a Route.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Routes` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Routes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Routes` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a Route.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Routes` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.Routes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Routes` itself.
     *
     * The event is raised when something is dropped on a Route.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Routes` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.Routes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Routes` itself.
     *
     * The event is raised when something is dropped on a Route.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Routes` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the dragSource in the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDragSource(): this;
    /**
     * Destroys all the dropTarget in the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDropTarget(): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.Routes`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.Routes`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:drop drop} event of this `sap.ui.vbm.Routes`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDrop(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:drop drop} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDrop(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getDragSource dragSource}.
     *
     * DragSource aggregation
     */
    getDragSource(): DragSource[];
    /**
     * Gets content of aggregation {@link #getDropTarget dropTarget}.
     *
     * DropTarget aggregation
     */
    getDropTarget(): DropTarget[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Route object aggregation
     */
    getItems(): Route[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.DragSource` in the aggregation {@link #getDragSource dragSource}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDragSource(
      /**
       * The dragSource whose index is looked for
       */
      oDragSource: DragSource
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.DropTarget` in the aggregation {@link #getDropTarget dropTarget}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDropTarget(
      /**
       * The dropTarget whose index is looked for
       */
      oDropTarget: DropTarget
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.Route` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Route
    ): int;
    /**
     * Inserts a dragSource into the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDragSource(
      /**
       * The dragSource to insert; if empty, nothing is inserted
       */
      oDragSource: DragSource,
      /**
       * The `0`-based index the dragSource should be inserted at; for a negative value of `iIndex`, the dragSource
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dragSource
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a dropTarget into the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDropTarget(
      /**
       * The dropTarget to insert; if empty, nothing is inserted
       */
      oDropTarget: DropTarget,
      /**
       * The `0`-based index the dropTarget should be inserted at; for a negative value of `iIndex`, the dropTarget
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dropTarget
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Route,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDragSource dragSource}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDragSource(): DragSource[];
    /**
     * Removes all the controls from the aggregation {@link #getDropTarget dropTarget}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDropTarget(): DropTarget[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Route[];
    /**
     * Removes a dragSource from the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns The removed dragSource or `null`
     */
    removeDragSource(
      /**
       * The dragSource to remove or its index or id
       */
      vDragSource: int | string | DragSource
    ): DragSource | null;
    /**
     * Removes a dropTarget from the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns The removed dropTarget or `null`
     */
    removeDropTarget(
      /**
       * The dropTarget to remove or its index or id
       */
      vDropTarget: int | string | DropTarget
    ): DropTarget | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Route
    ): Route | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Routes constructor.
   */
  export interface $RoutesSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Route object aggregation
     */
    items?: Route[] | Route | AggregationBindingInfo | `{${string}}`;

    /**
     * DragSource aggregation
     */
    dragSource?:
      | DragSource[]
      | DragSource
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * DropTarget aggregation
     */
    dropTarget?:
      | DropTarget[]
      | DropTarget
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * The event is raised when there is a click action on a Route.
     */
    click?: (oEvent: Event) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a Route.
     */
    contextMenu?: (oEvent: Event) => void;

    /**
     * The event is raised when something is dropped on a Route.
     */
    drop?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Routes#click event.
   */
  export interface Routes$ClickEventParameters
    extends VoAggregation$ClickEventParameters {}

  /**
   * Event object of the Routes#click event.
   */
  export type Routes$ClickEvent = Event<Routes$ClickEventParameters, Routes>;

  /**
   * Parameters of the Routes#contextMenu event.
   */
  export interface Routes$ContextMenuEventParameters
    extends VoAggregation$ContextMenuEventParameters {}

  /**
   * Event object of the Routes#contextMenu event.
   */
  export type Routes$ContextMenuEvent = Event<
    Routes$ContextMenuEventParameters,
    Routes
  >;

  /**
   * Parameters of the Routes#drop event.
   */
  export interface Routes$DropEventParameters
    extends VoAggregation$DropEventParameters {}

  /**
   * Event object of the Routes#drop event.
   */
  export type Routes$DropEvent = Event<Routes$DropEventParameters, Routes>;
}

declare module "sap/ui/vbm/Spot" {
  import { default as VoBase, $VoBaseSettings } from "sap/ui/vbm/VoBase";

  import DragSource from "sap/ui/vbm/DragSource";

  import DropTarget from "sap/ui/vbm/DropTarget";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SemanticType } from "sap/ui/vbm/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Specific Visual Object element for a Spot. A Spot is actually an image drawn at the given position.
   * There are two modes for using spots:
   * 	 - A controlled mode by providing a spot type. In this mode many properties for the spot are automatically
   *     set by programmed defaults according to the Fiori guidelines.
   * 	 - A freestyle mode, providing the full control on colors and layout.  Beside the visualization
   *     with an image a spot can have an icon or text, which can be controlled and positioned using
   *     the content properties.
   *  A Spot supports GeoMap internal drag'n drop with fine grained control on matching drag sources and drop
   * targets. A drag'n drop operation is possible if any type in the drag source aggregation of the dragged
   * visual object matches a type in the drop target aggregation of the target vo. Drag source and drop target
   * types defined on element level apply only for a single element instance, except the element is used as
   * template.
   */
  export default class Spot extends VoBase {
    /**
     * Constructor for a new Spot.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SpotSettings
    );
    /**
     * Constructor for a new Spot.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SpotSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Spot with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Spot>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Spot.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some dragSource to the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDragSource(
      /**
       * The dragSource to add; if empty, nothing is inserted
       */
      oDragSource: DragSource
    ): this;
    /**
     * Adds some dropTarget to the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDropTarget(
      /**
       * The dropTarget to add; if empty, nothing is inserted
       */
      oDropTarget: DropTarget
    ): this;
    /**
     * Destroys all the dragSource in the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDragSource(): this;
    /**
     * Destroys all the dropTarget in the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDropTarget(): this;
    /**
     * Gets current value of property {@link #getAlignment alignment}.
     *
     * Alignment of the spot to its position:
     * 	0: center 1: top center 2: top right 3: center right 4: bottom right 5: bottom center
     * 6: bottom left 7: center left 8: top left
     *
     * Default value is `'5'`.
     *
     *
     * @returns Value of property `alignment`
     */
    getAlignment(): string;
    /**
     * Gets current value of property {@link #getContentColor contentColor}.
     *
     * The color of the content ( icon or text ).
     *
     *
     * @returns Value of property `contentColor`
     */
    getContentColor(): string;
    /**
     * Gets current value of property {@link #getContentFont contentFont}.
     *
     * The font of the spot's text. If icon is used then the font is automatically set to"SAP-icons".
     *
     * Default value is `'arial'`.
     *
     *
     * @returns Value of property `contentFont`
     */
    getContentFont(): string;
    /**
     * Gets current value of property {@link #getContentOffset contentOffset}.
     *
     * The offset from the center of the image where to place the content ( text or icon ) in x;y- direction
     *
     * Default value is `'0;0'`.
     *
     *
     * @returns Value of property `contentOffset`
     */
    getContentOffset(): string;
    /**
     * Gets current value of property {@link #getContentSize contentSize}.
     *
     * The font size to be used for text or icon
     *
     *
     * @returns Value of property `contentSize`
     */
    getContentSize(): string;
    /**
     * Gets content of aggregation {@link #getDragSource dragSource}.
     *
     * DragSource aggregation
     */
    getDragSource(): DragSource[];
    /**
     * Gets content of aggregation {@link #getDropTarget dropTarget}.
     *
     * DropTarget aggregation
     */
    getDropTarget(): DropTarget[];
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * The icon to be rendered on the spot. Note that either text or icon may be displayed ( not both together
     * ). Use the CharCode-Id of SAPUI5-Icons (e.g.: "\ue146")
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets current value of property {@link #getImage image}.
     *
     * The image for the spot. This must be a reference to a resource.
     *
     *
     * @returns Value of property `image`
     */
    getImage(): string;
    /**
     * Gets current value of property {@link #getImageSelected imageSelected}.
     *
     * The image for the spot when selected. This must be a reference to a resource.
     *
     *
     * @returns Value of property `imageSelected`
     */
    getImageSelected(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of the spot. The format is "lon;lat;0"
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getScale scale}.
     *
     * The scale of the spot. The format is "x-Scale;y-Scale;z-Scale". The z-Scale is curretly ignored.
     *
     * Default value is `'1;1;1'`.
     *
     *
     * @returns Value of property `scale`
     */
    getScale(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * The text that is displayed on the spot. The text should not exceed a few characters. Note that either
     * text or icon may be displayed ( not both together ).
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Spot type for semantic spots. A given semantic type will overrule settings for image, scale, and content.
     *
     *
     * @returns Value of property `type`
     */
    getType(): SemanticType;
    /**
     * Checks for the provided `sap.ui.vbm.DragSource` in the aggregation {@link #getDragSource dragSource}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDragSource(
      /**
       * The dragSource whose index is looked for
       */
      oDragSource: DragSource
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.DropTarget` in the aggregation {@link #getDropTarget dropTarget}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDropTarget(
      /**
       * The dropTarget whose index is looked for
       */
      oDropTarget: DropTarget
    ): int;
    /**
     * Inserts a dragSource into the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDragSource(
      /**
       * The dragSource to insert; if empty, nothing is inserted
       */
      oDragSource: DragSource,
      /**
       * The `0`-based index the dragSource should be inserted at; for a negative value of `iIndex`, the dragSource
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dragSource
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a dropTarget into the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDropTarget(
      /**
       * The dropTarget to insert; if empty, nothing is inserted
       */
      oDropTarget: DropTarget,
      /**
       * The `0`-based index the dropTarget should be inserted at; for a negative value of `iIndex`, the dropTarget
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dropTarget
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDragSource dragSource}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDragSource(): DragSource[];
    /**
     * Removes all the controls from the aggregation {@link #getDropTarget dropTarget}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDropTarget(): DropTarget[];
    /**
     * Removes a dragSource from the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns The removed dragSource or `null`
     */
    removeDragSource(
      /**
       * The dragSource to remove or its index or id
       */
      vDragSource: int | string | DragSource
    ): DragSource | null;
    /**
     * Removes a dropTarget from the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns The removed dropTarget or `null`
     */
    removeDropTarget(
      /**
       * The dropTarget to remove or its index or id
       */
      vDropTarget: int | string | DropTarget
    ): DropTarget | null;
    /**
     * Sets a new value for property {@link #getAlignment alignment}.
     *
     * Alignment of the spot to its position:
     * 	0: center 1: top center 2: top right 3: center right 4: bottom right 5: bottom center
     * 6: bottom left 7: center left 8: top left
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'5'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAlignment(
      /**
       * New value for property `alignment`
       */
      sAlignment?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContentColor contentColor}.
     *
     * The color of the content ( icon or text ).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentColor(
      /**
       * New value for property `contentColor`
       */
      sContentColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContentFont contentFont}.
     *
     * The font of the spot's text. If icon is used then the font is automatically set to"SAP-icons".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'arial'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentFont(
      /**
       * New value for property `contentFont`
       */
      sContentFont?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContentOffset contentOffset}.
     *
     * The offset from the center of the image where to place the content ( text or icon ) in x;y- direction
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0;0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentOffset(
      /**
       * New value for property `contentOffset`
       */
      sContentOffset?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContentSize contentSize}.
     *
     * The font size to be used for text or icon
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentSize(
      /**
       * New value for property `contentSize`
       */
      sContentSize?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * The icon to be rendered on the spot. Note that either text or icon may be displayed ( not both together
     * ). Use the CharCode-Id of SAPUI5-Icons (e.g.: "\ue146")
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getImage image}.
     *
     * The image for the spot. This must be a reference to a resource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImage(
      /**
       * New value for property `image`
       */
      sImage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getImageSelected imageSelected}.
     *
     * The image for the spot when selected. This must be a reference to a resource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImageSelected(
      /**
       * New value for property `imageSelected`
       */
      sImageSelected?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of the spot. The format is "lon;lat;0"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0;0;0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getScale scale}.
     *
     * The scale of the spot. The format is "x-Scale;y-Scale;z-Scale". The z-Scale is curretly ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1;1;1'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScale(
      /**
       * New value for property `scale`
       */
      sScale?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * The text that is displayed on the spot. The text should not exceed a few characters. Note that either
     * text or icon may be displayed ( not both together ).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Spot type for semantic spots. A given semantic type will overrule settings for image, scale, and content.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: SemanticType | keyof typeof SemanticType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Spot constructor.
   */
  export interface $SpotSettings extends $VoBaseSettings {
    /**
     * The position of the spot. The format is "lon;lat;0"
     */
    position?: string | PropertyBindingInfo;

    /**
     * The text that is displayed on the spot. The text should not exceed a few characters. Note that either
     * text or icon may be displayed ( not both together ).
     */
    text?: string | PropertyBindingInfo;

    /**
     * The image for the spot. This must be a reference to a resource.
     */
    image?: string | PropertyBindingInfo;

    /**
     * Alignment of the spot to its position:
     * 	0: center 1: top center 2: top right 3: center right 4: bottom right 5: bottom center
     * 6: bottom left 7: center left 8: top left
     */
    alignment?: string | PropertyBindingInfo;

    /**
     * The scale of the spot. The format is "x-Scale;y-Scale;z-Scale". The z-Scale is curretly ignored.
     */
    scale?: string | PropertyBindingInfo;

    /**
     * The image for the spot when selected. This must be a reference to a resource.
     */
    imageSelected?: string | PropertyBindingInfo;

    /**
     * The icon to be rendered on the spot. Note that either text or icon may be displayed ( not both together
     * ). Use the CharCode-Id of SAPUI5-Icons (e.g.: "\ue146")
     */
    icon?: string | PropertyBindingInfo;

    /**
     * The color of the content ( icon or text ).
     */
    contentColor?: string | PropertyBindingInfo;

    /**
     * The offset from the center of the image where to place the content ( text or icon ) in x;y- direction
     */
    contentOffset?: string | PropertyBindingInfo;

    /**
     * The font of the spot's text. If icon is used then the font is automatically set to"SAP-icons".
     */
    contentFont?: string | PropertyBindingInfo;

    /**
     * The font size to be used for text or icon
     */
    contentSize?: string | PropertyBindingInfo;

    /**
     * Spot type for semantic spots. A given semantic type will overrule settings for image, scale, and content.
     */
    type?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * DragSource aggregation
     */
    dragSource?:
      | DragSource[]
      | DragSource
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * DropTarget aggregation
     */
    dropTarget?:
      | DropTarget[]
      | DropTarget
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vbm/Spots" {
  import {
    default as VoAggregation,
    $VoAggregationSettings,
  } from "sap/ui/vbm/VoAggregation";

  import DragSource from "sap/ui/vbm/DragSource";

  import DropTarget from "sap/ui/vbm/DropTarget";

  import Spot from "sap/ui/vbm/Spot";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Type specific Visual Object aggregation for Spot elements.
   *  Spots support GeoMap internal drag'n drop with fine grained control on matching drag sources and drop
   * targets. A drag'n drop operation is possible if any type in the drag source aggregation of the dragged
   * visual object matches a type in the drop target aggregation of the target vo. If drag source and drop
   * target types are defined on aggregation level they apply for all aggregated elements.
   */
  export default class Spots extends VoAggregation {
    /**
     * Constructor for a new Spots.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SpotsSettings
    );
    /**
     * Constructor for a new Spots.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SpotsSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.Spots with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAggregation.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Spots>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Spots.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some dragSource to the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDragSource(
      /**
       * The dragSource to add; if empty, nothing is inserted
       */
      oDragSource: DragSource
    ): this;
    /**
     * Adds some dropTarget to the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDropTarget(
      /**
       * The dropTarget to add; if empty, nothing is inserted
       */
      oDropTarget: DropTarget
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Spot
    ): this;
    /**
     * Destroys all the dragSource in the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDragSource(): this;
    /**
     * Destroys all the dropTarget in the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDropTarget(): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getDragSource dragSource}.
     *
     * DragSource aggregation
     */
    getDragSource(): DragSource[];
    /**
     * Gets content of aggregation {@link #getDropTarget dropTarget}.
     *
     * DropTarget aggregation
     */
    getDropTarget(): DropTarget[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * spot object aggregation
     */
    getItems(): Spot[];
    /**
     * Gets current value of property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `posChangeable`
     */
    getPosChangeable(): boolean;
    /**
     * Gets current value of property {@link #getScaleChangeable scaleChangeable}.
     *
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `scaleChangeable`
     */
    getScaleChangeable(): boolean;
    /**
     * Checks for the provided `sap.ui.vbm.DragSource` in the aggregation {@link #getDragSource dragSource}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDragSource(
      /**
       * The dragSource whose index is looked for
       */
      oDragSource: DragSource
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.DropTarget` in the aggregation {@link #getDropTarget dropTarget}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDropTarget(
      /**
       * The dropTarget whose index is looked for
       */
      oDropTarget: DropTarget
    ): int;
    /**
     * Checks for the provided `sap.ui.vbm.Spot` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Spot
    ): int;
    /**
     * Inserts a dragSource into the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDragSource(
      /**
       * The dragSource to insert; if empty, nothing is inserted
       */
      oDragSource: DragSource,
      /**
       * The `0`-based index the dragSource should be inserted at; for a negative value of `iIndex`, the dragSource
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dragSource
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a dropTarget into the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDropTarget(
      /**
       * The dropTarget to insert; if empty, nothing is inserted
       */
      oDropTarget: DropTarget,
      /**
       * The `0`-based index the dropTarget should be inserted at; for a negative value of `iIndex`, the dropTarget
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dropTarget
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Spot,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDragSource dragSource}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDragSource(): DragSource[];
    /**
     * Removes all the controls from the aggregation {@link #getDropTarget dropTarget}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDropTarget(): DropTarget[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Spot[];
    /**
     * Removes a dragSource from the aggregation {@link #getDragSource dragSource}.
     *
     *
     * @returns The removed dragSource or `null`
     */
    removeDragSource(
      /**
       * The dragSource to remove or its index or id
       */
      vDragSource: int | string | DragSource
    ): DragSource | null;
    /**
     * Removes a dropTarget from the aggregation {@link #getDropTarget dropTarget}.
     *
     *
     * @returns The removed dropTarget or `null`
     */
    removeDropTarget(
      /**
       * The dropTarget to remove or its index or id
       */
      vDropTarget: int | string | DropTarget
    ): DropTarget | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Spot
    ): Spot | null;
    /**
     * Sets a new value for property {@link #getPosChangeable posChangeable}.
     *
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosChangeable(
      /**
       * New value for property `posChangeable`
       */
      bPosChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getScaleChangeable scaleChangeable}.
     *
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScaleChangeable(
      /**
       * New value for property `scaleChangeable`
       */
      bScaleChangeable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Spots constructor.
   */
  export interface $SpotsSettings extends $VoAggregationSettings {
    /**
     * Set to true if position may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    posChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set to true if scale may be changed at runtime. The actual changeability is control on each aggregated
     * element with property changeable.
     */
    scaleChangeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * spot object aggregation
     */
    items?: Spot[] | Spot | AggregationBindingInfo | `{${string}}`;

    /**
     * DragSource aggregation
     */
    dragSource?:
      | DragSource[]
      | DragSource
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * DropTarget aggregation
     */
    dropTarget?:
      | DropTarget[]
      | DropTarget
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vbm/VBI" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import { ClusterInfoType } from "sap/ui/vbm/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The VBI control. This is the Visual Business base control, which is mainly intended to communicate directly
   * with the Visual Business Backend API in a proprietary JSON format. This control should not be used directly
   * in a client side application. For this the control extension sap.ui.vbm.GeoMap
   * is recommended.
   *  The main or high level API of the VBI control is made of
   * 	 - method load for sending JSON to the control for processing, and
   * 	 - event submit returning a result JSON as parameter data containing actual event information
   *     and changed data.  Further the high level API provides the thumbnail support.
   *  Additionally the control offers a low level API made of several events, like render, zoom, move and
   * so on, which allow to render application specific content directly on the controls canvas.
   */
  export default class VBI extends Control {
    /**
     * Constructor for a new VBI.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VBISettings
    );
    /**
     * Constructor for a new VBI.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VBISettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.VBI with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VBI>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.VBI.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Add dependant child control for rendering.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    addRenderItem(
      /**
       * Child control to render
       */
      oControl: object,
      /**
       * ID of DOM element the child to append to
       */
      targetElemId: string
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeTrackingMode changeTrackingMode} event
     * of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. Tracking mode is set or reset. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeTrackingMode(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ChangeTrackingModeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeTrackingMode changeTrackingMode} event
     * of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. Tracking mode is set or reset. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeTrackingMode(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ChangeTrackingModeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:closeWindow closeWindow} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised before a Visual Business window is closed. This function is not supported in plugin
     * mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCloseWindow(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$CloseWindowEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:closeWindow closeWindow} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised before a Visual Business window is closed. This function is not supported in plugin
     * mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCloseWindow(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$CloseWindowEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:containerCreated containerCreated} event of
     * this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised when a Visual Business container VO instance is created. It is intended to be used
     * to place arbitrary content in e.g. other controls. This event is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContainerCreated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ContainerCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:containerCreated containerCreated} event of
     * this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised when a Visual Business container VO instance is created. It is intended to be used
     * to place arbitrary content in e.g. other controls. This event is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContainerCreated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ContainerCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:containerDestroyed containerDestroyed} event
     * of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised before a Visual Business container VO instance is destroyed. This function is not
     * supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContainerDestroyed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ContainerDestroyedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:containerDestroyed containerDestroyed} event
     * of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised before a Visual Business container VO instance is destroyed. This function is not
     * supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContainerDestroyed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ContainerDestroyedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:move move} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. The canvas was moved. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMove(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$MoveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:move move} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. The canvas was moved. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMove(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$MoveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:openWindow openWindow} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised before a Visual Business window is opened. It is intended to be used to place arbitrary
     * content in e.g. a Detail Window. This event is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOpenWindow(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$OpenWindowEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:openWindow openWindow} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * The event is raised before a Visual Business window is opened. It is intended to be used to place arbitrary
     * content in e.g. a Detail Window. This event is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOpenWindow(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$OpenWindowEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:render render} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. Rendering of the canvas content is reqested. This event can be used to do custom rendering
     * into the Visual Business overlay canvas. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRender(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$RenderEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:render render} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. Rendering of the canvas content is reqested. This event can be used to do custom rendering
     * into the Visual Business overlay canvas. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRender(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$RenderEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:submit submit} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * High level API. Submit event is raised.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSubmit(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$SubmitEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:submit submit} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * High level API. Submit event is raised.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSubmit(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$SubmitEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:thumbnailClick thumbnailClick} event of this
     * `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * High level API. ThumbnailClick event is raised.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachThumbnailClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ThumbnailClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:thumbnailClick thumbnailClick} event of this
     * `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * High level API. ThumbnailClick event is raised.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachThumbnailClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ThumbnailClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoom zoom} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. The canvas is zoomed. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoom(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ZoomEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoom zoom} event of this `sap.ui.vbm.VBI`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VBI` itself.
     *
     * Low level API. The canvas is zoomed. This function is not supported in plugin mode.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoom(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VBI$ZoomEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VBI` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:changeTrackingMode changeTrackingMode} event
     * of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChangeTrackingMode(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$ChangeTrackingModeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:closeWindow closeWindow} event of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCloseWindow(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$CloseWindowEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:containerCreated containerCreated} event of
     * this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContainerCreated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$ContainerCreatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:containerDestroyed containerDestroyed} event
     * of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContainerDestroyed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$ContainerDestroyedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:move move} event of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMove(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$MoveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:openWindow openWindow} event of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOpenWindow(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$OpenWindowEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:render render} event of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRender(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$RenderEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:submit submit} event of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSubmit(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$SubmitEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:thumbnailClick thumbnailClick} event of this
     * `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachThumbnailClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$ThumbnailClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:zoom zoom} event of this `sap.ui.vbm.VBI`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachZoom(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VBI$ZoomEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:changeTrackingMode changeTrackingMode} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChangeTrackingMode(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$ChangeTrackingModeEventParameters
    ): this;
    /**
     * Fires event {@link #event:closeWindow closeWindow} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCloseWindow(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$CloseWindowEventParameters
    ): this;
    /**
     * Fires event {@link #event:containerCreated containerCreated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContainerCreated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$ContainerCreatedEventParameters
    ): this;
    /**
     * Fires event {@link #event:containerDestroyed containerDestroyed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContainerDestroyed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$ContainerDestroyedEventParameters
    ): this;
    /**
     * Fires event {@link #event:move move} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMove(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$MoveEventParameters
    ): this;
    /**
     * Fires event {@link #event:openWindow openWindow} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOpenWindow(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$OpenWindowEventParameters
    ): this;
    /**
     * Fires event {@link #event:render render} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRender(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$RenderEventParameters
    ): this;
    /**
     * Fires event {@link #event:submit submit} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSubmit(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$SubmitEventParameters
    ): this;
    /**
     * Fires event {@link #event:thumbnailClick thumbnailClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireThumbnailClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$ThumbnailClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:zoom zoom} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireZoom(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VBI$ZoomEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAllowKeyEventRepeat allowKeyEventRepeat}.
     *
     * Allow repeating of keyboard events when key is pressed and hold.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `allowKeyEventRepeat`
     */
    getAllowKeyEventRepeat(): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Gets current value of property {@link #getAriaLabel ariaLabel}.
     *
     * Text to be read out for the Control when used in accessibility mode (Screen reader)
     *
     *
     * @returns Value of property `ariaLabel`
     */
    getAriaLabel(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getConfig config}.
     *
     * @deprecated As of version 1.31. This property should not longer be used. Its functionality is covered
     * by method `load`.
     *
     * @returns Value of property `config`
     */
    getConfig(): object;
    /**
     * Gets current value of property {@link #getEnableOverlappingTest enableOverlappingTest}.
     *
     * Enable Test for Overlapped Objects for selection and context menu
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableOverlappingTest`
     */
    getEnableOverlappingTest(): boolean;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Set the height of the control.
     *
     * Default value is `'600px'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Retrieve information on a specific cluster object.
     *
     * Type :
     * 	 - 0 : contained VOs
     * 	 - 1 : child clusters (tree clustering only)
     * 	 - 2 : parent Node (tree clustering only)
     * 	 - 10 : Information on Node
     * 	 - 11 : Edges of the Voronoi Area (tree clustering only, not merged with rectangle)
     *
     *
     * @returns Cluster Info Object with requested info according to given Cluster Info Type
     */
    getInfoForCluster(
      /**
       * Cluster Id
       */
      sIdent: string,
      /**
       * Type of information which should be returned
       */
      iType: ClusterInfoType
    ): Object;
    /**
     * Gets current value of property {@link #getKeyEventDelay keyEventDelay}.
     *
     * Miminum delay between keyboard events. Used to reduce frequency of keyboard events.
     *
     * Default value is `250`.
     *
     *
     * @returns Value of property `keyEventDelay`
     */
    getKeyEventDelay(): int;
    /**
     * Gets current value of property {@link #getLassoSelection lassoSelection}.
     *
     * Defines whether the lasso selection mode is active or not
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `lassoSelection`
     */
    getLassoSelection(): boolean;
    /**
     * Returns a Screenshot of the Overlay. Please note that the map cannot be included due to browser restrictions.
     * Function returns the visible part of the Canvas excluding map, copyright info, navigation control, scaler,
     * legend, detail windows, container elements. Analytic Maps are returned as they are not treated as "maps"
     * internally. Modes 2 & 3 are experimental, trying to load the map (this may work on inhouse servers with
     * adapted settings, standard configurations should fail)
     *
     *
     * @returns Base64 encoded picture (PNG format) on success, "" otherwise
     */
    getPicOfOverlay(
      /**
       * 0: Overlay only; 1 (default) and 3: include Labels; 2 and 3: try to include maps (will return "" if not
       * possible)
       */
      iMode?: int
    ): string;
    /**
     * Gets current value of property {@link #getPlugin plugin}.
     *
     * When true, the ActiveX plugin version of Visual Business will be used for rendering. For that the plugin
     * needs to be installed on the client. Default (false) the control renders on canvas.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `plugin`
     */
    getPlugin(): boolean;
    /**
     * Gets current value of property {@link #getRectangularSelection rectangularSelection}.
     *
     * Defines whether the rectangular selection mode is active or not
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `rectangularSelection`
     */
    getRectangularSelection(): boolean;
    /**
     * Gets current value of property {@link #getRectZoom rectZoom}.
     *
     * Defines whether the rectangular zoom mode is active or not
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `rectZoom`
     */
    getRectZoom(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Set the width of the control.
     *
     * Default value is `'800px'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * High level load function. The function accepts a json string or an already parsed json object. This can
     * be a Visual Business application, any delta operations on the application or other hierachical data that
     * can be mapped by the Visual Business data provider to the inner Visual Business data context.
     */
    load(
      /**
       * Application JSON to process
       */
      dat: string
    ): void;
    /**
     * Maximize from Thumbnail.
     */
    maximize(
      /**
       * Width of the underlying VBI control. If ommitted current width is taken
       */
      iFullWidth?: int,
      /**
       * Height of the underlying control. If ommitted current width is taken
       */
      iFullHeight?: int
    ): void;
    /**
     * Minimize to Thumbnail.
     */
    minimize(
      /**
       * Width of the thumbnail
       */
      iNewWidth: int,
      /**
       * Height of the thumbnail
       */
      iNewHeight: int,
      /**
       * Width of the underlying VBI control. If ommitted or zero, current width is taken
       */
      iFullWidth?: int,
      /**
       * Height of the underlying control. If ommitted or zero, current width is taken
       */
      iFullHeight?: int,
      /**
       * Font to be used for text added to the thumbnail
       */
      font?: string,
      /**
       * Color for the thumbnailtext
       */
      fontCol?: string,
      /**
       * Position (0 - 8) of the text within the thumbnail
       */
      fontPos?: int,
      /**
       * text to be shown
       */
      text?: string
    ): void;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAllowKeyEventRepeat allowKeyEventRepeat}.
     *
     * Allow repeating of keyboard events when key is pressed and hold.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowKeyEventRepeat(
      /**
       * New value for property `allowKeyEventRepeat`
       */
      bAllowKeyEventRepeat?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAriaLabel ariaLabel}.
     *
     * Text to be read out for the Control when used in accessibility mode (Screen reader)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAriaLabel(
      /**
       * New value for property `ariaLabel`
       */
      sAriaLabel: string
    ): this;
    /**
     * Sets a new value for property {@link #getConfig config}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.31. This property should not longer be used. Its functionality is covered
     * by method `load`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConfig(
      /**
       * New value for property `config`
       */
      oConfig?: object
    ): this;
    /**
     * Sets a new value for property {@link #getEnableOverlappingTest enableOverlappingTest}.
     *
     * Enable Test for Overlapped Objects for selection and context menu
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableOverlappingTest(
      /**
       * New value for property `enableOverlappingTest`
       */
      bEnableOverlappingTest?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Set the height of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'600px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getKeyEventDelay keyEventDelay}.
     *
     * Miminum delay between keyboard events. Used to reduce frequency of keyboard events.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `250`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKeyEventDelay(
      /**
       * New value for property `keyEventDelay`
       */
      iKeyEventDelay?: int
    ): this;
    /**
     * Set Tracking Mode for Lasso Selection on/off.
     *
     *
     * @returns This allows method chaining
     */
    setLassoSelection(
      /**
       * to start or stop tracking mode
       */
      bSet: boolean
    ): VBI;
    /**
     * Sets a new value for property {@link #getPlugin plugin}.
     *
     * When true, the ActiveX plugin version of Visual Business will be used for rendering. For that the plugin
     * needs to be installed on the client. Default (false) the control renders on canvas.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlugin(
      /**
       * New value for property `plugin`
       */
      bPlugin?: boolean
    ): this;
    /**
     * Set Tracking Mode for Rectangular Selection on/off.
     *
     *
     * @returns This allows method chaining
     */
    setRectangularSelection(
      /**
       * to start or stop tracking mode
       */
      bSet: boolean
    ): VBI;
    /**
     * Set Tracking Mode for Rectangular Zoom on/off.
     *
     *
     * @returns This allows method chaining
     */
    setRectZoom(
      /**
       * to start or stop tracking mode
       */
      bSet: boolean
    ): VBI;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Set the width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'800px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Zoom to one or multiple Areas. This function works only for the main geo scene in the Visual Business
     * control.
     */
    zoomToAreas(
      /**
       * List of Area Ids to zoom to.
       */
      aAreaList: any[],
      /**
       * . This correction factor deals with the space which is reserved to the div borders. The Correction factor
       * can be expressed either in a fracture (e.g. 0.9, this means 10% space to the borders) or array of pixel
       * values (order left, top, right, bottom) for the added margin of the calculated zoom area, e.g. [450,150,0,0]
       * which keeps a left border of 450 pixels and a top border of 150 pixels.
       */
      corr: float
    ): void;
    /**
     * Zoom to one or multiple geo positions. This function works only for the main geo scene in the Visual
     * Business control.
     */
    zoomToGeoPosition(
      /**
       * Longitude in degrees. This can also be an array of longitude values.
       */
      fLon: float,
      /**
       * Latitude in degrees. This can also be an array of latitude values.
       */
      fLat: float,
      /**
       * Level of detail, usually between 0 and 20. This will be limited by the map provider capabilities.
       */
      iLod: int
    ): void;
  }
  /**
   * Describes the settings that can be provided to the VBI constructor.
   */
  export interface $VBISettings extends $ControlSettings {
    /**
     * Set the width of the control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the height of the control.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * @deprecated As of version 1.31. This property should not longer be used. Its functionality is covered
     * by method `load`.
     */
    config?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * When true, the ActiveX plugin version of Visual Business will be used for rendering. For that the plugin
     * needs to be installed on the client. Default (false) the control renders on canvas.
     */
    plugin?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the rectangular selection mode is active or not
     */
    rectangularSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the lasso selection mode is active or not
     */
    lassoSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the rectangular zoom mode is active or not
     */
    rectZoom?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow repeating of keyboard events when key is pressed and hold.
     */
    allowKeyEventRepeat?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Miminum delay between keyboard events. Used to reduce frequency of keyboard events.
     */
    keyEventDelay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Enable Test for Overlapped Objects for selection and context menu
     */
    enableOverlappingTest?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Text to be read out for the Control when used in accessibility mode (Screen reader)
     */
    ariaLabel?: string | PropertyBindingInfo;

    /**
     * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledBy).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * High level API. Submit event is raised.
     */
    submit?: (oEvent: VBI$SubmitEvent) => void;

    /**
     * High level API. ThumbnailClick event is raised.
     */
    thumbnailClick?: (oEvent: VBI$ThumbnailClickEvent) => void;

    /**
     * Low level API. Rendering of the canvas content is reqested. This event can be used to do custom rendering
     * into the Visual Business overlay canvas. This function is not supported in plugin mode.
     */
    render?: (oEvent: VBI$RenderEvent) => void;

    /**
     * Low level API. Tracking mode is set or reset. This function is not supported in plugin mode.
     */
    changeTrackingMode?: (oEvent: VBI$ChangeTrackingModeEvent) => void;

    /**
     * Low level API. The canvas is zoomed. This function is not supported in plugin mode.
     */
    zoom?: (oEvent: VBI$ZoomEvent) => void;

    /**
     * Low level API. The canvas was moved. This function is not supported in plugin mode.
     */
    move?: (oEvent: VBI$MoveEvent) => void;

    /**
     * The event is raised before a Visual Business window is opened. It is intended to be used to place arbitrary
     * content in e.g. a Detail Window. This event is not supported in plugin mode.
     */
    openWindow?: (oEvent: VBI$OpenWindowEvent) => void;

    /**
     * The event is raised before a Visual Business window is closed. This function is not supported in plugin
     * mode.
     */
    closeWindow?: (oEvent: VBI$CloseWindowEvent) => void;

    /**
     * The event is raised when a Visual Business container VO instance is created. It is intended to be used
     * to place arbitrary content in e.g. other controls. This event is not supported in plugin mode.
     */
    containerCreated?: (oEvent: VBI$ContainerCreatedEvent) => void;

    /**
     * The event is raised before a Visual Business container VO instance is destroyed. This function is not
     * supported in plugin mode.
     */
    containerDestroyed?: (oEvent: VBI$ContainerDestroyedEvent) => void;
  }

  /**
   * Parameters of the VBI#changeTrackingMode event.
   */
  export interface VBI$ChangeTrackingModeEventParameters {
    /**
     * tracking mode to set or reset
     */
    mode?: int;

    /**
     * set or reset the mode
     */
    bSet?: boolean;
  }

  /**
   * Event object of the VBI#changeTrackingMode event.
   */
  export type VBI$ChangeTrackingModeEvent = Event<
    VBI$ChangeTrackingModeEventParameters,
    VBI
  >;

  /**
   * Parameters of the VBI#closeWindow event.
   */
  export interface VBI$CloseWindowEventParameters {
    /**
     * DomRef of placeholder Div for content.
     */
    contentarea?: object;

    /**
     * ID of the window that is closed.
     */
    id?: string;
  }

  /**
   * Event object of the VBI#closeWindow event.
   */
  export type VBI$CloseWindowEvent = Event<VBI$CloseWindowEventParameters, VBI>;

  /**
   * Parameters of the VBI#containerCreated event.
   */
  export interface VBI$ContainerCreatedEventParameters {
    /**
     * DomRef of placeholder Div to render into.
     */
    contentarea?: object;

    /**
     * ID of the container that was created.
     */
    id?: string;
  }

  /**
   * Event object of the VBI#containerCreated event.
   */
  export type VBI$ContainerCreatedEvent = Event<
    VBI$ContainerCreatedEventParameters,
    VBI
  >;

  /**
   * Parameters of the VBI#containerDestroyed event.
   */
  export interface VBI$ContainerDestroyedEventParameters {
    /**
     * DomRef of placeholder Div of content.
     */
    contentarea?: object;

    /**
     * ID of the container that is destroyed.
     */
    id?: string;
  }

  /**
   * Event object of the VBI#containerDestroyed event.
   */
  export type VBI$ContainerDestroyedEvent = Event<
    VBI$ContainerDestroyedEventParameters,
    VBI
  >;

  /**
   * Parameters of the VBI#move event.
   */
  export interface VBI$MoveEventParameters {
    /**
     * Canvas object to render into.
     */
    canvas?: object;
  }

  /**
   * Event object of the VBI#move event.
   */
  export type VBI$MoveEvent = Event<VBI$MoveEventParameters, VBI>;

  /**
   * Parameters of the VBI#openWindow event.
   */
  export interface VBI$OpenWindowEventParameters {
    /**
     * DomRef of placeholder Div to render into.
     */
    contentarea?: object;

    /**
     * ID of the window that is opened.
     */
    id?: string;
  }

  /**
   * Event object of the VBI#openWindow event.
   */
  export type VBI$OpenWindowEvent = Event<VBI$OpenWindowEventParameters, VBI>;

  /**
   * Parameters of the VBI#render event.
   */
  export interface VBI$RenderEventParameters {
    /**
     * Canvas object to render into.
     */
    canvas?: object;
  }

  /**
   * Event object of the VBI#render event.
   */
  export type VBI$RenderEvent = Event<VBI$RenderEventParameters, VBI>;

  /**
   * Parameters of the VBI#submit event.
   */
  export interface VBI$SubmitEventParameters {
    /**
     * JSON (or possibly XML and case the plugin is used) string describing the delta state of Visual Business
     * and the information about the event.
     */
    data?: string;
  }

  /**
   * Event object of the VBI#submit event.
   */
  export type VBI$SubmitEvent = Event<VBI$SubmitEventParameters, VBI>;

  /**
   * Parameters of the VBI#thumbnailClick event.
   */
  export interface VBI$ThumbnailClickEventParameters {
    /**
     * Geo coordinates in format "lon;lat;0"
     */
    pos?: string;

    /**
     * Level of detail.
     */
    zoomLevel?: int;
  }

  /**
   * Event object of the VBI#thumbnailClick event.
   */
  export type VBI$ThumbnailClickEvent = Event<
    VBI$ThumbnailClickEventParameters,
    VBI
  >;

  /**
   * Parameters of the VBI#zoom event.
   */
  export interface VBI$ZoomEventParameters {
    /**
     * Canvas object to render into
     */
    canvas?: object;
  }

  /**
   * Event object of the VBI#zoom event.
   */
  export type VBI$ZoomEvent = Event<VBI$ZoomEventParameters, VBI>;
}

declare module "sap/ui/vbm/Viewport" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Provides a control for three js canvas.
   */
  export default class Viewport extends Control {
    /**
     * Constructor for a new three js viewport for Adapter3D.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vbm.Viewport with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Viewport>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.Viewport.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cameraChange cameraChange} event of this `sap.ui.vbm.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Viewport` itself.
     *
     * This event is fired when camera positioning changed (whole movement has been finished)
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCameraChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cameraChange cameraChange} event of this `sap.ui.vbm.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.Viewport` itself.
     *
     * This event is fired when camera positioning changed (whole movement has been finished)
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCameraChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cameraChange cameraChange} event of this `sap.ui.vbm.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCameraChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:cameraChange cameraChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCameraChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$CameraChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCameraHistoryLength cameraHistoryLength}.
     *
     * Camera history length (read only)
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `cameraHistoryLength`
     */
    getCameraHistoryLength(): int;
    /**
     * Gets current value of property {@link #getCameraHistoryPos cameraHistoryPos}.
     *
     * Camera history position
     *
     *
     * @returns Value of property `cameraHistoryPos`
     */
    getCameraHistoryPos(): int;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Viewport height
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Viewport width
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getCameraHistoryLength cameraHistoryLength}.
     *
     * Camera history length (read only)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCameraHistoryLength(
      /**
       * New value for property `cameraHistoryLength`
       */
      iCameraHistoryLength?: int
    ): this;
    /**
     * Sets a new value for property {@link #getCameraHistoryPos cameraHistoryPos}.
     *
     * Camera history position
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCameraHistoryPos(
      /**
       * New value for property `cameraHistoryPos`
       */
      iCameraHistoryPos: int
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Viewport height
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Viewport width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Viewport constructor.
   */
  export interface $ViewportSettings extends $ControlSettings {
    /**
     * Viewport width
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Viewport height
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Camera history length (read only)
     */
    cameraHistoryLength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Camera history position
     */
    cameraHistoryPos?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * This event is fired when camera positioning changed (whole movement has been finished)
     */
    cameraChange?: (oEvent: Viewport$CameraChangeEvent) => void;
  }

  /**
   * Parameters of the Viewport#cameraChange event.
   */
  export interface Viewport$CameraChangeEventParameters {
    /**
     * Current position in camera history
     */
    historyPos?: int;

    /**
     * Camera history length
     */
    historyLength?: int;
  }

  /**
   * Event object of the Viewport#cameraChange event.
   */
  export type Viewport$CameraChangeEvent = Event<
    Viewport$CameraChangeEventParameters,
    Viewport
  >;
}

declare module "sap/ui/vbm/VoAbstract" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import VoBase from "sap/ui/vbm/VoBase";

  import Menu from "sap/ui/unified/Menu";

  /**
   * Abstract VO aggregation container. This element implements the common part for VOs. It must not be used
   * directly, but is the base for further extension.
   */
  export default abstract class VoAbstract extends UI5Element {
    /**
     * Constructor for a new VoAbstract.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VoAbstractSettings
    );
    /**
     * Constructor for a new VoAbstract.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VoAbstractSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.VoAbstract with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VoAbstract>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.VoAbstract.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Open a context menu
     */
    openContextMenu(
      /**
       * Type of VO
       */
      sType: string,
      /**
       * VO instance for which the Context Menu should be opened
       */
      oVoInst: VoBase,
      /**
       * the context menu to be opened
       */
      oMenu: Menu
    ): void;
  }
  /**
   * Describes the settings that can be provided to the VoAbstract constructor.
   */
  export interface $VoAbstractSettings extends $ElementSettings {}
}

declare module "sap/ui/vbm/VoAggregation" {
  import {
    default as VoAbstract,
    $VoAbstractSettings,
  } from "sap/ui/vbm/VoAbstract";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import VoBase from "sap/ui/vbm/VoBase";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  import Menu from "sap/ui/unified/Menu";

  import Spot from "sap/ui/vbm/Spot";

  /**
   * Abstract VO aggregation container. This element implements the common part for all specific VO aggregations
   * with selection cardinatities. It must not be used directly, but is the base for further extension.
   */
  export default abstract class VoAggregation extends VoAbstract {
    /**
     * Constructor for a new VoAggregation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VoAggregationSettings
    );
    /**
     * Constructor for a new VoAggregation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VoAggregationSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.VoAggregation with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vbm.VoAbstract.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VoAggregation>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.VoAggregation.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * The event is raised when there is a click action on a VO.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * The event is raised when there is a click action on a VO.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a VO.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a VO.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselect deselect} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when aggregated elements get deselected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$DeselectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselect deselect} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when aggregated elements get deselected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$DeselectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * The event is raised when something is dropped on a VO.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$DropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * The event is raised when something is dropped on a VO.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$DropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleClick handleClick} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when a Design handle is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleClick handleClick} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when a Design handle is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleContextMenu handleContextMenu} event of
     * this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when a Design handle is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleContextMenu handleContextMenu} event of
     * this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when a Design handle is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleMoved handleMoved} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when a Design handle is moved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleMoved(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleMovedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleMoved handleMoved} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when a Design handle is moved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleMoved(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleMovedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when aggregated elements get selected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$SelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.ui.vbm.VoAggregation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoAggregation` itself.
     *
     * This event is raised when aggregated elements get selected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoAggregation$SelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoAggregation` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselect deselect} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$DeselectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:drop drop} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDrop(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$DropEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleClick handleClick} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleContextMenu handleContextMenu} event
     * of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleMoved handleMoved} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleMoved(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$HandleMovedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:select select} event of this `sap.ui.vbm.VoAggregation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoAggregation$SelectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$ContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:deselect deselect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$DeselectEventParameters
    ): this;
    /**
     * Fires event {@link #event:drop drop} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDrop(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$DropEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleClick handleClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$HandleClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleContextMenu handleContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$HandleContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleMoved handleMoved} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleMoved(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$HandleMovedEventParameters
    ): this;
    /**
     * Fires event {@link #event:select select} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoAggregation$SelectEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCustomProperties customProperties}.
     *
     * If you want to add custom data to VO instances and make the GeoMap control aware of it, e.g. for basing
     * clustering rules on it, you can provide an array of property names specifying the keys to consider.
     *
     *
     * @returns Value of property `customProperties`
     */
    getCustomProperties(): string[];
    /**
     * Gets current value of property {@link #getMaxSel maxSel}.
     *
     * Selection cardinality: maximum selectable elements ( valid values are "0", "1", and "n" )
     *
     * Default value is `"n"`.
     *
     *
     * @returns Value of property `maxSel`
     */
    getMaxSel(): string;
    /**
     * Gets current value of property {@link #getMinSel minSel}.
     *
     * Selection cardinality: minimum selected elements ("0" or "1" )
     *
     * Default value is `"0"`.
     *
     *
     * @returns Value of property `minSel`
     */
    getMinSel(): string;
    /**
     * Open a Detail Window
     */
    openDetailWindow(
      /**
       * VO instance for which the Detail Window should be opened
       */
      oVoInst: VoBase,
      /**
       * Parameter object
       */
      oParams: {
        /**
         * Text for Detail Window caption
         */
        caption: string;
        /**
         * position offset in x-direction from the anchor point
         */
        offsetX: string;
        /**
         * position offset in y-direction from the anchor point
         */
        offsetY: string;
      },
      /**
       * Indicates whether the Detail Window should be located at the click position or object position
       */
      bUseClickPos: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getCustomProperties customProperties}.
     *
     * If you want to add custom data to VO instances and make the GeoMap control aware of it, e.g. for basing
     * clustering rules on it, you can provide an array of property names specifying the keys to consider.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomProperties(
      /**
       * New value for property `customProperties`
       */
      sCustomProperties: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getMaxSel maxSel}.
     *
     * Selection cardinality: maximum selectable elements ( valid values are "0", "1", and "n" )
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"n"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxSel(
      /**
       * New value for property `maxSel`
       */
      sMaxSel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinSel minSel}.
     *
     * Selection cardinality: minimum selected elements ("0" or "1" )
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinSel(
      /**
       * New value for property `minSel`
       */
      sMinSel?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the VoAggregation constructor.
   */
  export interface $VoAggregationSettings extends $VoAbstractSettings {
    /**
     * Selection cardinality: minimum selected elements ("0" or "1" )
     */
    minSel?: string | PropertyBindingInfo;

    /**
     * Selection cardinality: maximum selectable elements ( valid values are "0", "1", and "n" )
     */
    maxSel?: string | PropertyBindingInfo;

    /**
     * If you want to add custom data to VO instances and make the GeoMap control aware of it, e.g. for basing
     * clustering rules on it, you can provide an array of property names specifying the keys to consider.
     */
    customProperties?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * This event is raised when a Design handle is moved.
     */
    handleMoved?: (oEvent: VoAggregation$HandleMovedEvent) => void;

    /**
     * This event is raised when a Design handle is right clicked.
     */
    handleContextMenu?: (oEvent: VoAggregation$HandleContextMenuEvent) => void;

    /**
     * This event is raised when a Design handle is clicked.
     */
    handleClick?: (oEvent: VoAggregation$HandleClickEvent) => void;

    /**
     * This event is raised when aggregated elements get selected
     */
    select?: (oEvent: VoAggregation$SelectEvent) => void;

    /**
     * This event is raised when aggregated elements get deselected
     */
    deselect?: (oEvent: VoAggregation$DeselectEvent) => void;

    /**
     * The event is raised when there is a click action on a VO.
     */
    click?: (oEvent: VoAggregation$ClickEvent) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a VO.
     */
    contextMenu?: (oEvent: VoAggregation$ContextMenuEvent) => void;

    /**
     * The event is raised when something is dropped on a VO.
     */
    drop?: (oEvent: VoAggregation$DropEvent) => void;
  }

  /**
   * Parameters of the VoAggregation#click event.
   */
  export interface VoAggregation$ClickEventParameters {
    /**
     * Clicked instance
     */
    instance?: VoBase;
  }

  /**
   * Event object of the VoAggregation#click event.
   */
  export type VoAggregation$ClickEvent = Event<
    VoAggregation$ClickEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#contextMenu event.
   */
  export interface VoAggregation$ContextMenuEventParameters {
    /**
     * Clicked instance
     */
    instance?: VoBase;

    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the VoAggregation#contextMenu event.
   */
  export type VoAggregation$ContextMenuEvent = Event<
    VoAggregation$ContextMenuEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#deselect event.
   */
  export interface VoAggregation$DeselectEventParameters {
    /**
     * Array of deselected VOs
     */
    deselected?: any[];
  }

  /**
   * Event object of the VoAggregation#deselect event.
   */
  export type VoAggregation$DeselectEvent = Event<
    VoAggregation$DeselectEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#drop event.
   */
  export interface VoAggregation$DropEventParameters {
    /**
     * Drop target instance
     */
    instance?: Spot;

    /**
     * Dragged instance
     */
    dragSource?: VoBase;
  }

  /**
   * Event object of the VoAggregation#drop event.
   */
  export type VoAggregation$DropEvent = Event<
    VoAggregation$DropEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#handleClick event.
   */
  export interface VoAggregation$HandleClickEventParameters {
    /**
     * Clicked instance
     */
    instance?: VoBase;

    /**
     * The number of the handle where the click occured. Handles are numbered zero based.
     */
    handle?: int;
  }

  /**
   * Event object of the VoAggregation#handleClick event.
   */
  export type VoAggregation$HandleClickEvent = Event<
    VoAggregation$HandleClickEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#handleContextMenu event.
   */
  export interface VoAggregation$HandleContextMenuEventParameters {
    /**
     * Clicked instance
     */
    instance?: VoBase;

    /**
     * Menu to open
     */
    menu?: Menu;

    /**
     * The number of the handle where the click occured. Handles are numbered zero based.
     */
    handle?: int;
  }

  /**
   * Event object of the VoAggregation#handleContextMenu event.
   */
  export type VoAggregation$HandleContextMenuEvent = Event<
    VoAggregation$HandleContextMenuEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#handleMoved event.
   */
  export interface VoAggregation$HandleMovedEventParameters {
    /**
     * Clicked instance
     */
    instance?: VoBase;

    /**
     * The number of the handle where the click occured. Handles are numbered zero based.
     */
    handle?: int;
  }

  /**
   * Event object of the VoAggregation#handleMoved event.
   */
  export type VoAggregation$HandleMovedEvent = Event<
    VoAggregation$HandleMovedEventParameters,
    VoAggregation
  >;

  /**
   * Parameters of the VoAggregation#select event.
   */
  export interface VoAggregation$SelectEventParameters {
    /**
     * Array of selected VOs
     */
    selected?: any[];
  }

  /**
   * Event object of the VoAggregation#select event.
   */
  export type VoAggregation$SelectEvent = Event<
    VoAggregation$SelectEventParameters,
    VoAggregation
  >;
}

declare module "sap/ui/vbm/VoBase" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import { SemanticType } from "sap/ui/vbm/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Menu from "sap/ui/unified/Menu";

  /**
   * Abstract aggregation element for VO aggregations. This element implements the common part for all specific
   * VO elements. It must not be used directly, but is the base for further extension.
   *  As a common feature it provides the Label, which may be attached to any visual object. There are two
   * modes for using labels:
   * 	 - A controlled mode by providing a label type. In this mode most parameters for the label are automatically
   *     set by programmed defaults according to the Fiori guidelines.
   * 	 - A freestyle mode, providing the full control on colors and layout.  Further all visual objects
   *     have common edit capabilities and it is possible to drop content on visual objects.
   */
  export default class VoBase extends UI5Element {
    /**
     * Constructor for a new VoBase.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VoBaseSettings
    );
    /**
     * Constructor for a new VoBase.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VoBaseSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vbm.VoBase with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VoBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vbm.VoBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * The event is raised when there is a click action on a visual object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * The event is raised when there is a click action on a visual object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a visual object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on a visual object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * The event is raised when something is dropped on the object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$DropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:drop drop} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * The event is raised when something is dropped on the object.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDrop(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$DropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleClick handleClick} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * This event is raised when the design handle is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$HandleClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleClick handleClick} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * This event is raised when the design handle is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$HandleClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleContextMenu handleContextMenu} event of
     * this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * This event is raised when the design handle is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$HandleContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleContextMenu handleContextMenu} event of
     * this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * This event is raised when the design handle is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$HandleContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleMoved handleMoved} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * This event is raised when the design handle is moved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleMoved(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$HandleMovedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleMoved handleMoved} event of this `sap.ui.vbm.VoBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vbm.VoBase` itself.
     *
     * This event is raised when the design handle is moved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleMoved(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: VoBase$HandleMovedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vbm.VoBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vbm.VoBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vbm.VoBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoBase$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:drop drop} event of this `sap.ui.vbm.VoBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDrop(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoBase$DropEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleClick handleClick} event of this `sap.ui.vbm.VoBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoBase$HandleClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleContextMenu handleContextMenu} event
     * of this `sap.ui.vbm.VoBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoBase$HandleContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleMoved handleMoved} event of this `sap.ui.vbm.VoBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleMoved(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: VoBase$HandleMovedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoBase$ContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:drop drop} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDrop(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoBase$DropEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleClick handleClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoBase$HandleClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleContextMenu handleContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoBase$HandleContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleMoved handleMoved} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleMoved(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: VoBase$HandleMovedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getChangeable changeable}.
     *
     * Set to true if VO is changeable. Which properties are actually changeable can be controlled on the related
     * VO aggregation.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `changeable`
     */
    getChangeable(): boolean;
    /**
     * Gets current value of property {@link #getDragData dragData}.
     *
     * Data to be dragged. This property allows you to provide an arbitrary data string, which is transfered
     * to the target in a drag'n drop operation
     *
     *
     * @returns Value of property `dragData`
     */
    getDragData(): string;
    /**
     * Gets current value of property {@link #getEntity entity}.
     *
     * The visual object builds an entity/group with other VO elements when it is hovered. The property is not
     * supported when the PlugIn is used.
     *
     *
     * @returns Value of property `entity`
     */
    getEntity(): string;
    /**
     * Gets current value of property {@link #getFxdir fxdir}.
     *
     * The visual object is not rotated when the map is rotated. The property is only required when the PlugIn
     * is used and only meaningful for some VOs.
     *
     * Default value is `'true'`.
     *
     *
     * @returns Value of property `fxdir`
     */
    getFxdir(): string;
    /**
     * Gets current value of property {@link #getFxsize fxsize}.
     *
     * The visual object should keep its size when the map is zoomed. Default value is 'true'. Only meaningful
     * for some VOs.
     *
     * Default value is `'true'`.
     *
     *
     * @returns Value of property `fxsize`
     */
    getFxsize(): string;
    /**
     * Gets current value of property {@link #getHotDeltaColor hotDeltaColor}.
     *
     * Color change applied when visual object is hovered. The format is RHLSA(<hue>;<lightness>;<saturation>;<opacity>).
     * The hue shift is given in degree (0 to 360). The other parameters are given as multipliers, where 1 means
     * the component remains unchanged.
     *  Beside the delta color approach it is also possible to specify an absolute color in the usual CSS color
     * formats (except named colors).
     *
     * Default value is `'RHLSA(0;1.3;1.0;1.0)'`.
     *
     *
     * @returns Value of property `hotDeltaColor`
     */
    getHotDeltaColor(): string;
    /**
     * Gets current value of property {@link #getHotScale hotScale}.
     *
     * Scaling factor applied when visual object is hovered. This is only supported on selected VOs, which do
     * not present a defined geo area.
     *
     * Default value is `'1.0;1.0;1.0'`.
     *
     *
     * @returns Value of property `hotScale`
     */
    getHotScale(): string;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique identifier for the object. This is optional. If not provided the default identifier sId is used.
     * However, sId is generated if template binding is used and thus it is not stable. Provide the key if the
     * object really needs to have a unique and stable identifier.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getLabelArrow labelArrow}.
     *
     * The visual objects label arrow. For left/right/top/bottom aligned labels an additional arrow points to
     * the label's object.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `labelArrow`
     */
    getLabelArrow(): boolean;
    /**
     * Gets current value of property {@link #getLabelBgColor labelBgColor}.
     *
     * The visual objects label background color. The default value is white.
     *
     * Default value is `'RGB(255;255;255)'`.
     *
     *
     * @returns Value of property `labelBgColor`
     */
    getLabelBgColor(): string;
    /**
     * Gets current value of property {@link #getLabelBorderColor labelBorderColor}.
     *
     * The visual objects label border color. The default is no border.
     *
     *
     * @returns Value of property `labelBorderColor`
     */
    getLabelBorderColor(): string;
    /**
     * Gets current value of property {@link #getLabelPos labelPos}.
     *
     * The visual objects label position. This property determines the positioning of the label relative to
     * the VO it belongs to. Possible values are:
     * 	 - 0: centered
     * 	 - 1: top
     * 	 - 2: top right
     * 	 - 3: right
     * 	 - 4: bottom right
     * 	 - 5: bottom
     * 	 - 6: bottom left
     * 	 - 7: left
     * 	 - 8: top left  The default alignment is VO specific.
     *  For multiple position based VOs, like Route, or Area the label is dynamically positioned. If the current
     * display of a VO consists of multiple disconnected parts, each part gets an own label.
     *
     *
     * @returns Value of property `labelPos`
     */
    getLabelPos(): string;
    /**
     * Gets current value of property {@link #getLabelText labelText}.
     *
     * The visual objects label text. Providing a label text required, but also sufficient the get a label displayed.
     *
     *
     * @returns Value of property `labelText`
     */
    getLabelText(): string;
    /**
     * Gets current value of property {@link #getLabelType labelType}.
     *
     * Type for semantic labels. A given semantic type will overrule color settings and add an icon.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `labelType`
     */
    getLabelType(): SemanticType;
    /**
     * Gets current value of property {@link #getSelect select}.
     *
     * Set to true if the element is selected
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `select`
     */
    getSelect(): boolean;
    /**
     * Gets current value of property {@link #getSelectColor selectColor}.
     *
     * Color change applied when visual object is selected. This can be explicit or a relative one. See above.
     *
     * Default value is `'RHLSA(0.0;1.0;1.0;1.0)'`.
     *
     *
     * @returns Value of property `selectColor`
     */
    getSelectColor(): string;
    /**
     * Open the context menu. The method relies on the state saved before firing event contextMenu. Further
     * the object oMenu is expected to be the one given as parameter menu of event contextMenu.
     */
    openContextMenu(
      /**
       * The context menu to be opened. The object is expected the have an attribute
       */
      oMenu: object
    ): void;
    /**
     * Open a Detail Window for the visual object at click position. The method relies on the state saved before
     * firing event click.
     */
    openDetailWindow(
      /**
       * Caption of detail window
       */
      sCaption: string,
      /**
       * Position offset in x-direction from the anchor point
       */
      sOffsetX: string,
      /**
       * Position offset in y-direction from the anchor point
       */
      sOffsetY: string
    ): void;
    /**
     * Sets a new value for property {@link #getChangeable changeable}.
     *
     * Set to true if VO is changeable. Which properties are actually changeable can be controlled on the related
     * VO aggregation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChangeable(
      /**
       * New value for property `changeable`
       */
      bChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDragData dragData}.
     *
     * Data to be dragged. This property allows you to provide an arbitrary data string, which is transfered
     * to the target in a drag'n drop operation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDragData(
      /**
       * New value for property `dragData`
       */
      sDragData?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEntity entity}.
     *
     * The visual object builds an entity/group with other VO elements when it is hovered. The property is not
     * supported when the PlugIn is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntity(
      /**
       * New value for property `entity`
       */
      sEntity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFxdir fxdir}.
     *
     * The visual object is not rotated when the map is rotated. The property is only required when the PlugIn
     * is used and only meaningful for some VOs.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'true'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFxdir(
      /**
       * New value for property `fxdir`
       */
      sFxdir?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFxsize fxsize}.
     *
     * The visual object should keep its size when the map is zoomed. Default value is 'true'. Only meaningful
     * for some VOs.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'true'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFxsize(
      /**
       * New value for property `fxsize`
       */
      sFxsize?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHotDeltaColor hotDeltaColor}.
     *
     * Color change applied when visual object is hovered. The format is RHLSA(<hue>;<lightness>;<saturation>;<opacity>).
     * The hue shift is given in degree (0 to 360). The other parameters are given as multipliers, where 1 means
     * the component remains unchanged.
     *  Beside the delta color approach it is also possible to specify an absolute color in the usual CSS color
     * formats (except named colors).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RHLSA(0;1.3;1.0;1.0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHotDeltaColor(
      /**
       * New value for property `hotDeltaColor`
       */
      sHotDeltaColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHotScale hotScale}.
     *
     * Scaling factor applied when visual object is hovered. This is only supported on selected VOs, which do
     * not present a defined geo area.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'1.0;1.0;1.0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHotScale(
      /**
       * New value for property `hotScale`
       */
      sHotScale?: string
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique identifier for the object. This is optional. If not provided the default identifier sId is used.
     * However, sId is generated if template binding is used and thus it is not stable. Provide the key if the
     * object really needs to have a unique and stable identifier.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelArrow labelArrow}.
     *
     * The visual objects label arrow. For left/right/top/bottom aligned labels an additional arrow points to
     * the label's object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelArrow(
      /**
       * New value for property `labelArrow`
       */
      bLabelArrow?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLabelBgColor labelBgColor}.
     *
     * The visual objects label background color. The default value is white.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RGB(255;255;255)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelBgColor(
      /**
       * New value for property `labelBgColor`
       */
      sLabelBgColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelBorderColor labelBorderColor}.
     *
     * The visual objects label border color. The default is no border.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelBorderColor(
      /**
       * New value for property `labelBorderColor`
       */
      sLabelBorderColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelPos labelPos}.
     *
     * The visual objects label position. This property determines the positioning of the label relative to
     * the VO it belongs to. Possible values are:
     * 	 - 0: centered
     * 	 - 1: top
     * 	 - 2: top right
     * 	 - 3: right
     * 	 - 4: bottom right
     * 	 - 5: bottom
     * 	 - 6: bottom left
     * 	 - 7: left
     * 	 - 8: top left  The default alignment is VO specific.
     *  For multiple position based VOs, like Route, or Area the label is dynamically positioned. If the current
     * display of a VO consists of multiple disconnected parts, each part gets an own label.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelPos(
      /**
       * New value for property `labelPos`
       */
      sLabelPos?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelText labelText}.
     *
     * The visual objects label text. Providing a label text required, but also sufficient the get a label displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelText(
      /**
       * New value for property `labelText`
       */
      sLabelText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelType labelType}.
     *
     * Type for semantic labels. A given semantic type will overrule color settings and add an icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelType(
      /**
       * New value for property `labelType`
       */
      sLabelType?: SemanticType | keyof typeof SemanticType
    ): this;
    /**
     * Sets a new value for property {@link #getSelect select}.
     *
     * Set to true if the element is selected
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelect(
      /**
       * New value for property `select`
       */
      bSelect?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSelectColor selectColor}.
     *
     * Color change applied when visual object is selected. This can be explicit or a relative one. See above.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'RHLSA(0.0;1.0;1.0;1.0)'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectColor(
      /**
       * New value for property `selectColor`
       */
      sSelectColor?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the VoBase constructor.
   */
  export interface $VoBaseSettings extends $ElementSettings {
    /**
     * Unique identifier for the object. This is optional. If not provided the default identifier sId is used.
     * However, sId is generated if template binding is used and thus it is not stable. Provide the key if the
     * object really needs to have a unique and stable identifier.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Scaling factor applied when visual object is hovered. This is only supported on selected VOs, which do
     * not present a defined geo area.
     */
    hotScale?: string | PropertyBindingInfo;

    /**
     * Color change applied when visual object is hovered. The format is RHLSA(<hue>;<lightness>;<saturation>;<opacity>).
     * The hue shift is given in degree (0 to 360). The other parameters are given as multipliers, where 1 means
     * the component remains unchanged.
     *  Beside the delta color approach it is also possible to specify an absolute color in the usual CSS color
     * formats (except named colors).
     */
    hotDeltaColor?: string | PropertyBindingInfo;

    /**
     * Color change applied when visual object is selected. This can be explicit or a relative one. See above.
     */
    selectColor?: string | PropertyBindingInfo;

    /**
     * The visual object should keep its size when the map is zoomed. Default value is 'true'. Only meaningful
     * for some VOs.
     */
    fxsize?: string | PropertyBindingInfo;

    /**
     * The visual object is not rotated when the map is rotated. The property is only required when the PlugIn
     * is used and only meaningful for some VOs.
     */
    fxdir?: string | PropertyBindingInfo;

    /**
     * The visual object builds an entity/group with other VO elements when it is hovered. The property is not
     * supported when the PlugIn is used.
     */
    entity?: string | PropertyBindingInfo;

    /**
     * The visual objects label text. Providing a label text required, but also sufficient the get a label displayed.
     */
    labelText?: string | PropertyBindingInfo;

    /**
     * Type for semantic labels. A given semantic type will overrule color settings and add an icon.
     */
    labelType?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The visual objects label background color. The default value is white.
     */
    labelBgColor?: string | PropertyBindingInfo;

    /**
     * The visual objects label border color. The default is no border.
     */
    labelBorderColor?: string | PropertyBindingInfo;

    /**
     * The visual objects label arrow. For left/right/top/bottom aligned labels an additional arrow points to
     * the label's object.
     */
    labelArrow?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The visual objects label position. This property determines the positioning of the label relative to
     * the VO it belongs to. Possible values are:
     * 	 - 0: centered
     * 	 - 1: top
     * 	 - 2: top right
     * 	 - 3: right
     * 	 - 4: bottom right
     * 	 - 5: bottom
     * 	 - 6: bottom left
     * 	 - 7: left
     * 	 - 8: top left  The default alignment is VO specific.
     *  For multiple position based VOs, like Route, or Area the label is dynamically positioned. If the current
     * display of a VO consists of multiple disconnected parts, each part gets an own label.
     */
    labelPos?: string | PropertyBindingInfo;

    /**
     * Set to true if VO is changeable. Which properties are actually changeable can be controlled on the related
     * VO aggregation.
     */
    changeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Data to be dragged. This property allows you to provide an arbitrary data string, which is transfered
     * to the target in a drag'n drop operation
     */
    dragData?: string | PropertyBindingInfo;

    /**
     * Set to true if the element is selected
     */
    select?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click action on a visual object.
     */
    click?: (oEvent: Event) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on a visual object.
     */
    contextMenu?: (oEvent: VoBase$ContextMenuEvent) => void;

    /**
     * This event is raised when the design handle is moved.
     */
    handleMoved?: (oEvent: VoBase$HandleMovedEvent) => void;

    /**
     * This event is raised when the design handle is right clicked.
     */
    handleContextMenu?: (oEvent: VoBase$HandleContextMenuEvent) => void;

    /**
     * This event is raised when the design handle is clicked.
     */
    handleClick?: (oEvent: VoBase$HandleClickEvent) => void;

    /**
     * The event is raised when something is dropped on the object.
     */
    drop?: (oEvent: VoBase$DropEvent) => void;
  }

  /**
   * Parameters of the VoBase#click event.
   */
  export interface VoBase$ClickEventParameters {}

  /**
   * Event object of the VoBase#click event.
   */
  export type VoBase$ClickEvent = Event<VoBase$ClickEventParameters, VoBase>;

  /**
   * Parameters of the VoBase#contextMenu event.
   */
  export interface VoBase$ContextMenuEventParameters {
    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the VoBase#contextMenu event.
   */
  export type VoBase$ContextMenuEvent = Event<
    VoBase$ContextMenuEventParameters,
    VoBase
  >;

  /**
   * Parameters of the VoBase#drop event.
   */
  export interface VoBase$DropEventParameters {
    /**
     * Dragged instance
     */
    dragSource?: VoBase;
  }

  /**
   * Event object of the VoBase#drop event.
   */
  export type VoBase$DropEvent = Event<VoBase$DropEventParameters, VoBase>;

  /**
   * Parameters of the VoBase#handleClick event.
   */
  export interface VoBase$HandleClickEventParameters {
    /**
     * The number of the handle where the click occured. Handles are numbered zero based.
     */
    handle?: int;
  }

  /**
   * Event object of the VoBase#handleClick event.
   */
  export type VoBase$HandleClickEvent = Event<
    VoBase$HandleClickEventParameters,
    VoBase
  >;

  /**
   * Parameters of the VoBase#handleContextMenu event.
   */
  export interface VoBase$HandleContextMenuEventParameters {
    /**
     * The number of the handle where the click occured. Handles are numbered zero based.
     */
    handle?: int;

    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the VoBase#handleContextMenu event.
   */
  export type VoBase$HandleContextMenuEvent = Event<
    VoBase$HandleContextMenuEventParameters,
    VoBase
  >;

  /**
   * Parameters of the VoBase#handleMoved event.
   */
  export interface VoBase$HandleMovedEventParameters {
    /**
     * The number of the handle where the click occured. Handles are numbered zero based.
     */
    handle?: int;
  }

  /**
   * Event object of the VoBase#handleMoved event.
   */
  export type VoBase$HandleMovedEvent = Event<
    VoBase$HandleMovedEventParameters,
    VoBase
  >;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/ui/vbm/Adapter": undefined;

    "sap/ui/vbm/Adapter3D": undefined;

    "sap/ui/vbm/AnalyticMap": undefined;

    "sap/ui/vbm/Area": undefined;

    "sap/ui/vbm/Areas": undefined;

    "sap/ui/vbm/Box": undefined;

    "sap/ui/vbm/Boxes": undefined;

    "sap/ui/vbm/Circle": undefined;

    "sap/ui/vbm/Circles": undefined;

    "sap/ui/vbm/Cluster": undefined;

    "sap/ui/vbm/ClusterBase": undefined;

    "sap/ui/vbm/ClusterContainer": undefined;

    "sap/ui/vbm/ClusterDistance": undefined;

    "sap/ui/vbm/ClusterGrid": undefined;

    "sap/ui/vbm/ClusterTree": undefined;

    "sap/ui/vbm/Container": undefined;

    "sap/ui/vbm/ContainerBase": undefined;

    "sap/ui/vbm/ContainerContent": undefined;

    "sap/ui/vbm/ContainerLegendItem": undefined;

    "sap/ui/vbm/Containers": undefined;

    "sap/ui/vbm/DragSource": undefined;

    "sap/ui/vbm/DropTarget": undefined;

    "sap/ui/vbm/Feature": undefined;

    "sap/ui/vbm/FeatureCollection": undefined;

    "sap/ui/vbm/GeoCircle": undefined;

    "sap/ui/vbm/GeoCircles": undefined;

    "sap/ui/vbm/GeoJsonLayer": undefined;

    "sap/ui/vbm/GeoMap": undefined;

    "sap/ui/vbm/Heatmap": undefined;

    "sap/ui/vbm/HeatPoint": undefined;

    "sap/ui/vbm/Legend": undefined;

    "sap/ui/vbm/LegendItem": undefined;

    "sap/ui/vbm/library": undefined;

    "sap/ui/vbm/ListPanel": undefined;

    "sap/ui/vbm/ListPanelStack": undefined;

    "sap/ui/vbm/MapContainer": undefined;

    "sap/ui/vbm/MapContainerButtonType": undefined;

    "sap/ui/vbm/Pie": undefined;

    "sap/ui/vbm/PieItem": undefined;

    "sap/ui/vbm/Pies": undefined;

    "sap/ui/vbm/Region": undefined;

    "sap/ui/vbm/Resource": undefined;

    "sap/ui/vbm/Route": undefined;

    "sap/ui/vbm/Routes": undefined;

    "sap/ui/vbm/Spot": undefined;

    "sap/ui/vbm/Spots": undefined;

    "sap/ui/vbm/VBI": undefined;

    "sap/ui/vbm/Viewport": undefined;

    "sap/ui/vbm/VoAbstract": undefined;

    "sap/ui/vbm/VoAggregation": undefined;

    "sap/ui/vbm/VoBase": undefined;
  }
}
