import { BaseUi5TypeInfo, Ui5ModuleTypeInfo, Ui5NamespaceTypeInfo, Ui5TypeInfo, Ui5TypeInfoKind } from "./Ui5TypeInfo.js";
export { Ui5TypeInfoKind, };
export type { Ui5TypeInfo, BaseUi5TypeInfo, Ui5ModuleTypeInfo, Ui5NamespaceTypeInfo, };
interface Node<T> extends BaseUi5TypeInfo {
    name: string;
    value?: T;
    children?: Node<T>[];
}
export default class Ui5TypeInfoMatcher<ValueType> {
    private libraryName?;
    private rootModules;
    private rootNamespaces;
    constructor(libraryName?: string | undefined);
    getLibraryName(): string | undefined;
    match(ui5TypeInfo: Ui5TypeInfo): ValueType | undefined;
    private findChildNode;
    declareModule(moduleName: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): void;
    declareModules(moduleNames: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): void;
    private createModule;
    declareNamespace(namespace: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): void;
    declareNamespaces(namespaces: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): void;
    namespace(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    namespaces(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    class(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    classes(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    constr(children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    constuctorParameter(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    constructorParameters(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    method(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    methods(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    staticMethod(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    staticMethods(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    property(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    properties(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    function(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    functions(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    managedObjectSetting(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    managedObjectSettings(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    metadataEvent(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    metadataEvents(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    metadataProperty(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    metadataProperties(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    metadataAggregation(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    metadataAggregations(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    metadataAssociation(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    metadataAssociations(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    enum(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    enums(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    enumMember(name: string, children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    enumMembers(names: string[], children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>[];
    export(children?: Node<ValueType>[] | ValueType, value?: ValueType): Node<ValueType>;
    private createNode;
}
