import ts from "typescript";
export default class DocumentRegistryProxy implements ts.DocumentRegistry {
    private readonly documentRegistry;
    acquireDocument(_fileName: string, _compilationSettingsOrHost: ts.CompilerOptions | ts.MinimalResolutionCacheHost, _scriptSnapshot: ts.IScriptSnapshot, _version: string, _scriptKind?: ts.ScriptKind, _sourceFileOptions?: ts.CreateSourceFileOptions | ts.ScriptTarget): ts.SourceFile;
    acquireDocumentWithKey(fileName: string, path: ts.Path, compilationSettingsOrHost: ts.CompilerOptions | ts.MinimalResolutionCacheHost, key: ts.DocumentRegistryBucketKey, scriptSnapshot: ts.IScriptSnapshot, version: string, scriptKind?: ts.ScriptKind, sourceFileOptions?: ts.CreateSourceFileOptions | ts.ScriptTarget): ts.SourceFile;
    updateDocument(_fileName: string, _compilationSettingsOrHost: ts.CompilerOptions | ts.MinimalResolutionCacheHost, _scriptSnapshot: ts.IScriptSnapshot, _version: string, _scriptKind?: ts.ScriptKind, _sourceFileOptions?: ts.CreateSourceFileOptions | ts.ScriptTarget): ts.SourceFile;
    updateDocumentWithKey(fileName: string, path: ts.Path, compilationSettingsOrHost: ts.CompilerOptions | ts.MinimalResolutionCacheHost, key: ts.DocumentRegistryBucketKey, scriptSnapshot: ts.IScriptSnapshot, version: string, scriptKind?: ts.ScriptKind, sourceFileOptions?: ts.CreateSourceFileOptions | ts.ScriptTarget): ts.SourceFile;
    getKeyForCompilationSettings(settings: ts.CompilerOptions): ts.DocumentRegistryBucketKey;
    releaseDocument(_fileName: string, _compilationSettings: ts.CompilerOptions, _scriptKind?: ts.ScriptKind): void;
    releaseDocumentWithKey(path: ts.Path, key: ts.DocumentRegistryBucketKey, scriptKind?: ts.ScriptKind): void;
    releaseDocumentWithKey(path: ts.Path, key: ts.DocumentRegistryBucketKey, scriptKind: ts.ScriptKind, impliedNodeFormat: ts.ResolutionMode): void;
    reportStats(): string;
}
