// TODO: Migrate to enum instead of Object/Map
// Currently, it's done this way to avoid pollution of the test snapshots
export const RULES = {
    "async-component-flags": "async-component-flags",
    "csp-unsafe-inline-script": "csp-unsafe-inline-script",
    "no-ambiguous-event-handler": "no-ambiguous-event-handler",
    "no-deprecated-api": "no-deprecated-api",
    "no-deprecated-component": "no-deprecated-component",
    "no-deprecated-control-renderer-declaration": "no-deprecated-control-renderer-declaration",
    "no-deprecated-library": "no-deprecated-library",
    "no-deprecated-theme": "no-deprecated-theme",
    "no-globals": "no-globals",
    "no-implicit-globals": "no-implicit-globals",
    "no-pseudo-modules": "no-pseudo-modules",
    "parsing-error": "parsing-error",
    "autofix-error": "autofix-error",
    "ui5-class-declaration": "ui5-class-declaration",
    "unsupported-api-usage": "unsupported-api-usage",
    "prefer-test-starter": "prefer-test-starter",
    "no-outdated-manifest-version": "no-outdated-manifest-version",
    "no-removed-manifest-property": "no-removed-manifest-property",
    "no-legacy-ui5-version-in-manifest": "no-legacy-ui5-version-in-manifest",
};
export var LintMessageSeverity;
(function (LintMessageSeverity) {
    LintMessageSeverity[LintMessageSeverity["Warning"] = 1] = "Warning";
    LintMessageSeverity[LintMessageSeverity["Error"] = 2] = "Error";
})(LintMessageSeverity || (LintMessageSeverity = {}));
// Messages (sorted alphabetically)
export var MESSAGE;
(function (MESSAGE) {
    MESSAGE[MESSAGE["ABANDONED_BOOTSTRAP_PARAM"] = 0] = "ABANDONED_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["ABANDONED_BOOTSTRAP_PARAM_ERROR"] = 1] = "ABANDONED_BOOTSTRAP_PARAM_ERROR";
    MESSAGE[MESSAGE["COMPONENT_MISSING_ASYNC_INTERFACE"] = 2] = "COMPONENT_MISSING_ASYNC_INTERFACE";
    MESSAGE[MESSAGE["COMPONENT_MISSING_MANIFEST_DECLARATION"] = 3] = "COMPONENT_MISSING_MANIFEST_DECLARATION";
    MESSAGE[MESSAGE["COMPONENT_REDUNDANT_ASYNC_FLAG"] = 4] = "COMPONENT_REDUNDANT_ASYNC_FLAG";
    MESSAGE[MESSAGE["MANIFEST_ASYNC_FALSE_ERROR"] = 5] = "MANIFEST_ASYNC_FALSE_ERROR";
    MESSAGE[MESSAGE["CSP_UNSAFE_INLINE_SCRIPT"] = 6] = "CSP_UNSAFE_INLINE_SCRIPT";
    MESSAGE[MESSAGE["DEPRECATED_API_ACCESS"] = 7] = "DEPRECATED_API_ACCESS";
    MESSAGE[MESSAGE["DEPRECATED_BOOTSTRAP_PARAM"] = 8] = "DEPRECATED_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["DEPRECATED_CLASS"] = 9] = "DEPRECATED_CLASS";
    MESSAGE[MESSAGE["DEPRECATED_INTERFACE"] = 10] = "DEPRECATED_INTERFACE";
    MESSAGE[MESSAGE["DEPRECATED_TYPE"] = 11] = "DEPRECATED_TYPE";
    MESSAGE[MESSAGE["DEPRECATED_COMPONENT"] = 12] = "DEPRECATED_COMPONENT";
    MESSAGE[MESSAGE["DEPRECATED_DECLARATIVE_SUPPORT"] = 13] = "DEPRECATED_DECLARATIVE_SUPPORT";
    MESSAGE[MESSAGE["DEPRECATED_FUNCTION_CALL"] = 14] = "DEPRECATED_FUNCTION_CALL";
    MESSAGE[MESSAGE["DEPRECATED_LESS_SUPPORT"] = 15] = "DEPRECATED_LESS_SUPPORT";
    MESSAGE[MESSAGE["DEPRECATED_LIBRARY"] = 16] = "DEPRECATED_LIBRARY";
    MESSAGE[MESSAGE["DEPRECATED_MANIFEST_JS_RESOURCES"] = 17] = "DEPRECATED_MANIFEST_JS_RESOURCES";
    MESSAGE[MESSAGE["DEPRECATED_MODULE_IMPORT_NAMED"] = 18] = "DEPRECATED_MODULE_IMPORT_NAMED";
    MESSAGE[MESSAGE["DEPRECATED_MODULE_IMPORT"] = 19] = "DEPRECATED_MODULE_IMPORT";
    MESSAGE[MESSAGE["DEPRECATED_ODATA_MODEL_V4_SYNCHRONIZATION_MODE"] = 20] = "DEPRECATED_ODATA_MODEL_V4_SYNCHRONIZATION_MODE";
    MESSAGE[MESSAGE["DEPRECATED_PROPERTY"] = 21] = "DEPRECATED_PROPERTY";
    MESSAGE[MESSAGE["DEPRECATED_PROPERTY_OF_CLASS"] = 22] = "DEPRECATED_PROPERTY_OF_CLASS";
    MESSAGE[MESSAGE["DEPRECATED_THEME"] = 23] = "DEPRECATED_THEME";
    MESSAGE[MESSAGE["DEPRECATED_VIEW_TYPE"] = 24] = "DEPRECATED_VIEW_TYPE";
    MESSAGE[MESSAGE["DUPLICATE_BOOTSTRAP_PARAM"] = 25] = "DUPLICATE_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["HTML_IN_XML"] = 26] = "HTML_IN_XML";
    MESSAGE[MESSAGE["LIB_INIT_API_VERSION"] = 27] = "LIB_INIT_API_VERSION";
    MESSAGE[MESSAGE["MISSING_BOOTSTRAP_PARAM"] = 28] = "MISSING_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["NO_AMBIGUOUS_EVENT_HANDLER"] = 29] = "NO_AMBIGUOUS_EVENT_HANDLER";
    MESSAGE[MESSAGE["NO_CONTROL_RERENDER_OVERRIDE"] = 30] = "NO_CONTROL_RERENDER_OVERRIDE";
    MESSAGE[MESSAGE["NO_DEPRECATED_RENDERER"] = 31] = "NO_DEPRECATED_RENDERER";
    MESSAGE[MESSAGE["NO_DIRECT_DATATYPE_ACCESS"] = 32] = "NO_DIRECT_DATATYPE_ACCESS";
    MESSAGE[MESSAGE["NO_DIRECT_ENUM_ACCESS"] = 33] = "NO_DIRECT_ENUM_ACCESS";
    MESSAGE[MESSAGE["NO_EXPORTED_VALUES_BY_LIB"] = 34] = "NO_EXPORTED_VALUES_BY_LIB";
    MESSAGE[MESSAGE["NO_GLOBALS"] = 35] = "NO_GLOBALS";
    MESSAGE[MESSAGE["NO_ICON_POOL_RENDERER"] = 36] = "NO_ICON_POOL_RENDERER";
    MESSAGE[MESSAGE["NO_LEGACY_TEMPLATE_REQUIRE_SYNTAX"] = 37] = "NO_LEGACY_TEMPLATE_REQUIRE_SYNTAX";
    MESSAGE[MESSAGE["NO_LEGACY_UI5_VERSION_IN_MANIFEST"] = 38] = "NO_LEGACY_UI5_VERSION_IN_MANIFEST";
    MESSAGE[MESSAGE["NO_ODATA_GLOBALS"] = 39] = "NO_ODATA_GLOBALS";
    MESSAGE[MESSAGE["NO_OUTDATED_MANIFEST_VERSION"] = 40] = "NO_OUTDATED_MANIFEST_VERSION";
    MESSAGE[MESSAGE["NO_REMOVED_MANIFEST_PROPERTY"] = 41] = "NO_REMOVED_MANIFEST_PROPERTY";
    MESSAGE[MESSAGE["NOT_STATIC_CONTROL_RENDERER"] = 42] = "NOT_STATIC_CONTROL_RENDERER";
    MESSAGE[MESSAGE["PARSING_ERROR"] = 43] = "PARSING_ERROR";
    MESSAGE[MESSAGE["AUTOFIX_ERROR"] = 44] = "AUTOFIX_ERROR";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_CORE_ROUTER"] = 45] = "PARTIALLY_DEPRECATED_CORE_ROUTER";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_CREATE_COMPONENT"] = 46] = "PARTIALLY_DEPRECATED_CREATE_COMPONENT";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_JSON_MODEL_LOAD_DATA"] = 47] = "PARTIALLY_DEPRECATED_JSON_MODEL_LOAD_DATA";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_MOBILE_INIT"] = 48] = "PARTIALLY_DEPRECATED_MOBILE_INIT";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY"] = 49] = "PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY_PROPERTIES_ARRAY"] = 50] = "PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY_PROPERTIES_ARRAY";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_PARAMETERS_GET"] = 51] = "PARTIALLY_DEPRECATED_PARAMETERS_GET";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_VIEW_CREATE"] = 52] = "PARTIALLY_DEPRECATED_VIEW_CREATE";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_FRAGMENT_LOAD"] = 53] = "PARTIALLY_DEPRECATED_FRAGMENT_LOAD";
    MESSAGE[MESSAGE["PARTIALLY_DEPRECATED_CONTROLLER_LOAD_FRAGMENT"] = 54] = "PARTIALLY_DEPRECATED_CONTROLLER_LOAD_FRAGMENT";
    MESSAGE[MESSAGE["PREFER_TEST_STARTER"] = 55] = "PREFER_TEST_STARTER";
    MESSAGE[MESSAGE["REDUNDANT_BOOTSTRAP_PARAM"] = 56] = "REDUNDANT_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["REDUNDANT_BOOTSTRAP_PARAM_ERROR"] = 57] = "REDUNDANT_BOOTSTRAP_PARAM_ERROR";
    MESSAGE[MESSAGE["REDUNDANT_VIEW_CONFIG_PROPERTY"] = 58] = "REDUNDANT_VIEW_CONFIG_PROPERTY";
    MESSAGE[MESSAGE["REPLACED_BOOTSTRAP_PARAM"] = 59] = "REPLACED_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["SPELLING_BOOTSTRAP_PARAM"] = 60] = "SPELLING_BOOTSTRAP_PARAM";
    MESSAGE[MESSAGE["STRING_FOR_FORMATTER_VALUE_IN_JS"] = 61] = "STRING_FOR_FORMATTER_VALUE_IN_JS";
    MESSAGE[MESSAGE["SVG_IN_XML"] = 62] = "SVG_IN_XML";
    MESSAGE[MESSAGE["MISSING_CONTROL_RENDERER_DECLARATION"] = 63] = "MISSING_CONTROL_RENDERER_DECLARATION";
    MESSAGE[MESSAGE["CONTROL_RENDERER_DECLARATION_STRING"] = 64] = "CONTROL_RENDERER_DECLARATION_STRING";
})(MESSAGE || (MESSAGE = {}));
export const MESSAGE_INFO = {
    [MESSAGE.ABANDONED_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name }) => `Abandoned bootstrap parameter '${name}' should be removed`,
        details: ({ messageDetails }) => messageDetails,
    },
    [MESSAGE.ABANDONED_BOOTSTRAP_PARAM_ERROR]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name }) => `Abandoned bootstrap parameter '${name}' should be removed`,
        details: ({ messageDetails }) => messageDetails,
    },
    [MESSAGE.COMPONENT_MISSING_ASYNC_INTERFACE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["async-component-flags"],
        message: () => `Component is not configured for asynchronous loading.`,
        details: ({ componentFileName, asyncFlagMissingIn }) => `{@link topic:676b636446c94eada183b1218a824717 Use Asynchronous Loading}. ` +
            `Implement sap.ui.core.IAsyncContentCreation interface in ${componentFileName}. ` +
            `Alternatively, set the 'async' flag to 'true' in ${asyncFlagMissingIn} in the component manifest.`,
    },
    [MESSAGE.COMPONENT_MISSING_MANIFEST_DECLARATION]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["async-component-flags"],
        message: () => `Component does not specify that it uses the descriptor via the manifest.json file`,
        details: () => `A manifest.json has been found in the same directory as the component. Although it will be used at ` +
            `runtime automatically, this should still be expressed in the ` +
            `{@link topic:0187ea5e2eff4166b0453b9dcc8fc64f metadata of the component class}.`,
    },
    [MESSAGE.COMPONENT_REDUNDANT_ASYNC_FLAG]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["async-component-flags"],
        message: ({ asyncFlagLocation }) => `Component implements the sap.ui.core.IAsyncContentCreation interface. ` +
            `The redundant 'async' flag at '${asyncFlagLocation}' should be removed from the component manifest`,
        details: () => `{@link sap.ui.core.IAsyncContentCreation sap.ui.core.IAsyncContentCreation}`,
    },
    [MESSAGE.MANIFEST_ASYNC_FALSE_ERROR]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["async-component-flags"],
        message: ({ asyncFlagLocation }) => `The 'async' property at '${asyncFlagLocation}' must be removed`,
        details: ({ hasAsyncInterface }) => `Setting 'async' to 'false' prevents asynchronous loading and is not recommended. Remove the 'async' flag` +
            (hasAsyncInterface ?
                ". " :
                ` and verify that the sap.ui.core.IAsyncContentCreation ` +
                    `interface is implemented for proper asynchronous loading support. `) +
            `{@link topic:676b636446c94eada183b1218a824717 Use Asynchronous Loading}`,
    },
    [MESSAGE.CSP_UNSAFE_INLINE_SCRIPT]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["csp-unsafe-inline-script"],
        message: () => `Use of unsafe inline script`,
        details: () => `{@link topic:fe1a6dba940e479fb7c3bc753f92b28c Content Security Policy}`,
    },
    [MESSAGE.DEPRECATED_API_ACCESS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ apiName }) => `Use of deprecated API '${apiName}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name, value }) => `Use of deprecated value '${value}' for bootstrap parameter '${name}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_CLASS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ className }) => `Use of deprecated class '${className}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_INTERFACE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ interfaceName }) => `Use of deprecated interface '${interfaceName}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_TYPE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ typeName }) => `Use of deprecated type '${typeName}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_COMPONENT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-component"],
        message: ({ componentName }) => `Use of deprecated component '${componentName}'`,
        details: () => undefined,
    },
    [MESSAGE.DEPRECATED_DECLARATIVE_SUPPORT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `DeclarativeSupport is deprecated`,
        details: () => `Please consider using {@link sap.ui.core.mvc.XMLView XMLViews} or` +
            ` {@link topic:e6bb33d076dc4f23be50c082c271b9f0 Typed Views} instead. For more information,` +
            ` see the documentation on {@link topic:91f27e3e6f4d1014b6dd926db0e91070 View types}.`,
    },
    [MESSAGE.DEPRECATED_FUNCTION_CALL]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ functionName, additionalMessage }) => `Call to deprecated function '${functionName}'${additionalMessage ? ` ${additionalMessage}` : ""}`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_LESS_SUPPORT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `LessSupport is deprecated`,
        details: () => "Please consider using UI5 Tooling https://sap.github.io/ui5-tooling/stable/ to compile LESS to CSS on the fly.",
    },
    [MESSAGE.DEPRECATED_LIBRARY]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-library"],
        message: ({ libraryName }) => `Use of deprecated library '${libraryName}'`,
        details: () => undefined,
    },
    [MESSAGE.DEPRECATED_MANIFEST_JS_RESOURCES]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Use of deprecated property 'sap.ui5/resources/js'`,
        details: () => "As of version 1.94, the usage of js resources is deprecated. " +
            "Please use regular dependencies instead.",
    },
    [MESSAGE.DEPRECATED_MODULE_IMPORT_NAMED]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ importName, moduleName }) => `Import of deprecated '${importName}' from module '${moduleName}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_MODULE_IMPORT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ moduleName }) => `Import of deprecated module '${moduleName}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_ODATA_MODEL_V4_SYNCHRONIZATION_MODE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ modelName }) => `Usage of deprecated parameter 'synchronizationMode' ` +
            `of constructor 'sap/ui/model/odata/v4/ODataModel'${modelName ? ` (model: '${modelName}')` : ""}`,
        details: () => `As of version 1.110.0, the 'synchronizationMode' parameter is obsolete and must be omitted. ` +
            `{@link sap/ui/model/odata/v4/ODataModel#constructor See the API reference}`,
    },
    [MESSAGE.DEPRECATED_PROPERTY]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ propertyName, namespace }) => `Use of deprecated property '${propertyName}'${namespace ? ` (${namespace})` : ""}`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_PROPERTY_OF_CLASS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ propertyName, className }) => `Use of deprecated property '${propertyName}' of class '${className}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.DEPRECATED_THEME]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-theme"],
        message: ({ themeName }) => `Use of deprecated theme '${themeName}'`,
        details: () => `{@link topic:a87ca843bcee469f82a9072927a7dcdb Deprecated Themes and Libraries}`,
    },
    [MESSAGE.DEPRECATED_VIEW_TYPE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ viewType }) => `Use of deprecated view type '${viewType}'. Use 'XML' instead'`,
        details: () => undefined,
    },
    [MESSAGE.DUPLICATE_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name, value }) => `Duplicate bootstrap parameter '${name}' with value '${value}'`,
        details: () => undefined,
    },
    [MESSAGE.MISSING_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name }) => `Missing bootstrap parameter '${name}'`,
        details: ({ details }) => details,
    },
    [MESSAGE.HTML_IN_XML]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Usage of native HTML in XML Views/Fragments is deprecated`,
        details: () => `{@link topic:be54950cae1041f59d4aa97a6bade2d8 Using Native HTML in XML Views (deprecated)}`,
    },
    [MESSAGE.LIB_INIT_API_VERSION]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ libInitFunction }) => `Deprecated call to ${libInitFunction}(). Use the {apiVersion: 2} parameter instead`,
        details: () => `{@link sap.ui.core.Lib.init Lib.init}`,
    },
    [MESSAGE.NO_AMBIGUOUS_EVENT_HANDLER]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["no-ambiguous-event-handler"],
        message: ({ eventHandler }) => `Event handler '${eventHandler}' must be prefixed by a dot '.' or refer to a local name`,
        details: () => `If the handler is defined on the controller, use the leading dot notation. ` +
            `Otherwise import the module via core:require and use the handler via the local name. ` +
            `See {@link topic:b0fb4de7364f4bcbb053a99aa645affe Handling Events in XML Views}`,
    },
    [MESSAGE.NO_CONTROL_RERENDER_OVERRIDE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ className }) => `Override of deprecated method 'rerender' in control '${className}'`,
        details: () => `Starting from UI5 1.121 the framework no longer calls 'rerender', ` +
            `so there is no point in overriding it. ` +
            `Move any rendering related code to the renderer or into onBeforeRendering/onAfterRendering.`,
    },
    [MESSAGE.NO_DEPRECATED_RENDERER]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Use of deprecated renderer detected. Define explicitly the {apiVersion: 2} parameter ` +
            `in the renderer object`,
        details: () => `{@link topic:c9ab34570cc14ea5ab72a6d1a4a03e3f Renderer Object}`,
    },
    [MESSAGE.NO_ICON_POOL_RENDERER]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `"sap/ui/core/IconPool" module must be imported when using RenderManager's icon() method`,
        details: () => `{@link sap.ui.core.RenderManager#methods/icon RenderManager}`,
    },
    [MESSAGE.NO_LEGACY_TEMPLATE_REQUIRE_SYNTAX]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ moduleNames }) => `Usage of space-separated list '${moduleNames}' in template:require`,
        details: () => `Use the object notation of template:require instead ` +
            `{@link topic:263f6e5a915f430894ee290040e7e220}`,
    },
    [MESSAGE.NOT_STATIC_CONTROL_RENDERER]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["ui5-class-declaration"],
        message: ({ className }) => `The control renderer${className ? (" of '" + className + "'") : ""} must be a static property`,
        details: () => undefined,
    },
    [MESSAGE.NO_DIRECT_DATATYPE_ACCESS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-pseudo-modules"],
        message: ({ moduleName }) => `Deprecated access of DataType pseudo module '${moduleName}'`,
        details: () => "{@link topic:00737d6c1b864dc3ab72ef56611491c4 Migrating Access to Pseudo Modules}",
    },
    [MESSAGE.NO_DIRECT_ENUM_ACCESS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-pseudo-modules"],
        message: ({ moduleName }) => `Deprecated access of enum pseudo module '${moduleName}'`,
        details: () => "{@link topic:00737d6c1b864dc3ab72ef56611491c4 Migrating Access to Pseudo Modules}",
    },
    [MESSAGE.NO_GLOBALS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-globals"],
        message: ({ variableName, namespace }) => `Access of global variable '${variableName}' (${namespace})`,
        details: () => `Do not use global variables to access UI5 modules or APIs. ` +
            `{@link topic:28fcd55b04654977b63dacbee0552712 See Best Practices for Developers}`,
    },
    [MESSAGE.PARSING_ERROR]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["parsing-error"],
        fatal: true,
        message: ({ message }) => message,
        details: () => `Check the source file for syntax errors`,
    },
    [MESSAGE.AUTOFIX_ERROR]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["autofix-error"],
        message: ({ message }) => message,
        details: () => `An expected autofix could not be applied. This is likely a UI5 linter internal issue. ` +
            `Please report this using the bug report template: https://github.com/UI5/linter/issues/new?template=bug-report.md`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_CORE_ROUTER]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Usage of deprecated value for parameter 'oConfig.async' of constructor 'sap/ui/core/Router'`,
        details: () => `The 'oConfig.async' parameter must be set to true. ` +
            `{@link sap/ui/core/routing/Router#constructor See the API reference}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_CREATE_COMPONENT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Usage of deprecated value for parameter 'async' of 'sap/ui/core/Component#createComponent'`,
        details: () => `The 'async' property must be either omitted or set to true. ` +
            `{@link sap.ui.core.Component#createComponent See the API reference}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_JSON_MODEL_LOAD_DATA]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ paramName }) => `Usage of deprecated value for parameter '${paramName}' of 'sap/ui/model/json/JSONModel#loadData'`,
        details: ({ paramName }) => `Parameter '${paramName}' must be either omitted or set to true. ` +
            `{@link sap.ui.model.json.JSONModel#loadData See API reference}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_MOBILE_INIT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ paramName }) => `Usage of deprecated value for parameter '${paramName}' of 'sap/ui/util/Mobile#init'`,
        details: ({ paramName }) => `Parameter '${paramName}' must be either omitted or set to true. ` +
            `{@link sap.ui.util.Mobile#init See API reference}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Usage of deprecated parameter 'batchGroupId' in 'sap/ui/model/odata/v2/ODataModel#createEntry'`,
        details: () => `Use the 'groupId' parameter instead. ` +
            `{@link sap.ui.model.odata.v2.ODataModel#createEntry See the API reference}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY_PROPERTIES_ARRAY]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Usage of deprecated value for parameter 'properties' in 'sap/ui/model/odata/v2/ODataModel#createEntry'`,
        details: () => `Passing a list of property names is deprecated. Pass the initial values as an object instead. ` +
            `{@link sap.ui.model.odata.v2.ODataModel#createEntry See the API reference}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_PARAMETERS_GET]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Usage of deprecated variant of 'sap/ui/core/theming/Parameters.get'`,
        details: () => `{@link sap.ui.core.theming.Parameters#sap.ui.core.theming.Parameters.get Parameters.get}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_VIEW_CREATE]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ typeValue }) => `Usage of deprecated value '${typeValue}' for parameter 'type' in 'sap/ui/core/mvc/View.create'`,
        details: () => `{@link sap.ui.core.mvc.View#sap.ui.core.mvc.View.create View.create}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_FRAGMENT_LOAD]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ typeValue }) => `Usage of deprecated value '${typeValue}' for parameter 'type' in ` +
            `'sap/ui/core/Fragment.load'`,
        details: () => `{@link sap.ui.core.Fragment#sap.ui.core.Fragment.load Fragment.load}`,
    },
    [MESSAGE.PARTIALLY_DEPRECATED_CONTROLLER_LOAD_FRAGMENT]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ typeValue }) => `Usage of deprecated value '${typeValue}' for parameter 'type' in ` +
            `'sap/ui/core/mvc/Controller#loadFragment'`,
        details: () => `{@link sap.ui.core.mvc.Controller#loadFragment Controller#loadFragment}`,
    },
    [MESSAGE.REDUNDANT_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name }) => `Redundant bootstrap parameter '${name}' should be removed`,
        details: ({ messageDetails }) => messageDetails,
    },
    [MESSAGE.REDUNDANT_BOOTSTRAP_PARAM_ERROR]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name }) => `Redundant bootstrap parameter '${name}' should be removed`,
        details: ({ messageDetails }) => messageDetails,
    },
    [MESSAGE.REDUNDANT_VIEW_CONFIG_PROPERTY]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["no-deprecated-api"],
        message: ({ propertyName }) => `Redundant view configuration property '${propertyName}' can be omitted`,
        details: () => undefined,
    },
    [MESSAGE.SPELLING_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["no-deprecated-api"],
        message: ({ oldName, newName }) => `Outdated spelling of bootstrap parameter: '${oldName}'; should be written as '${newName}'`,
        details: () => undefined,
    },
    [MESSAGE.STRING_FOR_FORMATTER_VALUE_IN_JS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["unsupported-api-usage"],
        message: () => `Do not use strings for 'formatter' values in JavaScript and TypeScript.`,
        details: () => `{@link topic:28fcd55b04654977b63dacbee0552712 See Best Practices for Developers}`,
    },
    [MESSAGE.SVG_IN_XML]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: () => `Deprecated use of SVG in XML View or Fragment`,
        details: () => `{@link topic:28fcd55b04654977b63dacbee0552712 See Best Practices for Developers}`,
    },
    [MESSAGE.MISSING_CONTROL_RENDERER_DECLARATION]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-control-renderer-declaration"],
        message: ({ className }) => `Control '${className}' is missing a renderer declaration`,
        details: ({ className }) => `Not defining a 'renderer' for control '${className}' ` +
            `may lead to synchronous loading of the '${className}Renderer' module. ` +
            `If no renderer exists, set 'renderer: null'. Otherwise, either import the renderer module ` +
            `and assign it to the 'renderer' property or implement the renderer inline.`,
    },
    [MESSAGE.CONTROL_RENDERER_DECLARATION_STRING]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-control-renderer-declaration"],
        message: ({ className, rendererName }) => `Deprecated declaration of renderer ${rendererName ? `'${rendererName}' ` : ""}for control '${className}'`,
        details: ({ className, rendererName }) => {
            const rendererModuleName = rendererName ? `'${rendererName.replace(/\./g, "/")}'` : "renderer";
            return `Defining the 'renderer' for control '${className}' by its name may lead to synchronous ` +
                `loading of the ${rendererModuleName} module. ` +
                `Import the ${rendererModuleName} module and assign it to the 'renderer' property.`;
        },
    },
    [MESSAGE.PREFER_TEST_STARTER]: {
        severity: LintMessageSeverity.Warning,
        ruleId: RULES["prefer-test-starter"],
        message: () => "To save boilerplate code and ensure compliance with UI5 2.x best practices," +
            " please migrate to the Test Starter concept",
        details: () => "{@link topic:032be2cb2e1d4115af20862673bedcdb Test Starter}",
    },
    [MESSAGE.REPLACED_BOOTSTRAP_PARAM]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-deprecated-api"],
        message: ({ name, replacement }) => `Bootstrap parameter '${name}' should be replaced with '${replacement}'`,
        details: ({ messageDetails }) => messageDetails,
    },
    [MESSAGE.NO_EXPORTED_VALUES_BY_LIB]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-implicit-globals"],
        message: ({ module, namespace, libraryName }) => `Access of module '${module}' (${namespace}) not exported by library '${libraryName}'`,
        details: () => `Please import the module itself directly instead of accessing it via the library module.`,
    },
    [MESSAGE.NO_ODATA_GLOBALS]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-implicit-globals"],
        message: () => "OData built-in global symbols must not be used implicitly",
        details: () => "Import the 'sap/ui/model/odata/ODataExpressionAddons' module instead. " +
            "See {@link topic:28fcd55b04654977b63dacbee0552712 Best Practices for Developers}",
    },
    [MESSAGE.NO_OUTDATED_MANIFEST_VERSION]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-outdated-manifest-version"],
        message: () => "manifest.json must be migrated to Version 2",
        details: () => "Set _version to 2.0.0 or higher and follow the migration guide " +
            "{@link topic:be0cf40f61184b358b5faedaec98b2da#loiobe0cf40f61184b358b5faedaec98b2da/section_manifest2 " +
            "Manifest Version 2}",
    },
    [MESSAGE.NO_LEGACY_UI5_VERSION_IN_MANIFEST]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-legacy-ui5-version-in-manifest"],
        message: () => "Use UI5 version 1.136.0 or higher in manifest.json",
        details: () => "Set minUI5Version to 1.136.0 or higher and follow the migration guide " +
            "{@link topic:be0cf40f61184b358b5faedaec98b2da#loiobe0cf40f61184b358b5faedaec98b2da/section_manifest2 " +
            "Manifest Version 2}",
    },
    [MESSAGE.NO_REMOVED_MANIFEST_PROPERTY]: {
        severity: LintMessageSeverity.Error,
        ruleId: RULES["no-removed-manifest-property"],
        message: ({ propName }) => `Property '${propName}' has been removed in Manifest ` +
            `Version 2 and must no longer be provided`,
        details: ({ propName }) => `Remove property '${propName}' and follow the migration guide ` +
            `{@link topic:be0cf40f61184b358b5faedaec98b2da#loiobe0cf40f61184b358b5faedaec98b2da/section_manifest2 ` +
            `Manifest Version 2}`,
    },
};
//# sourceMappingURL=messages.js.map