import { Attribute } from "sax-wasm";
import { ChangeSet } from "../../../utils/textChanges.js";
import { HtmlFix } from "./HtmlFix.js";
import { ToPositionCallback } from "../../ui5Types/fix/XmlEnabledFix.js";
/**
 * Special fix to change the animation mode attribute in HTML tags.
 * @param attribute The animation mode attribute to be fixed.
 */
export default class AnimationModeFix extends HtmlFix {
    private nameStartPositionDetail;
    private nameEndPositionDetail;
    private valueStartPositionDetail;
    private valueEndPositionDetail;
    private oldValue;
    private nameStartPos;
    private nameEndPos;
    private valueStartPos;
    private valueEndPos;
    constructor(attribute: Attribute);
    calculateSourceCodeRange(toPosition: ToPositionCallback): void;
    generateChanges(): ChangeSet[];
    private static getAnimationModeValue;
}
