import ts from "typescript";
import type { ApiExtract } from "../../utils/ApiExtract.js";
export declare enum Ui5TypeInfoKind {
    Module = "Module",
    Namespace = "Namespace",
    Class = "Class",
    Constructor = "Constructor",
    ConstructorParameter = "ConstructorParameter",
    ManagedObjectSettings = "ManagedObjectSettings",
    MetadataProperty = "MetadataProperty",
    MetadataEvent = "MetadataEvent",
    MetadataAggregation = "MetadataAggregation",
    MetadataAssociation = "MetadataAssociation",
    Function = "Function",
    Method = "Method",
    Property = "Property",
    StaticMethod = "StaticMethod",
    StaticProperty = "StaticProperty",
    Enum = "Enum",
    EnumMember = "EnumMember",
    Export = "Export"
}
export type Ui5TypeInfo = Ui5ModuleTypeInfo | Ui5NamespaceTypeInfo | Ui5ClassTypeInfo | Ui5ConstructorTypeInfo | Ui5ConstructorParameterTypeInfo | Ui5MetadataTypeInfo | Ui5FunctionTypeInfo | Ui5MethodTypeInfo | Ui5PropertyTypeInfo | Ui5EnumTypeInfo | Ui5EnumMemberTypeInfo | Ui5ManagedObjectSettingsTypeInfo | Ui5ExportTypeInfo;
export interface BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind;
}
export interface Ui5ModuleTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Module;
    name: string;
    library: string;
}
export interface Ui5NamespaceTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Namespace;
    name: string;
    parent?: Ui5NamespaceTypeInfo | Ui5ModuleTypeInfo;
}
interface Ui5ClassTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Class;
    name: string;
    parent: Ui5NamespaceTypeInfo | Ui5ModuleTypeInfo;
}
interface Ui5ManagedObjectSettingsTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.ManagedObjectSettings;
    name: string;
    parent: Ui5NamespaceTypeInfo | Ui5ModuleTypeInfo;
}
interface Ui5MetadataTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.MetadataProperty | Ui5TypeInfoKind.MetadataEvent | Ui5TypeInfoKind.MetadataAggregation | Ui5TypeInfoKind.MetadataAssociation;
    name: string;
    parent: Ui5ManagedObjectSettingsTypeInfo;
}
interface Ui5FunctionTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Function;
    name: string;
    parent: Ui5NamespaceTypeInfo | Ui5ModuleTypeInfo;
}
interface Ui5MethodTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Method | Ui5TypeInfoKind.StaticMethod;
    name: string;
    parent: Ui5ClassTypeInfo;
}
interface Ui5PropertyTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Property | Ui5TypeInfoKind.StaticProperty;
    name: string;
    parent: Ui5ClassTypeInfo | Ui5ConstructorTypeInfo | Ui5ConstructorParameterTypeInfo;
}
interface Ui5EnumTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Enum;
    name: string;
    parent: Ui5NamespaceTypeInfo | Ui5ModuleTypeInfo;
}
interface Ui5EnumMemberTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.EnumMember;
    name: string;
    parent: Ui5EnumTypeInfo;
}
interface Ui5ConstructorTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Constructor;
    name: string;
    parent: Ui5ClassTypeInfo;
}
interface Ui5ConstructorParameterTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.ConstructorParameter;
    name: string;
    parent: Ui5ConstructorTypeInfo;
}
interface Ui5ExportTypeInfo extends BaseUi5TypeInfo {
    kind: Ui5TypeInfoKind.Export;
    name: string;
    parent: Ui5NamespaceTypeInfo | Ui5ModuleTypeInfo;
}
/**
 * Extracts module / global type information from UI5 symbols.
 */
export declare function getUi5TypeInfoFromSymbol(symbol: ts.Symbol, apiExtract?: ApiExtract): Ui5TypeInfo | undefined;
export declare function getModuleTypeInfo(node: Ui5TypeInfo): Ui5ModuleTypeInfo | undefined;
export declare function getNamespace(node: Ui5TypeInfo): string | undefined;
export {};
