export declare const RULES: {
    readonly "async-component-flags": "async-component-flags";
    readonly "csp-unsafe-inline-script": "csp-unsafe-inline-script";
    readonly "no-ambiguous-event-handler": "no-ambiguous-event-handler";
    readonly "no-deprecated-api": "no-deprecated-api";
    readonly "no-deprecated-component": "no-deprecated-component";
    readonly "no-deprecated-control-renderer-declaration": "no-deprecated-control-renderer-declaration";
    readonly "no-deprecated-library": "no-deprecated-library";
    readonly "no-deprecated-theme": "no-deprecated-theme";
    readonly "no-globals": "no-globals";
    readonly "no-implicit-globals": "no-implicit-globals";
    readonly "no-pseudo-modules": "no-pseudo-modules";
    readonly "parsing-error": "parsing-error";
    readonly "autofix-error": "autofix-error";
    readonly "ui5-class-declaration": "ui5-class-declaration";
    readonly "unsupported-api-usage": "unsupported-api-usage";
    readonly "prefer-test-starter": "prefer-test-starter";
    readonly "no-outdated-manifest-version": "no-outdated-manifest-version";
    readonly "no-removed-manifest-property": "no-removed-manifest-property";
    readonly "no-legacy-ui5-version-in-manifest": "no-legacy-ui5-version-in-manifest";
};
export declare enum LintMessageSeverity {
    Warning = 1,
    Error = 2
}
export declare enum MESSAGE {
    ABANDONED_BOOTSTRAP_PARAM = 0,
    ABANDONED_BOOTSTRAP_PARAM_ERROR = 1,
    COMPONENT_MISSING_ASYNC_INTERFACE = 2,
    COMPONENT_MISSING_MANIFEST_DECLARATION = 3,
    COMPONENT_REDUNDANT_ASYNC_FLAG = 4,
    MANIFEST_ASYNC_FALSE_ERROR = 5,
    CSP_UNSAFE_INLINE_SCRIPT = 6,
    DEPRECATED_API_ACCESS = 7,
    DEPRECATED_BOOTSTRAP_PARAM = 8,
    DEPRECATED_CLASS = 9,
    DEPRECATED_INTERFACE = 10,
    DEPRECATED_TYPE = 11,
    DEPRECATED_COMPONENT = 12,
    DEPRECATED_DECLARATIVE_SUPPORT = 13,
    DEPRECATED_FUNCTION_CALL = 14,
    DEPRECATED_LESS_SUPPORT = 15,
    DEPRECATED_LIBRARY = 16,
    DEPRECATED_MANIFEST_JS_RESOURCES = 17,
    DEPRECATED_MODULE_IMPORT_NAMED = 18,
    DEPRECATED_MODULE_IMPORT = 19,
    DEPRECATED_ODATA_MODEL_V4_SYNCHRONIZATION_MODE = 20,
    DEPRECATED_PROPERTY = 21,
    DEPRECATED_PROPERTY_OF_CLASS = 22,
    DEPRECATED_THEME = 23,
    DEPRECATED_VIEW_TYPE = 24,
    DUPLICATE_BOOTSTRAP_PARAM = 25,
    HTML_IN_XML = 26,
    LIB_INIT_API_VERSION = 27,
    MISSING_BOOTSTRAP_PARAM = 28,
    NO_AMBIGUOUS_EVENT_HANDLER = 29,
    NO_CONTROL_RERENDER_OVERRIDE = 30,
    NO_DEPRECATED_RENDERER = 31,
    NO_DIRECT_DATATYPE_ACCESS = 32,
    NO_DIRECT_ENUM_ACCESS = 33,
    NO_EXPORTED_VALUES_BY_LIB = 34,
    NO_GLOBALS = 35,
    NO_ICON_POOL_RENDERER = 36,
    NO_LEGACY_TEMPLATE_REQUIRE_SYNTAX = 37,
    NO_LEGACY_UI5_VERSION_IN_MANIFEST = 38,
    NO_ODATA_GLOBALS = 39,
    NO_OUTDATED_MANIFEST_VERSION = 40,
    NO_REMOVED_MANIFEST_PROPERTY = 41,
    NOT_STATIC_CONTROL_RENDERER = 42,
    PARSING_ERROR = 43,
    AUTOFIX_ERROR = 44,
    PARTIALLY_DEPRECATED_CORE_ROUTER = 45,
    PARTIALLY_DEPRECATED_CREATE_COMPONENT = 46,
    PARTIALLY_DEPRECATED_JSON_MODEL_LOAD_DATA = 47,
    PARTIALLY_DEPRECATED_MOBILE_INIT = 48,
    PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY = 49,
    PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY_PROPERTIES_ARRAY = 50,
    PARTIALLY_DEPRECATED_PARAMETERS_GET = 51,
    PARTIALLY_DEPRECATED_VIEW_CREATE = 52,
    PARTIALLY_DEPRECATED_FRAGMENT_LOAD = 53,
    PARTIALLY_DEPRECATED_CONTROLLER_LOAD_FRAGMENT = 54,
    PREFER_TEST_STARTER = 55,
    REDUNDANT_BOOTSTRAP_PARAM = 56,
    REDUNDANT_BOOTSTRAP_PARAM_ERROR = 57,
    REDUNDANT_VIEW_CONFIG_PROPERTY = 58,
    REPLACED_BOOTSTRAP_PARAM = 59,
    SPELLING_BOOTSTRAP_PARAM = 60,
    STRING_FOR_FORMATTER_VALUE_IN_JS = 61,
    SVG_IN_XML = 62,
    MISSING_CONTROL_RENDERER_DECLARATION = 63,
    CONTROL_RENDERER_DECLARATION_STRING = 64
}
export declare const MESSAGE_INFO: {
    readonly 0: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 1: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 2: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "async-component-flags";
        readonly message: () => string;
        readonly details: ({ componentFileName, asyncFlagMissingIn }: {
            componentFileName: string;
            asyncFlagMissingIn: string;
        }) => string;
    };
    readonly 3: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "async-component-flags";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 4: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "async-component-flags";
        readonly message: ({ asyncFlagLocation }: {
            asyncFlagLocation: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 5: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "async-component-flags";
        readonly message: ({ asyncFlagLocation }: {
            asyncFlagLocation: string;
        }) => string;
        readonly details: ({ hasAsyncInterface }: {
            hasAsyncInterface?: boolean;
        }) => string;
    };
    readonly 6: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "csp-unsafe-inline-script";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 7: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ apiName }: {
            apiName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 8: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name, value }: {
            name: string;
            value: string;
        }) => string;
        readonly details: ({ details }: {
            details?: string;
        }) => string | undefined;
    };
    readonly 9: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ className }: {
            className: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 10: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ interfaceName }: {
            interfaceName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 11: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeName }: {
            typeName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 12: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-component";
        readonly message: ({ componentName }: {
            componentName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 13: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 14: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ functionName, additionalMessage }: {
            functionName: string;
            additionalMessage: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 15: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 16: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-library";
        readonly message: ({ libraryName }: {
            libraryName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 17: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 18: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ importName, moduleName }: {
            importName: string;
            moduleName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 19: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ moduleName }: {
            moduleName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 20: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ modelName }: {
            modelName?: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 21: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ propertyName, namespace }: {
            propertyName: string;
            namespace?: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 22: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ propertyName, className }: {
            propertyName: string;
            className: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 23: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-theme";
        readonly message: ({ themeName }: {
            themeName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 24: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ viewType }: {
            viewType: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 25: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name, value }: {
            name: string;
            value: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 28: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ details }: {
            details?: string;
        }) => string | undefined;
    };
    readonly 26: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 27: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ libInitFunction }: {
            libInitFunction: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 29: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-ambiguous-event-handler";
        readonly message: ({ eventHandler }: {
            eventHandler: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 30: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ className }: {
            className: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 31: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 36: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 37: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ moduleNames }: {
            moduleNames: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 42: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "ui5-class-declaration";
        readonly message: ({ className }: {
            className?: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 32: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-pseudo-modules";
        readonly message: ({ moduleName }: {
            moduleName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 33: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-pseudo-modules";
        readonly message: ({ moduleName }: {
            moduleName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 35: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-globals";
        readonly message: ({ variableName, namespace }: {
            variableName: string;
            namespace: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 43: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "parsing-error";
        readonly fatal: true;
        readonly message: ({ message }: {
            message: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 44: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "autofix-error";
        readonly message: ({ message }: {
            message: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 45: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 46: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 47: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ paramName }: {
            paramName: string;
        }) => string;
        readonly details: ({ paramName }: {
            paramName: string;
        }) => string;
    };
    readonly 48: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ paramName }: {
            paramName: string;
        }) => string;
        readonly details: ({ paramName }: {
            paramName: string;
        }) => string;
    };
    readonly 49: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 50: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 51: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 52: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeValue }: {
            typeValue: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 53: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeValue }: {
            typeValue: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 54: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeValue }: {
            typeValue: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 56: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 57: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 58: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ propertyName }: {
            propertyName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 60: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ oldName, newName }: {
            oldName: string;
            newName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 61: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "unsupported-api-usage";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 62: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 63: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-control-renderer-declaration";
        readonly message: ({ className }: {
            className: string;
        }) => string;
        readonly details: ({ className }: {
            className: string;
        }) => string;
    };
    readonly 64: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-control-renderer-declaration";
        readonly message: ({ className, rendererName }: {
            className: string;
            rendererName: string | undefined;
        }) => string;
        readonly details: ({ className, rendererName }: {
            className: string;
            rendererName: string | undefined;
        }) => string;
    };
    readonly 55: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "prefer-test-starter";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 59: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name, replacement }: {
            name: string;
            replacement: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails: string;
        }) => string;
    };
    readonly 34: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-implicit-globals";
        readonly message: ({ module, namespace, libraryName }: {
            module: string;
            namespace: string;
            libraryName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 39: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-implicit-globals";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 40: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-outdated-manifest-version";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 38: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-legacy-ui5-version-in-manifest";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 41: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-removed-manifest-property";
        readonly message: ({ propName }: {
            propName: string;
        }) => string;
        readonly details: ({ propName }: {
            propName: string;
        }) => string;
    };
};
