// For Library Version: 1.136.8

declare module "sap/uiext/inbox/library" {}

declare module "sap/uiext/inbox/composite/InboxAddAttachmentTile" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * InboxAddAttachmentTile
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxAddAttachmentTile extends Control {
    /**
     * Constructor for a new composite/InboxAddAttachmentTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Control#constructor sap.ui.core.Control }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxAddAttachmentTileSettings
    );
    /**
     * Constructor for a new composite/InboxAddAttachmentTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Control#constructor sap.ui.core.Control }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxAddAttachmentTileSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxAddAttachmentTile with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxAddAttachmentTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxAddAttachmentTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the InboxAddAttachmentTile constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxAddAttachmentTileSettings extends $ControlSettings {}
}

declare module "sap/uiext/inbox/composite/InboxAttachmentsTileContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import InboxAttachmentTile from "sap/uiext/inbox/composite/InboxAttachmentTile";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * InboxAttachmentsTileContainer
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxAttachmentsTileContainer extends Control {
    /**
     * Constructor for a new composite/InboxAttachmentsTileContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxAttachmentsTileContainerSettings
    );
    /**
     * Constructor for a new composite/InboxAttachmentsTileContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxAttachmentsTileContainerSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxAttachmentsTileContainer with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxAttachmentsTileContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxAttachmentsTileContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some attachment to the aggregation {@link #getAttachments attachments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAttachment(
      /**
       * The attachment to add; if empty, nothing is inserted
       */
      oAttachment: InboxAttachmentTile
    ): this;
    /**
     * method to add a header parameter while uploading a file. This method takes header name and header value
     * as input.
     */
    addUploadHeader(): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadButtonPress uploadButtonPress} event of
     * this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer` itself.
     *
     * event is fired to add all the header parameters just before uploading a file
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadButtonPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadButtonPress uploadButtonPress} event of
     * this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer` itself.
     *
     * event is fired to add all the header parameters just before uploading a file
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadButtonPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadFailed uploadFailed} event of this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer` itself.
     *
     * event is fired when uploading a file has failed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadFailed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadFailed uploadFailed} event of this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer` itself.
     *
     * event is fired when uploading a file has failed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadFailed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadSuccess uploadSuccess} event of this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer` itself.
     *
     * event is fired when uploading a file is completed successfully
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadSuccess(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadSuccess uploadSuccess} event of this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer` itself.
     *
     * event is fired when uploading a file is completed successfully
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadSuccess(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the attachments in the aggregation {@link #getAttachments attachments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAttachments(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:uploadButtonPress uploadButtonPress} event
     * of this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUploadButtonPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:uploadFailed uploadFailed} event of this `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUploadFailed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:uploadSuccess uploadSuccess} event of this
     * `sap.uiext.inbox.composite.InboxAttachmentsTileContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUploadSuccess(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:uploadButtonPress uploadButtonPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUploadButtonPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:uploadFailed uploadFailed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUploadFailed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:uploadSuccess uploadSuccess} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUploadSuccess(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getAttachments attachments}.
     *
     * aggregation for attachments tile
     */
    getAttachments(): InboxAttachmentTile[];
    /**
     * Gets current value of property {@link #getEnteredDescription enteredDescription}.
     *
     * description string entered by user while uploading a file
     *
     *
     * @returns Value of property `enteredDescription`
     */
    getEnteredDescription(): string;
    /**
     * Gets current value of property {@link #getFileName fileName}.
     *
     * name of the selected file for uploading
     *
     *
     * @returns Value of property `fileName`
     */
    getFileName(): string;
    /**
     * Gets current value of property {@link #getFileType fileType}.
     *
     * type of the selected file for uploading
     *
     *
     * @returns Value of property `fileType`
     */
    getFileType(): string;
    /**
     * Gets current value of property {@link #getIsFileSelected isFileSelected}.
     *
     * boolean property to indicate if user has selected a file to upload
     *
     *
     * @returns Value of property `isFileSelected`
     */
    getIsFileSelected(): boolean;
    /**
     * Gets current value of property {@link #getShowAddTile showAddTile}.
     *
     * boolean value to indicate whether to show Add Attachment tile
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showAddTile`
     */
    getShowAddTile(): boolean;
    /**
     * Gets current value of property {@link #getUploadUrl uploadUrl}.
     *
     * URL to upload the selected file
     *
     *
     * @returns Value of property `uploadUrl`
     */
    getUploadUrl(): string;
    /**
     * Checks for the provided `sap.uiext.inbox.composite.InboxAttachmentTile` in the aggregation {@link #getAttachments attachments}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfAttachment(
      /**
       * The attachment whose index is looked for
       */
      oAttachment: InboxAttachmentTile
    ): int;
    /**
     * Inserts a attachment into the aggregation {@link #getAttachments attachments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertAttachment(
      /**
       * The attachment to insert; if empty, nothing is inserted
       */
      oAttachment: InboxAttachmentTile,
      /**
       * The `0`-based index the attachment should be inserted at; for a negative value of `iIndex`, the attachment
       * is inserted at position 0; for a value greater than the current size of the aggregation, the attachment
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getAttachments attachments}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAttachments(): InboxAttachmentTile[];
    /**
     * Removes a attachment from the aggregation {@link #getAttachments attachments}.
     *
     *
     * @returns The removed attachment or `null`
     */
    removeAttachment(
      /**
       * The attachment to remove or its index or id
       */
      vAttachment: int | string | InboxAttachmentTile
    ): InboxAttachmentTile | null;
    /**
     * method to remove a headerParameter of fileUploader
     */
    removeUploadHeader(): void;
    /**
     * Sets a new value for property {@link #getEnteredDescription enteredDescription}.
     *
     * description string entered by user while uploading a file
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnteredDescription(
      /**
       * New value for property `enteredDescription`
       */
      sEnteredDescription?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileName fileName}.
     *
     * name of the selected file for uploading
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileName(
      /**
       * New value for property `fileName`
       */
      sFileName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileType fileType}.
     *
     * type of the selected file for uploading
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileType(
      /**
       * New value for property `fileType`
       */
      sFileType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIsFileSelected isFileSelected}.
     *
     * boolean property to indicate if user has selected a file to upload
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsFileSelected(
      /**
       * New value for property `isFileSelected`
       */
      bIsFileSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowAddTile showAddTile}.
     *
     * boolean value to indicate whether to show Add Attachment tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowAddTile(
      /**
       * New value for property `showAddTile`
       */
      bShowAddTile?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUploadUrl uploadUrl}.
     *
     * URL to upload the selected file
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUploadUrl(
      /**
       * New value for property `uploadUrl`
       */
      sUploadUrl?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxAttachmentsTileContainer constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxAttachmentsTileContainerSettings
    extends $ControlSettings {
    /**
     * URL to upload the selected file
     */
    uploadUrl?: string | PropertyBindingInfo;

    /**
     * name of the selected file for uploading
     */
    fileName?: string | PropertyBindingInfo;

    /**
     * type of the selected file for uploading
     */
    fileType?: string | PropertyBindingInfo;

    /**
     * boolean property to indicate if user has selected a file to upload
     */
    isFileSelected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * description string entered by user while uploading a file
     */
    enteredDescription?: string | PropertyBindingInfo;

    /**
     * boolean value to indicate whether to show Add Attachment tile
     */
    showAddTile?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * aggregation for attachments tile
     */
    attachments?:
      | InboxAttachmentTile[]
      | InboxAttachmentTile
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * event is fired to add all the header parameters just before uploading a file
     */
    uploadButtonPress?: (oEvent: Event) => void;

    /**
     * event is fired when uploading a file is completed successfully
     */
    uploadSuccess?: (oEvent: Event) => void;

    /**
     * event is fired when uploading a file has failed
     */
    uploadFailed?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InboxAttachmentsTileContainer#uploadButtonPress event.
   */
  export interface InboxAttachmentsTileContainer$UploadButtonPressEventParameters {}

  /**
   * Event object of the InboxAttachmentsTileContainer#uploadButtonPress event.
   */
  export type InboxAttachmentsTileContainer$UploadButtonPressEvent = Event<
    InboxAttachmentsTileContainer$UploadButtonPressEventParameters,
    InboxAttachmentsTileContainer
  >;

  /**
   * Parameters of the InboxAttachmentsTileContainer#uploadFailed event.
   */
  export interface InboxAttachmentsTileContainer$UploadFailedEventParameters {}

  /**
   * Event object of the InboxAttachmentsTileContainer#uploadFailed event.
   */
  export type InboxAttachmentsTileContainer$UploadFailedEvent = Event<
    InboxAttachmentsTileContainer$UploadFailedEventParameters,
    InboxAttachmentsTileContainer
  >;

  /**
   * Parameters of the InboxAttachmentsTileContainer#uploadSuccess event.
   */
  export interface InboxAttachmentsTileContainer$UploadSuccessEventParameters {}

  /**
   * Event object of the InboxAttachmentsTileContainer#uploadSuccess event.
   */
  export type InboxAttachmentsTileContainer$UploadSuccessEvent = Event<
    InboxAttachmentsTileContainer$UploadSuccessEventParameters,
    InboxAttachmentsTileContainer
  >;
}

declare module "sap/uiext/inbox/composite/InboxAttachmentTile" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * InboxAttachmentTile
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxAttachmentTile extends Control {
    /**
     * Constructor for a new composite/InboxAttachmentTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxAttachmentTileSettings
    );
    /**
     * Constructor for a new composite/InboxAttachmentTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxAttachmentTileSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxAttachmentTile with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxAttachmentTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxAttachmentTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deleteAttachment deleteAttachment} event of
     * this `sap.uiext.inbox.composite.InboxAttachmentTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentTile` itself.
     *
     * fire this event to delete the attachment
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeleteAttachment(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentTile`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deleteAttachment deleteAttachment} event of
     * this `sap.uiext.inbox.composite.InboxAttachmentTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxAttachmentTile` itself.
     *
     * fire this event to delete the attachment
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeleteAttachment(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxAttachmentTile`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deleteAttachment deleteAttachment} event of
     * this `sap.uiext.inbox.composite.InboxAttachmentTile`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeleteAttachment(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deleteAttachment deleteAttachment} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeleteAttachment(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getCreatedBy createdBy}.
     *
     * name of the user who has uploaded attachment
     *
     *
     * @returns Value of property `createdBy`
     */
    getCreatedBy(): string;
    /**
     * Gets current value of property {@link #getCreationDate creationDate}.
     *
     * creation date of the attachment
     *
     *
     * @returns Value of property `creationDate`
     */
    getCreationDate(): string;
    /**
     * Gets current value of property {@link #getDownloadUrl downloadUrl}.
     *
     * URL for attachment title link to download the attachment.
     *
     *
     * @returns Value of property `downloadUrl`
     */
    getDownloadUrl(): string;
    /**
     * Gets current value of property {@link #getFileDescription fileDescription}.
     *
     * description of the attachment
     *
     *
     * @returns Value of property `fileDescription`
     */
    getFileDescription(): string;
    /**
     * Gets current value of property {@link #getFileName fileName}.
     *
     * Name of the attachment
     *
     *
     * @returns Value of property `fileName`
     */
    getFileName(): string;
    /**
     * Gets current value of property {@link #getFileSize fileSize}.
     *
     * size of the attachment
     *
     *
     * @returns Value of property `fileSize`
     */
    getFileSize(): string;
    /**
     * Gets current value of property {@link #getFileTypeIcon fileTypeIcon}.
     *
     * Icon URI of the file type
     *
     *
     * @returns Value of property `fileTypeIcon`
     */
    getFileTypeIcon(): URI;
    /**
     * Gets current value of property {@link #getShowDeleteButton showDeleteButton}.
     *
     * boolean value to indicate whether to show delete button
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showDeleteButton`
     */
    getShowDeleteButton(): boolean;
    /**
     * Sets a new value for property {@link #getCreatedBy createdBy}.
     *
     * name of the user who has uploaded attachment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreatedBy(
      /**
       * New value for property `createdBy`
       */
      sCreatedBy?: string
    ): this;
    /**
     * Sets a new value for property {@link #getCreationDate creationDate}.
     *
     * creation date of the attachment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreationDate(
      /**
       * New value for property `creationDate`
       */
      sCreationDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDownloadUrl downloadUrl}.
     *
     * URL for attachment title link to download the attachment.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDownloadUrl(
      /**
       * New value for property `downloadUrl`
       */
      sDownloadUrl?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileDescription fileDescription}.
     *
     * description of the attachment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileDescription(
      /**
       * New value for property `fileDescription`
       */
      sFileDescription?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileName fileName}.
     *
     * Name of the attachment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileName(
      /**
       * New value for property `fileName`
       */
      sFileName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileSize fileSize}.
     *
     * size of the attachment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileSize(
      /**
       * New value for property `fileSize`
       */
      sFileSize?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileTypeIcon fileTypeIcon}.
     *
     * Icon URI of the file type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileTypeIcon(
      /**
       * New value for property `fileTypeIcon`
       */
      sFileTypeIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getShowDeleteButton showDeleteButton}.
     *
     * boolean value to indicate whether to show delete button
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDeleteButton(
      /**
       * New value for property `showDeleteButton`
       */
      bShowDeleteButton?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxAttachmentTile constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxAttachmentTileSettings extends $ControlSettings {
    /**
     * Name of the attachment
     */
    fileName?: string | PropertyBindingInfo;

    /**
     * size of the attachment
     */
    fileSize?: string | PropertyBindingInfo;

    /**
     * description of the attachment
     */
    fileDescription?: string | PropertyBindingInfo;

    /**
     * Icon URI of the file type
     */
    fileTypeIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * creation date of the attachment
     */
    creationDate?: string | PropertyBindingInfo;

    /**
     * URL for attachment title link to download the attachment.
     */
    downloadUrl?: string | PropertyBindingInfo;

    /**
     * name of the user who has uploaded attachment
     */
    createdBy?: string | PropertyBindingInfo;

    /**
     * boolean value to indicate whether to show delete button
     */
    showDeleteButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * fire this event to delete the attachment
     */
    deleteAttachment?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InboxAttachmentTile#deleteAttachment event.
   */
  export interface InboxAttachmentTile$DeleteAttachmentEventParameters {}

  /**
   * Event object of the InboxAttachmentTile#deleteAttachment event.
   */
  export type InboxAttachmentTile$DeleteAttachmentEvent = Event<
    InboxAttachmentTile$DeleteAttachmentEventParameters,
    InboxAttachmentTile
  >;
}

declare module "sap/uiext/inbox/composite/InboxBusyIndicator" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * InboxBusyIndicator
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxBusyIndicator extends Control {
    /**
     * Constructor for a new composite/InboxBusyIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Control#constructor sap.ui.core.Control }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxBusyIndicatorSettings
    );
    /**
     * Constructor for a new composite/InboxBusyIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Control#constructor sap.ui.core.Control }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxBusyIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxBusyIndicator with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxBusyIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxBusyIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the InboxBusyIndicator constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxBusyIndicatorSettings extends $ControlSettings {}
}

declare module "sap/uiext/inbox/composite/InboxComment" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { URI } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * fsgg
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxComment extends Control {
    /**
     * Constructor for a new composite/InboxComment.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxCommentSettings
    );
    /**
     * Constructor for a new composite/InboxComment.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxCommentSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxComment with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxComment>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxComment.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCreatedBy createdBy}.
     *
     * Unique username of the user responsible for adding comment
     *
     *
     * @returns Value of property `createdBy`
     */
    getCreatedBy(): string;
    /**
     * Gets current value of property {@link #getSapOrigin sapOrigin}.
     *
     * Represent system origin in case of multi origin scenario
     *
     *
     * @returns Value of property `sapOrigin`
     */
    getSapOrigin(): string;
    /**
     * Gets current value of property {@link #getSender sender}.
     *
     * Sender of the comment chunk
     *
     *
     * @returns Value of property `sender`
     */
    getSender(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * The FeedChunk text
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getThumbnailSrc thumbnailSrc}.
     *
     * URL to the thumbnail image.
     *
     *
     * @returns Value of property `thumbnailSrc`
     */
    getThumbnailSrc(): URI;
    /**
     * Gets current value of property {@link #getTimestamp timestamp}.
     *
     * Format is ISO 8601 YYYY-MM-DDThh:mm:ss.sZ, Z meaning the time is in UTC time zone
     *
     *
     * @returns Value of property `timestamp`
     */
    getTimestamp(): string;
    /**
     * Sets a new value for property {@link #getCreatedBy createdBy}.
     *
     * Unique username of the user responsible for adding comment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreatedBy(
      /**
       * New value for property `createdBy`
       */
      sCreatedBy?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSapOrigin sapOrigin}.
     *
     * Represent system origin in case of multi origin scenario
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSapOrigin(
      /**
       * New value for property `sapOrigin`
       */
      sSapOrigin?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSender sender}.
     *
     * Sender of the comment chunk
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSender(
      /**
       * New value for property `sender`
       */
      sSender?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * The FeedChunk text
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getThumbnailSrc thumbnailSrc}.
     *
     * URL to the thumbnail image.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setThumbnailSrc(
      /**
       * New value for property `thumbnailSrc`
       */
      sThumbnailSrc?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getTimestamp timestamp}.
     *
     * Format is ISO 8601 YYYY-MM-DDThh:mm:ss.sZ, Z meaning the time is in UTC time zone
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimestamp(
      /**
       * New value for property `timestamp`
       */
      sTimestamp?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxComment constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxCommentSettings extends $ControlSettings {
    /**
     * Sender of the comment chunk
     */
    sender?: string | PropertyBindingInfo;

    /**
     * Format is ISO 8601 YYYY-MM-DDThh:mm:ss.sZ, Z meaning the time is in UTC time zone
     */
    timestamp?: string | PropertyBindingInfo;

    /**
     * URL to the thumbnail image.
     */
    thumbnailSrc?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * The FeedChunk text
     */
    text?: string | PropertyBindingInfo;

    /**
     * Unique username of the user responsible for adding comment
     */
    createdBy?: string | PropertyBindingInfo;

    /**
     * Represent system origin in case of multi origin scenario
     */
    sapOrigin?: string | PropertyBindingInfo;
  }
}

declare module "sap/uiext/inbox/composite/InboxTaskComments" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import InboxComment from "sap/uiext/inbox/composite/InboxComment";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * InboxTaskComments
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxTaskComments extends Control {
    /**
     * Constructor for a new composite/InboxTaskComments.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxTaskCommentsSettings
    );
    /**
     * Constructor for a new composite/InboxTaskComments.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxTaskCommentsSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxTaskComments with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxTaskComments>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxTaskComments.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some comment to the aggregation {@link #getComments comments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addComment(
      /**
       * The comment to add; if empty, nothing is inserted
       */
      oComment: InboxComment
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:commentSubmit commentSubmit} event of this `sap.uiext.inbox.composite.InboxTaskComments`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxTaskComments` itself.
     *
     * Event is raised when submit on the feeder is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCommentSubmit(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxTaskComments`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:commentSubmit commentSubmit} event of this `sap.uiext.inbox.composite.InboxTaskComments`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxTaskComments` itself.
     *
     * Event is raised when submit on the feeder is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCommentSubmit(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxTaskComments`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the comments in the aggregation {@link #getComments comments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyComments(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:commentSubmit commentSubmit} event of this
     * `sap.uiext.inbox.composite.InboxTaskComments`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCommentSubmit(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:commentSubmit commentSubmit} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCommentSubmit(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getComments comments}.
     *
     * URL to the thumbnail image.
     */
    getComments(): InboxComment[];
    /**
     * Gets current value of property {@link #getFeederSender feederSender}.
     *
     * Sender for the comment feeder
     *
     *
     * @returns Value of property `feederSender`
     */
    getFeederSender(): string;
    /**
     * Gets current value of property {@link #getFeederThumbnailSrc feederThumbnailSrc}.
     *
     * URL to the thumbnail image for the comment feeder.
     *
     *
     * @returns Value of property `feederThumbnailSrc`
     */
    getFeederThumbnailSrc(): URI;
    /**
     * Gets current value of property {@link #getShowFeeder showFeeder}.
     *
     * Boolean value for visibilty of comment feeder
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showFeeder`
     */
    getShowFeeder(): boolean;
    /**
     * Gets current value of property {@link #getShowHeader showHeader}.
     *
     * Boolean value for visibility of header
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showHeader`
     */
    getShowHeader(): boolean;
    /**
     * Checks for the provided `sap.uiext.inbox.composite.InboxComment` in the aggregation {@link #getComments comments}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfComment(
      /**
       * The comment whose index is looked for
       */
      oComment: InboxComment
    ): int;
    /**
     * Inserts a comment into the aggregation {@link #getComments comments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertComment(
      /**
       * The comment to insert; if empty, nothing is inserted
       */
      oComment: InboxComment,
      /**
       * The `0`-based index the comment should be inserted at; for a negative value of `iIndex`, the comment
       * is inserted at position 0; for a value greater than the current size of the aggregation, the comment
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getComments comments}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllComments(): InboxComment[];
    /**
     * Removes a comment from the aggregation {@link #getComments comments}.
     *
     *
     * @returns The removed comment or `null`
     */
    removeComment(
      /**
       * The comment to remove or its index or id
       */
      vComment: int | string | InboxComment
    ): InboxComment | null;
    /**
     * Sets a new value for property {@link #getFeederSender feederSender}.
     *
     * Sender for the comment feeder
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFeederSender(
      /**
       * New value for property `feederSender`
       */
      sFeederSender?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFeederThumbnailSrc feederThumbnailSrc}.
     *
     * URL to the thumbnail image for the comment feeder.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFeederThumbnailSrc(
      /**
       * New value for property `feederThumbnailSrc`
       */
      sFeederThumbnailSrc?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getShowFeeder showFeeder}.
     *
     * Boolean value for visibilty of comment feeder
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFeeder(
      /**
       * New value for property `showFeeder`
       */
      bShowFeeder?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowHeader showHeader}.
     *
     * Boolean value for visibility of header
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowHeader(
      /**
       * New value for property `showHeader`
       */
      bShowHeader?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxTaskComments constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxTaskCommentsSettings extends $ControlSettings {
    /**
     * Sender for the comment feeder
     */
    feederSender?: string | PropertyBindingInfo;

    /**
     * URL to the thumbnail image for the comment feeder.
     */
    feederThumbnailSrc?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Boolean value for visibilty of comment feeder
     */
    showFeeder?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Boolean value for visibility of header
     */
    showHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * URL to the thumbnail image.
     */
    comments?:
      | InboxComment[]
      | InboxComment
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Event is raised when submit on the feeder is pressed.
     */
    commentSubmit?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InboxTaskComments#commentSubmit event.
   */
  export interface InboxTaskComments$CommentSubmitEventParameters {}

  /**
   * Event object of the InboxTaskComments#commentSubmit event.
   */
  export type InboxTaskComments$CommentSubmitEvent = Event<
    InboxTaskComments$CommentSubmitEventParameters,
    InboxTaskComments
  >;
}

declare module "sap/uiext/inbox/composite/InboxTaskTitleControl" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * InboxTaskTitleControl
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxTaskTitleControl extends Control {
    /**
     * Constructor for a new composite/InboxTaskTitleControl.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxTaskTitleControlSettings
    );
    /**
     * Constructor for a new composite/InboxTaskTitleControl.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxTaskTitleControlSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxTaskTitleControl with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxTaskTitleControl>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxTaskTitleControl.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the titleLink in the aggregation {@link #getTitleLink titleLink}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitleLink(): this;
    /**
     * Gets current value of property {@link #getCategoryIconURI categoryIconURI}.
     *
     * Category icon
     *
     * Default value is `'hasCategory'`.
     *
     *
     * @returns Value of property `categoryIconURI`
     */
    getCategoryIconURI(): URI;
    /**
     * Gets current value of property {@link #getHasAttachments hasAttachments}.
     *
     * has Attachments
     *
     *
     * @returns Value of property `hasAttachments`
     */
    getHasAttachments(): boolean;
    /**
     * Gets current value of property {@link #getHasComments hasComments}.
     *
     * has Comments
     *
     *
     * @returns Value of property `hasComments`
     */
    getHasComments(): boolean;
    /**
     * Gets current value of property {@link #getTaskTitle taskTitle}.
     *
     * The Task Title of the Task
     *
     *
     * @returns Value of property `taskTitle`
     */
    getTaskTitle(): string;
    /**
     * Gets content of aggregation {@link #getTitleLink titleLink}.
     *
     * Internal aggregation to hold the inner Task Title Link
     */
    getTitleLink(): Control;
    /**
     * Sets a new value for property {@link #getCategoryIconURI categoryIconURI}.
     *
     * Category icon
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'hasCategory'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCategoryIconURI(
      /**
       * New value for property `categoryIconURI`
       */
      sCategoryIconURI?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getHasAttachments hasAttachments}.
     *
     * has Attachments
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHasAttachments(
      /**
       * New value for property `hasAttachments`
       */
      bHasAttachments?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHasComments hasComments}.
     *
     * has Comments
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHasComments(
      /**
       * New value for property `hasComments`
       */
      bHasComments?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTaskTitle taskTitle}.
     *
     * The Task Title of the Task
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTaskTitle(
      /**
       * New value for property `taskTitle`
       */
      sTaskTitle?: string
    ): this;
    /**
     * Sets the aggregated {@link #getTitleLink titleLink}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitleLink(
      /**
       * The titleLink to set
       */
      oTitleLink: Control
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxTaskTitleControl constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxTaskTitleControlSettings extends $ControlSettings {
    /**
     * The Task Title of the Task
     */
    taskTitle?: string | PropertyBindingInfo;

    /**
     * Category icon
     */
    categoryIconURI?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * has Attachments
     */
    hasAttachments?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * has Comments
     */
    hasComments?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Internal aggregation to hold the inner Task Title Link
     */
    titleLink?: Control;
  }
}

declare module "sap/uiext/inbox/composite/InboxUploadAttachmentTile" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * InboxUploadAttachmentTile
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxUploadAttachmentTile extends Control {
    /**
     * Constructor for a new composite/InboxUploadAttachmentTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxUploadAttachmentTileSettings
    );
    /**
     * Constructor for a new composite/InboxUploadAttachmentTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxUploadAttachmentTileSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.composite.InboxUploadAttachmentTile with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxUploadAttachmentTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.composite.InboxUploadAttachmentTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadSelectedFile uploadSelectedFile} event
     * of this `sap.uiext.inbox.composite.InboxUploadAttachmentTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxUploadAttachmentTile` itself.
     *
     * event is fired when upload for selected file is requested
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadSelectedFile(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxUploadAttachmentTile`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadSelectedFile uploadSelectedFile} event
     * of this `sap.uiext.inbox.composite.InboxUploadAttachmentTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.composite.InboxUploadAttachmentTile` itself.
     *
     * event is fired when upload for selected file is requested
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadSelectedFile(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.composite.InboxUploadAttachmentTile`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:uploadSelectedFile uploadSelectedFile} event
     * of this `sap.uiext.inbox.composite.InboxUploadAttachmentTile`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUploadSelectedFile(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:uploadSelectedFile uploadSelectedFile} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUploadSelectedFile(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getFileName fileName}.
     *
     * name of the selected file
     *
     *
     * @returns Value of property `fileName`
     */
    getFileName(): string;
    /**
     * Gets current value of property {@link #getFileTypeIcon fileTypeIcon}.
     *
     * icon URI of the selected file type
     *
     *
     * @returns Value of property `fileTypeIcon`
     */
    getFileTypeIcon(): URI;
    /**
     * Sets a new value for property {@link #getFileName fileName}.
     *
     * name of the selected file
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileName(
      /**
       * New value for property `fileName`
       */
      sFileName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileTypeIcon fileTypeIcon}.
     *
     * icon URI of the selected file type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileTypeIcon(
      /**
       * New value for property `fileTypeIcon`
       */
      sFileTypeIcon?: URI
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxUploadAttachmentTile constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export interface $InboxUploadAttachmentTileSettings extends $ControlSettings {
    /**
     * name of the selected file
     */
    fileName?: string | PropertyBindingInfo;

    /**
     * icon URI of the selected file type
     */
    fileTypeIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * event is fired when upload for selected file is requested
     */
    uploadSelectedFile?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InboxUploadAttachmentTile#uploadSelectedFile event.
   */
  export interface InboxUploadAttachmentTile$UploadSelectedFileEventParameters {}

  /**
   * Event object of the InboxUploadAttachmentTile#uploadSelectedFile event.
   */
  export type InboxUploadAttachmentTile$UploadSelectedFileEvent = Event<
    InboxUploadAttachmentTile$UploadSelectedFileEventParameters,
    InboxUploadAttachmentTile
  >;
}

declare module "sap/uiext/inbox/Inbox" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import Sorter from "sap/ui/model/Sorter";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A comprehensive UI design approach with graphical and functional elements for search tasks, filter tasks,
   * and take actions on the tasks ("Inbox Pattern").
   *
   * @deprecated As of version 1.38.0.
   * @experimental As of version 1.5.2. API is not yet finished and might change completely
   */
  export default class Inbox extends Control {
    /**
     * Constructor for a new Inbox.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxSettings
    );
    /**
     * Constructor for a new Inbox.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.Inbox with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Inbox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.Inbox.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds an additional action to inbox
     */
    addAction(
      /**
       * ID of the new action.
       */
      sActionID: string,
      /**
       * The Label Text for the new action.
       */
      sDisplayText: string,
      /**
       * Tooltip for the added action.
       */
      sToolTip: string,
      /**
       * Function to be called when the action is executed
       */
      fnActionHandler: Function,
      /**
       * Flag indicating if the action is mass enabled.Default value is true.
       */
      bMassEnabled: boolean
    ): Inbox;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:oDataRequestCompleted oDataRequestCompleted }
     * event of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * If handleBindings property is set to true , the control assumes an oData model is set and handles the
     * complete logic within. In this case once the oData request is complete, this event is fired with additional
     * parameters.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachODataRequestCompleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:oDataRequestCompleted oDataRequestCompleted }
     * event of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * If handleBindings property is set to true , the control assumes an oData model is set and handles the
     * complete logic within. In this case once the oData request is complete, this event is fired with additional
     * parameters.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachODataRequestCompleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:refresh refresh} event of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * this event is fires to handle refresh Action, when the handleBindings property is set to false.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRefresh(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:refresh refresh} event of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * this event is fires to handle refresh Action, when the handleBindings property is set to false.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRefresh(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:taskAction taskAction} event of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * this event is fires to handle task Actions - Claim, Release, when the handleBindings property is set
     * to false.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTaskAction(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:taskAction taskAction} event of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * this event is fires to handle task Actions - Claim, Release, when the handleBindings property is set
     * to false.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTaskAction(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:taskSelectionChange taskSelectionChange} event
     * of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * This event is fired when table row selection is changed in the list view of Inbox control
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTaskSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:taskSelectionChange taskSelectionChange} event
     * of this `sap.uiext.inbox.Inbox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.Inbox` itself.
     *
     * This event is fired when table row selection is changed in the list view of Inbox control
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTaskSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.Inbox` itself
       */
      oListener?: object
    ): this;
    /**
     * Registers a callback function to be invoked to search on the Task Table.
     */
    bindSearch(
      /**
       * callback function to be called to execute a search
       */
      searchCallBack: Function
    ): Inbox;
    /**
     * Registers a callback function to be invoked to populate the Task Execution PopUp.
     */
    bindTaskExecutionURL(
      /**
       * callback function for getting the execution URL, will be supplied with the task ID and should return
       * the URL to be displayed with the Task Execution PopUp.
       */
      taskExecURLfnCallBack: Function,
      /**
       * callback function for getting the status of the task, will be supplied with the task ID and should return
       * the Task Status.
       */
      taskExecURLStatusCallBack: Function
    ): Inbox;
    /**
     * Bind the Inbox Task Collection
     */
    bindTasks(
      /**
       * Binding path for the element displaying the tasks within the Inbox. This path is the Task Collection
       * according to the TCM (Task Consumption Model)
       */
      sPath: string,
      /**
       * Predefined filter that is applied to the Task Collection before displaying the tasks in the Inbox. (sap.uiext.inbox.InboxFilters)
       */
      oFilter: object,
      /**
       * {}Predefined sorter that is applied to the Task Collection before displaying the tasks in the Inbox.
       * By default the tasks are sorted on 'CreatedOn' , descending, according to TCM. The sorter is not validated
       * for the path being a valid TCM Entity Property. The sorter passed will be applied to the oData service
       * as is. In case the entity Property in the path is a sortable property on the UI, the sorter indicator
       * for that property will be visible.
       */
      oSorter: Sorter
    ): Inbox;
    /**
     * Binds the Task Table Rows to the given path.
     */
    bindTaskTable(
      /**
       * Binding path for the rows of the Task Table
       */
      sPath: string,
      /**
       * Predefined filter for the Task Table (sap.uiext.inbox.TaskInitialFilters)
       */
      oTaskFilters: object
    ): Inbox;
    /**
     * Registers a callback function to be invoked to populate the TaskType Drill Down. This should return the
     * array of Values to be populated in the Task Type Drill Down.
     */
    bindTaskTypeDynamicFilter(
      /**
       * callback function that populates the TaskType Drill Down
       */
      taskTypeDynamicFilterCallBack: Function
    ): Inbox;
    /**
     * Clears all the filters applied in Drill Down. (Status, Priority, Date/Time and TaskType).
     */
    clearDrillDownFilter(): void;
    /**
     * Row Settings applied using the Settings button shall be cleared.
     */
    clearRowSettings(): void;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:oDataRequestCompleted oDataRequestCompleted }
     * event of this `sap.uiext.inbox.Inbox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachODataRequestCompleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:refresh refresh} event of this `sap.uiext.inbox.Inbox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRefresh(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:taskAction taskAction} event of this `sap.uiext.inbox.Inbox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTaskAction(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:taskSelectionChange taskSelectionChange} event
     * of this `sap.uiext.inbox.Inbox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTaskSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:oDataRequestCompleted oDataRequestCompleted} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireODataRequestCompleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:refresh refresh} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRefresh(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:taskAction taskAction} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTaskAction(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:taskSelectionChange taskSelectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTaskSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getHandleBindings handleBindings}.
     *
     * set this as true for oData Model. If set as false, the user will need to handle task Actions, search
     * and Task Execution URL population. See function call back methods.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `handleBindings`
     */
    getHandleBindings(): boolean;
    /**
     * Gets current value of property {@link #getOpenCompletedTasks openCompletedTasks}.
     *
     * set this to true to enable opening of completed tasks.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `openCompletedTasks`
     */
    getOpenCompletedTasks(): boolean;
    /**
     * Getter for property isSubstitutionEnabled.
     *
     * Boolean property to enable the sap.uiext.inbox.SubstitutionRulesManager control (default is false). If
     * is true, 'Manage Substitution Rules' is visible in settings button, else if it is false the option will
     * not be visible under settings.
     *
     * Default value is false
     */
    getSubstitutionEnabled(): boolean;
    /**
     * Gets current value of property {@link #getTaskExecutionURLThemeValue taskExecutionURLThemeValue}.
     *
     * set the theme URL parameter string to be appended to the task Execution URL. In case of a function callback
     * set for Task Execution PopUp, this string will not be appended.
     *
     *
     * @returns Value of property `taskExecutionURLThemeValue`
     */
    getTaskExecutionURLThemeValue(): string;
    /**
     * returns the binding for the Task Table
     */
    getTaskTableBinding(): object;
    /**
     * Inbox is refreshed if task is completed
     */
    refresh(
      /**
       * Array of Json objects containing TaskInstanceID and SAP__Origin
       */
      aTaskUniqueIdentifiers: object[]
    ): void;
    /**
     * Set configuration on Inbox. See APIs in InboxConfiguration
     */
    setConfiguration(
      /**
       * Configuration object to set the configuration on Inbox. See APIs in InboxConfiguration
       */
      oConfiguration: object
    ): Inbox;
    /**
     * Sets a new value for property {@link #getHandleBindings handleBindings}.
     *
     * set this as true for oData Model. If set as false, the user will need to handle task Actions, search
     * and Task Execution URL population. See function call back methods.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHandleBindings(
      /**
       * New value for property `handleBindings`
       */
      bHandleBindings?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getOpenCompletedTasks openCompletedTasks}.
     *
     * set this to true to enable opening of completed tasks.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpenCompletedTasks(
      /**
       * New value for property `openCompletedTasks`
       */
      bOpenCompletedTasks?: boolean
    ): this;
    /**
     * Setter for property bOpenTaskUIInNewTab. If set to true, Task UI will opene in a new tab. Default value
     * is false.
     */
    setOpenTaskUIInNewTab(): void;
    /**
     * Setter for property isSubstitutionEnabled.
     *
     * Boolean property to enable the sap.uiext.inbox.SubstitutionRulesManager control (default is false). If
     * set to true, 'Manage Substitution Rules' is visible in settings button, else if set to false the option
     * will not be visible under settings.
     *
     * Default value is false
     */
    setSubstitutionEnabled(
      /**
       * isSubstitutionEnabled
       */
      bIsSubstitutionEnabled: boolean,
      /**
       * the path
       */
      path: string
    ): void;
    /**
     * Sets a new value for property {@link #getTaskExecutionURLThemeValue taskExecutionURLThemeValue}.
     *
     * set the theme URL parameter string to be appended to the task Execution URL. In case of a function callback
     * set for Task Execution PopUp, this string will not be appended.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTaskExecutionURLThemeValue(
      /**
       * New value for property `taskExecutionURLThemeValue`
       */
      sTaskExecutionURLThemeValue?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Inbox constructor.
   *
   * @deprecated As of version 1.38.0.
   * @experimental As of version 1.5.2. API is not yet finished and might change completely
   */
  export interface $InboxSettings extends $ControlSettings {
    /**
     * set the theme URL parameter string to be appended to the task Execution URL. In case of a function callback
     * set for Task Execution PopUp, this string will not be appended.
     */
    taskExecutionURLThemeValue?: string | PropertyBindingInfo;

    /**
     * set this as true for oData Model. If set as false, the user will need to handle task Actions, search
     * and Task Execution URL population. See function call back methods.
     */
    handleBindings?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * set this to true to enable opening of completed tasks.
     */
    openCompletedTasks?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If handleBindings property is set to true , the control assumes an oData model is set and handles the
     * complete logic within. In this case once the oData request is complete, this event is fired with additional
     * parameters.
     */
    oDataRequestCompleted?: (oEvent: Event) => void;

    /**
     * this event is fires to handle refresh Action, when the handleBindings property is set to false.
     */
    refresh?: (oEvent: Event) => void;

    /**
     * this event is fires to handle task Actions - Claim, Release, when the handleBindings property is set
     * to false.
     */
    taskAction?: (oEvent: Event) => void;

    /**
     * This event is fired when table row selection is changed in the list view of Inbox control
     */
    taskSelectionChange?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Inbox#oDataRequestCompleted event.
   */
  export interface Inbox$ODataRequestCompletedEventParameters {}

  /**
   * Event object of the Inbox#oDataRequestCompleted event.
   */
  export type Inbox$ODataRequestCompletedEvent = Event<
    Inbox$ODataRequestCompletedEventParameters,
    Inbox
  >;

  /**
   * Parameters of the Inbox#refresh event.
   */
  export interface Inbox$RefreshEventParameters {}

  /**
   * Event object of the Inbox#refresh event.
   */
  export type Inbox$RefreshEvent = Event<Inbox$RefreshEventParameters, Inbox>;

  /**
   * Parameters of the Inbox#taskAction event.
   */
  export interface Inbox$TaskActionEventParameters {}

  /**
   * Event object of the Inbox#taskAction event.
   */
  export type Inbox$TaskActionEvent = Event<
    Inbox$TaskActionEventParameters,
    Inbox
  >;

  /**
   * Parameters of the Inbox#taskSelectionChange event.
   */
  export interface Inbox$TaskSelectionChangeEventParameters {}

  /**
   * Event object of the Inbox#taskSelectionChange event.
   */
  export type Inbox$TaskSelectionChangeEvent = Event<
    Inbox$TaskSelectionChangeEventParameters,
    Inbox
  >;
}

declare module "sap/uiext/inbox/InboxConfiguration" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Configuration for Inbox
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxConfiguration extends BaseObject {
    /**
     * Constructor for InboxConfiguration
     */
    constructor();

    /**
     * Creates a new subclass of class sap.uiext.inbox.InboxConfiguration with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxConfiguration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.InboxConfiguration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Getter for Max Limit for user search in Inbox
     */
    getSearchUersMaxLimit(): number;
    /**
     * Setter for Max Limit for user search in Inbox
     */
    setSearchUersMaxLimit(iMaxLimit: number): void;
  }
}

declare module "sap/uiext/inbox/InboxFilters" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  import InboxPrimaryFilters from "sap/uiext/inbox/InboxPrimaryFilters";

  import InboxSecondaryFilters from "sap/uiext/inbox/InboxSecondaryFilters";

  /**
   * PreDefined Filters for Inbox
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxFilters extends BaseObject {
    /**
     * Constructor for InboxFilters
     */
    constructor();

    /**
     * Creates a new subclass of class sap.uiext.inbox.InboxFilters with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxFilters>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.InboxFilters.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Getter for Primary filters
     */
    getPrimaryFilterr(): InboxPrimaryFilters;
    /**
     * Getter for Secondary filters
     */
    getSecondaryFilter(): InboxSecondaryFilters;
    /**
     * Setter for the Primary filters to be applied
     */
    setPrimaryFilter(oPrimaryFilter: InboxPrimaryFilters): void;
    /**
     * Setter for Secondary filters to be applied
     */
    setSecondaryFilter(oSecondaryFilter: InboxSecondaryFilters): void;
  }
}

declare module "sap/uiext/inbox/InboxLaunchPad" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * InboxLaunchPad Documentation to be updated later
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   * @experimental As of version 1.7.0. API is not yet finished and might change completely
   */
  export default class InboxLaunchPad extends Control {
    /**
     * Constructor for a new InboxLaunchPad.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxLaunchPadSettings
    );
    /**
     * Constructor for a new InboxLaunchPad.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxLaunchPadSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.InboxLaunchPad with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxLaunchPad>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.InboxLaunchPad.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:logout logout} event of this `sap.uiext.inbox.InboxLaunchPad`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.InboxLaunchPad` itself.
     *
     * Fired when the user clicks the "Log-off" button.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLogout(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.InboxLaunchPad` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:logout logout} event of this `sap.uiext.inbox.InboxLaunchPad`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.InboxLaunchPad` itself.
     *
     * Fired when the user clicks the "Log-off" button.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLogout(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.InboxLaunchPad` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tileSelected tileSelected} event of this `sap.uiext.inbox.InboxLaunchPad`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.InboxLaunchPad` itself.
     *
     * Fires an event when a tile is selected in Inbox LaunchPad.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTileSelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.InboxLaunchPad` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tileSelected tileSelected} event of this `sap.uiext.inbox.InboxLaunchPad`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.InboxLaunchPad` itself.
     *
     * Fires an event when a tile is selected in Inbox LaunchPad.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTileSelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.InboxLaunchPad` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:logout logout} event of this `sap.uiext.inbox.InboxLaunchPad`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLogout(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tileSelected tileSelected} event of this `sap.uiext.inbox.InboxLaunchPad`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTileSelected(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:logout logout} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLogout(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:tileSelected tileSelected} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTileSelected(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getLogoSrc logoSrc}.
     *
     * Path (src) to the logo icon to be displayed in the Inbox LaunchPad header.
     *
     *
     * @returns Value of property `logoSrc`
     */
    getLogoSrc(): string;
    /**
     * Gets current value of property {@link #getShowLogoutButton showLogoutButton}.
     *
     * Property to indicate whether the Logoff button in the header should be displayed or not. Default value
     * is true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLogoutButton`
     */
    getShowLogoutButton(): boolean;
    /**
     * Gets current value of property {@link #getShowUserName showUserName}.
     *
     * Property to indicate whether loggod on User's Name in the header should be displayed or not. Default
     * value is true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showUserName`
     */
    getShowUserName(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * The title text appearing in Inbox LaunchPad header bar.
     *
     * Default value is `'Inbox Launch Pad Title'`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getUserName userName}.
     *
     * User name to be shown in the header.
     *
     *
     * @returns Value of property `userName`
     */
    getUserName(): string;
    /**
     * Sets a new value for property {@link #getLogoSrc logoSrc}.
     *
     * Path (src) to the logo icon to be displayed in the Inbox LaunchPad header.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLogoSrc(
      /**
       * New value for property `logoSrc`
       */
      sLogoSrc?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowLogoutButton showLogoutButton}.
     *
     * Property to indicate whether the Logoff button in the header should be displayed or not. Default value
     * is true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLogoutButton(
      /**
       * New value for property `showLogoutButton`
       */
      bShowLogoutButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowUserName showUserName}.
     *
     * Property to indicate whether loggod on User's Name in the header should be displayed or not. Default
     * value is true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowUserName(
      /**
       * New value for property `showUserName`
       */
      bShowUserName?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * The title text appearing in Inbox LaunchPad header bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'Inbox Launch Pad Title'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUserName userName}.
     *
     * User name to be shown in the header.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUserName(
      /**
       * New value for property `userName`
       */
      sUserName?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxLaunchPad constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   * @experimental As of version 1.7.0. API is not yet finished and might change completely
   */
  export interface $InboxLaunchPadSettings extends $ControlSettings {
    /**
     * The title text appearing in Inbox LaunchPad header bar.
     */
    title?: string | PropertyBindingInfo;

    /**
     * Path (src) to the logo icon to be displayed in the Inbox LaunchPad header.
     */
    logoSrc?: string | PropertyBindingInfo;

    /**
     * Property to indicate whether the Logoff button in the header should be displayed or not. Default value
     * is true.
     */
    showLogoutButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Property to indicate whether loggod on User's Name in the header should be displayed or not. Default
     * value is true.
     */
    showUserName?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * User name to be shown in the header.
     */
    userName?: string | PropertyBindingInfo;

    /**
     * Fires an event when a tile is selected in Inbox LaunchPad.
     */
    tileSelected?: (oEvent: Event) => void;

    /**
     * Fired when the user clicks the "Log-off" button.
     */
    logout?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InboxLaunchPad#logout event.
   */
  export interface InboxLaunchPad$LogoutEventParameters {}

  /**
   * Event object of the InboxLaunchPad#logout event.
   */
  export type InboxLaunchPad$LogoutEvent = Event<
    InboxLaunchPad$LogoutEventParameters,
    InboxLaunchPad
  >;

  /**
   * Parameters of the InboxLaunchPad#tileSelected event.
   */
  export interface InboxLaunchPad$TileSelectedEventParameters {}

  /**
   * Event object of the InboxLaunchPad#tileSelected event.
   */
  export type InboxLaunchPad$TileSelectedEvent = Event<
    InboxLaunchPad$TileSelectedEventParameters,
    InboxLaunchPad
  >;
}

declare module "sap/uiext/inbox/InboxPrimaryFilterEnum" {
  /**
   * Enumeration for Primary Filters. This value will be applied for the DropDown Filter in Inbox
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  interface InboxPrimaryFilterEnum {
    /**
     * Primary Filter for Completed Tasks
     */
    COMPLETED: undefined;

    /**
     * Primary Filter for Escalated Tasks
     */
    ESCALATED: undefined;

    /**
     * Primary Filter for Open Tasks
     */
    OPEN: undefined;

    /**
     * Primary Filter for Overdue Tasks
     */
    OVERDUE: undefined;
  }
  const InboxPrimaryFilterEnum: InboxPrimaryFilterEnum;
  /**
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default InboxPrimaryFilterEnum;
}

declare module "sap/uiext/inbox/InboxPrimaryFilters" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  import InboxPrimaryFilterEnum from "sap/uiext/inbox/InboxPrimaryFilterEnum";

  /**
   * Primary Filters for Inbox
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxPrimaryFilters extends BaseObject {
    /**
     * Constructor for InboxPrimaryFilters
     */
    constructor();

    /**
     * Creates a new subclass of class sap.uiext.inbox.InboxPrimaryFilters with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxPrimaryFilters>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.InboxPrimaryFilters.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * set Primary filter
     */
    setFilter(oFilter: InboxPrimaryFilterEnum): void;
  }
}

declare module "sap/uiext/inbox/InboxSecondaryFilterPathEnum" {
  /**
   * Enumeration for Secondary Filter Paths
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  interface InboxSecondaryFilterPathEnum {
    /**
     * Path for DueDate Secondary Filter
     */
    DUEDATE: undefined;

    /**
     * Path for Priority Secondary Filter
     */
    PRIORITY: undefined;

    /**
     * Path for StartDate Secondary Filter
     */
    STARTDATE: undefined;

    /**
     * Path for Status Secondary Filter
     */
    STATUS: undefined;

    /**
     * Path for TaskType Secondary Filter
     */
    TASKTYPE: undefined;
  }
  const InboxSecondaryFilterPathEnum: InboxSecondaryFilterPathEnum;
  /**
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default InboxSecondaryFilterPathEnum;
}

declare module "sap/uiext/inbox/InboxSecondaryFilters" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Secondary Filters for Inbox
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default class InboxSecondaryFilters extends BaseObject {
    /**
     * Constructor for InboxSecondaryFilters
     */
    constructor();

    /**
     * Creates a new subclass of class sap.uiext.inbox.InboxSecondaryFilters with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxSecondaryFilters>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.InboxSecondaryFilters.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Set Secondary Filters
     */
    setStandardFilters(
      /**
       * Array of secondary Filter Objects eg. : {sPath : sap.uiext.inbox.InboxSecondaryFilterPathEnum.Priority,
       * values : [sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Status.LOW, sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Status.HIGH] }
       * sPath : {sap.uiext.inbox.InboxSecondaryFilterPathEnum} values : {Array} Array of SecondaryFilterValuesEnums
       * of {sap.uiext.inbox.InboxSecondaryFilterValuesEnum}
       */
      aFilterObjects: any[]
    ): void;
  }
}

declare module "sap/uiext/inbox/InboxSecondaryFilterValuesEnum" {
  /**
   * Enumeration for Secondary Filter Values
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  interface InboxSecondaryFilterValuesEnum {
    /**
     * Enum Values displayed by DueDate Secondary Filter dropdown are
     *  Today  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.DueDate.TODAY
     *
     *  Next7Days  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.DueDate.NEXT7DAYS
     *
     *  Next15Days  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.DueDate.NEXT15DAYS
     *
     *  Next30Days  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.DueDate.NEXT30DAYS
     *
     *  NoDueDate  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.DueDate.NODUEDATE
     */
    DueDate: undefined;

    /**
     * Enum Values displayed by Priority Secondary Filter dropdown are
     *   Low  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Priority.LOW
     *
     *   Medium : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Priority.MEDIUM
     *
     *   High  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Priority.HIGH
     *
     *   Very High: sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Priority.VERYHIGH
     */
    Priority: undefined;

    /**
     * Enum Values displayed by the StartDate Secondary Filter are
     *   Today  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.StartDate.TODAY
     *
     *   Last7Days  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.StartDate.LAST7DAYS
     *
     *  Last15Days  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.StartDate.LAST15DAYS
     *
     *  Last30Days  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.StartDate.LAST30DAYS
     */
    StartDate: undefined;

    /**
     * Enum Values displayed by the Status Secondary Filter dropdown are
     *  Ready  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Status.READY
     *
     * Reserved  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Status.RESERVED
     *
     * InProgress  : sap.uiext.inbox.InboxSecondaryFilterValuesEnum.Status.INPROGRESS
     */
    Status: undefined;
  }
  const InboxSecondaryFilterValuesEnum: InboxSecondaryFilterValuesEnum;
  /**
   * @deprecated As of version 1.120. the concept has been discarded.
   */
  export default InboxSecondaryFilterValuesEnum;
}

declare module "sap/uiext/inbox/InboxSplitApp" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SplitApp from "sap/m/SplitApp";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Inbox Split App
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   * @experimental As of version 1.7.0. API is not yet finished and might change completely
   */
  export default class InboxSplitApp extends Control {
    /**
     * Constructor for a new InboxSplitApp.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxSplitAppSettings
    );
    /**
     * Constructor for a new InboxSplitApp.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InboxSplitAppSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.InboxSplitApp with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InboxSplitApp>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.InboxSplitApp.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navButtonPressed navButtonPressed} event of
     * this `sap.uiext.inbox.InboxSplitApp`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.InboxSplitApp` itself.
     *
     * Navigation Button of the Master Page is pressed, if visible.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavButtonPressed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.InboxSplitApp` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navButtonPressed navButtonPressed} event of
     * this `sap.uiext.inbox.InboxSplitApp`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.uiext.inbox.InboxSplitApp` itself.
     *
     * Navigation Button of the Master Page is pressed, if visible.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavButtonPressed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.uiext.inbox.InboxSplitApp` itself
       */
      oListener?: object
    ): this;
    /**
     * Call this method to display data in the InboxSplitApp
     */
    bindTasks(aFilters: object[]): InboxSplitApp;
    /**
     * Destroys the splitAppl in the aggregation {@link #getSplitAppl splitAppl}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySplitAppl(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navButtonPressed navButtonPressed} event of
     * this `sap.uiext.inbox.InboxSplitApp`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavButtonPressed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:navButtonPressed navButtonPressed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavButtonPressed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getFilters filters}.
     *
     * Filters to be applied on the data shown in the MasterPage
     *
     *
     * @returns Value of property `filters`
     */
    getFilters(): object[];
    /**
     * Gets current value of property {@link #getShowMasterPageNavBtn showMasterPageNavBtn}.
     *
     * Show/Hide the Navigation Button for the Master Page
     *
     *
     * @returns Value of property `showMasterPageNavBtn`
     */
    getShowMasterPageNavBtn(): boolean;
    /**
     * Gets content of aggregation {@link #getSplitAppl splitAppl}.
     *
     * This is the splitApp that is created inside the control
     */
    getSplitAppl(): SplitApp;
    /**
     * Gets current value of property {@link #getTcmConfiguration tcmConfiguration}.
     *
     * TCM Configuration object for control initialization.
     *
     *
     * @returns Value of property `tcmConfiguration`
     */
    getTcmConfiguration(): object;
    /**
     * Gets current value of property {@link #getTcmServiceURL tcmServiceURL}.
     *
     * TCM service URL
     *
     *
     * @returns Value of property `tcmServiceURL`
     */
    getTcmServiceURL(): string;
    /**
     * Call this method to reset the search criteria.
     */
    resetSearchCriteria(): InboxSplitApp;
    /**
     * Sets a new value for property {@link #getFilters filters}.
     *
     * Filters to be applied on the data shown in the MasterPage
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilters(
      /**
       * New value for property `filters`
       */
      sFilters?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getShowMasterPageNavBtn showMasterPageNavBtn}.
     *
     * Show/Hide the Navigation Button for the Master Page
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowMasterPageNavBtn(
      /**
       * New value for property `showMasterPageNavBtn`
       */
      bShowMasterPageNavBtn?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getSplitAppl splitAppl}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSplitAppl(
      /**
       * The splitAppl to set
       */
      oSplitAppl: SplitApp
    ): this;
    /**
     * Sets a new value for property {@link #getTcmConfiguration tcmConfiguration}.
     *
     * TCM Configuration object for control initialization.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTcmConfiguration(
      /**
       * New value for property `tcmConfiguration`
       */
      oTcmConfiguration?: object
    ): this;
    /**
     * Sets a new value for property {@link #getTcmServiceURL tcmServiceURL}.
     *
     * TCM service URL
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTcmServiceURL(
      /**
       * New value for property `tcmServiceURL`
       */
      sTcmServiceURL?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InboxSplitApp constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   * @experimental As of version 1.7.0. API is not yet finished and might change completely
   */
  export interface $InboxSplitAppSettings extends $ControlSettings {
    /**
     * Show/Hide the Navigation Button for the Master Page
     */
    showMasterPageNavBtn?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * TCM service URL
     */
    tcmServiceURL?: string | PropertyBindingInfo;

    /**
     * Filters to be applied on the data shown in the MasterPage
     */
    filters?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * TCM Configuration object for control initialization.
     */
    tcmConfiguration?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * This is the splitApp that is created inside the control
     */
    splitAppl?: SplitApp;

    /**
     * Navigation Button of the Master Page is pressed, if visible.
     */
    navButtonPressed?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InboxSplitApp#navButtonPressed event.
   */
  export interface InboxSplitApp$NavButtonPressedEventParameters {}

  /**
   * Event object of the InboxSplitApp#navButtonPressed event.
   */
  export type InboxSplitApp$NavButtonPressedEvent = Event<
    InboxSplitApp$NavButtonPressedEventParameters,
    InboxSplitApp
  >;
}

declare module "sap/uiext/inbox/SubstitutionRulesManager" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The SubstitutionRulesManager
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   * @experimental As of version 1.7.0. API is not yet finished and might change completely
   */
  export default class SubstitutionRulesManager extends Control {
    /**
     * Constructor for a new SubstitutionRulesManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Control#constructor sap.ui.core.Control }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SubstitutionRulesManagerSettings
    );
    /**
     * Constructor for a new SubstitutionRulesManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Control#constructor sap.ui.core.Control }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SubstitutionRulesManagerSettings
    );

    /**
     * Creates a new subclass of class sap.uiext.inbox.SubstitutionRulesManager with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SubstitutionRulesManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.uiext.inbox.SubstitutionRulesManager.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Binds the Substitution Rules to the given path.
     */
    bindSubstitutionRules(
      /**
       * The path
       */
      path: string
    ): SubstitutionRulesManager;
  }
  /**
   * Describes the settings that can be provided to the SubstitutionRulesManager constructor.
   *
   * @deprecated As of version 1.120. the concept has been discarded.
   * @experimental As of version 1.7.0. API is not yet finished and might change completely
   */
  export interface $SubstitutionRulesManagerSettings extends $ControlSettings {}
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/uiext/inbox/composite/InboxAddAttachmentTile": undefined;

    "sap/uiext/inbox/composite/InboxAttachmentsTileContainer": undefined;

    "sap/uiext/inbox/composite/InboxAttachmentTile": undefined;

    "sap/uiext/inbox/composite/InboxBusyIndicator": undefined;

    "sap/uiext/inbox/composite/InboxComment": undefined;

    "sap/uiext/inbox/composite/InboxTaskComments": undefined;

    "sap/uiext/inbox/composite/InboxTaskTitleControl": undefined;

    "sap/uiext/inbox/composite/InboxUploadAttachmentTile": undefined;

    "sap/uiext/inbox/Inbox": undefined;

    "sap/uiext/inbox/InboxConfiguration": undefined;

    "sap/uiext/inbox/InboxFilters": undefined;

    "sap/uiext/inbox/InboxLaunchPad": undefined;

    "sap/uiext/inbox/InboxPrimaryFilterEnum": undefined;

    "sap/uiext/inbox/InboxPrimaryFilters": undefined;

    "sap/uiext/inbox/InboxSecondaryFilterPathEnum": undefined;

    "sap/uiext/inbox/InboxSecondaryFilters": undefined;

    "sap/uiext/inbox/InboxSecondaryFilterValuesEnum": undefined;

    "sap/uiext/inbox/InboxSplitApp": undefined;

    "sap/uiext/inbox/library": undefined;

    "sap/uiext/inbox/SubstitutionRulesManager": undefined;
  }
}
