// For Library Version: 1.136.5

declare module "sap/makit/library" {
  /**
   * Enumeration for chart type
   *
   * This enum is part of the 'sap/makit/library' module export and must be accessed by the property 'ChartType'.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export enum ChartType {
    /**
     * Horizontal table bar chart
     */
    Bar = "Bar",
    /**
     * Bubble chart
     */
    Bubble = "Bubble",
    /**
     * Column chart
     */
    Column = "Column",
    /**
     * Donut chart
     */
    Donut = "Donut",
    /**
     * 100% stacked column chart
     */
    HundredPercentStackedColumn = "HundredPercentStackedColumn",
    /**
     * Line chart
     */
    Line = "Line",
    /**
     * Pie chart
     */
    Pie = "Pie",
    /**
     * Stacked column chart
     */
    StackedColumn = "StackedColumn",
    /**
     * Waterfall Bar chart
     */
    WaterfallBar = "WaterfallBar",
    /**
     * Waterfall Column chart
     */
    WaterfallColumn = "WaterfallColumn",
  }
  /**
   * Enumeration for legend position.
   *
   * This enum is part of the 'sap/makit/library' module export and must be accessed by the property 'LegendPosition'.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export enum LegendPosition {
    /**
     * Legend location is on the bottom of the chart
     */
    Bottom = "Bottom",
    /**
     * Legend location is on the left of the chart
     */
    Left = "Left",
    /**
     * Hide the legend
     */
    None = "None",
    /**
     * Legend location is on the right of the chart
     */
    Right = "Right",
    /**
     * Legend location is on the top of the chart
     */
    Top = "Top",
  }
  /**
   * Enumeration for sort order
   *
   * This enum is part of the 'sap/makit/library' module export and must be accessed by the property 'SortOrder'.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export enum SortOrder {
    /**
     * Ascending sort
     */
    Ascending = "Ascending",
    /**
     * Descending sort
     */
    Descending = "Descending",
    /**
     * No sorting
     */
    None = "None",
    /**
     * Partially sort
     */
    Partial = "Partial",
  }
  /**
   * Position for Value Bubble only applies to Pie/Donut Chart.
   *
   * This enum is part of the 'sap/makit/library' module export and must be accessed by the property 'ValueBubblePosition'.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export enum ValueBubblePosition {
    /**
     * Value Bubble position set to beside the chart
     */
    Side = "Side",
    /**
     * Value Bubble position set to above the chart
     */
    Top = "Top",
  }
  /**
   * Enumeration for Value Bubble's positioning style. This applies all chart types except Pie/Donut/HBar
   * chart.
   *
   * This enum is part of the 'sap/makit/library' module export and must be accessed by the property 'ValueBubbleStyle'.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export enum ValueBubbleStyle {
    /**
     * The Value Bubble floats on the touch point, chart's size will not change.
     */
    Float = "Float",
    /**
     * The Value Bubble floats and snaps above of the chart, chart's size will not change.
     */
    FloatTop = "FloatTop",
    /**
     * The Value Bubble snaps above of the chart, the chart height will adjust accordingly.
     */
    Top = "Top",
  }
}

declare module "sap/makit/Axis" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base element for the Axis object for the Chart.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Axis extends UI5Element {
    /**
     * Constructor for a new Axis.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AxisSettings
    );
    /**
     * Constructor for a new Axis.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AxisSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Axis with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Axis>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Axis.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Color of the primary line. Accept the following format: standard name format: gray, red, black, etc hex
     * format: #ff00ff rgb format: rgb(256, 0, 256)
     *
     * Default value is `'gray'`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getShowGrid showGrid}.
     *
     * Indicates whether to show grid of the Axis in the chart area
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showGrid`
     */
    getShowGrid(): boolean;
    /**
     * Gets current value of property {@link #getShowLabel showLabel}.
     *
     * Indicates whether to show label of the Axis by the primary line
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLabel`
     */
    getShowLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowPrimaryLine showPrimaryLine}.
     *
     * Indicates whether to show the primary line of the Axis on the chart area
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showPrimaryLine`
     */
    getShowPrimaryLine(): boolean;
    /**
     * Gets current value of property {@link #getThickness thickness}.
     *
     * The line thickness of the primary line
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `thickness`
     */
    getThickness(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Color of the primary line. Accept the following format: standard name format: gray, red, black, etc hex
     * format: #ff00ff rgb format: rgb(256, 0, 256)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'gray'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowGrid showGrid}.
     *
     * Indicates whether to show grid of the Axis in the chart area
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowGrid(
      /**
       * New value for property `showGrid`
       */
      bShowGrid?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowLabel showLabel}.
     *
     * Indicates whether to show label of the Axis by the primary line
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLabel(
      /**
       * New value for property `showLabel`
       */
      bShowLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPrimaryLine showPrimaryLine}.
     *
     * Indicates whether to show the primary line of the Axis on the chart area
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPrimaryLine(
      /**
       * New value for property `showPrimaryLine`
       */
      bShowPrimaryLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getThickness thickness}.
     *
     * The line thickness of the primary line
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setThickness(
      /**
       * New value for property `thickness`
       */
      fThickness?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Axis constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $AxisSettings extends $ElementSettings {
    /**
     * Indicates whether to show label of the Axis by the primary line
     */
    showLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether to show the primary line of the Axis on the chart area
     */
    showPrimaryLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether to show grid of the Axis in the chart area
     */
    showGrid?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The line thickness of the primary line
     */
    thickness?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Color of the primary line. Accept the following format: standard name format: gray, red, black, etc hex
     * format: #ff00ff rgb format: rgb(256, 0, 256)
     */
    color?: string | PropertyBindingInfo;
  }
}

declare module "sap/makit/Category" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents the Category data region of the Chart.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Category extends UI5Element {
    /**
     * Constructor for a new Category.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CategorySettings
    );
    /**
     * Constructor for a new Category.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CategorySettings
    );

    /**
     * Creates a new subclass of class sap.makit.Category with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Category>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Category.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColumn column}.
     *
     * Specify the name of the column to be mapped to the Category Axis's value.
     *
     *
     * @returns Value of property `column`
     */
    getColumn(): string;
    /**
     * Gets current value of property {@link #getDisplayName displayName}.
     *
     * The text label representing this Category(on value bubble or table's header)
     *
     *
     * @returns Value of property `displayName`
     */
    getDisplayName(): string;
    /**
     * Gets current value of property {@link #getFormat format}.
     *
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     *
     *
     * @returns Value of property `format`
     */
    getFormat(): string;
    /**
     * Sets a new value for property {@link #getColumn column}.
     *
     * Specify the name of the column to be mapped to the Category Axis's value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumn(
      /**
       * New value for property `column`
       */
      sColumn?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayName displayName}.
     *
     * The text label representing this Category(on value bubble or table's header)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayName(
      /**
       * New value for property `displayName`
       */
      sDisplayName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFormat format}.
     *
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormat(
      /**
       * New value for property `format`
       */
      sFormat?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Category constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $CategorySettings extends $ElementSettings {
    /**
     * Specify the name of the column to be mapped to the Category Axis's value.
     */
    column?: string | PropertyBindingInfo;

    /**
     * The text label representing this Category(on value bubble or table's header)
     */
    displayName?: string | PropertyBindingInfo;

    /**
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     */
    format?: string | PropertyBindingInfo;
  }
}

declare module "sap/makit/CategoryAxis" {
  import { default as Axis, $AxisSettings } from "sap/makit/Axis";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SortOrder } from "sap/makit/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the properties of the Category's Axis.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class CategoryAxis extends Axis {
    /**
     * Constructor for a new CategoryAxis.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CategoryAxisSettings
    );
    /**
     * Constructor for a new CategoryAxis.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CategoryAxisSettings
    );

    /**
     * Creates a new subclass of class sap.makit.CategoryAxis with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.makit.Axis.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CategoryAxis>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.CategoryAxis.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDisplayAll displayAll}.
     *
     * Specify whether to display all the category values when there are multiple category data regions.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `displayAll`
     */
    getDisplayAll(): boolean;
    /**
     * Gets current value of property {@link #getDisplayLastLabel displayLastLabel}.
     *
     * Whether to always display the last label on the axis regardless of the automatic resize
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `displayLastLabel`
     */
    getDisplayLastLabel(): boolean;
    /**
     * Gets current value of property {@link #getSortOrder sortOrder}.
     *
     * Sort order of the chart
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `sortOrder`
     */
    getSortOrder(): SortOrder;
    /**
     * Sets a new value for property {@link #getDisplayAll displayAll}.
     *
     * Specify whether to display all the category values when there are multiple category data regions.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayAll(
      /**
       * New value for property `displayAll`
       */
      bDisplayAll?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayLastLabel displayLastLabel}.
     *
     * Whether to always display the last label on the axis regardless of the automatic resize
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayLastLabel(
      /**
       * New value for property `displayLastLabel`
       */
      bDisplayLastLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSortOrder sortOrder}.
     *
     * Sort order of the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSortOrder(
      /**
       * New value for property `sortOrder`
       */
      sSortOrder?: SortOrder | keyof typeof SortOrder
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CategoryAxis constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $CategoryAxisSettings extends $AxisSettings {
    /**
     * Sort order of the chart
     */
    sortOrder?:
      | (SortOrder | keyof typeof SortOrder)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Whether to always display the last label on the axis regardless of the automatic resize
     */
    displayLastLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specify whether to display all the category values when there are multiple category data regions.
     */
    displayAll?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/makit/Chart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Column from "sap/makit/Column";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import CategoryAxis from "sap/makit/CategoryAxis";

  import Category from "sap/makit/Category";

  import { CSSSize } from "sap/ui/core/library";

  import { LegendPosition, ChartType } from "sap/makit/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Row from "sap/makit/Row";

  import Series from "sap/makit/Series";

  import ValueAxis from "sap/makit/ValueAxis";

  import ValueBubble from "sap/makit/ValueBubble";

  import Value from "sap/makit/Value";

  /**
   * The Chart control.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and VizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Chart extends Control {
    /**
     * Constructor for a new Chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ChartSettings
    );
    /**
     * Constructor for a new Chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ChartSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Chart with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Chart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Chart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some column to the aggregation {@link #getColumns columns}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addColumn(
      /**
       * The column to add; if empty, nothing is inserted
       */
      oColumn: Column
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:doubletap doubletap} event of this `sap.makit.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.Chart` itself.
     *
     * Double tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDoubletap(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:doubletap doubletap} event of this `sap.makit.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.Chart` itself.
     *
     * Double tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDoubletap(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:longpress longpress} event of this `sap.makit.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.Chart` itself.
     *
     * Long press event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLongpress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:longpress longpress} event of this `sap.makit.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.Chart` itself.
     *
     * Long press event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLongpress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tap tap} event of this `sap.makit.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.Chart` itself.
     *
     * Single tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTap(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tap tap} event of this `sap.makit.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.Chart` itself.
     *
     * Single tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTap(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getColumns columns} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindColumns(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getRows rows} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindRows(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys the categoryAxis in the aggregation {@link #getCategoryAxis categoryAxis}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCategoryAxis(): this;
    /**
     * Destroys all the categoryRegions in the aggregation {@link #getCategoryRegions categoryRegions}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCategoryRegions(): this;
    /**
     * Destroys all the columns in the aggregation {@link #getColumns columns}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyColumns(): this;
    /**
     * Destroys the series in the aggregation {@link #getSeries series}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySeries(): this;
    /**
     * Destroys the valueAxis in the aggregation {@link #getValueAxis valueAxis}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyValueAxis(): this;
    /**
     * Destroys the valueBubble in the aggregation {@link #getValueBubble valueBubble}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyValueBubble(): this;
    /**
     * Destroys all the values in the aggregation {@link #getValues values}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyValues(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:doubletap doubletap} event of this `sap.makit.Chart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDoubletap(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:longpress longpress} event of this `sap.makit.Chart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLongpress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tap tap} event of this `sap.makit.Chart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTap(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:doubletap doubletap} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDoubletap(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:longpress longpress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLongpress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:tap tap} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTap(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getCategoryAxis categoryAxis}.
     *
     * Category Axis property of the Chart. Accepts only an instance of CategoryAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getCategoryAxis(): CategoryAxis;
    /**
     * Gets content of aggregation {@link #getCategoryRegions categoryRegions}.
     *
     * Data region property of the chart's Categories
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getCategoryRegions(): Category[];
    /**
     * Gets content of aggregation {@link #getColumns columns}.
     *
     * The data column map of the chart.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getColumns(): Column[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the Chart
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getLegendPosition legendPosition}.
     *
     * Legend position all chart types except Bar chart. Default position for Pie/Donut chart is Left. All other
     * chart's default position is None. Note: the default legend position is set when the chart type is set
     * first time, subsequent change to the chart type will keep using initial legend position unless it is
     * changed explicitly by user.
     *
     *
     * @returns Value of property `legendPosition`
     */
    getLegendPosition(): LegendPosition;
    /**
     * Gets current value of property {@link #getLineThickness lineThickness}.
     *
     * Specify the line thickness of the line graph. Only applies to Line chart type.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `lineThickness`
     */
    getLineThickness(): float;
    /**
     * Gets current value of property {@link #getMaxSliceCount maxSliceCount}.
     *
     * Set the maximum number of slices in a Pie/Donut chart. If exceeding the specified value, the rest will
     * be categorised into a single slice. Only applies to Pie/Donut.
     *
     * Default value is `12`.
     *
     *
     * @returns Value of property `maxSliceCount`
     */
    getMaxSliceCount(): int;
    /**
     * Get the number of distinct category values
     */
    getNumberOfCategories(): int;
    /**
     * Gets current value of property {@link #getNumberOfVisibleCategories numberOfVisibleCategories}.
     *
     * The number of categories that will be visible on the chart at any time. The minimum value is 2. If not
     * set, the number of visible categories will be automatically adjusted depending on the screen size
     *
     *
     * @returns Value of property `numberOfVisibleCategories`
     */
    getNumberOfVisibleCategories(): int;
    /**
     * Gets current value of property {@link #getPrimaryColorPalette primaryColorPalette}.
     *
     * Allow a chart’s color palette to be modified without affecting the other charts' color palette. If not
     * set, the chart will use the default color palette defined in the theme. Accept an array of color in string
     * format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     *
     * @returns Value of property `primaryColorPalette`
     */
    getPrimaryColorPalette(): any;
    /**
     * Gets current value of property {@link #getRangeSelectorStartPosition rangeSelectorStartPosition}.
     *
     * Specify the range selector start position, default value is 0.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `rangeSelectorStartPosition`
     */
    getRangeSelectorStartPosition(): int;
    /**
     * Gets content of aggregation {@link #getRows rows}.
     *
     * The data rows of the chart. User should bind these to their data source
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getRows(): Row[];
    /**
     * Get the value of the currently highlighted category
     */
    getSelectedCategory(): string;
    /**
     * Return an array of categories value that is currently selected.
     */
    getSelectedCategoryGroup(): object;
    /**
     * Get the value of the currently highlighted series
     */
    getSelectedSeries(): string;
    /**
     * Gets content of aggregation {@link #getSeries series}.
     *
     * Data region property of the chart's Series
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getSeries(): Series;
    /**
     * Gets current value of property {@link #getShowRangeSelector showRangeSelector}.
     *
     * Specify whether the range selector should be visible.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showRangeSelector`
     */
    getShowRangeSelector(): boolean;
    /**
     * Gets current value of property {@link #getShowTableValue showTableValue}.
     *
     * Toggle to display the table value on a Bar chart. Only applies to Bar chart.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTableValue`
     */
    getShowTableValue(): boolean;
    /**
     * Gets current value of property {@link #getShowTableView showTableView}.
     *
     * Toggle to display table view
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTableView`
     */
    getShowTableView(): boolean;
    /**
     * Gets current value of property {@link #getShowTotalValue showTotalValue}.
     *
     * Specify whether to show the sum of the value for Waterfall/Waterfall Bar chart. Only applies to Waterfall/WaterfallBar
     * chart.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTotalValue`
     */
    getShowTotalValue(): boolean;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Chart type
     *
     * Default value is `Column`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ChartType;
    /**
     * Gets content of aggregation {@link #getValueAxis valueAxis}.
     *
     * Value Axis property of the Chart. Accept only an instance of ValueAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getValueAxis(): ValueAxis;
    /**
     * Gets content of aggregation {@link #getValueBubble valueBubble}.
     *
     * Value Bubble property of the Chart. Accept only an instance of ValueBubble element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getValueBubble(): ValueBubble;
    /**
     * Gets content of aggregation {@link #getValues values}.
     *
     * Data region property of the chart's Values
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getValues(): Value[];
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the Chart
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.makit.Category` in the aggregation {@link #getCategoryRegions categoryRegions}.
     * and returns its index if found or -1 otherwise.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCategoryRegion(
      /**
       * The categoryRegion whose index is looked for
       */
      oCategoryRegion: Category
    ): int;
    /**
     * Checks for the provided `sap.makit.Column` in the aggregation {@link #getColumns columns}. and returns
     * its index if found or -1 otherwise.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfColumn(
      /**
       * The column whose index is looked for
       */
      oColumn: Column
    ): int;
    /**
     * Checks for the provided `sap.makit.Row` in the aggregation {@link #getRows rows}. and returns its index
     * if found or -1 otherwise.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRow(
      /**
       * The row whose index is looked for
       */
      oRow: Row
    ): int;
    /**
     * Checks for the provided `sap.makit.Value` in the aggregation {@link #getValues values}. and returns its
     * index if found or -1 otherwise.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfValue(
      /**
       * The value whose index is looked for
       */
      oValue: Value
    ): int;
    /**
     * Inserts a column into the aggregation {@link #getColumns columns}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertColumn(
      /**
       * The column to insert; if empty, nothing is inserted
       */
      oColumn: Column,
      /**
       * The `0`-based index the column should be inserted at; for a negative value of `iIndex`, the column is
       * inserted at position 0; for a value greater than the current size of the aggregation, the column is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getColumns columns}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllColumns(): Column[];
    /**
     * Removes a column from the aggregation {@link #getColumns columns}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The removed column or `null`
     */
    removeColumn(
      /**
       * The column to remove or its index or id
       */
      vColumn: int | string | Column
    ): Column | null;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the Chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getLegendPosition legendPosition}.
     *
     * Legend position all chart types except Bar chart. Default position for Pie/Donut chart is Left. All other
     * chart's default position is None. Note: the default legend position is set when the chart type is set
     * first time, subsequent change to the chart type will keep using initial legend position unless it is
     * changed explicitly by user.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendPosition(
      /**
       * New value for property `legendPosition`
       */
      sLegendPosition?: LegendPosition | keyof typeof LegendPosition
    ): this;
    /**
     * Sets a new value for property {@link #getLineThickness lineThickness}.
     *
     * Specify the line thickness of the line graph. Only applies to Line chart type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLineThickness(
      /**
       * New value for property `lineThickness`
       */
      fLineThickness?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMaxSliceCount maxSliceCount}.
     *
     * Set the maximum number of slices in a Pie/Donut chart. If exceeding the specified value, the rest will
     * be categorised into a single slice. Only applies to Pie/Donut.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `12`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxSliceCount(
      /**
       * New value for property `maxSliceCount`
       */
      iMaxSliceCount?: int
    ): this;
    /**
     * Sets a new value for property {@link #getNumberOfVisibleCategories numberOfVisibleCategories}.
     *
     * The number of categories that will be visible on the chart at any time. The minimum value is 2. If not
     * set, the number of visible categories will be automatically adjusted depending on the screen size
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNumberOfVisibleCategories(
      /**
       * New value for property `numberOfVisibleCategories`
       */
      iNumberOfVisibleCategories?: int
    ): this;
    /**
     * Sets a new value for property {@link #getRangeSelectorStartPosition rangeSelectorStartPosition}.
     *
     * Specify the range selector start position, default value is 0.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRangeSelectorStartPosition(
      /**
       * New value for property `rangeSelectorStartPosition`
       */
      iRangeSelectorStartPosition?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowRangeSelector showRangeSelector}.
     *
     * Specify whether the range selector should be visible.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRangeSelector(
      /**
       * New value for property `showRangeSelector`
       */
      bShowRangeSelector?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTableValue showTableValue}.
     *
     * Toggle to display the table value on a Bar chart. Only applies to Bar chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTableValue(
      /**
       * New value for property `showTableValue`
       */
      bShowTableValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTableView showTableView}.
     *
     * Toggle to display table view
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTableView(
      /**
       * New value for property `showTableView`
       */
      bShowTableView?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTotalValue showTotalValue}.
     *
     * Specify whether to show the sum of the value for Waterfall/Waterfall Bar chart. Only applies to Waterfall/WaterfallBar
     * chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTotalValue(
      /**
       * New value for property `showTotalValue`
       */
      bShowTotalValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Chart type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Column`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ChartType | keyof typeof ChartType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the Chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getColumns columns} from model data.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindColumns(): this;
    /**
     * Unbinds aggregation {@link #getRows rows} from model data.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindRows(): this;
  }
  /**
   * Describes the settings that can be provided to the Chart constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and VizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $ChartSettings extends $ControlSettings {
    /**
     * The width of the Chart
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the Chart
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Chart type
     */
    type?:
      | (ChartType | keyof typeof ChartType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specify whether the range selector should be visible.
     */
    showRangeSelector?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Toggle to display table view
     */
    showTableView?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Legend position all chart types except Bar chart. Default position for Pie/Donut chart is Left. All other
     * chart's default position is None. Note: the default legend position is set when the chart type is set
     * first time, subsequent change to the chart type will keep using initial legend position unless it is
     * changed explicitly by user.
     */
    legendPosition?:
      | (LegendPosition | keyof typeof LegendPosition)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specify the line thickness of the line graph. Only applies to Line chart type.
     */
    lineThickness?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Toggle to display the table value on a Bar chart. Only applies to Bar chart.
     */
    showTableValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the maximum number of slices in a Pie/Donut chart. If exceeding the specified value, the rest will
     * be categorised into a single slice. Only applies to Pie/Donut.
     */
    maxSliceCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow a chart’s color palette to be modified without affecting the other charts' color palette. If not
     * set, the chart will use the default color palette defined in the theme. Accept an array of color in string
     * format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     */
    primaryColorPalette?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Specify whether to show the sum of the value for Waterfall/Waterfall Bar chart. Only applies to Waterfall/WaterfallBar
     * chart.
     */
    showTotalValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The number of categories that will be visible on the chart at any time. The minimum value is 2. If not
     * set, the number of visible categories will be automatically adjusted depending on the screen size
     */
    numberOfVisibleCategories?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specify the range selector start position, default value is 0.
     */
    rangeSelectorStartPosition?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The data rows of the chart. User should bind these to their data source
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    rows?: Row[] | Row | AggregationBindingInfo | `{${string}}`;

    /**
     * The data column map of the chart.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    columns?: Column[] | Column | AggregationBindingInfo | `{${string}}`;

    /**
     * Data region property of the chart's Series
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    series?: Series;

    /**
     * Data region property of the chart's Values
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    values?: Value[] | Value | AggregationBindingInfo | `{${string}}`;

    /**
     * Data region property of the chart's Categories
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    categoryRegions?:
      | Category[]
      | Category
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Data region property of the chart's Category
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    category?: Category;

    /**
     * Category Axis property of the Chart. Accepts only an instance of CategoryAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    categoryAxis?: CategoryAxis;

    /**
     * Value Axis property of the Chart. Accept only an instance of ValueAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    valueAxis?: ValueAxis;

    /**
     * Value Bubble property of the Chart. Accept only an instance of ValueBubble element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    valueBubble?: ValueBubble;

    /**
     * Double tap event on the chart
     */
    doubletap?: (oEvent: Event) => void;

    /**
     * Single tap event on the chart
     */
    tap?: (oEvent: Event) => void;

    /**
     * Long press event on the chart
     */
    longpress?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Chart#doubletap event.
   */
  export interface Chart$DoubletapEventParameters {}

  /**
   * Event object of the Chart#doubletap event.
   */
  export type Chart$DoubletapEvent = Event<
    Chart$DoubletapEventParameters,
    Chart
  >;

  /**
   * Parameters of the Chart#longpress event.
   */
  export interface Chart$LongpressEventParameters {}

  /**
   * Event object of the Chart#longpress event.
   */
  export type Chart$LongpressEvent = Event<
    Chart$LongpressEventParameters,
    Chart
  >;

  /**
   * Parameters of the Chart#tap event.
   */
  export interface Chart$TapEventParameters {}

  /**
   * Event object of the Chart#tap event.
   */
  export type Chart$TapEvent = Event<Chart$TapEventParameters, Chart>;
}

declare module "sap/makit/Column" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The data column of the Chart's data table
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Column extends UI5Element {
    /**
     * Constructor for a new Column.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnSettings
    );
    /**
     * Constructor for a new Column.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Column with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Column>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Column.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * The name representing the Column
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * The data type of the Column: number string datetime
     *
     * Default value is `'string'`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The value mapped to this Column (User should map this using data binding)
     *
     *
     * @returns Value of property `value`
     */
    getValue(): any;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * The name representing the Column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * The data type of the Column: number string datetime
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'string'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The value mapped to this Column (User should map this using data binding)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      oValue?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Column constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $ColumnSettings extends $ElementSettings {
    /**
     * The name representing the Column
     */
    name?: string | PropertyBindingInfo;

    /**
     * The value mapped to this Column (User should map this using data binding)
     */
    value?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The data type of the Column: number string datetime
     */
    type?: string | PropertyBindingInfo;
  }
}

declare module "sap/makit/CombinationChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import CategoryAxis from "sap/makit/CategoryAxis";

  import Category from "sap/makit/Category";

  import { CSSSize } from "sap/ui/core/library";

  import Layer from "sap/makit/Layer";

  import { LegendPosition } from "sap/makit/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ValueAxis from "sap/makit/ValueAxis";

  import ValueBubble from "sap/makit/ValueBubble";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The CombinationChart control.
   *
   * @since 1.12
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class CombinationChart extends Control {
    /**
     * Constructor for a new CombinationChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CombinationChartSettings
    );
    /**
     * Constructor for a new CombinationChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CombinationChartSettings
    );

    /**
     * Creates a new subclass of class sap.makit.CombinationChart with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CombinationChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.CombinationChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:doubletap doubletap} event of this `sap.makit.CombinationChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.CombinationChart` itself.
     *
     * Double tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDoubletap(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.CombinationChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:doubletap doubletap} event of this `sap.makit.CombinationChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.CombinationChart` itself.
     *
     * Double tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDoubletap(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.CombinationChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:longpress longpress} event of this `sap.makit.CombinationChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.CombinationChart` itself.
     *
     * Long press event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLongpress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.CombinationChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:longpress longpress} event of this `sap.makit.CombinationChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.CombinationChart` itself.
     *
     * Long press event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLongpress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.CombinationChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tap tap} event of this `sap.makit.CombinationChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.CombinationChart` itself.
     *
     * Single tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTap(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.CombinationChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tap tap} event of this `sap.makit.CombinationChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.makit.CombinationChart` itself.
     *
     * Single tap event on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTap(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.makit.CombinationChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the categoryAxis in the aggregation {@link #getCategoryAxis categoryAxis}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCategoryAxis(): this;
    /**
     * Destroys all the categoryRegions in the aggregation {@link #getCategoryRegions categoryRegions}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCategoryRegions(): this;
    /**
     * Destroys all the layers in the aggregation {@link #getLayers layers}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLayers(): this;
    /**
     * Destroys the primaryValueAxis in the aggregation {@link #getPrimaryValueAxis primaryValueAxis}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPrimaryValueAxis(): this;
    /**
     * Destroys the secondaryValueAxis in the aggregation {@link #getSecondaryValueAxis secondaryValueAxis}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySecondaryValueAxis(): this;
    /**
     * Destroys the valueBubble in the aggregation {@link #getValueBubble valueBubble}.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyValueBubble(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:doubletap doubletap} event of this `sap.makit.CombinationChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDoubletap(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:longpress longpress} event of this `sap.makit.CombinationChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLongpress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tap tap} event of this `sap.makit.CombinationChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTap(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:doubletap doubletap} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDoubletap(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:longpress longpress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLongpress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:tap tap} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTap(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getCategoryAxis categoryAxis}.
     *
     * Category Axis property of the Chart. Accepts only an instance of CategoryAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getCategoryAxis(): CategoryAxis;
    /**
     * Gets content of aggregation {@link #getCategoryRegions categoryRegions}.
     *
     * Data region property of the chart's Categories
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getCategoryRegions(): Category[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the Chart
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets content of aggregation {@link #getLayers layers}.
     *
     * The collection of charts
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getLayers(): Layer[];
    /**
     * Gets current value of property {@link #getLegendPosition legendPosition}.
     *
     * Legend position for Pie /Donut chart only.
     *
     * Default value is `Left`.
     *
     *
     * @returns Value of property `legendPosition`
     */
    getLegendPosition(): LegendPosition;
    /**
     * Get the number of distinct category values
     */
    getNumberOfCategories(): int;
    /**
     * Gets current value of property {@link #getNumberOfVisibleCategories numberOfVisibleCategories}.
     *
     * The number of categories that will be visible on the chart at any time. The minimum value is 2. If not
     * set, the number of visible categories will be automatically adjusted depending on the screen size
     *
     *
     * @returns Value of property `numberOfVisibleCategories`
     */
    getNumberOfVisibleCategories(): int;
    /**
     * Gets current value of property {@link #getPrimaryColorPalette primaryColorPalette}.
     *
     * Allow a combination chart’s primary axis color palette to be modified without affecting other charts'
     * color palette. If not set, the chart will use the default color palette defined in the theme. Accept
     * an array of color in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     *
     * @returns Value of property `primaryColorPalette`
     */
    getPrimaryColorPalette(): any;
    /**
     * Gets content of aggregation {@link #getPrimaryValueAxis primaryValueAxis}.
     *
     * Property of the Combination Chart's primary Value Axis. Accept only an instance of ValueAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getPrimaryValueAxis(): ValueAxis;
    /**
     * Gets current value of property {@link #getRangeSelectorStartPosition rangeSelectorStartPosition}.
     *
     * Specify the range selector start position, default value is 0.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `rangeSelectorStartPosition`
     */
    getRangeSelectorStartPosition(): int;
    /**
     * Gets current value of property {@link #getSecondaryColorPalette secondaryColorPalette}.
     *
     * Allow a combination chart’s secondary axis color palette to be modified without affecting other charts'
     * color palette. If not set, the chart will use the default color palette defined in the theme. Accept
     * an array of color in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     *
     * @returns Value of property `secondaryColorPalette`
     */
    getSecondaryColorPalette(): any;
    /**
     * Gets content of aggregation {@link #getSecondaryValueAxis secondaryValueAxis}.
     *
     * Property of the Combination Chart's secondary Value Axis. Accept only an instance of ValueAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getSecondaryValueAxis(): ValueAxis;
    /**
     * Get the value of the currently highlighted category
     */
    getSelectedCategory(): string;
    /**
     * Return an array of categories value that is currently selected.
     */
    getSelectedCategoryGroup(): object;
    /**
     * Gets current value of property {@link #getShowRangeSelector showRangeSelector}.
     *
     * Specify whether the range selector should be visible.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showRangeSelector`
     */
    getShowRangeSelector(): boolean;
    /**
     * Gets current value of property {@link #getShowTableValue showTableValue}.
     *
     * Toggle to display the table value on a Bar chart. Only applies to Bar chart.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTableValue`
     */
    getShowTableValue(): boolean;
    /**
     * Gets content of aggregation {@link #getValueBubble valueBubble}.
     *
     * Value Bubble property of the Chart. Accept only an instance of ValueBubble element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    getValueBubble(): ValueBubble;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the Chart
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.makit.Category` in the aggregation {@link #getCategoryRegions categoryRegions}.
     * and returns its index if found or -1 otherwise.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCategoryRegion(
      /**
       * The categoryRegion whose index is looked for
       */
      oCategoryRegion: Category
    ): int;
    /**
     * Checks for the provided `sap.makit.Layer` in the aggregation {@link #getLayers layers}. and returns its
     * index if found or -1 otherwise.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfLayer(
      /**
       * The layer whose index is looked for
       */
      oLayer: Layer
    ): int;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the Chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getLegendPosition legendPosition}.
     *
     * Legend position for Pie /Donut chart only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Left`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendPosition(
      /**
       * New value for property `legendPosition`
       */
      sLegendPosition?: LegendPosition | keyof typeof LegendPosition
    ): this;
    /**
     * Sets a new value for property {@link #getNumberOfVisibleCategories numberOfVisibleCategories}.
     *
     * The number of categories that will be visible on the chart at any time. The minimum value is 2. If not
     * set, the number of visible categories will be automatically adjusted depending on the screen size
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNumberOfVisibleCategories(
      /**
       * New value for property `numberOfVisibleCategories`
       */
      iNumberOfVisibleCategories?: int
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryColorPalette primaryColorPalette}.
     *
     * Allow a combination chart’s primary axis color palette to be modified without affecting other charts'
     * color palette. If not set, the chart will use the default color palette defined in the theme. Accept
     * an array of color in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryColorPalette(
      /**
       * New value for property `primaryColorPalette`
       */
      oPrimaryColorPalette?: any
    ): this;
    /**
     * Sets a new value for property {@link #getRangeSelectorStartPosition rangeSelectorStartPosition}.
     *
     * Specify the range selector start position, default value is 0.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRangeSelectorStartPosition(
      /**
       * New value for property `rangeSelectorStartPosition`
       */
      iRangeSelectorStartPosition?: int
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryColorPalette secondaryColorPalette}.
     *
     * Allow a combination chart’s secondary axis color palette to be modified without affecting other charts'
     * color palette. If not set, the chart will use the default color palette defined in the theme. Accept
     * an array of color in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryColorPalette(
      /**
       * New value for property `secondaryColorPalette`
       */
      oSecondaryColorPalette?: any
    ): this;
    /**
     * Sets a new value for property {@link #getShowRangeSelector showRangeSelector}.
     *
     * Specify whether the range selector should be visible.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRangeSelector(
      /**
       * New value for property `showRangeSelector`
       */
      bShowRangeSelector?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTableValue showTableValue}.
     *
     * Toggle to display the table value on a Bar chart. Only applies to Bar chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTableValue(
      /**
       * New value for property `showTableValue`
       */
      bShowTableValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the Chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CombinationChart constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $CombinationChartSettings extends $ControlSettings {
    /**
     * The width of the Chart
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the Chart
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Specify whether the range selector should be visible.
     */
    showRangeSelector?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Legend position for Pie /Donut chart only.
     */
    legendPosition?:
      | (LegendPosition | keyof typeof LegendPosition)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Allow a combination chart’s primary axis color palette to be modified without affecting other charts'
     * color palette. If not set, the chart will use the default color palette defined in the theme. Accept
     * an array of color in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     */
    primaryColorPalette?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow a combination chart’s secondary axis color palette to be modified without affecting other charts'
     * color palette. If not set, the chart will use the default color palette defined in the theme. Accept
     * an array of color in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     */
    secondaryColorPalette?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Toggle to display the table value on a Bar chart. Only applies to Bar chart.
     */
    showTableValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The number of categories that will be visible on the chart at any time. The minimum value is 2. If not
     * set, the number of visible categories will be automatically adjusted depending on the screen size
     */
    numberOfVisibleCategories?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specify the range selector start position, default value is 0.
     */
    rangeSelectorStartPosition?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Data region property of the chart's Categories
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    categoryRegions?:
      | Category[]
      | Category
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * The collection of charts
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    layers?: Layer[] | Layer | AggregationBindingInfo | `{${string}}`;

    /**
     * Category Axis property of the Chart. Accepts only an instance of CategoryAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    categoryAxis?: CategoryAxis;

    /**
     * Property of the Combination Chart's primary Value Axis. Accept only an instance of ValueAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    primaryValueAxis?: ValueAxis;

    /**
     * Property of the Combination Chart's secondary Value Axis. Accept only an instance of ValueAxis element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    secondaryValueAxis?: ValueAxis;

    /**
     * Value Bubble property of the Chart. Accept only an instance of ValueBubble element.
     *
     * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
     * control will not be supported anymore from 1.38.
     */
    valueBubble?: ValueBubble;

    /**
     * Double tap event on the chart
     */
    doubletap?: (oEvent: Event) => void;

    /**
     * Single tap event on the chart
     */
    tap?: (oEvent: Event) => void;

    /**
     * Long press event on the chart
     */
    longpress?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the CombinationChart#doubletap event.
   */
  export interface CombinationChart$DoubletapEventParameters {}

  /**
   * Event object of the CombinationChart#doubletap event.
   */
  export type CombinationChart$DoubletapEvent = Event<
    CombinationChart$DoubletapEventParameters,
    CombinationChart
  >;

  /**
   * Parameters of the CombinationChart#longpress event.
   */
  export interface CombinationChart$LongpressEventParameters {}

  /**
   * Event object of the CombinationChart#longpress event.
   */
  export type CombinationChart$LongpressEvent = Event<
    CombinationChart$LongpressEventParameters,
    CombinationChart
  >;

  /**
   * Parameters of the CombinationChart#tap event.
   */
  export interface CombinationChart$TapEventParameters {}

  /**
   * Event object of the CombinationChart#tap event.
   */
  export type CombinationChart$TapEvent = Event<
    CombinationChart$TapEventParameters,
    CombinationChart
  >;
}

declare module "sap/makit/Layer" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Column from "sap/makit/Column";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Row from "sap/makit/Row";

  import Series from "sap/makit/Series";

  import { ChartType } from "sap/makit/library";

  import Value from "sap/makit/Value";

  /**
   * Layer represent a chart in the CombinationChart
   *
   * @since 1.12
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Layer extends UI5Element {
    /**
     * Constructor for a new Layer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LayerSettings
    );
    /**
     * Constructor for a new Layer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LayerSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Layer with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Layer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Layer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some column to the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addColumn(
      /**
       * The column to add; if empty, nothing is inserted
       */
      oColumn: Column
    ): this;
    /**
     * Binds aggregation {@link #getColumns columns} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindColumns(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getRows rows} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindRows(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the columns in the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyColumns(): this;
    /**
     * Destroys the series in the aggregation {@link #getSeries series}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySeries(): this;
    /**
     * Destroys all the values in the aggregation {@link #getValues values}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyValues(): this;
    /**
     * Gets content of aggregation {@link #getColumns columns}.
     *
     * The data column map of the chart.
     */
    getColumns(): Column[];
    /**
     * Gets current value of property {@link #getDrawOnSecondaryAxis drawOnSecondaryAxis}.
     *
     * Specifiy whether this layer should be drawn on the secondary axis.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `drawOnSecondaryAxis`
     */
    getDrawOnSecondaryAxis(): boolean;
    /**
     * Gets current value of property {@link #getLineThickness lineThickness}.
     *
     * Specify the line thickness of the line graph. Only applies to Line chart type.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `lineThickness`
     */
    getLineThickness(): float;
    /**
     * Gets current value of property {@link #getPrimaryColorPalette primaryColorPalette}.
     *
     * Allow a layer’s primary axis color palette to be modified without affecting other charts in the same
     * screen. If not set, the chart will use the default color palette defined in the theme. This property
     * will take precedence over other CombinationChart's color palette properties. Accept an array of color
     * in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     *
     * @returns Value of property `primaryColorPalette`
     */
    getPrimaryColorPalette(): any;
    /**
     * Gets content of aggregation {@link #getRows rows}.
     *
     * The data rows of the chart. User should bind these to their data source
     */
    getRows(): Row[];
    /**
     * Get the value of the currently highlighted series
     */
    getSelectedSeries(): string;
    /**
     * Gets content of aggregation {@link #getSeries series}.
     *
     * Data region property of the chart's Series
     */
    getSeries(): Series;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Chart type
     *
     * Default value is `Column`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ChartType;
    /**
     * Gets content of aggregation {@link #getValues values}.
     *
     * Data region property of the chart's Values
     */
    getValues(): Value[];
    /**
     * Checks for the provided `sap.makit.Column` in the aggregation {@link #getColumns columns}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfColumn(
      /**
       * The column whose index is looked for
       */
      oColumn: Column
    ): int;
    /**
     * Checks for the provided `sap.makit.Row` in the aggregation {@link #getRows rows}. and returns its index
     * if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRow(
      /**
       * The row whose index is looked for
       */
      oRow: Row
    ): int;
    /**
     * Checks for the provided `sap.makit.Value` in the aggregation {@link #getValues values}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfValue(
      /**
       * The value whose index is looked for
       */
      oValue: Value
    ): int;
    /**
     * Inserts a column into the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertColumn(
      /**
       * The column to insert; if empty, nothing is inserted
       */
      oColumn: Column,
      /**
       * The `0`-based index the column should be inserted at; for a negative value of `iIndex`, the column is
       * inserted at position 0; for a value greater than the current size of the aggregation, the column is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a value into the aggregation {@link #getValues values}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertValue(
      /**
       * The value to insert; if empty, nothing is inserted
       */
      oValue: Value,
      /**
       * The `0`-based index the value should be inserted at; for a negative value of `iIndex`, the value is inserted
       * at position 0; for a value greater than the current size of the aggregation, the value is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getColumns columns}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllColumns(): Column[];
    /**
     * Removes all the controls from the aggregation {@link #getValues values}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllValues(): Value[];
    /**
     * Removes a column from the aggregation {@link #getColumns columns}.
     *
     *
     * @returns The removed column or `null`
     */
    removeColumn(
      /**
       * The column to remove or its index or id
       */
      vColumn: int | string | Column
    ): Column | null;
    /**
     * Removes a value from the aggregation {@link #getValues values}.
     *
     *
     * @returns The removed value or `null`
     */
    removeValue(
      /**
       * The value to remove or its index or id
       */
      vValue: int | string | Value
    ): Value | null;
    /**
     * Sets a new value for property {@link #getDrawOnSecondaryAxis drawOnSecondaryAxis}.
     *
     * Specifiy whether this layer should be drawn on the secondary axis.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDrawOnSecondaryAxis(
      /**
       * New value for property `drawOnSecondaryAxis`
       */
      bDrawOnSecondaryAxis?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLineThickness lineThickness}.
     *
     * Specify the line thickness of the line graph. Only applies to Line chart type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLineThickness(
      /**
       * New value for property `lineThickness`
       */
      fLineThickness?: float
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryColorPalette primaryColorPalette}.
     *
     * Allow a layer’s primary axis color palette to be modified without affecting other charts in the same
     * screen. If not set, the chart will use the default color palette defined in the theme. This property
     * will take precedence over other CombinationChart's color palette properties. Accept an array of color
     * in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryColorPalette(
      /**
       * New value for property `primaryColorPalette`
       */
      oPrimaryColorPalette?: any
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Chart type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Column`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ChartType | keyof typeof ChartType
    ): this;
    /**
     * Unbinds aggregation {@link #getColumns columns} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindColumns(): this;
    /**
     * Unbinds aggregation {@link #getRows rows} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindRows(): this;
  }
  /**
   * Describes the settings that can be provided to the Layer constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $LayerSettings extends $ElementSettings {
    /**
     * Chart type
     */
    type?:
      | (ChartType | keyof typeof ChartType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specify the line thickness of the line graph. Only applies to Line chart type.
     */
    lineThickness?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow a layer’s primary axis color palette to be modified without affecting other charts in the same
     * screen. If not set, the chart will use the default color palette defined in the theme. This property
     * will take precedence over other CombinationChart's color palette properties. Accept an array of color
     * in string format or hex format. e.g. 0xff0000 "red" "rgb(255,0,0)"
     */
    primaryColorPalette?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifiy whether this layer should be drawn on the secondary axis.
     */
    drawOnSecondaryAxis?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The data rows of the chart. User should bind these to their data source
     */
    rows?: Row[] | Row | AggregationBindingInfo | `{${string}}`;

    /**
     * The data column map of the chart.
     */
    columns?: Column[] | Column | AggregationBindingInfo | `{${string}}`;

    /**
     * Data region property of the chart's Series
     */
    series?: Series;

    /**
     * Data region property of the chart's Values
     */
    values?: Value[] | Value | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/makit/MakitLib" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Wrapper for MAKit Chart Library. Only to be used used internally.
   *
   * @since 1.12
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class MakitLib extends UI5Element {
    /**
     * Constructor for a new MakitLib.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MakitLibSettings
    );
    /**
     * Constructor for a new MakitLib.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MakitLibSettings
    );

    /**
     * Creates a new subclass of class sap.makit.MakitLib with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MakitLib>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.MakitLib.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the MakitLib constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $MakitLibSettings extends $ElementSettings {}
}

declare module "sap/makit/Row" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Column from "sap/makit/Column";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The data row of the Chart's data table
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Row extends UI5Element {
    /**
     * Constructor for a new Row.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $RowSettings
    );
    /**
     * Constructor for a new Row.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $RowSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Row with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Row>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Row.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some cell to the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCell(
      /**
       * The cell to add; if empty, nothing is inserted
       */
      oCell: Column
    ): this;
    /**
     * Destroys all the cells in the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCells(): this;
    /**
     * Gets content of aggregation {@link #getCells cells}.
     *
     * Representing the cells of the row. User should not add individual cells. The cells will be added automatically
     * via Column mapping.
     */
    getCells(): Column[];
    /**
     * Checks for the provided `sap.makit.Column` in the aggregation {@link #getCells cells}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCell(
      /**
       * The cell whose index is looked for
       */
      oCell: Column
    ): int;
    /**
     * Inserts a cell into the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCell(
      /**
       * The cell to insert; if empty, nothing is inserted
       */
      oCell: Column,
      /**
       * The `0`-based index the cell should be inserted at; for a negative value of `iIndex`, the cell is inserted
       * at position 0; for a value greater than the current size of the aggregation, the cell is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getCells cells}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCells(): Column[];
    /**
     * Removes a cell from the aggregation {@link #getCells cells}.
     *
     *
     * @returns The removed cell or `null`
     */
    removeCell(
      /**
       * The cell to remove or its index or id
       */
      vCell: int | string | Column
    ): Column | null;
  }
  /**
   * Describes the settings that can be provided to the Row constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $RowSettings extends $ElementSettings {
    /**
     * Representing the cells of the row. User should not add individual cells. The cells will be added automatically
     * via Column mapping.
     */
    cells?: Column[] | Column | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/makit/Series" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents the Series data region of the Chart.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Series extends UI5Element {
    /**
     * Constructor for a new Series.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SeriesSettings
    );
    /**
     * Constructor for a new Series.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SeriesSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Series with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Series>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Series.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColumn column}.
     *
     * The name of the column that will be mapped to the chart's Series value
     *
     *
     * @returns Value of property `column`
     */
    getColumn(): string;
    /**
     * Gets current value of property {@link #getDisplayName displayName}.
     *
     * The displayed name of the Series
     *
     *
     * @returns Value of property `displayName`
     */
    getDisplayName(): string;
    /**
     * Gets current value of property {@link #getFormat format}.
     *
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     *
     *
     * @returns Value of property `format`
     */
    getFormat(): string;
    /**
     * Sets a new value for property {@link #getColumn column}.
     *
     * The name of the column that will be mapped to the chart's Series value
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumn(
      /**
       * New value for property `column`
       */
      sColumn?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayName displayName}.
     *
     * The displayed name of the Series
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayName(
      /**
       * New value for property `displayName`
       */
      sDisplayName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFormat format}.
     *
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormat(
      /**
       * New value for property `format`
       */
      sFormat?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Series constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $SeriesSettings extends $ElementSettings {
    /**
     * The name of the column that will be mapped to the chart's Series value
     */
    column?: string | PropertyBindingInfo;

    /**
     * The displayed name of the Series
     */
    displayName?: string | PropertyBindingInfo;

    /**
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     */
    format?: string | PropertyBindingInfo;
  }
}

declare module "sap/makit/Value" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents the Value data region of the Chart.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class Value extends UI5Element {
    /**
     * Constructor for a new Value.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ValueSettings
    );
    /**
     * Constructor for a new Value.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ValueSettings
    );

    /**
     * Creates a new subclass of class sap.makit.Value with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Value>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.Value.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDisplayName displayName}.
     *
     * The text label representing this Value (on value bubble or table's header)
     *
     *
     * @returns Value of property `displayName`
     */
    getDisplayName(): string;
    /**
     * Gets current value of property {@link #getExpression expression}.
     *
     * The user should map the column on this property. The expression allows more advanced column mapping.
     * Instead of just specifying the column name (e.g. revenueValue), the user can use SAP expression language
     * e.g. Assuming the user has a revenueValue column and an operatingCost column, the user can specify the
     * following expression: "revenueValue - operatingCost" the resulting value displayed in the chart will
     * be the arithmatic operation result on these two columns.
     *
     *
     * @returns Value of property `expression`
     */
    getExpression(): string;
    /**
     * Gets current value of property {@link #getFormat format}.
     *
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     *
     *
     * @returns Value of property `format`
     */
    getFormat(): string;
    /**
     * Gets current value of property {@link #getLocale locale}.
     *
     * Comma separated locales for specifiying values in different locale. The locale will be mapped in the
     * same order as the series data. e.g. zh-CH, en-US, de-DE The first zh-CH will be applied to the value
     * of the first series, en-US will be applied to the second series. Currently will only work with 'currency'
     * format. Supported locales: en, zh, de, fr, es, ru, ja, pt and their more specific variations such as
     * en-CA, es-AR, zh-HK, etc.
     *
     *
     * @returns Value of property `locale`
     */
    getLocale(): string;
    /**
     * Sets a new value for property {@link #getDisplayName displayName}.
     *
     * The text label representing this Value (on value bubble or table's header)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayName(
      /**
       * New value for property `displayName`
       */
      sDisplayName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getExpression expression}.
     *
     * The user should map the column on this property. The expression allows more advanced column mapping.
     * Instead of just specifying the column name (e.g. revenueValue), the user can use SAP expression language
     * e.g. Assuming the user has a revenueValue column and an operatingCost column, the user can specify the
     * following expression: "revenueValue - operatingCost" the resulting value displayed in the chart will
     * be the arithmatic operation result on these two columns.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpression(
      /**
       * New value for property `expression`
       */
      sExpression?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFormat format}.
     *
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormat(
      /**
       * New value for property `format`
       */
      sFormat?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLocale locale}.
     *
     * Comma separated locales for specifiying values in different locale. The locale will be mapped in the
     * same order as the series data. e.g. zh-CH, en-US, de-DE The first zh-CH will be applied to the value
     * of the first series, en-US will be applied to the second series. Currently will only work with 'currency'
     * format. Supported locales: en, zh, de, fr, es, ru, ja, pt and their more specific variations such as
     * en-CA, es-AR, zh-HK, etc.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLocale(
      /**
       * New value for property `locale`
       */
      sLocale?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Value constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $ValueSettings extends $ElementSettings {
    /**
     * The user should map the column on this property. The expression allows more advanced column mapping.
     * Instead of just specifying the column name (e.g. revenueValue), the user can use SAP expression language
     * e.g. Assuming the user has a revenueValue column and an operatingCost column, the user can specify the
     * following expression: "revenueValue - operatingCost" the resulting value displayed in the chart will
     * be the arithmatic operation result on these two columns.
     */
    expression?: string | PropertyBindingInfo;

    /**
     * The text label representing this Value (on value bubble or table's header)
     */
    displayName?: string | PropertyBindingInfo;

    /**
     * Number formatting for the value. Accepted values: number currency percent roundedN - where N represents
     * number of decimal places e.g. rounded4
     */
    format?: string | PropertyBindingInfo;

    /**
     * Comma separated locales for specifiying values in different locale. The locale will be mapped in the
     * same order as the series data. e.g. zh-CH, en-US, de-DE The first zh-CH will be applied to the value
     * of the first series, en-US will be applied to the second series. Currently will only work with 'currency'
     * format. Supported locales: en, zh, de, fr, es, ru, ja, pt and their more specific variations such as
     * en-CA, es-AR, zh-HK, etc.
     */
    locale?: string | PropertyBindingInfo;
  }
}

declare module "sap/makit/ValueAxis" {
  import { default as Axis, $AxisSettings } from "sap/makit/Axis";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the properties of the Value's Axis.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class ValueAxis extends Axis {
    /**
     * Constructor for a new ValueAxis.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ValueAxisSettings
    );
    /**
     * Constructor for a new ValueAxis.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ValueAxisSettings
    );

    /**
     * Creates a new subclass of class sap.makit.ValueAxis with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.makit.Axis.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ValueAxis>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.ValueAxis.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMax max}.
     *
     * Highest displayed value on the Value Axis (this value will be automatically adjusted to nearest major
     * tick value depending on the value's range)
     *
     *
     * @returns Value of property `max`
     */
    getMax(): string;
    /**
     * Gets current value of property {@link #getMin min}.
     *
     * Highest displayed value on the Value Axis (this value will be automatically adjusted to nearest major
     * tick value depending on the value's range). Set to empty string to switch back to automatic calculation.
     *
     *
     * @returns Value of property `min`
     */
    getMin(): string;
    /**
     * Sets a new value for property {@link #getMax max}.
     *
     * Highest displayed value on the Value Axis (this value will be automatically adjusted to nearest major
     * tick value depending on the value's range)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMax(
      /**
       * New value for property `max`
       */
      sMax?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMin min}.
     *
     * Highest displayed value on the Value Axis (this value will be automatically adjusted to nearest major
     * tick value depending on the value's range). Set to empty string to switch back to automatic calculation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMin(
      /**
       * New value for property `min`
       */
      sMin?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ValueAxis constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $ValueAxisSettings extends $AxisSettings {
    /**
     * Highest displayed value on the Value Axis (this value will be automatically adjusted to nearest major
     * tick value depending on the value's range). Set to empty string to switch back to automatic calculation.
     */
    min?: string | PropertyBindingInfo;

    /**
     * Highest displayed value on the Value Axis (this value will be automatically adjusted to nearest major
     * tick value depending on the value's range)
     */
    max?: string | PropertyBindingInfo;
  }
}

declare module "sap/makit/ValueBubble" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ValueBubblePosition, ValueBubbleStyle } from "sap/makit/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The properties of the Chart's Value Bubble.
   *
   * @since 1.8
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export default class ValueBubble extends UI5Element {
    /**
     * Constructor for a new ValueBubble.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ValueBubbleSettings
    );
    /**
     * Constructor for a new ValueBubble.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ValueBubbleSettings
    );

    /**
     * Creates a new subclass of class sap.makit.ValueBubble with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ValueBubble>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.makit.ValueBubble.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position of the Value Bubble (Pie or Donut chart only)
     *
     * Default value is `Top`.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): ValueBubblePosition;
    /**
     * Gets current value of property {@link #getShowCategoryDisplayName showCategoryDisplayName}.
     *
     * Whether to display category's display name on the Value Bubble
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showCategoryDisplayName`
     */
    getShowCategoryDisplayName(): boolean;
    /**
     * Gets current value of property {@link #getShowCategoryText showCategoryText}.
     *
     * Whether to display category's text on the Value Bubble
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showCategoryText`
     */
    getShowCategoryText(): boolean;
    /**
     * Gets current value of property {@link #getShowLegendLabel showLegendLabel}.
     *
     * Whether to display legend's label (Pie or Donut chart only)
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLegendLabel`
     */
    getShowLegendLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowNullValue showNullValue}.
     *
     * Whether to render null item on the Value Bubble
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showNullValue`
     */
    getShowNullValue(): boolean;
    /**
     * Gets current value of property {@link #getShowValueDisplayName showValueDisplayName}.
     *
     * Whether to display value's display name on the Value Bubble
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showValueDisplayName`
     */
    getShowValueDisplayName(): boolean;
    /**
     * Gets current value of property {@link #getShowValueOnPieChart showValueOnPieChart}.
     *
     * Whether to display value on Pie or Donut chart
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showValueOnPieChart`
     */
    getShowValueOnPieChart(): boolean;
    /**
     * Gets current value of property {@link #getStyle style}.
     *
     * Value Bubble positioning style (All the chart types except: Pie/Donut/HBar chart)
     *
     * Default value is `Top`.
     *
     *
     * @returns Value of property `style`
     */
    getStyle(): ValueBubbleStyle;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Whether the Value Bubble is visible
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position of the Value Bubble (Pie or Donut chart only)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Top`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: ValueBubblePosition | keyof typeof ValueBubblePosition
    ): this;
    /**
     * Sets a new value for property {@link #getShowCategoryDisplayName showCategoryDisplayName}.
     *
     * Whether to display category's display name on the Value Bubble
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowCategoryDisplayName(
      /**
       * New value for property `showCategoryDisplayName`
       */
      bShowCategoryDisplayName?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowCategoryText showCategoryText}.
     *
     * Whether to display category's text on the Value Bubble
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowCategoryText(
      /**
       * New value for property `showCategoryText`
       */
      bShowCategoryText?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowLegendLabel showLegendLabel}.
     *
     * Whether to display legend's label (Pie or Donut chart only)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLegendLabel(
      /**
       * New value for property `showLegendLabel`
       */
      bShowLegendLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowNullValue showNullValue}.
     *
     * Whether to render null item on the Value Bubble
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowNullValue(
      /**
       * New value for property `showNullValue`
       */
      bShowNullValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueDisplayName showValueDisplayName}.
     *
     * Whether to display value's display name on the Value Bubble
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueDisplayName(
      /**
       * New value for property `showValueDisplayName`
       */
      bShowValueDisplayName?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueOnPieChart showValueOnPieChart}.
     *
     * Whether to display value on Pie or Donut chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueOnPieChart(
      /**
       * New value for property `showValueOnPieChart`
       */
      bShowValueOnPieChart?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStyle style}.
     *
     * Value Bubble positioning style (All the chart types except: Pie/Donut/HBar chart)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Top`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStyle(
      /**
       * New value for property `style`
       */
      sStyle?: ValueBubbleStyle | keyof typeof ValueBubbleStyle
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Whether the Value Bubble is visible
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ValueBubble constructor.
   *
   * @deprecated As of version 1.38. MAKIT charts have been replaced with sap.viz and vizFrame in 1.38. This
   * control will not be supported anymore from 1.38.
   */
  export interface $ValueBubbleSettings extends $ElementSettings {
    /**
     * Whether to display category's text on the Value Bubble
     */
    showCategoryText?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether to display category's display name on the Value Bubble
     */
    showCategoryDisplayName?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether to display value's display name on the Value Bubble
     */
    showValueDisplayName?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether to display value on Pie or Donut chart
     */
    showValueOnPieChart?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether to display legend's label (Pie or Donut chart only)
     */
    showLegendLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether to render null item on the Value Bubble
     */
    showNullValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The position of the Value Bubble (Pie or Donut chart only)
     */
    position?:
      | (ValueBubblePosition | keyof typeof ValueBubblePosition)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Value Bubble positioning style (All the chart types except: Pie/Donut/HBar chart)
     */
    style?:
      | (ValueBubbleStyle | keyof typeof ValueBubbleStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Whether the Value Bubble is visible
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/makit/Axis": undefined;

    "sap/makit/Category": undefined;

    "sap/makit/CategoryAxis": undefined;

    "sap/makit/Chart": undefined;

    "sap/makit/Column": undefined;

    "sap/makit/CombinationChart": undefined;

    "sap/makit/Layer": undefined;

    "sap/makit/library": undefined;

    "sap/makit/MakitLib": undefined;

    "sap/makit/Row": undefined;

    "sap/makit/Series": undefined;

    "sap/makit/Value": undefined;

    "sap/makit/ValueAxis": undefined;

    "sap/makit/ValueBubble": undefined;
  }
}
