import { AttributeType } from "sax-wasm";
import { ChangeAction } from "../../../utils/textChanges.js";
import { HtmlFix } from "./HtmlFix.js";
/**
 * Fix to rename the identifier of an attribute in an HTML tag.
 * @param attribute The identifier to be renamed.
 * @param newName The new identifier for the attribute.
 */
export default class RenameAttributeFix extends HtmlFix {
    newName;
    startPositionDetail;
    endPositionDetail;
    constructor(attribute, newName) {
        super();
        this.newName = newName;
        this.startPositionDetail = attribute.name.start;
        this.endPositionDetail = attribute.name.end;
        // This if statement is a workaround for edge cases
        // since sax-wasm parses wrong positions for NoValue single-character attributes.
        // TODO: Remove once it's fixed (https://github.com/justinwilaby/sax-wasm/issues/139).
        if (attribute.type === AttributeType.NoValue && attribute.name.value.length === 1) {
            this.endPositionDetail = {
                line: attribute.name.start.line,
                character: attribute.name.start.character + 1,
            };
        }
    }
    calculateSourceCodeRange(toPosition) {
        this.startPos = toPosition(this.startPositionDetail);
        this.endPos = toPosition(this.endPositionDetail);
    }
    generateChanges() {
        if (this.startPos === undefined || this.endPos === undefined) {
            throw new Error("Start and end position are not defined");
        }
        return {
            action: ChangeAction.REPLACE,
            start: this.startPos,
            end: this.endPos,
            value: this.newName,
        };
    }
}
//# sourceMappingURL=RenameAttributeFix.js.map