// This file is generated by the createTypes script.

declare module "sap/m/BackgroundDesign" {
	import {BackgroundDesign} from "sap/m/library";

	/**
	 * Available Background Design.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BackgroundDesign'.
	 *
	 * @public
	*/
	export default BackgroundDesign;
}

declare module "sap/m/BadgeAnimationType" {
	import {BadgeAnimationType} from "sap/m/library";

	/**
	 * Types of animation performed by {@link sap.m.BadgeEnabler}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BadgeAnimationType'.
	 *
	 * @public
	 * @since 1.87
	*/
	export default BadgeAnimationType;
}

declare module "sap/m/BadgeState" {
	import {BadgeState} from "sap/m/library";

	/**
	 * Types of state of {@link sap.m.BadgeEnabler} to expose its current state.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BadgeState'.
	 *
	 * @public
	 * @since 1.81
	*/
	export default BadgeState;
}

declare module "sap/m/BadgeStyle" {
	import {BadgeStyle} from "sap/m/library";

	/**
	 * Types of badge rendering style.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BadgeStyle'.
	 *
	 * @public
	*/
	export default BadgeStyle;
}

declare module "sap/m/BarDesign" {
	import {BarDesign} from "sap/m/library";

	/**
	 * Types of the Bar design.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BarDesign'.
	 *
	 * @public
	 * @since 1.20
	*/
	export default BarDesign;
}

declare module "sap/m/BorderDesign" {
	import {BorderDesign} from "sap/m/library";

	/**
	 * Available Border Design.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BorderDesign'.
	 *
	 * @public
	*/
	export default BorderDesign;
}

declare module "sap/m/BreadcrumbsSeparatorStyle" {
	import {BreadcrumbsSeparatorStyle} from "sap/m/library";

	/**
	 * Variations of the {@link sap.m.Breadcrumbs} separators.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BreadcrumbsSeparatorStyle'.
	 *
	 * @public
	 * @since 1.69
	*/
	export default BreadcrumbsSeparatorStyle;
}

declare module "sap/m/ButtonAccessibleRole" {
	import {ButtonAccessibleRole} from "sap/m/library";

	/**
	 * Enumeration for possible Button accessibility roles.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ButtonAccessibleRole'.
	 *
	 * @public
	 * @since 1.114.0
	*/
	export default ButtonAccessibleRole;
}

declare module "sap/m/ButtonType" {
	import {ButtonType} from "sap/m/library";

	/**
	 * Different predefined button types for the {@link sap.m.Button sap.m.Button}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ButtonType'.
	 *
	 * @public
	*/
	export default ButtonType;
}

declare module "sap/m/CarouselArrowsPlacement" {
	import {CarouselArrowsPlacement} from "sap/m/library";

	/**
	 * Carousel arrows align.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'CarouselArrowsPlacement'.
	 *
	 * @public
	*/
	export default CarouselArrowsPlacement;
}

declare module "sap/m/CarouselPageIndicatorPlacementType" {
	import {CarouselPageIndicatorPlacementType} from "sap/m/library";

	/**
	 * Types for the placement of the page indicator of the Carousel control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'CarouselPageIndicatorPlacementType'.
	 *
	 * @public
	*/
	export default CarouselPageIndicatorPlacementType;
}

declare module "sap/m/CarouselScrollMode" {
	import {CarouselScrollMode} from "sap/m/library";

	/**
	 * Defines how pages will be scrolled, when clicking the arrow.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'CarouselScrollMode'.
	 *
	 * @public
	*/
	export default CarouselScrollMode;
}

declare module "sap/m/ContentConfigType" {
	import {ContentConfigType} from "sap/m/library";

	/**
	 * Defines the rendering type of the TileAttribute
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ContentConfigType'.
	 *
	 * @experimental (since 1.122)
	 * @public
	 * @since 1.122
	*/
	export default ContentConfigType;
}

declare module "sap/m/DateTimeInputType" {
	import {DateTimeInputType} from "sap/m/library";

	/**
	 * A subset of DateTimeInput types that fit to a simple API returning one string.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DateTimeInputType'.
	 *
	 * @deprecated (since 1.32.8) - Instead, use dedicated <code>sap.m.DatePicker</code> and/or <code>sap.m.TimePicker</code> controls.
	 * @public
	*/
	export default DateTimeInputType;
}

declare module "sap/m/DeviationIndicator" {
	import {DeviationIndicator} from "sap/m/library";

	/**
	 * Enum of the available deviation markers for the NumericContent control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DeviationIndicator'.
	 *
	 * @public
	 * @since 1.34
	*/
	export default DeviationIndicator;
}

declare module "sap/m/DialogRoleType" {
	import {DialogRoleType} from "sap/m/library";

	/**
	 * Enum for the ARIA role of {@link sap.m.Dialog} control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DialogRoleType'.
	 *
	 * @public
	 * @since 1.65
	*/
	export default DialogRoleType;
}

declare module "sap/m/DialogType" {
	import {DialogType} from "sap/m/library";

	/**
	 * Enum for the type of {@link sap.m.Dialog} control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DialogType'.
	 *
	 * @public
	*/
	export default DialogType;
}

declare module "sap/m/DraftIndicatorState" {
	import {DraftIndicatorState} from "sap/m/library";

	/**
	 * Enum for the state of {@link sap.m.DraftIndicator} control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DraftIndicatorState'.
	 *
	 * @public
	*/
	export default DraftIndicatorState;
}

declare module "sap/m/DynamicDateRangeGroups" {
	import {DynamicDateRangeGroups} from "sap/m/library";

	/**
	 * Defines the groups in {@link sap.m.DynamicDateRange}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DynamicDateRangeGroups'.
	 *
	 * @public
	 * @since 1.118
	*/
	export default DynamicDateRangeGroups;
}

declare module "sap/m/EmptyIndicatorMode" {
	import {EmptyIndicatorMode} from "sap/m/library";

	/**
	 * Modes in which a control will render empty indicator if its content is empty.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'EmptyIndicatorMode'.
	 *
	 * @public
	 * @since 1.87
	*/
	export default EmptyIndicatorMode;
}

declare module "sap/m/ExpandableTextOverflowMode" {
	import {ExpandableTextOverflowMode} from "sap/m/library";

	/**
	 * Expandable text overflow mode
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ExpandableTextOverflowMode'.
	 *
	 * @public
	*/
	export default ExpandableTextOverflowMode;
}

declare module "sap/m/FacetFilterListDataType" {
	import {FacetFilterListDataType} from "sap/m/library";

	/**
	 * FacetFilterList data types.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FacetFilterListDataType'.
	 *
	 * @public
	*/
	export default FacetFilterListDataType;
}

declare module "sap/m/FacetFilterType" {
	import {FacetFilterType} from "sap/m/library";

	/**
	 * Used by the FacetFilter control to adapt its design according to type.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FacetFilterType'.
	 *
	 * @public
	*/
	export default FacetFilterType;
}

declare module "sap/m/FlexAlignContent" {
	import {FlexAlignContent} from "sap/m/library";

	/**
	 * Available options for the layout of container lines along the cross axis of the flexbox layout.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexAlignContent'.
	 *
	 * @public
	*/
	export default FlexAlignContent;
}

declare module "sap/m/FlexAlignItems" {
	import {FlexAlignItems} from "sap/m/library";

	/**
	 * Available options for the layout of all elements along the cross axis of the flexbox layout.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexAlignItems'.
	 *
	 * @public
	*/
	export default FlexAlignItems;
}

declare module "sap/m/FlexAlignSelf" {
	import {FlexAlignSelf} from "sap/m/library";

	/**
	 * Available options for the layout of individual elements along the cross axis of the flexbox layout overriding the default alignment.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexAlignSelf'.
	 *
	 * @public
	*/
	export default FlexAlignSelf;
}

declare module "sap/m/FlexDirection" {
	import {FlexDirection} from "sap/m/library";

	/**
	 * Available directions for flex layouts.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexDirection'.
	 *
	 * @public
	*/
	export default FlexDirection;
}

declare module "sap/m/FlexJustifyContent" {
	import {FlexJustifyContent} from "sap/m/library";

	/**
	 * Available options for the layout of elements along the main axis of the flexbox layout.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexJustifyContent'.
	 *
	 * @public
	*/
	export default FlexJustifyContent;
}

declare module "sap/m/FlexRendertype" {
	import {FlexRendertype} from "sap/m/library";

	/**
	 * Determines the type of HTML elements used for rendering controls.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexRendertype'.
	 *
	 * @public
	*/
	export default FlexRendertype;
}

declare module "sap/m/FlexWrap" {
	import {FlexWrap} from "sap/m/library";

	/**
	 * Available options for the wrapping behavior of a flex container.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexWrap'.
	 *
	 * @public
	*/
	export default FlexWrap;
}

declare module "sap/m/FrameType" {
	import {FrameType} from "sap/m/library";

	/**
	 * Enum for possible frame size types for sap.m.TileContent and sap.m.GenericTile control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FrameType'.
	 *
	 * @public
	 * @since 1.34.0
	*/
	export default FrameType;
}

declare module "sap/m/GenericTagDesign" {
	import {GenericTagDesign} from "sap/m/library";

	/**
	 * Design modes for the <code>GenericTag</code> control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTagDesign'.
	 *
	 * @public
	 * @since 1.62.0
	*/
	export default GenericTagDesign;
}

declare module "sap/m/GenericTagValueState" {
	import {GenericTagValueState} from "sap/m/library";

	/**
	 * Value states for the <code>GenericTag</code> control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTagValueState'.
	 *
	 * @public
	 * @since 1.62.0
	*/
	export default GenericTagValueState;
}

declare module "sap/m/GenericTileMode" {
	import {GenericTileMode} from "sap/m/library";

	/**
	 * Defines the mode of GenericTile.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTileMode'.
	 *
	 * @public
	 * @since 1.38.0
	*/
	export default GenericTileMode;
}

declare module "sap/m/GenericTileScope" {
	import {GenericTileScope} from "sap/m/library";

	/**
	 * Defines the scopes of GenericTile enabling the developer to implement different "flavors" of tiles.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTileScope'.
	 *
	 * @public
	 * @since 1.46.0
	*/
	export default GenericTileScope;
}

declare module "sap/m/HeaderLevel" {
	import {HeaderLevel} from "sap/m/library";

	/**
	 * Different levels for headers.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'HeaderLevel'.
	 *
	 * @public
	*/
	export default HeaderLevel;
}

declare module "sap/m/IBarHTMLTag" {
	import {IBarHTMLTag} from "sap/m/library";

	/**
	 * Allowed tags for the implementation of the IBar interface.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IBarHTMLTag'.
	 *
	 * @public
	 * @since 1.22
	*/
	export default IBarHTMLTag;
}

declare module "sap/m/IconTabDensityMode" {
	import {IconTabDensityMode} from "sap/m/library";

	/**
	 * Specifies <code>IconTabBar</code> tab density mode.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabDensityMode'.
	 *
	 * @public
	*/
	export default IconTabDensityMode;
}

declare module "sap/m/IconTabFilterDesign" {
	import {IconTabFilterDesign} from "sap/m/library";

	/**
	 * Available Filter Item Design.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabFilterDesign'.
	 *
	 * @public
	*/
	export default IconTabFilterDesign;
}

declare module "sap/m/IconTabFilterInteractionMode" {
	import {IconTabFilterInteractionMode} from "sap/m/library";

	/**
	 * Available Interaction Modes.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabFilterInteractionMode'.
	 *
	 * @experimental (since 1.121) - Behavior might change.
	 * @public
	*/
	export default IconTabFilterInteractionMode;
}

declare module "sap/m/IconTabHeaderMode" {
	import {IconTabHeaderMode} from "sap/m/library";

	/**
	 * Specifies <code>IconTabBar</code> header mode.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabHeaderMode'.
	 *
	 * @public
	*/
	export default IconTabHeaderMode;
}

declare module "sap/m/ImageMode" {
	import {ImageMode} from "sap/m/library";

	/**
	 * Determines how the source image is used on the output DOM element.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ImageMode'.
	 *
	 * @public
	 * @since 1.30.0
	*/
	export default ImageMode;
}

declare module "sap/m/InputListItemContentSize" {
	import {InputListItemContentSize} from "sap/m/library";

	/**
	 * Defines the available content sizes for the <code>InputListItem</code> control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'InputListItemContentSize'.
	 *
	 * @public
	*/
	export default InputListItemContentSize;
}

declare module "sap/m/InputTextFormatMode" {
	import {InputTextFormatMode} from "sap/m/library";

	/**
	 * Defines how the input display text should be formatted.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'InputTextFormatMode'.
	 *
	 * @public
	 * @since 1.44.0
	*/
	export default InputTextFormatMode;
}

declare module "sap/m/InputType" {
	import {InputType} from "sap/m/library";

	/**
	 * A subset of input types that fits to a simple API returning one string.
	 * 
	 * Not available on purpose: button, checkbox, hidden, image, password, radio, range, reset, search, submit.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'InputType'.
	 *
	 * @public
	*/
	export default InputType;
}

declare module "sap/m/LabelDesign" {
	import {LabelDesign} from "sap/m/library";

	/**
	 * Available label display modes.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LabelDesign'.
	 *
	 * @public
	*/
	export default LabelDesign;
}

declare module "sap/m/LightBoxLoadingStates" {
	import {LightBoxLoadingStates} from "sap/m/library";

	/**
	 * Types of LightBox loading stages.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LightBoxLoadingStates'.
	 *
	 * @public
	 * @since 1.40
	*/
	export default LightBoxLoadingStates;
}

declare module "sap/m/LinkAccessibleRole" {
	import {LinkAccessibleRole} from "sap/m/library";

	/**
	 * Enumeration for possible Link accessibility roles.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LinkAccessibleRole'.
	 *
	 * @public
	 * @since 1.104.0
	*/
	export default LinkAccessibleRole;
}

declare module "sap/m/LinkConversion" {
	import {LinkConversion} from "sap/m/library";

	/**
	 * Enumeration for possible link-to-anchor conversion strategy.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LinkConversion'.
	 *
	 * @public
	 * @since 1.45.5
	*/
	export default LinkConversion;
}

declare module "sap/m/ListGrowingDirection" {
	import {ListGrowingDirection} from "sap/m/library";

	/**
	 * Defines the growing direction of the <code>sap.m.List</code> or <code>sap.m.Table</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListGrowingDirection'.
	 *
	 * @public
	 * @since 1.40.0
	*/
	export default ListGrowingDirection;
}

declare module "sap/m/ListHeaderDesign" {
	import {ListHeaderDesign} from "sap/m/library";

	/**
	 * Defines the different header styles.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListHeaderDesign'.
	 *
	 * @deprecated (since 1.16) - Has no functionality since 1.16.
	 * @public
	*/
	export default ListHeaderDesign;
}

declare module "sap/m/ListKeyboardMode" {
	import {ListKeyboardMode} from "sap/m/library";

	/**
	 * Defines the keyboard handling behavior of the <code>sap.m.List</code> or <code>sap.m.Table</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListKeyboardMode'.
	 *
	 * @public
	 * @since 1.38.0
	*/
	export default ListKeyboardMode;
}

declare module "sap/m/ListMode" {
	import {ListMode} from "sap/m/library";

	/**
	 * Defines the mode of the list.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListMode'.
	 *
	 * @public
	*/
	export default ListMode;
}

declare module "sap/m/ListSeparators" {
	import {ListSeparators} from "sap/m/library";

	/**
	 * Defines which separator style will be applied for the items.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListSeparators'.
	 *
	 * @public
	*/
	export default ListSeparators;
}

declare module "sap/m/ListType" {
	import {ListType} from "sap/m/library";

	/**
	 * Defines the visual indication and behaviour of the list items.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListType'.
	 *
	 * @public
	*/
	export default ListType;
}

declare module "sap/m/LoadState" {
	import {LoadState} from "sap/m/library";

	/**
	 * Enumeration of possible load statuses.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LoadState'.
	 *
	 * @public
	 * @since 1.34.0
	*/
	export default LoadState;
}

declare module "sap/m/MenuButtonMode" {
	import {MenuButtonMode} from "sap/m/library";

	/**
	 * Different modes for a MenuButton (predefined types).
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'MenuButtonMode'.
	 *
	 * @public
	 * @since 1.38.0
	*/
	export default MenuButtonMode;
}

declare module "sap/m/MultiSelectMode" {
	import {MultiSelectMode} from "sap/m/library";

	/**
	 * Enumeration of the <code>multiSelectMode>/code> in <code>ListBase</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'MultiSelectMode'.
	 *
	 * @public
	 * @since 1.93
	*/
	export default MultiSelectMode;
}

declare module "sap/m/ObjectHeaderPictureShape" {
	import {ObjectHeaderPictureShape} from "sap/m/library";

	/**
	 * Used by the <code>ObjectHeader</code> control to define which shape to use for the image.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ObjectHeaderPictureShape'.
	 *
	 * @public
	 * @since 1.61
	*/
	export default ObjectHeaderPictureShape;
}

declare module "sap/m/ObjectMarkerType" {
	import {ObjectMarkerType} from "sap/m/library";

	/**
	 * Predefined types for ObjectMarker.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ObjectMarkerType'.
	 *
	 * @public
	*/
	export default ObjectMarkerType;
}

declare module "sap/m/ObjectMarkerVisibility" {
	import {ObjectMarkerVisibility} from "sap/m/library";

	/**
	 * Predefined visibility for ObjectMarker.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ObjectMarkerVisibility'.
	 *
	 * @public
	*/
	export default ObjectMarkerVisibility;
}

declare module "sap/m/OverflowToolbarPriority" {
	import {OverflowToolbarPriority} from "sap/m/library";

	/**
	 * Defines the priorities of the controls within {@link sap.m.OverflowToolbar}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'OverflowToolbarPriority'.
	 *
	 * @public
	 * @since 1.32
	*/
	export default OverflowToolbarPriority;
}

declare module "sap/m/P13nConditionOperation" {
	import {P13nConditionOperation} from "sap/m/library";

	/**
	 * undefined
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'P13nConditionOperation'.
	 *
	 * @public
	*/
	export default P13nConditionOperation;
}

declare module "sap/m/P13nPanelType" {
	import {P13nPanelType} from "sap/m/library";

	/**
	 * Type of panels used in the personalization dialog.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'P13nPanelType'.
	 *
	 * @public
	*/
	export default P13nPanelType;
}

declare module "sap/m/P13nPopupMode" {
	import {P13nPopupMode} from "sap/m/library";

	/**
	 * Type of popup used in the <code>sap.m.p13n.Popup</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'P13nPopupMode'.
	 *
	 * @public
	*/
	export default P13nPopupMode;
}

declare module "sap/m/PageBackgroundDesign" {
	import {PageBackgroundDesign} from "sap/m/library";

	/**
	 * Available Page Background Design.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PageBackgroundDesign'.
	 *
	 * @public
	*/
	export default PageBackgroundDesign;
}

declare module "sap/m/PanelAccessibleRole" {
	import {PanelAccessibleRole} from "sap/m/library";

	/**
	 * Available Panel Accessible Landmark Roles.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PanelAccessibleRole'.
	 *
	 * @public
	*/
	export default PanelAccessibleRole;
}

declare module "sap/m/PDFViewerDisplayType" {
	import {PDFViewerDisplayType} from "sap/m/library";

	/**
	 * PDF viewer display types.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PDFViewerDisplayType'.
	 *
	 * @public
	*/
	export default PDFViewerDisplayType;
}

declare module "sap/m/PlacementType" {
	import {PlacementType} from "sap/m/library";

	/**
	 * Types for the placement of Popover control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PlacementType'.
	 *
	 * @public
	*/
	export default PlacementType;
}

declare module "sap/m/PlanningCalendarBuiltInView" {
	import {PlanningCalendarBuiltInView} from "sap/m/library";

	/**
	 * A list of the default built-in views in a {@link sap.m.PlanningCalendar}, described by their keys.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PlanningCalendarBuiltInView'.
	 *
	 * @public
	 * @since 1.50
	*/
	export default PlanningCalendarBuiltInView;
}

declare module "sap/m/PlanningCalendarStickyMode" {
	import {PlanningCalendarStickyMode} from "sap/m/library";

	/**
	 * Available sticky modes for the {@link sap.m.SinglePlanningCalendar}
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PlanningCalendarStickyMode'.
	 *
	 * @public
	 * @since 1.62
	*/
	export default PlanningCalendarStickyMode;
}

declare module "sap/m/plugins/ContextMenuScope" {
	import {plugins} from "sap/m/library";

	/**
	 * Defines the states of list items when the context menu is opened.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'plugins.ContextMenuScope'.
	 *
	 * @public
	 * @since 1.121
	*/
	export default plugins.ContextMenuScope;
}

declare module "sap/m/plugins/CopyPreference" {
	import {plugins} from "sap/m/library";

	/**
	 * Enumeration of the <code>copyPreference</code> in <code>CopyProvider</code>. Determines what is copied during a copy operation.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'plugins.CopyPreference'.
	 *
	 * @public
	 * @since 1.119
	*/
	export default plugins.CopyPreference;
}

declare module "sap/m/PopinDisplay" {
	import {PopinDisplay} from "sap/m/library";

	/**
	 * Defines the display of table pop-ins.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PopinDisplay'.
	 *
	 * @public
	 * @since 1.13.2
	*/
	export default PopinDisplay;
}

declare module "sap/m/PopinLayout" {
	import {PopinLayout} from "sap/m/library";

	/**
	 * Defines the layout options of the table popins.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PopinLayout'.
	 *
	 * @public
	 * @since 1.52
	*/
	export default PopinLayout;
}

declare module "sap/m/Priority" {
	import {Priority} from "sap/m/library";

	/**
	 * Defines the priority for the TileContent in ActionMode
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'Priority'.
	 *
	 * @public
	*/
	export default Priority;
}

declare module "sap/m/QuickViewGroupElementType" {
	import {QuickViewGroupElementType} from "sap/m/library";

	/**
	 * QuickViewGroupElement is a combination of one label and another control (Link or Text) associated to this label.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'QuickViewGroupElementType'.
	 *
	 * @public
	*/
	export default QuickViewGroupElementType;
}

declare module "sap/m/RatingIndicatorVisualMode" {
	import {RatingIndicatorVisualMode} from "sap/m/library";

	/**
	 * Possible values for the visualization of float values in the RatingIndicator control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'RatingIndicatorVisualMode'.
	 *
	 * @public
	*/
	export default RatingIndicatorVisualMode;
}

declare module "sap/m/ReactiveAreaMode" {
	import {ReactiveAreaMode} from "sap/m/library";

	/**
	 * Reactive area modes of interactable elements.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ReactiveAreaMode'.
	 *
	 * @public
	*/
	export default ReactiveAreaMode;
}

declare module "sap/m/ResetAllMode" {
	import {ResetAllMode} from "sap/m/library";

	/**
	 * Enumeration of the <code>ResetAllMode</code> that can be used in a <code>TablePersoController</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ResetAllMode'.
	 *
	 * @public
	*/
	export default ResetAllMode;
}

declare module "sap/m/ScreenSize" {
	import {ScreenSize} from "sap/m/library";

	/**
	 * Breakpoint names for different screen sizes.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ScreenSize'.
	 *
	 * @public
	*/
	export default ScreenSize;
}

declare module "sap/m/SelectColumnRatio" {
	import {SelectColumnRatio} from "sap/m/library";

	/**
	 * A string type that represents column ratio.
	 * 
	 * Allowed values are strings that follow the number:number (3:2) format.
	 *
	 * @public
	 * @since 1.86
	*/
	export default SelectColumnRatio;
}

declare module "sap/m/SelectDialogInitialFocus" {
	import {SelectDialogInitialFocus} from "sap/m/library";

	/**
	 * Defines the control that will receive the initial focus in the <code>sap.m.SelectDialog</code> or <code>sap.m.TableSelectDialog</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectDialogInitialFocus'.
	 *
	 * @public
	 * @since 1.117.0
	*/
	export default SelectDialogInitialFocus;
}

declare module "sap/m/SelectionDetailsActionLevel" {
	import {SelectionDetailsActionLevel} from "sap/m/library";

	/**
	 * Enumeration for different action levels in sap.m.SelectionDetails control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectionDetailsActionLevel'.
	 *
	 * @protected
	 * @since 1.48
	*/
	export default SelectionDetailsActionLevel;
}

declare module "sap/m/SelectListKeyboardNavigationMode" {
	import {SelectListKeyboardNavigationMode} from "sap/m/library";

	/**
	 * Defines the keyboard navigation mode.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectListKeyboardNavigationMode'.
	 *
	 * @public
	 * @since 1.38
	*/
	export default SelectListKeyboardNavigationMode;
}

declare module "sap/m/SelectType" {
	import {SelectType} from "sap/m/library";

	/**
	 * Enumeration for different Select types.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectType'.
	 *
	 * @public
	 * @since 1.16
	*/
	export default SelectType;
}

declare module "sap/m/semantic/SemanticRuleSetType" {
	import {semantic} from "sap/m/library";

	/**
	 * Declares the type of semantic ruleset that will govern the styling and positioning of semantic content.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'semantic.SemanticRuleSetType'.
	 *
	 * @public
	 * @since 1.44
	*/
	export default semantic.SemanticRuleSetType;
}

declare module "sap/m/SharingMode" {
	import {SharingMode} from "sap/m/library";

	/**
	 * Enumeration of the <code>SharingMode</code> that can be used in a <code>VariantItem</code>.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SharingMode'.
	 *
	 * @public
	*/
	export default SharingMode;
}

declare module "sap/m/SinglePlanningCalendarSelectionMode" {
	import {SinglePlanningCalendarSelectionMode} from "sap/m/library";

	/**
	 * Available selection modes for the {@link sap.m.SinglePlanningCalendar}
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SinglePlanningCalendarSelectionMode'.
	 *
	 * @public
	 * @since 1.113
	*/
	export default SinglePlanningCalendarSelectionMode;
}

declare module "sap/m/Size" {
	import {Size} from "sap/m/library";

	/**
	 * Enumeration of possible size settings.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'Size'.
	 *
	 * @public
	 * @since 1.34.0
	*/
	export default Size;
}

declare module "sap/m/SplitAppMode" {
	import {SplitAppMode} from "sap/m/library";

	/**
	 * The mode of SplitContainer or SplitApp control to show/hide the master area.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SplitAppMode'.
	 *
	 * @public
	*/
	export default SplitAppMode;
}

declare module "sap/m/StandardDynamicDateRangeKeys" {
	import {StandardDynamicDateRangeKeys} from "sap/m/library";

	/**
	 * The option keys of all the standard options of a DynamicDateRange control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StandardDynamicDateRangeKeys'.
	 *
	 * @public
	*/
	export default StandardDynamicDateRangeKeys;
}

declare module "sap/m/StandardTileType" {
	import {StandardTileType} from "sap/m/library";

	/**
	 * Types for StandardTile.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StandardTileType'.
	 *
	 * @public
	*/
	export default StandardTileType;
}

declare module "sap/m/StepInputStepModeType" {
	import {StepInputStepModeType} from "sap/m/library";

	/**
	 * Available step modes for {@link sap.m.StepInput}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StepInputStepModeType'.
	 *
	 * @public
	 * @since 1.54
	*/
	export default StepInputStepModeType;
}

declare module "sap/m/StepInputValidationMode" {
	import {StepInputValidationMode} from "sap/m/library";

	/**
	 * Available validation modes for {@link sap.m.StepInput}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StepInputValidationMode'.
	 *
	 * @public
	*/
	export default StepInputValidationMode;
}

declare module "sap/m/Sticky" {
	import {Sticky} from "sap/m/library";

	/**
	 * Defines which area of the control remains fixed at the top of the page during vertical scrolling as long as the control is in the viewport.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'Sticky'.
	 *
	 * @public
	 * @since 1.54
	*/
	export default Sticky;
}

declare module "sap/m/StringFilterOperator" {
	import {StringFilterOperator} from "sap/m/library";

	/**
	 * Types of string filter operators.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StringFilterOperator'.
	 *
	 * @public
	 * @since 1.42
	*/
	export default StringFilterOperator;
}

declare module "sap/m/SwipeDirection" {
	import {SwipeDirection} from "sap/m/library";

	/**
	 * Directions for swipe event.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SwipeDirection'.
	 *
	 * @public
	*/
	export default SwipeDirection;
}

declare module "sap/m/SwitchType" {
	import {SwitchType} from "sap/m/library";

	/**
	 * Enumeration for different switch types.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SwitchType'.
	 *
	 * @public
	*/
	export default SwitchType;
}

declare module "sap/m/table/columnmenu/Category" {
	import {table} from "sap/m/library";

	/**
	 * Categories of column menu entries.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'table.columnmenu.Category'.
	 *
	 * @public
	 * @since 1.110
	*/
	export default table.columnmenu.Category;
}

declare module "sap/m/table/columnmenu/QuickActionContentSize" {
	import {table} from "sap/m/library";

	/**
	 * Defines the available content sizes for the <code>sap.m.table.columnmenu.QuickAction</code> control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'table.columnmenu.QuickActionContentSize'.
	 *
	 * @public
	*/
	export default table.columnmenu.QuickActionContentSize;
}

declare module "sap/m/TabsOverflowMode" {
	import {TabsOverflowMode} from "sap/m/library";

	/**
	 * Specifies <code>IconTabBar</code> tab overflow mode.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TabsOverflowMode'.
	 *
	 * @public
	 * @since 1.90.0
	*/
	export default TabsOverflowMode;
}

declare module "sap/m/TileInfoColor" {
	import {TileInfoColor} from "sap/m/library";

	/**
	 * Colors to highlight certain UI elements.
	 * 
	 * In contrast to the <code>ValueState</code>, the semantic meaning must be defined by the application.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TileInfoColor'.
	 *
	 * @public
	 * @since 1.124
	*/
	export default TileInfoColor;
}

declare module "sap/m/TileSizeBehavior" {
	import {TileSizeBehavior} from "sap/m/library";

	/**
	 * Describes the behavior of tiles when displayed on a small-screened phone (374px wide and lower).
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TileSizeBehavior'.
	 *
	 * @public
	 * @since 1.56.0
	*/
	export default TileSizeBehavior;
}

declare module "sap/m/TimePickerMaskMode" {
	import {TimePickerMaskMode} from "sap/m/library";

	/**
	 * Different modes for the <code>sap.m.TimePicker</code> mask.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TimePickerMaskMode'.
	 *
	 * @public
	 * @since 1.54
	*/
	export default TimePickerMaskMode;
}

declare module "sap/m/TitleAlignment" {
	import {TitleAlignment} from "sap/m/library";

	/**
	 * Declares the type of title alignment for some controls
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TitleAlignment'.
	 *
	 * @public
	*/
	export default TitleAlignment;
}

declare module "sap/m/TokenizerRenderMode" {
	import {TokenizerRenderMode} from "sap/m/library";

	/**
	 * Types of the <code>sap.m.Tokenizer</code> responsive modes.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TokenizerRenderMode'.
	 *
	 * @public
	 * @since 1.80
	*/
	export default TokenizerRenderMode;
}

declare module "sap/m/ToolbarDesign" {
	import {ToolbarDesign} from "sap/m/library";

	/**
	 * Types of the Toolbar Design.
	 * 
	 * To preview the different combinations of <code>sap.m.ToolbarDesign</code> and <code>sap.m.ToolbarStyle</code>, see the <b>OverflowToolbar - Design and styling</b> sample of the {@link sap.m.OverflowToolbar} control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ToolbarDesign'.
	 *
	 * @public
	 * @since 1.16.8
	*/
	export default ToolbarDesign;
}

declare module "sap/m/ToolbarStyle" {
	import {ToolbarStyle} from "sap/m/library";

	/**
	 * Types of visual styles for the {@link sap.m.Toolbar}.
	 * 
	 * <b>Note:</b> Keep in mind that the styles are theme-dependent and can differ based on the currently used theme.
	 * 
	 * To preview the different combinations of <code>sap.m.ToolbarDesign</code> and <code>sap.m.ToolbarStyle</code>, see the <b>OverflowToolbar - Design and styling</b> sample of the {@link sap.m.OverflowToolbar} control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ToolbarStyle'.
	 *
	 * @public
	 * @since 1.54
	*/
	export default ToolbarStyle;
}

declare module "sap/m/UploadSetwithTableActionPlaceHolder" {
	import {UploadSetwithTableActionPlaceHolder} from "sap/m/library";

	/**
	 * Defines the placeholder type for the control to be replaced.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'UploadSetwithTableActionPlaceHolder'.
	 *
	 * @public
	 * @since 1.120
	*/
	export default UploadSetwithTableActionPlaceHolder;
}

declare module "sap/m/UploadState" {
	import {UploadState} from "sap/m/library";

	/**
	 * States of the upload process of {@link sap.m.UploadCollectionItem}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'UploadState'.
	 *
	 * @public
	*/
	export default UploadState;
}

declare module "sap/m/UploadType" {
	import {UploadType} from "sap/m/library";

	/**
	 * Type of the upload {@link sap.m.UploadSetItem}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'UploadType'.
	 *
	 * @public
	*/
	export default UploadType;
}

declare module "sap/m/ValueColor" {
	import {ValueColor} from "sap/m/library";

	/**
	 * Enumeration of possible value color settings.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ValueColor'.
	 *
	 * @public
	*/
	export default ValueColor;
}

declare module "sap/m/ValueCSSColor" {
	import {ValueCSSColor} from "sap/m/library";

	/**
	 * A string type that represents CSS color values, sap.m.ValueColor or less parameter values.
	 * 
	 * Allowed values are {@link sap.ui.core.CSSColor}, {@link sap.m.ValueColor} or a less parameter name (string). In case the less parameter color cannot be determined, the validation fails. You need to check if less parameters are supported on control level. An empty string is also allowed and has the same effect as setting no color.
	 *
	 * @deprecated (since 1.135) - the concept has been discarded.
	 * @public
	*/
	export default ValueCSSColor;
}

declare module "sap/m/VerticalPlacementType" {
	import {VerticalPlacementType} from "sap/m/library";

	/**
	 * Types for the placement of message Popover control.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'VerticalPlacementType'.
	 *
	 * @public
	*/
	export default VerticalPlacementType;
}

declare module "sap/m/WizardRenderMode" {
	import {WizardRenderMode} from "sap/m/library";

	/**
	 * Wizard rendering mode.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'WizardRenderMode'.
	 *
	 * @public
	 * @since 1.83
	*/
	export default WizardRenderMode;
}

declare module "sap/m/WrappingType" {
	import {WrappingType} from "sap/m/library";

	/**
	 * Available wrapping types for text controls that can be wrapped that enable you to display the text as hyphenated.
	 * 
	 * For more information about text hyphenation, see {@link sap.ui.core.hyphenation.Hyphenation} and {@link topic:6322164936f047de941ec522b95d7b70 Text Controls Hyphenation}.
	 * 
	 * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'WrappingType'.
	 *
	 * @public
	 * @since 1.60
	*/
	export default WrappingType;
}
