// For Library Version: 1.136.6

declare module "sap/suite/ui/generic/template/library" {
  /**
   * A static enumeration type which indicates the mode of targeted page while using navigateInternal extensionAPI
   *
   * This enum is part of the 'sap/suite/ui/generic/template/library' module export and must be accessed by
   * the property 'displayMode'.
   */
  export enum displayMode {
    /**
     * Navigating in create mode
     */
    create = "create",
    /**
     * Navigating in read-only mode
     */
    display = "display",
    /**
     * Navigating in draft mode
     */
    edit = "edit",
    /**
     * Navigating with a mode which is not yet decided (fallback condition)
     */
    undefined = "undefined",
  }
}

declare module "sap/suite/ui/generic/template/AnalyticalListPage/controllerFrameworkExtensions" {
  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import Filter from "sap/ui/export/util/Filter";

  import Event from "sap/ui/base/Event";

  import Filter1 from "sap/ui/model/Filter";

  import Sorter from "sap/ui/model/Sorter";

  import Context from "sap/ui/model/Context";

  /**
   * This class contains all extension functions that can be implemented by Application developers in their
   * extension code. Application developers should not override any methods outside this documentation
   */
  interface controllerFrameworkExtensions {
    /**
     * This method is called by SAP Fiori elements before triggering an external navigation. Application developers
     * can override this method and programmatically adapt the parameters which are passed to the target application.
     * Application developers can use the oObjectInfo parameter to identify the navigation context and modify
     * the oSelectionVariant which contains the navigation parameters.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptNavigationParameterExtension(
      /**
       * Selection variant object containing the information which needs to be passed to the target application
       */
      oSelectionVariant: SelectionVariant,
      /**
       * Context object based on which the intent based navigation is triggered
       */
      oObjectInfo: {
        /**
         * Semantic object used for the intend based navigation
         */
        semanticObject: string;
        /**
         * Action on the context for which the navigation is triggered
         */
        action: string;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements whenever the busy state is switched off. Application developers
     * can override this method, access the message model and adapt the transient messages related to the component.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptTransientMessageExtension(): void;
    /**
     * This method is called by SAP Fiori elements when a smart link in a table is clicked. Application developers
     * can override this method and invoke the oParams.getSourceInfo method to find out the information about
     * the clicked smart link.
     *
     * If the application expect the framework should not handle the `beforePopoverOpens` event, then this method
     * should return true. Otherwise, framework will proceed with its handling.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Method should return `true` if framework should not handle `beforePopoverOpens` event (that
     * means: extension code will handle the event)
     */
    beforeSmartLinkPopoverOpensExtension(
      /**
       * Object containing the "getSourceInfo" method and the selection variant
       */
      oParams: {
        /**
         * Selection variant object containing the information which needs to be passed to the target application
         */
        oSelectionVariant: SelectionVariant;
        /**
         * Returns an object contains information about the smart link
         */
        getSourceInfo?: Function;
      }
    ): boolean;
    /**
     * This method is called by SAP Fiori elements before persisting the AppState. Application developers can
     * override this method for persisting the state of custom controls. State of the custom control (controls)
     * should be stored in the oCustomData passed as a parameter to this method. To make a complete functionality,
     * this method should be overridden with `restoreCustomAppStateDataExtension`.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getCustomAppStateDataExtension(
      /**
       * Object to be enriched with the custom control state
       */
      oCustomData: object
    ): void;
    /**
     * This method is called in the AppState creation lifecycle. Application developers can override this method,
     * return an array of all selection fields set on SmartFilterBar using custom code as default and doesn't
     * really want to store as part of the AppState. SAP Fiori elements framework will remove these filter properties
     * from the selection variant.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - Properties which are visible and should not be stored as part of the selection variant in
     * the AppState
     */
    getVisibleSelectionsWithDefaults(): any[];
    /**
     * This method is called by SAP Fiori elements in the startup life cycle of a component. Application developers
     * can override this method and modify the startup object. For an example, when the application is started,
     * the selection variant might contain some properties that are not required for this app. Such properties
     * can be removed from the selection variant. The reverse use case is also true, where some additional properties
     * needs to be added with certain fixed values. This can be achieved by adding these values to the selection
     * variant.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    modifyStartupExtension(
      /**
       * Startup Object containing the initial contexts
       */
      oStartupObject: {
        /**
         * Selection Variant containing the values which needs to be applied to the smart filter bar
         */
        selectionVariant: SelectionVariant;
        /**
         * Semantic dates configuration in the manifest is read an assigned in this object
         */
        semanticDates: object;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements when the table data is getting exported. Application developers
     * can override this method to add/remove the filters in the exported file.
     *
     * To add new filter entries to the exported file, create an instance of {@link sap.ui.export.util.Filter }
     * and add it to "oExportParams.filterSettings"
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeExportTableExtension(
      /**
       * Object containing the table export info
       */
      oExportParams: {
        /**
         * The filters in the exported file Note: Please make changes on "oExportParams.filterSettings" array only
         * when "Include filter settings" is selected. Otherwise, the changes will be ignored.
         */
        filterSettings: Filter[];
        /**
         * The value of "Include filter settings" checkbox
         */
        includeFilterSettings: boolean;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a chart. Application developers can override
     * this method and programmatically modify parameters or filters before chart triggers a query to retrieve
     * data.
     *
     * **Note: **This method is called only when a chart is rebound, and not when it is refreshed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindChartExtension(
      /**
       * The {@link sap.ui.comp.smartchart.SmartChart.prototype.event:beforeRebindChart beforeRebindChart} event
       */
      oEvent: Event
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a filterable KPI. Application developers can
     * override this method to modify parameters or filters for a filterable KPI.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindFilterableKPIExtension(
      /**
       * The SelectionVariant.
       */
      oSelectionVariant: SelectionVariant,
      /**
       * The filterable KPI's entity type.
       */
      sEntityType: string,
      /**
       * The filterable KPI's Id.
       */
      sKPIId: string
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a table. Application developers can override
     * this method and programmatically modify parameters or filters before the table triggers a query to retrieve
     * data.
     *
     * **Note: **This method is called only when a table is rebound, and not when it is refreshed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindTableExtension(
      /**
       * The {@link sap.ui.comp.smarttable.SmartTable.prototype.event:beforeRebindTable beforeRebindTable} event
       */
      oEvent: Event
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a visual filter. Application developers can
     * override this method and programmatically modify parameters, filters, or influence sorting before the
     * chart triggers a query to retrieve data. Application developers can also access incoming navigation contexts
     * of the app through `getNavigationContext` API.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindVisualFilterExtension(
      /**
       * The visual filter entity type.
       */
      sEntityType: string,
      /**
       * The visual filter dimension.
       */
      sDimension: string,
      /**
       * The visual filter measure.
       */
      sMeasure: string,
      /**
       * The context to modify for the custom filter/parameter, query parameter or sort order.
       */
      oContext: {
        /**
         * The object can be modified for the entity set parameters to be applied to the visual filter call.
         */
        entityParameters: object;
        /**
         * The object can be modified for the custom query parameters to be applied to the visual filter call.
         */
        queryParameter: object;
        /**
         * The combined filter array can be modified by users to influence the filters applied to the visual filter
         * call.
         */
        filters: Filter1[];
        /**
         * The combined sorter array can be modified by users to influence the sorting order of the visual filter.
         */
        sorters: Sorter[];
      }
    ): void;
    /**
     * This method should be implemented whenever application uses onListNavigationExtension for internal navigation.
     * In this case the implementation of this method should provide an 'inverse' mapping to the transformation
     * implemented within onListNavigationExtension. More precisely, the identification of a child page instance
     * is passed to this function. The implementation of this function should provide information about the
     * list item which has triggered the opening of the child page.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onChildOpenedExtension(
      /**
       * Information about the child page instance opened last
       */
      oSelectionInfo: {
        /**
         * The entity set identifying the child page which was opened last. Note: In case the child page has been
         * defined without reference to OData this will be the routeName taken from the routingSpec.
         */
        pageEntitySet?: string;
        /**
         * The context path that was used for the last opened child page
         */
        path?: string;
        /**
         * The array of keys (one on each hiearchy level) used for the last opened child page
         */
        keys?: string[];
      },
      /**
       * pass the binding path of the corresponding list item to this function if it is not identical to `oSelectionInfo.path`
       */
      fnSetPath: Function
    ): void;
    /**
     * This method is called by SAP Fiori elements when the Clear button on the filter dialog is clicked. Application
     * developers can override this method to clear custom filters.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onClearFilterExtension(
      /**
       * The press event fired when the Clear button is pressed
       */
      oEvent: Event
    ): void;
    /**
     * This method is called by Fiori elements on the initialization of View. Application developers can override
     * this method & perform internal setup in this hook.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onInit(): void;
    /**
     * This method is called by SAP Fiori elements once the smart filter bar is initialized with a variant.
     * Application developers can override this method when there is a custom filter field bound outside the
     * standard model.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onInitSmartFilterBarExtension(
      /**
       * The {@link sap.ui.comp.filterbar.FilterBar.prototype.event:initialise initialise} event
       */
      oEvent: Event
    ): void;
    /**
     * This method is called when the user leaves the app and this page has been displayed within the same app
     * session (this is the time since last opening the app) at least once. Moreover, it is called for all pages
     * that have been displayed within some app session when the app is finally destroyed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - Only relevant in case that `isDestroyed` is false. In this case Application developers can
     * provide a function to be called when the same page is opened again (after the user has navigated back
     * to the app).
     */
    onLeaveAppExtension(
      /**
       * If this parameter is true this app instance is destroyed. Otherwise it might be rewoken if the user navigates
       * again to this app within the same FLP session
       */
      bIsDestroyed: boolean
    ): Function;
    /**
     * This method is called by SAP Fiori elements when a chevron navigation is triggered from a table. Application
     * developers can override this method and perform conditional (internal or external) navigation from different
     * rows of a table. Such custom navigation should be triggered via corresponding methods of {@link sap.suite.ui.generic.template.extensionAPI.NavigationController NavigationController}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Method should return `true` if framework navigation should be suppressed (that means: extension
     * code has taken over navigation)
     */
    onListNavigationExtension(
      /**
       * The press event fired when navigating from a row in the SmartTable. It is recommended to ignore this
       * parameter and use `oBindingContext` instead
       */
      oEvent: Event,
      /**
       * The context of the corresponding table row
       */
      oBindingContext: Context,
      /**
       * This parameter should be considered if the method triggers an internal navigation. Pass this parameter
       * to `oNavigationData.replaceInHistory` in this case
       */
      bReplaceInHistory: boolean
    ): boolean;
    /**
     * This method is called by SAP Fiori elements when the Share functionality is triggered. Application developers
     * can adapt the service URL passed as a parameter to this method. Adapted service URL will be used in the
     * 'Send Email' or 'Save as Tile' options.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onSaveAsTileExtension(
      /**
       * Object containing the serviceURL
       */
      oShareInfo: {
        /**
         * Service URL which is derived by SAP Fiori elements
         */
        serviceUrl: string;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements while applying the AppState. This method should be overridden
     * with `getCustomAppStateDataExtension`. The custom data retrieved from the AppState will be passed as
     * a parameter to this method. Application developers can use this custom data to restore the state of the
     * custom control.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    restoreCustomAppStateDataExtension(
      /**
       * Custom data containing the information
       */
      oCustomData: object
    ): void;
  }
  const controllerFrameworkExtensions: controllerFrameworkExtensions;
  export default controllerFrameworkExtensions;
}

declare module "sap/suite/ui/generic/template/AnalyticalListPage/extensionAPI/ExtensionAPI" {
  import BaseObject from "sap/ui/base/Object";

  import Control from "sap/ui/core/Control";

  import Metadata from "sap/ui/base/Metadata";

  import NavigationController from "sap/suite/ui/generic/template/extensionAPI/NavigationController";

  import Context from "sap/ui/model/Context";

  export default class ExtensionAPI extends BaseObject {
    /**
     * API to be used in extensions of AnalyticalListPage. Breakout coding can access an instance of this class
     * via `this.extensionAPI`. Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.AnalyticalListPage.extensionAPI.ExtensionAPI
     * with name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExtensionAPI>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.AnalyticalListPage.extensionAPI.ExtensionAPI.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attaches a control to the current View. Should be called whenever a new control is created and used in
     * the context of this view. This applies especially for dialogs, action sheets, popovers, ... This method
     * cares for defining dependency and handling device specific style classes
     */
    attachToView(
      /**
       * the control to be attached to the view
       */
      oControl: Control
    ): void;
    /**
     * provides incoming navigation context of the app
     *
     *
     * @returns Navigation context object
     */
    getNavigationContext(): Object;
    /**
     * Get the navigation controller for navigation actions
     *
     *
     * @returns the navigation controller
     */
    getNavigationController(): NavigationController;
    /**
     * Generally, this method returns the currently selected contexts in the given ui element (table, chart,
     * or list). In case the context menu is opened, it returns the contexts applicable to the context menu.
     *
     * Get the list entries currently selected
     *
     *
     * @returns contains the entries selected
     */
    getSelectedContexts(
      /**
       * the id identifying the ui element the selected context is requested for
       */
      sUiElementId: string
    ): Context[];
    /**
     * Invokes multiple time the action with the given name and submits changes to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the action, resolving to the same result as the `Promise`
     * returned from {@link sap.ui.generic.app.ApplicationController#invokeActions}
     */
    invokeActions(
      /**
       * The name of the function or action as expected by {@link sap.ui.model.odata.v2.ODataModel#callFunction}
       */
      sFunctionName: string,
      /**
       * The binding context(s) the function will be called for. To be omitted if the action is static.
       */
      vContext?: Context[] | Context,
      /**
       * The URL parameters (name-value pairs) for the function or action. Only needed in special cases.
       */
      mUrlParameters?: Record<string, any>,
      /**
       * Additional settings
       */
      oSettings?: {
        /**
         * Determines whether the common or unique changeset gets sent in batch
         */
        bInvocationGroupingChangeSet?: boolean;
      }
    ): Promise<any>;
    /**
     * This method should be called when any custom ui state handled by the getCustomAppStateDataExtension method
     * changes. Note that changes applied to custom filters need not to be propagated this way, since the change
     * event of the SmartFilterBar will automatically be handled by the smart template framework.
     */
    onCustomAppStateChange(): void;
    /**
     * Triggers rebinding on the list
     */
    rebindTable(): void;
    /**
     * Refreshes All controls in ALP
     */
    refresh(): void;
    /**
     * Refreshes the SmartTable
     */
    refreshTable(): void;
    /**
     * Secured execution of the given function. Ensures that the function is only executed when certain conditions
     * are fulfilled.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/6a39150ad3e548a8b5304d32d560790a Using the SecuredExecutionMethod}
     *
     *
     * @returns A `Promise` that is rejected, if execution is prohibited, and settled equivalent to the one
     * returned by fnFunction.
     */
    securedExecution(
      /**
       * The function to be executed. Should return a promise that is settled after completion of the execution.
       * If nothing is returned, immediate completion is assumed.
       */
      fnFunction: Function,
      /**
       * Parameters to define the preconditions to be checked before execution
       */
      mParameters?: {
        /**
         * Parameters regarding busy indication
         */
        busy?: {
          /**
           * Triggers a busy indication during function execution. Can be set to false in case of immediate completion.
           */
          set?: boolean;
          /**
           * Checks whether the application is currently busy. Function is only executed if not. Has to be set to
           * false, if function is not triggered by direct user interaction, but as result of another function, that
           * set the application busy.
           */
          check?: boolean;
        };
        /**
         * Parameters regarding dataloss prevention
         */
        dataloss?: {
          /**
           * Provides a dataloss popup before execution of the function if needed (i.e. in non-draft case when model
           * or registered methods contain pending changes).
           */
          popup?: boolean;
          /**
           * Indicates that execution of the function leads to a navigation, i.e. leaves the current page, which induces
           * a slightly different text for the dataloss popup.
           */
          navigation?: boolean;
        };
        /**
         * Tells the framework that objects will be deleted by `fnFunction`. Use the BindingContextPath as a key
         * for the map. Fill the map with a `Promise` for each object which is to be deleted. The `Promise` must
         * resolve after the deletion of the corresponding object or reject if the deletion is not successful.
         */
        mConsiderObjectsAsDeleted?: Record<string, any>;
        /**
         * In case of custom actions, the title of the message popup is set to sActionLabel.
         */
        sActionLabel?: string;
      }
    ): Promise<any>;
    /**
     * Provide an option for showing an own message in the message bar above the ALP table
     */
    setCustomMessage(
      /**
       * custom message along with type to set on table. If this parameter is faulty an existing message will
       * be removed.
       */
      oMessage?: {
        /**
         * message string to display
         */
        message: string;
        /**
         * indicates type of message (sap/ui/core/message/MessageType) whether it's MessageType.Success, MessageType.Warning,
         * MessageType.Error or MessageType.Information.
         */
        type: string;
      },
      /**
       * If switching between different table views is enabled, this parameter can be used to identify the views
       * which are affected by this call. Faulty values indicate that all views should be affected. Otherwise
       * the value should either be one string or an array of strings identifying the affected variant items.
       */
      vTabKey?: any[] | string,
      /**
       * A function that is called when the user closes the message bar. Note that the messages for all tabs specified
       * via `vTabKey` will be considered to be obsolete when the user closes the message bar while one of them
       * is active.
       */
      onClose?: Function
    ): void;
  }
}

declare module "sap/suite/ui/generic/template/Canvas/extensionAPI/ExtensionAPI" {
  import BaseObject from "sap/ui/base/Object";

  import Page from "sap/m/Page";

  import ObjectPageLayout from "sap/uxap/ObjectPageLayout";

  import Control from "sap/ui/core/Control";

  import Metadata from "sap/ui/base/Metadata";

  import NavigationController from "sap/suite/ui/generic/template/extensionAPI/NavigationController";

  import DraftTransactionController from "sap/suite/ui/generic/template/ObjectPage/extensionAPI/DraftTransactionController";

  import NonDraftTransactionController from "sap/suite/ui/generic/template/ObjectPage/extensionAPI/NonDraftTransactionController";

  import Context from "sap/ui/model/Context";

  export default class ExtensionAPI extends BaseObject {
    /**
     * API to be used in extensions of Canvas. Breakout coding can access an instance of this class via `this.extensionAPI`.
     * Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.Canvas.extensionAPI.ExtensionAPI with name
     * `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExtensionAPI>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.Canvas.extensionAPI.ExtensionAPI.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Can be used to add the standard footer bar for detail pages to this canvas page. It also allows to pass
     * an array of buttons to be added to the footer. Note that the usage of the standard footer bar must have
     * been switched on in the settings of the page.
     */
    addFooterBarToPage(
      /**
       * the page the standard footer bar should be set for
       */
      oPage: Page | ObjectPageLayout,
      /**
       * an array of controls(for example; Buttons) to be added to the footer.
       */
      aActions: any[]
    ): void;
    /**
     * Attach a handler to the PageDataLoaded event. This event is fired each time the object page is navigated
     * to or the object to be displayed is changed Note, that the event will not be fired before:
     * the navigation to the page has been completed the header data of the object are available
     */
    attachPageDataLoaded(
      /**
       * the handler function. Note that the event passed to this function possesses an attribute `context` which
       * contains the current header context
       */
      fnFunction: Function
    ): void;
    /**
     * Attaches a control to the current View. Should be called whenever a new control is created and used in
     * the context of this view. This applies especially for dialogs, action sheets, popovers, ... This method
     * cares for defining dependency and handling device specific style classes
     */
    attachToView(
      /**
       * the control to be attached to the view
       */
      oControl: Control
    ): void;
    /**
     * Detach a handler from the PageDataLoaded event
     */
    detachPageDataLoaded(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Returns a communication object for storing and accessing custom state information within the current
     * app.
     *
     * - If `iLevel` is `0`, it returns a global communication object shared across components. - If `iLevel`
     *     is `1`, it returns a local communication object specific to the current canvas component.
     *
     *
     * @returns The communication object.
     */
    getCommunicationObject(
      /**
       * The scope level of the communication object (0 for global, 1 for local).
       */
      iLevel: number
    ): object;
    /**
     * Get the Flexible Column Layout Action Buttons (Fullscreen, Exit Fullscreen and Close). Note that the
     * usage of the Flexible Column Layout Action Buttons must have been switched on in the settings of the
     * page.
     *
     *
     * @returns Flexible Column Layout Action Buttons (resp. `undefined` when no FCL Action Buttons should be
     * shown on this page)
     */
    getFlexibleColumnLayoutActionButtons(): object;
    /**
     * Get the navigation controller for navigation actions
     *
     *
     * @returns the navigation controller
     */
    getNavigationController(): NavigationController;
    /**
     * Get the transaction controller for editing actions on the page. Note that the methods provided by this
     * transaction controller depend on whether the object supports drafts or not.
     *
     *
     * @returns the transaction controller
     */
    getTransactionController():
      | DraftTransactionController
      | NonDraftTransactionController;
    /**
     * Invokes multiple time the action with the given name and submits changes to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the action, resolving to the same result as the `Promise`
     * returned from {@link sap.ui.generic.app.ApplicationController#invokeActions}
     */
    invokeActions(
      /**
       * The name of the function or action as expected by {@link sap.ui.model.odata.v2.ODataModel#callFunction}
       */
      sFunctionName: string,
      /**
       * The binding context(s) the function will be called for. To be omitted if the action is static.
       */
      vContext?: Context[] | Context,
      /**
       * The URL parameters (name-value pairs) for the function or action. Only needed in special cases.
       */
      mUrlParameters?: Record<string, any>,
      /**
       * Additional settings
       */
      oSettings?: {
        /**
         * Determines whether the common or unique changeset gets sent in batch
         */
        bInvocationGroupingChangeSet?: boolean;
      }
    ): Promise<any>;
    /**
     * Call this method to indicate that the state of custom controls has changed. This is only necessary when
     * methods `stGetCurrentState` and `stApplyState` have been implemented by the reuse component in the Canvas
     * page, such that the corresponding state can be stored and restored.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/89fa878945294931b15a581a99043005 Custom State Handling for Extended Apps}
     *
     *
     * @returns A `Promise` that is resolved when the changed state is transferred to the URL and the corresponding
     * busy session is ended.
     */
    onCustomStateChange(): Promise<any>;
    /**
     * Allow parent components to be refreshed on next activation
     */
    refreshAncestors(
      /**
       * Number of parent components to be refreshed 1 - Refresh the immediate parent component Undefined or faulty
       * - Refresh all parent components
       */
      iLevel: int
    ): void;
    /**
     * Registers a filter provider for the the message popover
     */
    registerMessageFilterProvider(
      /**
       * function which will be called each time a new context is set for the object page. The function should
       * return an instance of sap.ui.model.Filter, an array of sap.ui.model.Filter or a Promise which resolves
       * to one of these.
       */
      fnProviderCallback: Function
    ): void;
    /**
     * Secured execution of the given function. Ensures that the function is only executed when certain conditions
     * are fulfilled.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/6a39150ad3e548a8b5304d32d560790a Using the SecuredExecutionMethod}
     *
     *
     * @returns A `Promise` that is rejected, if execution is prohibited, and settled equivalent to the one
     * returned by fnFunction.
     */
    securedExecution(
      /**
       * The function to be executed. Should return a promise that is settled after completion of the execution.
       * If nothing is returned, immediate completion is assumed.
       */
      fnFunction: Function,
      /**
       * Parameters to define the preconditions to be checked before execution
       */
      mParameters?: {
        /**
         * Parameters regarding busy indication
         */
        busy?: {
          /**
           * Triggers a busy indication during function execution. Can be set to false in case of immediate completion.
           */
          set?: boolean;
          /**
           * Checks whether the application is currently busy. Function is only executed if not. Has to be set to
           * false, if function is not triggered by direct user interaction, but as result of another function, that
           * set the application busy.
           */
          check?: boolean;
        };
        /**
         * Parameters regarding dataloss prevention
         */
        dataloss?: {
          /**
           * Provides a dataloss popup before execution of the function if needed (i.e. in non-draft case when model
           * or registered methods contain pending changes).
           */
          popup?: boolean;
          /**
           * Indicates that execution of the function leads to a navigation, i.e. leaves the current page, which induces
           * a slightly different text for the dataloss popup.
           */
          navigation?: boolean;
        };
        /**
         * Tells the framework that objects will be deleted by `fnFunction`. Use the BindingContextPath as a key
         * for the map. Fill the map with a `Promise` for each object which is to be deleted. The `Promise` must
         * resolve after the deletion of the corresponding object or reject if the deletion is not successful.
         */
        mConsiderObjectsAsDeleted?: Record<string, any>;
        /**
         * In case of custom actions, the title of the message popup is set to sActionLabel.
         */
        sActionLabel?: string;
      }
    ): Promise<any>;
  }
}

declare module "sap/suite/ui/generic/template/extensionAPI/extensionAPI" {
  import Control from "sap/ui/core/Control";

  /**
   * Static access to extension API for Smart Template Application development
   */
  interface extensionAPI {
    /**
     * Get the extension API valid for the specified control embedded in a SAP Fiori elements view. Note that
     * extension API can also be retrieved directly from the controller of the SAP Fiori elements view. Therefore,
     * this method only needs to be called in scenarios where this controller is not directly accessible. The
     * most prominent use case for this would be the context of a controller of a view extension. In this case,
     * it is recommended to pass the extending view to this method.
     *  Note that this method does not return the extension API directly, but a Promise that resolves to the
     * extension API. Thus, a typical use of this method might look as follows:
     *  `sap.ui.define(["sap/suite/ui/generic/template/extensionAPI/extensionAPI"], function(extensionAPI){
     *  ...
     *  extensionAPI.getExtensionAPIPromise(oView).then(function(oExtensionAPI){
     *  oExtensionAPI.someMethod();
     *  });
     *  ...
     *  });`
     *
     *
     * @returns A `Promise` which resolves to the extension API for the embedding SAP Fiori elements view
     */
    getExtensionAPIPromise(
      /**
       * a control which is embedded into a SAP Fiori elements view.
       */
      oControl: Control
    ): Promise<any>;
    /**
     * This method can be used to define specific controller extension(s) for a template which is used more
     * than once within a SAP Fiori elements application. More precisely: In the manifest of a SAP Fiori elements
     * application, you can register a controller extension. This controller extension is defined at `sap.ui5/extends/extensions/sap.ui.controllerExtensions/{template}`.
     * This means that {template} identifies the template to be extended, e.g. `sap.suite.ui.generic.template.ObjectPage.view.Details`
     * for the standard object page. Property controllerName of the manifest entry specifies the controller
     * extension to be used. Even if the same template is used more than once, this single controller extension
     * will be instantiated once for each page based on this template. As a consequence, the extension code
     * for all these pages needs to be collected in one controller extension, which results in code that is
     * difficult to maintain.
     *  `registerControllerExtensions` provides a tool to distribute the extension code according to pages they
     * are actually used on.
     *  To use this tool, you should create separate classes implementing the logic for each single page.
     *  All event handlers and formatters used in the view extensions of the corrsponding page should be defined
     * as public instance methods of this class. The same applies to all extension functions that should be
     * overridden by extension code. Each of these classes can contain an optional method `onInit(oController)`.
     *
     *  This method can be used to initialize the class as usual. Moreover, it is possible to store `oController`
     * in a member variable. This variable can be used whenever standard controller functionality is needed
     * (e.g. `oController.byId()` or `oController.extensionAPI`.
     *  In the definition of the controller extension specified in the manifest, simply call `registerControllerExtensions`.
     *
     * @deprecated As of version 1.120. please refer the {@link topic:4120052d90374ce8b1cea24a0d8bd317 documentation }
     * for the migration steps.
     */
    registerControllerExtensions(
      /**
       * the name of the controller extension as specified in the manifest
       */
      sControllerExtensionName: undefined,
      /**
       * a map. As a key, use the name of the entity set for which the (controller of the) page should be extended.
       * As a value, use an instance of the corresponding class as described above.
       */
      mEntitySetToImplementation: undefined
    ): void;
  }
  const extensionAPI: extensionAPI;
  export default extensionAPI;
}

declare module "sap/suite/ui/generic/template/extensionAPI/NavigationController" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  import Context from "sap/ui/model/Context";

  import { displayMode } from "sap/suite/ui/generic/template/library";

  export default class NavigationController extends BaseObject {
    /**
     * API to be used for navigation in extensions of Smart Template Applications. Breakout coding can access
     * an instance of this class via {@link sap.suite.ui.generic.template.ListReport.extensionAPI.ExtensionAPI }
     * or {@link sap.suite.ui.generic.template.ObjectPage.extensionAPI.ExtensionAPI}. Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.extensionAPI.NavigationController with
     * name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NavigationController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.extensionAPI.NavigationController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Navigates to the given intent
     */
    navigateExternal(
      /**
       * The name of the outbound defined in the manifest
       */
      sOutbound: string,
      /**
       * map with parameters for the navigation. If no parameters are provided, default are the parameters defined
       * in the manifest
       */
      mParameters?: object
    ): void;
    /**
     * Triggers a navigation to another page within the application
     */
    navigateInternal(
      /**
       * The target context for the navigation. vContext as string, to navigate to specified target vContext as
       * Array [hierarchyOfContext] target context being the last context of hierarchyOfContext E.g to directly
       * navigate from LR to Sub object page, the hierarchyOfContext would be [contextOfMainObjectPage, contextOfSubObjectPage]
       * vContext as sap.ui.model.Context if only one context has to be passed, send it as an Object instead of
       * Array, to navigate to specified Target If the parameter is faulty (and oNavigationData does not specify
       * a route itself) the root page of the app is considered to be the target of the application.
       */
      vContext: Context | string | Context[],
      /**
       * object containing navigation data
       */
      oNavigationData?: {
        /**
         * This property is used if the target of the navigation should be a page which is not configured via an
         * entity set (thus it is a canvas page). In this case the value of this property should match the name
         * of the route which was defined in the routingSpec of this page. If the page requires a key, this key
         * should be added as content of `vContext`, which should be a string in this case.
         */
        routeName?: string;
        /**
         * If this is truthy the page navigated to will replace the current page in the browser history
         */
        replaceInHistory?: boolean;
        /**
         * This gives the provision to the application developer to choose between "display"/"edit" mode for target
         * page
         */
        displayMode?: displayMode | keyof typeof displayMode;
        /**
         * This property is only relevant if this instance is obtained from the extension api of a reuse component
         * (on object page) or an implementing component (of a canvas page) and property routeName is set.
         * In this case the navigation triggered by this method is by default restricted to child pages of that
         * component. If the target page of the navigation should be a page which is not a child page of that component
         * this property should be set to `>true`. In this case the target of the navigation can also be a child
         * of any of the hierarchical ancestors of the current page. Note that this establishes a strong dependency
         * from the business logic of that component to the structure of the app. This is problematic if the component
         * is defined independently of the app.
         */
        isAbsolute?: boolean;
      }
    ): void;
    /**
     * Sets the refresh behaviour of the source application, before navigating away in sap-keep-alive scenarios
     * using navPopover smart link The refreshStrategyOnAppRestore should be configured in the manifest This
     * function should be called on the beforeNavigationCallBack method of the NavPopover Smart Link. This function
     * only needs to be called in the exceptional case that the SmartLink control has been added in a custom
     * fragment or a reuse component, since framework takes care for all other cases.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/3c65f2cc630c472da8328a6f3c193683 Refresh Entity Sets in keep alive mode}
     */
    setRefreshBehaviour(
      /**
       * the name of the outbound defined in the manifest
       */
      sOutbound: string,
      /**
       * map with parameters for the navigation. If no parameters are provided, default are the parameters defined
       * in the manifest
       */
      mParameters: object
    ): void;
  }
}

declare module "sap/suite/ui/generic/template/extensionAPI/ReuseComponentSupport" {
  import UIComponent from "sap/ui/core/UIComponent";

  /**
   * Static access to a function that allows a regular UIComponent to be used as a Reuse Component within
   * SmartTemplate applications
   */
  interface ReuseComponentSupport {
    /**
     * Mixin function to transform a regular UIComponent instance into a reuse component for smart templates
     *
     * By using the mixInto method the existing component is checked if it implements the following functions:
     *
     * 	 - `stStart(oModel, oBindingContext, oExtensionAPI)` - is called when the model and the context is set
     *     for the first time above the compoenent
     * 	 - `stRefresh(oModel, oBindingContext, oExtensionAPI)` - is called everytime a new context is set above
     *     the component or the page context is forced to be refreshed  Note that both functions can be called
     *     with `oBindingContext` being empty. This happens in case the page the component is positioned on is opened
     *     for creating a new object in a non-draft scenario.
     */
    mixInto(
      /**
       * the component to be transformed. The following restrictions apply to this component:
       * 	The object must not define or access any properties or methods starting with `_st`. This namespace is
       * reserved for smart template specific coding. The object must not define any property or method starting
       * with `st` with the exception of the methods described above.
       */
      oComponent: UIComponent,
      /**
       * if this paramater is truthy a JSON model will created that contains the properties defined in the meatdata
       * of `oComponent`. The model will be attached to the component with the given name. Moreover, a method
       * `getComponentModel` will be added to `oComponent` giving access to this model. The properties in the
       * component model will be automatically synced with the corresponding properties of `oComponent`.
       */
      sComponentModelName?: string,
      /**
       * This parameters specifies the synchronisation between the properties of the component and the corresponding
       * properties of the component model.
       *  Changes applied to a property of the component will always be forwarded to the corresponding property
       * of the component model.
       *  Changes applied to a property of the component model which corresponds to a property of the component
       * will only be forwarded accordingly if the parameter `bTwoWaySync` is truthy.
       */
      bTwoWaySync?: boolean
    ): void;
  }
  const ReuseComponentSupport: ReuseComponentSupport;
  export default ReuseComponentSupport;
}

declare module "sap/suite/ui/generic/template/lib/AppComponent" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { IAsyncContentCreation } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Smart Templates Application Component
   */
  export default abstract class AppComponent
    extends UIComponent
    implements IAsyncContentCreation
  {
    __implements__sap_ui_core_IAsyncContentCreation: boolean;
    /**
     * Main class used for Smart Template(Fiori elements V2) Application Component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new AppComponent instance
       */
      mSettings?: $AppComponentSettings
    );
    /**
     * Main class used for Smart Template(Fiori elements V2) Application Component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Generated automatically if no non-empty ID is given;
       */
      sId?: string,
      /**
       * Initial settings for the new AppComponent instance
       */
      mSettings?: $AppComponentSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.lib.AppComponent with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AppComponent>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.lib.AppComponent.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pageDataLoaded pageDataLoaded} event of this
     * `sap.suite.ui.generic.template.lib.AppComponent`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.generic.template.lib.AppComponent` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPageDataLoaded(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.generic.template.lib.AppComponent`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pageDataLoaded pageDataLoaded} event of this
     * `sap.suite.ui.generic.template.lib.AppComponent`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.generic.template.lib.AppComponent` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPageDataLoaded(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.generic.template.lib.AppComponent`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pageDataLoaded pageDataLoaded} event of this
     * `sap.suite.ui.generic.template.lib.AppComponent`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPageDataLoaded(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:pageDataLoaded pageDataLoaded} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePageDataLoaded(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getCollaborationSettings collaborationSettings}.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Value of property `collaborationSettings`
     */
    getCollaborationSettings(): object;
    /**
     * Gets current value of property {@link #getConsiderAnalyticalParameters considerAnalyticalParameters}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `considerAnalyticalParameters`
     */
    getConsiderAnalyticalParameters(): boolean;
    /**
     * Gets current value of property {@link #getDraftDiscardConfirmationSettings draftDiscardConfirmationSettings}.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Value of property `draftDiscardConfirmationSettings`
     */
    getDraftDiscardConfirmationSettings(): object;
    /**
     * Gets current value of property {@link #getEnableAutoColumnWidthForSmartTable enableAutoColumnWidthForSmartTable}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableAutoColumnWidthForSmartTable`
     */
    getEnableAutoColumnWidthForSmartTable(): boolean;
    /**
     * Gets current value of property {@link #getExternalNavigationSettings externalNavigationSettings}.
     *
     *
     * @returns Value of property `externalNavigationSettings`
     */
    getExternalNavigationSettings(): object;
    /**
     * Gets current value of property {@link #getFlexibleColumnLayout flexibleColumnLayout}.
     *
     *
     * @returns Value of property `flexibleColumnLayout`
     */
    getFlexibleColumnLayout(): object;
    /**
     * Gets current value of property {@link #getForceGlobalRefresh forceGlobalRefresh}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `forceGlobalRefresh`
     */
    getForceGlobalRefresh(): boolean;
    /**
     * Gets current value of property {@link #getInboundParameters inboundParameters}.
     *
     *
     * @returns Value of property `inboundParameters`
     */
    getInboundParameters(): object;
    /**
     * Gets current value of property {@link #getMergeObjectPageSectionTitle mergeObjectPageSectionTitle}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `mergeObjectPageSectionTitle`
     */
    getMergeObjectPageSectionTitle(): boolean;
    /**
     * Gets current value of property {@link #getObjectPageColumns objectPageColumns}.
     *
     *
     * @returns Value of property `objectPageColumns`
     */
    getObjectPageColumns(): object;
    /**
     * Gets current value of property {@link #getObjectPageHeaderType objectPageHeaderType}.
     *
     * Default value is `"Static"`.
     *
     *
     * @returns Value of property `objectPageHeaderType`
     */
    getObjectPageHeaderType(): string;
    /**
     * Gets current value of property {@link #getObjectPageVariantManagement objectPageVariantManagement}.
     *
     * Default value is `"None"`.
     *
     *
     * @returns Value of property `objectPageVariantManagement`
     */
    getObjectPageVariantManagement(): string;
    /**
     * Gets current value of property {@link #getShowDraftToggle showDraftToggle}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showDraftToggle`
     */
    getShowDraftToggle(): boolean;
    /**
     * Gets current value of property {@link #getSkipOPContextInfoInBrowserTitle skipOPContextInfoInBrowserTitle}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `skipOPContextInfoInBrowserTitle`
     */
    getSkipOPContextInfoInBrowserTitle(): boolean;
    /**
     * Gets current value of property {@link #getStatePreservationMode statePreservationMode}.
     *
     * Default value is `"auto"`.
     *
     *
     * @returns Value of property `statePreservationMode`
     */
    getStatePreservationMode(): string;
    /**
     * Gets current value of property {@link #getTableColumnVerticalAlignment tableColumnVerticalAlignment}.
     *
     * Default value is `"Middle"`.
     *
     *
     * @returns Value of property `tableColumnVerticalAlignment`
     */
    getTableColumnVerticalAlignment(): string;
    /**
     * Gets current value of property {@link #getTableSettings tableSettings}.
     *
     *
     * @returns Value of property `tableSettings`
     */
    getTableSettings(): object;
    /**
     * Gets current value of property {@link #getUseColumnLayoutForSmartForm useColumnLayoutForSmartForm}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `useColumnLayoutForSmartForm`
     */
    getUseColumnLayoutForSmartForm(): boolean;
    /**
     * Sets a new value for property {@link #getCollaborationSettings collaborationSettings}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCollaborationSettings(
      /**
       * New value for property `collaborationSettings`
       */
      oCollaborationSettings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getConsiderAnalyticalParameters considerAnalyticalParameters}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConsiderAnalyticalParameters(
      /**
       * New value for property `considerAnalyticalParameters`
       */
      bConsiderAnalyticalParameters?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDraftDiscardConfirmationSettings draftDiscardConfirmationSettings}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDraftDiscardConfirmationSettings(
      /**
       * New value for property `draftDiscardConfirmationSettings`
       */
      oDraftDiscardConfirmationSettings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAutoColumnWidthForSmartTable enableAutoColumnWidthForSmartTable}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAutoColumnWidthForSmartTable(
      /**
       * New value for property `enableAutoColumnWidthForSmartTable`
       */
      bEnableAutoColumnWidthForSmartTable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExternalNavigationSettings externalNavigationSettings}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExternalNavigationSettings(
      /**
       * New value for property `externalNavigationSettings`
       */
      oExternalNavigationSettings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getFlexibleColumnLayout flexibleColumnLayout}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFlexibleColumnLayout(
      /**
       * New value for property `flexibleColumnLayout`
       */
      oFlexibleColumnLayout?: object
    ): this;
    /**
     * Sets a new value for property {@link #getForceGlobalRefresh forceGlobalRefresh}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setForceGlobalRefresh(
      /**
       * New value for property `forceGlobalRefresh`
       */
      bForceGlobalRefresh?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getInboundParameters inboundParameters}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInboundParameters(
      /**
       * New value for property `inboundParameters`
       */
      oInboundParameters?: object
    ): this;
    /**
     * Sets a new value for property {@link #getMergeObjectPageSectionTitle mergeObjectPageSectionTitle}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMergeObjectPageSectionTitle(
      /**
       * New value for property `mergeObjectPageSectionTitle`
       */
      bMergeObjectPageSectionTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getObjectPageColumns objectPageColumns}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObjectPageColumns(
      /**
       * New value for property `objectPageColumns`
       */
      oObjectPageColumns: object
    ): this;
    /**
     * Sets a new value for property {@link #getObjectPageHeaderType objectPageHeaderType}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Static"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObjectPageHeaderType(
      /**
       * New value for property `objectPageHeaderType`
       */
      sObjectPageHeaderType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getObjectPageVariantManagement objectPageVariantManagement}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"None"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObjectPageVariantManagement(
      /**
       * New value for property `objectPageVariantManagement`
       */
      sObjectPageVariantManagement?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowDraftToggle showDraftToggle}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDraftToggle(
      /**
       * New value for property `showDraftToggle`
       */
      bShowDraftToggle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSkipOPContextInfoInBrowserTitle skipOPContextInfoInBrowserTitle}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSkipOPContextInfoInBrowserTitle(
      /**
       * New value for property `skipOPContextInfoInBrowserTitle`
       */
      bSkipOPContextInfoInBrowserTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStatePreservationMode statePreservationMode}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStatePreservationMode(
      /**
       * New value for property `statePreservationMode`
       */
      sStatePreservationMode?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTableColumnVerticalAlignment tableColumnVerticalAlignment}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Middle"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableColumnVerticalAlignment(
      /**
       * New value for property `tableColumnVerticalAlignment`
       */
      sTableColumnVerticalAlignment?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTableSettings tableSettings}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableSettings(
      /**
       * New value for property `tableSettings`
       */
      oTableSettings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getUseColumnLayoutForSmartForm useColumnLayoutForSmartForm}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseColumnLayoutForSmartForm(
      /**
       * New value for property `useColumnLayoutForSmartForm`
       */
      bUseColumnLayoutForSmartForm?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AppComponent constructor.
   */
  export interface $AppComponentSettings extends $UIComponentSettings {
    forceGlobalRefresh?: boolean | PropertyBindingInfo | `{${string}}`;

    considerAnalyticalParameters?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    showDraftToggle?: boolean | PropertyBindingInfo | `{${string}}`;

    objectPageHeaderType?: string | PropertyBindingInfo;

    objectPageVariantManagement?: string | PropertyBindingInfo;

    flexibleColumnLayout?: object | PropertyBindingInfo | `{${string}}`;

    inboundParameters?: object | PropertyBindingInfo | `{${string}}`;

    tableSettings?: object | PropertyBindingInfo | `{${string}}`;

    tableColumnVerticalAlignment?: string | PropertyBindingInfo;

    useColumnLayoutForSmartForm?: boolean | PropertyBindingInfo | `{${string}}`;

    objectPageColumns?: object | PropertyBindingInfo | `{${string}}`;

    statePreservationMode?: string | PropertyBindingInfo;

    enableAutoColumnWidthForSmartTable?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    draftDiscardConfirmationSettings?:
      | object
      | PropertyBindingInfo
      | `{${string}}`;

    collaborationSettings?: object | PropertyBindingInfo | `{${string}}`;

    mergeObjectPageSectionTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    externalNavigationSettings?: object | PropertyBindingInfo | `{${string}}`;

    skipOPContextInfoInBrowserTitle?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    pageDataLoaded?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AppComponent#pageDataLoaded event.
   */
  export interface AppComponent$PageDataLoadedEventParameters {}

  /**
   * Event object of the AppComponent#pageDataLoaded event.
   */
  export type AppComponent$PageDataLoadedEvent = Event<
    AppComponent$PageDataLoadedEventParameters,
    AppComponent
  >;
}

declare module "sap/suite/ui/generic/template/ListReport/controllerFrameworkExtensions" {
  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import SmartFilterBar from "sap/ui/comp/smartfilterbar/SmartFilterBar";

  import Filter from "sap/ui/export/util/Filter";

  import Event from "sap/ui/base/Event";

  import Context from "sap/ui/model/Context";

  /**
   * This class contains all extension functions that can be implemented by Application developers in their
   * extension code. Application developers should not override any methods outside this documentation.
   */
  interface controllerFrameworkExtensions {
    /**
     * Obsolete and not called anymore. Kept here to avoid conflicts (in the very unlikely case, Fiori elements
     * would come up with the idea to invent a new extension method with the exact same name some day in future,
     * and any application would still have an implementation for this old extension).
     *
     * (Original purpose: When (standard) filters (i.e. filters defined in annotations) are provided with default
     * values (also from the annotation), and the user actively removed the default without giving a new value,
     * and later tried to restore from that state, the default values were reappearing. This was caused by the
     * way the old API of SFB (getDataSuiteFormat and setDataSuiteFormat) worked: the get method returned only
     * select options for the filters that actually had values (i.e. no select option for the filters the user
     * removed the values from), and the set method only overrode those values, select options were provided
     * for (i.e. the missing ones just kept their default value set during initialization). To overcome this
     * problem, the extension was created to inform Fiori elements about all fields potentially running into
     * that problem, and we added a select option (I EQ "") for those fields. This workaround of course ahs
     * two severe problems: A filter with eq "" is not the same as not having a filter for the same field (rather
     * the opposite), and all applications were required to keep extension and annotations in sync (and missing
     * to do that would only be found in very exceptional cases). With the newer API of SFB (getUiState and
     * setUiState), this problem has been overcome (esp. as setUiState overrides all filters, not only the ones
     * provided).)
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    getVisibleSelectionsWithDefaults: undefined;

    /**
     * This method is called by SAP Fiori elements before triggering an external navigation. Application developers
     * can override this method and programmatically adapt the parameters which are passed to the target application.
     * Application developers can use the oObjectInfo parameter to identify the navigation context and modify
     * the oSelectionVariant which contains the navigation parameters.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptNavigationParameterExtension(
      /**
       * Selection variant object containing the information which needs to be passed to the target application
       */
      oSelectionVariant: SelectionVariant,
      /**
       * Context object based on which the intent based navigation is triggered
       */
      oObjectInfo: {
        /**
         * Semantic object used for the intend based navigation
         */
        semanticObject: string;
        /**
         * Action on the context for which the navigation is triggered
         */
        action: string;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements whenever the busy state is switched off. Application developers
     * can override this method, access the message model and adapt the transient messages related to the component.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptTransientMessageExtension(): void;
    /**
     * This method is called by SAP Fiori elements when the delete operation is triggered. Application developers
     * can override this method in controller extension & perform additional checks before executing the delete
     * operation. Method is expected to return a Promise. To veto the delete operation, promise needs to be
     * rejected else resolved.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - Promise object created by the extension, used for Delete operation chaining
     */
    beforeDeleteExtension(
      /**
       * Object containing the selected context for delete
       */
      oBeforeDeleteProperties: {
        /**
         * Array of the selected contexts
         */
        aContexts: any[];
      }
    ): Promise<any>;
    /**
     * This method should be implemented whenever the application needs to have a custom save functionality
     * for multi edit scenario. The logic for save should be defined here and this method should return a promise
     * based on whose resolution or rejection the framework would perform cleanup tasks like closing the dialog
     * and refreshing the table data.There will be no chaining of multi edit save from the framework, if the
     * extension is implemented then the framework will only execute extension code for save.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - Promise object created by the extension, used for cleanup after the promise is resolved or
     * rejected.
     */
    beforeMultiEditSaveExtension(
      /**
       * The array of objects containing the contexts to be updated and the updated value.
       */
      aContextsToBeUpdated: Array<{
        /**
         * The context path for the child to be updated.
         */
        sContextPath: string;
        /**
         * The Object with the updated values for the selected properties in the multi edit dialog.
         */
        oUpdateData: Object;
      }>
    ): Promise<any>;
    /**
     * This method is called by SAP Fiori elements when a smart link in a table is clicked. Application developers
     * can override this method and invoke the oParams.getSourceInfo method to find out the information about
     * the clicked smart link.
     *
     * If the application expect the framework should not handle the `beforePopoverOpens` event, then this method
     * should return true. Otherwise, framework will proceed with its handling.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Method should return `true` if framework should not handle `beforePopoverOpens` event (that
     * means: extension code will handle the event)
     */
    beforeSmartLinkPopoverOpensExtension(
      /**
       * Object containing the "getSourceInfo" method and the selection variant
       */
      oParams: {
        /**
         * Selection variant object containing the information which needs to be passed to the target application
         */
        oSelectionVariant: SelectionVariant;
        /**
         * Returns an object contains information about the smart link
         */
        getSourceInfo?: Function;
      }
    ): boolean;
    /**
     * This method is called by SAP Fiori elements before persisting the AppState. Application developers can
     * override this method for persisting the state of custom controls. State of the custom control (controls)
     * should be stored in the oCustomData passed as a parameter to this method. To make a complete functionality,
     * this method should be overridden in combination with `restoreCustomAppStateDataExtension`.
     *
     * In some cases, applications might need to inform the framework about changes to their state by calling
     * {@link sap.suite.ui.generic.template.ListReport.extensionAPI.onCustomAppStateChange onCustomAppStateChange}.
     * For custom filters added to the filter bar, this should not be necessary.
     *
     * Remark: The term AppState actually relates to the UI state of the List Report. It is usually stored in
     * the layered repository, and can be retrieved via the key, that is added as value of the URL parameter
     * iAppState. (Although the value of the URL parameter xAppState used in navigation scenarios also points
     * to data stored on the layered repository, in contrast to the iAppState it has nothing to do with the
     * state of the app - conceptually, it is just a container for passing data from source to target during
     * navigation. The confusion arises from the fact, that per definition the source app should provide all
     * data available (to allow the target app to select the part it is interested in), and thus the structure
     * contained looks quite similar to the iAppState.)
     *
     * For more information, see {@link https://ui5.sap.com/#/topic/5fb9f57fcf12401bbe39a635e9a32a4e Adding Custom Fields to the Filter Bar}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getCustomAppStateDataExtension(
      /**
       * Object to be enriched with the custom control state
       */
      oCustomData: object
    ): void;
    /**
     * This method is called by SAP Fiori elements when the Create with Filters is executed. Application developers
     * can enable this feature in the LR component by adding createWithFilters in the settings object of the
     * List Report component & strategy needs to be set as `extension`. SmartFilterBar instance will be passed
     * as a parameter to the method. Application developers can access the properties, values and add it to
     * the returning object map. Application developers will have complete control on properties passed to the
     * new instance creation.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Key/Value map of the properties
     */
    getPredefinedValuesForCreateExtension(
      /**
       * SmartFilterBar of the ListReport
       */
      oSmartFilterBar: SmartFilterBar,
      /**
       * Default values returned by backend when Common.v1.DefaultValuesFunction annotation has been configured
       */
      oDefaultValues: object
    ): Map<any, any>;
    /**
     * This method is called by SAP Fiori elements in the startup life cycle of a component. Application developers
     * can override this method and modify the startup object. For an example, when the application is started,
     * the selection variant might contain some properties that are not required for this app. Such properties
     * can be removed from the selection variant. The reverse use case is also true, where some additional properties
     * needs to be added with certain fixed values. This can be achieved by adding these values to the selection
     * variant.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    modifyStartupExtension(
      /**
       * Startup Object containing the initial contexts
       */
      oStartupObject: {
        /**
         * information whether the application was triggered via external navigation
         */
        viaExternalNavigation: boolean;
        /**
         * Selection Variant containing the values which needs to be applied to the smart filter bar
         */
        selectionVariant: SelectionVariant;
        /**
         * Semantic dates configuration in the manifest is read an assigned in this object
         */
        semanticDates: object;
        /**
         * if switching between different table views is enabled, the key which will be initially selected
         */
        selectedQuickVariantSelectionKey: string;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements when the table data is getting exported. Application developers
     * can override this method to add/remove the filters in the exported file.
     *
     * To add new filter entries to the exported file, create an instance of {@link sap.ui.export.util.Filter }
     * and add it to "oExportParams.filterSettings"
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeExportTableExtension(
      /**
       * Object containing the table export info
       */
      oExportParams: {
        /**
         * The filters in the exported file Note: Please make changes on "oExportParams.filterSettings" array only
         * when "Include filter settings" is selected. Otherwise, the changes will be ignored.
         */
        filterSettings: Filter[];
        /**
         * The value of "Include filter settings" checkbox
         */
        includeFilterSettings: boolean;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a chart. Application developers can override
     * this method and programmatically modify parameters or filters before chart triggers a query to retrieve
     * data.
     *
     * For more information, see {@link https://ui5.sap.com/#/topic/5fb9f57fcf12401bbe39a635e9a32a4e Adding Custom Fields to the Filter Bar}.
     *
     * **Note: **This method is called only when a chart is rebound, and not when it is refreshed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindChartExtension(
      /**
       * The {@link sap.ui.comp.smartchart.SmartChart.prototype.event:beforeRebindChart beforeRebindChart} event
       */
      oEvent: Event
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a table. Application developers can override
     * this method and programmatically modify parameters or filters before the table triggers a query to retrieve
     * data.
     *
     * For more information, see {@link https://ui5.sap.com/#/topic/5fb9f57fcf12401bbe39a635e9a32a4e Adding Custom Fields to the Filter Bar}.
     *
     * **Note: **This method is called only when a table is rebound, and not when it is refreshed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindTableExtension(
      /**
       * The {@link sap.ui.comp.smarttable.SmartTable.prototype.event:beforeRebindTable beforeRebindTable} event
       */
      oEvent: Event
    ): void;
    /**
     * This method should be implemented whenever application uses onListNavigationExtension for internal navigation.
     * In this case the implementation of this method should provide an 'inverse' mapping to the transformation
     * implemented within onListNavigationExtension. More precisely, the identification of a child page instance
     * is passed to this function. The implementation of this function should provide information about the
     * list item which has triggered the opening of the child page.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onChildOpenedExtension(
      /**
       * Information about the child page instance opened last
       */
      oSelectionInfo: {
        /**
         * The entity set identifying the child page which was opened last. Note: In case the child page has been
         * defined without reference to OData this will be the routeName taken from the routingSpec.
         */
        pageEntitySet?: string;
        /**
         * The context path that was used for the last opened child page
         */
        path?: string;
        /**
         * The array of keys (one on each hiearchy level) used for the last opened child page
         */
        keys?: string[];
      },
      /**
       * pass the binding path of the corresponding list item to this function if it is not identical to `oSelectionInfo.path`
       */
      fnSetPath: Function
    ): void;
    /**
     * This method is called by SAP Fiori elements on the initialization of View. Application developers can
     * override this method & perform internal setup in this hook, It is only called once per View instance.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onInit(): void;
    /**
     * This method is called by SAP Fiori elements once the smart filter bar is initialized with a variant.
     *
     * Application developers can override this method when there is a custom filter field bound outside the
     * standard model.
     *
     * Use this method to provide initial values for your extension filters if they deviate from the initial
     * value according to the data type and cannot be provided in the view fragment.
     *
     * For more information, see {@link https://ui5.sap.com/#/topic/5fb9f57fcf12401bbe39a635e9a32a4e Adding Custom Fields to the Filter Bar}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onInitSmartFilterBarExtension(
      /**
       * The {@link sap.ui.comp.filterbar.FilterBar.prototype.event:initialise initialise} event
       */
      oEvent: Event
    ): void;
    /**
     * This method is called when the user leaves the app and this page has been displayed within the same app
     * session (this is the time since last opening the app) at least once. Moreover, it is called for all pages
     * that have been displayed within some app session when the app is finally destroyed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - Only relevant in case that `isDestroyed` is false. In this case Application developers can
     * provide a function to be called when the same page is opened again (after the user has navigated back
     * to the app).
     */
    onLeaveAppExtension(
      /**
       * If this parameter is true this app instance is destroyed. Otherwise it might be rewoken if the user navigates
       * again to this app within the same FLP session
       */
      bIsDestroyed: boolean
    ): Function;
    /**
     * This method is called by SAP Fiori elements when a chevron navigation is triggered from a table. Application
     * developers can override this method and perform conditional (internal or external) navigation from different
     * rows of a table. Such custom navigation should be triggered via corresponding methods of {@link sap.suite.ui.generic.template.extensionAPI.NavigationController NavigationController}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Method should return `true` if framework navigation should be suppressed (that means: extension
     * code has taken over navigation)
     */
    onListNavigationExtension(
      /**
       * The press event fired when navigating from a row in the SmartTable. It is recommended to ignore this
       * parameter and use `oBindingContext` instead
       */
      oEvent: Event,
      /**
       * The context of the corresponding table row
       */
      oBindingContext: Context,
      /**
       * This parameter should be considered if the method triggers an internal navigation. Pass this parameter
       * to `oNavigationData.replaceInHistory` in this case
       */
      bReplaceInHistory: boolean
    ): boolean;
    /**
     * This method is called by SAP Fiori elements when the Share functionality is triggered. Application developers
     * can adapt the service URL passed as a parameter to this method. Adapted service URL will be used in the
     * 'Send Email' or 'Save as Tile' options.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onSaveAsTileExtension(
      /**
       * Object containing the serviceURL
       */
      oShareInfo: {
        /**
         * Service URL which is derived by SAP Fiori elements
         */
        serviceUrl: string;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements while applying the AppState. This method should be overridden
     * in combination with `getCustomAppStateDataExtension`. The custom data retrieved from the AppState will
     * be passed as a parameter to this method. Application developers can use this custom data to restore the
     * state of the custom control.
     *
     * Note: Application developers need to be aware that this method is also called during startup without
     * restoring from an iAppState (initial startup or navigation). In this case, an empty object is provided.
     * Originally, this happened unintended, but needs to be kept for compatibility, as it has been used by
     * some applications to enforce specific filter values (contradicting the defined way navigation should
     * work). This usage is not recommended! Recommended: When called with an empty object, just return without
     * doing anything.
     *
     * For more information, see {@link https://ui5.sap.com/#/topic/5fb9f57fcf12401bbe39a635e9a32a4e Adding Custom Fields to the Filter Bar}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    restoreCustomAppStateDataExtension(
      /**
       * Custom data containing the information
       */
      oCustomData: object
    ): void;
  }
  const controllerFrameworkExtensions: controllerFrameworkExtensions;
  export default controllerFrameworkExtensions;
}

declare module "sap/suite/ui/generic/template/ListReport/extensionAPI/ExtensionAPI" {
  import BaseObject from "sap/ui/base/Object";

  import Control from "sap/ui/core/Control";

  import Metadata from "sap/ui/base/Metadata";

  import NavigationController from "sap/suite/ui/generic/template/extensionAPI/NavigationController";

  import Context from "sap/ui/model/Context";

  import NonDraftTransactionController from "sap/suite/ui/generic/template/ListReport/extensionAPI/NonDraftTransactionController";

  export default class ExtensionAPI extends BaseObject {
    /**
     * API to be used in extensions of ListReport. Breakout coding can access an instance of this class via
     * `this.extensionAPI`. Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.ListReport.extensionAPI.ExtensionAPI with
     * name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExtensionAPI>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.ListReport.extensionAPI.ExtensionAPI.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attaches a control to the current View. Should be called whenever a new control is created and used in
     * the context of this view. This applies especially for dialogs, action sheets, popovers, ... This method
     * cares for defining dependency and handling device specific style classes
     */
    attachToView(
      /**
       * the control to be attached to the view
       */
      oControl: Control
    ): void;
    /**
     * Returns the global communication object for storing and accessing custom state information within the
     * current app. This object can be used across components to share state information.
     *
     *
     * @returns The communication object.
     */
    getCommunicationObject(): object;
    /**
     * Get the navigation controller for navigation actions
     *
     *
     * @returns the navigation controller
     */
    getNavigationController(): NavigationController;
    /**
     * If multi view table is enabled, this function returns the selected variant's key.
     *
     *
     * @returns The currently selected variant key on the table.
     */
    getQuickVariantSelectionKey(): string;
    /**
     * Generally, it returns the currently selected contexts of the smart table. In case the context menu is
     * opened, it returns the contexts applicable to the context menu.
     *
     *
     * @returns contains one entry per line selected
     */
    getSelectedContexts(): Context[];
    /**
     * Get the transaction controller for editing actions on the list. Note: Currently implemented for non draft
     * case
     *
     *
     * @returns the transaction controller
     */
    getTransactionController(): NonDraftTransactionController;
    /**
     * Invokes multiple time the action with the given name and submits changes to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the action, resolving to the same result as the `Promise`
     * returned from {@link sap.ui.generic.app.ApplicationController#invokeActions}
     */
    invokeActions(
      /**
       * The name of the function or action as expected by {@link sap.ui.model.odata.v2.ODataModel#callFunction}
       */
      sFunctionName: string,
      /**
       * The binding context(s) the function will be called for. To be omitted if the action is static.
       */
      vContext?: Context[] | Context,
      /**
       * The URL parameters (name-value pairs) for the function or action. Only needed in special cases.
       */
      mUrlParameters?: Record<string, any>,
      /**
       * Additional settings
       */
      oSettings?: {
        /**
         * Determines whether the common or unique changeset gets sent in batch
         */
        bInvocationGroupingChangeSet?: boolean;
      }
    ): Promise<any>;
    /**
     * This method should be called when any custom ui state handled by the get/restoreCustomAppStateDataExtension-methods
     * changes. Note that changes applied to custom filters need not to be propagated this way, since the change
     * event of the SmartFilterBar will automatically be handled by the smart template framework.
     *
     * For more information, see {@link https://ui5.sap.com/#/topic/5fb9f57fcf12401bbe39a635e9a32a4e Adding Custom Fields to the Filter Bar}.
     */
    onCustomAppStateChange(): void;
    /**
     * Triggers rebinding on the list.
     *  Note that in a multi table tab scenarios the situation is more complex: By default the rebinding is
     * performed on all tabs as soon as they get visible the next time (immediately for the already visible
     * one). This applies to charts as well as tables.
     *  Optional parameter `vTabKey` can be used to restrict the set of affected tabs.
     */
    rebindTable(
      /**
       * in multiple table tab scenario keys for the tables that should be rebound
       */
      vTabKey?: any[] | string
    ): void;
    /**
     * Refreshes the List from the backend Note that in a multi table tab scenarios the situation is more complex:
     * By default the refresh is performed on all tabs as soon as they get visible the next time (immediately
     * for the already visible one). This applies to charts as well as tables.
     *  Optional parameter `vTabKey` can be used to restrict the set of affected tabs.
     */
    refreshTable(
      /**
       * in multiple table tab scenario keys for the tables that should be refreshed
       */
      vTabKey?: any[] | string
    ): void;
    /**
     * Secured execution of the given function. Ensures that the function is only executed when certain conditions
     * are fulfilled. For more information, see {@link https://ui5.sap.com/#/topic/6a39150ad3e548a8b5304d32d560790a Using the SecuredExecutionMethod}.
     *
     *
     * @returns A `Promise` that is rejected, if execution is prohibited, and settled equivalent to the one
     * returned by fnFunction.
     */
    securedExecution(
      /**
       * The function to be executed. Should return a promise that is settled after completion of the execution.
       * If nothing is returned, immediate completion is assumed.
       */
      fnFunction: Function,
      /**
       * Parameters to define the preconditions to be checked before execution
       */
      mParameters?: {
        /**
         * Parameters regarding busy indication
         */
        busy?: {
          /**
           * Triggers a busy indication during function execution. Can be set to false in case of immediate completion.
           */
          set?: boolean;
          /**
           * Checks whether the application is currently busy. Function is only executed if not. Has to be set to
           * false, if function is not triggered by direct user interaction, but as result of another function, that
           * set the application busy.
           */
          check?: boolean;
        };
        /**
         * Parameters regarding dataloss prevention
         */
        dataloss?: {
          /**
           * Provides a dataloss popup before execution of the function if needed (i.e. in non-draft case when model
           * or registered methods contain pending changes).
           */
          popup?: boolean;
          /**
           * Indicates that execution of the function leads to a navigation, i.e. leaves the current page, which induces
           * a slightly different text for the dataloss popup.
           */
          navigation?: boolean;
        };
        /**
         * Tells the framework that objects will be deleted by `fnFunction`. Use the BindingContextPath as a key
         * for the map. Fill the map with a `Promise` for each object which is to be deleted. The `Promise` must
         * resolve after the deletion of the corresponding object or reject if the deletion is not successful.
         */
        mConsiderObjectsAsDeleted?: Record<string, any>;
        /**
         * In case of custom actions, the title of the message popup is set to sActionLabel.
         */
        sActionLabel?: string;
      }
    ): Promise<any>;
    /**
     * Provide an option for showing an own message in the message bar above the LR table
     */
    setCustomMessage(
      /**
       * custom message along with type to set on table. If this parameter is faulty an existing message will
       * be removed.
       */
      oMessage?: {
        /**
         * message string to display
         */
        message: string;
        /**
         * indicates type of message (sap/ui/core/message/MessageType) whether it's MessageType.Success, MessageType.Warning,
         * MessageType.Error or MessageType.Information.
         */
        type: string;
      },
      /**
       * If switching between different table views is enabled, this parameter can be used to identify the views
       * which are affected by this call. Faulty values indicate that all views should be affected. Otherwise
       * the value should either be one string or an array of strings identifying the affected variant items.
       */
      vTabKey?: any[] | string,
      /**
       * A function that is called when the user closes the message bar. Note that the messages for all tabs specified
       * via `vTabKey` will be considered to be obsolete when the user closes the message bar while one of them
       * is active.
       */
      onClose?: Function
    ): void;
    /**
     * If multi view table is enabled, this function switches the table's view to given variant key.
     */
    setQuickVariantSelectionKey(
      /**
       * The table variant key to be selected.
       */
      sKey: string
    ): void;
  }
}

declare module "sap/suite/ui/generic/template/ListReport/extensionAPI/NonDraftTransactionController" {
  import BaseObject from "sap/ui/base/Object";

  import Context from "sap/ui/model/Context";

  import Metadata from "sap/ui/base/Metadata";

  export default class NonDraftTransactionController extends BaseObject {
    /**
     * Non draft transaction controller to be used in extensions of ListReport. Breakout coding can access an
     * instance of this class via `ExtensionAPI.getTransactionController`. Do not instantiate yourself.
     *
     * Note: Only one object can be edited at a given point in time.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.ListReport.extensionAPI.NonDraftTransactionController
     * with name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NonDraftTransactionController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.ListReport.extensionAPI.NonDraftTransactionController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Cancel editing
     */
    cancel(): void;
    /**
     * This method can be called when a new entry with predefined values should be created (e.g. in a copy scenario).
     *
     *
     * @returns a context representing the object to be created. It can be passed to {@link sap.suite.ui.generic.template.extensionAPI.NavigationController#navigateInternal }
     * in order to visit the corresponding object page.
     */
    createEntry(
      /**
       * an object containing predefined values for the new entity (see parameter `mParameters.properties` of
       * {@link sap.ui.model.odata.v2.ODataModel#createEntry} for details)
       */
      vPredefinedValues: undefined,
      /**
       * this parameter only needs to be used in multi entitySet scenarios, in order to specify another entity
       * set than the main entity set of the ListReport
       */
      sEntitySet?: string
    ): Context;
    /**
     * Start editing one list entry
     */
    edit(
      /**
       * the context identifying the entry to be edited
       */
      oContext: Context
    ): void;
    /**
     * Save the changes which have been applied to the OData model. Sets the application busy during execution
     * and doesn't execute if application is already busy when called (i.e. don't use `ExtensionAPI.securedExecution`
     * to call this method).
     *
     *
     * @returns is resolved when entry is successfully saved and rejected when saving fails
     */
    save(): Promise<any>;
  }
}

declare module "sap/suite/ui/generic/template/ObjectPage/controllerFrameworkExtensions" {
  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import Control from "sap/ui/core/Control";

  import Filter from "sap/ui/export/util/Filter";

  import Event from "sap/ui/base/Event";

  import Context from "sap/ui/model/Context";

  import ObjectPageSubSection from "sap/uxap/ObjectPageSubSection";

  /**
   * This class contains all extension functions that can be implemented by Application developers in their
   * extension code. Application developers should not override any methods outside this documentation.
   */
  interface controllerFrameworkExtensions {
    /**
     * This method is called by SAP Fiori elements before triggering an external navigation. Application developers
     * can override this method and programmatically adapt the parameters which are passed to the target application.
     * Application developers can use the oObjectInfo parameter to identify the navigation context and modify
     * the oSelectionVariant which contains the navigation parameters.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptNavigationParameterExtension(
      /**
       * Selection variant object containing the information which needs to be passed to the target application
       */
      oSelectionVariant: SelectionVariant,
      /**
       * Context object based on which the intent based navigation is triggered
       */
      oObjectInfo: {
        /**
         * Semantic object used for the intend based navigation
         */
        semanticObject: string;
        /**
         * Action on the context for which the navigation is triggered
         */
        action: string;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements whenever the busy state is switched off. Application developers
     * can override this method, access the message model and adapt the transient messages related to the component.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptTransientMessageExtension(): void;
    /**
     * This method will be called by SAP Fiori elements while applying the AppState. The custom state object
     * retrieved from the AppState will be passed as a parameter to this method. Application developers can
     * use this custom state for restoring the state of the custom control. To make a complete functionality,
     * this method should be overridden with `provideCustomStateExtension`.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/89fa878945294931b15a581a99043005 Custom State Handling for Extended Apps}
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    applyCustomStateExtension(
      /**
       * Custom data containing the information
       */
      oState: object,
      /**
       * Set to True if the method is called for the same instance **Note: ** In draft scenarios, this parameter
       * will be set to true if the instance that is currently displayed and the instance that was visited previously
       * are semantically same but differ in their draft status
       */
      bIsSameAsLast: boolean
    ): void;
    /**
     * This method is called by SAP Fiori element when Delete button on the Object Page is clicked. Application
     * developers can override this method & perform additional checks before executing the delete operation.
     * Method is expected to return a Promise. To veto the delete operation, promise needs to be rejected else
     * resolved.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Promise object created by the extension, used for delete operation chaining
     */
    beforeDeleteExtension(): Promise<any>;
    /**
     * This method is called when the Delete operation is triggered on a table in the Object Page. Application
     * developers can override this method & perform additional checks before executing the delete operation.
     * Method is expected to return a Promise. Delete operation is executed only once the returned promise is
     * resolved. In case the extension code wants to veto the Delete operation, promise needs to be rejected.
     * Application developers can use `sUiElementId` property of the object passed as param to identify the
     * smart table where the Delete operation is being triggered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Promise object created by the extension, used for Delete operation chaining
     */
    beforeLineItemDeleteExtension(
      /**
       * Object containing the selected context for delete
       */
      oBeforeLineItemDeleteProperties: {
        /**
         * Id of the smart table relevant for Delete operation
         */
        sUiElementId: string;
        /**
         * Array of the selected contexts
         */
        aContexts: any[];
      }
    ): Promise<any>;
    /**
     * This method is called by SAP Fiori elements when Save button is selected. Application developers can
     * override this method and perform a custom operation before executing the Save operation. The method is
     * expected to return a Promise. The save operation will be continued only once the promise is resolved.
     * If the extension code would like to veto the save operation, promise must be rejected. Note that this
     * function should **not** be used to implement any checks on the object to be saved, since all checks should
     * be implemented by the backend logic. However, the implementation may display user interaction (dialog)
     * requesting the user to enter additional data or confirmation. The returned Promise would be resolved
     * if the user confirms the dialog and rejected if it is canceled.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Promise object created by the extension, used for Save operation chaining
     */
    beforeSaveExtension(): Promise<any>;
    /**
     * This method is called by SAP Fiori elements when a smart link in a table or form is clicked. Application
     * developers can override this method and invoke the oParams.getSourceInfo method to find out the information
     * about the clicked smart link.
     *
     * If the application expect the framework should not handle the `beforePopoverOpens` event, then this method
     * should return true. Otherwise, framework will proceed with its handling.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Method should return `true` if framework should not handle `beforePopoverOpens` event (that
     * means: extension code will handle the event)
     */
    beforeSmartLinkPopoverOpensExtension(
      /**
       * Object containing the "getSourceInfo" method and the selection variant
       */
      oParams: {
        /**
         * Selection variant object containing the information which needs to be passed to the target application
         */
        oSelectionVariant: SelectionVariant;
        /**
         * Returns an object contains information about the smart link
         */
        getSourceInfo?: Function;
      }
    ): boolean;
    /**
     * Extension point for the application to specify the control to focus on in the object page upon edit.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - The control that needs to be focused.
     *
     * The returned control must meet the following criteria: - Be focusable and have a "focus" property. -
     * Be visible within the viewport.
     *
     * If the returned control does not satisfy these conditions, the standard focus handling logic is executed.
     */
    focusOnEditExtension(
      /**
       * The ID of the selected section.
       */
      sSelectedSection: String
    ): Control;
    /**
     * This method is called by SAP Fiori elements when the table data is getting exported. Application developers
     * can override this method to add/remove the filters in the exported file.
     *
     * To add new filter entries to the exported file, create an instance of {@link sap.ui.export.util.Filter }
     * and add it to "oExportParams.filterSettings"
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeExportTableExtension(
      /**
       * Object containing the table export info
       */
      oExportParams: {
        /**
         * The filters in the exported file Note: Please make changes on "oExportParams.filterSettings" array only
         * when "Include filter settings" is selected. Otherwise, the changes will be ignored.
         */
        filterSettings: Filter[];
        /**
         * The value of "Include filter settings" checkbox
         */
        includeFilterSettings: boolean;
      }
    ): void;
    /**
     * This method is called by SAP Fiori elements before binding a table. Application developers can override
     * this method and programmatically modify parameters or filters before the table triggers a query to retrieve
     * data. Source property of the oEvent shall be used to determine table triggering the event
     *
     * **Note: **This method is called only when a table is rebound, and not when it is refreshed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRebindTableExtension(
      /**
       * The {@link sap.ui.comp.smarttable.SmartTable.prototype.event:beforeRebindTable beforeRebindTable} event
       */
      oEvent: Event
    ): void;
    /**
     * This method should be implemented whenever application uses onListNavigationExtension for internal navigation.
     * In this case the implementation of this method should provide an 'inverse' mapping to the transformation
     * implemented within onListNavigationExtension. More precisely, the identification of a child page instance
     * is passed to this function. The implementation of this function should provide information about the
     * list item which has triggered the opening of the child page.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onChildOpenedExtension(
      /**
       * Information about the child page instance opened last
       */
      oSelectionInfo: {
        /**
         * The entity set identifying the child page which was opened last. Note: In case the child page has been
         * defined without reference to OData this will be the routeName taken from the routingSpec.
         */
        pageEntitySet?: string;
        /**
         * The context path that was used for the last opened child page
         */
        path?: string;
        /**
         * The array of keys (one on each hierarchy level) used for the last opened child page
         */
        keys?: string[];
      },
      /**
       * pass the binding path of the corresponding list item to this function if it is not identical to `oSelectionInfo.path`
       */
      fnSetPath: Function
    ): void;
    /**
     * This method is called by SAP Fiori elements on the initialization of View. Application developers can
     * override this method & perform internal setup in this hook.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onInit(): void;
    /**
     * This method is called when the user leaves the app and this page has been displayed within the same app
     * session (this is the time since last opening the app) at least once. Moreover, it is called for all pages
     * that have been displayed within some app session when the app is finally destroyed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns - Only relevant in case that `bIsDestroyed` is false. In this case Application developers can
     * provide a function to be called when the same page is opened again (after the user has navigated back
     * to the app).
     */
    onLeaveAppExtension(
      /**
       * If this parameter is true this app instance is destroyed. Otherwise it might be rewoken if the user navigates
       * again to this app within the same FLP session
       */
      bIsDestroyed: boolean
    ): Function;
    /**
     * This method is called by SAP Fiori elements when a chevron navigation is triggered from a table. Application
     * developers can override this method and perform conditional (internal or external) navigation from different
     * rows of a table. Such custom navigation should be triggered via corresponding methods of {@link sap.suite.ui.generic.template.extensionAPI.NavigationController NavigationController}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Method should return `true` if framework navigation should be suppressed (that means: extension
     * code has taken over navigation)
     */
    onListNavigationExtension(
      /**
       * The press event fired when navigating from a row in the SmartTable. It is recommended to ignore this
       * parameter and use `oBindingContext` instead
       */
      oEvent: Event,
      /**
       * The context of the corresponding table row
       */
      oBindingContext: Context,
      /**
       * This parameter should be considered if the method triggers an internal navigation. Pass this parameter
       * to `oNavigationData.replaceInHistory` in this case
       */
      bReplaceInHistory: boolean
    ): boolean;
    /**
     * This method is called by SAP Fiori elements when the Share functionality is triggered. Application developers
     * can adapt the service URL passed as a parameter to this method. Adapted service URL will be used in the
     * 'Send Email' or 'Save as Tile' options.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onSaveAsTileExtension(
      /**
       * Object containing the serviceURL
       */
      oShareInfo: {
        /**
         * Service URL which is derived by SAP Fiori elements
         */
        serviceUrl: string;
      }
    ): void;
    /**
     * This method is called when the SubSection enters the Viewport first time for an ObjectPage. Method would
     * be called again for the same SubSection only in case ObjectPage binding context is changed. Application
     * developers could use this method to perform specific actions on the current SubSection children. This
     * enables the application to perform actions relevant to a specific section when it really comes to view
     * port. Control specific handling should be done in this method in case View LazyLoading is enabled.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onSubSectionEnteredExtension(
      /**
       * Reference to the ObjectPageSubSection cause for this method call
       */
      oSubSection: ObjectPageSubSection
    ): void;
    /**
     * This method will be called by SAP Fiori elements before persisting the AppState. Application developers
     * can override this method for persisting the state of custom controls. State of the custom controls should
     * be stored in the oState object passed as a parameter to this method. To make a complete functionality,
     * this method should be overridden with `applyCustomStateExtension`.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/89fa878945294931b15a581a99043005 Custom State Handling for Extended Apps}
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    provideCustomStateExtension(
      /**
       * Object which needs to enriched with the custom control state
       */
      oState: object
    ): void;
  }
  const controllerFrameworkExtensions: controllerFrameworkExtensions;
  export default controllerFrameworkExtensions;
}

declare module "sap/suite/ui/generic/template/ObjectPage/extensionAPI/DraftTransactionController" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  export default class DraftTransactionController extends BaseObject {
    /**
     * Draft transaction controller to be used in extensions of ObjectPage. Breakout coding can access an instance
     * of this class via `ExtensionAPI.getTransactionController`. Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.ObjectPage.extensionAPI.DraftTransactionController
     * with name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DraftTransactionController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.ObjectPage.extensionAPI.DraftTransactionController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attach a handler to the activate event
     */
    attachAfterActivate(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Attach a handler to the discard event
     */
    attachAfterCancel(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Attach a handler to the delete event
     */
    attachAfterDelete(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Attach a handler to the line item delete event (for smart tables in object page)
     */
    attachAfterLineItemDelete(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Detach a handler from the activate event
     */
    detachAfterActivate(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Detach a handler from the discard event
     */
    detachAfterCancel(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Detach a handler from the delete event
     */
    detachAfterDelete(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Cancels the draft. Note that this method only works when you are on the root of a draft. The normal navigation
     * which follows the cancellation of a draft is executed. Moreover, note that executing this method will
     * set the App to be busy. However, it does not ensure, that the method is only called, when the App is
     * currently unbusy. If you want to ensure that, you have to use {@link sap.suite.ui.generic.template.ObjectPage.extensionAPI.ExtensionAPI#securedExecution}.
     *
     *
     * @returns A promise that is resolved when the draft is cancelled, rejected when it is not possible.
     */
    discardDraft(): Promise<void>;
    /**
     * Checks if side effects exist for the given properties or entities and executes them. If there are pending
     * changes in the model, those pending changes are sent as a patch request with the side effect batch request.
     * If no source property and no source entity is passed, a global side effect is executed.
     */
    executeSideEffects(
      /**
       * Object containing any of the following properties:
       */
      oSideEffects?: {
        /**
         * Array with property paths
         */
        sourceProperties: any[];
        /**
         * Array with navigation property paths
         */
        sourceEntities: any[];
      }
    ): void;
    /**
     * Perform a draft saving operation. This method only needs to be used, when more than one OData model is
     * used to handle the data for the current draft. Using more than one OData models is only sensible, when
     * more than one OData service is being used to store the data for the object. The Fiori Elements framework
     * cares for all changes being applied to the standard OData model (even if they are applied within breakouts).
     * However, if additional OData models are in place the breakout implementation which has introduced these
     * models also needs to take care for saving the data in these models as soon as possible.
     *  In these rare cases this method should be used to intergate the saving operation into the general draft
     * saving process.
     *  Note that this method may be enhanced in the future in order to introduce a better error handling.
     */
    saveDraft(
      /**
       * function that saves the draft in the additional OData model(s). This method must return a Promise that
       * is resolved, when the draft saving is finished successfully. Otherwise the Promise should be rejected.
       */
      fnFunction: Function
    ): void;
  }
}

declare module "sap/suite/ui/generic/template/ObjectPage/extensionAPI/ExtensionAPI" {
  import BaseObject from "sap/ui/base/Object";

  import Control from "sap/ui/core/Control";

  import Metadata from "sap/ui/base/Metadata";

  import NavigationController from "sap/suite/ui/generic/template/extensionAPI/NavigationController";

  import Context from "sap/ui/model/Context";

  import DraftTransactionController from "sap/suite/ui/generic/template/ObjectPage/extensionAPI/DraftTransactionController";

  import NonDraftTransactionController from "sap/suite/ui/generic/template/ObjectPage/extensionAPI/NonDraftTransactionController";

  export default class ExtensionAPI extends BaseObject {
    /**
     * API to be used in extensions of ObjectPage. Breakout coding can access an instance of this class via
     * `this.extensionAPI`. Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.ObjectPage.extensionAPI.ExtensionAPI with
     * name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExtensionAPI>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.ObjectPage.extensionAPI.ExtensionAPI.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attach a handler to the PageDataLoaded event. This event is fired each time the object page is navigated
     * to or the object to be displayed is changed Note, that the event will not be fired before:
     * the navigation to the page has been completed the header data of the object are available
     */
    attachPageDataLoaded(
      /**
       * the handler function. Note that the event passed to this function possesses an attribute `context` which
       * contains the current header context
       */
      fnFunction: Function
    ): void;
    /**
     * Attaches a control to the current View. Should be called whenever a new control is created and used in
     * the context of this view. This applies especially for dialogs, action sheets, popovers, ... This method
     * cares for defining dependency and handling device specific style classes
     */
    attachToView(
      /**
       * the control to be attached to the view
       */
      oControl: Control
    ): void;
    /**
     * Detach a handler from the PageDataLoaded event
     */
    detachPageDataLoaded(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Returns the global communication object for storing and accessing custom state information within the
     * current app. This object can be used across components to share state information.
     *
     *
     * @returns The communication object.
     */
    getCommunicationObject(): object;
    /**
     * Get the navigation controller for navigation actions
     *
     *
     * @returns the navigation controller
     */
    getNavigationController(): NavigationController;
    /**
     * Returns the currently selected variant key on the table in the given object page section.
     *
     *
     * @returns The currently selected variant key on the table.
     */
    getQuickVariantSelectionKey(
      /**
       * The object page section id in which the table is present.
       */
      sSectionKey: string
    ): string;
    /**
     * Generally, this method returns the currently selected contexts in one ui element (table, chart, or list).
     * In case the context menu is opened, it returns the contexts applicable to the context menu.
     *
     *
     * @returns contains one entry per entry selected
     */
    getSelectedContexts(
      /**
       * the id identifying the ui element the selected context is requested for
       */
      sUiElementId: string
    ): Context[];
    /**
     * Get the transaction controller for editing actions on the page. Note that the methods provided by this
     * transaction controller depend on whether the object supports drafts or not.
     *
     *
     * @returns the transaction controller
     */
    getTransactionController():
      | DraftTransactionController
      | NonDraftTransactionController;
    /**
     * Get the id of the view this extension api belongs to
     *
     *
     * @returns the view id
     */
    getViewId(): string;
    /**
     * Invokes multiple time the action with the given name and submits changes to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the action, resolving to the same result as the `Promise`
     * returned from {@link sap.ui.generic.app.ApplicationController#invokeActions}
     */
    invokeActions(
      /**
       * The name of the function or action as expected by {@link sap.ui.model.odata.v2.ODataModel#callFunction}
       */
      sFunctionName: string,
      /**
       * The binding context(s) the function will be called for. To be omitted if the action is static.
       */
      vContext?: Context[] | Context,
      /**
       * The URL parameters (name-value pairs) for the function or action. Only needed in special cases.
       */
      mUrlParameters?: Record<string, any>,
      /**
       * Additional settings
       */
      oSettings?: {
        /**
         * Determines whether the common or unique changeset gets sent in batch
         */
        bInvocationGroupingChangeSet?: boolean;
      }
    ): Promise<any>;
    /**
     * Call this method to indicate that the state of custom controls has changed. This is only necessary when
     * methods `provideCustomStateExtension` and `applyCustomStateExtension` have been overridden, such that
     * the corresponding state can be stored and restored.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/89fa878945294931b15a581a99043005 Custom State Handling for Extended Apps}
     *
     *
     * @returns A `Promise` that is resolved when the changed state is transferred to the URL and the corresponding
     * busy session is ended.
     */
    onCustomStateChange(): Promise<any>;
    /**
     * Rebinds the given SmartTable
     */
    rebind(
      /**
       * the id identifying the control to refresh the binding
       */
      sUiElementId: string
    ): void;
    /**
     * Refreshes the specified control from the backend (currently only supported for tables) or the whole page.
     * Note that this function must not be called on non-draft pages while they are in edit mode.
     */
    refresh(
      /**
       * the id identifying the control that should be refreshed. If the parameter is faulty the whole page is
       * refreshed.
       */
      sUiElementId: string
    ): void;
    /**
     * Allow parent components to be refreshed on next activation
     */
    refreshAncestors(
      /**
       * Number of parent components to be refreshed 1 - Refresh the immediate parent component Undefined or faulty
       * - Refresh all parent components
       */
      iLevel: int
    ): void;
    /**
     * Registers a filter provider for the the message popover
     */
    registerMessageFilterProvider(
      /**
       * function which will be called each time a new context is set for the object page. The function should
       * return an instance of sap.ui.model.Filter, an array of sap.ui.model.Filter or a Promise which resolves
       * to one of these.
       */
      fnProviderCallback: Function
    ): void;
    /**
     * Secured execution of the given function. Ensures that the function is only executed when certain conditions
     * are fulfilled.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/6a39150ad3e548a8b5304d32d560790a Using the SecuredExecutionMethod}
     *
     *
     * @returns A `Promise` that is rejected, if execution is prohibited, and settled equivalent to the one
     * returned by fnFunction.
     */
    securedExecution(
      /**
       * The function to be executed. Should return a promise that is settled after completion of the execution.
       * If nothing is returned, immediate completion is assumed.
       */
      fnFunction: Function,
      /**
       * Parameters to define the preconditions to be checked before execution
       */
      mParameters?: {
        /**
         * Parameters regarding busy indication
         */
        busy?: {
          /**
           * Triggers a busy indication during function execution. Can be set to false in case of immediate completion.
           */
          set?: boolean;
          /**
           * Checks whether the application is currently busy. Function is only executed if not. Has to be set to
           * false, if function is not triggered by direct user interaction, but as result of another function, that
           * set the application busy.
           */
          check?: boolean;
        };
        /**
         * Parameters regarding dataloss prevention
         */
        dataloss?: {
          /**
           * Provides a dataloss popup before execution of the function if needed (i.e. in non-draft case when model
           * or registered methods contain pending changes).
           */
          popup?: boolean;
          /**
           * Indicates that execution of the function leads to a navigation, i.e. leaves the current page, which induces
           * a slightly different text for the dataloss popup.
           */
          navigation?: boolean;
        };
        /**
         * Tells the framework that objects will be deleted by `fnFunction`. Use the BindingContextPath as a key
         * for the map. Fill the map with a `Promise` for each object which is to be deleted. The `Promise` must
         * resolve after the deletion of the corresponding object or reject if the deletion is not successful.
         */
        mConsiderObjectsAsDeleted?: Record<string, any>;
        /**
         * In case of custom actions, the title of the message popup is set to sActionLabel.
         */
        sActionLabel?: string;
      }
    ): Promise<any>;
    /**
     * Defines a control to be the **title owner** for its subsection. As the title owners of standard subsections
     * are determined automatically it is recommended to use this function for custom subsections and embedded
     * components only. The title owner should be a control possessing properties header and headerLevel
     * and headerStyle (like {@link sap.ui.comp.smarttable.SmartTable} and {@link sap.ui.comp.smartchart.SmartChart})
     * or text and level and titleStyle (like {@link sap.m.Title}). The framework will
     * adapt the values of these properties to be aligned with the title which is shown in the anchor bar (or
     * icon tab bar) for the subsection. Moreover, the title of the subsection (and if applicable also of the
     * section) will be hidden in order to prevent redundant titles if the subsection possesses a title owner.
     *  Note that this method should only be used in case that there exists one single suitable control which
     * represents the complete content of the subsection or embedded component.
     */
    setAsTitleOwner(
      /**
       * title owner of the subsection containing this control. The control must possess properties header
       * and headerLevel and headerStyle or text and level and titleStyle.
       * As a special case you can also pass a subsection itself which would remove a potential title owner from
       * this subsection.
       */
      the: Control
    ): void;
    /**
     * Provide an option for showing an own message in the message bar above an OP table or page header.
     *
     * If you want to display message on page header then you should pass `oMessage` only keeping all other
     * parameter as empty Note - Message bar on Page header will be shown only in display mode for dynamic header
     */
    setCustomMessage(
      /**
       * custom message along with type to set on table. If this parameter is faulty an existing message will
       * be removed.
       */
      oMessage?: {
        /**
         * message string to display
         */
        message: string;
        /**
         * indicates type of message (sap/ui/core/message/MessageType) whether it's MessageType.Success, MessageType.Warning,
         * MessageType.Error or MessageType.Information.
         */
        type: string;
      },
      /**
       * Id of the table for which message should be set.
       */
      sSmartTableId?: string,
      /**
       * If switching between different table views is enabled, this parameter can be used to identify the views
       * which are affected by this call. Faulty values indicate that all views should be affected. Otherwise
       * the value should either be one string or an array of strings identifying the affected variant items.
       */
      vTabKey?: any[] | string,
      /**
       * A function that is called when the user closes the message bar. Note that the messages for all tabs specified
       * via `vTabKey` will be considered to be obsolete when the user closes the message bar while one of them
       * is active.
       */
      onClose?: Function
    ): void;
    /**
     * Switches the table's view to the given variant key.
     */
    setQuickVariantSelectionKey(
      /**
       * The object page section id in which the table is present.
       */
      sSectionKey: string,
      /**
       * The table variant key to be selected.
       */
      sVariantKey: string
    ): void;
  }
}

declare module "sap/suite/ui/generic/template/ObjectPage/extensionAPI/NonDraftTransactionController" {
  import BaseObject from "sap/ui/base/Object";

  import Context from "sap/ui/model/Context";

  import Metadata from "sap/ui/base/Metadata";

  export default class NonDraftTransactionController extends BaseObject {
    /**
     * Non Draft transaction controller to be used in extensions of ObjectPage. Breakout coding can access an
     * instance of this class via `ExtensionAPI.getTransactionController`. Do not instantiate yourself.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.generic.template.ObjectPage.extensionAPI.NonDraftTransactionController
     * with name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NonDraftTransactionController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.generic.template.ObjectPage.extensionAPI.NonDraftTransactionController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attach a handler to the cancel event
     */
    attachAfterCancel(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Attach a handler to the delete event
     */
    attachAfterDelete(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Attach a handler to the line item delete event (for smart tables in object page)
     */
    attachAfterLineItemDelete(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Attach a handler to the save event
     */
    attachAfterSave(
      /**
       * the handler function This function will receive an object which contains two properties: `saveEntityPromise`
       * and `sideEffectsExecutedPromise` which both point to Promises. Both Promises will be rejected in case
       * the save operation fails in the backend. Otherwise both Promises will be resolved, but at different point
       * in time. The `saveEntityPromise` will be resolved immediately when the save operation has finished successfully.
       * The `sideEffectsExecutedPromise` will be resolved as soon as the processing of all side-effects connected
       * to this action has finished as well. Note that even a side-effect execution which results in an error
       * would be considered as finished processing here.
       */
      fnFunction: Function
    ): void;
    /**
     * This method can be called when a new entry with predefined values should be created (e.g. in a copy scenario).
     *
     *
     * @returns a context representing the object to be created. It can be passed to {@link sap.suite.ui.generic.template.extensionAPI.NavigationController#navigateInternal }
     * in order to visit the corresponding object page.
     */
    createEntry(
      /**
       * an object containing predefined values for the new entity (see parameter `mParameters.properties` of
       * {@link sap.ui.model.odata.v2.ODataModel#createEntry} for details)
       */
      vPredefinedValues: undefined
    ): Context;
    /**
     * Detach a handler from the cancel event
     */
    detachAfterCancel(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Detach a handler from the delete event
     */
    detachAfterDelete(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Detach a handler from the save event
     */
    detachAfterSave(
      /**
       * the handler function
       */
      fnFunction: Function
    ): void;
    /**
     * Registers a function that provides information whether there are unsaved custom data
     *
     * This method must be used when an extension ui may contain user input that is **not** bound to the standard
     * OData model of the app. In this case a function must be provided that returns the information whether
     * the extension ui still contains unsaved user changes.
     */
    registerUnsavedDataCheckFunction(
      /**
       * Callback function returning either true or false
       */
      fnHasUnsavedData: Function
    ): void;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/suite/ui/generic/template/AnalyticalListPage/controllerFrameworkExtensions": undefined;

    "sap/suite/ui/generic/template/AnalyticalListPage/extensionAPI/ExtensionAPI": undefined;

    "sap/suite/ui/generic/template/Canvas/extensionAPI/ExtensionAPI": undefined;

    "sap/suite/ui/generic/template/extensionAPI/extensionAPI": undefined;

    "sap/suite/ui/generic/template/extensionAPI/NavigationController": undefined;

    "sap/suite/ui/generic/template/extensionAPI/ReuseComponentSupport": undefined;

    "sap/suite/ui/generic/template/lib/AppComponent": undefined;

    "sap/suite/ui/generic/template/library": undefined;

    "sap/suite/ui/generic/template/ListReport/controllerFrameworkExtensions": undefined;

    "sap/suite/ui/generic/template/ListReport/extensionAPI/ExtensionAPI": undefined;

    "sap/suite/ui/generic/template/ListReport/extensionAPI/NonDraftTransactionController": undefined;

    "sap/suite/ui/generic/template/ObjectPage/controllerFrameworkExtensions": undefined;

    "sap/suite/ui/generic/template/ObjectPage/extensionAPI/DraftTransactionController": undefined;

    "sap/suite/ui/generic/template/ObjectPage/extensionAPI/ExtensionAPI": undefined;

    "sap/suite/ui/generic/template/ObjectPage/extensionAPI/NonDraftTransactionController": undefined;
  }
}
