export declare enum ChangeAction {
    INSERT = "insert",
    REPLACE = "replace",
    DELETE = "delete"
}
export type ChangeSet = InsertChange | ReplaceChange | DeleteChange;
export interface AbstractChangeSet {
    action: ChangeAction;
    start: number;
}
export interface InsertChange extends AbstractChangeSet {
    action: ChangeAction.INSERT;
    value: string;
}
export interface ReplaceChange extends AbstractChangeSet {
    action: ChangeAction.REPLACE;
    end: number;
    value: string;
}
export interface DeleteChange extends AbstractChangeSet {
    action: ChangeAction.DELETE;
    end: number;
}
/**
 * Applies a set of changes to a string content.
 * Changes are applied in reverse order (by start position) to ensure that
 * positions remain valid as modifications are made.
 *
 * @param content The original string content to modify
 * @param changeSet Array of changes to apply
 * @returns The modified string content
 */
export declare function applyChanges(content: string, changeSet: ChangeSet[]): string;
