import { encode } from "@jridgewell/sourcemap-codec";
const NL = "\n";
export default class Writer {
    #buf = "";
    // #map: GenMapping;
    #mappings = new Set();
    lineOffset = 0;
    columnOffset = 0;
    #sourceName;
    #targetName;
    constructor(targetName, sourceName) {
        // this.#map = new GenMapping({
        // 	file: targetName,
        // });
        this.#targetName = targetName;
        this.#sourceName = sourceName;
    }
    write(str, start, end) {
        if (str === null || str === "") {
            return;
        }
        if (start) {
            this.#addMapping(start);
        }
        const strSplit = str.split(NL);
        this.lineOffset += strSplit.length - 1;
        this.columnOffset += strSplit[strSplit.length - 1].length;
        this.#buf += str;
        if (end) {
            this.#addMapping(end);
        }
    }
    writeln(str, start, end) {
        this.write(str, start, end);
        this.#buf += NL;
        this.lineOffset += 1;
        this.columnOffset = 0;
    }
    // ln version only so we don't need to worry about the column offset
    prependln(str, start, end) {
        const strSplit = str.split(NL);
        const lineOffset = strSplit.length - 1;
        const columnOffset = strSplit[strSplit.length - 1].length;
        this.#shiftMappings(lineOffset + 1); // Adding one for the additional new line we'll be adding
        if (start) {
            this.#addMapping(start, {
                line: 0,
                column: 0,
            });
        }
        this.lineOffset += lineOffset + 1; // Adding one for the additional new line
        this.#buf = str + NL + this.#buf;
        if (end) {
            this.#addMapping(end, {
                line: lineOffset,
                column: columnOffset,
            });
        }
    }
    getString() {
        return this.#buf;
    }
    /**
     * Generate the final source map for the generated code.
     *
     * Important notes:
     * * Default aggregations will be mapped to the control that started it
     */
    getSourceMap() {
        const mappings = [];
        this.#mappings.forEach((mapping) => {
            let missingLineMappings = mapping.generated.line - mappings.length + 1;
            if (missingLineMappings > 0) {
                while (missingLineMappings--) {
                    mappings.push([]);
                }
            }
            // [generatedColumn, sourceIndex, sourceLine, sourceColumn, nameIndex]
            const segment = [
                mapping.generated.column,
                0,
                mapping.original.line,
                mapping.original.column,
            ];
            mappings[mapping.generated.line].push(segment);
        });
        return {
            version: 3,
            names: [],
            file: this.#targetName,
            sources: [this.#sourceName],
            mappings: encode(mappings),
        };
    }
    getLength() {
        return this.#buf.length;
    }
    #addMapping(sourcePos, targetPos) {
        this.#mappings.add({
            generated: targetPos ?? {
                line: this.lineOffset,
                column: this.columnOffset,
            },
            original: sourcePos,
        });
    }
    #shiftMappings(offset) {
        // Add offset to all mappings
        this.#mappings.forEach((mapping) => {
            mapping.generated.line += offset;
        });
    }
}
//# sourceMappingURL=Writer.js.map